; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -march=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -global-isel -march=amdgcn -mcpu=tonga -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s

define float @v_mul_legacy_f32(float %a, float %b) {
; GCN-LABEL: v_mul_legacy_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float %a, float %b)
  ret float %result
}

define float @v_mul_legacy_undef0_f32(float %a) {
; GCN-LABEL: v_mul_legacy_undef0_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, s4, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float undef, float %a)
  ret float %result
}

define float @v_mul_legacy_undef1_f32(float %a) {
; GCN-LABEL: v_mul_legacy_undef1_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, s4, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float %a, float undef)
  ret float %result
}

define float @v_mul_legacy_undef_f32() {
; GCN-LABEL: v_mul_legacy_undef_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e64 v0, s4, s4
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float undef, float undef)
  ret float %result
}

define float @v_mul_legacy_fabs_f32(float %a, float %b) {
; GCN-LABEL: v_mul_legacy_fabs_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e64 v0, |v0|, |v1|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %a.fabs = call float @llvm.fabs.f32(float %a)
  %b.fabs = call float @llvm.fabs.f32(float %b)
  %result = call float @llvm.amdgcn.fmul.legacy(float %a.fabs, float %b.fabs)
  ret float %result
}

define float @v_mul_legacy_fneg_f32(float %a, float %b) {
; GCN-LABEL: v_mul_legacy_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e64 v0, -v0, -v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %a.fabs = fneg float %a
  %b.fabs = fneg float %b
  %result = call float @llvm.amdgcn.fmul.legacy(float %a.fabs, float %b.fabs)
  ret float %result
}

; TODO: Should match mac_legacy/mad_legacy
define float @v_mad_legacy_f32(float %a, float %b, float %c) {
; GCN-LABEL: v_mad_legacy_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_add_f32_e32 v0, v0, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = call float @llvm.amdgcn.fmul.legacy(float %a, float %b)
  %add = fadd float %mul, %c
  ret float %add
}

define amdgpu_ps float @s_mul_legacy_f32(float inreg %a, float inreg %b) {
; GCN-LABEL: s_mul_legacy_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, s0, v0
; GCN-NEXT:    ; return to shader part epilog
  %result = call float @llvm.amdgcn.fmul.legacy(float %a, float %b)
  ret float %result
}

define float @v_mul_legacy_f32_1.0(float %a) {
; GCN-LABEL: v_mul_legacy_f32_1.0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, 1.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float %a, float 1.0)
  ret float %result
}

define float @v_mul_legacy_f32_1.0_swap(float %b) {
; GCN-LABEL: v_mul_legacy_f32_1.0_swap:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, 1.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float 1.0, float %b)
  ret float %result
}

define float @v_mul_legacy_f32_2.0(float %a) {
; GCN-LABEL: v_mul_legacy_f32_2.0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, 2.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float %a, float 2.0)
  ret float %result
}

define float @v_mul_legacy_f32_2.0_swap(float %b) {
; GCN-LABEL: v_mul_legacy_f32_2.0_swap:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, 2.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.fmul.legacy(float 2.0, float %b)
  ret float %result
}

declare float @llvm.fabs.f32(float) #0
declare float @llvm.amdgcn.fmul.legacy(float, float) #1

attributes #0 = { nounwind readnone speculatable willreturn }
attributes #1 = { nounwind readnone speculatable }
