/*
 * Copyright (c) 2007 - 2015 Joseph Gaeddert
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

//
// fftfilt_crcf_data_h23x256.c: autotest fftfilt data
//

#include <complex.h>

float fftfilt_crcf_data_h23x256_h[] = {
    0.175772392750,
    0.016595666111,
   -0.074416112900,
    0.010717856884,
   -0.091077792645,
    0.152976071835,
   -0.025270926952,
    0.021845243871,
   -0.001858575456,
   -0.090402913094,
   -0.054905104637,
    0.135398101807,
   -0.000730551640,
    0.029069179296,
   -0.117681956291,
    0.088986778259,
   -0.005193765089,
    0.047553667426,
   -0.093419462442,
    0.060808116198,
    0.138476681709,
    0.104599690437,
    0.007943090051};

float complex fftfilt_crcf_data_h23x256_x[] = {
    0.155103063583 +  -0.039989483356*_Complex_I,
    0.089731889963 +   0.007783630490*_Complex_I,
    0.031814819574 +  -0.092475223541*_Complex_I,
   -0.052295821905 +   0.059911632538*_Complex_I,
   -0.128601908684 +  -0.137423527241*_Complex_I,
   -0.005442334712 +   0.136688292027*_Complex_I,
   -0.110040140152 +   0.129731595516*_Complex_I,
    0.070668441057 +   0.014537031949*_Complex_I,
   -0.043719315529 +  -0.018183282018*_Complex_I,
   -0.023593281209 +  -0.088085335493*_Complex_I,
    0.079267203808 +  -0.050603461266*_Complex_I,
    0.091274780035 +  -0.041612377763*_Complex_I,
   -0.063425219059 +   0.028925007582*_Complex_I,
    0.029070848227 +  -0.047291010618*_Complex_I,
   -0.016231997311 +  -0.220043921471*_Complex_I,
    0.001723764278 +  -0.110049223900*_Complex_I,
    0.044714280963 +  -0.016450446844*_Complex_I,
   -0.050305968523 +   0.038971278071*_Complex_I,
   -0.118738901615 +  -0.027668058872*_Complex_I,
   -0.065542882681 +  -0.056009286642*_Complex_I,
    0.087729597092 +  -0.011164753139*_Complex_I,
    0.078783208132 +  -0.036137032509*_Complex_I,
   -0.024815648794 +  -0.187882483006*_Complex_I,
    0.157861471176 +  -0.075281244516*_Complex_I,
    0.002852580696 +  -0.062035644054*_Complex_I,
    0.010516438633 +   0.137531483173*_Complex_I,
    0.028980562091 +  -0.067520070076*_Complex_I,
    0.022702263296 +   0.036881408095*_Complex_I,
   -0.072563153505 +  -0.135415744781*_Complex_I,
   -0.130733311176 +  -0.031472635269*_Complex_I,
   -0.132395064831 +  -0.013236595690*_Complex_I,
   -0.050313913822 +  -0.001110552903*_Complex_I,
   -0.182336819172 +   0.011559166759*_Complex_I,
    0.034110882878 +  -0.085457748175*_Complex_I,
    0.010640498996 +   0.024029432237*_Complex_I,
   -0.031135216355 +  -0.075218772888*_Complex_I,
   -0.113621425629 +  -0.020260357857*_Complex_I,
    0.035748475790 +  -0.047527408600*_Complex_I,
    0.158889925480 +  -0.108263909817*_Complex_I,
    0.058575540781 +   0.029335317016*_Complex_I,
   -0.012806682289 +   0.062627220154*_Complex_I,
    0.017389293015 +   0.082187730074*_Complex_I,
   -0.155518913269 +  -0.130875742435*_Complex_I,
   -0.110213851929 +   0.189839553833*_Complex_I,
    0.052800035477 +   0.166894078255*_Complex_I,
   -0.017228771746 +   0.002264509723*_Complex_I,
    0.126624763012 +   0.014616450667*_Complex_I,
    0.074029338360 +   0.130479073524*_Complex_I,
    0.039149993658 +  -0.081848907471*_Complex_I,
   -0.174016666412 +  -0.002245875075*_Complex_I,
   -0.060786378384 +   0.087645614147*_Complex_I,
    0.057222455740 +  -0.064347177744*_Complex_I,
   -0.158683681488 +   0.064550727606*_Complex_I,
    0.058903807402 +  -0.197414779663*_Complex_I,
    0.022170741856 +   0.005642867088*_Complex_I,
   -0.019022856653 +   0.026909428835*_Complex_I,
    0.054943174124 +  -0.010510860384*_Complex_I,
   -0.130231952667 +  -0.085019159317*_Complex_I,
    0.057500022650 +  -0.036732053757*_Complex_I,
    0.105791926384 +   0.016274939477*_Complex_I,
    0.116283416748 +  -0.056632959843*_Complex_I,
    0.009825258702 +   0.019144052267*_Complex_I,
    0.196307218075 +  -0.048692828417*_Complex_I,
    0.010651530325 +   0.008062589169*_Complex_I,
    0.064581054449 +  -0.010377624631*_Complex_I,
    0.089088356495 +   0.044110041857*_Complex_I,
   -0.000476853596 +  -0.038994494081*_Complex_I,
    0.105319905281 +  -0.132293283939*_Complex_I,
    0.009918146580 +  -0.041363826394*_Complex_I,
    0.036220628023 +  -0.030043822527*_Complex_I,
    0.025852039456 +   0.067388910055*_Complex_I,
   -0.083622449636 +  -0.035971945524*_Complex_I,
   -0.100427985191 +   0.044513091445*_Complex_I,
   -0.185684227943 +  -0.040250685811*_Complex_I,
   -0.117641401291 +  -0.084515213966*_Complex_I,
    0.041368806362 +   0.039818888903*_Complex_I,
   -0.237114048004 +   0.125617718697*_Complex_I,
   -0.054697531462 +   0.033353772759*_Complex_I,
   -0.074546104670 +  -0.125889337063*_Complex_I,
    0.033940449357 +   0.015348845720*_Complex_I,
   -0.045566964149 +   0.039473927021*_Complex_I,
   -0.015814815462 +  -0.096754157543*_Complex_I,
    0.140625333786 +   0.088005954027*_Complex_I,
   -0.109252071381 +  -0.058004480600*_Complex_I,
    0.006840997189 +   0.123340046406*_Complex_I,
   -0.043643641472 +   0.077158600092*_Complex_I,
   -0.073954302073 +   0.095201927423*_Complex_I,
   -0.024249210954 +   0.057317435741*_Complex_I,
    0.018241013587 +   0.081239950657*_Complex_I,
   -0.091524779797 +  -0.259817528725*_Complex_I,
   -0.026682430506 +  -0.034324991703*_Complex_I,
    0.088583648205 +  -0.007783739269*_Complex_I,
    0.183037674427 +   0.111340200901*_Complex_I,
   -0.076495563984 +  -0.089935213327*_Complex_I,
    0.016016796231 +   0.185418581963*_Complex_I,
    0.090234714746 +  -0.036095014215*_Complex_I,
    0.016144131124 +   0.097066044807*_Complex_I,
    0.012245001644 +   0.095291149616*_Complex_I,
   -0.161877584457 +  -0.052310425043*_Complex_I,
   -0.033721217513 +  -0.012814992666*_Complex_I,
    0.091250944138 +   0.131859993935*_Complex_I,
   -0.128745031357 +  -0.084740310907*_Complex_I,
   -0.061492395401 +  -0.099420046806*_Complex_I,
    0.012414894253 +  -0.015323466063*_Complex_I,
    0.012217399478 +   0.012398956716*_Complex_I,
    0.050523018837 +  -0.087095749378*_Complex_I,
   -0.015820150077 +  -0.054119426012*_Complex_I,
   -0.055258476734 +   0.020015104115*_Complex_I,
    0.063105708361 +   0.042238712311*_Complex_I,
    0.017720183730 +   0.017351190746*_Complex_I,
   -0.141501569748 +  -0.117573750019*_Complex_I,
   -0.006765382737 +   0.056032115221*_Complex_I,
   -0.004831269756 +  -0.002968831547*_Complex_I,
   -0.032051759958 +  -0.190994548798*_Complex_I,
    0.036215576530 +   0.173437201977*_Complex_I,
   -0.189757418633 +  -0.055692046881*_Complex_I,
   -0.059237557650 +   0.126770603657*_Complex_I,
    0.038132804632 +  -0.074801898003*_Complex_I,
    0.088674974442 +  -0.053153961897*_Complex_I,
   -0.078639388084 +   0.046550104022*_Complex_I,
   -0.018440252542 +   0.040226161480*_Complex_I,
   -0.001557452139 +   0.011683121324*_Complex_I,
   -0.251441335678 +   0.073139393330*_Complex_I,
   -0.205929875374 +   0.018797023594*_Complex_I,
   -0.004785243422 +   0.018977609277*_Complex_I,
   -0.008223478496 +   0.016689766943*_Complex_I,
   -0.013542374969 +   0.098333865404*_Complex_I,
    0.174354946613 +  -0.053679537773*_Complex_I,
    0.070709151030 +   0.105750656128*_Complex_I,
   -0.004860538989 +  -0.093827313185*_Complex_I,
    0.008115487546 +   0.105573391914*_Complex_I,
   -0.086253505945 +  -0.016359496117*_Complex_I,
    0.260078501701 +   0.011332800239*_Complex_I,
   -0.106663954258 +  -0.106564879417*_Complex_I,
    0.103312873840 +  -0.263231492043*_Complex_I,
   -0.054847794771 +   0.040892100334*_Complex_I,
    0.110823535919 +  -0.184762966633*_Complex_I,
   -0.071165961027 +  -0.055934780836*_Complex_I,
   -0.178788268566 +  -0.044872501493*_Complex_I,
   -0.046904963255 +  -0.092374777794*_Complex_I,
    0.162701845169 +   0.020701634884*_Complex_I,
   -0.101515638828 +   0.074363875389*_Complex_I,
    0.057615011930 +  -0.117078483105*_Complex_I,
    0.020440319180 +   0.002894190140*_Complex_I,
   -0.066558498144 +   0.002631408162*_Complex_I,
    0.016302645206 +   0.071249717474*_Complex_I,
   -0.062377142906 +   0.063173556328*_Complex_I,
    0.115204286575 +   0.057497209311*_Complex_I,
    0.094178062677 +   0.013675969839*_Complex_I,
    0.039668846130 +  -0.104888665676*_Complex_I,
   -0.077536809444 +   0.030107039213*_Complex_I,
    0.019500632584 +  -0.077639460564*_Complex_I,
   -0.036470189691 +   0.141290163994*_Complex_I,
   -0.202891373634 +  -0.006020304561*_Complex_I,
    0.142597723007 +   0.001829937287*_Complex_I,
    0.042515522242 +  -0.033903941512*_Complex_I,
   -0.160332143307 +   0.167697465420*_Complex_I,
    0.065906691551 +  -0.046222153306*_Complex_I,
   -0.014665135741 +   0.029732593894*_Complex_I,
   -0.161926984787 +  -0.039980190992*_Complex_I,
    0.216635417938 +  -0.084111690521*_Complex_I,
    0.111900138855 +  -0.088012528419*_Complex_I,
    0.131331551075 +  -0.075983870029*_Complex_I,
   -0.110518038273 +   0.217655158043*_Complex_I,
   -0.019964502752 +   0.029798141122*_Complex_I,
   -0.077271521091 +   0.017983873188*_Complex_I,
    0.192190217972 +  -0.034995573759*_Complex_I,
    0.121502757072 +  -0.071480178833*_Complex_I,
    0.082723850012 +  -0.001845339499*_Complex_I,
   -0.072242385149 +  -0.005906258896*_Complex_I,
   -0.176676702499 +   0.110248458385*_Complex_I,
    0.080035436153 +   0.107154047489*_Complex_I,
    0.023038166761 +  -0.114933979511*_Complex_I,
   -0.139963030815 +  -0.063580548763*_Complex_I,
   -0.024152973294 +  -0.165445506573*_Complex_I,
    0.175627219677 +   0.068415731192*_Complex_I,
    0.062092590332 +  -0.063827121258*_Complex_I,
    0.058578062057 +   0.007875456661*_Complex_I,
    0.076061081886 +  -0.132551908493*_Complex_I,
    0.104943084717 +  -0.084286916256*_Complex_I,
    0.019696915150 +   0.003201137111*_Complex_I,
    0.079270011187 +   0.105154144764*_Complex_I,
    0.067746007442 +   0.087236845493*_Complex_I,
   -0.095283645391 +  -0.162002611160*_Complex_I,
   -0.049992722273 +   0.118607068062*_Complex_I,
    0.107323861122 +  -0.174439251423*_Complex_I,
   -0.132320475578 +   0.017735700309*_Complex_I,
    0.010226617008 +  -0.197343289852*_Complex_I,
   -0.065331441164 +  -0.169277667999*_Complex_I,
   -0.067106610537 +   0.003877854347*_Complex_I,
    0.149599671364 +  -0.130133831501*_Complex_I,
   -0.082966232300 +  -0.140549242496*_Complex_I,
   -0.121567571163 +   0.111494851112*_Complex_I,
   -0.040895500779 +   0.242881941795*_Complex_I,
    0.046610686183 +   0.190598750114*_Complex_I,
   -0.241175961494 +   0.038187211752*_Complex_I,
    0.091600197554 +   0.075727856159*_Complex_I,
    0.138635289669 +   0.048851582408*_Complex_I,
    0.142762672901 +   0.008544234186*_Complex_I,
    0.129457914829 +   0.013422895968*_Complex_I,
   -0.118289554119 +   0.265937256813*_Complex_I,
    0.010878042877 +  -0.077647930384*_Complex_I,
   -0.070324224234 +   0.039972990751*_Complex_I,
   -0.041980904341 +   0.067246806622*_Complex_I,
   -0.150996875763 +   0.028954780102*_Complex_I,
    0.023831695318 +  -0.059671503305*_Complex_I,
   -0.060499125719 +   0.022479967773*_Complex_I,
    0.042781451344 +  -0.012739011645*_Complex_I,
   -0.058961522579 +   0.108779168129*_Complex_I,
   -0.123040950298 +  -0.084437525272*_Complex_I,
   -0.031985121965 +   0.144360256195*_Complex_I,
    0.009733268619 +  -0.105923128128*_Complex_I,
   -0.133637535572 +  -0.006438682973*_Complex_I,
    0.049610015750 +  -0.120102596283*_Complex_I,
    0.112718105316 +   0.129998087883*_Complex_I,
   -0.142268264294 +  -0.013222855330*_Complex_I,
    0.119939064980 +   0.084782326221*_Complex_I,
   -0.002139478363 +   0.143925952911*_Complex_I,
   -0.017734520137 +   0.060474181175*_Complex_I,
   -0.115593242645 +   0.266750621796*_Complex_I,
   -0.122079384327 +   0.060140782595*_Complex_I,
   -0.116746783257 +   0.058306437731*_Complex_I,
   -0.035461139679 +  -0.199710798264*_Complex_I,
   -0.012796324492 +  -0.006662363559*_Complex_I,
   -0.168765580654 +  -0.080484443903*_Complex_I,
    0.109565150738 +  -0.066066616774*_Complex_I,
    0.167375874519 +  -0.095793098211*_Complex_I,
    0.063125562668 +  -0.015197466314*_Complex_I,
   -0.131772887707 +   0.043374121189*_Complex_I,
    0.108676636219 +   0.016854281723*_Complex_I,
   -0.158170187473 +   0.066611725092*_Complex_I,
    0.186592674255 +  -0.119178080559*_Complex_I,
    0.258357715607 +   0.035161945224*_Complex_I,
   -0.267501235008 +   0.113799548149*_Complex_I,
   -0.121099197865 +  -0.008966898173*_Complex_I,
   -0.080716609955 +   0.092299455404*_Complex_I,
    0.052158069611 +   0.009480424225*_Complex_I,
    0.042302635312 +  -0.107537162304*_Complex_I,
   -0.149109280109 +   0.086092722416*_Complex_I,
   -0.047981733084 +   0.051883894205*_Complex_I,
    0.129582881927 +   0.080048167706*_Complex_I,
    0.020590978861 +   0.052324140072*_Complex_I,
   -0.127634072304 +   0.003840797022*_Complex_I,
   -0.015030093491 +   0.081028074026*_Complex_I,
   -0.151265537739 +   0.073973071575*_Complex_I,
    0.065107202530 +  -0.102953696251*_Complex_I,
    0.020201592147 +  -0.043066096306*_Complex_I,
   -0.041327267885 +  -0.084052354097*_Complex_I,
    0.039087793231 +  -0.027260744572*_Complex_I,
    0.149368381500 +   0.085757601261*_Complex_I,
   -0.045472341776 +  -0.007366366684*_Complex_I,
   -0.014300452173 +   0.070052427053*_Complex_I,
   -0.030928212404 +   0.008410415053*_Complex_I,
    0.102823138237 +   0.089631778002*_Complex_I,
   -0.046347615123 +   0.012207016349*_Complex_I,
   -0.022019737959 +   0.008490467072*_Complex_I};

float complex fftfilt_crcf_data_h23x256_y[] = {
    0.027262836609 +  -0.007029047174*_Complex_I,
    0.018346427661 +   0.000704495242*_Complex_I,
   -0.004460839644 +  -0.013149554871*_Complex_I,
   -0.013679299641 +   0.007988293987*_Complex_I,
   -0.039004795515 +  -0.012553764367*_Complex_I,
    0.016696266867 +   0.009469516192*_Complex_I,
   -0.003513172567 +   0.046564035001*_Complex_I,
    0.020372582455 +  -0.027609901195*_Complex_I,
    0.006199293336 +   0.013118588352*_Complex_I,
   -0.042660178683 +  -0.048881324868*_Complex_I,
    0.012162311731 +   0.006692219554*_Complex_I,
    0.005999545171 +   0.012678334008*_Complex_I,
    0.016925234916 +   0.011802413052*_Complex_I,
    0.012643874018 +  -0.002379618949*_Complex_I,
   -0.019843625969 +  -0.042091077177*_Complex_I,
   -0.002447170334 +  -0.066361916522*_Complex_I,
    0.027635184820 +   0.025233499033*_Complex_I,
   -0.023950232537 +   0.018344717328*_Complex_I,
   -0.001523383406 +   0.047987234347*_Complex_I,
   -0.037208867735 +  -0.060587103130*_Complex_I,
    0.040881005070 +  -0.012194712051*_Complex_I,
    0.051353615432 +  -0.030052114039*_Complex_I,
    0.039843962567 +  -0.018530512464*_Complex_I,
   -0.011241859913 +   0.003314208877*_Complex_I,
   -0.023931715066 +  -0.008536051326*_Complex_I,
   -0.046474201238 +   0.019213392371*_Complex_I,
    0.026420531301 +   0.008903961274*_Complex_I,
   -0.003321242652 +  -0.005089987861*_Complex_I,
    0.018094294321 +   0.009055610544*_Complex_I,
   -0.065634402614 +  -0.053749750040*_Complex_I,
   -0.023600007069 +   0.001972776975*_Complex_I,
    0.029460287631 +  -0.022729601752*_Complex_I,
   -0.005045917714 +   0.054578580699*_Complex_I,
   -0.007148429271 +  -0.055204501924*_Complex_I,
    0.010660749874 +  -0.059471864271*_Complex_I,
   -0.028011323273 +  -0.066785744888*_Complex_I,
    0.011622802421 +   0.013720590963*_Complex_I,
   -0.036631828451 +   0.003833520561*_Complex_I,
    0.047864856646 +  -0.017738859345*_Complex_I,
   -0.007990385588 +  -0.035672288313*_Complex_I,
    0.004986325822 +   0.029278794046*_Complex_I,
   -0.016889528458 +  -0.015755301985*_Complex_I,
   -0.010143232206 +  -0.021096571154*_Complex_I,
   -0.009806462106 +  -0.047616138372*_Complex_I,
    0.051880472016 +   0.035421818987*_Complex_I,
    0.004878725946 +  -0.006588080806*_Complex_I,
    0.059514317675 +   0.025245817016*_Complex_I,
   -0.041213052806 +   0.001434752292*_Complex_I,
   -0.031520998781 +  -0.026425494383*_Complex_I,
   -0.042062234079 +  -0.023223262575*_Complex_I,
   -0.031771373601 +  -0.001999239137*_Complex_I,
    0.003008538314 +   0.007873584524*_Complex_I,
   -0.044522016963 +   0.031453229897*_Complex_I,
   -0.004123811253 +  -0.100618757520*_Complex_I,
    0.000868379196 +  -0.007049767471*_Complex_I,
   -0.035358534934 +   0.039935982082*_Complex_I,
    0.001096892916 +  -0.008139914684*_Complex_I,
   -0.045888282337 +  -0.028654012806*_Complex_I,
    0.054241028654 +  -0.040641857373*_Complex_I,
    0.076384681516 +  -0.009290596232*_Complex_I,
   -0.014394459295 +   0.031937206347*_Complex_I,
    0.029290098261 +   0.000294924311*_Complex_I,
   -0.024684029149 +   0.000989628106*_Complex_I,
   -0.016171486419 +   0.031195541518*_Complex_I,
   -0.014868511208 +   0.014303327420*_Complex_I,
    0.021852231291 +   0.016723227953*_Complex_I,
    0.020272353403 +   0.015401209854*_Complex_I,
    0.071528405043 +   0.017807463305*_Complex_I,
   -0.020235058791 +  -0.039855986142*_Complex_I,
   -0.034484804762 +   0.000496010405*_Complex_I,
    0.007189500129 +   0.020495810669*_Complex_I,
   -0.021931884508 +   0.027723824179*_Complex_I,
   -0.045456425035 +  -0.019096529483*_Complex_I,
   -0.017800090999 +  -0.040386165849*_Complex_I,
   -0.031040929546 +  -0.045937861114*_Complex_I,
    0.065367936599 +   0.021960412702*_Complex_I,
   -0.060220212620 +   0.045242058344*_Complex_I,
   -0.015791818114 +  -0.002107138847*_Complex_I,
   -0.016776877211 +  -0.047286567469*_Complex_I,
    0.014399266122 +  -0.042073854865*_Complex_I,
    0.056679887935 +   0.012644277043*_Complex_I,
   -0.008511751801 +   0.004971041195*_Complex_I,
    0.081952669986 +   0.012577593191*_Complex_I,
   -0.012764140374 +  -0.011967000266*_Complex_I,
   -0.003336654686 +  -0.001262645566*_Complex_I,
    0.016350375874 +   0.032350783323*_Complex_I,
    0.010862760597 +  -0.035926563231*_Complex_I,
    0.029863051593 +   0.043664156677*_Complex_I,
   -0.012277218714 +  -0.028013771036*_Complex_I,
   -0.021453932268 +  -0.061946366678*_Complex_I,
    0.031514206628 +  -0.020671975000*_Complex_I,
   -0.023541686556 +   0.038816659613*_Complex_I,
    0.015568416177 +   0.034767821284*_Complex_I,
   -0.053493562550 +   0.010727696220*_Complex_I,
   -0.041010374462 +  -0.065258809696*_Complex_I,
    0.005288272932 +   0.024477688872*_Complex_I,
   -0.046902277134 +  -0.000092205057*_Complex_I,
    0.001627461508 +   0.080137549979*_Complex_I,
   -0.065128047455 +  -0.060262053915*_Complex_I,
    0.006596006298 +   0.065336899466*_Complex_I,
    0.000058721241 +  -0.040094018767*_Complex_I,
   -0.036305854351 +  -0.003934363665*_Complex_I,
    0.008450440041 +  -0.033595118529*_Complex_I,
    0.029549628861 +   0.041310102659*_Complex_I,
   -0.031905285980 +  -0.031000918152*_Complex_I,
    0.011726181555 +   0.060113189533*_Complex_I,
   -0.047367175488 +  -0.048891971737*_Complex_I,
    0.019495535591 +   0.085142512409*_Complex_I,
    0.018357043313 +  -0.001756917795*_Complex_I,
   -0.044850116879 +  -0.007540707159*_Complex_I,
   -0.040509844673 +  -0.092704738011*_Complex_I,
    0.045015777649 +   0.044308907043*_Complex_I,
    0.033412972066 +   0.006857384940*_Complex_I,
   -0.013027623910 +  -0.030790116518*_Complex_I,
   -0.000975157484 +   0.037733658737*_Complex_I,
   -0.022753324517 +   0.023070309941*_Complex_I,
    0.021078444893 +   0.032118433292*_Complex_I,
    0.010443833730 +   0.016807510307*_Complex_I,
   -0.038157141667 +  -0.083720289418*_Complex_I,
    0.015884591663 +   0.080444457603*_Complex_I,
   -0.014224915913 +   0.005135806833*_Complex_I,
   -0.025232136903 +   0.004144801774*_Complex_I,
   -0.077288630878 +  -0.005906892810*_Complex_I,
   -0.034553210182 +  -0.017846341663*_Complex_I,
    0.035746673427 +  -0.012259253660*_Complex_I,
    0.036525883688 +  -0.010525857333*_Complex_I,
   -0.014488296110 +  -0.014305379613*_Complex_I,
   -0.015958243599 +   0.045987466851*_Complex_I,
    0.003179382534 +  -0.018266667088*_Complex_I,
    0.029305351113 +   0.000580102615*_Complex_I,
   -0.043259878864 +  -0.037454506754*_Complex_I,
   -0.028365132804 +   0.065377160248*_Complex_I,
    0.070378428765 +  -0.056958149428*_Complex_I,
    0.004867726670 +   0.005962596169*_Complex_I,
   -0.037918405464 +  -0.091858574411*_Complex_I,
   -0.019631672181 +   0.051212141219*_Complex_I,
   -0.057622870703 +  -0.011592712757*_Complex_I,
    0.039759648837 +   0.003839054841*_Complex_I,
   -0.059496690769 +  -0.007464198304*_Complex_I,
    0.020562373454 +  -0.038245564570*_Complex_I,
    0.032578387575 +   0.008176063763*_Complex_I,
   -0.022640669374 +   0.032133098133*_Complex_I,
   -0.059754420752 +  -0.022200850890*_Complex_I,
   -0.021917765961 +   0.061715182774*_Complex_I,
   -0.070723789096 +  -0.036769285459*_Complex_I,
    0.040897570713 +   0.020449142350*_Complex_I,
   -0.078688142274 +   0.044106118254*_Complex_I,
    0.132511709017 +  -0.002283572710*_Complex_I,
    0.031006482035 +   0.023633310053*_Complex_I,
    0.000719650304 +  -0.060425994891*_Complex_I,
   -0.068488182320 +   0.011823413272*_Complex_I,
    0.033571377809 +   0.001638620807*_Complex_I,
    0.013415095820 +   0.063237008575*_Complex_I,
    0.003843590843 +  -0.032020775100*_Complex_I,
    0.005708962317 +  -0.073909950927*_Complex_I,
    0.043060259091 +  -0.039410177301*_Complex_I,
   -0.031531087064 +  -0.004760009337*_Complex_I,
   -0.001506462543 +  -0.004643974469*_Complex_I,
   -0.069117792716 +  -0.013243456525*_Complex_I,
   -0.008999132078 +  -0.025213996567*_Complex_I,
    0.076230704310 +  -0.038893791301*_Complex_I,
   -0.016693801234 +   0.016189526184*_Complex_I,
    0.053793442954 +  -0.046315507571*_Complex_I,
   -0.022323859813 +   0.074471398757*_Complex_I,
   -0.077019541390 +   0.000776612640*_Complex_I,
    0.028852092849 +  -0.003754892925*_Complex_I,
    0.030634254859 +  -0.031119630463*_Complex_I,
    0.070978930378 +   0.018366156735*_Complex_I,
    0.011314850738 +   0.020679865086*_Complex_I,
   -0.009529937549 +   0.025881841685*_Complex_I,
   -0.099579012075 +  -0.013132370673*_Complex_I,
    0.044640476208 +   0.044583555144*_Complex_I,
    0.016522002764 +  -0.063707510591*_Complex_I,
    0.003035671136 +  -0.013751873371*_Complex_I,
   -0.026798937752 +  -0.022117369500*_Complex_I,
    0.007823238214 +   0.038428718991*_Complex_I,
   -0.033760635042 +   0.056366436739*_Complex_I,
    0.061213467638 +  -0.037917433069*_Complex_I,
   -0.019400770671 +   0.002314675027*_Complex_I,
    0.030275097259 +  -0.065680749303*_Complex_I,
   -0.012116792287 +   0.011848118163*_Complex_I,
    0.036218177449 +  -0.012568718012*_Complex_I,
    0.060643006355 +   0.043892825588*_Complex_I,
    0.017806428565 +  -0.022264383863*_Complex_I,
   -0.048473906401 +   0.014501335500*_Complex_I,
   -0.031370768130 +  -0.040223039246*_Complex_I,
    0.019781480670 +   0.021758320109*_Complex_I,
    0.063634947558 +  -0.007457977030*_Complex_I,
    0.020848525728 +  -0.052882085833*_Complex_I,
   -0.063823888094 +   0.004319709113*_Complex_I,
    0.038427723737 +  -0.024772513569*_Complex_I,
   -0.035206635151 +  -0.007553598958*_Complex_I,
    0.005557463302 +   0.057023731153*_Complex_I,
   -0.026365483732 +   0.001677431571*_Complex_I,
   -0.027214665101 +   0.003259544495*_Complex_I,
    0.006634141929 +  -0.021760848241*_Complex_I,
    0.046788459295 +  -0.032219612690*_Complex_I,
    0.049439176247 +   0.058001544517*_Complex_I,
    0.045244742233 +  -0.058913353130*_Complex_I,
    0.024261567778 +   0.012176684918*_Complex_I,
   -0.050667381589 +   0.023733558523*_Complex_I,
    0.045349821935 +   0.040847998957*_Complex_I,
    0.026718102874 +  -0.059402465947*_Complex_I,
   -0.038454788567 +  -0.000221349180*_Complex_I,
   -0.000891207880 +  -0.009195003923*_Complex_I,
    0.012516609339 +   0.056222305600*_Complex_I,
   -0.035084845543 +  -0.052719626538*_Complex_I,
   -0.021230335164 +  -0.038700055773*_Complex_I,
   -0.042702491469 +  -0.012596339115*_Complex_I,
    0.001037928882 +  -0.021134005956*_Complex_I,
    0.021394370180 +  -0.031996808591*_Complex_I,
   -0.018110589131 +  -0.004361916553*_Complex_I,
   -0.042616962178 +  -0.045478200889*_Complex_I,
    0.015593771645 +   0.075086774578*_Complex_I,
    0.027412734674 +   0.021799498978*_Complex_I,
   -0.092513052262 +   0.111578027869*_Complex_I,
    0.023261460083 +  -0.018008166583*_Complex_I,
   -0.005433496503 +   0.062765792378*_Complex_I,
    0.077096470007 +  -0.046336297254*_Complex_I,
    0.013100162132 +   0.106964173517*_Complex_I,
   -0.057225839702 +   0.011100170701*_Complex_I,
   -0.011950150953 +   0.042976543657*_Complex_I,
    0.009438239329 +  -0.043586074813*_Complex_I,
   -0.035007068103 +   0.014223415436*_Complex_I,
   -0.044707188095 +  -0.007302556287*_Complex_I,
   -0.006824766721 +   0.022952180881*_Complex_I,
    0.017261515635 +  -0.031023982394*_Complex_I,
    0.009883747796 +   0.006683863273*_Complex_I,
   -0.030856485749 +  -0.017782855219*_Complex_I,
   -0.009108501465 +   0.015353290050*_Complex_I,
   -0.038083572506 +   0.029801645641*_Complex_I,
    0.028040003683 +  -0.001971697544*_Complex_I,
    0.034858486128 +  -0.004199899994*_Complex_I,
   -0.047963189034 +  -0.015741737165*_Complex_I,
   -0.009310592393 +   0.022863663510*_Complex_I,
   -0.082864799372 +   0.027670042319*_Complex_I,
    0.018363359405 +   0.035364489440*_Complex_I,
    0.108637353728 +  -0.051587108396*_Complex_I,
   -0.037281254062 +   0.067821136010*_Complex_I,
   -0.061231969683 +   0.036908299475*_Complex_I,
   -0.020972301615 +   0.096608850141*_Complex_I,
   -0.079111323581 +   0.024466271096*_Complex_I,
    0.045843637768 +  -0.077335246433*_Complex_I,
   -0.011031555894 +   0.001143494701*_Complex_I,
   -0.050696885867 +  -0.000991623122*_Complex_I,
   -0.025631881174 +  -0.020905755095*_Complex_I,
    0.042787270331 +  -0.022375533820*_Complex_I,
    0.040540034730 +  -0.032482851465*_Complex_I,
    0.045207009532 +  -0.015041815894*_Complex_I,
   -0.041989439384 +   0.052327580958*_Complex_I,
   -0.060932225937 +  -0.002610819103*_Complex_I,
    0.056802692214 +   0.015432577360*_Complex_I,
    0.066574027053 +  -0.021238051145*_Complex_I,
   -0.000873772321 +   0.003555393272*_Complex_I,
   -0.047364452139 +   0.039519457621*_Complex_I,
   -0.075184690098 +   0.032775776752*_Complex_I};

