#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:vincent.vole@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/fb-request-person.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& ! grep -q '^FREEBUSY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   ! grep -q 'METHOD:REPLY' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out2fo.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2fo.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event6@example.com" 2>> $ERROR \
| tee out3.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out3f.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-conflict.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   ! grep -q 'METHOD:REPLY' out4.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out4f.tmp

   ! grep -q "event7@example.com" "out4f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out4fo.tmp

   grep -q "event7@example.com" "out4fo.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$DECLINE_SCRIPT" $DECLINE_ARGS "$USER" "event7@example.com" 2>> $ERROR \
| tee out5.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out5f.tmp

   grep -q "event6@example.com" "out5f.tmp" \
&& ! grep -q "event7@example.com" "out5f.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   ! grep -q 'METHOD:REPLY' out6.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out6f.tmp

   ! grep -q "event6@example.com" "out6f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out6fo.tmp

   grep -q "event6@example.com" "out6fo.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out7.tmp

   ! grep -q 'METHOD:REPLY' out7.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out7f.tmp

   ! grep -q "event6@example.com" "out7f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out7fo.tmp

   ! grep -q "event6@example.com" "out7fo.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-spoofed.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out8.tmp

   ! grep -q 'METHOD:REPLY' out8.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out8f.tmp

   ! grep -q "spoof2@example.com" "out8f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out8fo.tmp

   ! grep -q "spoof2@example.com" "out8fo.tmp" \
&& echo "Success" \
|| echo "Failed"
