/* Canvas.c generated by valac 0.12.0, the Vala compiler
 * generated from Canvas.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2008,2011 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_CANVAS_MODE (canvas_mode_get_type ())

#define TYPE_ARRAY_BOX (array_box_get_type ())

#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _ArrayBox ArrayBox;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;
typedef struct _CanvasPrivate CanvasPrivate;

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;

#define TYPE_GTK_MULT (gtk_mult_get_type ())
#define GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GTK_MULT, GtkMult))
#define GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GTK_MULT, GtkMultClass))
#define IS_GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GTK_MULT))
#define IS_GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GTK_MULT))
#define GTK_MULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GTK_MULT, GtkMultClass))

typedef struct _GtkMult GtkMult;
typedef struct _GtkMultClass GtkMultClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())
typedef struct _Block1Data Block1Data;

#define TYPE_TABLE_BOX (table_box_get_type ())
#define TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TABLE_BOX, TableBox))
#define TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TABLE_BOX, TableBoxClass))
#define IS_TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TABLE_BOX))
#define IS_TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TABLE_BOX))
#define TABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TABLE_BOX, TableBoxClass))

typedef struct _TableBox TableBox;
typedef struct _TableBoxClass TableBoxClass;
typedef struct _Block2Data Block2Data;

#define TYPE_DIGIT_BOX (digit_box_get_type ())
#define DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGIT_BOX, DigitBox))
#define DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGIT_BOX, DigitBoxClass))
#define IS_DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGIT_BOX))
#define IS_DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGIT_BOX))
#define DIGIT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGIT_BOX, DigitBoxClass))

typedef struct _DigitBox DigitBox;
typedef struct _DigitBoxClass DigitBoxClass;

typedef enum  {
	CANVAS_MODE_NONE,
	CANVAS_MODE_DIGIT,
	CANVAS_MODE_CHAR
} CanvasMode;

struct _ArrayBox {
	CharBox** array;
	gint array_length1;
	gint _array_size_;
};

struct _Canvas {
	GtkEventBox parent_instance;
	CanvasPrivate * priv;
};

struct _CanvasClass {
	GtkEventBoxClass parent_class;
};

struct _CanvasPrivate {
	MultPuzzle* _puzzle;
	GtkMult* _mult;
	gchar* mode_letter;
	CanvasMode mode;
	gint min_box_request;
	gint num_box_rows;
	gint num_box_cols;
	gint min_width;
	gint min_height;
	GtkFixed* fixed;
	GtkWidget* vsep;
	GtkWidget* hsep1;
	GtkWidget* hsep2;
	GList* mult_boxes;
	GList* digit_boxes;
	CharBox** xboxes;
	gint xboxes_length1;
	gint _xboxes_size_;
	CharBox** yboxes;
	gint yboxes_length1;
	gint _yboxes_size_;
	CharBox** zboxes;
	gint zboxes_length1;
	gint _zboxes_size_;
	ArrayBox* addboxes;
	gint addboxes_length1;
	gint _addboxes_size_;
	CharBox** digitboxes;
	gint digitboxes_length1;
	gint _digitboxes_size_;
	CharBox* plusbox;
	CharBox* timesbox;
};

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;

struct _Block1Data {
	int _ref_count_;
	Canvas * self;
	CharBox* b;
};

struct _Block2Data {
	int _ref_count_;
	Canvas * self;
	CharBox* b;
};


static gpointer canvas_parent_class = NULL;
extern gint gtk_mult_dpi;

GType canvas_mode_get_type (void) G_GNUC_CONST;
GType array_box_get_type (void) G_GNUC_CONST;
GType char_box_get_type (void) G_GNUC_CONST;
ArrayBox* array_box_dup (const ArrayBox* self);
void array_box_free (ArrayBox* self);
void array_box_copy (const ArrayBox* self, ArrayBox* dest);
void array_box_destroy (ArrayBox* self);
static CharBox** _vala_array_dup1 (CharBox** self, int length);
GType canvas_get_type (void) G_GNUC_CONST;
GType mult_puzzle_get_type (void) G_GNUC_CONST;
GType gtk_mult_get_type (void) G_GNUC_CONST;
#define CANVAS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANVAS, CanvasPrivate))
enum  {
	CANVAS_DUMMY_PROPERTY,
	CANVAS_PUZZLE,
	CANVAS_MULT
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_ArrayBox_array_free (ArrayBox* array, gint array_length);
#define CANVAS_SPACING 6
Canvas* canvas_new (GtkMult* mult);
Canvas* canvas_construct (GType object_type, GtkMult* mult);
void canvas_clear_mode (Canvas* self);
void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box);
const gchar* char_box_get_letter (CharBox* self);
void canvas_highlight_box (Canvas* self, CharBox* box, gboolean digit_box, gboolean hover, gboolean all);
GtkMult* canvas_get_mult (Canvas* self);
GtkStatusbar* gtk_mult_get_status (GtkMult* self);
void gtk_mult_clear_guess_feedback (GtkMult* self);
void canvas_start_choice (Canvas* self, gchar ch);
void canvas_start_digit_choice (Canvas* self, CharBox* b);
void canvas_start_char_choice (Canvas* self, CharBox* b);
MultPuzzle* canvas_get_puzzle (Canvas* self);
GType mult_puzzle_char_get_type (void) G_GNUC_CONST;
GType mult_puzzle_guess_status_get_type (void) G_GNUC_CONST;
MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter);
static void canvas_layout_mult_string (Canvas* self, CharBox** boxes, int boxes_length1, gint row, gint indent, gint w, gint mult_x_offset, gint mult_y_offset);
static void canvas_allocate_box (Canvas* self, CharBox* b, GdkRectangle* rect);
void char_box_set_points (CharBox* self, gint value);
static void canvas_handle_size_allocate (Canvas* self, GdkRectangle* rect);
guint mult_puzzle_get_num_addends (MultPuzzle* self);
static CharBox* canvas_create_mult_box (Canvas* self, gunichar ch);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
CharBox* char_box_new (const gchar* letter, GtkShadowType border);
CharBox* char_box_construct (GType object_type, const gchar* letter, GtkShadowType border);
TableBox* table_box_new (gchar c, Canvas* can);
TableBox* table_box_construct (GType object_type, gchar c, Canvas* can);
GType table_box_get_type (void) G_GNUC_CONST;
static gboolean _lambda1_ (GdkEventButton* e, Block1Data* _data1_);
static gboolean canvas_handle_release (Canvas* self, CharBox* box, GdkEventButton* event, gboolean digit_box);
static gboolean __lambda1__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda2_ (GdkEventCrossing* e, Block1Data* _data1_);
static gboolean __lambda2__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda3_ (GdkEventCrossing* e, Block1Data* _data1_);
static gboolean __lambda3__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static CharBox* canvas_create_digit_box (Canvas* self, gboolean* unknown, int unknown_length1, gint i);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
DigitBox* digit_box_new (Canvas* canvas, const gchar* letter);
DigitBox* digit_box_construct (GType object_type, Canvas* canvas, const gchar* letter);
GType digit_box_get_type (void) G_GNUC_CONST;
static gboolean _lambda4_ (GdkEventButton* e, Block2Data* _data2_);
static gboolean __lambda4__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda5_ (GdkEventCrossing* e, Block2Data* _data2_);
static gboolean __lambda5__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda6_ (GdkEventCrossing* e, Block2Data* _data2_);
static gboolean __lambda6__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static void canvas_handle_puzzle_change (Canvas* self, MultPuzzle* p);
gchar* mult_puzzle_get_multiplicand (MultPuzzle* self);
gchar* mult_puzzle_get_multiplier (MultPuzzle* self);
gchar* mult_puzzle_get_addend (MultPuzzle* self, gint n);
gchar* mult_puzzle_get_answer (MultPuzzle* self);
gboolean* mult_puzzle_get_unknown_digits (MultPuzzle* self, int* result_length1);
gboolean mult_puzzle_get_is_done (MultPuzzle* self);
void char_box_set_highlight (CharBox* self, GtkStateFlags value);
gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1);
static gboolean canvas_handle_none_release (Canvas* self, GdkEventButton* event);
static void canvas_set_puzzle (Canvas* self, MultPuzzle* value);
static void canvas_set_mult (Canvas* self, GtkMult* value);
static GObject * canvas_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
MultPuzzle* gtk_mult_get_puzzle (GtkMult* self);
static gboolean _canvas_handle_none_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _canvas_handle_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _canvas_handle_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self);
static void canvas_finalize (GObject* obj);
static void _vala_canvas_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_canvas_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType canvas_mode_get_type (void) {
	static volatile gsize canvas_mode_type_id__volatile = 0;
	if (g_once_init_enter (&canvas_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{CANVAS_MODE_NONE, "CANVAS_MODE_NONE", "none"}, {CANVAS_MODE_DIGIT, "CANVAS_MODE_DIGIT", "digit"}, {CANVAS_MODE_CHAR, "CANVAS_MODE_CHAR", "char"}, {0, NULL, NULL}};
		GType canvas_mode_type_id;
		canvas_mode_type_id = g_enum_register_static ("CanvasMode", values);
		g_once_init_leave (&canvas_mode_type_id__volatile, canvas_mode_type_id);
	}
	return canvas_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static CharBox** _vala_array_dup1 (CharBox** self, int length) {
	CharBox** result;
	int i;
	result = g_new0 (CharBox*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


void array_box_copy (const ArrayBox* self, ArrayBox* dest) {
	CharBox** _tmp0_;
	dest->array = (_tmp0_ = self->array, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, (*self).array_length1));
	dest->array_length1 = self->array_length1;
}


void array_box_destroy (ArrayBox* self) {
	(*self).array = (_vala_array_free ((*self).array, (*self).array_length1, (GDestroyNotify) g_object_unref), NULL);
}


ArrayBox* array_box_dup (const ArrayBox* self) {
	ArrayBox* dup;
	dup = g_new0 (ArrayBox, 1);
	array_box_copy (self, dup);
	return dup;
}


void array_box_free (ArrayBox* self) {
	array_box_destroy (self);
	g_free (self);
}


GType array_box_get_type (void) {
	static volatile gsize array_box_type_id__volatile = 0;
	if (g_once_init_enter (&array_box_type_id__volatile)) {
		GType array_box_type_id;
		array_box_type_id = g_boxed_type_register_static ("ArrayBox", (GBoxedCopyFunc) array_box_dup, (GBoxedFreeFunc) array_box_free);
		g_once_init_leave (&array_box_type_id__volatile, array_box_type_id);
	}
	return array_box_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _vala_ArrayBox_array_free (ArrayBox* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			array_box_destroy (&array[i]);
		}
	}
	g_free (array);
}


Canvas* canvas_construct (GType object_type, GtkMult* mult) {
	Canvas * self = NULL;
	g_return_val_if_fail (mult != NULL, NULL);
	self = (Canvas*) g_object_new (object_type, "mult", mult, NULL);
	return self;
}


Canvas* canvas_new (GtkMult* mult) {
	return canvas_construct (TYPE_CANVAS, mult);
}


void canvas_clear_mode (Canvas* self) {
	g_return_if_fail (self != NULL);
	canvas_set_mode (self, CANVAS_MODE_NONE, NULL);
}


void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	GtkStatusbar* _tmp5_ = NULL;
	guint _tmp6_;
	guint context_id;
	GtkStatusbar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->mode = m;
	if (box == NULL) {
		_tmp0_ = NULL;
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = char_box_get_letter (box);
		_tmp0_ = _tmp1_;
	}
	_tmp2_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->mode_letter);
	self->priv->mode_letter = _tmp2_;
	{
		GList* b_collection;
		GList* b_it;
		b_collection = self->priv->mult_boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* _tmp3_;
			CharBox* b;
			_tmp3_ = _g_object_ref0 ((CharBox*) b_it->data);
			b = _tmp3_;
			{
				canvas_highlight_box (self, b, FALSE, FALSE, FALSE);
				_g_object_unref0 (b);
			}
		}
	}
	{
		GList* b_collection;
		GList* b_it;
		b_collection = self->priv->digit_boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* _tmp4_;
			CharBox* b;
			_tmp4_ = _g_object_ref0 ((CharBox*) b_it->data);
			b = _tmp4_;
			{
				canvas_highlight_box (self, b, TRUE, FALSE, FALSE);
				_g_object_unref0 (b);
			}
		}
	}
	_tmp5_ = gtk_mult_get_status (self->priv->_mult);
	_tmp6_ = gtk_statusbar_get_context_id (_tmp5_, "guess-prompt");
	context_id = _tmp6_;
	_tmp7_ = gtk_mult_get_status (self->priv->_mult);
	gtk_statusbar_pop (_tmp7_, context_id);
	if (self->priv->mode != CANVAS_MODE_NONE) {
		GtkStatusbar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gtk_mult_clear_guess_feedback (self->priv->_mult);
		_tmp8_ = gtk_mult_get_status (self->priv->_mult);
		_tmp9_ = _ (self->priv->mode_letter);
		_tmp10_ = g_strdup_printf ("%s = ?", _tmp9_);
		_tmp11_ = _tmp10_;
		gtk_statusbar_push (_tmp8_, context_id, _tmp11_);
		_g_free0 (_tmp11_);
	}
}


void canvas_start_choice (Canvas* self, gchar ch) {
	GList* _tmp0_ = NULL;
	gboolean _tmp1_;
	GList* boxes;
	gchar* _tmp2_ = NULL;
	gchar* str;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_ascii_isdigit (ch);
	if (_tmp1_) {
		_tmp0_ = self->priv->digit_boxes;
	} else {
		_tmp0_ = self->priv->mult_boxes;
	}
	boxes = _tmp0_;
	_tmp2_ = g_strdup_printf ("%c", (gint) ch);
	str = _tmp2_;
	{
		GList* b_collection;
		GList* b_it;
		b_collection = boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* _tmp3_;
			CharBox* b;
			_tmp3_ = _g_object_ref0 ((CharBox*) b_it->data);
			b = _tmp3_;
			{
				const gchar* _tmp4_ = NULL;
				_tmp4_ = char_box_get_letter (b);
				if (g_strcmp0 (str, _tmp4_) == 0) {
					gboolean _tmp5_;
					_tmp5_ = g_ascii_isdigit (ch);
					if (_tmp5_) {
						canvas_start_digit_choice (self, b);
					} else {
						canvas_start_char_choice (self, b);
					}
					_g_object_unref0 (b);
					break;
				}
				_g_object_unref0 (b);
			}
		}
	}
	_g_free0 (str);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


void canvas_start_digit_choice (Canvas* self, CharBox* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (self->priv->mode == CANVAS_MODE_CHAR) {
		GtkStateFlags _tmp0_;
		_tmp0_ = gtk_widget_get_state_flags ((GtkWidget*) b);
		if (_tmp0_ != GTK_STATE_FLAG_INSENSITIVE) {
			const gchar* _tmp1_ = NULL;
			gchar _tmp2_;
			gint _tmp3_;
			gchar _tmp4_;
			_tmp1_ = char_box_get_letter (b);
			_tmp2_ = string_get (_tmp1_, (glong) 0);
			_tmp3_ = g_ascii_digit_value (_tmp2_);
			_tmp4_ = string_get (self->priv->mode_letter, (glong) 0);
			mult_puzzle_guess (self->priv->_puzzle, _tmp3_, (MultPuzzleChar) _tmp4_);
		}
		canvas_clear_mode (self);
	} else {
		canvas_set_mode (self, CANVAS_MODE_DIGIT, b);
	}
}


void canvas_start_char_choice (Canvas* self, CharBox* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (self->priv->mode == CANVAS_MODE_DIGIT) {
		GtkStateFlags _tmp0_;
		_tmp0_ = gtk_widget_get_state_flags ((GtkWidget*) b);
		if (_tmp0_ != GTK_STATE_FLAG_INSENSITIVE) {
			gchar _tmp1_;
			gint _tmp2_;
			const gchar* _tmp3_ = NULL;
			gchar _tmp4_;
			_tmp1_ = string_get (self->priv->mode_letter, (glong) 0);
			_tmp2_ = g_ascii_digit_value (_tmp1_);
			_tmp3_ = char_box_get_letter (b);
			_tmp4_ = string_get (_tmp3_, (glong) 0);
			mult_puzzle_guess (self->priv->_puzzle, _tmp2_, (MultPuzzleChar) _tmp4_);
		}
		canvas_clear_mode (self);
	} else {
		canvas_set_mode (self, CANVAS_MODE_CHAR, b);
	}
}


static void canvas_layout_mult_string (Canvas* self, CharBox** boxes, int boxes_length1, gint row, gint indent, gint w, gint mult_x_offset, gint mult_y_offset) {
	gint x;
	gint y;
	g_return_if_fail (self != NULL);
	indent = self->priv->num_box_cols - indent;
	x = mult_x_offset + (indent * (w + CANVAS_SPACING));
	y = mult_y_offset + (row * (w + CANVAS_SPACING));
	if (row >= 2) {
		gint _tmp0_;
		_tmp0_ = gtk_widget_get_allocated_height (self->priv->hsep1);
		y = y + (_tmp0_ + CANVAS_SPACING);
	}
	if (row == (self->priv->num_box_rows - 1)) {
		gint _tmp1_;
		_tmp1_ = gtk_widget_get_allocated_height (self->priv->hsep2);
		y = y + (_tmp1_ + CANVAS_SPACING);
	}
	{
		CharBox** b_collection;
		int b_collection_length1;
		int b_it;
		b_collection = boxes;
		b_collection_length1 = boxes_length1;
		for (b_it = 0; b_it < boxes_length1; b_it = b_it + 1) {
			CharBox* _tmp2_;
			CharBox* b;
			_tmp2_ = _g_object_ref0 (b_collection[b_it]);
			b = _tmp2_;
			{
				GdkRectangle _tmp3_ = {0};
				GdkRectangle alloc;
				_tmp3_.x = x;
				_tmp3_.y = y;
				_tmp3_.width = w;
				_tmp3_.height = w;
				alloc = _tmp3_;
				canvas_allocate_box (self, b, &alloc);
				x = x + (w + CANVAS_SPACING);
				_g_object_unref0 (b);
			}
		}
	}
}


static void canvas_allocate_box (Canvas* self, CharBox* b, GdkRectangle* rect) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	gtk_widget_size_allocate ((GtkWidget*) b, rect);
	char_box_set_points (b, (gint) ((*rect).height * (72.0 / gtk_mult_dpi)));
}


static void canvas_handle_size_allocate (Canvas* self, GdkRectangle* rect) {
	gint w;
	gint h;
	gint _tmp0_ = 0;
	gint mult_x_offset;
	gint mult_y_offset;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint hsep1_height = 0;
	gint hsep2_height = 0;
	gint _tmp4_;
	gint _tmp5_;
	GdkRectangle rec = {0};
	guint _tmp6_;
	guint _tmp7_;
	gint vsep_width = 0;
	gint digit_y_offset;
	g_return_if_fail (self != NULL);
	w = (gint) (((*rect).width - self->priv->min_width) / (self->priv->num_box_cols + 2));
	h = (gint) (((*rect).height - self->priv->min_height) / self->priv->num_box_rows);
	if (w > h) {
		_tmp0_ = h;
	} else {
		_tmp0_ = w;
	}
	w = _tmp0_;
	mult_x_offset = ((*rect).x + 12) + ((((*rect).width - self->priv->min_width) - (w * (self->priv->num_box_cols + 2))) / 2);
	mult_y_offset = ((*rect).y + 12) + ((((*rect).height - self->priv->min_height) - (w * self->priv->num_box_rows)) / 2);
	if (mult_x_offset > ((*rect).width / 2)) {
		_tmp1_ = (*rect).width / 2;
	} else {
		_tmp1_ = mult_x_offset;
	}
	mult_x_offset = _tmp1_;
	if (mult_y_offset > ((*rect).height / 2)) {
		_tmp2_ = (*rect).height / 2;
	} else {
		_tmp2_ = mult_y_offset;
	}
	mult_y_offset = _tmp2_;
	canvas_layout_mult_string (self, self->priv->xboxes, self->priv->xboxes_length1, 0, self->priv->xboxes_length1, w, mult_x_offset, mult_y_offset);
	canvas_layout_mult_string (self, self->priv->yboxes, self->priv->yboxes_length1, 1, self->priv->yboxes_length1, w, mult_x_offset, mult_y_offset);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					i = i + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < self->priv->addboxes_length1)) {
					break;
				}
				canvas_layout_mult_string (self, self->priv->addboxes[i].array, self->priv->addboxes[i].array_length1, 2 + i, self->priv->addboxes[i].array_length1 + i, w, mult_x_offset, mult_y_offset);
			}
		}
	}
	canvas_layout_mult_string (self, self->priv->zboxes, self->priv->zboxes_length1, self->priv->num_box_rows - 1, self->priv->zboxes_length1, w, mult_x_offset, mult_y_offset);
	gtk_widget_get_preferred_height (self->priv->hsep1, NULL, &_tmp4_);
	hsep1_height = _tmp4_;
	gtk_widget_get_preferred_height (self->priv->hsep2, NULL, &_tmp5_);
	hsep2_height = _tmp5_;
	memset (&rec, 0, sizeof (GdkRectangle));
	rec.x = mult_x_offset;
	rec.y = mult_y_offset + (2 * (w + CANVAS_SPACING));
	rec.width = (self->priv->num_box_cols * w) + ((self->priv->num_box_cols - 1) * CANVAS_SPACING);
	rec.height = hsep1_height;
	gtk_widget_size_allocate (self->priv->hsep1, &rec);
	rec.x = mult_x_offset;
	_tmp6_ = mult_puzzle_get_num_addends (self->priv->_puzzle);
	rec.y = ((mult_y_offset + (((gint) (2 + _tmp6_)) * (w + CANVAS_SPACING))) + hsep1_height) + CANVAS_SPACING;
	rec.width = (self->priv->num_box_cols * w) + ((self->priv->num_box_cols - 1) * CANVAS_SPACING);
	rec.height = hsep2_height;
	gtk_widget_size_allocate (self->priv->hsep2, &rec);
	rec.x = mult_x_offset;
	rec.y = (mult_y_offset + w) + CANVAS_SPACING;
	rec.width = w;
	rec.height = w;
	canvas_allocate_box (self, self->priv->timesbox, &rec);
	rec.x = mult_x_offset;
	_tmp7_ = mult_puzzle_get_num_addends (self->priv->_puzzle);
	rec.y = ((mult_y_offset + (((gint) (1 + _tmp7_)) * (w + CANVAS_SPACING))) + hsep1_height) + CANVAS_SPACING;
	rec.width = w;
	rec.height = w;
	canvas_allocate_box (self, self->priv->plusbox, &rec);
	vsep_width = hsep1_height;
	rec.x = (mult_x_offset + (self->priv->num_box_cols * (w + CANVAS_SPACING))) + CANVAS_SPACING;
	rec.y = mult_y_offset;
	rec.width = vsep_width;
	rec.height = (*rect).height - ((mult_y_offset - (*rect).y) * 2);
	gtk_widget_size_allocate (self->priv->vsep, &rec);
	digit_y_offset = ((*rect).y + 12) + ((((((*rect).height - 12) - 12) - (5 * w)) - (4 * CANVAS_SPACING)) / 2);
	rec.width = w;
	rec.height = w;
	rec.x = rec.x + (CANVAS_SPACING * 2);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				if (!_tmp8_) {
					i = i + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < 5)) {
					break;
				}
				rec.y = digit_y_offset + (i * (w + CANVAS_SPACING));
				canvas_allocate_box (self, self->priv->digitboxes[i * 2], &rec);
			}
		}
	}
	rec.x = (rec.x + w) + CANVAS_SPACING;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				if (!_tmp9_) {
					i = i + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < 5)) {
					break;
				}
				rec.y = digit_y_offset + (i * (w + CANVAS_SPACING));
				canvas_allocate_box (self, self->priv->digitboxes[(i * 2) + 1], &rec);
			}
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->b);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _lambda1_ (GdkEventButton* e, Block1Data* _data1_) {
	Canvas * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = _data1_->self;
	_tmp0_ = canvas_handle_release (self, _data1_->b, e, FALSE);
	result = _tmp0_;
	return result;
}


static gboolean __lambda1__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda1_ (event, self);
	return result;
}


static gboolean _lambda2_ (GdkEventCrossing* e, Block1Data* _data1_) {
	Canvas * self;
	gboolean result = FALSE;
	self = _data1_->self;
	canvas_highlight_box (self, _data1_->b, FALSE, TRUE, TRUE);
	result = FALSE;
	return result;
}


static gboolean __lambda2__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda2_ (event, self);
	return result;
}


static gboolean _lambda3_ (GdkEventCrossing* e, Block1Data* _data1_) {
	Canvas * self;
	gboolean result = FALSE;
	self = _data1_->self;
	canvas_highlight_box (self, _data1_->b, FALSE, FALSE, TRUE);
	result = FALSE;
	return result;
}


static gboolean __lambda3__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda3_ (event, self);
	return result;
}


static CharBox* canvas_create_mult_box (Canvas* self, gunichar ch) {
	CharBox* result = NULL;
	Block1Data* _data1_;
	gboolean _tmp0_;
	CharBox* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_unichar_isdigit (ch);
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		CharBox* _tmp3_ = NULL;
		_tmp1_ = g_strdup_printf ("%c", (gint) ((gchar) ch));
		_tmp2_ = _tmp1_;
		_tmp3_ = char_box_new (_tmp2_, GTK_SHADOW_NONE);
		_g_object_unref0 (_data1_->b);
		_data1_->b = g_object_ref_sink (_tmp3_);
		_g_free0 (_tmp2_);
	} else {
		TableBox* _tmp4_ = NULL;
		CharBox* _tmp5_;
		_tmp4_ = table_box_new ((gchar) ch, self);
		_g_object_unref0 (_data1_->b);
		_data1_->b = (CharBox*) g_object_ref_sink (_tmp4_);
		gtk_widget_add_events ((GtkWidget*) _data1_->b, (gint) ((GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK));
		g_signal_connect_data ((GtkWidget*) _data1_->b, "button-release-event", (GCallback) __lambda1__gtk_widget_button_release_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		g_signal_connect_data ((GtkWidget*) _data1_->b, "enter-notify-event", (GCallback) __lambda2__gtk_widget_enter_notify_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		g_signal_connect_data ((GtkWidget*) _data1_->b, "leave-notify-event", (GCallback) __lambda3__gtk_widget_leave_notify_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp5_ = _g_object_ref0 (_data1_->b);
		self->priv->mult_boxes = g_list_append (self->priv->mult_boxes, _tmp5_);
	}
	_tmp6_ = _g_object_ref0 (_data1_->b);
	result = _tmp6_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->b);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda4_ (GdkEventButton* e, Block2Data* _data2_) {
	Canvas * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = _data2_->self;
	_tmp0_ = canvas_handle_release (self, _data2_->b, e, TRUE);
	result = _tmp0_;
	return result;
}


static gboolean __lambda4__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda4_ (event, self);
	return result;
}


static gboolean _lambda5_ (GdkEventCrossing* e, Block2Data* _data2_) {
	Canvas * self;
	gboolean result = FALSE;
	self = _data2_->self;
	canvas_highlight_box (self, _data2_->b, TRUE, TRUE, TRUE);
	result = FALSE;
	return result;
}


static gboolean __lambda5__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda5_ (event, self);
	return result;
}


static gboolean _lambda6_ (GdkEventCrossing* e, Block2Data* _data2_) {
	Canvas * self;
	gboolean result = FALSE;
	self = _data2_->self;
	canvas_highlight_box (self, _data2_->b, TRUE, FALSE, TRUE);
	result = FALSE;
	return result;
}


static gboolean __lambda6__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda6_ (event, self);
	return result;
}


static CharBox* canvas_create_digit_box (Canvas* self, gboolean* unknown, int unknown_length1, gint i) {
	CharBox* result = NULL;
	Block2Data* _data2_;
	CharBox* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (unknown[i] == TRUE) {
		gchar* _tmp0_ = NULL;
		gchar* digit_str;
		DigitBox* _tmp1_ = NULL;
		CharBox* _tmp2_;
		_tmp0_ = g_strdup_printf ("%i", i);
		digit_str = _tmp0_;
		_tmp1_ = digit_box_new (self, digit_str);
		_g_object_unref0 (_data2_->b);
		_data2_->b = (CharBox*) g_object_ref_sink (_tmp1_);
		gtk_widget_add_events ((GtkWidget*) _data2_->b, (gint) ((GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK));
		g_signal_connect_data ((GtkWidget*) _data2_->b, "button-release-event", (GCallback) __lambda4__gtk_widget_button_release_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		g_signal_connect_data ((GtkWidget*) _data2_->b, "enter-notify-event", (GCallback) __lambda5__gtk_widget_enter_notify_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		g_signal_connect_data ((GtkWidget*) _data2_->b, "leave-notify-event", (GCallback) __lambda6__gtk_widget_leave_notify_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp2_ = _g_object_ref0 (_data2_->b);
		self->priv->digit_boxes = g_list_append (self->priv->digit_boxes, _tmp2_);
		_g_free0 (digit_str);
	} else {
		CharBox* _tmp3_ = NULL;
		_tmp3_ = char_box_new (" ", GTK_SHADOW_NONE);
		_g_object_unref0 (_data2_->b);
		_data2_->b = g_object_ref_sink (_tmp3_);
	}
	_tmp4_ = _g_object_ref0 (_data2_->b);
	result = _tmp4_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static void canvas_handle_puzzle_change (Canvas* self, MultPuzzle* p) {
	gchar* _tmp0_ = NULL;
	gchar* multiplicand;
	gchar* _tmp6_ = NULL;
	gchar* multiplier;
	gchar* _tmp20_ = NULL;
	gchar* answer;
	gint _tmp26_;
	gboolean* _tmp27_ = NULL;
	gboolean* unknown;
	gint unknown_length1;
	gint _unknown_size_;
	gboolean _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->mult_boxes);
	self->priv->mult_boxes = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->digit_boxes);
	self->priv->digit_boxes = NULL;
	_tmp0_ = mult_puzzle_get_multiplicand (self->priv->_puzzle);
	multiplicand = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gchar _tmp3_;
				CharBox* _tmp4_ = NULL;
				CharBox* _tmp5_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				_tmp2_ = strlen (multiplicand);
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = string_get (multiplicand, (glong) i);
				_tmp4_ = canvas_create_mult_box (self, (gunichar) _tmp3_);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (self->priv->xboxes[i]);
				self->priv->xboxes[i] = _tmp5_;
				gtk_widget_show_all ((GtkWidget*) self->priv->xboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->xboxes[i]);
			}
		}
	}
	_tmp6_ = mult_puzzle_get_multiplier (self->priv->_puzzle);
	multiplier = _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				gchar _tmp9_;
				CharBox* _tmp10_ = NULL;
				CharBox* _tmp11_;
				if (!_tmp7_) {
					i = i + 1;
				}
				_tmp7_ = FALSE;
				_tmp8_ = strlen (multiplier);
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = string_get (multiplier, (glong) i);
				_tmp10_ = canvas_create_mult_box (self, (gunichar) _tmp9_);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (self->priv->yboxes[i]);
				self->priv->yboxes[i] = _tmp11_;
				gtk_widget_show_all ((GtkWidget*) self->priv->yboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->yboxes[i]);
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				guint _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* addend;
				if (!_tmp12_) {
					i = i + 1;
				}
				_tmp12_ = FALSE;
				_tmp13_ = mult_puzzle_get_num_addends (self->priv->_puzzle);
				if (!(i < _tmp13_)) {
					break;
				}
				_tmp14_ = mult_puzzle_get_addend (self->priv->_puzzle, i);
				addend = _tmp14_;
				{
					gint j;
					j = 0;
					{
						gboolean _tmp15_;
						_tmp15_ = TRUE;
						while (TRUE) {
							gint _tmp16_;
							gchar _tmp17_;
							CharBox* _tmp18_ = NULL;
							CharBox* _tmp19_;
							if (!_tmp15_) {
								j = j + 1;
							}
							_tmp15_ = FALSE;
							_tmp16_ = strlen (addend);
							if (!(j < _tmp16_)) {
								break;
							}
							_tmp17_ = string_get (addend, (glong) j);
							_tmp18_ = canvas_create_mult_box (self, (gunichar) _tmp17_);
							_tmp19_ = _tmp18_;
							_g_object_unref0 (self->priv->addboxes[i].array[j]);
							self->priv->addboxes[i].array[j] = _tmp19_;
							gtk_widget_show_all ((GtkWidget*) self->priv->addboxes[i].array[j]);
							gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->addboxes[i].array[j]);
						}
					}
				}
				_g_free0 (addend);
			}
		}
	}
	_tmp20_ = mult_puzzle_get_answer (self->priv->_puzzle);
	answer = _tmp20_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				gchar _tmp23_;
				CharBox* _tmp24_ = NULL;
				CharBox* _tmp25_;
				if (!_tmp21_) {
					i = i + 1;
				}
				_tmp21_ = FALSE;
				_tmp22_ = strlen (answer);
				if (!(i < _tmp22_)) {
					break;
				}
				_tmp23_ = string_get (answer, (glong) i);
				_tmp24_ = canvas_create_mult_box (self, (gunichar) _tmp23_);
				_tmp25_ = _tmp24_;
				_g_object_unref0 (self->priv->zboxes[i]);
				self->priv->zboxes[i] = _tmp25_;
				gtk_widget_show_all ((GtkWidget*) self->priv->zboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->zboxes[i]);
			}
		}
	}
	_tmp27_ = mult_puzzle_get_unknown_digits (self->priv->_puzzle, &_tmp26_);
	unknown = _tmp27_;
	unknown_length1 = _tmp26_;
	_unknown_size_ = _tmp26_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp28_;
			_tmp28_ = TRUE;
			while (TRUE) {
				CharBox* _tmp29_ = NULL;
				CharBox* _tmp30_;
				if (!_tmp28_) {
					i++;
				}
				_tmp28_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				_tmp29_ = canvas_create_digit_box (self, unknown, unknown_length1, i);
				_tmp30_ = _tmp29_;
				_g_object_unref0 (self->priv->digitboxes[i]);
				self->priv->digitboxes[i] = _tmp30_;
				gtk_widget_show_all ((GtkWidget*) self->priv->digitboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->digitboxes[i]);
			}
		}
	}
	_tmp31_ = mult_puzzle_get_is_done (p);
	if (_tmp31_) {
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp32_;
				_tmp32_ = TRUE;
				while (TRUE) {
					if (!_tmp32_) {
						i++;
					}
					_tmp32_ = FALSE;
					if (!(i < 10)) {
						break;
					}
					char_box_set_highlight (self->priv->digitboxes[i], GTK_STATE_FLAG_INSENSITIVE);
				}
			}
		}
	}
	unknown = (g_free (unknown), NULL);
	_g_free0 (answer);
	_g_free0 (multiplier);
	_g_free0 (multiplicand);
}


void canvas_highlight_box (Canvas* self, CharBox* box, gboolean digit_box, gboolean hover, gboolean all) {
	CanvasMode _tmp5_ = 0;
	CanvasMode native_mode;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	if (all) {
		GList* _tmp0_ = NULL;
		GList* boxes;
		if (digit_box) {
			_tmp0_ = self->priv->digit_boxes;
		} else {
			_tmp0_ = self->priv->mult_boxes;
		}
		boxes = _tmp0_;
		{
			GList* b_collection;
			GList* b_it;
			b_collection = boxes;
			for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
				CharBox* _tmp1_;
				CharBox* b;
				_tmp1_ = _g_object_ref0 ((CharBox*) b_it->data);
				b = _tmp1_;
				{
					gboolean _tmp2_ = FALSE;
					if (b != box) {
						const gchar* _tmp3_ = NULL;
						const gchar* _tmp4_ = NULL;
						_tmp3_ = char_box_get_letter (b);
						_tmp4_ = char_box_get_letter (box);
						_tmp2_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						canvas_highlight_box (self, b, digit_box, hover, FALSE);
					}
					_g_object_unref0 (b);
				}
			}
		}
	}
	if (digit_box) {
		_tmp5_ = CANVAS_MODE_DIGIT;
	} else {
		_tmp5_ = CANVAS_MODE_CHAR;
	}
	native_mode = _tmp5_;
	if (self->priv->mode == native_mode) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = char_box_get_letter (box);
		if (g_strcmp0 (self->priv->mode_letter, _tmp6_) == 0) {
			char_box_set_highlight (box, GTK_STATE_FLAG_ACTIVE);
			return;
		}
	} else {
		if (self->priv->mode != CANVAS_MODE_NONE) {
			if (digit_box) {
				gint _tmp7_;
				gboolean* _tmp8_ = NULL;
				gboolean* unknowns;
				gint unknowns_length1;
				gint _unknowns_size_;
				gchar _tmp9_;
				gint _tmp10_;
				gboolean* _tmp11_ = NULL;
				gboolean* guesses;
				gint guesses_length1;
				gint _guesses_size_;
				const gchar* _tmp12_ = NULL;
				gchar _tmp13_;
				gint _tmp14_;
				gint digit;
				gboolean _tmp15_ = FALSE;
				_tmp8_ = mult_puzzle_get_unknown_digits (self->priv->_puzzle, &_tmp7_);
				unknowns = _tmp8_;
				unknowns_length1 = _tmp7_;
				_unknowns_size_ = _tmp7_;
				_tmp9_ = string_get (self->priv->mode_letter, (glong) 0);
				_tmp11_ = mult_puzzle_get_letter_guesses (self->priv->_puzzle, (MultPuzzleChar) _tmp9_, &_tmp10_);
				guesses = _tmp11_;
				guesses_length1 = _tmp10_;
				_guesses_size_ = _tmp10_;
				_tmp12_ = char_box_get_letter (box);
				_tmp13_ = string_get (_tmp12_, (glong) 0);
				_tmp14_ = g_ascii_digit_value (_tmp13_);
				digit = _tmp14_;
				if (!unknowns[digit]) {
					_tmp15_ = TRUE;
				} else {
					_tmp15_ = guesses[digit];
				}
				if (_tmp15_) {
					char_box_set_highlight (box, GTK_STATE_FLAG_INSENSITIVE);
					guesses = (g_free (guesses), NULL);
					unknowns = (g_free (unknowns), NULL);
					return;
				}
				guesses = (g_free (guesses), NULL);
				unknowns = (g_free (unknowns), NULL);
			} else {
				gchar _tmp16_;
				gint _tmp17_;
				gint digit;
				const gchar* _tmp18_ = NULL;
				gchar _tmp19_;
				gint _tmp20_;
				gboolean* _tmp21_ = NULL;
				gboolean* _tmp22_;
				gint _tmp22__length1;
				gboolean _tmp23_;
				_tmp16_ = string_get (self->priv->mode_letter, (glong) 0);
				_tmp17_ = g_ascii_digit_value (_tmp16_);
				digit = _tmp17_;
				_tmp18_ = char_box_get_letter (box);
				_tmp19_ = string_get (_tmp18_, (glong) 0);
				_tmp21_ = mult_puzzle_get_letter_guesses (self->priv->_puzzle, (MultPuzzleChar) _tmp19_, &_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp22__length1 = _tmp20_;
				_tmp23_ = _tmp22_[digit];
				_tmp22_ = (g_free (_tmp22_), NULL);
				if (_tmp23_) {
					char_box_set_highlight (box, GTK_STATE_FLAG_INSENSITIVE);
					return;
				}
			}
			if (hover) {
				char_box_set_highlight (box, GTK_STATE_FLAG_PRELIGHT);
				return;
			}
		} else {
			if (hover) {
				char_box_set_highlight (box, GTK_STATE_FLAG_PRELIGHT);
				return;
			}
		}
	}
	char_box_set_highlight (box, GTK_STATE_FLAG_NORMAL);
}


static gboolean canvas_handle_release (Canvas* self, CharBox* box, GdkEventButton* event, gboolean digit_box) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp1_;
	gint _tmp2_;
	GdkWindow* _tmp3_ = NULL;
	gint _tmp4_;
	GdkWindow* _tmp5_ = NULL;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) box);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	gtk_widget_get_pointer ((GtkWidget*) box, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp4_ = gdk_window_get_width (_tmp3_);
	w = _tmp4_;
	_tmp5_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp6_ = gdk_window_get_height (_tmp5_);
	h = _tmp6_;
	_tmp8_ = CLAMP (x, 0, w);
	if (_tmp8_ != x) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_;
		_tmp9_ = CLAMP (y, 0, h);
		_tmp7_ = _tmp9_ != y;
	}
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	if ((*event).button == 1) {
		if (digit_box) {
			canvas_start_digit_choice (self, box);
		} else {
			canvas_start_char_choice (self, box);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean canvas_handle_none_release (Canvas* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp0_;
	gint _tmp1_;
	GdkWindow* _tmp2_ = NULL;
	gint _tmp3_;
	GdkWindow* _tmp4_ = NULL;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_get_pointer ((GtkWidget*) self, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp3_ = gdk_window_get_width (_tmp2_);
	w = _tmp3_;
	_tmp4_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp5_ = gdk_window_get_height (_tmp4_);
	h = _tmp5_;
	_tmp7_ = CLAMP (x, 0, w);
	if (_tmp7_ != x) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp8_;
		_tmp8_ = CLAMP (y, 0, h);
		_tmp6_ = _tmp8_ != y;
	}
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	if ((*event).button == 1) {
		canvas_clear_mode (self);
	}
	result = TRUE;
	return result;
}


MultPuzzle* canvas_get_puzzle (Canvas* self) {
	MultPuzzle* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_puzzle;
	return result;
}


static void canvas_set_puzzle (Canvas* self, MultPuzzle* value) {
	MultPuzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp0_;
	g_object_notify ((GObject *) self, "puzzle");
}


GtkMult* canvas_get_mult (Canvas* self) {
	GtkMult* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mult;
	return result;
}


static void canvas_set_mult (Canvas* self, GtkMult* value) {
	GtkMult* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_mult);
	self->priv->_mult = _tmp0_;
	g_object_notify ((GObject *) self, "mult");
}


static gboolean _canvas_handle_none_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = canvas_handle_none_release (self, event);
	return result;
}


static void _canvas_handle_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	canvas_handle_size_allocate (self, allocation);
}


static void _canvas_handle_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self) {
	canvas_handle_puzzle_change (self, _sender);
}


static GObject * canvas_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Canvas * self;
	MultPuzzle* _tmp0_ = NULL;
	GtkFixed* _tmp1_ = NULL;
	GtkVSeparator* _tmp2_ = NULL;
	GtkHSeparator* _tmp3_ = NULL;
	GtkHSeparator* _tmp4_ = NULL;
	CharBox* _tmp5_ = NULL;
	CharBox* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* x;
	gchar* _tmp8_ = NULL;
	gchar* y;
	gchar* _tmp9_ = NULL;
	gchar* z;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	CharBox** _tmp13_ = NULL;
	gint _tmp14_;
	CharBox** _tmp15_ = NULL;
	gint _tmp16_;
	CharBox** _tmp17_ = NULL;
	CharBox** _tmp18_ = NULL;
	guint _tmp19_;
	ArrayBox* _tmp20_ = NULL;
	gint vsep_width = 0;
	gint hsep1_height = 0;
	gint _tmp26_;
	parent_class = G_OBJECT_CLASS (canvas_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CANVAS (obj);
	_tmp0_ = gtk_mult_get_puzzle (self->priv->_mult);
	canvas_set_puzzle (self, _tmp0_);
	self->priv->mode = CANVAS_MODE_NONE;
	_g_free0 (self->priv->mode_letter);
	self->priv->mode_letter = NULL;
	self->priv->min_box_request = -1;
	__g_list_free__g_object_unref0_0 (self->priv->mult_boxes);
	self->priv->mult_boxes = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->digit_boxes);
	self->priv->digit_boxes = NULL;
	_tmp1_ = (GtkFixed*) gtk_fixed_new ();
	_g_object_unref0 (self->priv->fixed);
	self->priv->fixed = g_object_ref_sink (_tmp1_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->fixed);
	_tmp2_ = (GtkVSeparator*) gtk_vseparator_new ();
	_g_object_unref0 (self->priv->vsep);
	self->priv->vsep = (GtkWidget*) g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkHSeparator*) gtk_hseparator_new ();
	_g_object_unref0 (self->priv->hsep1);
	self->priv->hsep1 = (GtkWidget*) g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkHSeparator*) gtk_hseparator_new ();
	_g_object_unref0 (self->priv->hsep2);
	self->priv->hsep2 = (GtkWidget*) g_object_ref_sink (_tmp4_);
	gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->vsep);
	gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->hsep1);
	gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->hsep2);
	_tmp5_ = char_box_new ("+", GTK_SHADOW_NONE);
	_g_object_unref0 (self->priv->plusbox);
	self->priv->plusbox = g_object_ref_sink (_tmp5_);
	gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->plusbox);
	_tmp6_ = char_box_new ("×", GTK_SHADOW_NONE);
	_g_object_unref0 (self->priv->timesbox);
	self->priv->timesbox = g_object_ref_sink (_tmp6_);
	gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->timesbox);
	_tmp7_ = mult_puzzle_get_multiplicand (self->priv->_puzzle);
	x = _tmp7_;
	_tmp8_ = mult_puzzle_get_multiplier (self->priv->_puzzle);
	y = _tmp8_;
	_tmp9_ = mult_puzzle_get_answer (self->priv->_puzzle);
	z = _tmp9_;
	_tmp10_ = strlen (y);
	self->priv->num_box_rows = 3 + ((gint) _tmp10_);
	_tmp11_ = strlen (z);
	self->priv->num_box_cols = 1 + ((gint) _tmp11_);
	_tmp12_ = strlen (x);
	_tmp13_ = g_new0 (CharBox*, _tmp12_ + 1);
	self->priv->xboxes = (_vala_array_free (self->priv->xboxes, self->priv->xboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->xboxes = _tmp13_;
	self->priv->xboxes_length1 = _tmp12_;
	self->priv->_xboxes_size_ = _tmp12_;
	_tmp14_ = strlen (y);
	_tmp15_ = g_new0 (CharBox*, _tmp14_ + 1);
	self->priv->yboxes = (_vala_array_free (self->priv->yboxes, self->priv->yboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->yboxes = _tmp15_;
	self->priv->yboxes_length1 = _tmp14_;
	self->priv->_yboxes_size_ = _tmp14_;
	_tmp16_ = strlen (z);
	_tmp17_ = g_new0 (CharBox*, _tmp16_ + 1);
	self->priv->zboxes = (_vala_array_free (self->priv->zboxes, self->priv->zboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->zboxes = _tmp17_;
	self->priv->zboxes_length1 = _tmp16_;
	self->priv->_zboxes_size_ = _tmp16_;
	_tmp18_ = g_new0 (CharBox*, 10 + 1);
	self->priv->digitboxes = (_vala_array_free (self->priv->digitboxes, self->priv->digitboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->digitboxes = _tmp18_;
	self->priv->digitboxes_length1 = 10;
	self->priv->_digitboxes_size_ = 10;
	_tmp19_ = mult_puzzle_get_num_addends (self->priv->_puzzle);
	_tmp20_ = g_new0 (ArrayBox, _tmp19_);
	self->priv->addboxes = (_vala_ArrayBox_array_free (self->priv->addboxes, self->priv->addboxes_length1), NULL);
	self->priv->addboxes = _tmp20_;
	self->priv->addboxes_length1 = _tmp19_;
	self->priv->_addboxes_size_ = _tmp19_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gint _tmp24_;
				CharBox** _tmp25_ = NULL;
				if (!_tmp21_) {
					i = i + 1;
				}
				_tmp21_ = FALSE;
				if (!(i < self->priv->addboxes_length1)) {
					break;
				}
				_tmp22_ = mult_puzzle_get_addend (self->priv->_puzzle, i);
				_tmp23_ = _tmp22_;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = g_new0 (CharBox*, _tmp24_ + 1);
				self->priv->addboxes[i].array = (_vala_array_free (self->priv->addboxes[i].array, self->priv->addboxes[i].array_length1, (GDestroyNotify) g_object_unref), NULL);
				self->priv->addboxes[i].array = _tmp25_;
				self->priv->addboxes[i].array_length1 = _tmp24_;
				self->priv->addboxes[i]._array_size_ = _tmp24_;
				_g_free0 (_tmp23_);
			}
		}
	}
	gtk_widget_get_preferred_height (self->priv->hsep1, NULL, &_tmp26_);
	hsep1_height = _tmp26_;
	vsep_width = hsep1_height;
	self->priv->min_width = ((((12 + ((self->priv->num_box_cols - 1) * CANVAS_SPACING)) + CANVAS_SPACING) + vsep_width) + (CANVAS_SPACING * 4)) + 12;
	self->priv->min_height = ((12 + ((self->priv->num_box_rows + 1) * CANVAS_SPACING)) + (hsep1_height * 2)) + 12;
	gtk_widget_set_size_request ((GtkWidget*) self, self->priv->min_width, self->priv->min_height);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_RELEASE_MASK);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _canvas_handle_none_release_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->fixed, "size-allocate", (GCallback) _canvas_handle_size_allocate_gtk_widget_size_allocate, self, 0);
	canvas_handle_puzzle_change (self, self->priv->_puzzle);
	g_signal_connect_object (self->priv->_puzzle, "changed", (GCallback) _canvas_handle_puzzle_change_mult_puzzle_changed, self, 0);
	_g_free0 (z);
	_g_free0 (y);
	_g_free0 (x);
	return obj;
}


static void canvas_class_init (CanvasClass * klass) {
	canvas_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CanvasPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_canvas_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_canvas_set_property;
	G_OBJECT_CLASS (klass)->constructor = canvas_constructor;
	G_OBJECT_CLASS (klass)->finalize = canvas_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_MULT_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_MULT, g_param_spec_object ("mult", "mult", "mult", TYPE_GTK_MULT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void canvas_instance_init (Canvas * self) {
	self->priv = CANVAS_GET_PRIVATE (self);
}


static void canvas_finalize (GObject* obj) {
	Canvas * self;
	self = CANVAS (obj);
	_g_object_unref0 (self->priv->_puzzle);
	_g_object_unref0 (self->priv->_mult);
	_g_free0 (self->priv->mode_letter);
	_g_object_unref0 (self->priv->fixed);
	_g_object_unref0 (self->priv->vsep);
	_g_object_unref0 (self->priv->hsep1);
	_g_object_unref0 (self->priv->hsep2);
	__g_list_free__g_object_unref0_0 (self->priv->mult_boxes);
	__g_list_free__g_object_unref0_0 (self->priv->digit_boxes);
	self->priv->xboxes = (_vala_array_free (self->priv->xboxes, self->priv->xboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->yboxes = (_vala_array_free (self->priv->yboxes, self->priv->yboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->zboxes = (_vala_array_free (self->priv->zboxes, self->priv->zboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->addboxes = (_vala_ArrayBox_array_free (self->priv->addboxes, self->priv->addboxes_length1), NULL);
	self->priv->digitboxes = (_vala_array_free (self->priv->digitboxes, self->priv->digitboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->plusbox);
	_g_object_unref0 (self->priv->timesbox);
	G_OBJECT_CLASS (canvas_parent_class)->finalize (obj);
}


GType canvas_get_type (void) {
	static volatile gsize canvas_type_id__volatile = 0;
	if (g_once_init_enter (&canvas_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CanvasClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) canvas_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Canvas), 0, (GInstanceInitFunc) canvas_instance_init, NULL };
		GType canvas_type_id;
		canvas_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "Canvas", &g_define_type_info, 0);
		g_once_init_leave (&canvas_type_id__volatile, canvas_type_id);
	}
	return canvas_type_id__volatile;
}


static void _vala_canvas_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Canvas * self;
	self = CANVAS (object);
	switch (property_id) {
		case CANVAS_PUZZLE:
		g_value_set_object (value, canvas_get_puzzle (self));
		break;
		case CANVAS_MULT:
		g_value_set_object (value, canvas_get_mult (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_canvas_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Canvas * self;
	self = CANVAS (object);
	switch (property_id) {
		case CANVAS_PUZZLE:
		canvas_set_puzzle (self, g_value_get_object (value));
		break;
		case CANVAS_MULT:
		canvas_set_mult (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



