# frozen_string_literal: true

class RemoveOrganizationsVulnerabilityExportPartsOrganizationIdFk < Gitlab::Database::Migration[2.2]
  milestone '17.3'
  disable_ddl_transaction!

  FOREIGN_KEY_NAME = "fk_rails_feaf890d7a"

  def up
    with_lock_retries do
      remove_foreign_key_if_exists(:vulnerability_export_parts, :organizations,
        name: FOREIGN_KEY_NAME, reverse_lock_order: true)
    end
  end

  def down
    add_concurrent_foreign_key(:vulnerability_export_parts, :organizations,
      name: FOREIGN_KEY_NAME, column: :organization_id,
      target_column: :id, on_delete: :cascade)
  end
end
