//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FileServersClient contains the methods for the FileServers group.
// Don't use this type directly, use NewFileServersClient() instead.
type FileServersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewFileServersClient creates a new instance of FileServersClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewFileServersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FileServersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &FileServersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginBackupNow - Backup the file server now.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// fileServerName - The file server name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - FileServersClientBeginBackupNowOptions contains the optional parameters for the FileServersClient.BeginBackupNow
// method.
func (client *FileServersClient) BeginBackupNow(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientBeginBackupNowOptions) (*runtime.Poller[FileServersClientBackupNowResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.backupNow(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[FileServersClientBackupNowResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[FileServersClientBackupNowResponse](options.ResumeToken, client.pl, nil)
	}
}

// BackupNow - Backup the file server now.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *FileServersClient) backupNow(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientBeginBackupNowOptions) (*http.Response, error) {
	req, err := client.backupNowCreateRequest(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// backupNowCreateRequest creates the BackupNow request.
func (client *FileServersClient) backupNowCreateRequest(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientBeginBackupNowOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/backup"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginCreateOrUpdate - Creates or updates the file server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// fileServerName - The file server name.
// resourceGroupName - The resource group name
// managerName - The manager name
// fileServer - The file server.
// options - FileServersClientBeginCreateOrUpdateOptions contains the optional parameters for the FileServersClient.BeginCreateOrUpdate
// method.
func (client *FileServersClient) BeginCreateOrUpdate(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, fileServer FileServer, options *FileServersClientBeginCreateOrUpdateOptions) (*runtime.Poller[FileServersClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, deviceName, fileServerName, resourceGroupName, managerName, fileServer, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[FileServersClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[FileServersClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Creates or updates the file server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *FileServersClient) createOrUpdate(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, fileServer FileServer, options *FileServersClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, deviceName, fileServerName, resourceGroupName, managerName, fileServer, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *FileServersClient) createOrUpdateCreateRequest(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, fileServer FileServer, options *FileServersClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, fileServer)
}

// BeginDelete - Deletes the file server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// fileServerName - The file server name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - FileServersClientBeginDeleteOptions contains the optional parameters for the FileServersClient.BeginDelete method.
func (client *FileServersClient) BeginDelete(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientBeginDeleteOptions) (*runtime.Poller[FileServersClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[FileServersClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[FileServersClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the file server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *FileServersClient) deleteOperation(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *FileServersClient) deleteCreateRequest(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns the properties of the specified file server name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// fileServerName - The file server name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - FileServersClientGetOptions contains the optional parameters for the FileServersClient.Get method.
func (client *FileServersClient) Get(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientGetOptions) (FileServersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
	if err != nil {
		return FileServersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return FileServersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return FileServersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *FileServersClient) getCreateRequest(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FileServersClient) getHandleResponse(resp *http.Response) (FileServersClientGetResponse, error) {
	result := FileServersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileServer); err != nil {
		return FileServersClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDevicePager - Retrieves all the file servers in a device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - FileServersClientListByDeviceOptions contains the optional parameters for the FileServersClient.ListByDevice
// method.
func (client *FileServersClient) NewListByDevicePager(deviceName string, resourceGroupName string, managerName string, options *FileServersClientListByDeviceOptions) *runtime.Pager[FileServersClientListByDeviceResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileServersClientListByDeviceResponse]{
		More: func(page FileServersClientListByDeviceResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileServersClientListByDeviceResponse) (FileServersClientListByDeviceResponse, error) {
			req, err := client.listByDeviceCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return FileServersClientListByDeviceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return FileServersClientListByDeviceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileServersClientListByDeviceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDeviceHandleResponse(resp)
		},
	})
}

// listByDeviceCreateRequest creates the ListByDevice request.
func (client *FileServersClient) listByDeviceCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *FileServersClientListByDeviceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDeviceHandleResponse handles the ListByDevice response.
func (client *FileServersClient) listByDeviceHandleResponse(resp *http.Response) (FileServersClientListByDeviceResponse, error) {
	result := FileServersClientListByDeviceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileServerList); err != nil {
		return FileServersClientListByDeviceResponse{}, err
	}
	return result, nil
}

// NewListByManagerPager - Retrieves all the file servers in a manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - FileServersClientListByManagerOptions contains the optional parameters for the FileServersClient.ListByManager
// method.
func (client *FileServersClient) NewListByManagerPager(resourceGroupName string, managerName string, options *FileServersClientListByManagerOptions) *runtime.Pager[FileServersClientListByManagerResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileServersClientListByManagerResponse]{
		More: func(page FileServersClientListByManagerResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileServersClientListByManagerResponse) (FileServersClientListByManagerResponse, error) {
			req, err := client.listByManagerCreateRequest(ctx, resourceGroupName, managerName, options)
			if err != nil {
				return FileServersClientListByManagerResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return FileServersClientListByManagerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileServersClientListByManagerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByManagerHandleResponse(resp)
		},
	})
}

// listByManagerCreateRequest creates the ListByManager request.
func (client *FileServersClient) listByManagerCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *FileServersClientListByManagerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/fileservers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByManagerHandleResponse handles the ListByManager response.
func (client *FileServersClient) listByManagerHandleResponse(resp *http.Response) (FileServersClientListByManagerResponse, error) {
	result := FileServersClientListByManagerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileServerList); err != nil {
		return FileServersClientListByManagerResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Retrieves metric definitions of all metrics aggregated at the file server.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the device.
// fileServerName - The name of the file server.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - FileServersClientListMetricDefinitionOptions contains the optional parameters for the FileServersClient.ListMetricDefinition
// method.
func (client *FileServersClient) NewListMetricDefinitionPager(deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientListMetricDefinitionOptions) *runtime.Pager[FileServersClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileServersClientListMetricDefinitionResponse]{
		More: func(page FileServersClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileServersClientListMetricDefinitionResponse) (FileServersClientListMetricDefinitionResponse, error) {
			req, err := client.listMetricDefinitionCreateRequest(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
			if err != nil {
				return FileServersClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return FileServersClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileServersClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *FileServersClient) listMetricDefinitionCreateRequest(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/metricsDefinitions"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *FileServersClient) listMetricDefinitionHandleResponse(resp *http.Response) (FileServersClientListMetricDefinitionResponse, error) {
	result := FileServersClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return FileServersClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Gets the file server metrics.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the device.
// fileServerName - The name of the file server name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - FileServersClientListMetricsOptions contains the optional parameters for the FileServersClient.ListMetrics method.
func (client *FileServersClient) NewListMetricsPager(deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientListMetricsOptions) *runtime.Pager[FileServersClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileServersClientListMetricsResponse]{
		More: func(page FileServersClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileServersClientListMetricsResponse) (FileServersClientListMetricsResponse, error) {
			req, err := client.listMetricsCreateRequest(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
			if err != nil {
				return FileServersClientListMetricsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return FileServersClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileServersClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *FileServersClient) listMetricsCreateRequest(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileServersClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/metrics"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *FileServersClient) listMetricsHandleResponse(resp *http.Response) (FileServersClientListMetricsResponse, error) {
	result := FileServersClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return FileServersClientListMetricsResponse{}, err
	}
	return result, nil
}
