//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicefabric

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ApplicationDeltaHealthPolicy.
func (a ApplicationDeltaHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultServiceTypeDeltaHealthPolicy", a.DefaultServiceTypeDeltaHealthPolicy)
	populate(objectMap, "serviceTypeDeltaHealthPolicies", a.ServiceTypeDeltaHealthPolicies)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationHealthPolicy.
func (a ApplicationHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultServiceTypeHealthPolicy", a.DefaultServiceTypeHealthPolicy)
	populate(objectMap, "serviceTypeHealthPolicies", a.ServiceTypeHealthPolicies)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResource.
func (a ApplicationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceProperties.
func (a ApplicationResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managedIdentities", a.ManagedIdentities)
	populate(objectMap, "maximumNodes", a.MaximumNodes)
	populate(objectMap, "metrics", a.Metrics)
	populate(objectMap, "minimumNodes", a.MinimumNodes)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "removeApplicationCapacity", a.RemoveApplicationCapacity)
	populate(objectMap, "typeName", a.TypeName)
	populate(objectMap, "typeVersion", a.TypeVersion)
	populate(objectMap, "upgradePolicy", a.UpgradePolicy)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceUpdate.
func (a ApplicationResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceUpdateProperties.
func (a ApplicationResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managedIdentities", a.ManagedIdentities)
	populate(objectMap, "maximumNodes", a.MaximumNodes)
	populate(objectMap, "metrics", a.Metrics)
	populate(objectMap, "minimumNodes", a.MinimumNodes)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "removeApplicationCapacity", a.RemoveApplicationCapacity)
	populate(objectMap, "typeVersion", a.TypeVersion)
	populate(objectMap, "upgradePolicy", a.UpgradePolicy)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeResource.
func (a ApplicationTypeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeVersionResource.
func (a ApplicationTypeVersionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationTypeVersionResourceProperties.
func (a ApplicationTypeVersionResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appPackageUrl", a.AppPackageURL)
	populate(objectMap, "defaultParameterList", a.DefaultParameterList)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArmApplicationHealthPolicy.
func (a ArmApplicationHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "considerWarningAsError", a.ConsiderWarningAsError)
	populate(objectMap, "defaultServiceTypeHealthPolicy", a.DefaultServiceTypeHealthPolicy)
	populate(objectMap, "maxPercentUnhealthyDeployedApplications", a.MaxPercentUnhealthyDeployedApplications)
	populate(objectMap, "serviceTypeHealthPolicyMap", a.ServiceTypeHealthPolicyMap)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ClusterHealthPolicy.
func (c ClusterHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationHealthPolicies", c.ApplicationHealthPolicies)
	populate(objectMap, "maxPercentUnhealthyApplications", c.MaxPercentUnhealthyApplications)
	populate(objectMap, "maxPercentUnhealthyNodes", c.MaxPercentUnhealthyNodes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ClusterProperties.
func (c ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "addOnFeatures", c.AddOnFeatures)
	populate(objectMap, "applicationTypeVersionsCleanupPolicy", c.ApplicationTypeVersionsCleanupPolicy)
	populate(objectMap, "availableClusterVersions", c.AvailableClusterVersions)
	populate(objectMap, "azureActiveDirectory", c.AzureActiveDirectory)
	populate(objectMap, "certificate", c.Certificate)
	populate(objectMap, "certificateCommonNames", c.CertificateCommonNames)
	populate(objectMap, "clientCertificateCommonNames", c.ClientCertificateCommonNames)
	populate(objectMap, "clientCertificateThumbprints", c.ClientCertificateThumbprints)
	populate(objectMap, "clusterCodeVersion", c.ClusterCodeVersion)
	populate(objectMap, "clusterEndpoint", c.ClusterEndpoint)
	populate(objectMap, "clusterId", c.ClusterID)
	populate(objectMap, "clusterState", c.ClusterState)
	populate(objectMap, "diagnosticsStorageAccountConfig", c.DiagnosticsStorageAccountConfig)
	populate(objectMap, "eventStoreServiceEnabled", c.EventStoreServiceEnabled)
	populate(objectMap, "fabricSettings", c.FabricSettings)
	populate(objectMap, "infrastructureServiceManager", c.InfrastructureServiceManager)
	populate(objectMap, "managementEndpoint", c.ManagementEndpoint)
	populate(objectMap, "nodeTypes", c.NodeTypes)
	populate(objectMap, "notifications", c.Notifications)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "reliabilityLevel", c.ReliabilityLevel)
	populate(objectMap, "reverseProxyCertificate", c.ReverseProxyCertificate)
	populate(objectMap, "reverseProxyCertificateCommonNames", c.ReverseProxyCertificateCommonNames)
	populate(objectMap, "sfZonalUpgradeMode", c.SfZonalUpgradeMode)
	populate(objectMap, "upgradeDescription", c.UpgradeDescription)
	populate(objectMap, "upgradeMode", c.UpgradeMode)
	populateTimeRFC3339(objectMap, "upgradePauseEndTimestampUtc", c.UpgradePauseEndTimestampUTC)
	populateTimeRFC3339(objectMap, "upgradePauseStartTimestampUtc", c.UpgradePauseStartTimestampUTC)
	populate(objectMap, "upgradeWave", c.UpgradeWave)
	populate(objectMap, "vmImage", c.VMImage)
	populate(objectMap, "vmssZonalUpgradeMode", c.VmssZonalUpgradeMode)
	populate(objectMap, "waveUpgradePaused", c.WaveUpgradePaused)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterProperties.
func (c *ClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addOnFeatures":
			err = unpopulate(val, "AddOnFeatures", &c.AddOnFeatures)
			delete(rawMsg, key)
		case "applicationTypeVersionsCleanupPolicy":
			err = unpopulate(val, "ApplicationTypeVersionsCleanupPolicy", &c.ApplicationTypeVersionsCleanupPolicy)
			delete(rawMsg, key)
		case "availableClusterVersions":
			err = unpopulate(val, "AvailableClusterVersions", &c.AvailableClusterVersions)
			delete(rawMsg, key)
		case "azureActiveDirectory":
			err = unpopulate(val, "AzureActiveDirectory", &c.AzureActiveDirectory)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "certificateCommonNames":
			err = unpopulate(val, "CertificateCommonNames", &c.CertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateCommonNames":
			err = unpopulate(val, "ClientCertificateCommonNames", &c.ClientCertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateThumbprints":
			err = unpopulate(val, "ClientCertificateThumbprints", &c.ClientCertificateThumbprints)
			delete(rawMsg, key)
		case "clusterCodeVersion":
			err = unpopulate(val, "ClusterCodeVersion", &c.ClusterCodeVersion)
			delete(rawMsg, key)
		case "clusterEndpoint":
			err = unpopulate(val, "ClusterEndpoint", &c.ClusterEndpoint)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &c.ClusterID)
			delete(rawMsg, key)
		case "clusterState":
			err = unpopulate(val, "ClusterState", &c.ClusterState)
			delete(rawMsg, key)
		case "diagnosticsStorageAccountConfig":
			err = unpopulate(val, "DiagnosticsStorageAccountConfig", &c.DiagnosticsStorageAccountConfig)
			delete(rawMsg, key)
		case "eventStoreServiceEnabled":
			err = unpopulate(val, "EventStoreServiceEnabled", &c.EventStoreServiceEnabled)
			delete(rawMsg, key)
		case "fabricSettings":
			err = unpopulate(val, "FabricSettings", &c.FabricSettings)
			delete(rawMsg, key)
		case "infrastructureServiceManager":
			err = unpopulate(val, "InfrastructureServiceManager", &c.InfrastructureServiceManager)
			delete(rawMsg, key)
		case "managementEndpoint":
			err = unpopulate(val, "ManagementEndpoint", &c.ManagementEndpoint)
			delete(rawMsg, key)
		case "nodeTypes":
			err = unpopulate(val, "NodeTypes", &c.NodeTypes)
			delete(rawMsg, key)
		case "notifications":
			err = unpopulate(val, "Notifications", &c.Notifications)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "reliabilityLevel":
			err = unpopulate(val, "ReliabilityLevel", &c.ReliabilityLevel)
			delete(rawMsg, key)
		case "reverseProxyCertificate":
			err = unpopulate(val, "ReverseProxyCertificate", &c.ReverseProxyCertificate)
			delete(rawMsg, key)
		case "reverseProxyCertificateCommonNames":
			err = unpopulate(val, "ReverseProxyCertificateCommonNames", &c.ReverseProxyCertificateCommonNames)
			delete(rawMsg, key)
		case "sfZonalUpgradeMode":
			err = unpopulate(val, "SfZonalUpgradeMode", &c.SfZonalUpgradeMode)
			delete(rawMsg, key)
		case "upgradeDescription":
			err = unpopulate(val, "UpgradeDescription", &c.UpgradeDescription)
			delete(rawMsg, key)
		case "upgradeMode":
			err = unpopulate(val, "UpgradeMode", &c.UpgradeMode)
			delete(rawMsg, key)
		case "upgradePauseEndTimestampUtc":
			err = unpopulateTimeRFC3339(val, "UpgradePauseEndTimestampUTC", &c.UpgradePauseEndTimestampUTC)
			delete(rawMsg, key)
		case "upgradePauseStartTimestampUtc":
			err = unpopulateTimeRFC3339(val, "UpgradePauseStartTimestampUTC", &c.UpgradePauseStartTimestampUTC)
			delete(rawMsg, key)
		case "upgradeWave":
			err = unpopulate(val, "UpgradeWave", &c.UpgradeWave)
			delete(rawMsg, key)
		case "vmImage":
			err = unpopulate(val, "VMImage", &c.VMImage)
			delete(rawMsg, key)
		case "vmssZonalUpgradeMode":
			err = unpopulate(val, "VmssZonalUpgradeMode", &c.VmssZonalUpgradeMode)
			delete(rawMsg, key)
		case "waveUpgradePaused":
			err = unpopulate(val, "WaveUpgradePaused", &c.WaveUpgradePaused)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPropertiesUpdateParameters.
func (c ClusterPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "addOnFeatures", c.AddOnFeatures)
	populate(objectMap, "applicationTypeVersionsCleanupPolicy", c.ApplicationTypeVersionsCleanupPolicy)
	populate(objectMap, "certificate", c.Certificate)
	populate(objectMap, "certificateCommonNames", c.CertificateCommonNames)
	populate(objectMap, "clientCertificateCommonNames", c.ClientCertificateCommonNames)
	populate(objectMap, "clientCertificateThumbprints", c.ClientCertificateThumbprints)
	populate(objectMap, "clusterCodeVersion", c.ClusterCodeVersion)
	populate(objectMap, "eventStoreServiceEnabled", c.EventStoreServiceEnabled)
	populate(objectMap, "fabricSettings", c.FabricSettings)
	populate(objectMap, "infrastructureServiceManager", c.InfrastructureServiceManager)
	populate(objectMap, "nodeTypes", c.NodeTypes)
	populate(objectMap, "notifications", c.Notifications)
	populate(objectMap, "reliabilityLevel", c.ReliabilityLevel)
	populate(objectMap, "reverseProxyCertificate", c.ReverseProxyCertificate)
	populate(objectMap, "sfZonalUpgradeMode", c.SfZonalUpgradeMode)
	populate(objectMap, "upgradeDescription", c.UpgradeDescription)
	populate(objectMap, "upgradeMode", c.UpgradeMode)
	populateTimeRFC3339(objectMap, "upgradePauseEndTimestampUtc", c.UpgradePauseEndTimestampUTC)
	populateTimeRFC3339(objectMap, "upgradePauseStartTimestampUtc", c.UpgradePauseStartTimestampUTC)
	populate(objectMap, "upgradeWave", c.UpgradeWave)
	populate(objectMap, "vmssZonalUpgradeMode", c.VmssZonalUpgradeMode)
	populate(objectMap, "waveUpgradePaused", c.WaveUpgradePaused)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPropertiesUpdateParameters.
func (c *ClusterPropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addOnFeatures":
			err = unpopulate(val, "AddOnFeatures", &c.AddOnFeatures)
			delete(rawMsg, key)
		case "applicationTypeVersionsCleanupPolicy":
			err = unpopulate(val, "ApplicationTypeVersionsCleanupPolicy", &c.ApplicationTypeVersionsCleanupPolicy)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "certificateCommonNames":
			err = unpopulate(val, "CertificateCommonNames", &c.CertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateCommonNames":
			err = unpopulate(val, "ClientCertificateCommonNames", &c.ClientCertificateCommonNames)
			delete(rawMsg, key)
		case "clientCertificateThumbprints":
			err = unpopulate(val, "ClientCertificateThumbprints", &c.ClientCertificateThumbprints)
			delete(rawMsg, key)
		case "clusterCodeVersion":
			err = unpopulate(val, "ClusterCodeVersion", &c.ClusterCodeVersion)
			delete(rawMsg, key)
		case "eventStoreServiceEnabled":
			err = unpopulate(val, "EventStoreServiceEnabled", &c.EventStoreServiceEnabled)
			delete(rawMsg, key)
		case "fabricSettings":
			err = unpopulate(val, "FabricSettings", &c.FabricSettings)
			delete(rawMsg, key)
		case "infrastructureServiceManager":
			err = unpopulate(val, "InfrastructureServiceManager", &c.InfrastructureServiceManager)
			delete(rawMsg, key)
		case "nodeTypes":
			err = unpopulate(val, "NodeTypes", &c.NodeTypes)
			delete(rawMsg, key)
		case "notifications":
			err = unpopulate(val, "Notifications", &c.Notifications)
			delete(rawMsg, key)
		case "reliabilityLevel":
			err = unpopulate(val, "ReliabilityLevel", &c.ReliabilityLevel)
			delete(rawMsg, key)
		case "reverseProxyCertificate":
			err = unpopulate(val, "ReverseProxyCertificate", &c.ReverseProxyCertificate)
			delete(rawMsg, key)
		case "sfZonalUpgradeMode":
			err = unpopulate(val, "SfZonalUpgradeMode", &c.SfZonalUpgradeMode)
			delete(rawMsg, key)
		case "upgradeDescription":
			err = unpopulate(val, "UpgradeDescription", &c.UpgradeDescription)
			delete(rawMsg, key)
		case "upgradeMode":
			err = unpopulate(val, "UpgradeMode", &c.UpgradeMode)
			delete(rawMsg, key)
		case "upgradePauseEndTimestampUtc":
			err = unpopulateTimeRFC3339(val, "UpgradePauseEndTimestampUTC", &c.UpgradePauseEndTimestampUTC)
			delete(rawMsg, key)
		case "upgradePauseStartTimestampUtc":
			err = unpopulateTimeRFC3339(val, "UpgradePauseStartTimestampUTC", &c.UpgradePauseStartTimestampUTC)
			delete(rawMsg, key)
		case "upgradeWave":
			err = unpopulate(val, "UpgradeWave", &c.UpgradeWave)
			delete(rawMsg, key)
		case "vmssZonalUpgradeMode":
			err = unpopulate(val, "VmssZonalUpgradeMode", &c.VmssZonalUpgradeMode)
			delete(rawMsg, key)
		case "waveUpgradePaused":
			err = unpopulate(val, "WaveUpgradePaused", &c.WaveUpgradePaused)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpdateParameters.
func (c ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpgradeDeltaHealthPolicy.
func (c ClusterUpgradeDeltaHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationDeltaHealthPolicies", c.ApplicationDeltaHealthPolicies)
	populate(objectMap, "maxPercentDeltaUnhealthyApplications", c.MaxPercentDeltaUnhealthyApplications)
	populate(objectMap, "maxPercentDeltaUnhealthyNodes", c.MaxPercentDeltaUnhealthyNodes)
	populate(objectMap, "maxPercentUpgradeDomainDeltaUnhealthyNodes", c.MaxPercentUpgradeDomainDeltaUnhealthyNodes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentity.
func (m ManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamedPartitionSchemeDescription.
func (n NamedPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "count", n.Count)
	populate(objectMap, "names", n.Names)
	objectMap["partitionScheme"] = PartitionSchemeNamed
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedPartitionSchemeDescription.
func (n *NamedPartitionSchemeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		case "names":
			err = unpopulate(val, "Names", &n.Names)
			delete(rawMsg, key)
		case "partitionScheme":
			err = unpopulate(val, "PartitionScheme", &n.PartitionScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeTypeDescription.
func (n NodeTypeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationPorts", n.ApplicationPorts)
	populate(objectMap, "capacities", n.Capacities)
	populate(objectMap, "clientConnectionEndpointPort", n.ClientConnectionEndpointPort)
	populate(objectMap, "durabilityLevel", n.DurabilityLevel)
	populate(objectMap, "ephemeralPorts", n.EphemeralPorts)
	populate(objectMap, "httpGatewayEndpointPort", n.HTTPGatewayEndpointPort)
	populate(objectMap, "isPrimary", n.IsPrimary)
	populate(objectMap, "isStateless", n.IsStateless)
	populate(objectMap, "multipleAvailabilityZones", n.MultipleAvailabilityZones)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "placementProperties", n.PlacementProperties)
	populate(objectMap, "reverseProxyEndpointPort", n.ReverseProxyEndpointPort)
	populate(objectMap, "vmInstanceCount", n.VMInstanceCount)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Notification.
func (n Notification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isEnabled", n.IsEnabled)
	populate(objectMap, "notificationCategory", n.NotificationCategory)
	populate(objectMap, "notificationLevel", n.NotificationLevel)
	populate(objectMap, "notificationTargets", n.NotificationTargets)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NotificationTarget.
func (n NotificationTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "notificationChannel", n.NotificationChannel)
	populate(objectMap, "receivers", n.Receivers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerCertificateCommonNames.
func (s ServerCertificateCommonNames) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commonNames", s.CommonNames)
	populate(objectMap, "x509StoreName", s.X509StoreName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResource.
func (s ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResource.
func (s *ServiceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalServiceResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceProperties.
func (s ServiceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "partitionDescription", s.PartitionDescription)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "serviceDnsName", s.ServiceDNSName)
	objectMap["serviceKind"] = s.ServiceKind
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePackageActivationMode", s.ServicePackageActivationMode)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populate(objectMap, "serviceTypeName", s.ServiceTypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceProperties.
func (s *ServiceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "partitionDescription":
			s.PartitionDescription, err = unmarshalPartitionSchemeDescriptionClassification(val)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "serviceDnsName":
			err = unpopulate(val, "ServiceDNSName", &s.ServiceDNSName)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePackageActivationMode":
			err = unpopulate(val, "ServicePackageActivationMode", &s.ServicePackageActivationMode)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "serviceTypeName":
			err = unpopulate(val, "ServiceTypeName", &s.ServiceTypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourcePropertiesBase.
func (s ServiceResourcePropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourcePropertiesBase.
func (s *ServiceResourcePropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceUpdate.
func (s ServiceResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceUpdate.
func (s *ServiceResourceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalServiceResourceUpdatePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceUpdateProperties.
func (s ServiceResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	objectMap["serviceKind"] = s.ServiceKind
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceUpdateProperties.
func (s *ServiceResourceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SettingsSectionDescription.
func (s SettingsSectionDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "parameters", s.Parameters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SingletonPartitionSchemeDescription.
func (s SingletonPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["partitionScheme"] = PartitionSchemeSingleton
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingletonPartitionSchemeDescription.
func (s *SingletonPartitionSchemeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "partitionScheme":
			err = unpopulate(val, "PartitionScheme", &s.PartitionScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatefulServiceProperties.
func (s StatefulServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "hasPersistedState", s.HasPersistedState)
	populate(objectMap, "minReplicaSetSize", s.MinReplicaSetSize)
	populate(objectMap, "partitionDescription", s.PartitionDescription)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populateTimeRFC3339(objectMap, "quorumLossWaitDuration", s.QuorumLossWaitDuration)
	populateTimeRFC3339(objectMap, "replicaRestartWaitDuration", s.ReplicaRestartWaitDuration)
	populate(objectMap, "serviceDnsName", s.ServiceDNSName)
	objectMap["serviceKind"] = ServiceKindStateful
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePackageActivationMode", s.ServicePackageActivationMode)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populate(objectMap, "serviceTypeName", s.ServiceTypeName)
	populateTimeRFC3339(objectMap, "standByReplicaKeepDuration", s.StandByReplicaKeepDuration)
	populate(objectMap, "targetReplicaSetSize", s.TargetReplicaSetSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatefulServiceProperties.
func (s *StatefulServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "hasPersistedState":
			err = unpopulate(val, "HasPersistedState", &s.HasPersistedState)
			delete(rawMsg, key)
		case "minReplicaSetSize":
			err = unpopulate(val, "MinReplicaSetSize", &s.MinReplicaSetSize)
			delete(rawMsg, key)
		case "partitionDescription":
			s.PartitionDescription, err = unmarshalPartitionSchemeDescriptionClassification(val)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "quorumLossWaitDuration":
			err = unpopulateTimeRFC3339(val, "QuorumLossWaitDuration", &s.QuorumLossWaitDuration)
			delete(rawMsg, key)
		case "replicaRestartWaitDuration":
			err = unpopulateTimeRFC3339(val, "ReplicaRestartWaitDuration", &s.ReplicaRestartWaitDuration)
			delete(rawMsg, key)
		case "serviceDnsName":
			err = unpopulate(val, "ServiceDNSName", &s.ServiceDNSName)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePackageActivationMode":
			err = unpopulate(val, "ServicePackageActivationMode", &s.ServicePackageActivationMode)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "serviceTypeName":
			err = unpopulate(val, "ServiceTypeName", &s.ServiceTypeName)
			delete(rawMsg, key)
		case "standByReplicaKeepDuration":
			err = unpopulateTimeRFC3339(val, "StandByReplicaKeepDuration", &s.StandByReplicaKeepDuration)
			delete(rawMsg, key)
		case "targetReplicaSetSize":
			err = unpopulate(val, "TargetReplicaSetSize", &s.TargetReplicaSetSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatefulServiceUpdateProperties.
func (s StatefulServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "minReplicaSetSize", s.MinReplicaSetSize)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populateTimeRFC3339(objectMap, "quorumLossWaitDuration", s.QuorumLossWaitDuration)
	populateTimeRFC3339(objectMap, "replicaRestartWaitDuration", s.ReplicaRestartWaitDuration)
	objectMap["serviceKind"] = ServiceKindStateful
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populateTimeRFC3339(objectMap, "standByReplicaKeepDuration", s.StandByReplicaKeepDuration)
	populate(objectMap, "targetReplicaSetSize", s.TargetReplicaSetSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatefulServiceUpdateProperties.
func (s *StatefulServiceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "minReplicaSetSize":
			err = unpopulate(val, "MinReplicaSetSize", &s.MinReplicaSetSize)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "quorumLossWaitDuration":
			err = unpopulateTimeRFC3339(val, "QuorumLossWaitDuration", &s.QuorumLossWaitDuration)
			delete(rawMsg, key)
		case "replicaRestartWaitDuration":
			err = unpopulateTimeRFC3339(val, "ReplicaRestartWaitDuration", &s.ReplicaRestartWaitDuration)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "standByReplicaKeepDuration":
			err = unpopulateTimeRFC3339(val, "StandByReplicaKeepDuration", &s.StandByReplicaKeepDuration)
			delete(rawMsg, key)
		case "targetReplicaSetSize":
			err = unpopulate(val, "TargetReplicaSetSize", &s.TargetReplicaSetSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatelessServiceProperties.
func (s StatelessServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "instanceCloseDelayDuration", s.InstanceCloseDelayDuration)
	populate(objectMap, "instanceCount", s.InstanceCount)
	populate(objectMap, "partitionDescription", s.PartitionDescription)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "serviceDnsName", s.ServiceDNSName)
	objectMap["serviceKind"] = ServiceKindStateless
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePackageActivationMode", s.ServicePackageActivationMode)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	populate(objectMap, "serviceTypeName", s.ServiceTypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatelessServiceProperties.
func (s *StatelessServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "instanceCloseDelayDuration":
			err = unpopulate(val, "InstanceCloseDelayDuration", &s.InstanceCloseDelayDuration)
			delete(rawMsg, key)
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &s.InstanceCount)
			delete(rawMsg, key)
		case "partitionDescription":
			s.PartitionDescription, err = unmarshalPartitionSchemeDescriptionClassification(val)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "serviceDnsName":
			err = unpopulate(val, "ServiceDNSName", &s.ServiceDNSName)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePackageActivationMode":
			err = unpopulate(val, "ServicePackageActivationMode", &s.ServicePackageActivationMode)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		case "serviceTypeName":
			err = unpopulate(val, "ServiceTypeName", &s.ServiceTypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatelessServiceUpdateProperties.
func (s StatelessServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationScheme", s.CorrelationScheme)
	populate(objectMap, "defaultMoveCost", s.DefaultMoveCost)
	populate(objectMap, "instanceCloseDelayDuration", s.InstanceCloseDelayDuration)
	populate(objectMap, "instanceCount", s.InstanceCount)
	populate(objectMap, "placementConstraints", s.PlacementConstraints)
	objectMap["serviceKind"] = ServiceKindStateless
	populate(objectMap, "serviceLoadMetrics", s.ServiceLoadMetrics)
	populate(objectMap, "servicePlacementPolicies", s.ServicePlacementPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatelessServiceUpdateProperties.
func (s *StatelessServiceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationScheme":
			err = unpopulate(val, "CorrelationScheme", &s.CorrelationScheme)
			delete(rawMsg, key)
		case "defaultMoveCost":
			err = unpopulate(val, "DefaultMoveCost", &s.DefaultMoveCost)
			delete(rawMsg, key)
		case "instanceCloseDelayDuration":
			err = unpopulate(val, "InstanceCloseDelayDuration", &s.InstanceCloseDelayDuration)
			delete(rawMsg, key)
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &s.InstanceCount)
			delete(rawMsg, key)
		case "placementConstraints":
			err = unpopulate(val, "PlacementConstraints", &s.PlacementConstraints)
			delete(rawMsg, key)
		case "serviceKind":
			err = unpopulate(val, "ServiceKind", &s.ServiceKind)
			delete(rawMsg, key)
		case "serviceLoadMetrics":
			err = unpopulate(val, "ServiceLoadMetrics", &s.ServiceLoadMetrics)
			delete(rawMsg, key)
		case "servicePlacementPolicies":
			s.ServicePlacementPolicies, err = unmarshalServicePlacementPolicyDescriptionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UniformInt64RangePartitionSchemeDescription.
func (u UniformInt64RangePartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "count", u.Count)
	populate(objectMap, "highKey", u.HighKey)
	populate(objectMap, "lowKey", u.LowKey)
	objectMap["partitionScheme"] = PartitionSchemeUniformInt64Range
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UniformInt64RangePartitionSchemeDescription.
func (u *UniformInt64RangePartitionSchemeDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &u.Count)
			delete(rawMsg, key)
		case "highKey":
			err = unpopulate(val, "HighKey", &u.HighKey)
			delete(rawMsg, key)
		case "lowKey":
			err = unpopulate(val, "LowKey", &u.LowKey)
			delete(rawMsg, key)
		case "partitionScheme":
			err = unpopulate(val, "PartitionScheme", &u.PartitionScheme)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
