//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// EventSubscriptionsClient contains the methods for the EventSubscriptions group.
// Don't use this type directly, use NewEventSubscriptionsClient() instead.
type EventSubscriptionsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewEventSubscriptionsClient creates a new instance of EventSubscriptionsClient with the specified values.
// subscriptionID - Subscription credentials that uniquely identify a Microsoft Azure subscription. The subscription ID forms
// part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewEventSubscriptionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*EventSubscriptionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &EventSubscriptionsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Asynchronously creates a new event subscription or updates an existing event subscription based on
// the specified scope.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// scope - The identifier of the resource to which the event subscription needs to be created or updated. The scope can be
// a subscription, or a resource group, or a top level resource belonging to a resource
// provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
// for a resource
// group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for
// an EventGrid topic.
// eventSubscriptionName - Name of the event subscription. Event subscription names must be between 3 and 64 characters in
// length and should use alphanumeric letters only.
// eventSubscriptionInfo - Event subscription properties containing the destination and filter information.
// options - EventSubscriptionsClientBeginCreateOrUpdateOptions contains the optional parameters for the EventSubscriptionsClient.BeginCreateOrUpdate
// method.
func (client *EventSubscriptionsClient) BeginCreateOrUpdate(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionInfo EventSubscription, options *EventSubscriptionsClientBeginCreateOrUpdateOptions) (*runtime.Poller[EventSubscriptionsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, scope, eventSubscriptionName, eventSubscriptionInfo, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EventSubscriptionsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EventSubscriptionsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Asynchronously creates a new event subscription or updates an existing event subscription based on the
// specified scope.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
func (client *EventSubscriptionsClient) createOrUpdate(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionInfo EventSubscription, options *EventSubscriptionsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, scope, eventSubscriptionName, eventSubscriptionInfo, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *EventSubscriptionsClient) createOrUpdateCreateRequest(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionInfo EventSubscription, options *EventSubscriptionsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if eventSubscriptionName == "" {
		return nil, errors.New("parameter eventSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventSubscriptionName}", url.PathEscape(eventSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, eventSubscriptionInfo)
}

// BeginDelete - Delete an existing event subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// scope - The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource
// belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
// for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for
// an EventGrid topic.
// eventSubscriptionName - Name of the event subscription.
// options - EventSubscriptionsClientBeginDeleteOptions contains the optional parameters for the EventSubscriptionsClient.BeginDelete
// method.
func (client *EventSubscriptionsClient) BeginDelete(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientBeginDeleteOptions) (*runtime.Poller[EventSubscriptionsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, scope, eventSubscriptionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EventSubscriptionsClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EventSubscriptionsClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Delete an existing event subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
func (client *EventSubscriptionsClient) deleteOperation(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, scope, eventSubscriptionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *EventSubscriptionsClient) deleteCreateRequest(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if eventSubscriptionName == "" {
		return nil, errors.New("parameter eventSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventSubscriptionName}", url.PathEscape(eventSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Get properties of an event subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// scope - The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource
// belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
// for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for
// an EventGrid topic.
// eventSubscriptionName - Name of the event subscription.
// options - EventSubscriptionsClientGetOptions contains the optional parameters for the EventSubscriptionsClient.Get method.
func (client *EventSubscriptionsClient) Get(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientGetOptions) (EventSubscriptionsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, scope, eventSubscriptionName, options)
	if err != nil {
		return EventSubscriptionsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EventSubscriptionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EventSubscriptionsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *EventSubscriptionsClient) getCreateRequest(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if eventSubscriptionName == "" {
		return nil, errors.New("parameter eventSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventSubscriptionName}", url.PathEscape(eventSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *EventSubscriptionsClient) getHandleResponse(resp *http.Response) (EventSubscriptionsClientGetResponse, error) {
	result := EventSubscriptionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscription); err != nil {
		return EventSubscriptionsClientGetResponse{}, err
	}
	return result, nil
}

// GetDeliveryAttributes - Get all delivery attributes for an event subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// scope - The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource
// belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
// for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for
// an EventGrid topic.
// eventSubscriptionName - Name of the event subscription.
// options - EventSubscriptionsClientGetDeliveryAttributesOptions contains the optional parameters for the EventSubscriptionsClient.GetDeliveryAttributes
// method.
func (client *EventSubscriptionsClient) GetDeliveryAttributes(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientGetDeliveryAttributesOptions) (EventSubscriptionsClientGetDeliveryAttributesResponse, error) {
	req, err := client.getDeliveryAttributesCreateRequest(ctx, scope, eventSubscriptionName, options)
	if err != nil {
		return EventSubscriptionsClientGetDeliveryAttributesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EventSubscriptionsClientGetDeliveryAttributesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EventSubscriptionsClientGetDeliveryAttributesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDeliveryAttributesHandleResponse(resp)
}

// getDeliveryAttributesCreateRequest creates the GetDeliveryAttributes request.
func (client *EventSubscriptionsClient) getDeliveryAttributesCreateRequest(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientGetDeliveryAttributesOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}/getDeliveryAttributes"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if eventSubscriptionName == "" {
		return nil, errors.New("parameter eventSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventSubscriptionName}", url.PathEscape(eventSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeliveryAttributesHandleResponse handles the GetDeliveryAttributes response.
func (client *EventSubscriptionsClient) getDeliveryAttributesHandleResponse(resp *http.Response) (EventSubscriptionsClientGetDeliveryAttributesResponse, error) {
	result := EventSubscriptionsClientGetDeliveryAttributesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeliveryAttributeListResult); err != nil {
		return EventSubscriptionsClientGetDeliveryAttributesResponse{}, err
	}
	return result, nil
}

// GetFullURL - Get the full endpoint URL for an event subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// scope - The scope of the event subscription. The scope can be a subscription, or a resource group, or a top level resource
// belonging to a resource provider namespace, or an EventGrid topic. For example, use
// '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
// for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for
// an EventGrid topic.
// eventSubscriptionName - Name of the event subscription.
// options - EventSubscriptionsClientGetFullURLOptions contains the optional parameters for the EventSubscriptionsClient.GetFullURL
// method.
func (client *EventSubscriptionsClient) GetFullURL(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientGetFullURLOptions) (EventSubscriptionsClientGetFullURLResponse, error) {
	req, err := client.getFullURLCreateRequest(ctx, scope, eventSubscriptionName, options)
	if err != nil {
		return EventSubscriptionsClientGetFullURLResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EventSubscriptionsClientGetFullURLResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EventSubscriptionsClientGetFullURLResponse{}, runtime.NewResponseError(resp)
	}
	return client.getFullURLHandleResponse(resp)
}

// getFullURLCreateRequest creates the GetFullURL request.
func (client *EventSubscriptionsClient) getFullURLCreateRequest(ctx context.Context, scope string, eventSubscriptionName string, options *EventSubscriptionsClientGetFullURLOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}/getFullUrl"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if eventSubscriptionName == "" {
		return nil, errors.New("parameter eventSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventSubscriptionName}", url.PathEscape(eventSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFullURLHandleResponse handles the GetFullURL response.
func (client *EventSubscriptionsClient) getFullURLHandleResponse(resp *http.Response) (EventSubscriptionsClientGetFullURLResponse, error) {
	result := EventSubscriptionsClientGetFullURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionFullURL); err != nil {
		return EventSubscriptionsClientGetFullURLResponse{}, err
	}
	return result, nil
}

// NewListByDomainTopicPager - List all event subscriptions that have been created for a specific domain topic.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// resourceGroupName - The name of the resource group within the user's subscription.
// domainName - Name of the top level domain.
// topicName - Name of the domain topic.
// options - EventSubscriptionsClientListByDomainTopicOptions contains the optional parameters for the EventSubscriptionsClient.ListByDomainTopic
// method.
func (client *EventSubscriptionsClient) NewListByDomainTopicPager(resourceGroupName string, domainName string, topicName string, options *EventSubscriptionsClientListByDomainTopicOptions) *runtime.Pager[EventSubscriptionsClientListByDomainTopicResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListByDomainTopicResponse]{
		More: func(page EventSubscriptionsClientListByDomainTopicResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListByDomainTopicResponse) (EventSubscriptionsClientListByDomainTopicResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByDomainTopicCreateRequest(ctx, resourceGroupName, domainName, topicName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListByDomainTopicResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListByDomainTopicResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListByDomainTopicResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDomainTopicHandleResponse(resp)
		},
	})
}

// listByDomainTopicCreateRequest creates the ListByDomainTopic request.
func (client *EventSubscriptionsClient) listByDomainTopicCreateRequest(ctx context.Context, resourceGroupName string, domainName string, topicName string, options *EventSubscriptionsClientListByDomainTopicOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}/topics/{topicName}/providers/Microsoft.EventGrid/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if topicName == "" {
		return nil, errors.New("parameter topicName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{topicName}", url.PathEscape(topicName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDomainTopicHandleResponse handles the ListByDomainTopic response.
func (client *EventSubscriptionsClient) listByDomainTopicHandleResponse(resp *http.Response) (EventSubscriptionsClientListByDomainTopicResponse, error) {
	result := EventSubscriptionsClientListByDomainTopicResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListByDomainTopicResponse{}, err
	}
	return result, nil
}

// NewListByResourcePager - List all event subscriptions that have been created for a specific resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// resourceGroupName - The name of the resource group within the user's subscription.
// providerNamespace - Namespace of the provider of the topic.
// resourceTypeName - Name of the resource type.
// resourceName - Name of the resource.
// options - EventSubscriptionsClientListByResourceOptions contains the optional parameters for the EventSubscriptionsClient.ListByResource
// method.
func (client *EventSubscriptionsClient) NewListByResourcePager(resourceGroupName string, providerNamespace string, resourceTypeName string, resourceName string, options *EventSubscriptionsClientListByResourceOptions) *runtime.Pager[EventSubscriptionsClientListByResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListByResourceResponse]{
		More: func(page EventSubscriptionsClientListByResourceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListByResourceResponse) (EventSubscriptionsClientListByResourceResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceCreateRequest(ctx, resourceGroupName, providerNamespace, resourceTypeName, resourceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListByResourceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListByResourceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListByResourceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceHandleResponse(resp)
		},
	})
}

// listByResourceCreateRequest creates the ListByResource request.
func (client *EventSubscriptionsClient) listByResourceCreateRequest(ctx context.Context, resourceGroupName string, providerNamespace string, resourceTypeName string, resourceName string, options *EventSubscriptionsClientListByResourceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{providerNamespace}/{resourceTypeName}/{resourceName}/providers/Microsoft.EventGrid/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceTypeName == "" {
		return nil, errors.New("parameter resourceTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceTypeName}", url.PathEscape(resourceTypeName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceHandleResponse handles the ListByResource response.
func (client *EventSubscriptionsClient) listByResourceHandleResponse(resp *http.Response) (EventSubscriptionsClientListByResourceResponse, error) {
	result := EventSubscriptionsClientListByResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListByResourceResponse{}, err
	}
	return result, nil
}

// NewListGlobalByResourceGroupPager - List all global event subscriptions under a specific Azure subscription and resource
// group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// resourceGroupName - The name of the resource group within the user's subscription.
// options - EventSubscriptionsClientListGlobalByResourceGroupOptions contains the optional parameters for the EventSubscriptionsClient.ListGlobalByResourceGroup
// method.
func (client *EventSubscriptionsClient) NewListGlobalByResourceGroupPager(resourceGroupName string, options *EventSubscriptionsClientListGlobalByResourceGroupOptions) *runtime.Pager[EventSubscriptionsClientListGlobalByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListGlobalByResourceGroupResponse]{
		More: func(page EventSubscriptionsClientListGlobalByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListGlobalByResourceGroupResponse) (EventSubscriptionsClientListGlobalByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listGlobalByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListGlobalByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListGlobalByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListGlobalByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listGlobalByResourceGroupHandleResponse(resp)
		},
	})
}

// listGlobalByResourceGroupCreateRequest creates the ListGlobalByResourceGroup request.
func (client *EventSubscriptionsClient) listGlobalByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *EventSubscriptionsClientListGlobalByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGlobalByResourceGroupHandleResponse handles the ListGlobalByResourceGroup response.
func (client *EventSubscriptionsClient) listGlobalByResourceGroupHandleResponse(resp *http.Response) (EventSubscriptionsClientListGlobalByResourceGroupResponse, error) {
	result := EventSubscriptionsClientListGlobalByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListGlobalByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListGlobalByResourceGroupForTopicTypePager - List all global event subscriptions under a resource group for a specific
// topic type.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// resourceGroupName - The name of the resource group within the user's subscription.
// topicTypeName - Name of the topic type.
// options - EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions contains the optional parameters for the
// EventSubscriptionsClient.ListGlobalByResourceGroupForTopicType method.
func (client *EventSubscriptionsClient) NewListGlobalByResourceGroupForTopicTypePager(resourceGroupName string, topicTypeName string, options *EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions) *runtime.Pager[EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse]{
		More: func(page EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse) (EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listGlobalByResourceGroupForTopicTypeCreateRequest(ctx, resourceGroupName, topicTypeName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse{}, runtime.NewResponseError(resp)
			}
			return client.listGlobalByResourceGroupForTopicTypeHandleResponse(resp)
		},
	})
}

// listGlobalByResourceGroupForTopicTypeCreateRequest creates the ListGlobalByResourceGroupForTopicType request.
func (client *EventSubscriptionsClient) listGlobalByResourceGroupForTopicTypeCreateRequest(ctx context.Context, resourceGroupName string, topicTypeName string, options *EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if topicTypeName == "" {
		return nil, errors.New("parameter topicTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{topicTypeName}", url.PathEscape(topicTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGlobalByResourceGroupForTopicTypeHandleResponse handles the ListGlobalByResourceGroupForTopicType response.
func (client *EventSubscriptionsClient) listGlobalByResourceGroupForTopicTypeHandleResponse(resp *http.Response) (EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse, error) {
	result := EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListGlobalByResourceGroupForTopicTypeResponse{}, err
	}
	return result, nil
}

// NewListGlobalBySubscriptionPager - List all aggregated global event subscriptions under a specific Azure subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// options - EventSubscriptionsClientListGlobalBySubscriptionOptions contains the optional parameters for the EventSubscriptionsClient.ListGlobalBySubscription
// method.
func (client *EventSubscriptionsClient) NewListGlobalBySubscriptionPager(options *EventSubscriptionsClientListGlobalBySubscriptionOptions) *runtime.Pager[EventSubscriptionsClientListGlobalBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListGlobalBySubscriptionResponse]{
		More: func(page EventSubscriptionsClientListGlobalBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListGlobalBySubscriptionResponse) (EventSubscriptionsClientListGlobalBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listGlobalBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListGlobalBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListGlobalBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListGlobalBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listGlobalBySubscriptionHandleResponse(resp)
		},
	})
}

// listGlobalBySubscriptionCreateRequest creates the ListGlobalBySubscription request.
func (client *EventSubscriptionsClient) listGlobalBySubscriptionCreateRequest(ctx context.Context, options *EventSubscriptionsClientListGlobalBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGlobalBySubscriptionHandleResponse handles the ListGlobalBySubscription response.
func (client *EventSubscriptionsClient) listGlobalBySubscriptionHandleResponse(resp *http.Response) (EventSubscriptionsClientListGlobalBySubscriptionResponse, error) {
	result := EventSubscriptionsClientListGlobalBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListGlobalBySubscriptionResponse{}, err
	}
	return result, nil
}

// NewListGlobalBySubscriptionForTopicTypePager - List all global event subscriptions under an Azure subscription for a topic
// type.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// topicTypeName - Name of the topic type.
// options - EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions contains the optional parameters for the
// EventSubscriptionsClient.ListGlobalBySubscriptionForTopicType method.
func (client *EventSubscriptionsClient) NewListGlobalBySubscriptionForTopicTypePager(topicTypeName string, options *EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions) *runtime.Pager[EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse]{
		More: func(page EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse) (EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listGlobalBySubscriptionForTopicTypeCreateRequest(ctx, topicTypeName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse{}, runtime.NewResponseError(resp)
			}
			return client.listGlobalBySubscriptionForTopicTypeHandleResponse(resp)
		},
	})
}

// listGlobalBySubscriptionForTopicTypeCreateRequest creates the ListGlobalBySubscriptionForTopicType request.
func (client *EventSubscriptionsClient) listGlobalBySubscriptionForTopicTypeCreateRequest(ctx context.Context, topicTypeName string, options *EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if topicTypeName == "" {
		return nil, errors.New("parameter topicTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{topicTypeName}", url.PathEscape(topicTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGlobalBySubscriptionForTopicTypeHandleResponse handles the ListGlobalBySubscriptionForTopicType response.
func (client *EventSubscriptionsClient) listGlobalBySubscriptionForTopicTypeHandleResponse(resp *http.Response) (EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse, error) {
	result := EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListGlobalBySubscriptionForTopicTypeResponse{}, err
	}
	return result, nil
}

// NewListRegionalByResourceGroupPager - List all event subscriptions from the given location under a specific Azure subscription
// and resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// resourceGroupName - The name of the resource group within the user's subscription.
// location - Name of the location.
// options - EventSubscriptionsClientListRegionalByResourceGroupOptions contains the optional parameters for the EventSubscriptionsClient.ListRegionalByResourceGroup
// method.
func (client *EventSubscriptionsClient) NewListRegionalByResourceGroupPager(resourceGroupName string, location string, options *EventSubscriptionsClientListRegionalByResourceGroupOptions) *runtime.Pager[EventSubscriptionsClientListRegionalByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListRegionalByResourceGroupResponse]{
		More: func(page EventSubscriptionsClientListRegionalByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListRegionalByResourceGroupResponse) (EventSubscriptionsClientListRegionalByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listRegionalByResourceGroupCreateRequest(ctx, resourceGroupName, location, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListRegionalByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListRegionalByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListRegionalByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listRegionalByResourceGroupHandleResponse(resp)
		},
	})
}

// listRegionalByResourceGroupCreateRequest creates the ListRegionalByResourceGroup request.
func (client *EventSubscriptionsClient) listRegionalByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, location string, options *EventSubscriptionsClientListRegionalByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRegionalByResourceGroupHandleResponse handles the ListRegionalByResourceGroup response.
func (client *EventSubscriptionsClient) listRegionalByResourceGroupHandleResponse(resp *http.Response) (EventSubscriptionsClientListRegionalByResourceGroupResponse, error) {
	result := EventSubscriptionsClientListRegionalByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListRegionalByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListRegionalByResourceGroupForTopicTypePager - List all event subscriptions from the given location under a specific
// Azure subscription and resource group and topic type.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// resourceGroupName - The name of the resource group within the user's subscription.
// location - Name of the location.
// topicTypeName - Name of the topic type.
// options - EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions contains the optional parameters for the
// EventSubscriptionsClient.ListRegionalByResourceGroupForTopicType method.
func (client *EventSubscriptionsClient) NewListRegionalByResourceGroupForTopicTypePager(resourceGroupName string, location string, topicTypeName string, options *EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions) *runtime.Pager[EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse]{
		More: func(page EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse) (EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listRegionalByResourceGroupForTopicTypeCreateRequest(ctx, resourceGroupName, location, topicTypeName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse{}, runtime.NewResponseError(resp)
			}
			return client.listRegionalByResourceGroupForTopicTypeHandleResponse(resp)
		},
	})
}

// listRegionalByResourceGroupForTopicTypeCreateRequest creates the ListRegionalByResourceGroupForTopicType request.
func (client *EventSubscriptionsClient) listRegionalByResourceGroupForTopicTypeCreateRequest(ctx context.Context, resourceGroupName string, location string, topicTypeName string, options *EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if topicTypeName == "" {
		return nil, errors.New("parameter topicTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{topicTypeName}", url.PathEscape(topicTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRegionalByResourceGroupForTopicTypeHandleResponse handles the ListRegionalByResourceGroupForTopicType response.
func (client *EventSubscriptionsClient) listRegionalByResourceGroupForTopicTypeHandleResponse(resp *http.Response) (EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse, error) {
	result := EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListRegionalByResourceGroupForTopicTypeResponse{}, err
	}
	return result, nil
}

// NewListRegionalBySubscriptionPager - List all event subscriptions from the given location under a specific Azure subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// location - Name of the location.
// options - EventSubscriptionsClientListRegionalBySubscriptionOptions contains the optional parameters for the EventSubscriptionsClient.ListRegionalBySubscription
// method.
func (client *EventSubscriptionsClient) NewListRegionalBySubscriptionPager(location string, options *EventSubscriptionsClientListRegionalBySubscriptionOptions) *runtime.Pager[EventSubscriptionsClientListRegionalBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListRegionalBySubscriptionResponse]{
		More: func(page EventSubscriptionsClientListRegionalBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListRegionalBySubscriptionResponse) (EventSubscriptionsClientListRegionalBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listRegionalBySubscriptionCreateRequest(ctx, location, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListRegionalBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListRegionalBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListRegionalBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listRegionalBySubscriptionHandleResponse(resp)
		},
	})
}

// listRegionalBySubscriptionCreateRequest creates the ListRegionalBySubscription request.
func (client *EventSubscriptionsClient) listRegionalBySubscriptionCreateRequest(ctx context.Context, location string, options *EventSubscriptionsClientListRegionalBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRegionalBySubscriptionHandleResponse handles the ListRegionalBySubscription response.
func (client *EventSubscriptionsClient) listRegionalBySubscriptionHandleResponse(resp *http.Response) (EventSubscriptionsClientListRegionalBySubscriptionResponse, error) {
	result := EventSubscriptionsClientListRegionalBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListRegionalBySubscriptionResponse{}, err
	}
	return result, nil
}

// NewListRegionalBySubscriptionForTopicTypePager - List all event subscriptions from the given location under a specific
// Azure subscription and topic type.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// location - Name of the location.
// topicTypeName - Name of the topic type.
// options - EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions contains the optional parameters for the
// EventSubscriptionsClient.ListRegionalBySubscriptionForTopicType method.
func (client *EventSubscriptionsClient) NewListRegionalBySubscriptionForTopicTypePager(location string, topicTypeName string, options *EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions) *runtime.Pager[EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse] {
	return runtime.NewPager(runtime.PagingHandler[EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse]{
		More: func(page EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse) (EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listRegionalBySubscriptionForTopicTypeCreateRequest(ctx, location, topicTypeName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse{}, runtime.NewResponseError(resp)
			}
			return client.listRegionalBySubscriptionForTopicTypeHandleResponse(resp)
		},
	})
}

// listRegionalBySubscriptionForTopicTypeCreateRequest creates the ListRegionalBySubscriptionForTopicType request.
func (client *EventSubscriptionsClient) listRegionalBySubscriptionForTopicTypeCreateRequest(ctx context.Context, location string, topicTypeName string, options *EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if topicTypeName == "" {
		return nil, errors.New("parameter topicTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{topicTypeName}", url.PathEscape(topicTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRegionalBySubscriptionForTopicTypeHandleResponse handles the ListRegionalBySubscriptionForTopicType response.
func (client *EventSubscriptionsClient) listRegionalBySubscriptionForTopicTypeHandleResponse(resp *http.Response) (EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse, error) {
	result := EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventSubscriptionsListResult); err != nil {
		return EventSubscriptionsClientListRegionalBySubscriptionForTopicTypeResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Asynchronously updates an existing event subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
// scope - The scope of existing event subscription. The scope can be a subscription, or a resource group, or a top level
// resource belonging to a resource provider namespace, or an EventGrid topic. For example,
// use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
// for a resource group, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}'
// for a resource, and
// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for
// an EventGrid topic.
// eventSubscriptionName - Name of the event subscription to be updated.
// eventSubscriptionUpdateParameters - Updated event subscription information.
// options - EventSubscriptionsClientBeginUpdateOptions contains the optional parameters for the EventSubscriptionsClient.BeginUpdate
// method.
func (client *EventSubscriptionsClient) BeginUpdate(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionUpdateParameters EventSubscriptionUpdateParameters, options *EventSubscriptionsClientBeginUpdateOptions) (*runtime.Poller[EventSubscriptionsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, scope, eventSubscriptionName, eventSubscriptionUpdateParameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[EventSubscriptionsClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[EventSubscriptionsClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Asynchronously updates an existing event subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-06-15
func (client *EventSubscriptionsClient) update(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionUpdateParameters EventSubscriptionUpdateParameters, options *EventSubscriptionsClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, scope, eventSubscriptionName, eventSubscriptionUpdateParameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *EventSubscriptionsClient) updateCreateRequest(ctx context.Context, scope string, eventSubscriptionName string, eventSubscriptionUpdateParameters EventSubscriptionUpdateParameters, options *EventSubscriptionsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if eventSubscriptionName == "" {
		return nil, errors.New("parameter eventSubscriptionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventSubscriptionName}", url.PathEscape(eventSubscriptionName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, eventSubscriptionUpdateParameters)
}
