//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdeviceupdate

import "time"

// Account - Device Update account details.
type Account struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The type of identity used for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Device Update account properties.
	Properties *AccountProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountList - List of Accounts.
type AccountList struct {
	// The link used to get the next page of Accounts list.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Accounts.
	Value []*Account `json:"value,omitempty"`
}

// AccountProperties - Device Update account properties.
type AccountProperties struct {
	// List of private endpoint connections associated with the account.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// Whether or not public network access is allowed for the account.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Device Update Sku
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; API host name.
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY; Device Update account primary and failover location details
	Locations []*Location `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AccountUpdate - Request payload used to update and existing Accounts.
type AccountUpdate struct {
	// The type of identity used for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// List of key value pairs that describe the resource. This will overwrite the existing tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountsClientBeginCreateOptions contains the optional parameters for the AccountsClient.BeginCreate method.
type AccountsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginDeleteOptions contains the optional parameters for the AccountsClient.BeginDelete method.
type AccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginUpdateOptions contains the optional parameters for the AccountsClient.BeginUpdate method.
type AccountsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientHeadOptions contains the optional parameters for the AccountsClient.Head method.
type AccountsClientHeadOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListBySubscriptionOptions contains the optional parameters for the AccountsClient.ListBySubscription method.
type AccountsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string `json:"message,omitempty"`

	// Indicates if the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// ClientCheckNameAvailabilityOptions contains the optional parameters for the Client.CheckNameAvailability method.
type ClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ConnectionDetails - Private endpoint connection proxy object properties.
type ConnectionDetails struct {
	// READ-ONLY; Group ID.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Connection details ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Link ID.
	LinkIdentifier *string `json:"linkIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; Member name.
	MemberName *string `json:"memberName,omitempty" azure:"ro"`

	// READ-ONLY; Private IP address.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty" azure:"ro"`
}

// DiagnosticStorageProperties - Customer-initiated diagnostic log collection storage properties
type DiagnosticStorageProperties struct {
	// REQUIRED; Authentication Type
	AuthenticationType *AuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; ResourceId of the diagnostic storage account
	ResourceID *string `json:"resourceId,omitempty"`

	// ConnectionString of the diagnostic storage account
	ConnectionString *string `json:"connectionString,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GroupConnectivityInformation - Group connectivity details.
type GroupConnectivityInformation struct {
	// List of customer visible FQDNs.
	CustomerVisibleFqdns []*string `json:"customerVisibleFqdns,omitempty"`

	// PrivateLinkService ARM region.
	PrivateLinkServiceArmRegion *string `json:"privateLinkServiceArmRegion,omitempty"`

	// Redirect map ID.
	RedirectMapID *string `json:"redirectMapId,omitempty"`

	// READ-ONLY; Group ID.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Internal FQDN.
	InternalFqdn *string `json:"internalFqdn,omitempty" azure:"ro"`

	// READ-ONLY; Member name.
	MemberName *string `json:"memberName,omitempty" azure:"ro"`
}

// GroupInformation - The group information for creating a private endpoint on an Account
type GroupInformation struct {
	// REQUIRED; The properties for a group information object
	Properties *GroupInformationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GroupInformationProperties - The properties for a group information object
type GroupInformationProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of private link group ID.
	ProvisioningState *GroupIDProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// Instance - Device Update instance details.
type Instance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Device Update instance properties.
	Properties *InstanceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InstanceList - List of Instances.
type InstanceList struct {
	// The link used to get the next page of Instances list.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Instances.
	Value []*Instance `json:"value,omitempty"`
}

// InstanceProperties - Device Update instance properties.
type InstanceProperties struct {
	// Customer-initiated diagnostic log collection storage properties
	DiagnosticStorageProperties *DiagnosticStorageProperties `json:"diagnosticStorageProperties,omitempty"`

	// Enables or Disables the diagnostic logs collection
	EnableDiagnostics *bool `json:"enableDiagnostics,omitempty"`

	// List of IoT Hubs associated with the account.
	IotHubs []*IotHubSettings `json:"iotHubs,omitempty"`

	// READ-ONLY; Parent Device Update Account name which Instance belongs to.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// InstancesClientBeginCreateOptions contains the optional parameters for the InstancesClient.BeginCreate method.
type InstancesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstancesClientBeginDeleteOptions contains the optional parameters for the InstancesClient.BeginDelete method.
type InstancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstancesClientGetOptions contains the optional parameters for the InstancesClient.Get method.
type InstancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// InstancesClientHeadOptions contains the optional parameters for the InstancesClient.Head method.
type InstancesClientHeadOptions struct {
	// placeholder for future optional parameters
}

// InstancesClientListByAccountOptions contains the optional parameters for the InstancesClient.ListByAccount method.
type InstancesClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// InstancesClientUpdateOptions contains the optional parameters for the InstancesClient.Update method.
type InstancesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IotHubSettings - Device Update account integration with IoT Hub settings.
type IotHubSettings struct {
	// REQUIRED; IoTHub resource ID
	ResourceID *string `json:"resourceId,omitempty"`
}

type Location struct {
	Name *string `json:"name,omitempty"`

	// Whether the location is primary or failover
	Role *Role `json:"role,omitempty"`
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// REQUIRED; Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Array of group IDs.
	GroupIDs []*string `json:"groupIds,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProxiesClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionProxiesClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionProxiesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionProxiesClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionProxiesClient.BeginDelete
// method.
type PrivateEndpointConnectionProxiesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionProxiesClientGetOptions contains the optional parameters for the PrivateEndpointConnectionProxiesClient.Get
// method.
type PrivateEndpointConnectionProxiesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionProxiesClientListByAccountOptions contains the optional parameters for the PrivateEndpointConnectionProxiesClient.ListByAccount
// method.
type PrivateEndpointConnectionProxiesClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionProxiesClientUpdatePrivateEndpointPropertiesOptions contains the optional parameters for the PrivateEndpointConnectionProxiesClient.UpdatePrivateEndpointProperties
// method.
type PrivateEndpointConnectionProxiesClientUpdatePrivateEndpointPropertiesOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionProxiesClientValidateOptions contains the optional parameters for the PrivateEndpointConnectionProxiesClient.Validate
// method.
type PrivateEndpointConnectionProxiesClientValidateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionProxy - Private endpoint connection proxy details.
type PrivateEndpointConnectionProxy struct {
	// Private endpoint connection proxy object property bag.
	Properties *PrivateEndpointConnectionProxyProperties `json:"properties,omitempty"`

	// Remote private endpoint details.
	RemotePrivateEndpoint *RemotePrivateEndpoint `json:"remotePrivateEndpoint,omitempty"`

	// Operation status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; ETag from NRP.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProxyListResult - The available private endpoint connection proxies for an Account (not to be
// used by anyone, here because of ARM requirements)
type PrivateEndpointConnectionProxyListResult struct {
	// The URI that can be used to request the next list of private endpoint connection proxies.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of available private endpoint connection proxies for an Account
	Value []*PrivateEndpointConnectionProxy `json:"value,omitempty"`
}

// PrivateEndpointConnectionProxyProperties - Private endpoint connection proxy object property bag.
type PrivateEndpointConnectionProxyProperties struct {
	// READ-ONLY; The provisioning state of the private endpoint connection proxy resource.
	ProvisioningState *PrivateEndpointConnectionProxyProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProxyPropertiesAutoGenerated - Private endpoint connection proxy object properties.
type PrivateEndpointConnectionProxyPropertiesAutoGenerated struct {
	// Remote private endpoint details.
	RemotePrivateEndpoint *RemotePrivateEndpoint `json:"remotePrivateEndpoint,omitempty"`

	// Operation status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; ETag from NRP.
	ETag *string `json:"eTag,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByAccountOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByAccount
// method.
type PrivateEndpointConnectionsClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointUpdate - Private endpoint update details.
type PrivateEndpointUpdate struct {
	// Remote endpoint resource ID.
	ID *string `json:"id,omitempty"`

	// Original resource ID needed by Microsoft.Network.
	ImmutableResourceID *string `json:"immutableResourceId,omitempty"`

	// Original subscription ID needed by Microsoft.Network.
	ImmutableSubscriptionID *string `json:"immutableSubscriptionId,omitempty"`

	// ARM location of the remote private endpoint.
	Location *string `json:"location,omitempty"`

	// Virtual network traffic tag.
	VnetTrafficTag *string `json:"vnetTrafficTag,omitempty"`
}

// PrivateLinkResourceListResult - The available private link resources for an Account
type PrivateLinkResourceListResult struct {
	// The URI that can be used to request the next list of private link resources.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of available private link resources for an Account
	Value []*GroupInformation `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByAccountOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByAccount
// method.
type PrivateLinkResourcesClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnection - Private link service connection details.
type PrivateLinkServiceConnection struct {
	// List of group IDs.
	GroupIDs []*string `json:"groupIds,omitempty"`

	// Private link service connection name.
	Name *string `json:"name,omitempty"`

	// Request message.
	RequestMessage *string `json:"requestMessage,omitempty"`
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// PrivateLinkServiceProxy - Private link service proxy details.
type PrivateLinkServiceProxy struct {
	// Group connectivity information.
	GroupConnectivityInformation []*GroupConnectivityInformation `json:"groupConnectivityInformation,omitempty"`

	// NRP resource ID.
	ID *string `json:"id,omitempty"`

	// Remote private endpoint connection details.
	RemotePrivateEndpointConnection *PrivateLinkServiceProxyRemotePrivateEndpointConnection `json:"remotePrivateEndpointConnection,omitempty"`

	// Remote private link service connection state
	RemotePrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"remotePrivateLinkServiceConnectionState,omitempty"`
}

// PrivateLinkServiceProxyRemotePrivateEndpointConnection - Remote private endpoint connection details.
type PrivateLinkServiceProxyRemotePrivateEndpointConnection struct {
	// READ-ONLY; Remote private endpoint connection ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RemotePrivateEndpoint - Remote private endpoint details.
type RemotePrivateEndpoint struct {
	// List of connection details.
	ConnectionDetails []*ConnectionDetails `json:"connectionDetails,omitempty"`

	// Remote endpoint resource ID.
	ID *string `json:"id,omitempty"`

	// Original resource ID needed by Microsoft.Network.
	ImmutableResourceID *string `json:"immutableResourceId,omitempty"`

	// Original subscription ID needed by Microsoft.Network.
	ImmutableSubscriptionID *string `json:"immutableSubscriptionId,omitempty"`

	// ARM location of the remote private endpoint.
	Location *string `json:"location,omitempty"`

	// List of private link service connections that need manual approval.
	ManualPrivateLinkServiceConnections []*PrivateLinkServiceConnection `json:"manualPrivateLinkServiceConnections,omitempty"`

	// List of automatically approved private link service connections.
	PrivateLinkServiceConnections []*PrivateLinkServiceConnection `json:"privateLinkServiceConnections,omitempty"`

	// List of private link service proxies.
	PrivateLinkServiceProxies []*PrivateLinkServiceProxy `json:"privateLinkServiceProxies,omitempty"`

	// Virtual network traffic tag.
	VnetTrafficTag *string `json:"vnetTrafficTag,omitempty"`
}

// RemotePrivateEndpointConnection - Remote private endpoint connection details.
type RemotePrivateEndpointConnection struct {
	// READ-ONLY; Remote private endpoint connection ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagUpdate - Request payload used to update an existing resource's tags.
type TagUpdate struct {
	// List of key value pairs that describe the resource. This will overwrite the existing tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}
