// This file consists of testcases taken from the MSVC STL testsuite.

// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception


// Copyright 2018 Ulf Adams
// Copyright (c) Microsoft Corporation. All rights reserved.

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

// { dg-do run { target c++17 } }
// { dg-require-effective-target ieee-floats }
// { dg-require-effective-target size32plus }

#include <charconv>

#include <cstring>
#include <limits>
#include <optional>

#include <testsuite_hooks.h>

using namespace std;

inline constexpr double double_inf = numeric_limits<double>::infinity();
inline constexpr double double_nan = numeric_limits<double>::quiet_NaN();

struct double_to_chars_testcase {
    double value;
    chars_format fmt;
    optional<int> precision;
    const char* correct;

    constexpr
    double_to_chars_testcase(double value, chars_format fmt, const char* correct)
      : value (value), fmt (fmt), precision (nullopt), correct (correct)
    { }

    constexpr
    double_to_chars_testcase(double value, chars_format fmt, int precision,
			     const char* correct)
      : value (value), fmt (fmt), precision (precision), correct (correct)
    { }
};

inline constexpr double_to_chars_testcase double_to_chars_test_cases[] = {
    // Test special cases (zero, inf, nan) and an ordinary case. Also test negative signs.
    {0.0, chars_format::scientific, "0e+00"},
    {-0.0, chars_format::scientific, "-0e+00"},
    {double_inf, chars_format::scientific, "inf"},
    {-double_inf, chars_format::scientific, "-inf"},
    {double_nan, chars_format::scientific, "nan"},
    {-double_nan, chars_format::scientific, "-nan"},
    {2.018, chars_format::scientific, "2.018e+00"},
    {-2.018, chars_format::scientific, "-2.018e+00"},

    // Ditto for fixed, which doesn't emit exponents.
    {0.0, chars_format::fixed, "0"},
    {-0.0, chars_format::fixed, "-0"},
    {double_inf, chars_format::fixed, "inf"},
    {-double_inf, chars_format::fixed, "-inf"},
    {double_nan, chars_format::fixed, "nan"},
    {-double_nan, chars_format::fixed, "-nan"},
    {2.018, chars_format::fixed, "2.018"},
    {-2.018, chars_format::fixed, "-2.018"},

    // Ditto for general, which selects fixed for the scientific exponent 0.
    {0.0, chars_format::general, "0"},
    {-0.0, chars_format::general, "-0"},
    {double_inf, chars_format::general, "inf"},
    {-double_inf, chars_format::general, "-inf"},
    {double_nan, chars_format::general, "nan"},
    {-double_nan, chars_format::general, "-nan"},
    {2.018, chars_format::general, "2.018"},
    {-2.018, chars_format::general, "-2.018"},

    // Ditto for plain, which selects fixed because it's shorter for these values.
    {0.0, chars_format{}, "0"},
    {-0.0, chars_format{}, "-0"},
    {double_inf, chars_format{}, "inf"},
    {-double_inf, chars_format{}, "-inf"},
    {double_nan, chars_format{}, "nan"},
    {-double_nan, chars_format{}, "-nan"},
    {2.018, chars_format{}, "2.018"},
    {-2.018, chars_format{}, "-2.018"},

    // Ditto for hex.
    {0.0, chars_format::hex, "0p+0"},
    {-0.0, chars_format::hex, "-0p+0"},
    {double_inf, chars_format::hex, "inf"},
    {-double_inf, chars_format::hex, "-inf"},
    {double_nan, chars_format::hex, "nan"},
    {-double_nan, chars_format::hex, "-nan"},
    {0x1.729p+0, chars_format::hex, "1.729p+0"},
    {-0x1.729p+0, chars_format::hex, "-1.729p+0"},

    // Ryu d2s_test.cc SwitchToSubnormal
    {2.2250738585072014e-308, chars_format::scientific, "2.2250738585072014e-308"},

    // Ryu d2s_test.cc MinAndMax
    {0x1.fffffffffffffp+1023, chars_format::scientific, "1.7976931348623157e+308"},
    {0x0.0000000000001p-1022, chars_format::scientific, "5e-324"},

    // Ryu d2s_test.cc LotsOfTrailingZeros
    {2.98023223876953125e-8, chars_format::scientific, "2.9802322387695312e-08"},

    // Ryu d2s_test.cc Regression
    {-2.109808898695963e16, chars_format::scientific, "-2.109808898695963e+16"},
    {4.940656e-318, chars_format::scientific, "4.940656e-318"},
    {1.18575755e-316, chars_format::scientific, "1.18575755e-316"},
    {2.989102097996e-312, chars_format::scientific, "2.989102097996e-312"},
    {9.0608011534336e15, chars_format::scientific, "9.0608011534336e+15"},
    {4.708356024711512e18, chars_format::scientific, "4.708356024711512e+18"},
    {9.409340012568248e18, chars_format::scientific, "9.409340012568248e+18"},

    // Ryu d2s_test.cc LooksLikePow5
    {0x1.0f0cf064dd592p+132, chars_format::scientific, "5.764607523034235e+39"},
    {0x1.0f0cf064dd592p+133, chars_format::scientific, "1.152921504606847e+40"},
    {0x1.0f0cf064dd592p+134, chars_format::scientific, "2.305843009213694e+40"},

    // Ryu d2s_test.cc OutputLength
    {1.0, chars_format::scientific, "1e+00"},
    {1.2, chars_format::scientific, "1.2e+00"},
    {1.23, chars_format::scientific, "1.23e+00"},
    {1.234, chars_format::scientific, "1.234e+00"},
    {1.2345, chars_format::scientific, "1.2345e+00"},
    {1.23456, chars_format::scientific, "1.23456e+00"},
    {1.234567, chars_format::scientific, "1.234567e+00"},
    {1.2345678, chars_format::scientific, "1.2345678e+00"},
    {1.23456789, chars_format::scientific, "1.23456789e+00"},
    {1.234567895, chars_format::scientific, "1.234567895e+00"},
    {1.2345678901, chars_format::scientific, "1.2345678901e+00"},
    {1.23456789012, chars_format::scientific, "1.23456789012e+00"},
    {1.234567890123, chars_format::scientific, "1.234567890123e+00"},
    {1.2345678901234, chars_format::scientific, "1.2345678901234e+00"},
    {1.23456789012345, chars_format::scientific, "1.23456789012345e+00"},
    {1.234567890123456, chars_format::scientific, "1.234567890123456e+00"},
    {1.2345678901234567, chars_format::scientific, "1.2345678901234567e+00"},

    // Ryu d2s_test.cc 32-bit Chunking
    {4.294967294, chars_format::scientific, "4.294967294e+00"},
    {4.294967295, chars_format::scientific, "4.294967295e+00"},
    {4.294967296, chars_format::scientific, "4.294967296e+00"},
    {4.294967297, chars_format::scientific, "4.294967297e+00"},
    {4.294967298, chars_format::scientific, "4.294967298e+00"},

    // Ryu d2s_test.cc MinMaxShift
    {0x1.0000000000000p-1019, chars_format::scientific, "1.7800590868057611e-307"},
    {0x1.fffffffffffffp-1016, chars_format::scientific, "2.8480945388892175e-306"},
    {0x1.0000000000000p-982, chars_format::scientific, "2.446494580089078e-296"},
    {0x1.fffffffffffffp-982, chars_format::scientific, "4.8929891601781557e-296"},
    {0x1.0000000000000p+54, chars_format::scientific, "1.8014398509481984e+16"},
    {0x1.fffffffffffffp+54, chars_format::scientific, "3.6028797018963964e+16"},
    {0x1.0000000000000p-716, chars_format::scientific, "2.900835519859558e-216"},
    {0x1.fffffffffffffp-716, chars_format::scientific, "5.801671039719115e-216"},
    {0x1.fa7161a4d6e0cp-89, chars_format::scientific, "3.196104012172126e-27"},

    // Ryu d2s_test.cc SmallIntegers
    {9007199254740991.0, chars_format::scientific, "9.007199254740991e+15"},
    {9007199254740992.0, chars_format::scientific, "9.007199254740992e+15"},

    {1.0, chars_format::scientific, "1e+00"},
    {12.0, chars_format::scientific, "1.2e+01"},
    {123.0, chars_format::scientific, "1.23e+02"},
    {1234.0, chars_format::scientific, "1.234e+03"},
    {12345.0, chars_format::scientific, "1.2345e+04"},
    {123456.0, chars_format::scientific, "1.23456e+05"},
    {1234567.0, chars_format::scientific, "1.234567e+06"},
    {12345678.0, chars_format::scientific, "1.2345678e+07"},
    {123456789.0, chars_format::scientific, "1.23456789e+08"},
    {1234567890.0, chars_format::scientific, "1.23456789e+09"},
    {1234567895.0, chars_format::scientific, "1.234567895e+09"},
    {12345678901.0, chars_format::scientific, "1.2345678901e+10"},
    {123456789012.0, chars_format::scientific, "1.23456789012e+11"},
    {1234567890123.0, chars_format::scientific, "1.234567890123e+12"},
    {12345678901234.0, chars_format::scientific, "1.2345678901234e+13"},
    {123456789012345.0, chars_format::scientific, "1.23456789012345e+14"},
    {1234567890123456.0, chars_format::scientific, "1.234567890123456e+15"},

    {1.0, chars_format::scientific, "1e+00"},
    {10.0, chars_format::scientific, "1e+01"},
    {100.0, chars_format::scientific, "1e+02"},
    {1000.0, chars_format::scientific, "1e+03"},
    {10000.0, chars_format::scientific, "1e+04"},
    {100000.0, chars_format::scientific, "1e+05"},
    {1000000.0, chars_format::scientific, "1e+06"},
    {10000000.0, chars_format::scientific, "1e+07"},
    {100000000.0, chars_format::scientific, "1e+08"},
    {1000000000.0, chars_format::scientific, "1e+09"},
    {10000000000.0, chars_format::scientific, "1e+10"},
    {100000000000.0, chars_format::scientific, "1e+11"},
    {1000000000000.0, chars_format::scientific, "1e+12"},
    {10000000000000.0, chars_format::scientific, "1e+13"},
    {100000000000000.0, chars_format::scientific, "1e+14"},
    {1000000000000000.0, chars_format::scientific, "1e+15"},

    {1000000000000001.0, chars_format::scientific, "1.000000000000001e+15"},
    {1000000000000010.0, chars_format::scientific, "1.00000000000001e+15"},
    {1000000000000100.0, chars_format::scientific, "1.0000000000001e+15"},
    {1000000000001000.0, chars_format::scientific, "1.000000000001e+15"},
    {1000000000010000.0, chars_format::scientific, "1.00000000001e+15"},
    {1000000000100000.0, chars_format::scientific, "1.0000000001e+15"},
    {1000000001000000.0, chars_format::scientific, "1.000000001e+15"},
    {1000000010000000.0, chars_format::scientific, "1.00000001e+15"},
    {1000000100000000.0, chars_format::scientific, "1.0000001e+15"},
    {1000001000000000.0, chars_format::scientific, "1.000001e+15"},
    {1000010000000000.0, chars_format::scientific, "1.00001e+15"},
    {1000100000000000.0, chars_format::scientific, "1.0001e+15"},
    {1001000000000000.0, chars_format::scientific, "1.001e+15"},
    {1010000000000000.0, chars_format::scientific, "1.01e+15"},
    {1100000000000000.0, chars_format::scientific, "1.1e+15"},

    {8.0, chars_format::scientific, "8e+00"},
    {64.0, chars_format::scientific, "6.4e+01"},
    {512.0, chars_format::scientific, "5.12e+02"},
    {8192.0, chars_format::scientific, "8.192e+03"},
    {65536.0, chars_format::scientific, "6.5536e+04"},
    {524288.0, chars_format::scientific, "5.24288e+05"},
    {8388608.0, chars_format::scientific, "8.388608e+06"},
    {67108864.0, chars_format::scientific, "6.7108864e+07"},
    {536870912.0, chars_format::scientific, "5.36870912e+08"},
    {8589934592.0, chars_format::scientific, "8.589934592e+09"},
    {68719476736.0, chars_format::scientific, "6.8719476736e+10"},
    {549755813888.0, chars_format::scientific, "5.49755813888e+11"},
    {8796093022208.0, chars_format::scientific, "8.796093022208e+12"},
    {70368744177664.0, chars_format::scientific, "7.0368744177664e+13"},
    {562949953421312.0, chars_format::scientific, "5.62949953421312e+14"},
    {9007199254740992.0, chars_format::scientific, "9.007199254740992e+15"},

    {8000.0, chars_format::scientific, "8e+03"},
    {64000.0, chars_format::scientific, "6.4e+04"},
    {512000.0, chars_format::scientific, "5.12e+05"},
    {8192000.0, chars_format::scientific, "8.192e+06"},
    {65536000.0, chars_format::scientific, "6.5536e+07"},
    {524288000.0, chars_format::scientific, "5.24288e+08"},
    {8388608000.0, chars_format::scientific, "8.388608e+09"},
    {67108864000.0, chars_format::scientific, "6.7108864e+10"},
    {536870912000.0, chars_format::scientific, "5.36870912e+11"},
    {8589934592000.0, chars_format::scientific, "8.589934592e+12"},
    {68719476736000.0, chars_format::scientific, "6.8719476736e+13"},
    {549755813888000.0, chars_format::scientific, "5.49755813888e+14"},
    {8796093022208000.0, chars_format::scientific, "8.796093022208e+15"},

    // Test all exponents.
    {7.29e-324, chars_format::scientific, "5e-324"}, // 1.729e-324 would be too small
    {1.729e-323, chars_format::scientific, "1.5e-323"},
    {1.729e-322, chars_format::scientific, "1.73e-322"},
    {1.729e-321, chars_format::scientific, "1.73e-321"},
    {1.729e-320, chars_format::scientific, "1.729e-320"},
    {1.729e-319, chars_format::scientific, "1.729e-319"},
    {1.729e-318, chars_format::scientific, "1.729e-318"},
    {1.729e-317, chars_format::scientific, "1.729e-317"},
    {1.729e-316, chars_format::scientific, "1.729e-316"},
    {1.729e-315, chars_format::scientific, "1.729e-315"},
    {1.729e-314, chars_format::scientific, "1.729e-314"},
    {1.729e-313, chars_format::scientific, "1.729e-313"},
    {1.729e-312, chars_format::scientific, "1.729e-312"},
    {1.729e-311, chars_format::scientific, "1.729e-311"},
    {1.729e-310, chars_format::scientific, "1.729e-310"},
    {1.729e-309, chars_format::scientific, "1.729e-309"},
    {1.729e-308, chars_format::scientific, "1.729e-308"},
    {1.729e-307, chars_format::scientific, "1.729e-307"},
    {1.729e-306, chars_format::scientific, "1.729e-306"},
    {1.729e-305, chars_format::scientific, "1.729e-305"},
    {1.729e-304, chars_format::scientific, "1.729e-304"},
    {1.729e-303, chars_format::scientific, "1.729e-303"},
    {1.729e-302, chars_format::scientific, "1.729e-302"},
    {1.729e-301, chars_format::scientific, "1.729e-301"},
    {1.729e-300, chars_format::scientific, "1.729e-300"},
    {1.729e-299, chars_format::scientific, "1.729e-299"},
    {1.729e-298, chars_format::scientific, "1.729e-298"},
    {1.729e-297, chars_format::scientific, "1.729e-297"},
    {1.729e-296, chars_format::scientific, "1.729e-296"},
    {1.729e-295, chars_format::scientific, "1.729e-295"},
    {1.729e-294, chars_format::scientific, "1.729e-294"},
    {1.729e-293, chars_format::scientific, "1.729e-293"},
    {1.729e-292, chars_format::scientific, "1.729e-292"},
    {1.729e-291, chars_format::scientific, "1.729e-291"},
    {1.729e-290, chars_format::scientific, "1.729e-290"},
    {1.729e-289, chars_format::scientific, "1.729e-289"},
    {1.729e-288, chars_format::scientific, "1.729e-288"},
    {1.729e-287, chars_format::scientific, "1.729e-287"},
    {1.729e-286, chars_format::scientific, "1.729e-286"},
    {1.729e-285, chars_format::scientific, "1.729e-285"},
    {1.729e-284, chars_format::scientific, "1.729e-284"},
    {1.729e-283, chars_format::scientific, "1.729e-283"},
    {1.729e-282, chars_format::scientific, "1.729e-282"},
    {1.729e-281, chars_format::scientific, "1.729e-281"},
    {1.729e-280, chars_format::scientific, "1.729e-280"},
    {1.729e-279, chars_format::scientific, "1.729e-279"},
    {1.729e-278, chars_format::scientific, "1.729e-278"},
    {1.729e-277, chars_format::scientific, "1.729e-277"},
    {1.729e-276, chars_format::scientific, "1.729e-276"},
    {1.729e-275, chars_format::scientific, "1.729e-275"},
    {1.729e-274, chars_format::scientific, "1.729e-274"},
    {1.729e-273, chars_format::scientific, "1.729e-273"},
    {1.729e-272, chars_format::scientific, "1.729e-272"},
    {1.729e-271, chars_format::scientific, "1.729e-271"},
    {1.729e-270, chars_format::scientific, "1.729e-270"},
    {1.729e-269, chars_format::scientific, "1.729e-269"},
    {1.729e-268, chars_format::scientific, "1.729e-268"},
    {1.729e-267, chars_format::scientific, "1.729e-267"},
    {1.729e-266, chars_format::scientific, "1.729e-266"},
    {1.729e-265, chars_format::scientific, "1.729e-265"},
    {1.729e-264, chars_format::scientific, "1.729e-264"},
    {1.729e-263, chars_format::scientific, "1.729e-263"},
    {1.729e-262, chars_format::scientific, "1.729e-262"},
    {1.729e-261, chars_format::scientific, "1.729e-261"},
    {1.729e-260, chars_format::scientific, "1.729e-260"},
    {1.729e-259, chars_format::scientific, "1.729e-259"},
    {1.729e-258, chars_format::scientific, "1.729e-258"},
    {1.729e-257, chars_format::scientific, "1.729e-257"},
    {1.729e-256, chars_format::scientific, "1.729e-256"},
    {1.729e-255, chars_format::scientific, "1.729e-255"},
    {1.729e-254, chars_format::scientific, "1.729e-254"},
    {1.729e-253, chars_format::scientific, "1.729e-253"},
    {1.729e-252, chars_format::scientific, "1.729e-252"},
    {1.729e-251, chars_format::scientific, "1.729e-251"},
    {1.729e-250, chars_format::scientific, "1.729e-250"},
    {1.729e-249, chars_format::scientific, "1.729e-249"},
    {1.729e-248, chars_format::scientific, "1.729e-248"},
    {1.729e-247, chars_format::scientific, "1.729e-247"},
    {1.729e-246, chars_format::scientific, "1.729e-246"},
    {1.729e-245, chars_format::scientific, "1.729e-245"},
    {1.729e-244, chars_format::scientific, "1.729e-244"},
    {1.729e-243, chars_format::scientific, "1.729e-243"},
    {1.729e-242, chars_format::scientific, "1.729e-242"},
    {1.729e-241, chars_format::scientific, "1.729e-241"},
    {1.729e-240, chars_format::scientific, "1.729e-240"},
    {1.729e-239, chars_format::scientific, "1.729e-239"},
    {1.729e-238, chars_format::scientific, "1.729e-238"},
    {1.729e-237, chars_format::scientific, "1.729e-237"},
    {1.729e-236, chars_format::scientific, "1.729e-236"},
    {1.729e-235, chars_format::scientific, "1.729e-235"},
    {1.729e-234, chars_format::scientific, "1.729e-234"},
    {1.729e-233, chars_format::scientific, "1.729e-233"},
    {1.729e-232, chars_format::scientific, "1.729e-232"},
    {1.729e-231, chars_format::scientific, "1.729e-231"},
    {1.729e-230, chars_format::scientific, "1.729e-230"},
    {1.729e-229, chars_format::scientific, "1.729e-229"},
    {1.729e-228, chars_format::scientific, "1.729e-228"},
    {1.729e-227, chars_format::scientific, "1.729e-227"},
    {1.729e-226, chars_format::scientific, "1.729e-226"},
    {1.729e-225, chars_format::scientific, "1.729e-225"},
    {1.729e-224, chars_format::scientific, "1.729e-224"},
    {1.729e-223, chars_format::scientific, "1.729e-223"},
    {1.729e-222, chars_format::scientific, "1.729e-222"},
    {1.729e-221, chars_format::scientific, "1.729e-221"},
    {1.729e-220, chars_format::scientific, "1.729e-220"},
    {1.729e-219, chars_format::scientific, "1.729e-219"},
    {1.729e-218, chars_format::scientific, "1.729e-218"},
    {1.729e-217, chars_format::scientific, "1.729e-217"},
    {1.729e-216, chars_format::scientific, "1.729e-216"},
    {1.729e-215, chars_format::scientific, "1.729e-215"},
    {1.729e-214, chars_format::scientific, "1.729e-214"},
    {1.729e-213, chars_format::scientific, "1.729e-213"},
    {1.729e-212, chars_format::scientific, "1.729e-212"},
    {1.729e-211, chars_format::scientific, "1.729e-211"},
    {1.729e-210, chars_format::scientific, "1.729e-210"},
    {1.729e-209, chars_format::scientific, "1.729e-209"},
    {1.729e-208, chars_format::scientific, "1.729e-208"},
    {1.729e-207, chars_format::scientific, "1.729e-207"},
    {1.729e-206, chars_format::scientific, "1.729e-206"},
    {1.729e-205, chars_format::scientific, "1.729e-205"},
    {1.729e-204, chars_format::scientific, "1.729e-204"},
    {1.729e-203, chars_format::scientific, "1.729e-203"},
    {1.729e-202, chars_format::scientific, "1.729e-202"},
    {1.729e-201, chars_format::scientific, "1.729e-201"},
    {1.729e-200, chars_format::scientific, "1.729e-200"},
    {1.729e-199, chars_format::scientific, "1.729e-199"},
    {1.729e-198, chars_format::scientific, "1.729e-198"},
    {1.729e-197, chars_format::scientific, "1.729e-197"},
    {1.729e-196, chars_format::scientific, "1.729e-196"},
    {1.729e-195, chars_format::scientific, "1.729e-195"},
    {1.729e-194, chars_format::scientific, "1.729e-194"},
    {1.729e-193, chars_format::scientific, "1.729e-193"},
    {1.729e-192, chars_format::scientific, "1.729e-192"},
    {1.729e-191, chars_format::scientific, "1.729e-191"},
    {1.729e-190, chars_format::scientific, "1.729e-190"},
    {1.729e-189, chars_format::scientific, "1.729e-189"},
    {1.729e-188, chars_format::scientific, "1.729e-188"},
    {1.729e-187, chars_format::scientific, "1.729e-187"},
    {1.729e-186, chars_format::scientific, "1.729e-186"},
    {1.729e-185, chars_format::scientific, "1.729e-185"},
    {1.729e-184, chars_format::scientific, "1.729e-184"},
    {1.729e-183, chars_format::scientific, "1.729e-183"},
    {1.729e-182, chars_format::scientific, "1.729e-182"},
    {1.729e-181, chars_format::scientific, "1.729e-181"},
    {1.729e-180, chars_format::scientific, "1.729e-180"},
    {1.729e-179, chars_format::scientific, "1.729e-179"},
    {1.729e-178, chars_format::scientific, "1.729e-178"},
    {1.729e-177, chars_format::scientific, "1.729e-177"},
    {1.729e-176, chars_format::scientific, "1.729e-176"},
    {1.729e-175, chars_format::scientific, "1.729e-175"},
    {1.729e-174, chars_format::scientific, "1.729e-174"},
    {1.729e-173, chars_format::scientific, "1.729e-173"},
    {1.729e-172, chars_format::scientific, "1.729e-172"},
    {1.729e-171, chars_format::scientific, "1.729e-171"},
    {1.729e-170, chars_format::scientific, "1.729e-170"},
    {1.729e-169, chars_format::scientific, "1.729e-169"},
    {1.729e-168, chars_format::scientific, "1.729e-168"},
    {1.729e-167, chars_format::scientific, "1.729e-167"},
    {1.729e-166, chars_format::scientific, "1.729e-166"},
    {1.729e-165, chars_format::scientific, "1.729e-165"},
    {1.729e-164, chars_format::scientific, "1.729e-164"},
    {1.729e-163, chars_format::scientific, "1.729e-163"},
    {1.729e-162, chars_format::scientific, "1.729e-162"},
    {1.729e-161, chars_format::scientific, "1.729e-161"},
    {1.729e-160, chars_format::scientific, "1.729e-160"},
    {1.729e-159, chars_format::scientific, "1.729e-159"},
    {1.729e-158, chars_format::scientific, "1.729e-158"},
    {1.729e-157, chars_format::scientific, "1.729e-157"},
    {1.729e-156, chars_format::scientific, "1.729e-156"},
    {1.729e-155, chars_format::scientific, "1.729e-155"},
    {1.729e-154, chars_format::scientific, "1.729e-154"},
    {1.729e-153, chars_format::scientific, "1.729e-153"},
    {1.729e-152, chars_format::scientific, "1.729e-152"},
    {1.729e-151, chars_format::scientific, "1.729e-151"},
    {1.729e-150, chars_format::scientific, "1.729e-150"},
    {1.729e-149, chars_format::scientific, "1.729e-149"},
    {1.729e-148, chars_format::scientific, "1.729e-148"},
    {1.729e-147, chars_format::scientific, "1.729e-147"},
    {1.729e-146, chars_format::scientific, "1.729e-146"},
    {1.729e-145, chars_format::scientific, "1.729e-145"},
    {1.729e-144, chars_format::scientific, "1.729e-144"},
    {1.729e-143, chars_format::scientific, "1.729e-143"},
    {1.729e-142, chars_format::scientific, "1.729e-142"},
    {1.729e-141, chars_format::scientific, "1.729e-141"},
    {1.729e-140, chars_format::scientific, "1.729e-140"},
    {1.729e-139, chars_format::scientific, "1.729e-139"},
    {1.729e-138, chars_format::scientific, "1.729e-138"},
    {1.729e-137, chars_format::scientific, "1.729e-137"},
    {1.729e-136, chars_format::scientific, "1.729e-136"},
    {1.729e-135, chars_format::scientific, "1.729e-135"},
    {1.729e-134, chars_format::scientific, "1.729e-134"},
    {1.729e-133, chars_format::scientific, "1.729e-133"},
    {1.729e-132, chars_format::scientific, "1.729e-132"},
    {1.729e-131, chars_format::scientific, "1.729e-131"},
    {1.729e-130, chars_format::scientific, "1.729e-130"},
    {1.729e-129, chars_format::scientific, "1.729e-129"},
    {1.729e-128, chars_format::scientific, "1.729e-128"},
    {1.729e-127, chars_format::scientific, "1.729e-127"},
    {1.729e-126, chars_format::scientific, "1.729e-126"},
    {1.729e-125, chars_format::scientific, "1.729e-125"},
    {1.729e-124, chars_format::scientific, "1.729e-124"},
    {1.729e-123, chars_format::scientific, "1.729e-123"},
    {1.729e-122, chars_format::scientific, "1.729e-122"},
    {1.729e-121, chars_format::scientific, "1.729e-121"},
    {1.729e-120, chars_format::scientific, "1.729e-120"},
    {1.729e-119, chars_format::scientific, "1.729e-119"},
    {1.729e-118, chars_format::scientific, "1.729e-118"},
    {1.729e-117, chars_format::scientific, "1.729e-117"},
    {1.729e-116, chars_format::scientific, "1.729e-116"},
    {1.729e-115, chars_format::scientific, "1.729e-115"},
    {1.729e-114, chars_format::scientific, "1.729e-114"},
    {1.729e-113, chars_format::scientific, "1.729e-113"},
    {1.729e-112, chars_format::scientific, "1.729e-112"},
    {1.729e-111, chars_format::scientific, "1.729e-111"},
    {1.729e-110, chars_format::scientific, "1.729e-110"},
    {1.729e-109, chars_format::scientific, "1.729e-109"},
    {1.729e-108, chars_format::scientific, "1.729e-108"},
    {1.729e-107, chars_format::scientific, "1.729e-107"},
    {1.729e-106, chars_format::scientific, "1.729e-106"},
    {1.729e-105, chars_format::scientific, "1.729e-105"},
    {1.729e-104, chars_format::scientific, "1.729e-104"},
    {1.729e-103, chars_format::scientific, "1.729e-103"},
    {1.729e-102, chars_format::scientific, "1.729e-102"},
    {1.729e-101, chars_format::scientific, "1.729e-101"},
    {1.729e-100, chars_format::scientific, "1.729e-100"},
    {1.729e-99, chars_format::scientific, "1.729e-99"},
    {1.729e-98, chars_format::scientific, "1.729e-98"},
    {1.729e-97, chars_format::scientific, "1.729e-97"},
    {1.729e-96, chars_format::scientific, "1.729e-96"},
    {1.729e-95, chars_format::scientific, "1.729e-95"},
    {1.729e-94, chars_format::scientific, "1.729e-94"},
    {1.729e-93, chars_format::scientific, "1.729e-93"},
    {1.729e-92, chars_format::scientific, "1.729e-92"},
    {1.729e-91, chars_format::scientific, "1.729e-91"},
    {1.729e-90, chars_format::scientific, "1.729e-90"},
    {1.729e-89, chars_format::scientific, "1.729e-89"},
    {1.729e-88, chars_format::scientific, "1.729e-88"},
    {1.729e-87, chars_format::scientific, "1.729e-87"},
    {1.729e-86, chars_format::scientific, "1.729e-86"},
    {1.729e-85, chars_format::scientific, "1.729e-85"},
    {1.729e-84, chars_format::scientific, "1.729e-84"},
    {1.729e-83, chars_format::scientific, "1.729e-83"},
    {1.729e-82, chars_format::scientific, "1.729e-82"},
    {1.729e-81, chars_format::scientific, "1.729e-81"},
    {1.729e-80, chars_format::scientific, "1.729e-80"},
    {1.729e-79, chars_format::scientific, "1.729e-79"},
    {1.729e-78, chars_format::scientific, "1.729e-78"},
    {1.729e-77, chars_format::scientific, "1.729e-77"},
    {1.729e-76, chars_format::scientific, "1.729e-76"},
    {1.729e-75, chars_format::scientific, "1.729e-75"},
    {1.729e-74, chars_format::scientific, "1.729e-74"},
    {1.729e-73, chars_format::scientific, "1.729e-73"},
    {1.729e-72, chars_format::scientific, "1.729e-72"},
    {1.729e-71, chars_format::scientific, "1.729e-71"},
    {1.729e-70, chars_format::scientific, "1.729e-70"},
    {1.729e-69, chars_format::scientific, "1.729e-69"},
    {1.729e-68, chars_format::scientific, "1.729e-68"},
    {1.729e-67, chars_format::scientific, "1.729e-67"},
    {1.729e-66, chars_format::scientific, "1.729e-66"},
    {1.729e-65, chars_format::scientific, "1.729e-65"},
    {1.729e-64, chars_format::scientific, "1.729e-64"},
    {1.729e-63, chars_format::scientific, "1.729e-63"},
    {1.729e-62, chars_format::scientific, "1.729e-62"},
    {1.729e-61, chars_format::scientific, "1.729e-61"},
    {1.729e-60, chars_format::scientific, "1.729e-60"},
    {1.729e-59, chars_format::scientific, "1.729e-59"},
    {1.729e-58, chars_format::scientific, "1.729e-58"},
    {1.729e-57, chars_format::scientific, "1.729e-57"},
    {1.729e-56, chars_format::scientific, "1.729e-56"},
    {1.729e-55, chars_format::scientific, "1.729e-55"},
    {1.729e-54, chars_format::scientific, "1.729e-54"},
    {1.729e-53, chars_format::scientific, "1.729e-53"},
    {1.729e-52, chars_format::scientific, "1.729e-52"},
    {1.729e-51, chars_format::scientific, "1.729e-51"},
    {1.729e-50, chars_format::scientific, "1.729e-50"},
    {1.729e-49, chars_format::scientific, "1.729e-49"},
    {1.729e-48, chars_format::scientific, "1.729e-48"},
    {1.729e-47, chars_format::scientific, "1.729e-47"},
    {1.729e-46, chars_format::scientific, "1.729e-46"},
    {1.729e-45, chars_format::scientific, "1.729e-45"},
    {1.729e-44, chars_format::scientific, "1.729e-44"},
    {1.729e-43, chars_format::scientific, "1.729e-43"},
    {1.729e-42, chars_format::scientific, "1.729e-42"},
    {1.729e-41, chars_format::scientific, "1.729e-41"},
    {1.729e-40, chars_format::scientific, "1.729e-40"},
    {1.729e-39, chars_format::scientific, "1.729e-39"},
    {1.729e-38, chars_format::scientific, "1.729e-38"},
    {1.729e-37, chars_format::scientific, "1.729e-37"},
    {1.729e-36, chars_format::scientific, "1.729e-36"},
    {1.729e-35, chars_format::scientific, "1.729e-35"},
    {1.729e-34, chars_format::scientific, "1.729e-34"},
    {1.729e-33, chars_format::scientific, "1.729e-33"},
    {1.729e-32, chars_format::scientific, "1.729e-32"},
    {1.729e-31, chars_format::scientific, "1.729e-31"},
    {1.729e-30, chars_format::scientific, "1.729e-30"},
    {1.729e-29, chars_format::scientific, "1.729e-29"},
    {1.729e-28, chars_format::scientific, "1.729e-28"},
    {1.729e-27, chars_format::scientific, "1.729e-27"},
    {1.729e-26, chars_format::scientific, "1.729e-26"},
    {1.729e-25, chars_format::scientific, "1.729e-25"},
    {1.729e-24, chars_format::scientific, "1.729e-24"},
    {1.729e-23, chars_format::scientific, "1.729e-23"},
    {1.729e-22, chars_format::scientific, "1.729e-22"},
    {1.729e-21, chars_format::scientific, "1.729e-21"},
    {1.729e-20, chars_format::scientific, "1.729e-20"},
    {1.729e-19, chars_format::scientific, "1.729e-19"},
    {1.729e-18, chars_format::scientific, "1.729e-18"},
    {1.729e-17, chars_format::scientific, "1.729e-17"},
    {1.729e-16, chars_format::scientific, "1.729e-16"},
    {1.729e-15, chars_format::scientific, "1.729e-15"},
    {1.729e-14, chars_format::scientific, "1.729e-14"},
    {1.729e-13, chars_format::scientific, "1.729e-13"},
    {1.729e-12, chars_format::scientific, "1.729e-12"},
    {1.729e-11, chars_format::scientific, "1.729e-11"},
    {1.729e-10, chars_format::scientific, "1.729e-10"},
    {1.729e-9, chars_format::scientific, "1.729e-09"},
    {1.729e-8, chars_format::scientific, "1.729e-08"},
    {1.729e-7, chars_format::scientific, "1.729e-07"},
    {1.729e-6, chars_format::scientific, "1.729e-06"},
    {1.729e-5, chars_format::scientific, "1.729e-05"},
    {1.729e-4, chars_format::scientific, "1.729e-04"},
    {1.729e-3, chars_format::scientific, "1.729e-03"},
    {1.729e-2, chars_format::scientific, "1.729e-02"},
    {1.729e-1, chars_format::scientific, "1.729e-01"},
    {1.729e0, chars_format::scientific, "1.729e+00"},
    {1.729e1, chars_format::scientific, "1.729e+01"},
    {1.729e2, chars_format::scientific, "1.729e+02"},
    {1.729e3, chars_format::scientific, "1.729e+03"},
    {1.729e4, chars_format::scientific, "1.729e+04"},
    {1.729e5, chars_format::scientific, "1.729e+05"},
    {1.729e6, chars_format::scientific, "1.729e+06"},
    {1.729e7, chars_format::scientific, "1.729e+07"},
    {1.729e8, chars_format::scientific, "1.729e+08"},
    {1.729e9, chars_format::scientific, "1.729e+09"},
    {1.729e10, chars_format::scientific, "1.729e+10"},
    {1.729e11, chars_format::scientific, "1.729e+11"},
    {1.729e12, chars_format::scientific, "1.729e+12"},
    {1.729e13, chars_format::scientific, "1.729e+13"},
    {1.729e14, chars_format::scientific, "1.729e+14"},
    {1.729e15, chars_format::scientific, "1.729e+15"},
    {1.729e16, chars_format::scientific, "1.729e+16"},
    {1.729e17, chars_format::scientific, "1.729e+17"},
    {1.729e18, chars_format::scientific, "1.729e+18"},
    {1.729e19, chars_format::scientific, "1.729e+19"},
    {1.729e20, chars_format::scientific, "1.729e+20"},
    {1.729e21, chars_format::scientific, "1.729e+21"},
    {1.729e22, chars_format::scientific, "1.729e+22"},
    {1.729e23, chars_format::scientific, "1.729e+23"},
    {1.729e24, chars_format::scientific, "1.729e+24"},
    {1.729e25, chars_format::scientific, "1.729e+25"},
    {1.729e26, chars_format::scientific, "1.729e+26"},
    {1.729e27, chars_format::scientific, "1.729e+27"},
    {1.729e28, chars_format::scientific, "1.729e+28"},
    {1.729e29, chars_format::scientific, "1.729e+29"},
    {1.729e30, chars_format::scientific, "1.729e+30"},
    {1.729e31, chars_format::scientific, "1.729e+31"},
    {1.729e32, chars_format::scientific, "1.729e+32"},
    {1.729e33, chars_format::scientific, "1.729e+33"},
    {1.729e34, chars_format::scientific, "1.729e+34"},
    {1.729e35, chars_format::scientific, "1.729e+35"},
    {1.729e36, chars_format::scientific, "1.729e+36"},
    {1.729e37, chars_format::scientific, "1.729e+37"},
    {1.729e38, chars_format::scientific, "1.729e+38"},
    {1.729e39, chars_format::scientific, "1.729e+39"},
    {1.729e40, chars_format::scientific, "1.729e+40"},
    {1.729e41, chars_format::scientific, "1.729e+41"},
    {1.729e42, chars_format::scientific, "1.729e+42"},
    {1.729e43, chars_format::scientific, "1.729e+43"},
    {1.729e44, chars_format::scientific, "1.729e+44"},
    {1.729e45, chars_format::scientific, "1.729e+45"},
    {1.729e46, chars_format::scientific, "1.729e+46"},
    {1.729e47, chars_format::scientific, "1.729e+47"},
    {1.729e48, chars_format::scientific, "1.729e+48"},
    {1.729e49, chars_format::scientific, "1.729e+49"},
    {1.729e50, chars_format::scientific, "1.729e+50"},
    {1.729e51, chars_format::scientific, "1.729e+51"},
    {1.729e52, chars_format::scientific, "1.729e+52"},
    {1.729e53, chars_format::scientific, "1.729e+53"},
    {1.729e54, chars_format::scientific, "1.729e+54"},
    {1.729e55, chars_format::scientific, "1.729e+55"},
    {1.729e56, chars_format::scientific, "1.729e+56"},
    {1.729e57, chars_format::scientific, "1.729e+57"},
    {1.729e58, chars_format::scientific, "1.729e+58"},
    {1.729e59, chars_format::scientific, "1.729e+59"},
    {1.729e60, chars_format::scientific, "1.729e+60"},
    {1.729e61, chars_format::scientific, "1.729e+61"},
    {1.729e62, chars_format::scientific, "1.729e+62"},
    {1.729e63, chars_format::scientific, "1.729e+63"},
    {1.729e64, chars_format::scientific, "1.729e+64"},
    {1.729e65, chars_format::scientific, "1.729e+65"},
    {1.729e66, chars_format::scientific, "1.729e+66"},
    {1.729e67, chars_format::scientific, "1.729e+67"},
    {1.729e68, chars_format::scientific, "1.729e+68"},
    {1.729e69, chars_format::scientific, "1.729e+69"},
    {1.729e70, chars_format::scientific, "1.729e+70"},
    {1.729e71, chars_format::scientific, "1.729e+71"},
    {1.729e72, chars_format::scientific, "1.729e+72"},
    {1.729e73, chars_format::scientific, "1.729e+73"},
    {1.729e74, chars_format::scientific, "1.729e+74"},
    {1.729e75, chars_format::scientific, "1.729e+75"},
    {1.729e76, chars_format::scientific, "1.729e+76"},
    {1.729e77, chars_format::scientific, "1.729e+77"},
    {1.729e78, chars_format::scientific, "1.729e+78"},
    {1.729e79, chars_format::scientific, "1.729e+79"},
    {1.729e80, chars_format::scientific, "1.729e+80"},
    {1.729e81, chars_format::scientific, "1.729e+81"},
    {1.729e82, chars_format::scientific, "1.729e+82"},
    {1.729e83, chars_format::scientific, "1.729e+83"},
    {1.729e84, chars_format::scientific, "1.729e+84"},
    {1.729e85, chars_format::scientific, "1.729e+85"},
    {1.729e86, chars_format::scientific, "1.729e+86"},
    {1.729e87, chars_format::scientific, "1.729e+87"},
    {1.729e88, chars_format::scientific, "1.729e+88"},
    {1.729e89, chars_format::scientific, "1.729e+89"},
    {1.729e90, chars_format::scientific, "1.729e+90"},
    {1.729e91, chars_format::scientific, "1.729e+91"},
    {1.729e92, chars_format::scientific, "1.729e+92"},
    {1.729e93, chars_format::scientific, "1.729e+93"},
    {1.729e94, chars_format::scientific, "1.729e+94"},
    {1.729e95, chars_format::scientific, "1.729e+95"},
    {1.729e96, chars_format::scientific, "1.729e+96"},
    {1.729e97, chars_format::scientific, "1.729e+97"},
    {1.729e98, chars_format::scientific, "1.729e+98"},
    {1.729e99, chars_format::scientific, "1.729e+99"},
    {1.729e100, chars_format::scientific, "1.729e+100"},
    {1.729e101, chars_format::scientific, "1.729e+101"},
    {1.729e102, chars_format::scientific, "1.729e+102"},
    {1.729e103, chars_format::scientific, "1.729e+103"},
    {1.729e104, chars_format::scientific, "1.729e+104"},
    {1.729e105, chars_format::scientific, "1.729e+105"},
    {1.729e106, chars_format::scientific, "1.729e+106"},
    {1.729e107, chars_format::scientific, "1.729e+107"},
    {1.729e108, chars_format::scientific, "1.729e+108"},
    {1.729e109, chars_format::scientific, "1.729e+109"},
    {1.729e110, chars_format::scientific, "1.729e+110"},
    {1.729e111, chars_format::scientific, "1.729e+111"},
    {1.729e112, chars_format::scientific, "1.729e+112"},
    {1.729e113, chars_format::scientific, "1.729e+113"},
    {1.729e114, chars_format::scientific, "1.729e+114"},
    {1.729e115, chars_format::scientific, "1.729e+115"},
    {1.729e116, chars_format::scientific, "1.729e+116"},
    {1.729e117, chars_format::scientific, "1.729e+117"},
    {1.729e118, chars_format::scientific, "1.729e+118"},
    {1.729e119, chars_format::scientific, "1.729e+119"},
    {1.729e120, chars_format::scientific, "1.729e+120"},
    {1.729e121, chars_format::scientific, "1.729e+121"},
    {1.729e122, chars_format::scientific, "1.729e+122"},
    {1.729e123, chars_format::scientific, "1.729e+123"},
    {1.729e124, chars_format::scientific, "1.729e+124"},
    {1.729e125, chars_format::scientific, "1.729e+125"},
    {1.729e126, chars_format::scientific, "1.729e+126"},
    {1.729e127, chars_format::scientific, "1.729e+127"},
    {1.729e128, chars_format::scientific, "1.729e+128"},
    {1.729e129, chars_format::scientific, "1.729e+129"},
    {1.729e130, chars_format::scientific, "1.729e+130"},
    {1.729e131, chars_format::scientific, "1.729e+131"},
    {1.729e132, chars_format::scientific, "1.729e+132"},
    {1.729e133, chars_format::scientific, "1.729e+133"},
    {1.729e134, chars_format::scientific, "1.729e+134"},
    {1.729e135, chars_format::scientific, "1.729e+135"},
    {1.729e136, chars_format::scientific, "1.729e+136"},
    {1.729e137, chars_format::scientific, "1.729e+137"},
    {1.729e138, chars_format::scientific, "1.729e+138"},
    {1.729e139, chars_format::scientific, "1.729e+139"},
    {1.729e140, chars_format::scientific, "1.729e+140"},
    {1.729e141, chars_format::scientific, "1.729e+141"},
    {1.729e142, chars_format::scientific, "1.729e+142"},
    {1.729e143, chars_format::scientific, "1.729e+143"},
    {1.729e144, chars_format::scientific, "1.729e+144"},
    {1.729e145, chars_format::scientific, "1.729e+145"},
    {1.729e146, chars_format::scientific, "1.729e+146"},
    {1.729e147, chars_format::scientific, "1.729e+147"},
    {1.729e148, chars_format::scientific, "1.729e+148"},
    {1.729e149, chars_format::scientific, "1.729e+149"},
    {1.729e150, chars_format::scientific, "1.729e+150"},
    {1.729e151, chars_format::scientific, "1.729e+151"},
    {1.729e152, chars_format::scientific, "1.729e+152"},
    {1.729e153, chars_format::scientific, "1.729e+153"},
    {1.729e154, chars_format::scientific, "1.729e+154"},
    {1.729e155, chars_format::scientific, "1.729e+155"},
    {1.729e156, chars_format::scientific, "1.729e+156"},
    {1.729e157, chars_format::scientific, "1.729e+157"},
    {1.729e158, chars_format::scientific, "1.729e+158"},
    {1.729e159, chars_format::scientific, "1.729e+159"},
    {1.729e160, chars_format::scientific, "1.729e+160"},
    {1.729e161, chars_format::scientific, "1.729e+161"},
    {1.729e162, chars_format::scientific, "1.729e+162"},
    {1.729e163, chars_format::scientific, "1.729e+163"},
    {1.729e164, chars_format::scientific, "1.729e+164"},
    {1.729e165, chars_format::scientific, "1.729e+165"},
    {1.729e166, chars_format::scientific, "1.729e+166"},
    {1.729e167, chars_format::scientific, "1.729e+167"},
    {1.729e168, chars_format::scientific, "1.729e+168"},
    {1.729e169, chars_format::scientific, "1.729e+169"},
    {1.729e170, chars_format::scientific, "1.729e+170"},
    {1.729e171, chars_format::scientific, "1.729e+171"},
    {1.729e172, chars_format::scientific, "1.729e+172"},
    {1.729e173, chars_format::scientific, "1.729e+173"},
    {1.729e174, chars_format::scientific, "1.729e+174"},
    {1.729e175, chars_format::scientific, "1.729e+175"},
    {1.729e176, chars_format::scientific, "1.729e+176"},
    {1.729e177, chars_format::scientific, "1.729e+177"},
    {1.729e178, chars_format::scientific, "1.729e+178"},
    {1.729e179, chars_format::scientific, "1.729e+179"},
    {1.729e180, chars_format::scientific, "1.729e+180"},
    {1.729e181, chars_format::scientific, "1.729e+181"},
    {1.729e182, chars_format::scientific, "1.729e+182"},
    {1.729e183, chars_format::scientific, "1.729e+183"},
    {1.729e184, chars_format::scientific, "1.729e+184"},
    {1.729e185, chars_format::scientific, "1.729e+185"},
    {1.729e186, chars_format::scientific, "1.729e+186"},
    {1.729e187, chars_format::scientific, "1.729e+187"},
    {1.729e188, chars_format::scientific, "1.729e+188"},
    {1.729e189, chars_format::scientific, "1.729e+189"},
    {1.729e190, chars_format::scientific, "1.729e+190"},
    {1.729e191, chars_format::scientific, "1.729e+191"},
    {1.729e192, chars_format::scientific, "1.729e+192"},
    {1.729e193, chars_format::scientific, "1.729e+193"},
    {1.729e194, chars_format::scientific, "1.729e+194"},
    {1.729e195, chars_format::scientific, "1.729e+195"},
    {1.729e196, chars_format::scientific, "1.729e+196"},
    {1.729e197, chars_format::scientific, "1.729e+197"},
    {1.729e198, chars_format::scientific, "1.729e+198"},
    {1.729e199, chars_format::scientific, "1.729e+199"},
    {1.729e200, chars_format::scientific, "1.729e+200"},
    {1.729e201, chars_format::scientific, "1.729e+201"},
    {1.729e202, chars_format::scientific, "1.729e+202"},
    {1.729e203, chars_format::scientific, "1.729e+203"},
    {1.729e204, chars_format::scientific, "1.729e+204"},
    {1.729e205, chars_format::scientific, "1.729e+205"},
    {1.729e206, chars_format::scientific, "1.729e+206"},
    {1.729e207, chars_format::scientific, "1.729e+207"},
    {1.729e208, chars_format::scientific, "1.729e+208"},
    {1.729e209, chars_format::scientific, "1.729e+209"},
    {1.729e210, chars_format::scientific, "1.729e+210"},
    {1.729e211, chars_format::scientific, "1.729e+211"},
    {1.729e212, chars_format::scientific, "1.729e+212"},
    {1.729e213, chars_format::scientific, "1.729e+213"},
    {1.729e214, chars_format::scientific, "1.729e+214"},
    {1.729e215, chars_format::scientific, "1.729e+215"},
    {1.729e216, chars_format::scientific, "1.729e+216"},
    {1.729e217, chars_format::scientific, "1.729e+217"},
    {1.729e218, chars_format::scientific, "1.729e+218"},
    {1.729e219, chars_format::scientific, "1.729e+219"},
    {1.729e220, chars_format::scientific, "1.729e+220"},
    {1.729e221, chars_format::scientific, "1.729e+221"},
    {1.729e222, chars_format::scientific, "1.729e+222"},
    {1.729e223, chars_format::scientific, "1.729e+223"},
    {1.729e224, chars_format::scientific, "1.729e+224"},
    {1.729e225, chars_format::scientific, "1.729e+225"},
    {1.729e226, chars_format::scientific, "1.729e+226"},
    {1.729e227, chars_format::scientific, "1.729e+227"},
    {1.729e228, chars_format::scientific, "1.729e+228"},
    {1.729e229, chars_format::scientific, "1.729e+229"},
    {1.729e230, chars_format::scientific, "1.729e+230"},
    {1.729e231, chars_format::scientific, "1.729e+231"},
    {1.729e232, chars_format::scientific, "1.729e+232"},
    {1.729e233, chars_format::scientific, "1.729e+233"},
    {1.729e234, chars_format::scientific, "1.729e+234"},
    {1.729e235, chars_format::scientific, "1.729e+235"},
    {1.729e236, chars_format::scientific, "1.729e+236"},
    {1.729e237, chars_format::scientific, "1.729e+237"},
    {1.729e238, chars_format::scientific, "1.729e+238"},
    {1.729e239, chars_format::scientific, "1.729e+239"},
    {1.729e240, chars_format::scientific, "1.729e+240"},
    {1.729e241, chars_format::scientific, "1.729e+241"},
    {1.729e242, chars_format::scientific, "1.729e+242"},
    {1.729e243, chars_format::scientific, "1.729e+243"},
    {1.729e244, chars_format::scientific, "1.729e+244"},
    {1.729e245, chars_format::scientific, "1.729e+245"},
    {1.729e246, chars_format::scientific, "1.729e+246"},
    {1.729e247, chars_format::scientific, "1.729e+247"},
    {1.729e248, chars_format::scientific, "1.729e+248"},
    {1.729e249, chars_format::scientific, "1.729e+249"},
    {1.729e250, chars_format::scientific, "1.729e+250"},
    {1.729e251, chars_format::scientific, "1.729e+251"},
    {1.729e252, chars_format::scientific, "1.729e+252"},
    {1.729e253, chars_format::scientific, "1.729e+253"},
    {1.729e254, chars_format::scientific, "1.729e+254"},
    {1.729e255, chars_format::scientific, "1.729e+255"},
    {1.729e256, chars_format::scientific, "1.729e+256"},
    {1.729e257, chars_format::scientific, "1.729e+257"},
    {1.729e258, chars_format::scientific, "1.729e+258"},
    {1.729e259, chars_format::scientific, "1.729e+259"},
    {1.729e260, chars_format::scientific, "1.729e+260"},
    {1.729e261, chars_format::scientific, "1.729e+261"},
    {1.729e262, chars_format::scientific, "1.729e+262"},
    {1.729e263, chars_format::scientific, "1.729e+263"},
    {1.729e264, chars_format::scientific, "1.729e+264"},
    {1.729e265, chars_format::scientific, "1.729e+265"},
    {1.729e266, chars_format::scientific, "1.729e+266"},
    {1.729e267, chars_format::scientific, "1.729e+267"},
    {1.729e268, chars_format::scientific, "1.729e+268"},
    {1.729e269, chars_format::scientific, "1.729e+269"},
    {1.729e270, chars_format::scientific, "1.729e+270"},
    {1.729e271, chars_format::scientific, "1.729e+271"},
    {1.729e272, chars_format::scientific, "1.729e+272"},
    {1.729e273, chars_format::scientific, "1.729e+273"},
    {1.729e274, chars_format::scientific, "1.729e+274"},
    {1.729e275, chars_format::scientific, "1.729e+275"},
    {1.729e276, chars_format::scientific, "1.729e+276"},
    {1.729e277, chars_format::scientific, "1.729e+277"},
    {1.729e278, chars_format::scientific, "1.729e+278"},
    {1.729e279, chars_format::scientific, "1.729e+279"},
    {1.729e280, chars_format::scientific, "1.729e+280"},
    {1.729e281, chars_format::scientific, "1.729e+281"},
    {1.729e282, chars_format::scientific, "1.729e+282"},
    {1.729e283, chars_format::scientific, "1.729e+283"},
    {1.729e284, chars_format::scientific, "1.729e+284"},
    {1.729e285, chars_format::scientific, "1.729e+285"},
    {1.729e286, chars_format::scientific, "1.729e+286"},
    {1.729e287, chars_format::scientific, "1.729e+287"},
    {1.729e288, chars_format::scientific, "1.729e+288"},
    {1.729e289, chars_format::scientific, "1.729e+289"},
    {1.729e290, chars_format::scientific, "1.729e+290"},
    {1.729e291, chars_format::scientific, "1.729e+291"},
    {1.729e292, chars_format::scientific, "1.729e+292"},
    {1.729e293, chars_format::scientific, "1.729e+293"},
    {1.729e294, chars_format::scientific, "1.729e+294"},
    {1.729e295, chars_format::scientific, "1.729e+295"},
    {1.729e296, chars_format::scientific, "1.729e+296"},
    {1.729e297, chars_format::scientific, "1.729e+297"},
    {1.729e298, chars_format::scientific, "1.729e+298"},
    {1.729e299, chars_format::scientific, "1.729e+299"},
    {1.729e300, chars_format::scientific, "1.729e+300"},
    {1.729e301, chars_format::scientific, "1.729e+301"},
    {1.729e302, chars_format::scientific, "1.729e+302"},
    {1.729e303, chars_format::scientific, "1.729e+303"},
    {1.729e304, chars_format::scientific, "1.729e+304"},
    {1.729e305, chars_format::scientific, "1.729e+305"},
    {1.729e306, chars_format::scientific, "1.729e+306"},
    {1.729e307, chars_format::scientific, "1.729e+307"},
    {1.729e308, chars_format::scientific, "1.729e+308"},

    // Test all of the cases for fixed notation, including the non-Ryu fallback for large integers.
    {1.729e-4, chars_format::fixed, "0.0001729"},
    {1.729e-3, chars_format::fixed, "0.001729"},
    {1.729e-2, chars_format::fixed, "0.01729"},
    {1.729e-1, chars_format::fixed, "0.1729"},
    {1.729e0, chars_format::fixed, "1.729"},
    {1.729e1, chars_format::fixed, "17.29"},
    {1.729e2, chars_format::fixed, "172.9"},
    {1.729e3, chars_format::fixed, "1729"},
    {1.729e4, chars_format::fixed, "17290"},
    {1.729e5, chars_format::fixed, "172900"},
    {1.729e6, chars_format::fixed, "1729000"},
    {1.729e7, chars_format::fixed, "17290000"},
    {1.729e8, chars_format::fixed, "172900000"},
    {1.729e9, chars_format::fixed, "1729000000"},
    {1.729e10, chars_format::fixed, "17290000000"},
    {1.729e11, chars_format::fixed, "172900000000"},
    {1.729e12, chars_format::fixed, "1729000000000"},
    {1.729e13, chars_format::fixed, "17290000000000"},
    {1.729e14, chars_format::fixed, "172900000000000"},
    {1.729e15, chars_format::fixed, "1729000000000000"},
    {1.729e16, chars_format::fixed, "17290000000000000"},
    {1.729e17, chars_format::fixed, "172900000000000000"},
    {1.729e18, chars_format::fixed, "1729000000000000000"},
    {1.729e19, chars_format::fixed, "17290000000000000000"},
    {1.729e20, chars_format::fixed, "172900000000000000000"},
    {1.729e21, chars_format::fixed, "1729000000000000000000"},
    {1.729e22, chars_format::fixed, "17289999999999999475712"},
    {1.729e23, chars_format::fixed, "172900000000000015728640"},
    {1.729e24, chars_format::fixed, "1728999999999999888850944"},
    {1.729e25, chars_format::fixed, "17290000000000000499122176"},
    {1.729e26, chars_format::fixed, "172899999999999987811352576"},
    {1.729e27, chars_format::fixed, "1729000000000000084271955968"},
    {1.729e28, chars_format::fixed, "17290000000000000842719559680"},
    {1.729e29, chars_format::fixed, "172900000000000004029149085696"},
    {1.729e30, chars_format::fixed, "1728999999999999969922746679296"},
    {1.729e31, chars_format::fixed, "17290000000000000825127373635584"},
    {1.729e32, chars_format::fixed, "172899999999999994740474854244352"},
    {1.729e33, chars_format::fixed, "1729000000000000019462342580371456"},
    {1.729e34, chars_format::fixed, "17290000000000000771084178107138048"},
    {1.729e35, chars_format::fixed, "172900000000000003099155762643992576"},
    {1.729e36, chars_format::fixed, "1728999999999999957204581331601719296"},
    {1.729e37, chars_format::fixed, "17289999999999998981750002957311541248"},
    {1.729e38, chars_format::fixed, "172900000000000018151698926790986694656"},
    {1.729e39, chars_format::fixed, "1728999999999999879285534364252573270016"},
    {1.729e40, chars_format::fixed, "17289999999999999397318253449840320053248"},
    {1.729e41, chars_format::fixed, "172899999999999993973182534498403200532480"},
    {1.729e42, chars_format::fixed, "1728999999999999978417451572652165595922432"},
    {1.729e43, chars_format::fixed, "17290000000000001022114555011901930858348544"},
    {1.729e44, chars_format::fixed, "172899999999999995365865078694456009793994752"},
    {1.729e45, chars_format::fixed, "1729000000000000112114975815473235285027848192"},
    {1.729e46, chars_format::fixed, "17289999999999999853499157926502951353575276544"},
    {1.729e47, chars_format::fixed, "172900000000000003605593980177947119522565586944"},
    {1.729e48, chars_format::fixed, "1728999999999999914361482179869448651542148153344"},
    {1.729e49, chars_format::fixed, "17290000000000001090726143749254847214357604990976"},
    {1.729e50, chars_format::fixed, "172900000000000000522667720422893215082583391469568"},
    {1.729e51, chars_format::fixed, "1729000000000000046765052072507553179069804548456448"},
    {1.729e52, chars_format::fixed, "17289999999999999138422524940159658886890985204219904"},
    {1.729e53, chars_format::fixed, "172899999999999991384225249401596588868909852042199040"},
    {1.729e54, chars_format::fixed, "1729000000000000083983435954485197620376402236306096128"},
    {1.729e55, chars_format::fixed, "17289999999999999478704891861098122350265592635988115456"},
    {1.729e56, chars_format::fixed, "172899999999999994787048918610981223502655926359881154560"},
    {1.729e57, chars_format::fixed, "1729000000000000122095061049630305528274358268664135811072"},
    {1.729e58, chars_format::fixed, "17289999999999999130255748134057135763769994625857466925056"},
    {1.729e59, chars_format::fixed, "172900000000000002452930080605882928405559082582755422240768"},
    {1.729e60, chars_format::fixed, "1728999999999999846123339217813844151769844644640662174564352"},
    {1.729e61, chars_format::fixed, "17290000000000000602104931237078263105127400620649326319763456"},
    {1.729e62, chars_format::fixed, "172899999999999994603067770723103582584986250610532172135661568"},
    {1.729e63, chars_format::fixed, "1728999999999999991702603873821752019715013528489166085604507648"},
    {1.729e64, chars_format::fixed, "17289999999999999917026038738217520197150135284891660856045076480"},
    {1.729e65, chars_format::fixed, "172899999999999999170260387382175201971501352848916608560450764800"},
    {1.729e66, chars_format::fixed, "1728999999999999898166499084643965254679184234647052827624824897536"},
    {1.729e67, chars_format::fixed, "17290000000000000478242667473284240787365111047944340403923172982784"},
    {1.729e68, chars_format::fixed, "172899999999999992809805261718085701949064960867652907017832337768448"},
    {1.729e69, chars_format::fixed, "1729000000000000167550480877475991137982372600912339010606311218872320"},
    {1.729e70, chars_format::fixed, "17289999999999998610513727042982194663129671708505022868584867821518848"},
    {1.729e71, chars_format::fixed, "172900000000000010625065924284043680364849151489997166585674633152823296"},
    {1.729e72, chars_format::fixed, "1729000000000000008170944627423549868714281777280183914257442511777693696"},
    {1.729e73, chars_format::fixed, "17290000000000000081709446274235498687142817772801839142574425117776936960"},
    {1.729e74, chars_format::fixed, "172900000000000000817094462742354986871428177728018391425744251177769369600"},
    {1.729e75, chars_format::fixed, "1728999999999999957954130744330103758027966391618852585438598956065417592832"},
    {1.729e76, chars_format::fixed, "17289999999999999981275818508048606465770187001479176484936738006352384753664"},
    {1.729e77, chars_format::fixed, "172899999999999993385006008044524962489853500650141354760555404932352506331136"},
    {1.729e78, chars_format::fixed, "1728999999999999933850060080445249624898535006501413547605554049323525063311360"},
    {1.729e79, chars_format::fixed, "17289999999999998515748322143849475171500758786338882984687607676445318958809088"},
    {1.729e80, chars_format::fixed,
        "172900000000000004903537909292967257574637778551594889639706464367411549771399168"},
    {1.729e81, chars_format::fixed,
        "1728999999999999996379233258651079226787363943680732736949516943399559870558502912"},
    {1.729e82, chars_format::fixed,
        "17289999999999999121293999238053298684529417967443868818334406229602708671097208832"},
    {1.729e83, chars_format::fixed,
        "172900000000000011432899992743512832845555494939161693411202379201456447538679775232"},
    {1.729e84, chars_format::fixed,
        "1728999999999999898649426590230009971119434253234571545014868411689984626557915758592"},
    {1.729e85, chars_format::fixed,
        "17289999999999998555135119227889862996522101140031624671954373356250686567921393598464"},
    {1.729e86, chars_format::fixed,
        "172899999999999992453097539069462417399976873677341699170652705732893420841738159783936"},
    {1.729e87, chars_format::fixed,
        "1729000000000000034958916939343644772955862533205824230924270612055119091017769178628096"},
    {1.729e88, chars_format::fixed,
        "17289999999999999907877403198840365333734250146328613352371731901646451379776141463126016"},
    {1.729e89, chars_format::fixed,
        "172900000000000013213550550215478290003722507406634260143588494021416178770611024972218368"},
    {1.729e90, chars_format::fixed,
        "1729000000000000019057293356338185806706185026519557588476915540174548467923313366994518016"},
    {1.729e91, chars_format::fixed,
        "17289999999999998833634387813582692947089369694634155729261522601270124841839571077213192192"},
    {1.729e92, chars_format::fixed,
        "172900000000000002810355032800351357417266823032330038951363309217771753350593711761273126912"},
    {1.729e93, chars_format::fixed,
        "1728999999999999912311461090687318150601683221635392536243648426537153494048353109699601629184"},
    {1.729e94, chars_format::fixed,
        "17289999999999999586282967856137963200300772251105556775516422927933791098313867128648534851584"},
    {1.729e95, chars_format::fixed,
        "172900000000000003273523389749616139111550763067081670364443247880334009508424047792925645471744"},
    {1.729e96, chars_format::fixed,
        "1729000000000000032735233897496161391115507630670816703644432478803340095084240477929256454717440"},
    {1.729e97, chars_format::fixed,
        "17290000000000001275921134007055886821048585497879508170432039168960901562078932972116922557530112"},
    {1.729e98, chars_format::fixed,
        "172899999999999997582110619557050501652189707920053623560516961594769005841004878635979497409609728"},
    {1.729e99, chars_format::fixed,
        "1729000000000000097237911959678571948988266255670467900755597056706410136648324395041312799421628416"},
    {1.729e100, chars_format::fixed,
        "17290000000000000001044673483921184030151709144945225686352551040994340740577039080960985391612035072"},
    {1.729e101, chars_format::fixed,
        "172900000000000007781122303742128123979364718743527883433152866618501492413020029765226994736954343424"},
    {1.729e102, chars_format::fixed,
        "1729000000000000015645818486197950970370866169082673821774509816516550244072203186007332820802871492608"},
    {1.729e103, chars_format::fixed,
        "17290000000000000653781421271766151859090909837647578318201248962513219881186008753232825220562090459136"},
    {1.729e104, chars_format::fixed,
        "17289999999999999062347064760448896961867715767820889996741566411000524071701282695122434780455288753356"
        "8"},
    {1.729e105, chars_format::fixed,
        "172899999999999990623470647604488969618677157678208899967415664110005240717012826951224347804552887533568"
        "0"},
    {1.729e106, chars_format::fixed,
        "1728999999999999957160605884407041852897913787016543025960866482748458673073639503371775972128946529920614"
        "4"},
    {1.729e107, chars_format::fixed,
        "1729000000000000079382764464476207029004655091579232689048970102704633711242066464634653957929148900924456"
        "96"},
    {1.729e108, chars_format::fixed,
        "1729000000000000079382764464476207029004655091579232689048970102704633711242066464634653957929148900924456"
        "960"},
    {1.729e109, chars_format::fixed,
        "1728999999999999922938401481987675603588026221738989920296197469160729662386479954218170136104889866039538"
        "4832"},
    {1.729e110, chars_format::fixed,
        "1729000000000000006375395072648225697143561618987119396964342873717478488442792759773628174411161351311495"
        "00416"},
    {1.729e111, chars_format::fixed,
        "1729000000000000073124989945176665771987989936785622978298859197362877549287843004217994605056178539529060"
        "220928"},
    {1.729e112, chars_format::fixed,
        "1729000000000000019725314047153913712112447282546820113231246138446558300611802808662501460540164788955008"
        "0475136"},
    {1.729e113, chars_format::fixed,
        "1729000000000000062445054765572115360012881405937862405285336585579613699552634965106895976152975789414249"
        "78624512"},
    {1.729e114, chars_format::fixed,
        "1728999999999999994093469616102992723372186808512194737998791870166725061247303514795864751172478188679463"
        "004274688"},
    {1.729e115, chars_format::fixed,
        "1729000000000000048774737735678290832684742486452728871828027642497035971891568675044689731156876269267292"
        "4298510336"},
    {1.729e116, chars_format::fixed,
        "1729000000000000136264766726998767807584831571157583485954804878225533428922392931442809699131913198207819"
        "51077318656"},
    {1.729e117, chars_format::fixed,
        "1728999999999999996280720340886004647744689035629816103351961301059937497673074121205817750371854111902976"
        "181297741824"},
    {1.729e118, chars_format::fixed,
        "1729000000000000108267957449776215175616803064052030009434236162792414242672529169395411309379901380946850"
        "8448780976128"},
    {1.729e119, chars_format::fixed,
        "1728999999999999884293483231995794119872575007207602197269686439327460752673619073016224191363806842859101"
        "51771738603520"},
    {1.729e120, chars_format::fixed,
        "1729000000000000099308978481064998333387033941778252896947654173853816103072572765540243824659257599423340"
        "871791669149696"},
    {1.729e121, chars_format::fixed,
        "1729000000000000041971513081313210543116511559226079377033529444646788009632851780867171922447137397672877"
        "0440385269858304"},
    {1.729e122, chars_format::fixed,
        "1728999999999999904361596121908919846467257841100862929239630094549920585377521417651799357138048913471763"
        "85743098579255296"},
    {1.729e123, chars_format::fixed,
        "1728999999999999977753551833591208218013526490767645034729709747934916544980364278033331391969562771712357"
        "556955007762300928"},
    {1.729e124, chars_format::fixed,
        "1729000000000000095180680972282869612487556330234496403513837193350910080344912854643782647699984944897307"
        "4761934429138976768"},
    {1.729e125, chars_format::fixed,
        "1729000000000000048209829316806205054697944394447755856000186215184512666199093423999602145407816075623327"
        "50849806885325897728"},
    {1.729e126, chars_format::fixed,
        "1729000000000000048209829316806205054697944394447755856000186215184512666199093423999602145407816075623327"
        "508498068853258977280"},
    {1.729e127, chars_format::fixed,
        "1728999999999999927964449078785943786756537838833700054365239711078535285985795681550500059539863770281938"
        "7911979112580239065088"},
    {1.729e128, chars_format::fixed,
        "1728999999999999927964449078785943786756537838833700054365239711078535285985795681550500059539863770281938"
        "79119791125802390650880"},
    {1.729e129, chars_format::fixed,
        "1729000000000000120357057459618361815462788327816189336981154117648099094327072069469063396928587458828160"
        "738878163410400019742720"},
    {1.729e130, chars_format::fixed,
        "1728999999999999997225788095885614277090788014867396196106968897443578256988655181201182860999804298158578"
        "6923628020328793072730112"},
    {1.729e131, chars_format::fixed,
        "1728999999999999997225788095885614277090788014867396196106968897443578256988655181201182860999804298158578"
        "69236280203287930727301120"},
    {1.729e132, chars_format::fixed,
        "1729000000000000036627794292280093489369828115011010001186708167909024924936948585446904632497014909572844"
        "947247717673685935263318016"},
    {1.729e133, chars_format::fixed,
        "1729000000000000099671004206511260229016292275240792089314291000653739593654218032240059466892551887835670"
        "9550635826989765400478089216"},
    {1.729e134, chars_format::fixed,
        "1728999999999999948367300412356460053864778290689315077808092202066424388732771359936487864343263140004888"
        "53630550663827908856503074816"},
    {1.729e135, chars_format::fixed,
        "1728999999999999988714954757464406767238515353236375614209745215023041776711823805884106958356406806093097"
        "181307660254465075627104927744"},
    {1.729e136, chars_format::fixed,
        "1728999999999999924158707805291692025840536053161078755967100394292453955945339892367916407935376940351963"
        "3493042144685674963277862404096"},
    {1.729e137, chars_format::fixed,
        "1728999999999999975803705367029863818958919493221316242561216250876924212558527023180868848272200832944870"
        "41490697109728555976724119027712"},
    {1.729e138, chars_format::fixed,
        "1729000000000000099751699515201476122443039749365886210387094306679652828430176137131954705080578175167847"
        "372353587006208912021933069959168"},
    {1.729e139, chars_format::fixed,
        "1729000000000000099751699515201476122443039749365886210387094306679652828430176137131954705080578175167847"
        "3723535870062089120219330699591680"},
    {1.729e140, chars_format::fixed,
        "1728999999999999993982744508761700290136590464122519837842345032394657742886368893227028107270762843137573"
        "70199914143059431809792933263048704"},
    {1.729e141, chars_format::fixed,
        "1729000000000000036290326511337610623059170178219866386860244742108655777103891790788998746394688975949683"
        "170140919660840155667530827561959424"},
    {1.729e142, chars_format::fixed,
        "1729000000000000036290326511337610623059170178219866386860244742108655777103891790788998746394688975949683"
        "1701409196608401556675308275619594240"},
    {1.729e143, chars_format::fixed,
        "1729000000000000090444031474634775849200072212264469969603156370542573260902321099668321164473314425949183"
        "28936239579555482775662074107424407552"},
    {1.729e144, chars_format::fixed,
        "1728999999999999873829211621446114944636464076086055638631509856806903325708603864151031492158812625951182"
        "812476491256696139400261087025105469440"},
    {1.729e145, chars_format::fixed,
        "1728999999999999943145953974466486434096818679663148224542436741202317704970593379516564187299453201950542"
        "9650799807091309196742961763208298233856"},
    {1.729e146, chars_format::fixed,
        "1728999999999999943145953974466486434096818679663148224542436741202317704970593379516564187299453201950542"
        "96507998070913091967429617632082982338560"},
    {1.729e147, chars_format::fixed,
        "1729000000000000031871384186332561940606072572241826734508423153228448110425939959184446037079473139229723"
        "960412447208247438425061090619356996435968"},
    {1.729e148, chars_format::fixed,
        "1728999999999999889910695847346841130191266344115941118562844893986639461697385431715835077431441239583034"
        "3678805008096610084238372277417135195553792"},
    {1.729e149, chars_format::fixed,
        "1728999999999999946694971182941129454357188835366295364941076197683362921188807242703279461290653999441710"
        "20489327936909558042432677289277091030761472"},
    {1.729e150, chars_format::fixed,
        "1728999999999999946694971182941129454357188835366295364941076197683362921188807242703279461290653999441710"
        "204893279369095580424326772892770910307614720"},
    {1.729e151, chars_format::fixed,
        "1728999999999999946694971182941129454357188835366295364941076197683362921188807242703279461290653999441710"
        "2048932793690955804243267728927709103076147200"},
    {1.729e152, chars_format::fixed,
        "1729000000000000062989167070238231942248998097447020861523693907654252566227239111605565559434321731632278"
        "31909544985881758388132936136213644656819306496"},
    {1.729e153, chars_format::fixed,
        "1729000000000000156024523780075913932562445507111601258789788075630964282257984606727394437949255917384732"
        "810457186250595186646931432137628875576655740928"},
    {1.729e154, chars_format::fixed,
        "1728999999999999932739667676465477155810171723916608305351162072486856163784195418435005129513413871578842"
        "0311890189103289400094864622764470459563453186048"},
    {1.729e155, chars_format::fixed,
        "1728999999999999932739667676465477155810171723916608305351162072486856163784195418435005129513413871578842"
        "03118901891032894000948646227644704595634531860480"},
    {1.729e156, chars_format::fixed,
        "1728999999999999885105565041028583976769686650168343141950921858482779765176453724932628743713767568473585"
        "331611809877738807393498202039394922304012428509184"},
    {1.729e157, chars_format::fixed,
        "1728999999999999961320129257727613063234462768165567403391306200889302002948840434536430960993201653441996"
        "0509353443298830195790794184186783201477450526621696"},
    {1.729e158, chars_format::fixed,
        "1729000000000000022291780631086836332406283662563346812543613674814519793166749802219472734816748921416724"
        "62639417189159838932754439152210503842273115198455808"},
    {1.729e159, chars_format::fixed,
        "1729000000000000071069101729774214947743740378081570339865459653954694025341077296365906153875586735796507"
        "486761233940970685126316370004846413042720031442468864"},
    {1.729e160, chars_format::fixed,
        "1728999999999999875959817335024700486393913516008676230578075737393997096643767319780172477640235478277376"
        "0452929857434815019312284560738809145627645136108257280"},
    {1.729e161, chars_format::fixed,
        "1729000000000000000829759347664389741657802707735328460522001443992843131010045704795042030430860283089620"
        "16783266458987457917608472098969883358993604502307733504"},
    {1.729e162, chars_format::fixed,
        "1729000000000000050777736152720265443763358384425989352499571726632381544756557058800989851547110205014517"
        "816848536128431810074027226956026001200804657587977977856"},
    {1.729e163, chars_format::fixed,
        "1728999999999999970860973264630864320394469301720931925335459274409120082762138892391473337761110329934681"
        "5784231416667402406373192174099025330234148774841369493504"},
    {1.729e164, chars_format::fixed,
        "1728999999999999970860973264630864320394469301720931925335459274409120082762138892391473337761110329934681"
        "57842314166674024063731921740990253302341487748413694935040"},
    {1.729e165, chars_format::fixed,
        "1728999999999999919714245016253647601438380288789695171950427304986232747085711265889382768938070409883586"
        "385830889211257636197826091300383513389885418217678691106816"},
    {1.729e166, chars_format::fixed,
        "1728999999999999837879479818850100851108637868099716366534376153909613010003427063486037858821206537801834"
        "0776832852824854690946370895251530819762382833913454779170816"},
    {1.729e167, chars_format::fixed,
        "1729000000000000099750728450541450452163813614307648543865739837354796168666736511176741571195170928463441"
        "46375561785455640382484189520589046249990911483561176012423168"},
    {1.729e168, chars_format::fixed,
        "1729000000000000047376478724203180531952778465066062108399467100665759536934074621638600828720378050331119"
        "986541151340142216878800934069742986395174948546758503682801664"},
    {1.729e169, chars_format::fixed,
        "1729000000000000005477078943132564595783950345672792960026448911314530231547945110008088234740543747825262"
        "8047695781286108673219681651608250055113876155156758985296576512"},
    {1.729e170, chars_format::fixed,
        "1729000000000000072516118592845550093654075336702023597423278014276497120165752328616908385108278631834634"
        "29560409526706102661290059541509377492544734836540806677468807168"},
    {1.729e171, chars_format::fixed,
        "1728999999999999911622423433534384898765775358231870067670888167167776587483015003955740024225714910212142"
        "717601254134780644314662762804848728331703989526050862986615062528"},
    {1.729e172, chars_format::fixed,
        "1729000000000000126147350312615938491950175329525408107340741296646070631059998103503964505402466539042131"
        "4882717089778211540456465396185087904566951346451938013707124080640"},
    {1.729e173, chars_format::fixed,
        "1729000000000000057499373711309841342131167338711475934646388295213016537115363511648532671425906017816535"
        "08165716342804819093173173103813757057669796820706806108780125749248"},
    {1.729e174, chars_format::fixed,
        "1728999999999999892744229868175208182565548160758038720179941091773686711648240491195496269882160766875103"
        "705782254108593079458336190445246642864704768755566284408814496120832"},
    {1.729e175, chars_format::fixed,
        "1729000000000000112417754992354719061986373731362621672801870696359459812271071185132878138607154434797012"
        "2069487998678665614228635779024345464806957013575686533141301779496960"},
    {1.729e176, chars_format::fixed,
        "1728999999999999901531170873142388617742381183582222038284818275957117635673153718952991544631160513591980"
        "04582891593896401873691728594353415900934440605964637916502712339398656"},
    {1.729e177, chars_format::fixed,
        "1729000000000000014004015736722298188005843875731768510027246233505033463192043034248931061418357271567997"
        "198426187367712041502755308321614365660731763551871592044548752490364928"},
    {1.729e178, chars_format::fixed,
        "1729000000000000103982291627586225844216614029451405687421188599543366125207154486485682674848114677948810"
        "9205040045107104597154257262240785309818416495456517623481660557674676224"},
    {1.729e179, chars_format::fixed,
        "1729000000000000103982291627586225844216614029451405687421188599543366125207154486485682674848114677948810"
        "92050400451071045971542572622407853098184164954565176234816605576746762240"},
    {1.729e180, chars_format::fixed,
        "1729000000000000103982291627586225844216614029451405687421188599543366125207154486485682674848114677948810"
        "920504004510710459715425726224078530981841649545651762348166055767467622400"},
    {1.729e181, chars_format::fixed,
        "1729000000000000057913414371463894884236699710746951452595490108131739802255417422940465848772078885881834"
        "2948001621334952695905384722580168783374333879168363151527139964895910428672"},
    {1.729e182, chars_format::fixed,
        "1729000000000000131623617981259624420204562620674078228316607694390341918978196724612812770493736153188996"
        "89592630993703957379035807860371552256848660652294103066543729133419357011968"},
    {1.729e183, chars_format::fixed,
        "1728999999999999954719129317749873533881691636848973966585925487369696838843526400599180158361758711651806"
        "653223555208533243710791023374038776413958881868289713434901383707147504713728"},
    {1.729e184, chars_format::fixed,
        "1728999999999999813195538386942072824823394849788890557201379721753180774735790141388274068656176758422054"
        "4590613514257281796471373791902973794903367021445686596504726576055106523889664"},
    {1.729e185, chars_format::fixed,
        "1729000000000000115112532372665381004147761328850401830555077355068415044832294161038207060028084925312192"
        "47327405282904564964959848678227902626073068555517357439058727328900260401512448"},
    {1.729e186, chars_format::fixed,
        "1728999999999999933962335981231396096553141441413495066542858775079274482774391749248247265204940025178109"
        "664746431987055167648121822227090038198494295508810625546518503878907433039429632"},
    {1.729e187, chars_format::fixed,
        "1729000000000000078882493094378584022628837351363020477752633639070586932420713678680215101063455945285375"
        "9115685286606475532493031538712412286482834075459009846217735194069835698199855104"},
    {1.729e188, chars_format::fixed,
        "1729000000000000001591742634033417128721799532723273591774087044941886959276008649649832255272247454561500"
        "57993007710139828092867311032769392707506254779278612644830417779200963020368904192"},
    {1.729e189, chars_format::fixed,
        "1729000000000000001591742634033417128721799532723273591774087044941886959276008649649832255272247454561500"
        "579930077101398280928673110327693927075062547792786126448304177792009630203689041920"},
    {1.729e190, chars_format::fixed,
        "1728999999999999952125662339412510316621295328793835584747817224699518976463397431070387233965874020498220"
        "3676814681034787466434698824598236540682011975507926172172837991584263088492593020928"},
    {1.729e191, chars_format::fixed,
        "1729000000000000070844255046502686665662505418224486801610864793281202135213664355661055285101170262250092"
        "87707812969848562892795762934271230928466843813157703937173270787902628009989067767808"},
    {1.729e192, chars_format::fixed,
        "1728999999999999880894506715158404507196569275135444854629988683550509081213237276315986403284696275447096"
        "862043471146474617272777234330090460938320853202321963924614453926066326098880476741632"},
    {1.729e193, chars_format::fixed,
        "1729000000000000032854305380233830233969318189606678412214689571335063524413578939792041508737875464889493"
        "6740711979880834265969215503401879396153989211457260242823090570884342892996886374907904"},
    {1.729e194, chars_format::fixed,
        "1729000000000000032854305380233830233969318189606678412214689571335063524413578939792041508737875464889493"
        "67407119798808342659692155034018793961539892114572602428230905708843428929968863749079040"},
    {1.729e195, chars_format::fixed,
        "1729000000000000097690486143999345210725691059781071396784161950123140086845724716208491687064565252384916"
        "313869694773836518575223125171162863850952230134911756701592087771044620265366786077097984"},
    {1.729e196, chars_format::fixed,
        "1728999999999999942083652310962109266510396171362528233817428241031756337008574852809011259080509762395901"
        "9783533024880290978272993455768230456856242885608659988953128141327798259477392294699597824"},
    {1.729e197, chars_format::fixed,
        "1728999999999999900588496622152179681386317534450916723692965918607387337052001555902483144951428298398831"
        "48888226454514711896118633768499909417487017080778713014697167449590921412970521437472292864"},
    {1.729e198, chars_format::fixed,
        "1728999999999999900588496622152179681386317534450916723692965918607387337052001555902483144951428298398831"
        "488882264545147118961186337684999094174870170807787130146971674495909214129705214374722928640"},
    {1.729e199, chars_format::fixed,
        "1729000000000000006816095185505599419303958844944642189611589464013771976940829195983195117121876846231331"
        "9419281216789249848584356378880684100424007122556690341427249919662979803838722930185292742656"},
    {1.729e200, chars_format::fixed,
        "1729000000000000049307134610846967314471015369142132375979038882176325832896360252015479905990056265364332"
        "12314646453243613121733535796929613638941292883482179574102631895445348688553912447605181251584"},
    {1.729e201, chars_format::fixed,
        "1729000000000000117292797691393155946738305807858116674166957951236412002425209941667135568179143335977132"
        "413095813098053965391574910099260498544632475361466214298308442135502297288206054808087873716224"},
    {1.729e202, chars_format::fixed,
        "1728999999999999954127206298082303229296808754939754358515952185492205195555970686503161978925334366506411"
        "7172173765405711633733999849873460293721055636975196097608313465009851523218054220112013268353024"},
    {1.729e203, chars_format::fixed,
        "1728999999999999867105557554983181779994676993383294456835415777095294898559043083749042731323302916122027"
        "34608221037658033563037335826099164581342454414341475400751022882924267500639175118619516849881088"},
    {1.729e204, chars_format::fixed,
        "1728999999999999867105557554983181779994676993383294456835415777095294898559043083749042731323302916122027"
        "346082210376580335630373358260991645813424544143414754007510228829242675006391751186195168498810880"},
    {1.729e205, chars_format::fixed,
        "1728999999999999978493267946150057235101405648175563130986502379843340078715110415274315368253903172614039"
        "3411352230664885951414474404707252567685362491726689693717612594490730459701212498422030511695200256"},
    {1.729e206, chars_format::fixed,
        "1729000000000000023048352102616807417144097110092470600646937020942558150777537347884424423026143275210844"
        "13915642814245189894587707335461870115058093118437065551746167169700519435561304930460620423780368384"},
    {1.729e207, chars_format::fixed,
        "1728999999999999951760217452270007125875790771025418649190241595183809235477654255708249935390559111055956"
        "462322500020910612858789660740389190139309439965647957684341012100313756938826170164761159328549830656"},
    {1.729e208, chars_format::fixed,
        "1729000000000000065821232892824887591905080913532701771520954276397807499957467203190129115607493773703776"
        "7452567850153766705981295209231564077573438259156042742173340674550200568056851767885132311833559957504"},
    {1.729e209, chars_format::fixed,
        "1728999999999999974572420540380983219081648799526875273656384131426608888373616845204625771433946043585520"
        "51890935701980382440665763277694263366291631715563922099093962317125501691219797148951157369951106367488"},
    {1.729e210, chars_format::fixed,
        "1729000000000000047571470422336106717340394490731536471948040247403567777640697131593028446772784227680125"
        "49998729941626210135983514329391365293845832416361126357205517859826704882698773572871289968658700933529"
        "6"},
    {1.729e211, chars_format::fixed,
        "1728999999999999930772990611207909120126401384804078554681390461840433554813368673371584166230643133128757"
        "530262591581928858234751126466760022097591112950855995442270289915047797763324112945990778107265496278630"
        "4"},
    {1.729e212, chars_format::fixed,
        "1729000000000000024211774460110467197897595869546044888494710290290940933075231439948739590664356008769851"
        "9060423578493954527348183399284829267702848819210602099460982008616231986142550111721684753707227067239628"
        "8"},
    {1.729e213, chars_format::fixed,
        "1729000000000000098962801539232513660114551457339617955545366153051346835684721653210463930211326309282727"
        "4066661708633687283348721106978612505084398970972235815491605296188835192949997297531106331814884750802288"
        "64"},
    {1.729e214, chars_format::fixed,
        "1729000000000000098962801539232513660114551457339617955545366153051346835684721653210463930211326309282727"
        "4066661708633687283348721106978612505084398970972235815491605296188835192949997297531106331814884750802288"
        "640"},
    {1.729e215, chars_format::fixed,
        "1728999999999999859759514886041964981020293576400184140983267392218047947334352970772946043661021347641525"
        "8046699692186542464147000442358506145463438485335007924193610775956504931166166302940957281870380163401777"
        "1520"},
    {1.729e216, chars_format::fixed,
        "1728999999999999859759514886041964981020293576400184140983267392218047947334352970772946043661021347641525"
        "8046699692186542464147000442358506145463438485335007924193610775956504931166166302940957281870380163401777"
        "15200"},
    {1.729e217, chars_format::fixed,
        "1729000000000000104703680418909086828412813646482164367094856523311346009005130501588964359488533628362116"
        "2451140797028418759009562402929495057715302022627529284882757164674411119232809241401269909013552860899900"
        "915712"},
    {1.729e218, chars_format::fixed,
        "1728999999999999908748347992615389350498797590416580186205585218436707559668508476936149706826523803785643"
        "8927587913154917723119512834472703927913811192793512196331440053700086168779494890633019807299014702901401"
        "9047424"},
    {1.729e219, chars_format::fixed,
        "1728999999999999947939414477874128846081600801629697022383439479411635249535832881866712637358925768700938"
        "3632298489929617930297522748164062153874109358760315614041703475894951158870157760786669827641922334501101"
        "70693632"},
    {1.729e220, chars_format::fixed,
        "1729000000000000073350827230702095231946571077511670898152573114531403857111270977644514015062612056429880"
        "6687372335608658593267154471976408476947063489854086550714546426918519127160278945278349892739226755620141"
        "073956864"},
    {1.729e221, chars_format::fixed,
        "1728999999999999973021697028439722123254594856806091797537266206435588971050920501022272912899663026246726"
        "8243313259065426062891449092926531418488700184979069801376272066099664752528181997685005840661383218724909"
        "5803404288"},
    {1.729e222, chars_format::fixed,
        "1728999999999999852626740785724874392824223391959396876798897916720611107778499929075583590304124190026942"
        "2110442367213547026440602638066678948338664219129049702170342833117039502969665660572992978167970974450631"
        "78800070656"},
    {1.729e223, chars_format::fixed,
        "1729000000000000109469314103516549551075682516965679374374083601445897216092997149228520811841273707295816"
        "0527233603164222304202408408434364217992074279609092580476325196813306702027833846411953751487250428902424"
        "411658780672"},
    {1.729e224, chars_format::fixed,
        "1728999999999999955363770112841544456124807041961909875828972190610725551104298817136758478918983996934491"
        "7477158861593817137545324946213753056200028243321066853492735778595546382592932934908577287495682756231348"
        "8374639362048"},
    {1.729e225, chars_format::fixed,
        "1728999999999999955363770112841544456124807041961909875828972190610725551104298817136758478918983996934491"
        "7477158861593817137545324946213753056200028243321066853492735778595546382592932934908577287495682756231348"
        "83746393620480"},
    {1.729e226, chars_format::fixed,
        "1729000000000000086867167651550882137149554113965126514587467261190072038561321393855062336346004549776155"
        "1546555974400562879759369500642007914262574194286848807185398748808035188510715046058125203435153836910666"
        "660776870150144"},
    {1.729e227, chars_format::fixed,
        "1728999999999999929063090605099676919919857627561266548077273176494856253612894301793097707433579886366159"
        "0663279439032467989102516035328102084587519053127910462754203184553048621409376512678667704307788540095485"
        "2728013494157312"},
    {1.729e228, chars_format::fixed,
        "1729000000000000097387439454647629151631533879725383845688146866836419757557883199992526644940166194003488"
        "2272107743425102539136493064996268302907577870364111363480811786425034292984137614950089036710311523365012"
        "08664190486577152"},
    {1.729e229, chars_format::fixed,
        "1729000000000000097387439454647629151631533879725383845688146866836419757557883199992526644940166194003488"
        "2272107743425102539136493064996268302907577870364111363480811786425034292984137614950089036710311523365012"
        "086641904865771520"},
    {1.729e230, chars_format::fixed,
        "1729000000000000043523647822792284437483797479032866310452667285927119436295486752568709384938058575559542"
        "8957282686019459483125620415502455113045159048848527075248297033825998878080214062223234210341504168718763"
        "5062129271217586176"},
    {1.729e231, chars_format::fixed,
        "1728999999999999828068481295370905580892851876262796169510748962289918151245900962873440344929628101783761"
        "5697982456396887259082129817527202353595483762786189922318238023429857218464519851315814904866274750133769"
        "18449701614570700800"},
    {1.729e232, chars_format::fixed,
        "1728999999999999897014134584145746815001954469149218614612162825853822562461768415575926437732325853392011"
        "5940958529876110370776046808879283236619379854326137811255856906756622549541541998806189082618348164080967"
        "367446107658043523072"},
    {1.729e233, chars_format::fixed,
        "1729000000000000062483702477205365776863800692076632482855556098407193149379850302061893060458800457251811"
        "6524101106226245838841447588124277355876730474022012744706142226740859344126395152783087109223324357554243"
        "0065239272876511592448"},
    {1.729e234, chars_format::fixed,
        "1729000000000000106608920582021264166693626351523942847720460971088091972558005471791484159852527018281091"
        "6679605793252948630325554462589609121012023972607579393626218312069989156015689327176926582984651342480449"
        "84361134585554652889088"},
    {1.729e235, chars_format::fixed,
        "1728999999999999894807873678904951895510463186176853096368917582219777621302860657089446882762639525340547"
        "5933183295524775231201841465156016648362615179396859478809853102490166058947077290086497108930281814834657"
        "025591736729648754589696"},
    {1.729e236, chars_format::fixed,
        "1729000000000000007768432027233651773474816874361967630423074056282878608638937891597200097210579521575504"
        "4331275294313134377401155063787265967108966535775910100045247880932738377383670376534726161759278896245746"
        "5285355282634609008836608"},
    {1.729e237, chars_format::fixed,
        "1728999999999999827031538669907731968731850973265784375936423697781917028901214316384794954093875527599573"
        "4894328096251759743482253305977267057114804365569429106068616235424622667885121438217559677232883565988003"
        "32382546180936146681331712"},
    {1.729e238, chars_format::fixed,
        "1729000000000000043915810698698835734423410054581204281320404127983070924586482606639681125833920320370690"
        "6218664733925409304184935415349265749107798969817206298840574210034361519283380164198159458664557962297295"
        "169477541554280787697729536"},
    {1.729e239, chars_format::fixed,
        "1729000000000000043915810698698835734423410054581204281320404127983070924586482606639681125833920320370690"
        "6218664733925409304184935415349265749107798969817206298840574210034361519283380164198159458664557962297295"
        "1694775415542807876977295360"},
    {1.729e240, chars_format::fixed,
        "1728999999999999905109876600272529324380812242539335541874656652654332431347910900876553975920291652997175"
        "6571089285814273585335218865351186586232282423098628895466521106284128654388494579570575598548286348659348"
        "38826021051753242233170558976"},
    {1.729e241, chars_format::fixed,
        "1729000000000000053169539638593922828426249908717328863950120626338320157469054053690556269161495564862258"
        "2861836430466151685441583185349137693299500072931778125732177750284377043609705869839998382672309403206491"
        "621558696956730678722131132416"},
    {1.729e242, chars_format::fixed,
        "1729000000000000112393404853922480230044424975188526192780306215811915247917511314816157186457977129608291"
        "3378135288326902925484128913348318136126387132865037817838440407884476399298190385947767496321918625025348"
        "9148780915324099812783013494784"},
    {1.729e243, chars_format::fixed,
        "1728999999999999828118851820345404702277184656126779014395415386338658813764916461413272783434865618827332"
        "6899900770595296973279909418952252010557329245185391295728379651403999491993464708630475750803794360294833"
        "90694499756914932900868430757888"},
    {1.729e244, chars_format::fixed,
        "1728999999999999979731946771586511650419712826293044176200690495391062245312967049894811131713858424577177"
        "3021625846718820147788826482630153944194160118614536107520412054860253842555985069866364681746793968151108"
        "577842647682888343552480063258624"},
    {1.729e245, chars_format::fixed,
        "1729000000000000040377184752082954429676724094359550240922800539012023617932187285287426471025455546877115"
        "1470315877168229417592393308101314717648892467986194032237225016242755582780993214360720254123993811293618"
        "4462017077283839493699983655305216"},
    {1.729e246, chars_format::fixed,
        "1729000000000000040377184752082954429676724094359550240922800539012023617932187285287426471025455546877115"
        "1470315877168229417592393308101314717648892467986194032237225016242755582780993214360720254123993811293618"
        "44620170772838394936999836553052160"},
    {1.729e247, chars_format::fixed,
        "1729000000000000079190137059600677808401211305922114122344950966929438896408488235938700288184877705149075"
        "3677477496655851350266676076402857612659921171584055104055985311527556696524998426837107820445401710904824"
        "761951506157501137093210078984536064"},
    {1.729e248, chars_format::fixed,
        "1728999999999999954988689675543962996482852228921909701794069597593710005284325193854624073274726798678802"
        "6614560314295461165708971217837920348624629320070899674235952366616193132544181746912667608216896432148964"
        "5515521511843261363789325959316897792"},
    {1.729e249, chars_format::fixed,
        "1729000000000000054349847582789334846017539490522073238234774693062293118183655627521885045202847523855020"
        "8264894060183773313355135104689870159852862801281424018091978722545283983728835090852219777999700655153652"
        "71987163516286613695035458237396680704"},
    {1.729e250, chars_format::fixed,
        "1728999999999999974860921256993037366389789681241942409082210616687426627864191280588076267660350943714046"
        "2944627063473123595238203995208310310870276016313004543007157637802011302781112415700578042173457276749902"
        "185216047980034136493216993220145184768"},
    {1.729e251, chars_format::fixed,
        "1728999999999999974860921256993037366389789681241942409082210616687426627864191280588076267660350943714046"
        "2944627063473123595238203995208310310870276016313004543007157637802011302781112415700578042173457276749902"
        "1852160479800341364932169932201451847680"},
    {1.729e252, chars_format::fixed,
        "1729000000000000025733834105502667753351549559181226139739851625567341181668648462625713885287548755004269"
        "9949597941367939414833039905276508614219131558692793007061443132037705818587654927797628753102253038928302"
        "52739562377704661678578505027859102302208"},
    {1.729e253, chars_format::fixed,
        "1728999999999999985035503826694963443782141656829799155213738818463409538625082716995603791185790505972091"
        "0345621239052086759157171177221949971540047124788962235818014736649150205942420918119988184359216429185582"
        "253651963139436632551730604631834352418816"},
    {1.729e254, chars_format::fixed,
        "1729000000000000115270160718879617234404246944354365505697299801195990796364493103011956092311416902875063"
        "7078346686462815257319951106996537628113117313281220703796985601892528166407169749088438004336933580362287"
        "1296316771797885821007048307014556983492608"},
    {1.729e255, chars_format::fixed,
        "1729000000000000011082435205131894201906562714334712425310451015009925790172964794198874251410915785352685"
        "5692166328534232458789727163176867502854661162487413929413808909697825798035370684313678148354759859420923"
        "22884790594750702246152544984575862160490496"},
    {1.729e256, chars_format::fixed,
        "1729000000000000052757525410630983414905636406342573657465190529484351792649576117724106987771116232361636"
        "8246638471705665578201816740704735552958043622804936639167079586575706745384090310223582090747629347797468"
        "789161414440419646317197202188037452302647296"},
    {1.729e257, chars_format::fixed,
        "1729000000000000052757525410630983414905636406342573657465190529484351792649576117724106987771116232361636"
        "8246638471705665578201816740704735552958043622804936639167079586575706745384090310223582090747629347797468"
        "7891614144404196463171972021880374523026472960"},
    {1.729e258, chars_format::fixed,
        "1728999999999999999413409947592149222266822080572511280307123950957086509479513623611809085230059660190179"
        "2176914128446231185354342081469064448825714073598507570682893120172019132777729189058905044484756402675490"
        "47196012356949148778193735918992054900953710592"},
    {1.729e259, chars_format::fixed,
        "1728999999999999871387532836298947159933667698724361575127764162491649829871363637742294119131523886978680"
        "9609575704623588642520402899303453798908123155503077806320845600803168862522462498263680133453861334382742"
        "510677025479263907297313735994439981106072649728"},
    {1.729e260, chars_format::fixed,
        "1729000000000000007948468421678362693089032372695721260652414603521448954786723622669776749636628711737612"
        "4348070023367740688209938026946771825486886801471536221640362954796609150794746968445253371886816073895007"
        "0027123301088399931475789340696192535364347363328"},
    {1.729e261, chars_format::fixed,
        "1729000000000000062572842655830128906351178242284265134862274779933368604752867616640769801838670641641185"
        "0243467750865401506485752078004099036118392259858919587768169896393985266103660756517882667259997969699912"
        "79952645196067042748768501329969096250857957097472"},
    {1.729e262, chars_format::fixed,
        "1728999999999999844075345719223064053302594763930089638022834074285690004888291640756797593030502922026894"
        "6661876840874758233382495873774790193592370426309386123256942130004480804868005604227365485767270386480289"
        "612269964553348690127260696379404126620000232407040"},
    {1.729e263, chars_format::fixed,
        "1728999999999999913994544738937324806278141477003425797011455100092947156844955953039668699849116592303467"
        "5807985932071764080775537859128169023200697413045236831900535015249122232463415252960330983844943213110569"
        "0321920405236916460825964777938959141043456207486976"},
    {1.729e264, chars_format::fixed,
        "1728999999999999913994544738937324806278141477003425797011455100092947156844955953039668699849116592303467"
        "5807985932071764080775537859128169023200697413045236831900535015249122232463415252960330983844943213110569"
        "03219204052369164608259647779389591410434562074869760"},
    {1.729e265, chars_format::fixed,
        "1729000000000000048239406856788705451991191166104231222269607469642880888601751432622781224940854839234487"
        "5768515387170015307770178471006656376048685227578070192496233354918833773446601778527624740154075040240705"
        "518442426386750121516841178109720146074288766364680192"},
    {1.729e266, chars_format::fixed,
        "1728999999999999905044887264413899429897271497730038768660911608789618241394502921067461198176334042508066"
        "2477283968398547332309228485002936533010831558743047941194155125937808129731202817922511400091001091301893"
        "2664420147994877477203134977728409653063494110409654272"},
    {1.729e267, chars_format::fixed,
        "1729000000000000076878310775263666656409975099779069712991346641813533418043201134933845230293758998579771"
        "8426761670924308902862368468207400344656255961345074642756649000715038902189681570648647408166689830028467"
        "96884250870420259627614671417709598222787663742942314496"},
    {1.729e268, chars_format::fixed,
        "1728999999999999985233818236143790802269866512019586542681781290867445323830562087538440413164465688674862"
        "1920373562910569398567360477165019645112029613290660401923318934167182490211826235861374870526322502707628"
        "127562245288354677046368998761493306536395450022245695488"},
    {1.729e269, chars_format::fixed,
        "1728999999999999911918224204847890118957779641812000006434129010110574848460450849622116559461031040750934"
        "4715263076499577795131354084331115085476648534847129009256654880928897360629541968031556840414028640850956"
        "2545380345556763416625468264290111659832105000965037359104"},
    {1.729e270, chars_format::fixed,
        "1728999999999999970570699429884610665607449137978069235432250834716071228756539839955175642423778759090076"
        "6479351465628371077880159198598238733184953397601954123389986123519525464295369382295411264503863730336293"
        "75295740314181900996960456429499687842575846003709730357248"},
    {1.729e271, chars_format::fixed,
        "1728999999999999829804758889796481353648242347179503085836758455662879916045926263155833843313184235076135"
        "4245539331719267199283026924357141978685021726990373849469991141302018015497383588062160646688259515571483"
        "756750918535076606032665993416631168563643356179672741183488"},
    {1.729e272, chars_format::fixed,
        "1728999999999999979955095465890485953071396257364640312071950326652950649603914078408465095697818394024339"
        "3961605607888978003119968016880978516818282175642726141651319122334025960881901768577627972358237344653947"
        "7527045021156018368987338023535545924165661336275922743984128"},
    {1.729e273, chars_format::fixed,
        "1728999999999999979955095465890485953071396257364640312071950326652950649603914078408465095697818394024339"
        "3961605607888978003119968016880978516818282175642726141651319122334025960881901768577627972358237344653947"
        "75270450211560183689873380235355459241656613362759227439841280"},
    {1.729e274, chars_format::fixed,
        "1728999999999999931906987761540404481255987006105396399676688927936128014865357977527623094934735463160914"
        "1252464399514670545892146867273350824615638832073973408153294168403783418358855950812678428143844439347559"
        "273999355369833763021592103493739096783630844844258023769636864"},
    {1.729e275, chars_format::fixed,
        "1728999999999999893468501598060339303803659605098001269760479808962669907074513096822949494324269118470173"
        "9085151432815224580109889947587248670853524157218971221354874205259589384340419296600718792772330115102448"
        "4910352379732193039198787444058867002772826138175906232666161152"},
    {1.729e276, chars_format::fixed,
        "1729000000000000077973235182764652155574831129933497893358283580035268824470568524205382777254507572985726"
        "9488253672972565215864723162080539008911674596522981717987290028351720747628915236818125042555598871478980"
        "24926300147696870760810286802757820350775412274559414568111570944"},
    {1.729e277, chars_format::fixed,
        "1728999999999999979570710604255685301296872983354566360772788235463216068526005629601418359691713730577431"
        "9939932478221983543462145447684117495280661028894176119783334922702584020541717402035508376004522201411496"
        "644874860941635692307716668762676068451502651317325600393382592512"},
    {1.729e278, chars_format::fixed,
        "1729000000000000058292730267062858784719239500617711586841184511120858273281655945284589893741948804504067"
        "9578589434022448881384207619201254706185471882997220598346499007221893402211475669861601709245383537465483"
        "5283853733699021045480256281745977764965038284599404366235690860544"},
    {1.729e279, chars_format::fixed,
        "1729000000000000058292730267062858784719239500617711586841184511120858273281655945284589893741948804504067"
        "9578589434022448881384207619201254706185471882997220598346499007221893402211475669861601709245383537465483"
        "52838537336990210454802562817459777649650382845994043662356908605440"},
    {1.729e280, chars_format::fixed,
        "1729000000000000058292730267062858784719239500617711586841184511120858273281655945284589893741948804504067"
        "9578589434022448881384207619201254706185471882997220598346499007221893402211475669861601709245383537465483"
        "528385373369902104548025628174597776496503828459940436623569086054400"},
    {1.729e281, chars_format::fixed,
        "1729000000000000098598404334420131608231491157456441942588203404257571082116548906914373719175669162354505"
        "5713581795392287134400303451018028958168735040297979371370839018495779805626391902988561495864704541525124"
        "8127427557331745076150638153935016910155444311569592327734245707481088"},
    {1.729e282, chars_format::fixed,
        "1729000000000000034109325826648495090611888506514473373392973175238830587980720168306719598481716589793805"
        "3897594017200545929574550120111190154995513988616765334531895000457561560162525929985425837273790935029698"
        "75777094395193866270780271584325542778507946684172915893365579523817472"},
    {1.729e283, chars_format::fixed,
        "1729000000000000034109325826648495090611888506514473373392973175238830587980720168306719598481716589793805"
        "3897594017200545929574550120111190154995513988616765334531895000457561560162525929985425837273790935029698"
        "757770943951938662707802715843255427785079466841729158933655795238174720"},
    {1.729e284, chars_format::fixed,
        "1729000000000000034109325826648495090611888506514473373392973175238830587980720168306719598481716589793805"
        "3897594017200545929574550120111190154995513988616765334531895000457561560162525929985425837273790935029698"
        "7577709439519386627078027158432554277850794668417291589336557952381747200"},
    {1.729e285, chars_format::fixed,
        "1728999999999999968072509434690339296569415391949897558537057420723640321985631539972481778891109155491648"
        "4038022532332202935832978709262587220546135631695202160808816325986426076807527173630214922876695401978382"
        "47747980868795315752276734990380325423708334338293356332173256911600222208"},
    {1.729e286, chars_format::fixed,
        "1729000000000000020901962548256863931803393883601558210421790024335792534781702442639872034563595102933373"
        "9925679720226877330826235837941469568105638317232452699787279265563334463491526178714383654394371828419435"
        "501712716899141561670795642655364993075480242149970039811271150013740220416"},
    {1.729e287, chars_format::fixed,
        "1729000000000000105429087529963303348177759470244215253437362190115236075255415886907696443639572618840134"
        "9345931220858356362815447243827681324200842614092053562152819968886387882185924586849053624822654110725120"
        "3404853700370430083076409110578637752169152801772284021945328794501210177536"},
    {1.729e288, chars_format::fixed,
        "1729000000000000105429087529963303348177759470244215253437362190115236075255415886907696443639572618840134"
        "9345931220858356362815447243827681324200842614092053562152819968886387882185924586849053624822654110725120"
        "34048537003704300830764091105786377521691528017722840219453287945012101775360"},
    {1.729e289, chars_format::fixed,
        "1728999999999999943137007565086939668738977543890313730847463631818704477545886073913473578213695788299153"
        "9259048339645916621396161344526154752498050364121619906410981818506125318292679643230487281600352128698205"
        "450041876012272230764897995725066113505360007164892346418670358932269886865408"},
    {1.729e290, chars_format::fixed,
        "1729000000000000159526447518255424574657353445695515760967328376214079941158592491239104065448198229020461"
        "9374892181262502943288542543594856848101773364082198114066766019013142070150339568055242405896754771400758"
        "6372998680452999341552218828354629957874337045146737541198203862894047280496640"},
    {1.729e291, chars_format::fixed,
        "1729000000000000090281826733241509404763473157117851111328971658007559792802526437694902309533157447989643"
        "3737822151945195320282980559892872177508582004094813087616915074850896709555888392111320766121905925735941"
        "61737731059473106907031823896013599345717012136274370365545237753512157887070208"},
    {1.729e292, chars_format::fixed,
        "1729000000000000034886130105230377268848368926255719391618286283442343674117673594859540904801124823164988"
        "5228166128491349221878530972931284441034028916104905066457034319521100421080327451356183454302026849204088"
        "001439264634275977002395323859874391592959254841199663283957970531695059527532544"},
    {1.729e293, chars_format::fixed,
        "1729000000000000123519244710048188686312535695635130143155382882746689464013438143396119152372377022884436"
        "2843615766017502979325650312069824819393313856888757900312843528048774482641224956564403153213833371655053"
        "7869401381710041243110719880202929545756966412756701278783490217371774904766038016"},
    {1.729e294, chars_format::fixed,
        "1729000000000000052612753026193939552341202280131601541925705603303212832096826504566856554315375263108878"
        "0751256055996579973367954840758992516705885904261675633228196161226635233392506952397827394084388153694281"
        "15853943934162160646413065669195810418950673212809375620283618077279154571734679552"},
    {1.729e295, chars_format::fixed,
        "1728999999999999995887559679110540245164135547728778660941963779748431526563537193503446475869773855288431"
        "5077368287979841568601798463710326674555943542160009819560478267768923833993532549064566786780831979325663"
        "055818880278115592186577591629290223880554804810032658862425908001282789909941190656"},
    {1.729e296, chars_format::fixed,
        "1729000000000000041267714356777259690905788933651036965728957238592256570990168642354174538626254981544788"
        "7616478502393232292414723565349259348275897431841342470494652582535092953512712071731175272623676918820557"
        "5379953275289204036086200436794245281277163466644815367347541262184897945558656745472"},
    {1.729e297, chars_format::fixed,
        "1728999999999999968659466872510508577719143516175423678069767704442136499907558324193009638215885179534617"
        "1553902159331807134314043402726967070323971208351210228999973678909222362282024835464601695275125015628726"
        "36651301192763270533335212039920964133225787969736333213902897707095858712238650032128"},
    {1.729e298, chars_format::fixed,
        "1729000000000000084832662847337310358817776184136404938324470959082328613639734833250873478872476862750891"
        "7254024308230087387275131662922634715047053165935421815391459924710615308251124413491119419032808060735656"
        "240884716889693022573780797647553460204991426844752459492189215707008519015953179082752"},
    {1.729e299, chars_format::fixed,
        "1729000000000000084832662847337310358817776184136404938324470959082328613639734833250873478872476862750891"
        "7254024308230087387275131662922634715047053165935421815391459924710615308251124413491119419032808060735656"
        "2408847168896930225737807976475534602049914268447524594921892157070085190159531790827520"},
    {1.729e300, chars_format::fixed,
        "1729000000000000010481817423448157218914651276641376931761460876112605660851141867453840620852258185492476"
        "0005946132935188025380035176397407422424280713081526400100908727397723822830900683554148075827890911867221"
        "12128682571397441953990644420861341612644195667042341798616666297993656260407050467540992"},
    {1.729e301, chars_format::fixed,
        "1729000000000000010481817423448157218914651276641376931761460876112605660851141867453840620852258185492476"
        "0005946132935188025380035176397407422424280713081526400100908727397723822830900683554148075827890911867221"
        "121286825713974419539906444208613416126441956670423417986166662979936562604070504675409920"},
    {1.729e302, chars_format::fixed,
        "1728999999999999915312735280870041199838651395047741083360807969911360281281742871233638562586378278601703"
        "8728406068557716842154311673645116487867131973428540268529003194837222721493014309234824756525596961315624"
        "1682015250090546076565472718067701597058986348472822448584577954892844583968606814340120576"},
    {1.729e303, chars_format::fixed,
        "1728999999999999991448000994932534015099451300322649762081330294872356584937262068209800209199082204114321"
        "5750438120059693788734890475846949235512850965150929173786527620885623602563323408690283411967432121756901"
        "73066976557299045716323460972824476484233329230579518336062488948180614176262854002713034752"},
    {1.729e304, chars_format::fixed,
        "1729000000000000113264426137432522519516731148762503648034166014809950670786092783371658843779408484934509"
        "8985689402462856903263816559369881631746001351906751422198566702563065012275817967819017260674368378462945"
        "830618950475287816373934350402604133060628744239415884964092239869840835147857113776119611392"},
    {1.729e305, chars_format::fixed,
        "1729000000000000064537856080432527117749819209386562093653031726834913036446560497306915389947277972606434"
        "5691588889501591657452246125960708673252741197204422522833751069892088448390820144167523721191593875780528"
        "1906392765143688726896544541328603857733105634659676043227052997146269577937656842765239058432"},
    {1.729e306, chars_format::fixed,
        "1728999999999999908612831898032541832095701003383549119633402005314792606560057181899736337684460333156593"
        "5150467248025542870855220739051355206074308702156970044866341045344963443958827108482744394846715467196791"
        "74270431983942825289995878606968039445389238499093310627026709121794255026067310987781764808704"},
    {1.729e307, chars_format::fixed,
        "1729000000000000033352851243952530060618995568185959498849105782530888950469259834225479579494714444716466"
        "3583364561206381900132841048578837979817054698194932027240269064982663447504421537030567855922618194063780"
        "901052285179380748731715320520224387509426927770960704712217658015290076287147169396782654291968"},
    {1.729e308, chars_format::fixed,
        "1729000000000000033352851243952530060618995568185959498849105782530888950469259834225479579494714444716466"
        "3583364561206381900132841048578837979817054698194932027240269064982663447504421537030567855922618194063780"
        "9010522851793807487317153205202243875094269277709607047122176580152900762871471693967826542919680"},

    // Also test one-digit cases, where the decimal point can't appear between digits like "17.29".
    {7e-3, chars_format::fixed, "0.007"},
    {7e-2, chars_format::fixed, "0.07"},
    {7e-1, chars_format::fixed, "0.7"},
    {7e0, chars_format::fixed, "7"},
    {7e1, chars_format::fixed, "70"},
    {7e2, chars_format::fixed, "700"},
    {7e3, chars_format::fixed, "7000"},

    // Test the maximum value in fixed notation.
    {0x1.fffffffffffffp+1023, chars_format::fixed,
        "1797693134862315708145274237317043567980705675258449965989174768031572607800285387605895586327668781715404"
        "5895351438246423432132688946418276846754670353751698604991057655128207624549009038932894407586850845513394"
        "2304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368"},

    // Test highly-trimmed powers of 2.
    {0x1p959, chars_format::fixed,
        "4872657005699999540176691193937594155438113428797503763433953228606474345383213051232807532941005129612652"
        "4581157043340917295849326015470232889936481563267097656388499782365149353948277450268241763997967396091894"
        "36842798962697437472873181807734482806413869401552138773540914294995957055488"},
    {0x1p959, chars_format::scientific, "4.8726570057e+288"},
    {0x1p960, chars_format::fixed,
        "9745314011399999080353382387875188310876226857595007526867906457212948690766426102465615065882010259225304"
        "9162314086681834591698652030940465779872963126534195312776999564730298707896554900536483527995934792183788"
        "73685597925394874945746363615468965612827738803104277547081828589991914110976"},
    {0x1p960, chars_format::scientific, "9.7453140114e+288"},

    // Test powers of 10 that are exactly representable.
    {1e0, chars_format::fixed, "1"},
    {1e1, chars_format::fixed, "10"},
    {1e2, chars_format::fixed, "100"},
    {1e3, chars_format::fixed, "1000"},
    {1e4, chars_format::fixed, "10000"},
    {1e5, chars_format::fixed, "100000"},
    {1e6, chars_format::fixed, "1000000"},
    {1e7, chars_format::fixed, "10000000"},
    {1e8, chars_format::fixed, "100000000"},
    {1e9, chars_format::fixed, "1000000000"},
    {1e10, chars_format::fixed, "10000000000"},
    {1e11, chars_format::fixed, "100000000000"},
    {1e12, chars_format::fixed, "1000000000000"},
    {1e13, chars_format::fixed, "10000000000000"},
    {1e14, chars_format::fixed, "100000000000000"},
    {1e15, chars_format::fixed, "1000000000000000"},
    {1e16, chars_format::fixed, "10000000000000000"},
    {1e17, chars_format::fixed, "100000000000000000"},
    {1e18, chars_format::fixed, "1000000000000000000"},
    {1e19, chars_format::fixed, "10000000000000000000"},
    {1e20, chars_format::fixed, "100000000000000000000"},
    {1e21, chars_format::fixed, "1000000000000000000000"},
    {1e22, chars_format::fixed, "10000000000000000000000"},

    // Test powers of 10 that aren't exactly representable.
    // This exercises the "adjustment" code.
    {1e23, chars_format::fixed, "99999999999999991611392"},
    {1e24, chars_format::fixed, "999999999999999983222784"},
    {1e25, chars_format::fixed, "10000000000000000905969664"},
    {1e26, chars_format::fixed, "100000000000000004764729344"},
    {1e27, chars_format::fixed, "1000000000000000013287555072"},
    {1e28, chars_format::fixed, "9999999999999999583119736832"},
    {1e29, chars_format::fixed, "99999999999999991433150857216"},
    {1e30, chars_format::fixed, "1000000000000000019884624838656"},
    {1e31, chars_format::fixed, "9999999999999999635896294965248"},
    {1e32, chars_format::fixed, "100000000000000005366162204393472"},
    {1e33, chars_format::fixed, "999999999999999945575230987042816"},
    {1e34, chars_format::fixed, "9999999999999999455752309870428160"},
    {1e35, chars_format::fixed, "99999999999999996863366107917975552"},
    {1e36, chars_format::fixed, "1000000000000000042420637374017961984"},
    {1e37, chars_format::fixed, "9999999999999999538762658202121142272"},
    {1e38, chars_format::fixed, "99999999999999997748809823456034029568"},
    {1e39, chars_format::fixed, "999999999999999939709166371603178586112"},
    {1e40, chars_format::fixed, "10000000000000000303786028427003666890752"},
    {1e41, chars_format::fixed, "100000000000000000620008645040778319495168"},
    {1e42, chars_format::fixed, "1000000000000000044885712678075916785549312"},
    {1e43, chars_format::fixed, "10000000000000000139372116959414099130712064"},
    {1e44, chars_format::fixed, "100000000000000008821361405306422640701865984"},
    {1e45, chars_format::fixed, "999999999999999929757289024535551219930759168"},
    {1e46, chars_format::fixed, "9999999999999999931398190359470212947659194368"},
    {1e47, chars_format::fixed, "100000000000000004384584304507619735463404765184"},
    {1e48, chars_format::fixed, "1000000000000000043845843045076197354634047651840"},
    {1e49, chars_format::fixed, "9999999999999999464902769475481793196872414789632"},
    {1e50, chars_format::fixed, "100000000000000007629769841091887003294964970946560"},
    {1e51, chars_format::fixed, "999999999999999993220948674361627976461708441944064"},
    {1e52, chars_format::fixed, "9999999999999999932209486743616279764617084419440640"},
    {1e53, chars_format::fixed, "99999999999999999322094867436162797646170844194406400"},
    {1e54, chars_format::fixed, "1000000000000000078291540404596243842305360299886116864"},
    {1e55, chars_format::fixed, "10000000000000000102350670204085511496304388135324745728"},
    {1e56, chars_format::fixed, "100000000000000009190283508143378238084034459715684532224"},
    {1e57, chars_format::fixed, "1000000000000000048346692115553659057528394845890514255872"},
    {1e58, chars_format::fixed, "9999999999999999438119489974413630815797154428513196965888"},
    {1e59, chars_format::fixed, "99999999999999997168788049560464200849936328366177157906432"},
    {1e60, chars_format::fixed, "999999999999999949387135297074018866963645011013410073083904"},
    {1e61, chars_format::fixed, "9999999999999999493871352970740188669636450110134100730839040"},
    {1e62, chars_format::fixed, "100000000000000003502199685943161173046080317798311825604870144"},
    {1e63, chars_format::fixed, "1000000000000000057857959942726969827393378689175040438172647424"},
    {1e64, chars_format::fixed, "10000000000000000213204190094543968723012578712679649467743338496"},
    {1e65, chars_format::fixed, "99999999999999999209038626283633850822756121694230455365568299008"},
    {1e66, chars_format::fixed, "999999999999999945322333868247445125709646570021247924665841614848"},
    {1e67, chars_format::fixed, "9999999999999999827367757839185598317239782875580932278577147150336"},
    {1e68, chars_format::fixed, "99999999999999995280522225138166806691251291352861698530421623488512"},
    {1e69, chars_format::fixed, "1000000000000000072531436381529235126158374409646521955518210155479040"},
    {1e70, chars_format::fixed, "10000000000000000725314363815292351261583744096465219555182101554790400"},
    {1e71, chars_format::fixed, "100000000000000004188152556421145795899143386664033828314342771180699648"},
    {1e72, chars_format::fixed, "999999999999999943801810948794571024057224129020550531544123892056457216"},
    {1e73, chars_format::fixed, "9999999999999999830336967949613257980309080240684656321838454199566729216"},
    {1e74, chars_format::fixed, "99999999999999995164818811802792197885196090803013355167206819763650035712"},
    {1e75, chars_format::fixed, "999999999999999926539781176481198923508803215199467887262646419780362305536"},
    {1e76, chars_format::fixed, "10000000000000000470601344959054695891559601407866630764278709534898249531392"},
    {1e77, chars_format::fixed, "99999999999999998278261272554585856747747644714015897553975120217811154108416"},
    {1e78, chars_format::fixed, "1000000000000000008493621433689702976148869924598760615894999102702796905906176"},
    {1e79, chars_format::fixed, "9999999999999999673560075006595519222746403606649979913266024618633003221909504"},
    {1e80, chars_format::fixed, "100000000000000000026609864708367276537402401181200809098131977453489758916313088"},
    {1e81, chars_format::fixed, "999999999999999921281879895665782741935503249059183851809998224123064148429897728"},
    {1e82, chars_format::fixed, "9999999999999999634067965630886574211027143225273567793680363843427086501542887424"},
    {1e83, chars_format::fixed, "100000000000000003080666323096525690777025204007643346346089744069413985291331436544"},
    {1e84, chars_format::fixed,
        "1000000000000000057766609898115896702437267127096064137098041863234712334016924614656"},
    {1e85, chars_format::fixed,
        "10000000000000000146306952306748730309700429878646550592786107871697963642511482159104"},
    {1e86, chars_format::fixed,
        "100000000000000001463069523067487303097004298786465505927861078716979636425114821591040"},
    {1e87, chars_format::fixed,
        "999999999999999959416724456350362731491996089648451439669739009806703922950954425516032"},
    {1e88, chars_format::fixed,
        "9999999999999999594167244563503627314919960896484514396697390098067039229509544255160320"},
    {1e89, chars_format::fixed,
        "99999999999999999475366575191804932315794610450682175621941694731908308538307845136842752"},
    {1e90, chars_format::fixed,
        "999999999999999966484112715463900049825186092620125502979674597309179755437379230686511104"},
    {1e91, chars_format::fixed,
        "10000000000000000795623248612804971431562261401669105159386439973487930752201761134141767680"},
    {1e92, chars_format::fixed,
        "100000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552"},
    {1e93, chars_format::fixed,
        "1000000000000000043377296974619186073290293324951939311791773789336116812889681110941323755520"},
    {1e94, chars_format::fixed,
        "10000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328"},
    {1e95, chars_format::fixed,
        "100000000000000002021887912715594698857609632321435774113777685620800400499816430935869782753280"},
    {1e96, chars_format::fixed,
        "1000000000000000049861653971908893017010268485438462151574892930611988399099305815384459015356416"},
    {1e97, chars_format::fixed,
        "10000000000000000735758738477112498397576062152177456799245857901351759143802190202050679656153088"},
    {1e98, chars_format::fixed,
        "99999999999999999769037024514370800696612547992403838920556863966097586548129676477911932478685184"},
    {1e99, chars_format::fixed,
        "999999999999999967336168804116691273849533185806555472917961779471295845921727862608739868455469056"},
    {1e100, chars_format::fixed,
        "10000000000000000159028911097599180468360808563945281389781327557747838772170381060813469985856815104"},
    {1e101, chars_format::fixed,
        "99999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688"},
    {1e102, chars_format::fixed,
        "999999999999999977049513265245336628446842719924150006129995974731993452180789911303261294481511546880"},
    {1e103, chars_format::fixed,
        "10000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328"},
    {1e104, chars_format::fixed,
        "10000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328"
        "0"},
    {1e105, chars_format::fixed,
        "99999999999999993825830082528197854032702736447212447829441621253887149182459971363682052750390825530163"
        "2"},
    {1e106, chars_format::fixed,
        "1000000000000000091035999050368435010460453995175486557154545737484090289535133415215418009754161219056435"
        "2"},
    {1e107, chars_format::fixed,
        "9999999999999999688138404702992698343537126906127968940664421175279152513667064539525400239539588480525926"
        "4"},
    {1e108, chars_format::fixed,
        "1000000000000000033998991713002824594943974719712898047713430714837875271723200833292741616380733445921308"
        "672"},
    {1e109, chars_format::fixed,
        "9999999999999999818508707188399807864717650964328171247958398369899072554380053298205803424393137676263358"
        "464"},
    {1e110, chars_format::fixed,
        "1000000000000000023569367514170255833249532795056881863129912539268281668466161732598309361592449510262314"
        "10688"},
    {1e111, chars_format::fixed,
        "9999999999999999568197726416418157584051044772583782817953962156228826076211114881539429309474323220447488"
        "90112"},
    {1e112, chars_format::fixed,
        "9999999999999999301199346926304397284673331501389768492615896861647229832830913903761963586894254467577228"
        "034048"},
    {1e113, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "28086784"},
    {1e114, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "280867840"},
    {1e115, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "2808678400"},
    {1e116, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "28086784000"},
    {1e117, chars_format::fixed,
        "1000000000000000050555427725995033814228237030803003279020481474722232763977085405824233377105062219252417"
        "113236701184"},
    {1e118, chars_format::fixed,
        "9999999999999999665649998943273759183241515094863428494587753284228752052274941196820382078490267674695111"
        "155514343424"},
    {1e119, chars_format::fixed,
        "9999999999999999441675524725493338127497287038019000682423203560763798562276031100441194960474173136607361"
        "8283536318464"},
    {1e120, chars_format::fixed,
        "9999999999999999800034683473942011816688051928970085181886483118307724146274287254647894349299924397547760"
        "75181077037056"},
    {1e121, chars_format::fixed,
        "1000000000000000037340933747145988971939327575449182038102773041037800508067149710137861337142112641505239"
        "9029342192009216"},
    {1e122, chars_format::fixed,
        "1000000000000000014405947587245273855831118622428312630137123149354989270691261316268632576257264560805054"
        "37183296233537536"},
    {1e123, chars_format::fixed,
        "9999999999999999777099697314041296700579842975949215773920833226624912908898398860778665588415076316847575"
        "22070951350501376"},
    {1e124, chars_format::fixed,
        "9999999999999999483531874467312143214394768377282087351960514613084929070487027419252537449089020883885200"
        "422613425626021888"},
    {1e125, chars_format::fixed,
        "9999999999999999248677616189928820425446708698348384614392259722252941999757930266031634937628176537515300"
        "5841365553228283904"},
    {1e126, chars_format::fixed,
        "9999999999999999248677616189928820425446708698348384614392259722252941999757930266031634937628176537515300"
        "58413655532282839040"},
    {1e127, chars_format::fixed,
        "9999999999999999549291066784979473595300225087383524118479625982517885450291174622154390152298057300868772"
        "377386949310916067328"},
    {1e128, chars_format::fixed,
        "1000000000000000075174486916518208627471429064352408213482909102357765925242415204664541101097758035428265"
        "95503885252632667750400"},
    {1e129, chars_format::fixed,
        "9999999999999999982174435641852414159889288687594125004365433397299404019059046494971157661422685600097771"
        "75966751665376232210432"},
    {1e130, chars_format::fixed,
        "1000000000000000059783078246051615185174929025233809070873635949832200820575113093631056034106660140344568"
        "1992244323541365884452864"},
    {1e131, chars_format::fixed,
        "9999999999999999120255550095723181391285286496952573018246136855867758157690128277095993909921203475410697"
        "4340599870111173348163584"},
    {1e132, chars_format::fixed,
        "9999999999999999908295674023612765636866088499824849119840922265176691516655996362010429339865415703696022"
        "53175829982724989462249472"},
    {1e133, chars_format::fixed,
        "1000000000000000022351172359476859933509840930097375956047883642890026486024234359597620351184310059501015"
        "2570837624953702918544949248"},
    {1e134, chars_format::fixed,
        "9999999999999999214820364967069931500754982737297246150437511104984830160766032447285726161514508942804936"
        "4457837845490532419930947584"},
    {1e135, chars_format::fixed,
        "9999999999999999618296908418149398634492353362767851514454041234551004040556556906761917101645945603687022"
        "89580532071091311261383655424"},
    {1e136, chars_format::fixed,
        "1000000000000000058664061270074011975546204286389730438809371354550982135205381560950477535796139358980403"
        "0375857007499376802103616864256"},
    {1e137, chars_format::fixed,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "50478432243557864849063421149184"},
    {1e138, chars_format::fixed,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "504784322435578648490634211491840"},
    {1e139, chars_format::fixed,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "5047843224355786484906342114918400"},
    {1e140, chars_format::fixed,
        "1000000000000000059283801240814870037063624887670453288648500744829995778284739806520232965080181245691517"
        "92237293382948229697163514582401024"},
    {1e141, chars_format::fixed,
        "1000000000000000016976219238238959704141045173573106739630601035115997744067216908958262325956255112879408"
        "454231155599236459402033650892537856"},
    {1e142, chars_format::fixed,
        "1000000000000000050822284840299687970479108944850983978844920802887196171441235227007838837255396019129096"
        "0287445781834331294577148468377157632"},
    {1e143, chars_format::fixed,
        "1000000000000000023745432358651105357408657927828682187473464988670237429542020572568177628216083294129345"
        "96913384011607579341316989008157343744"},
    {1e144, chars_format::fixed,
        "1000000000000000023745432358651105357408657927828682187473464988670237429542020572568177628216083294129345"
        "969133840116075793413169890081573437440"},
    {1e145, chars_format::fixed,
        "9999999999999999890870611821409196126784806260401358945180015464725302399110258148854112806457630061296658"
        "928320953898584032761523454337112604672"},
    {1e146, chars_format::fixed,
        "9999999999999999336336672997246224211101969431784618257892600389561987365014342025929851245332505453301777"
        "7074930382791057905692427399713177731072"},
    {1e147, chars_format::fixed,
        "9999999999999999779963824056576601743648238894678010807722532449692639392291074924269260494232605139697682"
        "68415537077468838432306731146395363835904"},
    {1e148, chars_format::fixed,
        "1000000000000000048976726575150520579572227003530743888745042374590168263593384756161231529247276463793113"
        "0646815102767620534329186625852171022761984"},
    {1e149, chars_format::fixed,
        "1000000000000000048976726575150520579572227003530743888745042374590168263593384756161231529247276463793113"
        "06468151027676205343291866258521710227619840"},
    {1e150, chars_format::fixed,
        "9999999999999999808355961724373745905731200140303187930911648101541001122036785829762982686162211519627020"
        "60266176005440567032331208403948233373515776"},
    {1e151, chars_format::fixed,
        "1000000000000000017177532387217719118039310408430545510773232844520003126278188542008262674286117318272254"
        "5959543542834786931126445173006249634549465088"},
    {1e152, chars_format::fixed,
        "1000000000000000046251081359041994740012262723950726884918887272012725537537796509233834198822034251319896"
        "62450489690590919397689516441796634752009109504"},
    {1e153, chars_format::fixed,
        "9999999999999999997334030041231537448555390191184366862858401880243696795224237616729197595645671584436693"
        "78824028710020392594094129030220133015859757056"},
    {1e154, chars_format::fixed,
        "1000000000000000036947545688058226540980917982984268845192277855215054365934721959721651310970540832744651"
        "1753687232667314337003349573404171046192448274432"},
    {1e155, chars_format::fixed,
        "1000000000000000007176231540910168304080614811891603118067127721462506616804883401282666069845761893303865"
        "73813296762136260081534229469225952733653677113344"},
    {1e156, chars_format::fixed,
        "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373"
        "88344363105067534507348164573733465510370326085632"},
    {1e157, chars_format::fixed,
        "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373"
        "883443631050675345073481645737334655103703260856320"},
    {1e158, chars_format::fixed,
        "9999999999999999528733545365121100799744618278185808317908538774978595223920578706899569900341651077638731"
        "0061494932420984963311567802202010637287727642443776"},
    {1e159, chars_format::fixed,
        "9999999999999999284846939871684207723057334700594690681299308879277724063048941236167402805047462005739816"
        "70431418299523701733729688780649419062882836695482368"},
    {1e160, chars_format::fixed,
        "1000000000000000006528407745068226556845664214888626711844884454552051177783818114251033750998886703581634"
        "2470187175785193750117648543530356184548650438281396224"},
    {1e161, chars_format::fixed,
        "1000000000000000037745893248228148870661636512820289769330865881201762686375387710504751139196542904784695"
        "27765363729011764432297892058199009821165792668120252416"},
    {1e162, chars_format::fixed,
        "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999"
        "79621894213003182527093908649335762989920701551401238528"},
    {1e163, chars_format::fixed,
        "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999"
        "796218942130031825270939086493357629899207015514012385280"},
    {1e164, chars_format::fixed,
        "1000000000000000001783349948587918365145636425603013927107015277701295028477899535620468707992842960998768"
        "97036220978235643807646031628623453753183252563447406133248"},
    {1e165, chars_format::fixed,
        "9999999999999998994898934518334849272334583997405404203369513388555203571250442826162875703467631208965785"
        "85177704871391229197474064067196498264773607101557544845312"},
    {1e166, chars_format::fixed,
        "9999999999999999404072760505352583023983296100855298230449769143938302256661863838179600254051950569374547"
        "392515068357773127490685649548117139715971745147241514401792"},
    {1e167, chars_format::fixed,
        "1000000000000000038608994287419514402794020514913504389544238295685773910164927426701973917545431703435557"
        "50902863155030391327289536708508823166797373630632400726786048"},
    {1e168, chars_format::fixed,
        "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145"
        "54599698521475539380813444812793279458505403728617494385000448"},
    {1e169, chars_format::fixed,
        "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145"
        "545996985214755393808134448127932794585054037286174943850004480"},
    {1e170, chars_format::fixed,
        "1000000000000000034419054309312452809177137702974177474706936476750650979626314475538922658147448273184971"
        "79085147422915077831721209019419643357959500300321574675254607872"},
    {1e171, chars_format::fixed,
        "9999999999999999539722067296568702117329877137391007098307415531962907132849458132083384777061664123737260"
        "01850053663010587168093173889073910282723323583537144858509574144"},
    {1e172, chars_format::fixed,
        "1000000000000000082687162857105802367643627696515223533632653430883267139431135672937273166412217389671719"
        "2642523265688348930066834399772699475577180106550229078889679814656"},
    {1e173, chars_format::fixed,
        "1000000000000000014039186255799705217824619705701291360938300429450213045486501081081841332435656868446122"
        "85763778101906192989276863139689872767772084421689716760605683089408"},
    {1e174, chars_format::fixed,
        "1000000000000000068957567536844582937679826098352437099093782830596656320642208754566186799616905285426599"
        "982929417458880300383900478261195703581718577367397759832385751351296"},
    {1e175, chars_format::fixed,
        "9999999999999999371534524623368764100273307559896873275206250678451924602685103382037576783819090846734548"
        "822294900033162112051840457868829614121240178061963384891963422539776"},
    {1e176, chars_format::fixed,
        "1000000000000000007448980502074319891441994938583153872359642541312639852467816160263719876373907058408465"
        "60260278464628372543383280977318309056924111623883709653889736043921408"},
    {1e177, chars_format::fixed,
        "1000000000000000007448980502074319891441994938583153872359642541312639852467816160263719876373907058408465"
        "602602784646283725433832809773183090569241116238837096538897360439214080"},
    {1e178, chars_format::fixed,
        "1000000000000000052438118447506283719547380015442972461056613724331806183475371886382095683088785761598872"
        "4636416932177829345401680187244151732297960592357271816907060120777654272"},
    {1e179, chars_format::fixed,
        "9999999999999999804554977348151415945787638924672627191414598315011400538632827245926943923449798364942214"
        "8597943950338419997003168440244384097290815044070304544781216945608327168"},
    {1e180, chars_format::fixed,
        "1000000000000000009248546019891598444566210341657546615907521388633406505708118389308454908642502206536081"
        "877044340989143693798086218131232373875663313958712699944969706504756133888"},
    {1e181, chars_format::fixed,
        "9999999999999999171107915076469365246063817042486381462561244058101538598046442622180212564904306224021286"
        "256366562347133135483117101991090685868467907010818055540655879490029748224"},
    {1e182, chars_format::fixed,
        "1000000000000000064531198727238395596542107524102891697698359578327358093250202865562715099933745157016453"
        "82788895184180192194795092289050635704895322791329123657951217763820802932736"},
    {1e183, chars_format::fixed,
        "9999999999999999465948729515652283389935268682194888565445714403135947064937559828869600251790935293249936"
        "66087115356131035228239552737388526279268078143523691759154905886843985723392"},
    {1e184, chars_format::fixed,
        "1000000000000000017356668416969128693522675261749530561236844323121852738547624112492413070031884505939869"
        "7631682172475335672600663748292592247410791680053842186513692689376624118857728"},
    {1e185, chars_format::fixed,
        "9999999999999999796170441687537151711071294518668416520676321189574484547855611100361714461103959850786025"
        "1139162957211888350975873638026151889477992007905860430885494197722591793250304"},
    {1e186, chars_format::fixed,
        "9999999999999999796170441687537151711071294518668416520676321189574484547855611100361714461103959850786025"
        "11391629572118883509758736380261518894779920079058604308854941977225917932503040"},
    {1e187, chars_format::fixed,
        "9999999999999999071569656121801212080692814968920789464627446869617922299624001453201875281811380250249693"
        "879805812353226907091680705581859236698853640605134247712274342131878495422251008"},
    {1e188, chars_format::fixed,
        "1000000000000000023093091302697871548929838224851699275430564578154842189679457688865761796867950761110782"
        "38543825857419659919011313587350687602971665369018571203143144663564875896666980352"},
    {1e189, chars_format::fixed,
        "1000000000000000023093091302697871548929838224851699275430564578154842189679457688865761796867950761110782"
        "385438258574196599190113135873506876029716653690185712031431446635648758966669803520"},
    {1e190, chars_format::fixed,
        "1000000000000000072559171597318778361030342428781137282456834398397210172492068907445206818174324195174062"
        "5976868675721161334753163637413771490365780039321792212624518252692320803210995433472"},
    {1e191, chars_format::fixed,
        "1000000000000000072559171597318778361030342428781137282456834398397210172492068907445206818174324195174062"
        "59768686757211613347531636374137714903657800393217922126245182526923208032109954334720"},
    {1e192, chars_format::fixed,
        "1000000000000000040900880208761398001286019738266296957960021713442094663491997727554362004538245197373563"
        "261847757813447631532786297905940174312186739777303375354598782943738754654264509857792"},
    {1e193, chars_format::fixed,
        "1000000000000000066227513319607302289081477890678169217557471861406187070692054671467037855447108395613962"
        "7305190456203824330868103505742897540916997511012040520808812168041334151877325366493184"},
    {1e194, chars_format::fixed,
        "9999999999999999446596743875469617076632787591011823714897111511785435161317813406861937710845650440600452"
        "8089686414709538562749489776621177115003729674648080379472553427423904462708600804999168"},
    {1e195, chars_format::fixed,
        "9999999999999999770777647694297191960414651941883788637744473405725817973478542288944188602479099378077566"
        "00796112539971931616645685181699233267813951241073670004367049615544210109925082343145472"},
    {1e196, chars_format::fixed,
        "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875"
        "448767138256706948253250552493092635735926276453993770366538373425000777236538229086224384"},
    {1e197, chars_format::fixed,
        "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875"
        "4487671382567069482532505524930926357359262764539937703665383734250007772365382290862243840"},
    {1e198, chars_format::fixed,
        "1000000000000000017535541566019400541537441865177200086145798104936341572305513193378283771523764365204900"
        "328030374534281861011105867876227585990799216050325567033999660761493056632508247061001404416"},
    {1e199, chars_format::fixed,
        "1000000000000000097206240488534465344975672848047494185584765763991130052222133923438817750651600776079275"
        "6678147673846152604340428430285295728914471221362369950308146488642846313231335560438561636352"},
    {1e200, chars_format::fixed,
        "9999999999999999697331222125103616594745032754550236264824175095034684843555407553419633840470625186802751"
        "2415973882408182135734368278484639385041047239877871023591066789981811181813306167128854888448"},
    {1e201, chars_format::fixed,
        "1000000000000000037718785293056550291741793714171007924670336578563554653884390444993619046236149589293075"
        "414109087389699655531583234914810756005630018925423128793192791080866922220799992003324610084864"},
    {1e202, chars_format::fixed,
        "9999999999999999017474591319641730272072128367390393282944984404433823148266910656903077218579754480674748"
        "342103902584639871831041306548820316951909258721342916786285447187693014154661313392524876840960"},
    {1e203, chars_format::fixed,
        "9999999999999999887691078750632944765093445982954992299750348488402926118236186684444269694600068984518592"
        "0534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752"},
    {1e204, chars_format::fixed,
        "9999999999999999887691078750632944765093445982954992299750348488402926118236186684444269694600068984518592"
        "05345556422454814926130757381236415253871945426239147431949662390511778730879802164258646020587520"},
    {1e205, chars_format::fixed,
        "1000000000000000016616035472855013340286026761993566398512806499527303906862635501325745128692656962574862"
        "2041088095949318798038992779336698179926498716835527012730124200454693714718121768282606166882648064"},
    {1e206, chars_format::fixed,
        "1000000000000000038893577551088388431307372492952020133343023820076912942893848967630799656078777013873264"
        "60311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552"},
    {1e207, chars_format::fixed,
        "1000000000000000038893577551088388431307372492952020133343023820076912942893848967630799656078777013873264"
        "603119412132913531706114094375616540183672212689403544345862626169435445664558076559462193222406635520"},
    {1e208, chars_format::fixed,
        "9999999999999999818630698308109481982927274216983785721776674794699138106539424938898600659703096825493544"
        "616522696356805028364441642842329313746550197144253860793660984920822957311285732475861572950035529728"},
    {1e209, chars_format::fixed,
        "1000000000000000073111882183254852571116159535704205070042237624441112422237792851875363410143857412667610"
        "68799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832"},
    {1e210, chars_format::fixed,
        "9999999999999999271137824193446055745986681532948826734589253924871946437036322790985580594661810444784007"
        "25843812838336795121561031396504666917998514458446354143529431921823271795036250068185162804696593727488"},
    {1e211, chars_format::fixed,
        "9999999999999999563134023721266549739021664297767471527755878388779781994104643936539191296017163181162427"
        "18274989796920105902832035603293074628215317261635171175975654092628084560952155763865693199526971991654"
        "4"},
    {1e212, chars_format::fixed,
        "9999999999999999095940104476753759350165691874057639858689279246527245102795330103653414173848598802956955"
        "303851066631868086527984288724316222918684327765330639240616986193403841354867066507768445677983667689881"
        "6"},
    {1e213, chars_format::fixed,
        "9999999999999999843450375267974223972335247751993370529195837874131304128890232236270657569318301808085710"
        "3100891967716008425285219964180994603002344795269643552712402737660070481623142523171900237856413512525414"
        "4"},
    {1e214, chars_format::fixed,
        "9999999999999999544446266951486038123467425400819078260993214423089680518452271383223760211130420606034208"
        "3075939447157077401283069133405861653476144188223108688589909587369657654393353779934213925425782778274775"
        "04"},
    {1e215, chars_format::fixed,
        "9999999999999999066039693645104940765278909638940210631869016901423082741751534018348724438029810682751805"
        "1036015414262787762879627804165648934234223216948652905993920546904997130825691790753915825536773603473752"
        "064"},
    {1e216, chars_format::fixed,
        "1000000000000000021421546958041957442493134746744949294176709095342291740583330369404881029347127449862957"
        "2793183309320908289504788699434215946041483354800734678422429424402018238738808056478663126527039562299620"
        "72064"},
    {1e217, chars_format::fixed,
        "9999999999999999601855055748251769806450047292244542376488118125689672251656359867008764503902493796828096"
        "6920730331104392157891482092914687179785174704776043382501428272225416917221473218635849697412463879250897"
        "79712"},
    {1e218, chars_format::fixed,
        "1000000000000000082657588341258737904341264764265444350704606378115616256001024752108885608304005520043104"
        "8894293585531377363220429189576963174104449239123865018594716021581494785755468791093741283312832736674151"
        "6615680"},
    {1e219, chars_format::fixed,
        "9999999999999999650843888854825194175928551306260938421710435951908331863990515373171968167067996252972214"
        "7801618552072767416863994485028884962235547412234547654639257549968998154834801806327912222841098418750522"
        "5498624"},
    {1e220, chars_format::fixed,
        "9999999999999999964372420736895110140590976995965873111133270039707753382929110612616471611327211972294570"
        "5439303166270369074288073794559750769917932739968974996321364927527918075560104767557112385584359471548120"
        "96741376"},
    {1e221, chars_format::fixed,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "8435495936"},
    {1e222, chars_format::fixed,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "84354959360"},
    {1e223, chars_format::fixed,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "843549593600"},
    {1e224, chars_format::fixed,
        "9999999999999999695490351794831950209296480724474921121484247526010969488287371335268865457530508571403718"
        "2409224841134505892881183378706080253249519082903930108094789640533388351546084948006950326015738792668900"
        "564521713664"},
    {1e225, chars_format::fixed,
        "9999999999999999284542234486365269956094146124464869125363950430450511714984175783024165903071069343773520"
        "0942358863613425448462294146117783821804062986135861502805217858619360833053015850664613088704891665546032"
        "3666687950848"},
    {1e226, chars_format::fixed,
        "9999999999999999613300728333138614158656013804472910722260188106898877933626732224819925546638620725877678"
        "6115851645630289803997405532188420966960427863550316387036875284150582847847471128538482878553569367244326"
        "92495112994816"},
    {1e227, chars_format::fixed,
        "1000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431"
        "2680982277369774722613785107647096954758588737320813592396350498627547090702529224003396203794828017403750"
        "5158080469401600"},
    {1e228, chars_format::fixed,
        "9999999999999999245091215224752468651786722002863904133736401909276707768747069010008674745842963177921021"
        "0721539729771401725798080779789307364385299200846126916697418967555614191277681217319748713923050341342237"
        "0196749149011968"},
    {1e229, chars_format::fixed,
        "9999999999999999918388610622944277578633427011520373324179896670642961784527024602806390495869308408470337"
        "7156852947341939925933988898461972237665534469790930519603853375043556877576725626405434043533142274420344"
        "27503713670135808"},
    {1e230, chars_format::fixed,
        "1000000000000000099566444326005117186158815502537072402888948828882896820977495355128273569591146077734924"
        "4345335409545480104615144188833823603491391090010261628425414842702426517565519668094253057090928936734531"
        "5883616691581616128"},
    {1e231, chars_format::fixed,
        "1000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768"
        "1693475363620965659806446069238773051601456032797794197839403040623198185642380825912769195995883053017532"
        "72401848696295129088"},
    {1e232, chars_format::fixed,
        "1000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768"
        "1693475363620965659806446069238773051601456032797794197839403040623198185642380825912769195995883053017532"
        "724018486962951290880"},
    {1e233, chars_format::fixed,
        "9999999999999999737406270739910319339097032705193514405788685278787712705085372539462364502262226810498681"
        "4019040754458979257737456796162759919727807229498567311142603806310797883499542489243201826933949562808949"
        "044795771481474727936"},
    {1e234, chars_format::fixed,
        "1000000000000000017865845178806930323739528929966661805443773400559670093686692423675827549619949242079148"
        "1557408762472600717257852554081607757108074221535423380034336465960209600239248423318159656454721941207101"
        "74156699571604284243968"},
    {1e235, chars_format::fixed,
        "1000000000000000053166019662659649035603389457524510097335697298704389152229216559459500429134930490902572"
        "1681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067"
        "211236930570359138156544"},
    {1e236, chars_format::fixed,
        "1000000000000000053166019662659649035603389457524510097335697298704389152229216559459500429134930490902572"
        "1681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067"
        "2112369305703591381565440"},
    {1e237, chars_format::fixed,
        "9999999999999999402054613143309491576390357693393955632815408246412881648931393249517472146869904946676153"
        "2837205133056038042458244550226238504699576640248260779350025557809411313140906763850021826347864477369777"
        "0829313903654699186257920"},
    {1e238, chars_format::fixed,
        "1000000000000000048647597328726501040484815309997105515973531039741865112735773470079190300557012891053173"
        "8945888832142428584597165509708623196466454966148714674320981543085810557013220039375302073350623645891623"
        "631119178909006652304785408"},
    {1e239, chars_format::fixed,
        "9999999999999999908117914543822067029670662216463268745378029250215574072197019260112206547596676129808759"
        "9260657287627887017431169472094235452683230716826407562484594165232135299736843791138087983021771402091458"
        "056119576436948334022754304"},
    {1e240, chars_format::fixed,
        "1000000000000000013946113804119924437974165856986638331112094170909680489426130543638408513078605724209795"
        "1533994970114644654884736372209103405747575829469070323477468267148252340789498643218406108321555742482136"
        "93581484614981956096327942144"},
    {1e241, chars_format::fixed,
        "1000000000000000050961029563700272813985525273531136661630960164330677420956416331841909086388906702176065"
        "8106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922"
        "744139467759619125060885807104"},
    {1e242, chars_format::fixed,
        "1000000000000000050961029563700272813985525273531136661630960164330677420956416331841909086388906702176065"
        "8106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922"
        "7441394677596191250608858071040"},
    {1e243, chars_format::fixed,
        "1000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479"
        "0313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465"
        "66146722558989084608335389392896"},
    {1e244, chars_format::fixed,
        "1000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479"
        "0313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465"
        "661467225589890846083353893928960"},
    {1e245, chars_format::fixed,
        "1000000000000000044327956659583474385004289666086362560801979378309634770826189118595841783651700766924510"
        "1088856284197210041026562330672682972917768891214832545527981010497103310257691199981691663623805273275210"
        "7272876955671430431745947427930112"},
    {1e246, chars_format::fixed,
        "1000000000000000068586051851782051496707094173312964986690823395758019319873877212752887919376339615844485"
        "2468332296376973748947989060861147282299661830963495715414706195050104006347694457779433892574685210532214"
        "67463131958534128550160206370177024"},
    {1e247, chars_format::fixed,
        "9999999999999999521471949292288813605336325386252733424243721120057734844449743607990664678980731410286045"
        "8468474379141079509251407559565185972665757201699124999584253091957006651156788203502711936104615116985957"
        "27381924297989722331966923339726848"},
    {1e248, chars_format::fixed,
        "1000000000000000045298280467271417469472401846375426657837533139007570152788096642362123629080686320881309"
        "1144035324684400589343419399880221545293044608804779072323450017879223338101291330293601352781840470765490"
        "8851814405278709728676750356293615616"},
    {1e249, chars_format::fixed,
        "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364"
        "0811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306"
        "7478208555469597215339755257651527680"},
    {1e250, chars_format::fixed,
        "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364"
        "0811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306"
        "74782085554695972153397552576515276800"},
    {1e251, chars_format::fixed,
        "1000000000000000048279115204488778624958442464223431563930754291871627646175076555372141458238529942636595"
        "6593545337061049953772804316485780039629891613241094802639130808557096063636830930611787917875324597455631"
        "5302310250472271728848176952226298724352"},
    {1e252, chars_format::fixed,
        "1000000000000000099152028052998409011920202342162715294588395300751542199979533737409779075865727753926819"
        "3598516214955865773367640226553978342978747155620883266693416302792790579443373442708838628804120359634031"
        "87241060084423965317738575228107571068928"},
    {1e253, chars_format::fixed,
        "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035"
        "1826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507"
        "77435958293799716241167969694049028276224"},
    {1e254, chars_format::fixed,
        "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035"
        "1826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507"
        "774359582937997162411679696940490282762240"},
    {1e255, chars_format::fixed,
        "9999999999999999884525696946414532898914128477668338966773684654288481309010349092958796199089453165592925"
        "8756995846567465499292772862455788348916374954024635689112910673359193130483369363856562818230607811338327"
        "2782784390994049606075766012189756664840192"},
    {1e256, chars_format::fixed,
        "1000000000000000030127659900140542502890486539774695128832107979903274133377646232821112356269145763568243"
        "8430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378"
        "288141352402853119916429412464176397346144256"},
    {1e257, chars_format::fixed,
        "1000000000000000030127659900140542502890486539774695128832107979903274133377646232821112356269145763568243"
        "8430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378"
        "2881413524028531199164294124641763973461442560"},
    {1e258, chars_format::fixed,
        "1000000000000000056799717631659959599209893702659726317411141269166906774962677479877261307539674049653972"
        "6465033899457896865765104193391282437061184730323200812906654977415644066700237122877898747347366742071367"
        "44674199783831719918405933396323484899269935104"},
    {1e259, chars_format::fixed,
        "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743"
        "8976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194"
        "85458899748089618699435710767754281089234894848"},
    {1e260, chars_format::fixed,
        "1000000000000000065334776105746173070032103994782936297756431921731269220269887478935228971946243101201405"
        "8636189794379406368620700138868989813722357458196229463864124812040234084717254902264247074749426413290883"
        "9774942043776657045497009088429335535195969814528"},
    {1e261, chars_format::fixed,
        "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743"
        "8976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194"
        "8545889974808961869943571076775428108923489484800"},
    {1e262, chars_format::fixed,
        "1000000000000000016172839295009583478096172712153246810967557762960541535300357884361335224964405364288190"
        "5330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468"
        "760361494711018313643605437535869015444666630275072"},
    {1e263, chars_format::fixed,
        "1000000000000000016172839295009583478096172712153246810967557762960541535300357884361335224964405364288190"
        "5330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468"
        "7603614947110183136436054375358690154446666302750720"},
    {1e264, chars_format::fixed,
        "1000000000000000044140518902895287779286391397382581274563006173283444396083023609274483667691850832398819"
        "6988775476110313971129684287058746855997333340341924717806535718700452151977396352492066908144631837718580"
        "52833032509915549602573975010166573043840478561173504"},
    {1e265, chars_format::fixed,
        "1000000000000000066514662589203851220238566345566048845439364901541766684709156189205002421873807206887323"
        "0315530385293355842295457722371828081471997976097396944572485441978737408807927440086615867529487142240269"
        "942705389409665241931447200154303102433395309881065472"},
    {1e266, chars_format::fixed,
        "1000000000000000030716032691110149714715086428472500732037190936328451022907344061316172415182677007705717"
        "6992722530600488848430220225870898120712534558888641381746965884733480997879077699935337532513718655005566"
        "8797052865128496484823152800700833072414104710501367808"},
    {1e267, chars_format::fixed,
        "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491"
        "6762299630919016582458402314694101834973930913546324812261345931410707403929181156932921964884890754300419"
        "7890512187794469896370420793533163493423472892065087488"},
    {1e268, chars_format::fixed,
        "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491"
        "6762299630919016582458402314694101834973930913546324812261345931410707403929181156932921964884890754300419"
        "78905121877944698963704207935331634934234728920650874880"},
    {1e269, chars_format::fixed,
        "1000000000000000046753818885456127989189605431330410286841364872744016439394555894610368258180303336939076"
        "8881340449502893261681846624303314743132774169798163873892798646379355869975202383523110226600782937286713"
        "8519293326106230343475263802678137754874196788463928344576"},
    {1e270, chars_format::fixed,
        "1000000000000000046753818885456127989189605431330410286841364872744016439394555894610368258180303336939076"
        "8881340449502893261681846624303314743132774169798163873892798646379355869975202383523110226600782937286713"
        "85192933261062303434752638026781377548741967884639283445760"},
    {1e271, chars_format::fixed,
        "9999999999999999529098585253973751145501342374646995204443699533752222309208135100774737254399069875964494"
        "0587990268968240092837584414759169067994863893904436912794686582343509041098785207009431480570467941101738"
        "54458342872794765056233999682236635579342942941443126198272"},
    {1e272, chars_format::fixed,
        "1000000000000000065522610957467878564117499670103552440120763856617775281089304371516947164728382606807602"
        "3845848734024107112161464260868794310399431725879707910415464644008356863148267156087543642309530165922021"
        "8514235305581886882057848563849292034690350260273827761094656"},
    {1e273, chars_format::fixed,
        "9999999999999999454023416965926748845789765419554426591326103598257186942429141193148421628206752796490392"
        "0729957130883384690919113868497250798928233669578260766704022591827505068406526116751697817735479026560506"
        "5466066369376850351293060923539046438669680406904714953752576"},
    {1e274, chars_format::fixed,
        "9999999999999999213782878444176341486712719163258207029349796604673073768736360688744211624391338142173265"
        "7184251089011847404780008120459112337915016951734497099213897822176292355791297027926950096663514500028564"
        "15308090320884466574359759805482716570229159677380024223137792"},
    {1e275, chars_format::fixed,
        "9999999999999999598167740078976993261235993173332158328511887794407654846644809495790947630496001589080667"
        "8857380756006307062602577317320133875536163700284518967198097453618232695975663570046546450378657742479671"
        "982722077174989256760731188933351130765773907040474247261585408"},
    {1e276, chars_format::fixed,
        "1000000000000000052069140800249855752009185079750964144650090664977064943362508663270311404514719386165843"
        "3087289195679301024137674338978658556582691589680457145036017656907888951241814327113357769929500152436233"
        "07738608946937362752018518070418086469181314516804918593340833792"},
    {1e277, chars_format::fixed,
        "1000000000000000002867878510995372324870206006461498378357342992691038565390227215968329195733322464961695"
        "8313128598304010187936385481780447799767184805866054345934040104083320587698215409722049436653961817402491"
        "275192019201707119869992081071729797163687409453914913289541779456"},
    {1e278, chars_format::fixed,
        "9999999999999999635068686795917855831590227478299257653231448548622174630124020581267434287082049279983778"
        "4938001204037775189753543960218791943147793788145321066524580618236658968633362758090027700335311493754978"
        "334367629875739137498376013657689431411868208826074951744485326848"},
    {1e279, chars_format::fixed,
        "1000000000000000057973292274960393763265862568545700036605220385651388108719182436946549269568487016710341"
        "0060188467364335924481829001842443847400552403738185480928254963246837154867046197200314769922564752640282"
        "09364937790149360843820835266007499279518823345374529865067232493568"},
    {1e280, chars_format::fixed,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "290926013924448356521309485648260046220787856768108551057012647002112"},
    {1e281, chars_format::fixed,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "2909260139244483565213094856482600462207878567681085510570126470021120"},
    {1e282, chars_format::fixed,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "29092601392444835652130948564826004622078785676810855105701264700211200"},
    {1e283, chars_format::fixed,
        "9999999999999999553953517735361344274271821018911312812290573026184540102343798495987494338396687059809772"
        "7966329076780975705558651098687533761031476684077544035813096345547962581760843838922021129763927973084950"
        "24959839786965342632596166187964530344229899589832462449290116390191104"},
    {1e284, chars_format::fixed,
        "1000000000000000079214382508457676541256819191699710934083899342334435758975171027725445345572057645297521"
        "6283329441806240683821311505209883878195732087635685354312082149188175289466707052058222577470946921779713"
        "0505057184069381648545374773244373557467226310750742042216461653692645376"},
    {1e285, chars_format::fixed,
        "9999999999999999801591579205204428501931095198528472118000257105616503599825380852240886161861464938442861"
        "4939722145037261932089543889369794765216645522533405937274641374814720644342089175254062058753036222027386"
        "3006901551095990707698442841525909542472844588688081080376132618600579072"},
    {1e286, chars_format::fixed,
        "1000000000000000032988611034086967485427088011504507863684758314173802572778608987891478871858632441286011"
        "7381629402398400588202211517615861824081167237790591132705927077058380451118207922609574937392980048643791"
        "654301923722148311225012721166820834263125344653917287293299907083743789056"},
    {1e287, chars_format::fixed,
        "1000000000000000075252173524940187193614270804825836385192544397063524343015465710025391076396621199239392"
        "2091755152714140104196817220558967702128769386220391563888697428719907160465407126676909922607121189796634"
        "0736882502910990345434353553680702253338428636675464684849307718019341877248"},
    {1e288, chars_format::fixed,
        "1000000000000000007630473539575035660514778335511710750780086664439969510636494954611131549135839186513983"
        "4555553952208956878605448095849998297252605948732710873996264866061464425509888400169173946264495363952086"
        "20267012778077787723395914064607119962069483324573977857832138825282954985472"},
    {1e289, chars_format::fixed,
        "1000000000000000061727833527867156886994372310963011258310052850538813376539671558942539170944464796694310"
        "4584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724"
        "499484625789034803081540112423670420191213257583185130503608895092113260150784"},
    {1e290, chars_format::fixed,
        "1000000000000000061727833527867156886994372310963011258310052850538813376539671558942539170944464796694310"
        "4584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724"
        "4994846257890348030815401124236704201912132575831851305036088950921132601507840"},
    {1e291, chars_format::fixed,
        "9999999999999999578609023503462841321535518780965142838525177732290331540055724786262365370719036251480826"
        "1289098686371420245702004200641968152637496587417778862354344999448505725826266174594802676763227561304989"
        "6960078961318150545418464661067991669581788285529005480705688196068853638234112"},
    {1e292, chars_format::fixed,
        "1000000000000000013256598978357416268068656108958646003563203147794249272690425321461597941803936249972737"
        "4638565892090988122974650007025784551738302746731685907395315255274646861058187558214617579496201832662352"
        "585538835573636597522107561710941518560028749376834095178551288964115055725510656"},
    {1e293, chars_format::fixed,
        "9999999999999999246234843735396048506044893395792352520261065484899034827946607729250196942326840502532897"
        "0231162545648343655275306678872441733790178059478330735395060467469727994972900530063978805843953102113868"
        "000379620369084502134308975505229555772913629423636305841602377586326247764393984"},
    {1e294, chars_format::fixed,
        "1000000000000000066436467741248103118547156170586292454485461107376856746627884050583544890346687569804406"
        "1207835674606680377442921610508908778753873711201997607708800780391251297994726061339549398843285746132932"
        "05683935969567348590731356020719265634967118123751637393518591968740451429495341056"},
    {1e295, chars_format::fixed,
        "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362"
        "6970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049"
        "02758521100414464490983962613190835886243290260424727924570510530141380583845003264"},
    {1e296, chars_format::fixed,
        "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362"
        "6970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049"
        "027585211004144644909839626131908358862432902604247279245705105301413805838450032640"},
    {1e297, chars_format::fixed,
        "1000000000000000017652801462756379714374878780719864776839443139119744823869255243069012222883470359078822"
        "0728292194112285349344027126247056154504923279794565007954563392017619494511608074472945276562227436175920"
        "48849967890105831362861792425329827928397252374398383022243308510390698430058459037696"},
    {1e298, chars_format::fixed,
        "9999999999999999595662034753429788238255624467393741467120915117996487670031669885400803025551745174706847"
        "8782311196631452228634829961492223321433823010024592147588202691169230215270582854596864146833859136224555"
        "51313826420028155008403585629126369847605750170289266545852965785882018353801250996224"},
    {1e299, chars_format::fixed,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "4508111903896764088007465274278014249457925878882005684283811566947219638686545940054016"},
    {1e300, chars_format::fixed,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "45081119038967640880074652742780142494579258788820056842838115669472196386865459400540160"},
    {1e301, chars_format::fixed,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "450811190389676408800746527427801424945792587888200568428381156694721963868654594005401600"},
    {1e302, chars_format::fixed,
        "1000000000000000076297030790848949253473468551506568117016017342062113802881257944841421889646917840766397"
        "4757713854876137221038784479993829181561135051983075016764985648898162653636809541460731423515105837345898"
        "6890825155659063617715863205282622390509284183439858617103083735673849899204570498157510656"},
    {1e303, chars_format::fixed,
        "1000000000000000000161765076786456438212668646231659438295495017101117499225738747865260243034213915253779"
        "7735681803374160274458205677791996433915416060260686111507461222849761772566500442005272768073270676904621"
        "12661427500197051226489898260678763391449376088547292320814127957486330655468919122263277568"},
    {1e304, chars_format::fixed,
        "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856"
        "1180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990"
        "76639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744"},
    {1e305, chars_format::fixed,
        "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856"
        "1180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990"
        "766396825508218326595491122696079498053460349186625724064076043808459598620749043481381437440"},
    {1e306, chars_format::fixed,
        "1000000000000000017216064596736454828831087825013238982328892017892380671244575047987920451875459594568606"
        "1388616982910603110492255329485206969388057114406501226285146694284603569926249680283295506892241752843467"
        "30060716088829214255439694630119794546505512415617982143262670862918816362862119154749127262208"},
    {1e307, chars_format::fixed,
        "9999999999999999860310597602564577717002641838126363875249660735883565852672743849064846414228960666786379"
        "2803926546153933531728502521033362759523706153970107306916646893751785690398510731463396416232660711267200"
        "11020169553304018596457812688561947201171488461172921822139066929851282122002676667750021070848"},
    {1e308, chars_format::fixed,
        "1000000000000000010979063629440455417404923096773118463368106829031575854049114915371633289784946888990612"
        "4966972117251561159028374314008832830700919814604603127166450293302718569748969958855904333838446616500117"
        "8426897626212945177628091195786707458122783970171784415105291802893207873272974885715430223118336"},

    // These numbers have odd mantissas (unaffected by shifting)
    // that are barely within the "max shifted mantissa" limit.
    // They're exactly-representable multiples of powers of 10, and can use Ryu with zero-filling.
    {1801439850948197e1, chars_format::fixed, "18014398509481970"},
    {360287970189639e2, chars_format::fixed, "36028797018963900"},
    {72057594037927e3, chars_format::fixed, "72057594037927000"},
    {14411518807585e4, chars_format::fixed, "144115188075850000"},
    {2882303761517e5, chars_format::fixed, "288230376151700000"},
    {576460752303e6, chars_format::fixed, "576460752303000000"},
    {115292150459e7, chars_format::fixed, "1152921504590000000"},
    {23058430091e8, chars_format::fixed, "2305843009100000000"},
    {4611686017e9, chars_format::fixed, "4611686017000000000"},
    {922337203e10, chars_format::fixed, "9223372030000000000"},
    {184467439e11, chars_format::fixed, "18446743900000000000"},
    {36893487e12, chars_format::fixed, "36893487000000000000"},
    {7378697e13, chars_format::fixed, "73786970000000000000"},
    {1475739e14, chars_format::fixed, "147573900000000000000"},
    {295147e15, chars_format::fixed, "295147000000000000000"},
    {59029e16, chars_format::fixed, "590290000000000000000"},
    {11805e17, chars_format::fixed, "1180500000000000000000"},
    {2361e18, chars_format::fixed, "2361000000000000000000"},
    {471e19, chars_format::fixed, "4710000000000000000000"},
    {93e20, chars_format::fixed, "9300000000000000000000"},
    {17e21, chars_format::fixed, "17000000000000000000000"},
    {3e22, chars_format::fixed, "30000000000000000000000"},

    // These numbers have odd mantissas (unaffected by shifting)
    // that are barely above the "max shifted mantissa" limit.
    // This activates the non-Ryu fallback for large integers.
    {1801439850948199e1, chars_format::fixed, "18014398509481992"},
    {360287970189641e2, chars_format::fixed, "36028797018964096"},
    {72057594037929e3, chars_format::fixed, "72057594037928992"},
    {14411518807587e4, chars_format::fixed, "144115188075870016"},
    {2882303761519e5, chars_format::fixed, "288230376151900032"},
    {576460752305e6, chars_format::fixed, "576460752304999936"},
    {115292150461e7, chars_format::fixed, "1152921504609999872"},
    {23058430093e8, chars_format::fixed, "2305843009299999744"},
    {4611686019e9, chars_format::fixed, "4611686019000000512"},
    {922337205e10, chars_format::fixed, "9223372049999998976"},
    {184467441e11, chars_format::fixed, "18446744099999997952"},
    {36893489e12, chars_format::fixed, "36893488999999995904"},
    {7378699e13, chars_format::fixed, "73786990000000008192"},
    {1475741e14, chars_format::fixed, "147574099999999983616"},
    {295149e15, chars_format::fixed, "295148999999999967232"},
    {59031e16, chars_format::fixed, "590310000000000065536"},
    {11807e17, chars_format::fixed, "1180700000000000131072"},
    {2363e18, chars_format::fixed, "2363000000000000262144"},
    {473e19, chars_format::fixed, "4729999999999999475712"},
    {95e20, chars_format::fixed, "9500000000000001048576"},
    {19e21, chars_format::fixed, "19000000000000002097152"},
    {5e22, chars_format::fixed, "49999999999999995805696"},

    // Test the mantissa shifting logic.
    // Also test a large shift, because 32-bit platforms need to simulate _BitScanForward64().
    {302230528e15, chars_format::fixed, "302230528000000000000000"}, // 295147 * 2^10
    {302232576e15, chars_format::fixed, "302232575999999966445568"}, // 295149 * 2^10
    {81123342286848e18, chars_format::fixed, "81123342286848000000000000000000"}, // 2361 * 2^35
    {81192061763584e18, chars_format::fixed, "81192061763584009007199254740992"}, // 2363 * 2^35

    // Inspect all of those numbers in scientific notation.
    // For the within-limit numbers, this verifies that Ryu is actually being used with zero-filling above.
    // For the above-limit numbers, this tests Ryu's trimming.
    {1801439850948197e1, chars_format::scientific, "1.801439850948197e+16"},
    {360287970189639e2, chars_format::scientific, "3.60287970189639e+16"},
    {72057594037927e3, chars_format::scientific, "7.2057594037927e+16"},
    {14411518807585e4, chars_format::scientific, "1.4411518807585e+17"},
    {2882303761517e5, chars_format::scientific, "2.882303761517e+17"},
    {576460752303e6, chars_format::scientific, "5.76460752303e+17"},
    {115292150459e7, chars_format::scientific, "1.15292150459e+18"},
    {23058430091e8, chars_format::scientific, "2.3058430091e+18"},
    {4611686017e9, chars_format::scientific, "4.611686017e+18"},
    {922337203e10, chars_format::scientific, "9.22337203e+18"},
    {184467439e11, chars_format::scientific, "1.84467439e+19"},
    {36893487e12, chars_format::scientific, "3.6893487e+19"},
    {7378697e13, chars_format::scientific, "7.378697e+19"},
    {1475739e14, chars_format::scientific, "1.475739e+20"},
    {295147e15, chars_format::scientific, "2.95147e+20"},
    {59029e16, chars_format::scientific, "5.9029e+20"},
    {11805e17, chars_format::scientific, "1.1805e+21"},
    {2361e18, chars_format::scientific, "2.361e+21"},
    {471e19, chars_format::scientific, "4.71e+21"},
    {93e20, chars_format::scientific, "9.3e+21"},
    {17e21, chars_format::scientific, "1.7e+22"},
    {3e22, chars_format::scientific, "3e+22"},
    {1801439850948199e1, chars_format::scientific, "1.801439850948199e+16"},
    {360287970189641e2, chars_format::scientific, "3.60287970189641e+16"},
    {72057594037929e3, chars_format::scientific, "7.2057594037929e+16"},
    {14411518807587e4, chars_format::scientific, "1.4411518807587e+17"},
    {2882303761519e5, chars_format::scientific, "2.882303761519e+17"},
    {576460752305e6, chars_format::scientific, "5.76460752305e+17"},
    {115292150461e7, chars_format::scientific, "1.15292150461e+18"},
    {23058430093e8, chars_format::scientific, "2.3058430093e+18"},
    {4611686019e9, chars_format::scientific, "4.611686019e+18"},
    {922337205e10, chars_format::scientific, "9.22337205e+18"},
    {184467441e11, chars_format::scientific, "1.84467441e+19"},
    {36893489e12, chars_format::scientific, "3.6893489e+19"},
    {7378699e13, chars_format::scientific, "7.378699e+19"},
    {1475741e14, chars_format::scientific, "1.475741e+20"},
    {295149e15, chars_format::scientific, "2.95149e+20"},
    {59031e16, chars_format::scientific, "5.9031e+20"},
    {11807e17, chars_format::scientific, "1.1807e+21"},
    {2363e18, chars_format::scientific, "2.363e+21"},
    {473e19, chars_format::scientific, "4.73e+21"},
    {95e20, chars_format::scientific, "9.5e+21"},
    {19e21, chars_format::scientific, "1.9e+22"},
    {5e22, chars_format::scientific, "5e+22"},
    {302230528e15, chars_format::scientific, "3.02230528e+23"},
    {302232576e15, chars_format::scientific, "3.02232576e+23"},
    {81123342286848e18, chars_format::scientific, "8.1123342286848e+31"},
    {81192061763584e18, chars_format::scientific, "8.1192061763584e+31"},

    // Test the switching logic of chars_format::general.
    // C11 7.21.6.1 "The fprintf function"/8:
    // "Let P equal [...] 6 if the precision is omitted [...].
    // Then, if a conversion with style E would have an exponent of X:
    // - if P > X >= -4, the conversion is with style f [...].
    // - otherwise, the conversion is with style e [...]."
    {1e-6, chars_format::general, "1e-06"},
    {1e-5, chars_format::general, "1e-05"},
    {1e-4, chars_format::general, "0.0001"},
    {1e-3, chars_format::general, "0.001"},
    {1e-2, chars_format::general, "0.01"},
    {1e-1, chars_format::general, "0.1"},
    {1e0, chars_format::general, "1"},
    {1e1, chars_format::general, "10"},
    {1e2, chars_format::general, "100"},
    {1e3, chars_format::general, "1000"},
    {1e4, chars_format::general, "10000"},
    {1e5, chars_format::general, "100000"},
    {1e6, chars_format::general, "1e+06"},
    {1e7, chars_format::general, "1e+07"},
    {1.234e-6, chars_format::general, "1.234e-06"},
    {1.234e-5, chars_format::general, "1.234e-05"},
    {1.234e-4, chars_format::general, "0.0001234"},
    {1.234e-3, chars_format::general, "0.001234"},
    {1.234e-2, chars_format::general, "0.01234"},
    {1.234e-1, chars_format::general, "0.1234"},
    {1.234e0, chars_format::general, "1.234"},
    {1.234e1, chars_format::general, "12.34"},
    {1.234e2, chars_format::general, "123.4"},
    {1.234e3, chars_format::general, "1234"},
    {1.234e4, chars_format::general, "12340"},
    {1.234e5, chars_format::general, "123400"},
    {1.234e6, chars_format::general, "1.234e+06"},
    {1.234e7, chars_format::general, "1.234e+07"},
    {1.234e8, chars_format::general, "1.234e+08"},
    {1.234e9, chars_format::general, "1.234e+09"},
    {1.234e10, chars_format::general, "1.234e+10"},

    // Test the switching logic of the plain overload.
    // N4762 19.19.2 [charconv.to.chars]/8:
    // "The conversion specifier is f or e, chosen according to the requirement
    // for a shortest representation (see above); a tie is resolved in favor of f."
    {1e-6, chars_format{}, "1e-06"},
    {1e-5, chars_format{}, "1e-05"},
    {1e-4, chars_format{}, "1e-04"},
    {1e-3, chars_format{}, "0.001"},
    {1e-2, chars_format{}, "0.01"},
    {1e-1, chars_format{}, "0.1"},
    {1e0, chars_format{}, "1"},
    {1e1, chars_format{}, "10"},
    {1e2, chars_format{}, "100"},
    {1e3, chars_format{}, "1000"},
    {1e4, chars_format{}, "10000"},
    {1e5, chars_format{}, "1e+05"},
    {1e6, chars_format{}, "1e+06"},
    {1e7, chars_format{}, "1e+07"},
    {1.234e-6, chars_format{}, "1.234e-06"},
    {1.234e-5, chars_format{}, "1.234e-05"},
    {1.234e-4, chars_format{}, "0.0001234"},
    {1.234e-3, chars_format{}, "0.001234"},
    {1.234e-2, chars_format{}, "0.01234"},
    {1.234e-1, chars_format{}, "0.1234"},
    {1.234e0, chars_format{}, "1.234"},
    {1.234e1, chars_format{}, "12.34"},
    {1.234e2, chars_format{}, "123.4"},
    {1.234e3, chars_format{}, "1234"},
    {1.234e4, chars_format{}, "12340"},
    {1.234e5, chars_format{}, "123400"},
    {1.234e6, chars_format{}, "1234000"},
    {1.234e7, chars_format{}, "12340000"},
    {1.234e8, chars_format{}, "123400000"},
    {1.234e9, chars_format{}, "1.234e+09"},
    {1.234e10, chars_format{}, "1.234e+10"},

    // GH-331 "<charconv>: Test plain shortest's large integer fallback"
    // The exactly-representable integer 123456789012345683968 is 21 digits, but scientific shortest needs 22
    // characters. Therefore, the plain overload must select fixed notation. Because this 21-digit number exceeds the
    // 17-digit round-trip limit, we can't use Ryu - we need to activate the large integer fallback (Ryu Printf for
    // double).
    {123456789012345683968.0, chars_format::scientific, "1.2345678901234568e+20"},
    {123456789012345683968.0, chars_format{}, "123456789012345683968"},

    // Exact value is 1.9156918820264798304697...e-56, incorrectly rounded by dtoa_milo() (Grisu2).
    {0x1.e0ffed391517ep-186, chars_format::scientific, "1.9156918820264798e-56"},

    // Exact value is 6.6564021122018745286598...e+264, incorrectly rounded by dtoa_milo() (Grisu2).
    {0x1.a6c767640cd71p+879, chars_format::scientific, "6.6564021122018745e+264"},

    // Incorrectly handled by dtoa_milo() (Grisu2), which doesn't achieve shortest round-trip.
    {4.91e-6, chars_format::scientific, "4.91e-06"},
    {5.547e-6, chars_format::scientific, "5.547e-06"},

    // Test hexfloat corner cases.
    {0x1.728p+0, chars_format::hex, "1.728p+0"}, // instead of "2.e5p-1"
    {0x0.0000000000001p-1022, chars_format::hex, "0.0000000000001p-1022"}, // instead of "1p-1074", min subnormal
    {0x0.fffffffffffffp-1022, chars_format::hex, "0.fffffffffffffp-1022"}, // max subnormal
    {0x1p-1022, chars_format::hex, "1p-1022"}, // min normal
    {0x1.fffffffffffffp+1023, chars_format::hex, "1.fffffffffffffp+1023"}, // max normal

    // Test hexfloat exponents.
    {0x1p-1009, chars_format::hex, "1p-1009"},
    {0x1p-999, chars_format::hex, "1p-999"},
    {0x1p-99, chars_format::hex, "1p-99"},
    {0x1p-9, chars_format::hex, "1p-9"},
    {0x1p+0, chars_format::hex, "1p+0"},
    {0x1p+9, chars_format::hex, "1p+9"},
    {0x1p+99, chars_format::hex, "1p+99"},
    {0x1p+999, chars_format::hex, "1p+999"},
    {0x1p+1009, chars_format::hex, "1p+1009"},

    // Test hexfloat hexits.
    {0x1.01234567p+0, chars_format::hex, "1.01234567p+0"},
    {0x1.89abcdefp+0, chars_format::hex, "1.89abcdefp+0"},

    // Test hexfloat trimming.
    {0x1.000000000000ap+0, chars_format::hex, "1.000000000000ap+0"},
    {0x1.00000000000ap+0, chars_format::hex, "1.00000000000ap+0"},
    {0x1.0000000000ap+0, chars_format::hex, "1.0000000000ap+0"},
    {0x1.000000000ap+0, chars_format::hex, "1.000000000ap+0"},
    {0x1.00000000ap+0, chars_format::hex, "1.00000000ap+0"},
    {0x1.0000000ap+0, chars_format::hex, "1.0000000ap+0"},
    {0x1.000000ap+0, chars_format::hex, "1.000000ap+0"},
    {0x1.00000ap+0, chars_format::hex, "1.00000ap+0"},
    {0x1.0000ap+0, chars_format::hex, "1.0000ap+0"},
    {0x1.000ap+0, chars_format::hex, "1.000ap+0"},
    {0x1.00ap+0, chars_format::hex, "1.00ap+0"},
    {0x1.0ap+0, chars_format::hex, "1.0ap+0"},
    {0x1.ap+0, chars_format::hex, "1.ap+0"},
    {0x1p+0, chars_format::hex, "1p+0"},

    // https://www.exploringbinary.com/the-shortest-decimal-string-that-round-trips-may-not-be-the-nearest/
    // This is an exhaustive list of anomalous values.

    // Because math, these values have shortest-round-trip decimal representations containing 16 significant digits,
    // but those decimal digits aren't what would be printed by "%.15e". For ordinary values, shortest-round-trip
    // behaves as if it can magically pick a precision for "%.*e", finding the smallest precision that round-trips.
    // (That is, start with the exact decimal representation, and then round it as much as possible.) These anomalous
    // values demonstrate an exception to that mental model. They aren't being "incorrectly rounded"; instead, having
    // the shortest output that round-trips is being prioritized. (This differs by 1 in the least significant decimal
    // digit printed, so it's a very small difference.)

    // N4835 20.19.2 [charconv.to.chars]/2 demands this behavior:
    // "The functions that take a floating-point value but not a precision parameter ensure that the string
    // representation consists of the smallest number of characters such that there is at least one digit before the
    // radix point (if present) and parsing the representation using the corresponding from_chars function recovers
    // value exactly. [...] If there are several such representations, the representation with the smallest difference
    // from the floating-point argument value is chosen, resolving any remaining ties using rounding according to
    // round_to_nearest (17.3.4.1)."
    {0x1p976, chars_format::scientific, "6.386688990511104e+293"},
    {0x1p896, chars_format::scientific, "5.282945311356653e+269"},
    {0x1p863, chars_format::scientific, "6.150157786156811e+259"},
    {0x1p803, chars_format::scientific, "5.334411546303884e+241"},
    {0x1p710, chars_format::scientific, "5.386379163185535e+213"},
    {0x1p594, chars_format::scientific, "6.483618076376552e+178"},
    {0x1p574, chars_format::scientific, "6.183260036827614e+172"},
    {0x1p554, chars_format::scientific, "5.896816288783659e+166"},
    {0x1p544, chars_format::scientific, "5.758609657015292e+163"},
    {0x1p534, chars_format::scientific, "5.623642243178996e+160"},
    {0x1p481, chars_format::scientific, "6.243497100631985e+144"},
    {0x1p405, chars_format::scientific, "8.263199609878108e+121"},
    {0x1p398, chars_format::scientific, "6.455624695217272e+119"},
    {0x1p378, chars_format::scientific, "6.156563468186638e+113"},
    {0x1p345, chars_format::scientific, "7.167183174968974e+103"},
    {0x1p305, chars_format::scientific, "6.518515124270356e+91"},
    {0x1p275, chars_format::scientific, "6.070840288205404e+82"},
    {0x1p182, chars_format::scientific, "6.129982163463556e+54"},
    {0x1p172, chars_format::scientific, "5.986310706507379e+51"},
    {0x1p132, chars_format::scientific, "5.444517870735016e+39"},
    {0x1p122, chars_format::scientific, "5.316911983139664e+36"},
    {0x1p89, chars_format::scientific, "6.189700196426902e+26"},
    {0x1p-24, chars_format::scientific, "5.960464477539063e-08"},
    {0x1p-44, chars_format::scientific, "5.684341886080802e-14"},
    {0x1p-77, chars_format::scientific, "6.617444900424222e-24"},
    {0x1p-97, chars_format::scientific, "6.310887241768095e-30"},
    {0x1p-140, chars_format::scientific, "7.174648137343064e-43"},
    {0x1p-296, chars_format::scientific, "7.854549544476363e-90"},
    {0x1p-366, chars_format::scientific, "6.653062250012736e-111"},
    {0x1p-383, chars_format::scientific, "5.075883674631299e-116"},
    {0x1p-489, chars_format::scientific, "6.256509672447191e-148"},
    {0x1p-496, chars_format::scientific, "4.887898181599368e-150"},
    {0x1p-509, chars_format::scientific, "5.966672584960166e-154"},
    {0x1p-549, chars_format::scientific, "5.426657103235053e-166"},
    {0x1p-652, chars_format::scientific, "5.351097043477547e-197"},
    {0x1p-662, chars_format::scientific, "5.225680706521042e-200"},
    {0x1p-695, chars_format::scientific, "6.083493012144512e-210"},
    {0x1p-705, chars_format::scientific, "5.940911144672375e-213"},
    {0x1p-778, chars_format::scientific, "6.290184345309701e-235"},
    {0x1p-788, chars_format::scientific, "6.142758149716505e-238"},
    {0x1p-791, chars_format::scientific, "7.678447687145631e-239"},
    {0x1p-808, chars_format::scientific, "5.858190679279809e-244"},
    {0x1p-921, chars_format::scientific, "5.641232424577593e-278"},
    {0x1p-957, chars_format::scientific, "8.209073602596753e-289"},
    {0x1p-1007, chars_format::scientific, "7.291122019556398e-304"},
    {0x1p-1017, chars_format::scientific, "7.120236347223045e-307"},

    // This is an exhaustive list of almost-but-not-quite-anomalous values.
    {0x1p966, chars_format::scientific, "6.237000967296e+290"},
    {0x1p956, chars_format::scientific, "6.090821257125e+287"},
    {0x1p890, chars_format::scientific, "8.25460204899477e+267"},
    {0x1p740, chars_format::scientific, "5.78358058743443e+222"},
    {0x1p149, chars_format::scientific, "7.1362384635298e+44"},
    {0x1p-499, chars_format::scientific, "6.10987272699921e-151"},
    {0x1p-569, chars_format::scientific, "5.17526350329881e-172"},
    {0x1p-645, chars_format::scientific, "6.84940421565126e-195"},
};

inline constexpr double_to_chars_testcase double_scientific_precision_to_chars_test_cases_1[] = {
    // Test special cases (zero, inf, nan) and an ordinary case. Also test negative signs.
    {0.0, chars_format::scientific, 4, "0.0000e+00"},
    {-0.0, chars_format::scientific, 4, "-0.0000e+00"},
    {double_inf, chars_format::scientific, 4, "inf"},
    {-double_inf, chars_format::scientific, 4, "-inf"},
    {double_nan, chars_format::scientific, 4, "nan"},
    {-double_nan, chars_format::scientific, 4, "-nan"},
    {1.729, chars_format::scientific, 4, "1.7290e+00"},
    {-1.729, chars_format::scientific, 4, "-1.7290e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest Basic
    {0x1.000000001869fp+211, chars_format::scientific, 62,
        "3.29100911471548643542566484557342614975886952410844652587974656e+63"},

    // Ryu Printf d2fixed_test.cc D2expTest Zero
    {0.0, chars_format::scientific, 4, "0.0000e+00"},
    {0.0, chars_format::scientific, 3, "0.000e+00"},
    {0.0, chars_format::scientific, 2, "0.00e+00"},
    {0.0, chars_format::scientific, 1, "0.0e+00"},
    {0.0, chars_format::scientific, 0, "0e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest MinMax
    {0x0.0000000000001p-1022, chars_format::scientific, 750,
        "4.9406564584124654417656879286822137236505980261432476442558568250067550727020875186529983"
        "636163599237979656469544571773092665671035593979639877479601078187812630071319031140452784"
        "581716784898210368871863605699873072305000638740915356498438731247339727316961514003171538"
        "539807412623856559117102665855668676818703956031062493194527159149245532930545654440112748"
        "012970999954193198940908041656332452475714786901472678015935523861155013480352649347201937"
        "902681071074917033322268447533357208324319360923828934583680601060115061698097530783422773"
        "183292479049825247307763759272478746560847782037344696995336470179726777175851256605511991"
        "315048911014510378627381672509558373897335989936648099411642057026370902792427675445652290"
        "87538682506419718265533447265625e-324"},

    {0x1.fffffffffffffp+1023, chars_format::scientific, 308,
        "1.7976931348623157081452742373170435679807056752584499659891747680315726078002853876058955"
        "863276687817154045895351438246423432132688946418276846754670353751698604991057655128207624"
        "549009038932894407586850845513394230458323690322294816580855933212334827479782620414472316"
        "8738177180919299881250404026184124858368e+308"},

    // Test more corner cases.
    {0x0.fffffffffffffp-1022, chars_format::scientific, 766,
        "2."
        "2250738585072008890245868760858598876504231122409594654935248025624400092282356951787758888037591552642309"
        "7809504343120858773871583572918219930202943792242235598198275012420417889695713117910822610439719796040004"
        "5489739193807919893608152561311337614984204327175103362739154978273159414382813627511383860409424946494228"
        "6316695429105080201815926642134996606517803095075913058719846423906068637102005108723282784678843631944515"
        "8661350412234790147923695852083215976210663754016137365830441936037147783553066828345356340050740730401356"
        "0296804637591858316312422452159926254649430083685186171942241764645513713542013221703137049658321015465406"
        "8035397417906022589503023501937519773030945763173210852507299305089761582519159720757232455434770912461317"
        "493580281734466552734375e-308"}, // max subnormal
    {0x1p-1022, chars_format::scientific, 714,
        "2."
        "2250738585072013830902327173324040642192159804623318305533274168872044348139181958542831590125110205640673"
        "3973103581100515243416155346010885601238537771882113077799353200233047961014744258363607192156504694250373"
        "4208375250806650616658158948720491179968591639648500635908770118304874799780887753749949451580451605050915"
        "3998565824708186451135379358049921159810857660519924333521143523901487956996095912888916029926415110634663"
        "1339366347758651302937176204732563178148566435087212282863764204484681140761391147706280168985324411002416"
        "1447421618567166150540154285084716752901903161322778896729707373123334086988983175067838846926092773977972"
        "858659654941091369095406136467568702398678315290680984617210924625396728515625e-308"}, // min normal

    // Ryu Printf d2fixed_test.cc D2expTest RoundToEven
    {0.125, chars_format::scientific, 2, "1.25e-01"},
    {0.125, chars_format::scientific, 1, "1.2e-01"},
    {0.375, chars_format::scientific, 2, "3.75e-01"},
    {0.375, chars_format::scientific, 1, "3.8e-01"},

    // Ryu Printf d2fixed_test.cc D2expTest RoundToEvenInteger
    {2.5, chars_format::scientific, 1, "2.5e+00"},
    {2.5, chars_format::scientific, 0, "2e+00"},
    {3.5, chars_format::scientific, 1, "3.5e+00"},
    {3.5, chars_format::scientific, 0, "4e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest NonRoundToEvenScenarios
    {0.748046875, chars_format::scientific, 2, "7.48e-01"},
    {0.748046875, chars_format::scientific, 1, "7.5e-01"},
    {0.748046875, chars_format::scientific, 0, "7e-01"}, // 0.75 would round to "8e-01", but this is smaller

    {0.2509765625, chars_format::scientific, 2, "2.51e-01"},
    {0.2509765625, chars_format::scientific, 1, "2.5e-01"},
    {0.2509765625, chars_format::scientific, 0, "3e-01"}, // 0.25 would round to "2e-01", but this is larger

    {0x1.0000000000001p-2, chars_format::scientific, 53, "2.50000000000000055511151231257827021181583404541015625e-01"},
    {0x1.0000000000001p-2, chars_format::scientific, 2, "2.50e-01"},
    {0x1.0000000000001p-2, chars_format::scientific, 1, "2.5e-01"},
    {0x1.0000000000001p-2, chars_format::scientific, 0,
        "3e-01"}, // 0.25 would round to "2e-01", but this is larger (again)

    // More rounding tests.
    {9.5, chars_format::scientific, 1, "9.5e+00"},
    {9.5, chars_format::scientific, 0, "1e+01"},
    {10.5, chars_format::scientific, 2, "1.05e+01"},
    {10.5, chars_format::scientific, 1, "1.0e+01"},

    {1.241, chars_format::scientific, 3, "1.241e+00"},
    {1.241, chars_format::scientific, 1, "1.2e+00"},
    {1.251, chars_format::scientific, 3, "1.251e+00"},
    {1.251, chars_format::scientific, 1, "1.3e+00"},
    {1.261, chars_format::scientific, 3, "1.261e+00"},
    {1.261, chars_format::scientific, 1, "1.3e+00"},
    {1.341, chars_format::scientific, 3, "1.341e+00"},
    {1.341, chars_format::scientific, 1, "1.3e+00"},
    {1.351, chars_format::scientific, 3, "1.351e+00"},
    {1.351, chars_format::scientific, 1, "1.4e+00"},
    {1.361, chars_format::scientific, 3, "1.361e+00"},
    {1.361, chars_format::scientific, 1, "1.4e+00"},

    {2.41, chars_format::scientific, 2, "2.41e+00"},
    {2.41, chars_format::scientific, 0, "2e+00"},
    {2.51, chars_format::scientific, 2, "2.51e+00"},
    {2.51, chars_format::scientific, 0, "3e+00"},
    {2.61, chars_format::scientific, 2, "2.61e+00"},
    {2.61, chars_format::scientific, 0, "3e+00"},
    {3.41, chars_format::scientific, 2, "3.41e+00"},
    {3.41, chars_format::scientific, 0, "3e+00"},
    {3.51, chars_format::scientific, 2, "3.51e+00"},
    {3.51, chars_format::scientific, 0, "4e+00"},
    {3.61, chars_format::scientific, 2, "3.61e+00"},
    {3.61, chars_format::scientific, 0, "4e+00"},

    // Ryu Printf d2fixed_test.cc D2expTest VaryingPrecision
    {1729.142857142857, chars_format::scientific, 50, "1.72914285714285711037518922239542007446289062500000e+03"},
    {1729.142857142857, chars_format::scientific, 49, "1.7291428571428571103751892223954200744628906250000e+03"},
    {1729.142857142857, chars_format::scientific, 48, "1.729142857142857110375189222395420074462890625000e+03"},
    {1729.142857142857, chars_format::scientific, 47, "1.72914285714285711037518922239542007446289062500e+03"},
    {1729.142857142857, chars_format::scientific, 46, "1.7291428571428571103751892223954200744628906250e+03"},
    {1729.142857142857, chars_format::scientific, 45, "1.729142857142857110375189222395420074462890625e+03"},
    {1729.142857142857, chars_format::scientific, 44, "1.72914285714285711037518922239542007446289062e+03"},
    {1729.142857142857, chars_format::scientific, 43, "1.7291428571428571103751892223954200744628906e+03"},
    {1729.142857142857, chars_format::scientific, 42, "1.729142857142857110375189222395420074462891e+03"},
    {1729.142857142857, chars_format::scientific, 41, "1.72914285714285711037518922239542007446289e+03"},
    {1729.142857142857, chars_format::scientific, 40, "1.7291428571428571103751892223954200744629e+03"},
    {1729.142857142857, chars_format::scientific, 39, "1.729142857142857110375189222395420074463e+03"},
    {1729.142857142857, chars_format::scientific, 38, "1.72914285714285711037518922239542007446e+03"},
    {1729.142857142857, chars_format::scientific, 37, "1.7291428571428571103751892223954200745e+03"},
    {1729.142857142857, chars_format::scientific, 36, "1.729142857142857110375189222395420074e+03"},
    {1729.142857142857, chars_format::scientific, 35, "1.72914285714285711037518922239542007e+03"},
    {1729.142857142857, chars_format::scientific, 34, "1.7291428571428571103751892223954201e+03"},
    {1729.142857142857, chars_format::scientific, 33, "1.729142857142857110375189222395420e+03"},
    {1729.142857142857, chars_format::scientific, 32, "1.72914285714285711037518922239542e+03"},
    {1729.142857142857, chars_format::scientific, 31, "1.7291428571428571103751892223954e+03"},
    {1729.142857142857, chars_format::scientific, 30, "1.729142857142857110375189222395e+03"},
    {1729.142857142857, chars_format::scientific, 29, "1.72914285714285711037518922240e+03"},
    {1729.142857142857, chars_format::scientific, 28, "1.7291428571428571103751892224e+03"},
    {1729.142857142857, chars_format::scientific, 27, "1.729142857142857110375189222e+03"},
    {1729.142857142857, chars_format::scientific, 26, "1.72914285714285711037518922e+03"},
    {1729.142857142857, chars_format::scientific, 25, "1.7291428571428571103751892e+03"},
    {1729.142857142857, chars_format::scientific, 24, "1.729142857142857110375189e+03"},
    {1729.142857142857, chars_format::scientific, 23, "1.72914285714285711037519e+03"},
    {1729.142857142857, chars_format::scientific, 22, "1.7291428571428571103752e+03"},
    {1729.142857142857, chars_format::scientific, 21, "1.729142857142857110375e+03"},
    {1729.142857142857, chars_format::scientific, 20, "1.72914285714285711038e+03"},
    {1729.142857142857, chars_format::scientific, 19, "1.7291428571428571104e+03"},
    {1729.142857142857, chars_format::scientific, 18, "1.729142857142857110e+03"},
    {1729.142857142857, chars_format::scientific, 17, "1.72914285714285711e+03"},
    {1729.142857142857, chars_format::scientific, 16, "1.7291428571428571e+03"},
    {1729.142857142857, chars_format::scientific, 15, "1.729142857142857e+03"},
    {1729.142857142857, chars_format::scientific, 14, "1.72914285714286e+03"},
    {1729.142857142857, chars_format::scientific, 13, "1.7291428571429e+03"},
    {1729.142857142857, chars_format::scientific, 12, "1.729142857143e+03"},
    {1729.142857142857, chars_format::scientific, 11, "1.72914285714e+03"},
    {1729.142857142857, chars_format::scientific, 10, "1.7291428571e+03"},
    {1729.142857142857, chars_format::scientific, 9, "1.729142857e+03"},
    {1729.142857142857, chars_format::scientific, 8, "1.72914286e+03"},
    {1729.142857142857, chars_format::scientific, 7, "1.7291429e+03"},
    {1729.142857142857, chars_format::scientific, 6, "1.729143e+03"},
    {1729.142857142857, chars_format::scientific, 5, "1.72914e+03"},
    {1729.142857142857, chars_format::scientific, 4, "1.7291e+03"},
    {1729.142857142857, chars_format::scientific, 3, "1.729e+03"},
    {1729.142857142857, chars_format::scientific, 2, "1.73e+03"},
    {1729.142857142857, chars_format::scientific, 1, "1.7e+03"},
    {1729.142857142857, chars_format::scientific, 0, "2e+03"},

    // Negative precision requests 6 digits of precision.
    {1729.142857142857, chars_format::scientific, -1, "1.729143e+03"},
    {1729.142857142857, chars_format::scientific, -2, "1.729143e+03"},
    {1729.142857142857, chars_format::scientific, -3, "1.729143e+03"},

    // Ryu Printf d2fixed_test.cc D2expTest Carrying
    {2.0009, chars_format::scientific, 4, "2.0009e+00"},
    {2.0009, chars_format::scientific, 3, "2.001e+00"},
    {2.0029, chars_format::scientific, 4, "2.0029e+00"},
    {2.0029, chars_format::scientific, 3, "2.003e+00"},
    {2.0099, chars_format::scientific, 4, "2.0099e+00"},
    {2.0099, chars_format::scientific, 3, "2.010e+00"},
    {2.0299, chars_format::scientific, 4, "2.0299e+00"},
    {2.0299, chars_format::scientific, 3, "2.030e+00"},
    {2.0999, chars_format::scientific, 4, "2.0999e+00"},
    {2.0999, chars_format::scientific, 3, "2.100e+00"},
    {2.2999, chars_format::scientific, 4, "2.2999e+00"},
    {2.2999, chars_format::scientific, 3, "2.300e+00"},
    {2.9999, chars_format::scientific, 4, "2.9999e+00"},
    {2.9999, chars_format::scientific, 3, "3.000e+00"},
    {9.9999, chars_format::scientific, 4, "9.9999e+00"},
    {9.9999, chars_format::scientific, 3, "1.000e+01"},

    {2.09, chars_format::scientific, 2, "2.09e+00"},
    {2.09, chars_format::scientific, 1, "2.1e+00"},
    {2.29, chars_format::scientific, 2, "2.29e+00"},
    {2.29, chars_format::scientific, 1, "2.3e+00"},
    {2.99, chars_format::scientific, 2, "2.99e+00"},
    {2.99, chars_format::scientific, 1, "3.0e+00"},
    {9.99, chars_format::scientific, 2, "9.99e+00"},
    {9.99, chars_format::scientific, 1, "1.0e+01"},

    {2.9, chars_format::scientific, 1, "2.9e+00"},
    {2.9, chars_format::scientific, 0, "3e+00"},
    {9.9, chars_format::scientific, 1, "9.9e+00"},
    {9.9, chars_format::scientific, 0, "1e+01"},

    // Ryu Printf d2fixed_test.cc D2expTest Exponents
    {9.99e-100, chars_format::scientific, 2, "9.99e-100"},
    {9.99e-99, chars_format::scientific, 2, "9.99e-99"},
    {9.99e-10, chars_format::scientific, 2, "9.99e-10"},
    {9.99e-09, chars_format::scientific, 2, "9.99e-09"},
    {9.99e-01, chars_format::scientific, 2, "9.99e-01"},
    {9.99e+00, chars_format::scientific, 2, "9.99e+00"},
    {9.99e+01, chars_format::scientific, 2, "9.99e+01"},
    {9.99e+09, chars_format::scientific, 2, "9.99e+09"},
    {9.99e+10, chars_format::scientific, 2, "9.99e+10"},
    {9.99e+99, chars_format::scientific, 2, "9.99e+99"},
    {9.99e+100, chars_format::scientific, 2, "9.99e+100"},

    {9.99e-100, chars_format::scientific, 1, "1.0e-99"},
    {9.99e-99, chars_format::scientific, 1, "1.0e-98"},
    {9.99e-10, chars_format::scientific, 1, "1.0e-09"},
    {9.99e-09, chars_format::scientific, 1, "1.0e-08"},
    {9.99e-01, chars_format::scientific, 1, "1.0e+00"},
    {9.99e+00, chars_format::scientific, 1, "1.0e+01"},
    {9.99e+01, chars_format::scientific, 1, "1.0e+02"},
    {9.99e+09, chars_format::scientific, 1, "1.0e+10"},
    {9.99e+10, chars_format::scientific, 1, "1.0e+11"},
    {9.99e+99, chars_format::scientific, 1, "1.0e+100"},
    {9.99e+100, chars_format::scientific, 1, "1.0e+101"},

    // Ryu Printf d2fixed_test.cc D2expTest PrintDecimalPoint
    // These values exercise each codepath.
    {1e+54, chars_format::scientific, 0, "1e+54"},
    {1e+54, chars_format::scientific, 1, "1.0e+54"},
    {1e-63, chars_format::scientific, 0, "1e-63"},
    {1e-63, chars_format::scientific, 1, "1.0e-63"},
    {1e+83, chars_format::scientific, 0, "1e+83"},
    {1e+83, chars_format::scientific, 1, "1.0e+83"},

    // The UCRT had trouble with rounding this value. charconv was never affected, but let's test it anyways.
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 104,
        "1.09995565999999994887854821710219658911365648587951921896774663603198787416706536331386569598149846892544e+"
        "104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 18, "1.099955659999999949e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 17, "1.09995565999999995e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 16, "1.0999556599999999e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 15, "1.099955660000000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 14, "1.09995566000000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 13, "1.0999556600000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 12, "1.099955660000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 11, "1.09995566000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 10, "1.0999556600e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 9, "1.099955660e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 8, "1.09995566e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 7, "1.0999557e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 6, "1.099956e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 5, "1.09996e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 4, "1.1000e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 3, "1.100e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 2, "1.10e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 1, "1.1e+104"},
    {0x1.88e2d605edc3dp+345, chars_format::scientific, 0, "1e+104"},
};

inline constexpr double_to_chars_testcase double_scientific_precision_to_chars_test_cases_2[] = {
    // Ryu Printf d2fixed_test.cc D2expTest AllPowersOfTen
    // These values test every power of ten that's within the range of doubles.
    {1e-323, chars_format::scientific, 749,
        "9."
        "8813129168249308835313758573644274473011960522864952885117136500135101454041750373059967272327198475959312"
        "9390891435461853313420711879592797549592021563756252601426380622809055691634335697964207377437272113997461"
        "4461000127748183071299687746249467945463392302800634307707961482524771311823420533171133735363740791206212"
        "4986389054318298491065861091308880225496025941999908386397881816083312664904951429573802945356031871047722"
        "3100269607052986944038758053621421498340666445368950667144166486387218476578691673612021202301233961950615"
        "6684554636658495809965049461552751854495749312169556407468939399067294035945355435170251321102398263009782"
        "2029020757254763345019116747794671979873296198823284114052741805584855350891304581750773650128394365310668"
        "9453125e-324"},
    {1e-322, chars_format::scientific, 749,
        "9."
        "8813129168249308835313758573644274473011960522864952885117136500135101454041750373059967272327198475959312"
        "9390891435461853313420711879592797549592021563756252601426380622809055691634335697964207377437272113997461"
        "4461000127748183071299687746249467945463392302800634307707961482524771311823420533171133735363740791206212"
        "4986389054318298491065861091308880225496025941999908386397881816083312664904951429573802945356031871047722"
        "3100269607052986944038758053621421498340666445368950667144166486387218476578691673612021202301233961950615"
        "6684554636658495809965049461552751854495749312169556407468939399067294035945355435170251321102398263009782"
        "2029020757254763345019116747794671979873296198823284114052741805584855350891304581750773650128394365310668"
        "9453125e-323"},
    {1e-321, chars_format::scientific, 751,
        "9."
        "9801260459931801923666896159380717217742080128093602413968307865136452468582167876790566945050470460718906"
        "0684800349816471846554918998388725525087941779393815127440644429037146248550679054943849451211644835137436"
        "0605610129025664902012684623711962624918026225828640650785041097350019024941654738502845072717378199118274"
        "6236252944861481475976519702221969027750986201419907470261860634244145791554000943869540974809592189758199"
        "5331272303123516813479145634157635713324073109822640173815608151251090661344478590348141414324246301570121"
        "8251400183025080768064699956168279373040706805291251971543628793057966976304808989521953834313422245639880"
        "0249310964827310978469307915272618699672029160811516955193269223640703904400217627568281386629678308963775"
        "634765625e-322"},
    {1e-320, chars_format::scientific, 750,
        "9."
        "9998886718268300541337523676528005766688104049139332319738542138136722671490251377536686879595124857670824"
        "6943582132687395553181760422147911120187125822521327632643497190282764359933947726339777865966519379365430"
        "9834532129281161268155283999204461560808953010434241919400457020315068567565301579569187340188105680700687"
        "0486225722970118072958651424404586788201978253303907287034656397876312416883810846728688580700304253500294"
        "9777472842337622787367223150264878556320754442713378075149896484223865098297635973695365456728848769494023"
        "0564769292298397759684630055091384876749698303915591084358566671856101564376699700392294336955627042165899"
        "5893369006341820505159346148768208043631775753209163523421374707251873615102000236731782933929935097694396"
        "97265625e-321"},
    {1e-319, chars_format::scientific, 750,
        "9."
        "9998886718268300541337523676528005766688104049139332319738542138136722671490251377536686879595124857670824"
        "6943582132687395553181760422147911120187125822521327632643497190282764359933947726339777865966519379365430"
        "9834532129281161268155283999204461560808953010434241919400457020315068567565301579569187340188105680700687"
        "0486225722970118072958651424404586788201978253303907287034656397876312416883810846728688580700304253500294"
        "9777472842337622787367223150264878556320754442713378075149896484223865098297635973695365456728848769494023"
        "0564769292298397759684630055091384876749698303915591084358566671856101564376699700392294336955627042165899"
        "5893369006341820505159346148768208043631775753209163523421374707251873615102000236731782933929935097694396"
        "97265625e-320"},
    {1e-318, chars_format::scientific, 754,
        "9."
        "9999874849559983034425876814113742209432834168744560969267393309501724022504791795040417479267848129655584"
        "2874876041601750171714894629266707048162621742736965195169511454088992450490864069696757508040293752086570"
        "9580676739282438749985996996081924055488407644357269925743534099929893815278419813774519051525459318108599"
        "1107475586860661255943562083015499877004233213563327286118520376694473250010459896242984318729757813819005"
        "4549703845033693317236663537845414770535737849377831764656567925888728970482401760612101576940871781833642"
        "5626336137844764344642729705586000404268243261408712779922641361250092237317059153946646039468838066148529"
        "6871589296549393052792796339935685990351574486171151756262515234669929463655509149777600441666436381638050"
        "079345703125e-319"},
    {1e-317, chars_format::scientific, 757,
        "1."
        "0000002306925373540838912978475160267584454368668534526669672098520647422515697285766597706921875662045329"
        "8226457012793890336449486476033452643735894613076931082954841359365992666407440152120030445435135990799474"
        "1954259843078263037226060394561354342969032583944572412669499566187211760243538754890531880822606236371978"
        "5920066306644424273339129868180713684032457145760224028598109997351719737497945725367012867943417584786681"
        "2026553849543810389671707959598249520266798536037749981808256864213845855131011662864961199497267523368458"
        "5488557116467671933238644465316019273339602500503268103425725256465919083825811307197979879484581971974592"
        "4201832234008052893493781386861080768235954429611544999118868631378263784093853548673447306782691157422959"
        "804534912109375e-317"},
    {1e-316, chars_format::scientific, 757,
        "9."
        "9999998365971443346061920956311959264775925433695214550458499705922349191381609347228383804226938538653679"
        "2366287780216044499031536405156556539159558732763919890485263237064770961810478612616379963299515548676713"
        "4548944815532598435214836120691606867323339473597648426536418734881746971242559593050185515442628522784588"
        "1185131819846979153816675915341864013104515083595754786004003374046743354151291027432271285983439508858844"
        "2646232720370702133470343586292981797312610775210888475844901856096836954505497483976693591967374658376095"
        "0009031993538060167762492161897827345208061381095352991868150697424341071434604085640940002282989444146358"
        "4493866832825339621246977613831620733691549327791400285367657800597186444724697763908327630133499042131006"
        "717681884765625e-317"},
    {1e-315, chars_format::scientific, 758,
        "9."
        "9999999848168380869801553486018337869440042528874622393432792982679396693408131157854639400126447623561656"
        "3760184721079416030959336106467234733051521976644243346829052258460480303946313987131415432762626210235795"
        "1648564032447600351437582190186923061065358655548532968545933350501169209114129270401493513009634553240699"
        "9866063694642814968591153281329780382737718466036143916002629170014970595400981001006542729590483689199322"
        "3303391066874746239265147746874352601633933250320885156379161863259334250313774632657068696147692692894604"
        "4301624343806379717639929311373569268499339198531592674411496809458432057444014624821271529836759260682332"
        "3945334163260650980068427789118371950611629025890843267716919511388313528497528027277896356395103794056922"
        "1973419189453125e-316"},
    {1e-314, chars_format::scientific, 759,
        "9."
        "9999999996388074622175516738988975729906454238392563177730222310355101443610783338917264959716398532052454"
        "0899574415165753184152116076598302552440718301032275692463431160600051238159897524582918979708937276391703"
        "3358525954139100543059856797136454680439560573743621422746884812063111432901286238136624312766335156286311"
        "1734156882122398550068601017928572019701038804280182829002491749611793319525949998363969873951188107233370"
        "1369106901525150649844628162932489682066065497831884824432587863975583979894602347525106206565724496346455"
        "3730883578833211672627673026321143460828466980275216642665831420661841156044955678739304682592136242335929"
        "7890480896304182115950572806647047072303636995700787565951845682467426236874811053614853229021264269249513"
        "74530792236328125e-315"},
    {1e-313, chars_format::scientific, 761,
        "1."
        "0000000000132873108058798218075466365858866796204316120387346995461095826861753841161935247836939689566881"
        "4013755407163529775592520874226933814642035817851187677065124379067137026930035030916463576460714764526356"
        "6941552468486215054944726595070143906775203397101679103788691652744850950702752480372779533942489184305449"
        "8212975998837171800278451594248186507426648281555498412610248716893168741033011563160921744542987825450117"
        "1730463076268016413019727751013442758474713657274891814670103539733279230421396327135404079024632555646151"
        "7071185888666743940446059781681939593390610457300000410827430924103528812599832038053657245435064880839104"
        "9702198578740563315381331097389800290969337059469445237589300988817006332715405382115941845810880295175593"
        "3463573455810546875e-313"},
    {1e-312, chars_format::scientific, 761,
        "9."
        "9999999999846534143064242548224957279984003844947981796030495661334201221115511889808726222773497386583906"
        "0366160174694434384393280942568027468226466215267996447194900001649974559958214473790120729137684534602007"
        "8598425065645235547531043204631943751558291951834840153344907012832890084789653234050444031427324837024042"
        "1011079056496922166969741465115877157896849612172543736972488543135719183088865941635643173986271210320831"
        "2523973604333660086091482705973846213942815250273808150020501137325629806918154994205360415142145238426998"
        "5617566294317171084910720379669920191982813295182567868591765894923254035012310969997392122823095038574513"
        "7282534320075197842454489523722716158476450514996352932910660626459272200070280990896048889382541347004007"
        "5480937957763671875e-313"},
    {1e-311, chars_format::scientific, 762,
        "9."
        "9999999999994753836816616511477927917844470256657499736814793090661876925865714541989788848333087337492396"
        "8343299564388520721546473722538158536045855411592384479540534380552114130892428057327572232684630845668163"
        "7680135027566927047722665479238893283177666153753035241799107964294452027013440391018179162227081537627087"
        "7122947149684401750551218912852475949533812932510787775885488405715316005812990910633000601130631914738865"
        "3002039320168310490502062186389904351023247382521319149688554563326346056647735821920228452652563270230450"
        "4126995553552197916865708123384867766175142422964311492560020229534457444110911911051310155975850415556167"
        "3256479466808241373590371668740244833598142522966162877208895552630351312778658273922385846255167507479200"
        "13964176177978515625e-312"},
    {1e-310, chars_format::scientific, 763,
        "9."
        "9999999999999694493275028976919693605773152470381150334840936338306132782690721297062490935851740335856013"
        "1942537544044990266118246815203829571639835051469864080618722193182185449923568510112153949469529056037035"
        "6316192026297650097729052888392458267564978627150308411414247996009837425087566629583770333253740094313855"
        "8993342752790651070003934827777029242588378376522062577182588401134635899903795076266245848702110604886133"
        "1017974844029465503982414835737106288925928453596236183010823010859703264972055182844057387236243871290565"
        "4743976528860032144597541048175366018648220060557036280025628707354830891080865275753107423747608928122222"
        "4455610971699342824628234406907495789435532256565156542018836716836053949868937516689930411484255046161706"
        "559360027313232421875e-311"},
    {1e-309, chars_format::scientific, 765,
        "1."
        "0000000000000018855892087022346387017456602069175351539464355066307055836837322197256976114460360563569237"
        "4830246134201063722057542412447039667519923301545761204072654097444519258182668255539061212114801887707392"
        "2817979772617072240272969162930781476600370987449003572837576199918137596489497925344032945035640594998253"
        "2718038231310127600194920641926948457189383492092319005731229840067656788931287549282957037345925847390085"
        "9881956839641558100533045010067182648271619656070372788634304985561303898580448711893644028069461193139657"
        "6980567462639081556737072434065441584389552782431630875877218955513686823577786061222328715052478477937882"
        "7957552412218845296973202068072422088501927122992505590849983083325662421357796544096668486800716380002995"
        "72013318538665771484375e-309"},
    {1e-308, chars_format::scientific, 764,
        "9."
        "9999999999999990932662533724846199547048873403204569370722504933164788134100221702366853061102859515757830"
        "1758491822824378438792553200763769833775473829862512856683413461939989729065436937279228852476622948659167"
        "9434355446221493480729436132941672166628217375554144801591156397912760548972014203897705803515339607715061"
        "9905566488977026029171097782672502440171652303162739065260414400859795093549243326204240563556399326294969"
        "1698930975461134804791235994697938405200089317860731205010159117711704697471514344499487123311264707354172"
        "3780995387378502198261451023662795913796604718812599767273565216024053297899062477635215259813914438876185"
        "7527558861992808911690506171197530846785775640581096161907433186688396108094354271255983085398000298482656"
        "9445431232452392578125e-309"},
    {1e-307, chars_format::scientific, 764,
        "9."
        "9999999999999990932662533724846199547048873403204569370722504933164788134100221702366853061102859515757830"
        "1758491822824378438792553200763769833775473829862512856683413461939989729065436937279228852476622948659167"
        "9434355446221493480729436132941672166628217375554144801591156397912760548972014203897705803515339607715061"
        "9905566488977026029171097782672502440171652303162739065260414400859795093549243326204240563556399326294969"
        "1698930975461134804791235994697938405200089317860731205010159117711704697471514344499487123311264707354172"
        "3780995387378502198261451023662795913796604718812599767273565216024053297899062477635215259813914438876185"
        "7527558861992808911690506171197530846785775640581096161907433186688396108094354271255983085398000298482656"
        "9445431232452392578125e-308"},
    {1e-306, chars_format::scientific, 763,
        "1."
        "0000000000000000279023803391476325978469990224051750613215776767695913434815660171857902754611290428295390"
        "2855112999397555396569952545618616744426089938099821880772600111269030190023111167436591184859690670436405"
        "3235908198301844721604945146272364072259074692549029825719823273398887747392739210687026322232580358825111"
        "0234205543842448102753778430086832136807498326022836612478352744084880146129506125620176035215057087515132"
        "2612616922071840157682358884105637168985105575243131100589013256198578475477149271096570431275426554079671"
        "6654247614171924100040800742268229310960254010514282230676348267637082219417179036571049957325656665930634"
        "4285043677760454755517299704176913224907978537594173374670297704548248979442337094143862519235455010857549"
        "495995044708251953125e-306"},
    {1e-305, chars_format::scientific, 760,
        "9."
        "9999999999999999628217900530785377054659627883900722995775030945280642024408233714255781016776892345034950"
        "1406426481668573825190999521406861414798119234028697220781311072490218654586931744476129716298164369509417"
        "1579154906539259553297447374781782441000739045507324002369679044368579627272624666077581243976346526774830"
        "7025658385238493027973334562682769653967428338344198908910697296851733096562843141535755075192125128789628"
        "3612239021983130437614961415360789480610798036545823058988806310179363406158165146574713062236131985212038"
        "1806081273895043986502259049610427190720957335454762962899504686945017155165729595557090423005192733858302"
        "0097669333441417250244332809616705208468049446512230390757498683137398144735633162723253963832803492550738"
        "155841827392578125e-306"},
    {1e-304, chars_format::scientific, 757,
        "9."
        "9999999999999997098601793823603070870627408398607296486668841559937848165409539310797183793308082794699787"
        "9690663671822989712784178773583416591227895116453079951225559040330152058071587800564304010459170501625708"
        "2955213245355909423095844104428295815728732741520944598506836092672341349948810713443435661296780877593807"
        "0772540742689702628321774772134328282681384400836865136212433181654078404777068649802950853625368531700272"
        "9601094862994913526248059474804323713218591863837432701467745308734226327267503095061920061821625140744295"
        "4016965379635686375377660351152934455615691119704315487808322295404373123960880979434363102804093593499868"
        "1895455378110913006301401423894763575978660702968627706001115993261324824985442939750956981015406199730932"
        "712554931640625e-305"},
    {1e-303, chars_format::scientific, 755,
        "9."
        "9999999999999993051216023092111380976175857222137814072098938543389377991011628265263428235757987514163528"
        "4945443176070055132933265577065904873515536528332092319936355788874045503647037490305382881116780313011774"
        "1156906587462549214773278871862717215293522655142737552326287369958360106230708389228802729009475838904169"
        "2767552514611637988879279107256822088623714100825131099895210597337830897919829463030464099118557976357304"
        "3183264208613766468061016369913978485391061987504008129434047706422007001042443812641451261158414189595906"
        "9554379948820714197578302433620946079447265174503599527662430468939342674033123193637999390482334968926374"
        "0771913049582106215992711206739656963995638713298863410390903689459607513385138582995281808507570531219244"
        "0032958984375e-304"},
    {1e-302, chars_format::scientific, 751,
        "9."
        "9999999999999996289124639677304732891737098163313400003754860956628154130529957101690432681798063738592536"
        "0741619572672402796813996134279914247685423398828882424967718390038930747186677738512519784590692463902921"
        "4595551913777237381431331057915180095641690724245303189270726348129545101205190248600509074839319869855879"
        "5171543097074089700433275639158827043869850340834518328948988664790828903405620812448453502724006420631679"
        "2317528732118684114610650853826254667653085888570747787061005788271782462022491238577826301688982950514617"
        "7124448293472691939817788767646536780382005930664172295779143930111367033975329422275090360339741868585169"
        "3670746912405151648239663380463742253582056305034674846879073532500981362665382068399821946513839066028594"
        "970703125e-303"},
    {1e-301, chars_format::scientific, 751,
        "1."
        "0000000000000000665043221274992345902153306917507527498505381267899223777698860937825684690912630765676536"
        "0328938404179991532123233391736474424502906138441861076106807871376656352651352653277535787570721134675459"
        "2959921695798423951473709805328306131275582854537351322749293107827733708512353219858996938149482076890135"
        "2286431296095393517740606454124524290065748630886455746192107848064042252096015313058601959426144144230967"
        "8954717520733442058356948120234553845089156237198431469146727165019106393715864300157422643138680298545449"
        "2134866699635902071498414503652842702337317635037800515375262700586184498579038935391378146388344394749331"
        "4294701527343889703142991033638081518025859259858927144364121703023337768036216122169435038813389837741851"
        "806640625e-301"},
    {1e-300, chars_format::scientific, 749,
        "1."
        "0000000000000000250590918352087596856961468077037052499253423199004660431840514846763028121819501008949623"
        "0627027825414891031146499880413081224609160619018271942662793458427551041478278701507022263926060379361392"
        "4359775094030143866141479125513590882591017341692222921220404918621822029155619541859418525883262040928316"
        "3178720501540199698661694898041067655794243192165254180873224255430058507393834020333099315764646743363847"
        "9065531661724812599598594906293782493759617177861888792970476530542335134710418229637566637950767497147854"
        "2365897951520448920491760252897567092617670818249247201056323377556165380506436538125830502246596311593005"
        "6323650792902539887815381155401398600958797808116743280493635963114041915328344956037653901148587465286254"
        "8828125e-300"},
    {1e-299, chars_format::scientific, 746,
        "9."
        "9999999999999999190290760137637976208079970046606724998518567438890097551538379739129028665449972035680926"
        "8654993624028106303651130713543666646941642034794006359075819280682667925398195400906114450103317751101389"
        "4796578126155197978756945816618186836433649314161201999972943672570926856702325994597557960702860121588611"
        "8925518658960446433985656531743023483770388411882929286181173813228715116320889861526972008354488226701519"
        "1541829745179090325919123351411654126959859303926546520294760229609181275060613732216818338004372560297782"
        "5507229530280863996864368522933466048419533648184045496011719191321500860483546203133923869331978450679449"
        "9468102053494600355532932528120522673051486467229961893972473711866052331620480231322289910167455673217773"
        "4375e-300"},
    {1e-298, chars_format::scientific, 743,
        "9."
        "9999999999999991232806544017866794540396664309573605012880972516114481311058134790726022538861880706524197"
        "8378310511738176684897847296134517208981728061861094996950742552059845950875175526912254796125831249071305"
        "7673763372204220340378116764175654061689991467534736690618290439817422613053039377005652445191435431121688"
        "8057471403500725107670554654940656105757483988435859232058608834656227218039009041197321250053738130052815"
        "3669461252213404717758741643748844181432709364664927137710748047655173102156049178235583038396446773463958"
        "9943029566464163497536606908432174341802314765843821861088084189145133793489580175635409101810415254077994"
        "6423927952220683901242822865976210665363906593780031707659147505607571959629353841592092067003250122070312"
        "5e-299"},
    {1e-297, chars_format::scientific, 742,
        "1."
        "0000000000000000396478128980950068520868995348882659698990112439255546729582652670817083234140282683317496"
        "4282100349140206407490310076398915630971759041855375317635086531785636111011200732530243024248980965231943"
        "9707026697852578456178424324808370650127984402213708118558573561222302940289189796515270127000971493586876"
        "5744634701223627922977471765782444391057813106595117131865471280037220785529001835372476246333493828469074"
        "1426525084095850169081535237600934009427614926748351814984516753878158617880335246460555951776912803239807"
        "6684574950857088429646102549163424107238986497758817967696590019262732110067992581963303272984491636864032"
        "3129460651425895022810699832540710987766403439129992000576046943562114055481515606516040861606597900390625"
        "e-297"},
    {1e-296, chars_format::scientific, 739,
        "1."
        "0000000000000000056958802426506498103047840970769246579602908389217120436655495553018554972739190786606809"
        "3230295203015836077090169983922791921618802712343571099517749924697729040098218551239838345679274874478660"
        "3989786601684003410274260951904155918405588334090978932026108356624820092560153567498015491672484040126954"
        "5227598018324013146388027419038876716262595851194708809556241840951461301868974920371744480645995157678729"
        "4477304028395980916466692284740654118418456529339856054660932234114787602503073825490689912326974636334897"
        "8633835752400909208341451386944702327756651825445635092606514925836540448542916698123366642903571607142370"
        "2199575889771541254094321820289220342105066697862794979293345025428418892943227547220885753631591796875e-"
        "296"},
    {1e-295, chars_format::scientific, 737,
        "1."
        "0000000000000000600189724913616210771561687975750707570622434869278602505338946941496200190980937821343908"
        "6913183436814828605730394131884589856583532839562457848505488496038380353558990041304485831390804619683914"
        "1137370755553723483720922348550899489161422043087345630478052683980792648926611533925622908198063965662829"
        "8054856710963396788931138373828584995934943459835362125251008943488676475725017984372915305745993030943280"
        "9596057717515771720650441009317101944033109965193449271178667465736181227106692099042475575446875703382753"
        "5515018469930795962428893246494657174928387301146727692750635075318447106983038112267265251033043654697029"
        "56873915084185072840405266398916053751632054838903102133456680944423311530044884420931339263916015625e-"
        "295"},
    {1e-294, chars_format::scientific, 735,
        "1."
        "0000000000000000165604986923928440636750610371765538777806813685229416850392185830714084016387540193554229"
        "1966872849775634582818214813515151508611748737787348449315297638965859302790372849252767842821580823519711"
        "1419303432457947424963593231233504632556755075890252271716497222096014603833445160783536974977600025234129"
        "5793049756851889874896649609996818372197065372922839472695195261458904336640183533171978645665994732331639"
        "7501054766219939077303442029655943683541387216510574697964479280439066327423797480201047044950954849744469"
        "0010072295906886559158939758854693297190998920585853612635338955732921780230940980952146364529466016653302"
        "089713901350093446008356278420969734871669445506829802610380963923120134495547972619533538818359375e-294"},
    {1e-293, chars_format::scientific, 729,
        "1."
        "0000000000000000513272777315678656744599472454953673812059310632468765374349594719339776956062258295785972"
        "7923921319406989801147958268210702186989176019207435968667450324623876143405266602894142233676959860451073"
        "5193757290934568271969456525087420517840488649647926958725741591603837039907978259297205721553971177577089"
        "7602495320141095406124240621062231671187367842452857594739846207082722047908051094132727973729993371220952"
        "7177057127256605191981041213384870291934765415456874356535829828676758247170113175274189869347691532655096"
        "6414029235126014081774902548966664399380909625034552876727575851401342041632618686004241473732328127088284"
        "072934100943499271924913386875522376987390327812590777589729640340010519139468669891357421875e-293"},
    {1e-292, chars_format::scientific, 729,
        "1."
        "0000000000000000513272777315678656744599472454953673812059310632468765374349594719339776956062258295785972"
        "7923921319406989801147958268210702186989176019207435968667450324623876143405266602894142233676959860451073"
        "5193757290934568271969456525087420517840488649647926958725741591603837039907978259297205721553971177577089"
        "7602495320141095406124240621062231671187367842452857594739846207082722047908051094132727973729993371220952"
        "7177057127256605191981041213384870291934765415456874356535829828676758247170113175274189869347691532655096"
        "6414029235126014081774902548966664399380909625034552876727575851401342041632618686004241473732328127088284"
        "072934100943499271924913386875522376987390327812590777589729640340010519139468669891357421875e-292"},
    {1e-291, chars_format::scientific, 727,
        "9."
        "9999999999999996232432339127981035085063855219920481243729184475360331530186279644580030304949799540727091"
        "8738772371507204422238150241900924503429621787720119191259394493393530314311385935722237930871895259067858"
        "3311554132344189036344464928213958515141307008282797599820760056638116035571735271022137303184610275791116"
        "9703146781207292461816076327347736257721935204560112023055397862857487070623101380732096938861568556643115"
        "2064910830027399384063873030388181744477172261543472305931724251882669326195449958869442388920456244038898"
        "8198994707250476238780378062800183777747382216458827606514493984901861724443237610708779941730011243747301"
        "9589038998438035757852718923186761317114486910984268164259702871277113445103168487548828125e-292"},
    {1e-290, chars_format::scientific, 725,
        "1."
        "0000000000000000691278685996254767391818089841545998949596589069455311818615788070316131741175713964128625"
        "5133930135858243672932786917014824134318418787294520778575752499680780765800092204758525921794913927359931"
        "0566277666474598145636458531540625451105760239411856398474474708791842127178139205736204119801073207576685"
        "3728931448545168638112767218727723280270402706852226873226707491242116716077199285344631629698760674332280"
        "9571170336107378242695971995454080715432175053317379781724361309374456510080226811151638995438820714305337"
        "9932855188006207373354275497503993603702143905712286899942801141983573215470277670990914169644193527630994"
        "84834284313532305479419062640425332975063941955314039677915616266545839607715606689453125e-290"},
    {1e-289, chars_format::scientific, 723,
        "1."
        "0000000000000000121659778218411213320718514204450558509477298071098363196963969347191796428812655825432136"
        "8061901923214231283221335240841633902864841929415849386869185539498685974136650278792498119817460913251586"
        "9374212464746502549902052110890369664656891152167282191278528733790225847913624177131409245410346711577979"
        "4124335837652134295749482106198150131204691140774245182068751381932053777935925073466539930598705304376030"
        "5910008067784904480408193492832607360240464212163762421121060571141822068767863176343801791947207333024565"
        "6672612138789588840300282062184540149874194207543538025654080212120433459189768919033561542726224245894320"
        "367034868121486949612503459912314280908242325983381615372991291224025189876556396484375e-289"},
    {1e-288, chars_format::scientific, 721,
        "1."
        "0000000000000000577354904440686056577598174714126910861572730869783922094285424325691264678703102336389327"
        "7719524493329441194990496581780186088027703415718786500234439107644361807467403819565320361399423324538262"
        "2327864626128979026489577247410574293815986421962941557035285513791518871325236200015245144922927908376944"
        "1808012326366561769640110196221808650457260393636630534995116269380104128448944442969013289878749600341030"
        "8838937882442883490238416294929786044393832885086656309603701161727929621817754084190071554740498038049183"
        "5280806578162883666743476810440102912936553966078537125085056956010945264214175920599443644260599671283659"
        "9520812481325558337578531931058655199821600008391886404979231883771717548370361328125e-288"},
    {1e-287, chars_format::scientific, 719,
        "1."
        "0000000000000000212798803462866181972094446306385828979896384630835474976428260342891690078790745127623574"
        "9993426437237273265575167509029344339897414226676436809542236253127821140802800986947062568133853395508921"
        "9964942897022997845219557138194410590488710206126414064429880089790484452595946581708176425312862950937772"
        "3661071135395019790527607724202881835055204991346722252654024359421663848038528947367034602454714163569030"
        "6495794030716500282374238053252043097071137946748341198817588689259043579377841357913055744505865474029489"
        "2394251026664247805588921011835652702486666159250537845540275560898535820194650319346737963033099330972188"
        "28404414412370072644157340655102452872302586095454302039797767065465450286865234375e-287"},
    {1e-286, chars_format::scientific, 717,
        "1."
        "0000000000000000504443684245122081656497429032578694485237461621994232670713991529131349758720630894636177"
        "2174304882111007609107430767230017738401645577910316562095998536741053674134483253041668802746309338732394"
        "1855280280307782790235573225567341553150531178795636058514204428991311987579378276353831401000914916889109"
        "8178624088172253373817609701818023287376849313178648878526897887388416072366861343848617552393942512986630"
        "8370309112097606848665580646594237454929293897418993287446478667234152413329771538934668392693571525245244"
        "6703495467863156494512565650719212870846576404712937269176100676988463375410270800348902508015099603221365"
        "618473827330784812294597235794897321730333172862259516477934084832668304443359375e-286"},
    {1e-285, chars_format::scientific, 714,
        "1."
        "0000000000000000737759588870926801404019815213532986889510323214921238826142576478123077502664539508246258"
        "9919007638009995083933241373790556457205030658897420364139008363631639700799829065917353790436274093311171"
        "9367550186935610746248386095465686323279987956931013653781663900351974015566123632070355381551356489650179"
        "7792666450394040240449611283910136449234164770644190179225196709761817851829527261033883912345325192520710"
        "9869921177202492101698654721267992941215818657955514958349590649614239480491315683751958511243736366217849"
        "0150891020822283445651481361826061005534504601082856808084760769860405419582767185150634144000699821020707"
        "486017573896452080977016299189995556136179022388432713341899216175079345703125e-285"},
    {1e-284, chars_format::scientific, 712,
        "1."
        "0000000000000000364454141469639249807983997324006119042673744666238028977456840559736313112354285726470128"
        "1527483228571615124211944403293694507119614529318054280870192640606702058135275765316257810132330485985127"
        "5347918336331086016627885503628334691072857111914409501353728746174914770787331062923917012670649973232467"
        "8410198670839181253838408752562755390262460038699324098107918593964375004689261793537457736423112905266182"
        "7470541873034675696845736201789984163157379041097080284904611477806100173032845052044294321563472620661682"
        "0635058136087680323829216224055103990033819486890985545830904621265298148906772969467863526423739472541760"
        "4979475793913844510851457977578383810868256631465555983595550060272216796875e-284"},
    {1e-283, chars_format::scientific, 709,
        "9."
        "9999999999999994685210677065491259774980343891416362102659561493983253406110743556080785756096766502074141"
        "3878246459195032208808316741012258269146158183275756810250349053468517157403478438736274574028658284026209"
        "7008018948802266655386840832186907737757430838745595355266843761499725833182288969724649273569543338299591"
        "8922759999075196859715226773290408487303686820316455034264511160505121715526246715460349142098034158553149"
        "7120315430319163251987317550427630958171239606368370686366614654665658351325155359459002663308396313268813"
        "7970592127246328314557798934048071528321752128304945164216498646370406992843868518292140442390346361922877"
        "2657959257922213934465659432066116096837760096605052240192890167236328125e-284"},
    {1e-282, chars_format::scientific, 704,
        "1."
        "0000000000000000185267526717021225041886804737033222476192186962870088250087687318910666205005363911217585"
        "3499551512041192743545721857455200771078614787119958560901161093554731989656290181027731739586437554468626"
        "2218495048040914146410045219546405907613434306306439508188319872169926333293510629733626595607910845351966"
        "1106614136652848940265031537516012481956041767365788379171625098381602438061934369139173171980451007384009"
        "1918839807034123822516335312440539949689328025005031641651021475338193305452779148824615510516946022794721"
        "9267458351415070825354528957925044622593490632078887339949053669939646658982295745940133629986798505271865"
        "94367398202895198873704795707040293706313605071045458316802978515625e-282"},
    {1e-281, chars_format::scientific, 704,
        "1."
        "0000000000000000185267526717021225041886804737033222476192186962870088250087687318910666205005363911217585"
        "3499551512041192743545721857455200771078614787119958560901161093554731989656290181027731739586437554468626"
        "2218495048040914146410045219546405907613434306306439508188319872169926333293510629733626595607910845351966"
        "1106614136652848940265031537516012481956041767365788379171625098381602438061934369139173171980451007384009"
        "1918839807034123822516335312440539949689328025005031641651021475338193305452779148824615510516946022794721"
        "9267458351415070825354528957925044622593490632078887339949053669939646658982295745940133629986798505271865"
        "94367398202895198873704795707040293706313605071045458316802978515625e-281"},
    {1e-280, chars_format::scientific, 700,
        "9."
        "9999999999999995736438816947517005069417207068324021959351366687075172340009775902257914279210441151555725"
        "8308779196173510175383489009931421520586690004171251700735334129506741559146860533228960854564563482256350"
        "7367302240104608293998170498800889934052711298312352648503909155662324666479368844441019720337612888531868"
        "7103789266301679766012373101564633549368007345473197918690766334590720773073234271930285253494983959461901"
        "2356967550855734248053136101277703677183805567441722726787676002477378641128208658347785021448019020754979"
        "9327177530658970705609297562011086483971681409869254638723357560814229067067468229654822501487066703239591"
        "9842010303184918392220732752395662146227550692856311798095703125e-281"},
    {1e-279, chars_format::scientific, 700,
        "1."
        "0000000000000000552241713730382939762853855155153714644346417139367630859739713156121591071255955788854793"
        "0100755667495497779150145631332435942490582259141658595397737701917166689901252657650633132064426278214420"
        "9107553942459186136616182121346196056138332212191562054191077246132142653280854876907341369752400579251233"
        "6544355262666457518463308073931741958167586387056869531553154177335120654514700934306859959959022574246700"
        "6328725638203254061142948333828201698871896505961547263034373800392466570256754118618517715540232495226256"
        "2868302710424575078230688478959406207111284126734064465595084418254580910347625099724924457889653606240609"
        "9908263094272136716259523347982707264236523769795894622802734375e-279"},
    {1e-278, chars_format::scientific, 697,
        "9."
        "9999999999999993779243152876254526557592938171681397062528805745754945088532304770466314992540617804157284"
        "9769023700417216652159895549252833939722863486722184850086925551573756491173727324573486761348623622278779"
        "0625654803207157679565440355868675808586589133591699069822536494530504293213532859514540924900334307735775"
        "1435836594229100682288231574014076342906436040454098439322611246838623618658479257702622384275935602860880"
        "2170909784620372975377866653876841014876773669006972746076463602187921228840342152780306594657157834453463"
        "3456007615941614690269780116494491366543449438374976635277860236467913059785711676135938086005172831406290"
        "3993886175277628638145832606909380047000013291835784912109375e-279"},
    {1e-277, chars_format::scientific, 695,
        "9."
        "9999999999999996910756215390274492176511768406309596897444903251867308690896258581332873851212335159994790"
        "3432632493627286289317645086338574069104985914640691811124379276266532599930740458422245310494127398242893"
        "7412290702243078662657808584560218409332384597144744795712732752341416890438870435396906997599980037009524"
        "8504560869545227216246858018094967873244950128484657606311659387241979065722087280466882975026412973422513"
        "8468602210596951011658297769718221274568024706502572715214403442651053088500928561688272077522535732535889"
        "8849879479489384314813008029321043554428620592765821440790655955422018671436522161766153150776203026339572"
        "93508847799292922446656728396874314057640731334686279296875e-278"},
    {1e-276, chars_format::scientific, 681,
        "1."
        "0000000000000000943680846544635435465218708934482239623710929327631676310035207382479910928589920458334481"
        "1808706766646756483794864323468153458663347562631471965527419417503763703495879299381727950707614250209935"
        "2455883429838676259502728149932638881231556645135692769927351778358506727934022073892637128839856295410452"
        "3677945797080973335208136379441853399459900648060689427426785194885540085397651937152392533802832245566904"
        "8365937191450326315678002223308374231333302885648497259176616280450358052714327419732013400898404732486559"
        "6042536693368046281298591968062725230596930521032920066284183883123844111803976410428701340986032380607270"
        "307788791985359466707450337707996368408203125e-276"},
    {1e-275, chars_format::scientific, 690,
        "9."
        "9999999999999993403461585374572130683322678543526013082338874045021461456248630313162327929500011721456784"
        "3329390645232008295700965604802545124197008795371964014762431104610623358122885748511635735451163169163085"
        "3011258495322847161594356168425690696497093677965333582715712943593194781546492350408656996176376820222925"
        "1787589681191165498213196400724369359265814349890431339283925469990220965010846294970911113385878318393484"
        "1815186693503183611024214919975875383713823544507500749779910821332345405681071783711350736713312486683572"
        "1608742992315882335324592766955305103997228899848075258616324750193420386387614417860312278232649208014296"
        "495104634271942900536345177897601388394832611083984375e-276"},
    {1e-274, chars_format::scientific, 688,
        "9."
        "9999999999999996610130961388928575477095560703785289713292957891280521785069319015489684200779850293834389"
        "8280926049479119604150501130778343016684302161560515142864783718696026093490067197572764489776159035750338"
        "7320773655935630248280941234605830319660788232643652406027273911591569281105238028112199854620814046999244"
        "8785963339114879068986829879463202286332452776033723926280710765763256942803980910281513958314367145848597"
        "0184023737703199520175376382597448769637664606902995118177161217966592429973512266433107391167459454319976"
        "9372067780588798430856858149689694544391644161944300339461427566402424532718044355145652504558184127625977"
        "8116612913882732538439768177340738475322723388671875e-275"},
    {1e-273, chars_format::scientific, 681,
        "1."
        "0000000000000000943680846544635435465218708934482239623710929327631676310035207382479910928589920458334481"
        "1808706766646756483794864323468153458663347562631471965527419417503763703495879299381727950707614250209935"
        "2455883429838676259502728149932638881231556645135692769927351778358506727934022073892637128839856295410452"
        "3677945797080973335208136379441853399459900648060689427426785194885540085397651937152392533802832245566904"
        "8365937191450326315678002223308374231333302885648497259176616280450358052714327419732013400898404732486559"
        "6042536693368046281298591968062725230596930521032920066284183883123844111803976410428701340986032380607270"
        "307788791985359466707450337707996368408203125e-273"},
    {1e-272, chars_format::scientific, 683,
        "9."
        "9999999999999993018661260252849357308069932684294899886624383983470374216790147668883045176946431092771471"
        "6735206396722354938687021341685449377098533591429337879390148790920375029878823974624300284932163665172614"
        "8894116676049313191191965960484073941717450331403935323918325627433389841599442869084231853163044353009766"
        "8147784842240319869720360383275709408017817738753236228844311234497456647675670141133638771994459659098870"
        "6410926248199181701926075544461286577402962617020041425572240773736235762765978925784739938178814850567203"
        "5877144017723132403860720921027178371149899068396528248914912412248339888827962825386071451073585017660894"
        "73711783541798325813942938111722469329833984375e-273"},
    {1e-271, chars_format::scientific, 681,
        "9."
        "9999999999999996302290701291550356776893364016400399156721365842039651993502532900066257998736985790886139"
        "7005578650671396918539345720284666419005521998406414234566957867743827430894817778462896129360959432557962"
        "4027060200516803071959029068252536915837073555394533798989364058663725329147598443052659740210148073228718"
        "1874119467954202566192561065504274325334055487123967837929019377369045488935839987211696085201232218412906"
        "1860615381459997992896864882185777724588975864913027658811025179889704715641437980091818752339861345426882"
        "0786788600914598485685760672947193158113780296783062731700297696046360134670323081166259842830932775343256"
        "405271852305105539926444180309772491455078125e-272"},
    {1e-270, chars_format::scientific, 678,
        "1."
        "0000000000000000418300135978443275550206959921345359740495412230260591865761225745490596877103431706636134"
        "2965447206014909767018492422892278731958229417515139748699129965212011319333320290767552615599006927428279"
        "6434612465923877878579998052689684805372416929297197013915985629361653049926317182057688666912319700175420"
        "1481732256966752103772584270285283012689302608321372369973231892026085870796024761779903363689748636076659"
        "1493986930128595709122675929272455647783540765985619461858410775465803020254253971042880790632637293309011"
        "0456993560057411708206585607755522864682709524491074549038522237716160872469198769503871198304856739378092"
        "440884149283419901621527969837188720703125e-270"},
    {1e-269, chars_format::scientific, 674,
        "9."
        "9999999999999995776909990725358196861881615003263519273505848744668567549228551263076943947250497039187792"
        "8162319090039550201762973819708791692300403853290082017738668415452075046732258769848720794252352109776306"
        "8005789236602004691036298971009582839977933839556038042977997909666871651139893551217711278282611477993685"
        "9677905927839981334757008956347703938563457447384650780475466074509591274334212811839206915088148608922660"
        "4988665120138267386341538588149859141039213745250149861492819674905149683181364531402686142074093906249333"
        "5201245467603963912593754312639990792199559300241217214454636050638676895335545440241429700149757134114078"
        "53836720960316597484052181243896484375e-270"},
    {1e-268, chars_format::scientific, 674,
        "9."
        "9999999999999995776909990725358196861881615003263519273505848744668567549228551263076943947250497039187792"
        "8162319090039550201762973819708791692300403853290082017738668415452075046732258769848720794252352109776306"
        "8005789236602004691036298971009582839977933839556038042977997909666871651139893551217711278282611477993685"
        "9677905927839981334757008956347703938563457447384650780475466074509591274334212811839206915088148608922660"
        "4988665120138267386341538588149859141039213745250149861492819674905149683181364531402686142074093906249333"
        "5201245467603963912593754312639990792199559300241217214454636050638676895335545440241429700149757134114078"
        "53836720960316597484052181243896484375e-269"},
    {1e-267, chars_format::scientific, 667,
        "9."
        "9999999999999998466859228824262055626741769950524344275569296283208519903911337244462231890861319447883328"
        "8639808040474605391657997950657270293030608756285702967899510411185847253644560893953298510008421602418383"
        "4834696571845772401360677068893507708376729184649136313756192592530762482539342597412647403351598845597050"
        "9322519253224794039707035755229344318828919410849954114637658985149996853094543949746351466067136689512718"
        "4173050458105528091904809213613762288813995797924084183762031860426071449376940588691045106634823194838382"
        "1399226310154412926824826877412866905680370802535466262752423675126015080729606961776560030677376417207469"
        "2169189802370965480804443359375e-268"},
    {1e-266, chars_format::scientific, 667,
        "9."
        "9999999999999998466859228824262055626741769950524344275569296283208519903911337244462231890861319447883328"
        "8639808040474605391657997950657270293030608756285702967899510411185847253644560893953298510008421602418383"
        "4834696571845772401360677068893507708376729184649136313756192592530762482539342597412647403351598845597050"
        "9322519253224794039707035755229344318828919410849954114637658985149996853094543949746351466067136689512718"
        "4173050458105528091904809213613762288813995797924084183762031860426071449376940588691045106634823194838382"
        "1399226310154412926824826877412866905680370802535466262752423675126015080729606961776560030677376417207469"
        "2169189802370965480804443359375e-267"},
    {1e-265, chars_format::scientific, 667,
        "9."
        "9999999999999998466859228824262055626741769950524344275569296283208519903911337244462231890861319447883328"
        "8639808040474605391657997950657270293030608756285702967899510411185847253644560893953298510008421602418383"
        "4834696571845772401360677068893507708376729184649136313756192592530762482539342597412647403351598845597050"
        "9322519253224794039707035755229344318828919410849954114637658985149996853094543949746351466067136689512718"
        "4173050458105528091904809213613762288813995797924084183762031860426071449376940588691045106634823194838382"
        "1399226310154412926824826877412866905680370802535466262752423675126015080729606961776560030677376417207469"
        "2169189802370965480804443359375e-266"},
    {1e-264, chars_format::scientific, 661,
        "1."
        "0000000000000000122136724863753960700195856861651942907768226656267343111510651008940076674511880159438755"
        "7776875672572010190611050266074851238017833857695321882086421261481722999352275826903638609094263676288387"
        "0006749768313539053673284024112664677361709561802446894303306394778338669389237842071626199542224191002289"
        "6655860329841884224957586319728414406822075246143842472881974452564577216574512303496326748626962048403693"
        "7725786104418400305440159833408879911213537261986219292976570513839949533796121047135432468634500998635356"
        "7926595869292607271739744518374029204588472178088477728820935820260104938257312595982853348913765856309510"
        "1271755993366241455078125e-264"},
    {1e-263, chars_format::scientific, 661,
        "1."
        "0000000000000000122136724863753960700195856861651942907768226656267343111510651008940076674511880159438755"
        "7776875672572010190611050266074851238017833857695321882086421261481722999352275826903638609094263676288387"
        "0006749768313539053673284024112664677361709561802446894303306394778338669389237842071626199542224191002289"
        "6655860329841884224957586319728414406822075246143842472881974452564577216574512303496326748626962048403693"
        "7725786104418400305440159833408879911213537261986219292976570513839949533796121047135432468634500998635356"
        "7926595869292607271739744518374029204588472178088477728820935820260104938257312595982853348913765856309510"
        "1271755993366241455078125e-263"},
    {1e-262, chars_format::scientific, 661,
        "1."
        "0000000000000000122136724863753960700195856861651942907768226656267343111510651008940076674511880159438755"
        "7776875672572010190611050266074851238017833857695321882086421261481722999352275826903638609094263676288387"
        "0006749768313539053673284024112664677361709561802446894303306394778338669389237842071626199542224191002289"
        "6655860329841884224957586319728414406822075246143842472881974452564577216574512303496326748626962048403693"
        "7725786104418400305440159833408879911213537261986219292976570513839949533796121047135432468634500998635356"
        "7926595869292607271739744518374029204588472178088477728820935820260104938257312595982853348913765856309510"
        "1271755993366241455078125e-262"},
    {1e-261, chars_format::scientific, 658,
        "9."
        "9999999999999998400751036348743394393736566782540462240318584996501362034842653096183707054359139876367227"
        "3700713272028713475311137837615080482939063240589682587428357558298694067887484156951304408066000438567211"
        "8069109345174821566111745152759912370810960390248128330653547680004699501466869737653360653141903412050830"
        "6348853236140136882670183896620029124843515417635830819897288932178098245590930051701145481582277078444137"
        "1539015004039644692804886274722361405054282754197569573857943701754709276050918111507126396721778711842017"
        "6810424732967893091851084038061008702315466379055082798141457246466614257485362505823312667674329645706166"
        "0476028919219970703125e-262"},
    {1e-260, chars_format::scientific, 655,
        "9."
        "9999999999999996144258066517706424307158965315357288770427639743563706770631567501610059301751410501950963"
        "0446278509075602730671645979108334965147642971498853600679673513083865327379264867283239061764691379113885"
        "2470398674806366389614869082066524848566052208027055840749934665781749747526462791203039579317632613673177"
        "8181053186317172589145640456088737170141725782593755692759324457403959109467575665091447877832402353969896"
        "6963938171924158003527516627229211239389410861665870889131734552438880426522684223629367765023193692232777"
        "4845997565001349391413995121517582027460062057591327206087136481559066157415151742619136010503666511795017"
        "8682804107666015625e-261"},
    {1e-259, chars_format::scientific, 650,
        "1."
        "0000000000000000697542432170668388072273145235783652142590417695766445203884477835556356851426851149914903"
        "1806756537125053430494120689994071345054646026313483273707335693011504328181871745768995272401097486448985"
        "2734420989257495123679987422139478495534161148268820379228727713405190856644041613416458073367413244588591"
        "1338649342546740119806344897063893855271031603079571630302155393631982696285967672081799637583180103144625"
        "0892430696607849411205889093519633203458079594581802457581753846915485890425820688544260919717640178635713"
        "0427524797124075915351202192092603006676600280061735404794787615311529703775216340599918396492284955456852"
        "91290283203125e-259"},
    {1e-258, chars_format::scientific, 651,
        "9."
        "9999999999999995422180316171774593879454132845858673260062537262623657086084020111346492020916937102137758"
        "4604859384930607292387008584386176399454388485389788324920094618615120130416634694589458150948272480088820"
        "7478811260288460733135868739444640841447681589716312643980778501230405826265532568338936835693865958192328"
        "9167357170373824015217786555118723744637153099380291652075175825476234585908102261376344644632442442138139"
        "7499913585647202262958758340031403186376651856055727310019347624657815194673649379508485002879646485957820"
        "6217380871252055407274126668223685491506332674722925416629753836788650765392684298393799480209054308943450"
        "450897216796875e-259"},
    {1e-257, chars_format::scientific, 646,
        "9."
        "9999999999999997732829117278756451248109596748254242893230865201631816076636171760189907319587251981540013"
        "1297400582194592694897848247497083809672802840938797207350747080915104760697051247209557065560812956969027"
        "1451890986745758833868669835834669664226467568310690873642078227794706374300509281504065615289919255731045"
        "4011184421392539451786919038222766706251785685663376582264451447644953061298417153264674990872314159999761"
        "9784792261733460632778784859064388956017480674008186763178985793557223936590560880695309841738997546037682"
        "5828954291249796156521705718764154406558266699901811142893378300053980019864580119914876377151813358068466"
        "1865234375e-258"},
    {1e-256, chars_format::scientific, 646,
        "9."
        "9999999999999997732829117278756451248109596748254242893230865201631816076636171760189907319587251981540013"
        "1297400582194592694897848247497083809672802840938797207350747080915104760697051247209557065560812956969027"
        "1451890986745758833868669835834669664226467568310690873642078227794706374300509281504065615289919255731045"
        "4011184421392539451786919038222766706251785685663376582264451447644953061298417153264674990872314159999761"
        "9784792261733460632778784859064388956017480674008186763178985793557223936590560880695309841738997546037682"
        "5828954291249796156521705718764154406558266699901811142893378300053980019864580119914876377151813358068466"
        "1865234375e-257"},
    {1e-255, chars_format::scientific, 643,
        "1."
        "0000000000000000069045958269569322867998859054332057202368632496356225958454292587070947890188525502717489"
        "9106385331469249401011172301627904529475237321604152857686198223265908508745598443456328367626486476737569"
        "1333743303661110040280665523921390655738331362091149500760854187779701107578527947435543045317286747658060"
        "2501128330269649521059540861659594169711851539610572529290672424402091270979802021488173783405934995886263"
        "8430943696712387134614841880342661074115774156098733486322332264974846712624420760221444563547896690293990"
        "5893176826884690431555860690345595461782474225213078487251081761303360146558860677146185480523854494094848"
        "6328125e-255"},
    {1e-254, chars_format::scientific, 639,
        "9."
        "9999999999999991226042093361495540897975810399108318806228853725384840359241312717046849838531645281143263"
        "9811204570699209801427323756176768542497748015712788194426029747078348041827398235031358522011898974074365"
        "9303698477042007382205101948400348499281406252588921778915858197789636031034014857231062971947433169862019"
        "7810966882523836782408241965801781726344980322690209418851451295617841834599290417707136735860835402501433"
        "7830573909874557063365590181467501028708906722654060943081444709936488919352538093353211095511064960852791"
        "3002763540536158206640523112442193941772020484998068937735011811498812839271721486511523835361003875732421"
        "875e-255"},
    {1e-253, chars_format::scientific, 637,
        "1."
        "0000000000000000636911007629621184134919625862984792395416080770646871111972389376290705633989742087479388"
        "0181544256108846453532236257234041134610514833623877280632355372400752731483313615428243876881664424335648"
        "6575767377235255621516758721370204139224445804190503894482415208580143610263603824463005094190812806061175"
        "2133147315480009026750770860707243767958263644015503481733988801306275523491725809318649849297845869267936"
        "1219675480147345991581811597660207656862704246398729921530844941363565405037920930753118635945970806819217"
        "4648917110583335198090945717806421102345637531241041443337630109395447464137873794243205338716506958007812"
        "5e-253"},
    {1e-252, chars_format::scientific, 637,
        "9."
        "9999999999999994254655689948438800988219900045256239835815244521601614511337828926218891138804800399873387"
        "2212052168777060748206331519409497103219228079817985116805534542464183896428545818881574571372848027930790"
        "0594493536104117148797599001460687077874016610452145212097516975391996045354419534710860565939572148011966"
        "2515068136979087479428135294055912916992511546183174498549138639106824514662883952803009087284360060537019"
        "2703810088194337633856095340494416136692533870920708597526845650676321945557872336188806148300793582320667"
        "9700045053595596961494309925566597358108891450480538036863269667989945199693124777695629745721817016601562"
        "5e-253"},
    {1e-251, chars_format::scientific, 635,
        "1."
        "0000000000000000152332832175710262520480571519601125030682258243252187247636946782823179025946037268482568"
        "2997408640416390302047595015116804564895078023367045773051634605139018994747130002012209308983912575718620"
        "7969240167785318058861959192880549966649628146932388145173349804163766007972339076066237479152070569557183"
        "7780491114767168915227587928186582777454658648256629068982358826348038294681550843703310273070081923982242"
        "4439957691616181100303330772215901239585323902676066296819580790845192120845067451899423427499614227384357"
        "197735206849382499731433982770651655573173817676384638747710885235686628647044926765374839305877685546875e"
        "-251"},
    {1e-250, chars_format::scientific, 631,
        "1."
        "0000000000000000539995372538838999812031814994308058922469316265167934339105300857597200312381001123680024"
        "0744717132970355223235308008810593820667427471572510979116211218948405984136076892745036963302114054612243"
        "0854461935345268108985798815672273304709482272738880744620602127696868089805350874783651571183064358760376"
        "9262616075337441004446134274203111569857542644863728599183662806314628077729690816195581934052293080210797"
        "3863731922441113013326115432571346373407228177654197196588592111259890748199350234982379594256699490932245"
        "41146041021654331579356245397864401930228576603456024321655258579877312286043888889253139495849609375e-"
        "250"},
    {1e-249, chars_format::scientific, 631,
        "1."
        "0000000000000000539995372538838999812031814994308058922469316265167934339105300857597200312381001123680024"
        "0744717132970355223235308008810593820667427471572510979116211218948405984136076892745036963302114054612243"
        "0854461935345268108985798815672273304709482272738880744620602127696868089805350874783651571183064358760376"
        "9262616075337441004446134274203111569857542644863728599183662806314628077729690816195581934052293080210797"
        "3863731922441113013326115432571346373407228177654197196588592111259890748199350234982379594256699490932245"
        "41146041021654331579356245397864401930228576603456024321655258579877312286043888889253139495849609375e-"
        "249"},
    {1e-248, chars_format::scientific, 627,
        "9."
        "9999999999999997956832950416318242122534275228707458502381648630896999234860610340310794424258705217009089"
        "8698848272667425745548990609185184495845165310180177834722241204343829645092988625380078670111672151364882"
        "9148361416301640127480267399121644956345623511904149536818776665133120926859682212462165144835562834902460"
        "8169361510425185931465252898513762884440053713780975011971591647787756942772620690104203449664476602519718"
        "9700853992572437403223688846888917164691719696961858690320903760636693836791272914631037540830957849203000"
        "4110801975159454895427578925929868094239082518686308263637652071764705397072248160839080810546875e-249"},
    {1e-247, chars_format::scientific, 625,
        "1."
        "0000000000000000192649736373475651198801900840970646155428112277531424945149655606599677239735273509423103"
        "7003128723642002653851117166460958647495402365980414154482350572975195241643580478648423385033005529523557"
        "5149303231611552864074838513650889193807852976016263375515864045811208624482972303132848544723293923634315"
        "8654632110666477212506316748172301771864558583903767420123294440264563632118557400842506525812231884230012"
        "1580030211621974019257700376892867533502801947273791910395557968168320778089912861340050868842351094793337"
        "57196262799956722460189534377628286140100146030563490161247042209424762404523789882659912109375e-247"},
    {1e-246, chars_format::scientific, 623,
        "9."
        "9999999999999995575034302425255280203243435320108056671241964144246649104879042904899207640402287290675921"
        "5899384894415865269771681975930543308379850300405799608661482489098955982287298928717585561980642265042467"
        "5741558876413307019519396756689296767305879762949059005814858389345741736077657721142372963397136994038042"
        "1143185752681434215306504148588209983916734438626955498414779994873029315724848699111686364589771258651477"
        "4041185118384055729611699893665062262489939831496222442140098208008785470326559495369354852275425989964775"
        "225952548028109435657040565491081726672244441155999912507201798916867119260132312774658203125e-247"},
    {1e-245, chars_format::scientific, 617,
        "9."
        "9999999999999993034449077901454787489333206084268694718026300691819608966232037640460181737622108169253875"
        "4246623957614200762275886100458926041750180956646462834196673192837757408627896585610926246640877052965224"
        "5440969500532418371027801404761458698996819764063629106077345561839203932576831597067927969862816097115995"
        "4981931611088099051403838815334286890025193878462668017287514231763986513540558575386334807176752225192019"
        "7337538319249781944425578343559617033474707974999543777413905618539016546097531848156893317816192006777335"
        "028483055241084311512275416582382971737136376395860271060200830106623470783233642578125e-246"},
    {1e-244, chars_format::scientific, 617,
        "9."
        "9999999999999993034449077901454787489333206084268694718026300691819608966232037640460181737622108169253875"
        "4246623957614200762275886100458926041750180956646462834196673192837757408627896585610926246640877052965224"
        "5440969500532418371027801404761458698996819764063629106077345561839203932576831597067927969862816097115995"
        "4981931611088099051403838815334286890025193878462668017287514231763986513540558575386334807176752225192019"
        "7337538319249781944425578343559617033474707974999543777413905618539016546097531848156893317816192006777335"
        "028483055241084311512275416582382971737136376395860271060200830106623470783233642578125e-245"},
    {1e-243, chars_format::scientific, 616,
        "9."
        "9999999999999999538347252682384048836943392928017461318258399130032831721168371117424088048739366720094313"
        "6077691955826461901465123541666266244322134476670364976826584991266425757195966583963974093910675995882966"
        "7010478302787493311166285505696724153868013361210329649405378400255940709538946474698507153310677593236434"
        "8354742213567037070994662068464330010387537712483243968973314585323136087132341292123234794154080950848231"
        "3698874125033522834502049511829556819753701527631041159112958647581624992123842625020794846031831003737181"
        "93400495677586862932287419778865178437101302218181775316452331026084721088409423828125e-244"},
    {1e-242, chars_format::scientific, 607,
        "9."
        "9999999999999996936787982770012344297899318190517954678165559754747542619193837726638525524292463299758138"
        "3345264756541557445789428565183330163293353068660804119774620271894958417768738584622754955002756418715869"
        "8382674781885463335110891865322617971919535922351649432074165264889245998754100523646275479931532994788259"
        "1005617972575461863158332767212312762242600178875013588298994443899476257695628205428474799363149460585746"
        "7154339802720026478471461044521580905242104106578442206433337435964581613713318314275234234745575404953243"
        "17179619616195490219863468530614425931746236386743476032279431819915771484375e-243"},
    {1e-241, chars_format::scientific, 607,
        "9."
        "9999999999999996936787982770012344297899318190517954678165559754747542619193837726638525524292463299758138"
        "3345264756541557445789428565183330163293353068660804119774620271894958417768738584622754955002756418715869"
        "8382674781885463335110891865322617971919535922351649432074165264889245998754100523646275479931532994788259"
        "1005617972575461863158332767212312762242600178875013588298994443899476257695628205428474799363149460585746"
        "7154339802720026478471461044521580905242104106578442206433337435964581613713318314275234234745575404953243"
        "17179619616195490219863468530614425931746236386743476032279431819915771484375e-242"},
    {1e-240, chars_format::scientific, 607,
        "9."
        "9999999999999996936787982770012344297899318190517954678165559754747542619193837726638525524292463299758138"
        "3345264756541557445789428565183330163293353068660804119774620271894958417768738584622754955002756418715869"
        "8382674781885463335110891865322617971919535922351649432074165264889245998754100523646275479931532994788259"
        "1005617972575461863158332767212312762242600178875013588298994443899476257695628205428474799363149460585746"
        "7154339802720026478471461044521580905242104106578442206433337435964581613713318314275234234745575404953243"
        "17179619616195490219863468530614425931746236386743476032279431819915771484375e-241"},
    {1e-239, chars_format::scientific, 606,
        "1."
        "0000000000000000759277475233108684608982384831531593387598582983591608678088152649529618962442697970945511"
        "2253728656481252609623707518885743635118724171586796539025946776244048864006266446992438854796959500679229"
        "8588215800350017811703378421629495689318049951191680360226281426735122753412882953915621641409250927003198"
        "6910763086367695391445593758514057541064426431653432522754100974317078691906840500853021173802680484470088"
        "3860075238691610755277275140661505025108160714320988751660906591874799129168282589108905049857407833757225"
        "6341803279636545528499519728434495081936805860323147499002516269683837890625e-239"},
    {1e-238, chars_format::scientific, 601,
        "9."
        "9999999999999999067985336682227244656284224215477550517729613770981251451531375480370058344319366581697533"
        "1183669118195751175878957889918151400872130798102236373871589770004064462227523761683081673596124136331155"
        "5882571426208406291495470335517085756171728640264680266111895065381642305829046326748263666763728249837004"
        "6626020550795760273417853730797965291922933006406875916147397503753738389970183566048822187095880537408774"
        "1443622319559242693331719116940274774410004713904731268468483132521263549307219829637997487511275991477045"
        "80579761285687302745881169393181442384133106315857730805873870849609375e-239"},
    {1e-237, chars_format::scientific, 601,
        "9."
        "9999999999999999067985336682227244656284224215477550517729613770981251451531375480370058344319366581697533"
        "1183669118195751175878957889918151400872130798102236373871589770004064462227523761683081673596124136331155"
        "5882571426208406291495470335517085756171728640264680266111895065381642305829046326748263666763728249837004"
        "6626020550795760273417853730797965291922933006406875916147397503753738389970183566048822187095880537408774"
        "1443622319559242693331719116940274774410004713904731268468483132521263549307219829637997487511275991477045"
        "80579761285687302745881169393181442384133106315857730805873870849609375e-238"},
    {1e-236, chars_format::scientific, 599,
        "1."
        "0000000000000000452385056269749738957374958363937411586701359205253954606231547212992278236358823898346238"
        "3764998428403048712490815296123929376907380178547230294435983168516337593604201381495751807319514549342628"
        "7108230683567514025983999121921492328385734199812203920124848335464217685194090758268935342505414810276179"
        "3301425115103972420368222739757723576790458504488844347543930933698064944859304528923691149969167209407572"
        "4362418556266763620337397978233213107947983026866003126727845611570636930442760770896667141459146949297798"
        "054884123959586342812486483601353004502243493334390223026275634765625e-236"},
    {1e-235, chars_format::scientific, 593,
        "9."
        "9999999999999995794466201073065157705805008561139611308159226802046274685060917490638423932758043140638622"
        "7303880018694909606461440847125465979951128205680196431578644620908477577938829729718419833836711322074076"
        "6762730180528365910488757805298383239560360625550264905029942091825321578161929573183609811789476338082131"
        "4793082190649381915259229530730403006333941783317935380572250403817591754796466532135968599538405603408604"
        "0135284373694206587306362717705160991368109381051551269182499342610200096234987102040793131263159890576484"
        "959971436813478787059179808682785051132668741047382354736328125e-236"},
    {1e-234, chars_format::scientific, 593,
        "9."
        "9999999999999995794466201073065157705805008561139611308159226802046274685060917490638423932758043140638622"
        "7303880018694909606461440847125465979951128205680196431578644620908477577938829729718419833836711322074076"
        "6762730180528365910488757805298383239560360625550264905029942091825321578161929573183609811789476338082131"
        "4793082190649381915259229530730403006333941783317935380572250403817591754796466532135968599538405603408604"
        "0135284373694206587306362717705160991368109381051551269182499342610200096234987102040793131263159890576484"
        "959971436813478787059179808682785051132668741047382354736328125e-235"},
    {1e-233, chars_format::scientific, 593,
        "9."
        "9999999999999995794466201073065157705805008561139611308159226802046274685060917490638423932758043140638622"
        "7303880018694909606461440847125465979951128205680196431578644620908477577938829729718419833836711322074076"
        "6762730180528365910488757805298383239560360625550264905029942091825321578161929573183609811789476338082131"
        "4793082190649381915259229530730403006333941783317935380572250403817591754796466532135968599538405603408604"
        "0135284373694206587306362717705160991368109381051551269182499342610200096234987102040793131263159890576484"
        "959971436813478787059179808682785051132668741047382354736328125e-234"},
    {1e-232, chars_format::scientific, 591,
        "1."
        "0000000000000000249863339080062911178038644222122371080935937931442510710279241545360881120763563354792727"
        "1204968809447263314062851575076488572199734151496053423339459628625623951696207510718204728166398876567257"
        "4288016505168108861079050506718628599358044231968538756452578178166866642842418468448402090677674425335611"
        "1758693995222916479276809189246877056722019580820408559743015166448682006363223901758949274685611426824095"
        "2441476048682580053244629262333867401903791102273486390772019414434805804812691972815986765285930166522083"
        "3572223445350350191397625909672797206440009176731109619140625e-232"},
    {1e-231, chars_format::scientific, 587,
        "9."
        "9999999999999998923077556279261669607276344269178857742052631307823063146668949873357937994367585330706658"
        "6851923787391180589072742468823861859572694416677687405759422064737433149483010905868112642822774129086708"
        "8950866453732969837296239860846071191436398749479988812794667280418882508284315291790468322783534698543322"
        "2763549146053280591430031966208307868080860328264805481772604325463231632253160358680946534953336313663699"
        "9465706559822283761704996673667467070947350147170430500500090250087867140451222327563027908008026052077180"
        "979022374130685442417121322478124056942760944366455078125e-232"},
    {1e-230, chars_format::scientific, 587,
        "1."
        "0000000000000000464396689151344957708425250099245062264974342811838633347646649480175933513559646247825963"
        "8716834667872150467156197971992950003945212977393024232997570081916752333744951362797040806496871754762409"
        "3523774421044995987488706419099041487486686846180862681556445048241853678050810632010015245717266998624378"
        "5448097443593469531357092784822504818670379709616765366682468006790097312245968621293462047399778104098730"
        "3938419284302791059489107019314139818789224754807352395205225648090417259273233816851797149977006703310702"
        "512814408808214904078592866198960109613835811614990234375e-230"},
    {1e-229, chars_format::scientific, 584,
        "1."
        "0000000000000000693232262560712474007504296368175932861281974684261164160838551277311989399208801333728083"
        "0729491583525363430455767462037175531140390391683126429966221232093955941263611471681132623382709491503904"
        "7375249531313675588992339392304815234823905634674008201667236376321839848939762273142402611092832410132397"
        "0716794455188726120242728620103174431415297180332879294084551036487606971854229655463609004961555893191674"
        "5535158735631016132816549960093097063467020650843476133267312297323069477364478450489994893647488342551896"
        "278779277366273448013345159779419191181659698486328125e-229"},
    {1e-228, chars_format::scientific, 582,
        "1."
        "0000000000000000327095345105724447928977822337886539907189763688385114859731508401894299982170153196284692"
        "3509240518480222689176456277966414687628106528818962914816379391810430169233755297466585716365369112717512"
        "1212889354883788226586526635175577239084355573084975369489970251393861975517439647330582826491927751719567"
        "4286879236636315578025711283654103051023429227187097010241218188971591516481012000791373872862711430642963"
        "8980375613505856015492641254846765471982547217185678152367973658550825928418487036668878503774717719765986"
        "2532354876733797777177414900506846606731414794921875e-228"},
    {1e-227, chars_format::scientific, 579,
        "9."
        "9999999999999994483667432137531853405142846651919968173684572982825965370746055008918453812773976664205546"
        "1806379623718849101061094361965886631986252579449704784567589751299683163621004793516731395237522036301698"
        "4232249314520585568125760180654060493094354252712965722645315515667150793038653453822153434497565715287762"
        "8550827121105302767048696761763317380829461396372195290172193549331544235852896295780095558254847205260583"
        "2488961204054717339152603622555696524198109764069629982095609254974414109481076434981991680800682250798021"
        "9193039241043496900829268270172178745269775390625e-228"},
    {1e-226, chars_format::scientific, 576,
        "9."
        "9999999999999992140391160425608486502573412858067853267494422609219249843660980606245241543726628584567845"
        "5596772807429948356873502783913017233507635857119058287608601973485118222629925278543631190326543612068785"
        "6793144185369306448728558535026937320361233858543155596710812316128092403135788648626506813051775901445653"
        "1399369722369875296859785808489260546321506496239188673574863325229045321464303305877790712822242644948835"
        "0538349222453692588279587908979174338697479788659722904339841966832055396226731386526846785614950264968197"
        "7558236700698302001910633407533168792724609375e-227"},
    {1e-225, chars_format::scientific, 573,
        "9."
        "9999999999999995889633195164685873546684506928231237117398663206989994686997099650522381174202385511988166"
        "5532143713492189547573649308797608271073422612848092682742982417988422128215652502500591518184109090841446"
        "0695712392011353039764081168030334396734226489214851798206017435390585826980372336939541407365039603593028"
        "6841701560346559249162043333727751481534234336451999260130591683793043584486052089721478465514409941447632"
        "1659328393015332189676413050701609835498487749315574228749069627859829337433683464055078617912121442295916"
        "4173920765250613840180449187755584716796875e-226"},
    {1e-224, chars_format::scientific, 572,
        "1."
        "0000000000000000188842045074720969281726225744049265127724544816342318643633489012136580458296359659586068"
        "0142873716319177545269388374861295393117868142201454771495799112919370837715281606083172804275621385687770"
        "2693982152263862758542091738083576971893101469828956572059834562621057530513170623824039675826626152702882"
        "9554943250110925357284565537410933697787459888079249619861975705749544080532085014387137886982187761584570"
        "7545289506591395555191133327745750663038010048636493634780383388550426764336480678810024954958759532602026"
        "627590152685343127814121544361114501953125e-224"},
    {1e-223, chars_format::scientific, 568,
        "9."
        "9999999999999997089390646281190637400800057030683519949368020198276633036864657744691065855954627728762669"
        "2711462403432106728597696196760677403094474374681383689185984160229479378003085214166818823098530044048697"
        "3944534218136807948895448410591421461173584131029794582684483073554583722610639117199712477545283988280188"
        "8583247748499098113898765741804068580802307245320098647828424758533523028653011700551458546375903476327247"
        "2418041727595056862123397096052789194474810296725446652560022479388716998619908128864112804247216219040786"
        "38909396659073536284267902374267578125e-224"},
    {1e-222, chars_format::scientific, 568,
        "1."
        "0000000000000000476783833342682112606713957768637813007397190494251111847601702954737064781916897791611948"
        "6665910201904757668715159627972431984802920565041444613042119531057224577664265456883067357455082414457510"
        "5873699390533971936733619876298237867358547303864542840334666315780417025464434651086480732669884805027801"
        "3972914335267534684821378915349249801611797386207593472909455643687259147132155320986333106388946209955678"
        "3727380706890529476578409498630033709192327460014863016495012072917359803021174598364193159679182279020795"
        "42079860630110488273203372955322265625e-222"},
    {1e-221, chars_format::scientific, 566,
        "1."
        "0000000000000000169645925856856893060060376942410028602413035104481732430035608082629881503388323784117675"
        "9708004617280138870373003624653886287005531314012122115392711085043513921718682682696513167396990650436454"
        "2482001003045855479995989862202599578862071747559917487508179112410433564183086355339876938703742242547888"
        "3927078511100484735448777978881712624199170721537360029658810376553696409425413660613858205688403865026496"
        "9133150093238119960431981583020131793294388887877935675999408142925964561757501084173080407977398016174108"
        "708042922444292344152927398681640625e-221"},
    {1e-220, chars_format::scientific, 562,
        "9."
        "9999999999999999239355998681967174227375122814278010784257107926662288959827321849441348805654645781222578"
        "1416801495804438316992788219990497287676199131886641172731843282325453969622164633472698153505172392196091"
        "7686422930553623146058858509260889480648913025162172052469893497144467951580077187425939035308281925639579"
        "8904098517668447759506972297076828822690693898011732750582941628468462192600203323158782851279699890831517"
        "4577656023161923475148392505322102605760380301683938036029249989328483687465622728201902066159706058967593"
        "37838375358842313289642333984375e-221"},
    {1e-219, chars_format::scientific, 558,
        "1."
        "0000000000000000317072121450052998442454095738999365116805429691571034550467333621241329477082039307714926"
        "8647799297899955893577238506246788221948278154506196914264427139130095036572562414306059178624874697166561"
        "2910016229040151379230052268968505957340380014586137656864892970028025625598133537298246759807490672538246"
        "6349079706700668711147626428386130469357231520579072082419120104777806523524649657592646158024664190592504"
        "0138380787791276528182266982512884712925399402503660799437298029321834277564064370984814528794254462340518"
        "3301656506955623626708984375e-219"},
    {1e-218, chars_format::scientific, 558,
        "1."
        "0000000000000000317072121450052998442454095738999365116805429691571034550467333621241329477082039307714926"
        "8647799297899955893577238506246788221948278154506196914264427139130095036572562414306059178624874697166561"
        "2910016229040151379230052268968505957340380014586137656864892970028025625598133537298246759807490672538246"
        "6349079706700668711147626428386130469357231520579072082419120104777806523524649657592646158024664190592504"
        "0138380787791276528182266982512884712925399402503660799437298029321834277564064370984814528794254462340518"
        "3301656506955623626708984375e-218"},
    {1e-217, chars_format::scientific, 556,
        "1."
        "0000000000000000820286869074829038147691322564690967085931469882169185788207623459701738560623254961593543"
        "2495631807748931332781026902083893493219520703392638894413217937078958575273805231533309563616052243338659"
        "9970974867100681381948985284062799729213005566035635834935809604029406528561494585049482415841618646905336"
        "1016177121015963348199695802694543380830079047974782555840977310449435712983375193946909035332432768524474"
        "9169568225199384279436574479448148011932581959092802554105295508219736240850467056635533661182457798588529"
        "84034456312656402587890625e-217"},
    {1e-216, chars_format::scientific, 552,
        "1."
        "0000000000000000417715070975008206383501541104137685510630637729690664798015391588933411293790282438490650"
        "1417365799869750981417996185414209276202526664283485310294185298719867744312810977751509255623110206400981"
        "0322207956652257379773838871987364711714905124876037292479076296828301806190805746848493891014316267411664"
        "5282499189563727638558040303247813051651801026058214177103491545912132361416394764863498733486217906178898"
        "1944618275272898078433128481899937372726835913821489150370897525101414670221344908114958355271895129590120"
        "6322014331817626953125e-216"},
    {1e-215, chars_format::scientific, 552,
        "1."
        "0000000000000000417715070975008206383501541104137685510630637729690664798015391588933411293790282438490650"
        "1417365799869750981417996185414209276202526664283485310294185298719867744312810977751509255623110206400981"
        "0322207956652257379773838871987364711714905124876037292479076296828301806190805746848493891014316267411664"
        "5282499189563727638558040303247813051651801026058214177103491545912132361416394764863498733486217906178898"
        "1944618275272898078433128481899937372726835913821489150370897525101414670221344908114958355271895129590120"
        "6322014331817626953125e-215"},
    {1e-214, chars_format::scientific, 548,
        "9."
        "9999999999999991294853170555815447380942404303671844696679748417593976294002496024747640399247703645613921"
        "9669145746563738570562978920712197817481457391341938411132808559707770852376293656497482700456956882004083"
        "4461538432173005728133703533459726557209837131653219566175297137847666946046014646053306115669486530319154"
        "9347298089165733677047427050182759982813113559251953651435370993927616364020573917965857675783303466730526"
        "8247784355081422352221012897456633272684485689532862584208239791227856442081540328491173763580945887952111"
        "661434173583984375e-215"},
    {1e-213, chars_format::scientific, 544,
        "9."
        "9999999999999995417188383097980764646245766459737448027760269658974031233570950381415311611617342282187547"
        "3910589667246545368520413459409764199735476351819671112511702776504860961416874815223117854304683340245916"
        "0464911595164867510407202793112181136390385649127508640932246203586979303121868349231428609901062896334351"
        "8460160107236627343777979364517278553598680503677613849707225222789602684066453511779979166688543657149232"
        "4631271842328641050496299912350310218151325193111111838448475138359469325323751129341864896105107618495821"
        "95281982421875e-214"},
    {1e-212, chars_format::scientific, 544,
        "9."
        "9999999999999995417188383097980764646245766459737448027760269658974031233570950381415311611617342282187547"
        "3910589667246545368520413459409764199735476351819671112511702776504860961416874815223117854304683340245916"
        "0464911595164867510407202793112181136390385649127508640932246203586979303121868349231428609901062896334351"
        "8460160107236627343777979364517278553598680503677613849707225222789602684066453511779979166688543657149232"
        "4631271842328641050496299912350310218151325193111111838448475138359469325323751129341864896105107618495821"
        "95281982421875e-213"},
    {1e-211, chars_format::scientific, 542,
        "1."
        "0000000000000000860866106323290977989521652535914737868721793763139020704019000432275185949120018591922314"
        "8748321021343152712198420398324197662294833702534841575692416427025554931034673452314515034661740800661978"
        "0367570571673882521368240042400003578976814090504523368015448321395277884576460019940142059144210726758298"
        "1962131856506348707731574677038773798011249472583972648417715875514795890821326821198516793758531226648909"
        "0505843180151974088497721836001007644364521160456150945201722824918063055169882569206407652018242515623569"
        "488525390625e-211"},
    {1e-210, chars_format::scientific, 537,
        "1."
        "0000000000000000438738980558973249501554588251133620087619148388021703078207190706152416416973367595537175"
        "6313997163865233296087579101561566864752022160981921747071217659225532903868917941661009994907733611338014"
        "3784825159783515874863433718211592230068725922315156166760336737063572299211892600734702315734897306878342"
        "0324974785855889196258366120050919096362807417474785044114678002479328491648628750791950753089834631150033"
        "5932174061457858893794332445675895125148716795289738221567522725371785895925880183199296880047768354415893"
        "5546875e-210"},
    {1e-209, chars_format::scientific, 537,
        "1."
        "0000000000000000438738980558973249501554588251133620087619148388021703078207190706152416416973367595537175"
        "6313997163865233296087579101561566864752022160981921747071217659225532903868917941661009994907733611338014"
        "3784825159783515874863433718211592230068725922315156166760336737063572299211892600734702315734897306878342"
        "0324974785855889196258366120050919096362807417474785044114678002479328491648628750791950753089834631150033"
        "5932174061457858893794332445675895125148716795289738221567522725371785895925880183199296880047768354415893"
        "5546875e-209"},
    {1e-208, chars_format::scientific, 532,
        "1."
        "0000000000000000979061701537299941966152430535653450847430534468171869639246307155589561418121080870910153"
        "8629931701436970148709455961417734285606820934169659127706352082009561098641084995297496445792862813672687"
        "8610739287003185182389585813172758756671078777597546184366879565008155448478538897317665187298818484324685"
        "9220535836288477370944073072995373114472813248014545177622566479964726762589682280912355285145766273388594"
        "1786470533386326343014670865292039149744946382702746507819298852791020659758203237288398668169975280761718"
        "75e-208"},
    {1e-207, chars_format::scientific, 532,
        "9."
        "9999999999999992500289944066545260794393352251899924160340990116913366439211345173906974144483983897166235"
        "2189411812074122203194500098779985388714648599688995096739219291006708753701504236607398029604493662017327"
        "1678140799002433983058991092970258715435496406938981280259425155854893708252707482521839982942707164963854"
        "7547404749041952119498108235731202565207945902873127503973233520114522955783109845270607825667850182252003"
        "0527218232152305055095879225203782710370117029811199918136152450494694154947694642032729461789131164550781"
        "25e-208"},
    {1e-206, chars_format::scientific, 531,
        "1."
        "0000000000000000287448618685041775611467192411468067474871960285579656441116238100310015816652007878432741"
        "7265535493345146977353453580801839986912678504489355280493380020846005009332711166642793788659897434684305"
        "8033569204162008468756111131622465602620067122836086961830504745239089017417231637691472711696999377193365"
        "7434217691734764507346368173226471971292005784923652206732469228783416975785133762358237484114173771323236"
        "6292971049317888008012637688183374798261772510814095901417025409694400162052829728054348379373550415039062"
        "5e-206"},
    {1e-205, chars_format::scientific, 526,
        "1."
        "0000000000000000010803385544138509069593097161793914125848530612542771161864210478198197576064378681441776"
        "8719777010108417708811052628555482267435021532617233741608191196380582573609361635180912725806711283088952"
        "9802701171025537783302721259002348340999662460931503272815954817331462444992708733840995721456271734340837"
        "6719690433913279361907286213318911514019682799687295018376430328310893061063314354936590363701536770497093"
        "609557125569051267401182441733990905766850296205863565885611603245575196297068032436072826385498046875e-"
        "205"},
    {1e-204, chars_format::scientific, 526,
        "1."
        "0000000000000000010803385544138509069593097161793914125848530612542771161864210478198197576064378681441776"
        "8719777010108417708811052628555482267435021532617233741608191196380582573609361635180912725806711283088952"
        "9802701171025537783302721259002348340999662460931503272815954817331462444992708733840995721456271734340837"
        "6719690433913279361907286213318911514019682799687295018376430328310893061063314354936590363701536770497093"
        "609557125569051267401182441733990905766850296205863565885611603245575196297068032436072826385498046875e-"
        "204"},
    {1e-203, chars_format::scientific, 520,
        "1."
        "0000000000000000364909283964494690243191939081376830412598520594029984319306805834501324924016544053590211"
        "8858347868651431172545325847430820148366422456613549311381232891696323291335249035452120486258789557131004"
        "5938212253440220260683060295956098435873780428169370394754578725053224457696098050769606268964403117192073"
        "6034285323924780348069311122000588899328256220789832219472160120915723671907243196436298677829712131554556"
        "674824299153355310153286540401954520562788798446562476933408003532122165779583156108856201171875e-203"},
    {1e-202, chars_format::scientific, 520,
        "1."
        "0000000000000000364909283964494690243191939081376830412598520594029984319306805834501324924016544053590211"
        "8858347868651431172545325847430820148366422456613549311381232891696323291335249035452120486258789557131004"
        "5938212253440220260683060295956098435873780428169370394754578725053224457696098050769606268964403117192073"
        "6034285323924780348069311122000588899328256220789832219472160120915723671907243196436298677829712131554556"
        "674824299153355310153286540401954520562788798446562476933408003532122165779583156108856201171875e-202"},
    {1e-201, chars_format::scientific, 518,
        "9."
        "9999999999999994583981840083828664387789037672445647185185462414227186362537617223653189132590007008902182"
        "5036064707813167053855864071099551731820360911829814527622461516880270539569772907578286195014691755833524"
        "6313038824586331185893923613544981929960384320404305625917015212855137051754213994323632673435867770929096"
        "1889224054953378234945273557754947929383082627673369846670918518473573081467853621970453936615832072474512"
        "2774033477753696070790004781196766668518623271037326465104921879856192390434443950653076171875e-202"},
    {1e-200, chars_format::scientific, 514,
        "9."
        "9999999999999998210026239908275959605441178928974709961505359824656249094749793672197213175620180419702157"
        "0455030299293624922494821832383011632557906373552085962098408476913455489082859886355453662043973282024133"
        "1540672308512679754268595351951382901471352304920064954568524027925980061836920599672604679919133131325752"
        "1270675728671148333244408622655324354942874459763350785891191594747038536509684958927467073288347769702934"
        "065739205278643004860546448479624082362272590048489495639927326919860206544399261474609375e-201"},
    {1e-199, chars_format::scientific, 514,
        "9."
        "9999999999999998210026239908275959605441178928974709961505359824656249094749793672197213175620180419702157"
        "0455030299293624922494821832383011632557906373552085962098408476913455489082859886355453662043973282024133"
        "1540672308512679754268595351951382901471352304920064954568524027925980061836920599672604679919133131325752"
        "1270675728671148333244408622655324354942874459763350785891191594747038536509684958927467073288347769702934"
        "065739205278643004860546448479624082362272590048489495639927326919860206544399261474609375e-200"},
    {1e-198, chars_format::scientific, 510,
        "9."
        "9999999999999991248020992245337152787549067716438909430971156796632448648902414890992687013002247470966205"
        "9250616363651145814708022930718768623141819087045324807904590313649740386017732887103292125347752751738164"
        "7903616019374090502989225614211093036170293774649807043557627102989961482478123917402578427471263639364172"
        "7258288515133029744510069298046601617868074142150587382588267288301984862829368791970001850877117631024364"
        "23213435887235808111997818538852504458228488519455634531141186016611754894256591796875e-199"},
    {1e-197, chars_format::scientific, 508,
        "9."
        "9999999999999998674159923085805213393300653009810429996874306693191169124472952257610848253128042616284553"
        "7868657895003123529680608425827294499852312192652536705711329687797703162620535019638931097823721317376531"
        "0449809394455252371020553334467402225824756206938082148635917156255047967127507045157273096748991097456524"
        "0871501542907022905826697910962572537414527814270868346111386548510042114755039370057964754782429778948172"
        "054646195039061999776584332685697351547605103705418372328495024703443050384521484375e-198"},
    {1e-196, chars_format::scientific, 507,
        "1."
        "0000000000000000461507106775817966187790192124450764644959682661043814550492938215090537724522867873253923"
        "2076309112008470570165867682191411520122070667713830622395672118711607338390277672566744227580449616988722"
        "4048676409452018186544561551067244957754832615276870223269854919886711715484701354736102883217117306393040"
        "5176207196512621743488000080129534927305169075196709311692988195667648791629557583252833507790667949728721"
        "83126556639724251347018692505234351971198612785141079939421615563333034515380859375e-196"},
    {1e-195, chars_format::scientific, 504,
        "1."
        "0000000000000000936779998349607922066558293583226541961177484254423572660929452606554100043890918762554297"
        "4707863770014997143924113153878357176231542226472692183855303438657076956092857009049025121818911605189577"
        "8451632785457212546098566525163648745892718210943319829994865483295677250502261874912403342050891863710951"
        "0047452830290157305812264311356157066156142110212407293358467828320964455752800500250463133640607927195845"
        "53190632391191156426420971847936254735776662183610596912330947816371917724609375e-195"},
    {1e-194, chars_format::scientific, 503,
        "1."
        "0000000000000000176343371831543992660529331249185298255229001705015959684231029580212400332902037339673698"
        "6497376317204554625910920399179244126456387732458513685519893326744325567768730070677375691037372424068209"
        "1406902583848901570812158566609402684872101257877000459234848581841332394474165042630322607916852572002294"
        "2253459816246100406093441541393561643994585254187290522693700416075659393155611833054255732280703963248447"
        "6108811118884410829937732489961321031245178314605936975567601621150970458984375e-194"},
    {1e-193, chars_format::scientific, 500,
        "1."
        "0000000000000000480518022438769564422940916182801795737608394724779004874910398790749080217297589908825938"
        "1781571298328731633116197501058889346366449530064185084854057371509426123098380846026035463349988096516756"
        "6224794664492225960926721750031101109280348039103528207538855342423070336885403775543154901570468288685756"
        "9371057021863723165980970649378599812859207996597337230959607380973781418194487299932738692824665548827406"
        "7792911966978292755019478367894242808178173476107986061833798885345458984375e-193"},
    {1e-192, chars_format::scientific, 497,
        "1."
        "0000000000000000967197463410330479242799452076588191709415423556399877179997389527607768032330474019469521"
        "4236283268127414844644640864066321698222548406233259323788719843133587011625822086583891099050173172434432"
        "5933421993521544985110022843505818588333542889065972604825266159353851044743385748203686571416253435379297"
        "2759212550851919581801017222154660883042604384453411964185058524810776658256688046938311429695004085753741"
        "4487473323928503835150271772586917651270965734511264599859714508056640625e-192"},
    {1e-191, chars_format::scientific, 493,
        "1."
        "0000000000000000188510357855833015531025794646529958154524177425806481491858204348633867528277859442439788"
        "2308744116449521706199131483254429935252790204362740541493259888534929589981916101691322081929877050966151"
        "0399618267074634546416741093946270621848431129126061569167008852264601912170614591946835899662997200669632"
        "7338163704470805316488942705712963170749170163883692391024336694671584274157166851729395050702462426671605"
        "977617515280816610694100232507863790232249812106601893901824951171875e-191"},
    {1e-190, chars_format::scientific, 493,
        "1."
        "0000000000000000188510357855833015531025794646529958154524177425806481491858204348633867528277859442439788"
        "2308744116449521706199131483254429935252790204362740541493259888534929589981916101691322081929877050966151"
        "0399618267074634546416741093946270621848431129126061569167008852264601912170614591946835899662997200669632"
        "7338163704470805316488942705712963170749170163883692391024336694671584274157166851729395050702462426671605"
        "977617515280816610694100232507863790232249812106601893901824951171875e-190"},
    {1e-189, chars_format::scientific, 491,
        "1."
        "0000000000000000686870105410711392306560935401767227629654574949386254732267282863177163850871532771738817"
        "4742369173523373314804257486974040663553435453559872562162354259478070339834015932022566252886866568705851"
        "2341252652000657227180441413664381320398902655487604631988293528801721357017188131951220329585081190883818"
        "0407634966154718446288670396235649706616968065048312917847198665960667399980860416663101533257689088484172"
        "6791405982325182252994934771483936941649517393670976161956787109375e-189"},
    {1e-188, chars_format::scientific, 487,
        "9."
        "9999999999999994908067112790032880452765975891977808893416208927947989552854944282732526766467167814211472"
        "9016690365461294541519550780469749156318868554867557125565277692145325401889763392275802425900917261305707"
        "6813301281782027933475606463409156438777709922199012812172103051126346893854116359406976977720796143697733"
        "0409039381133269347693239389812020205342531022532236534723299348668678980039958608222059751251451001340125"
        "954851991484343502465496900111219247264671139419078826904296875e-189"},
    {1e-187, chars_format::scientific, 485,
        "1."
        "0000000000000000128707188149247610317961577755901485817508529722976908703009114926888671969566618642923904"
        "7216709109600659513166516362808076647856712774459084699012968564021752699999664122051572781415038308837387"
        "0166622140883511824725097055580097338022374545962676401628454691080147578789025767146309768072347121843930"
        "4969827153068735740912975382850240786445034415743937927805593258116894299058323623937350272795835227254097"
        "9734347453266124169414530431510002017603255808353424072265625e-187"},
    {1e-186, chars_format::scientific, 482,
        "9."
        "9999999999999991080664251568566946816656094891755579324414755946855331066513221291040011008947756645194928"
        "3126449927134114187432183071903138762969913041033583206826632923302004443025636695331847192951237765064810"
        "1901549205550173745210388007974066273910088599742362089704636735321269557432431572173304555919191098852789"
        "8835500091400816510831330726597787609877843141587950888723719409168520573713992029531193965227310238619613"
        "6871547144152751022960767812719495850615203380584716796875e-187"},
    {1e-185, chars_format::scientific, 480,
        "9."
        "9999999999999999245790355507694271907023841025563002404951188973186335837375563673317377958322500472430223"
        "4358962862232098942818567516845240935447684803879394233469075096834422488602440315478951689910554023712058"
        "1713286968178129346842854046235591958961014087649883630968564875705434541798692451605139055762615194522001"
        "9525717242830049229470069208121483813535843954269093600189489946768858507209387397405040975412143865756706"
        "52490890549595435599083970146239153109490871429443359375e-186"},
    {1e-184, chars_format::scientific, 479,
        "1."
        "0000000000000000577789123865899613197931803793260894086938033539425113965406543757913927151782229553421845"
        "9534497321031048674712767507279892267342990221415604305478302883566035692506388321159663528747800703062985"
        "6556267717828049382814882687684481250700175447797590086397970738801276652929170115515060665563735447105737"
        "1607789096397343540438105999334044077646224460441400776936210637684912885400570369170411858356001076746638"
        "0795112258360497758946650037614745087921619415283203125e-184"},
    {1e-183, chars_format::scientific, 477,
        "1."
        "0000000000000000055221053213795464392148268040697219009783701825739929660071353845448175667022245948478787"
        "0655616493184777650368038902803597728304412828593472399773186584459960937589472889470248840942404462509561"
        "7848316501019860224310404861235743606856916216571508707757079337816690093929729419231423257573756304982907"
        "5883615198705872646445226736516527520612112408429807643402401323278491257656865065626485649704171724609864"
        "13789495760688630365820017686928622424602508544921875e-183"},
    {1e-182, chars_format::scientific, 473,
        "1."
        "0000000000000000473275509735478783436775096642748159071507167196688077104339505775420776854830232832433234"
        "1758721155461794469843821786384633359535274742851177924337279623744820741523005234821780591186721454952300"
        "8814677474466411551113987122394733721931523601552373810669792458604359341129281976258333183965739618681171"
        "2462954316859049361639530146770540766239402050039082150229448774803628559851829308461626616625635206319283"
        "2911879721902170814473720383830368518829345703125e-182"},
    {1e-181, chars_format::scientific, 473,
        "1."
        "0000000000000000473275509735478783436775096642748159071507167196688077104339505775420776854830232832433234"
        "1758721155461794469843821786384633359535274742851177924337279623744820741523005234821780591186721454952300"
        "8814677474466411551113987122394733721931523601552373810669792458604359341129281976258333183965739618681171"
        "2462954316859049361639530146770540766239402050039082150229448774803628559851829308461626616625635206319283"
        "2911879721902170814473720383830368518829345703125e-181"},
    {1e-180, chars_format::scientific, 467,
        "1."
        "0000000000000000205720657561601459248213926337435557432004149359281262740007888540238312094633121226702388"
        "0252734171604503705379320740892770555547523117726246388616260078602510467005544533796800271030358579788947"
        "8596206451460618701959694475252980048283774875164620144805656061300251022921568339761110831074870297914282"
        "5052177281241016263915175964207972289037936679409146465860138405827540686447052193047136397795898578025255"
        "0330804428568853836623020470142364501953125e-180"},
    {1e-179, chars_format::scientific, 467,
        "1."
        "0000000000000000205720657561601459248213926337435557432004149359281262740007888540238312094633121226702388"
        "0252734171604503705379320740892770555547523117726246388616260078602510467005544533796800271030358579788947"
        "8596206451460618701959694475252980048283774875164620144805656061300251022921568339761110831074870297914282"
        "5052177281241016263915175964207972289037936679409146465860138405827540686447052193047136397795898578025255"
        "0330804428568853836623020470142364501953125e-179"},
    {1e-178, chars_format::scientific, 462,
        "9."
        "9999999999999995207802359964755093254973303558352972348764236955198179673189484181712023085285155160314218"
        "7974074929298393483501980644336017773388789574064216571704500430381961642408451391728506514300696193707641"
        "2369206325657890081247052985700906437455381356119707601934668842017337283098214303282216076742448367510473"
        "2805880700588515337408292568477969874021853305965111138747038612487557305308227775860414375917728095925426"
        "92325167763556237332522869110107421875e-179"},
    {1e-177, chars_format::scientific, 462,
        "9."
        "9999999999999995207802359964755093254973303558352972348764236955198179673189484181712023085285155160314218"
        "7974074929298393483501980644336017773388789574064216571704500430381961642408451391728506514300696193707641"
        "2369206325657890081247052985700906437455381356119707601934668842017337283098214303282216076742448367510473"
        "2805880700588515337408292568477969874021853305965111138747038612487557305308227775860414375917728095925426"
        "92325167763556237332522869110107421875e-178"},
    {1e-176, chars_format::scientific, 455,
        "9."
        "9999999999999999591421057981561172760359517840594637610381681203271426218398700962941525716354631708608402"
        "1288165672816245368488365773674697953924112200111094852957684657993573180102527517321784079742545540384017"
        "1468635566584800121790983716471398626500096489256663663452679575447847968613394523652707106506451318955178"
        "4144051652154369610524111495583091804490661938365977391453819697791781023172096034811422121224133013894785"
        "9040854382328689098358154296875e-177"},
    {1e-175, chars_format::scientific, 455,
        "9."
        "9999999999999999591421057981561172760359517840594637610381681203271426218398700962941525716354631708608402"
        "1288165672816245368488365773674697953924112200111094852957684657993573180102527517321784079742545540384017"
        "1468635566584800121790983716471398626500096489256663663452679575447847968613394523652707106506451318955178"
        "4144051652154369610524111495583091804490661938365977391453819697791781023172096034811422121224133013894785"
        "9040854382328689098358154296875e-176"},
    {1e-174, chars_format::scientific, 455,
        "9."
        "9999999999999999591421057981561172760359517840594637610381681203271426218398700962941525716354631708608402"
        "1288165672816245368488365773674697953924112200111094852957684657993573180102527517321784079742545540384017"
        "1468635566584800121790983716471398626500096489256663663452679575447847968613394523652707106506451318955178"
        "4144051652154369610524111495583091804490661938365977391453819697791781023172096034811422121224133013894785"
        "9040854382328689098358154296875e-175"},
    {1e-173, chars_format::scientific, 451,
        "1."
        "0000000000000000408024660475077059817387500126561010283827794411329843068069293894692053641056977569406164"
        "5860179459417852569871442414611750645879228256918309821296094530706786339470126146992930030675499927138062"
        "6078645110929395600330796878478038262808188478558890667044712256648069091058093906931208992098479034123455"
        "6471433870655780438619471007693873666129072197794446443422556352914330611026469713197725405241789164989540"
        "950045920908451080322265625e-173"},
    {1e-172, chars_format::scientific, 451,
        "1."
        "0000000000000000408024660475077059817387500126561010283827794411329843068069293894692053641056977569406164"
        "5860179459417852569871442414611750645879228256918309821296094530706786339470126146992930030675499927138062"
        "6078645110929395600330796878478038262808188478558890667044712256648069091058093906931208992098479034123455"
        "6471433870655780438619471007693873666129072197794446443422556352914330611026469713197725405241789164989540"
        "950045920908451080322265625e-172"},
    {1e-171, chars_format::scientific, 446,
        "9."
        "9999999999999998334549904886182533644575182481590307346570727588463864968956314327427402721974391392681493"
        "8840349574834806876025069429390711572561024496770933912156771676252771920014882010591679536179058495704966"
        "6459647214626236474966227897344883106057195766283635621494235537958651944862482050868079918452516392716952"
        "5584371276921407873336343892803511244586645127284001019477731425013353998786167727604989180489880595814611"
        "2971007823944091796875e-172"},
    {1e-170, chars_format::scientific, 446,
        "9."
        "9999999999999998334549904886182533644575182481590307346570727588463864968956314327427402721974391392681493"
        "8840349574834806876025069429390711572561024496770933912156771676252771920014882010591679536179058495704966"
        "6459647214626236474966227897344883106057195766283635621494235537958651944862482050868079918452516392716952"
        "5584371276921407873336343892803511244586645127284001019477731425013353998786167727604989180489880595814611"
        "2971007823944091796875e-171"},
    {1e-169, chars_format::scientific, 445,
        "1."
        "0000000000000000201179579279951889494332706650336297646126334616435798702446775408390300828267543734556479"
        "1148767438721478692254625644809586029974902966311471906467144279997443046381416486456775682934766059213738"
        "8682880170721357697310494206530360280015299673863900909282408323621275688292229454267224632007317171976821"
        "9062755043188870164156569825065005551127725431170669760491634397165652335013242654640323869852380767042632"
        "214725017547607421875e-169"},
    {1e-168, chars_format::scientific, 442,
        "1."
        "0000000000000000495359250313018798398232857372078111175301744102507328466887690588908349273123627410787142"
        "8960553423711877095976320606305997928149943379618974718668317969895175729885359114774861866388254226928332"
        "6312412530128344937161591339967057855542963751652330786988796139481604083337014453611557944136969598140923"
        "2266209375586253665614918173692729092462974165924485487326723400897105883120943360144183831295094933011569"
        "082736968994140625e-168"},
    {1e-167, chars_format::scientific, 440,
        "1."
        "0000000000000000024671776660111744151992616217291209528621088924792880843782226300079471761353893528818080"
        "8461695847727239650021608667911738891069878718326970219146440066058803436279050909465923972862673158584982"
        "6105160755077165353399835926468341734698701227190842982658575634105078651265358454660624644729525716278361"
        "1140682443750440063281560815888371426326576190318380324390580994926780206148622231338007892986752267461270"
        "0939178466796875e-167"},
    {1e-166, chars_format::scientific, 438,
        "1."
        "0000000000000000401221755582437387548984809141120730845965613066964438942266597731142573770769680634393330"
        "4860781908514949606785378218627146120733930447360573818763942389127901271164097473713074287683138013259662"
        "6270962175118109020409240257267314631374111246760033226122752038406298996922683253821371284255480821768410"
        "8041103989219090945148246702131857559235694570803264454739494919703040747726479134382948643633426399901509"
        "28497314453125e-166"},
    {1e-165, chars_format::scientific, 435,
        "1."
        "0000000000000000099981772444576872831391054802057113792089993753227192463479100586292092163237050949933130"
        "7741513059884781641374362578054820337002689064133690939069940530672623003256060222315354035826766129519918"
        "6138321039085354086801716792628136314033783231104681031351410914965322720396823414492773972634716737376371"
        "0520766752844170239654897993137068652908399866415357150460363779882032314464193611946996043116087093949317"
        "93212890625e-165"},
    {1e-164, chars_format::scientific, 432,
        "9."
        "9999999999999996179977994240000492832410478595553265058890028512475980974191051545313215911848434547968112"
        "3506829020765128967167375531390990830327028509706783315595375571441777746032006200790016328565711155363281"
        "9260952214329461930296792492054510062892584060561175197172651174597606779554476715670182740414942023491074"
        "4882271746442971108655400587454064027847283393947054636137539561684188212445367760494718822883442044258117"
        "67578125e-165"},
    {1e-163, chars_format::scientific, 430,
        "9."
        "9999999999999992324106210075385904447210423055538966769282101296639226045711088091227051335430774586877556"
        "0380187758298979009906375332065220798567138804402682455512151783214215916809129382899197104804151043494558"
        "5563145673110198780120492144673027600936385460172667104099484794553110440023470772264137151669161743272965"
        "6621955120843986078340537112320766026857911177781841141364660971975280266688113073314525536261498928070068"
        "359375e-164"},
    {1e-162, chars_format::scientific, 428,
        "9."
        "9999999999999995408803637407077575155370467487550405400968443069308629988495058854495982996564902555750001"
        "0881500768271898975715175491525836823975050568645963143578730813796265380187430837211852483813399132989537"
        "2521390906085609300261532422578213570501344340483473578558017898588707511648275526988973622665785967447452"
        "7230208421323174102592427892427404427649408950714011937182963843742406623293916823058680165559053421020507"
        "8125e-163"},
    {1e-161, chars_format::scientific, 426,
        "1."
        "0000000000000000281207746300313758485495457412437785811701566332371519945117658868634141898328680968104386"
        "9208465199220690689365629587423131528495403880282983679493852048719318409229535432756222539343559454777748"
        "6122117946522659454860002908955065989745724565322940911725849734827414048354780693832858115305768410546622"
        "1669001634247322536079696576468333658954900360575122184714689073598350987914784582244465127587318420410156"
        "25e-161"},
    {1e-160, chars_format::scientific, 421,
        "9."
        "9999999999999998863664756018572246348509717251403216668457145854698362404413106109357186457035125880887139"
        "5442971339441569337421031670121726772431911744598437514213299328048160779171128466042026508303756993223913"
        "3914625567018069082819497533832021856414098286431576829951574975108576231868056852280790470182005098522878"
        "2311452117859864689754545566146839436535886456398043228499463060121588142692417022772133350372314453125e-"
        "161"},
    {1e-159, chars_format::scientific, 421,
        "9."
        "9999999999999998863664756018572246348509717251403216668457145854698362404413106109357186457035125880887139"
        "5442971339441569337421031670121726772431911744598437514213299328048160779171128466042026508303756993223913"
        "3914625567018069082819497533832021856414098286431576829951574975108576231868056852280790470182005098522878"
        "2311452117859864689754545566146839436535886456398043228499463060121588142692417022772133350372314453125e-"
        "160"},
    {1e-158, chars_format::scientific, 419,
        "1."
        "0000000000000000644461715342893769628088384244751452824968949939521068953419899265716691290743835877718806"
        "0499499819275101744539273894201213671647439569640272413320572395360660554036964212016080836775688509796677"
        "3034320905157843797711811812081180689521694123068341482158086593158645959509317701749254858130330879185409"
        "76318295429117517178155992347336913970321071383156146176302524197776477876686840318143367767333984375e-"
        "158"},
    {1e-157, chars_format::scientific, 416,
        "9."
        "9999999999999994315093317572352976389085242133736429719717733730390966126541574180671350586793186143106586"
        "9711755227455900472638007306987480806006421373515865542817844552713093922452020273570757392631880130378197"
        "6057475476281847746240325181644150833132392519880474034974000401221846213932984753153735603509222882524146"
        "59073461311052731967136774974327947162647755003431814598176263775286543022957630455493927001953125e-158"},
    {1e-156, chars_format::scientific, 415,
        "1."
        "0000000000000000401871238625762075230252412238475890854369514626224674485266750896186780044330932425037176"
        "5793834959969199405084179261500720553438080083182535241512814807342790321678611775084279817273188410444905"
        "7948606233651911993094255953297827568280003148852282666425949282551353691886113856462478598574449160998810"
        "7423610556951506838186752937735609011950981220659355323300554463372691316180862486362457275390625e-156"},
    {1e-155, chars_format::scientific, 412,
        "1."
        "0000000000000000143108063460821601205894042098448624752396783625375187052570059302021541381490502075510105"
        "1441125776709570242998744986620194560681429964294282258251206713457062073829702509023692063137188304469682"
        "8523843917378918068168863037262250905622199443021819929645002817903575273088029754823250588381508661599771"
        "7868176971927245633249316887604321134531113575159345409348876643207404413260519504547119140625e-155"},
    {1e-154, chars_format::scientific, 408,
        "9."
        "9999999999999997290869831969168427669206498744049989892404140240160071602553527513571595209458135162667908"
        "4767910834941635836620501468113529722707897740730774850326337632398968772714476833267516565195881349093261"
        "4442242113421277882882343716053282453697135136930795507954884744671298030110951922004857720728038625613094"
        "579483235888427705349419207394260530659325342359329547026192130942945368587970733642578125e-155"},
    {1e-153, chars_format::scientific, 408,
        "1."
        "0000000000000000391520711619164456269278077432874800210290605386190694987958883232420170497817315211056093"
        "7219726592638814238600761890505499513727814078427005122182350483587361191764655404441856307107748406205896"
        "8771615741000992236097240236656404501773691000619064156954711423965442555134190492396909478166731541022849"
        "184139321355053638998925549573035749685418651483935492674248735056607984006404876708984375e-153"},
    {1e-152, chars_format::scientific, 405,
        "1."
        "0000000000000000656494202988063501670221048456262720698710681931060570119040295424845374888565915888971814"
        "8716900796296674500576246587983158130310623800168576177042237171726346917561938492887898167343012514724525"
        "1702572352864538015220842582676835004335281995389457999418400603764767655983428612475478960604302612407465"
        "074615720461537986384519001106479628333213098383136507862900543841533362865447998046875e-152"},
    {1e-151, chars_format::scientific, 401,
        "9."
        "9999999999999993846214444173480837456947875440007023542943145156851694898495169012043938129726326349763533"
        "5304646187389452430939200400903967707131371358090351137147810686592154337349796683468972382137447938351093"
        "6339806159195182754275513217787685920396452204915675555926925407280071719070856360983454449039614697613088"
        "00329004750413118933670433745949010823799753266971634957371861673891544342041015625e-152"},
    {1e-150, chars_format::scientific, 401,
        "1."
        "0000000000000000062953582321729639972108793363873778804649710470552049825417932113812917053289050370440599"
        "4963230580103067513751160865633202829165130023467457014156090990295018891776024374768764400416020911642797"
        "7937229542290195469983973327591070678597318167103775792299736841014279430081135223499483319944143412505925"
        "47994858646301304824078966967156534016215353732892623384032049216330051422119140625e-150"},
    {1e-149, chars_format::scientific, 397,
        "9."
        "9999999999999997916207271599770174815431910359245482245075520886052976911905660287695077571624832762549010"
        "3901241955574186054882645354160804057843328684040882539795670216406975085596064922000175355351104645197224"
        "2159299717419245921614045252661498439742489884588924976169191208997705268115153885390281699280706354080788"
        "0810075377797307651794197530131880842681202370414439428714103996753692626953125e-150"},
    {1e-148, chars_format::scientific, 395,
        "9."
        "9999999999999993574881589011728214966382273112057792962800986774904942764267802927000528833599759255577835"
        "0731539802843803522676304070686845283750574203026982376971286717937832954133378800900225517256537491228018"
        "2618506588646911876452944415462765085773383026270792261244107687165562815801236526022999299023541920515241"
        "33144221481909121761385664308924357650265601904493451002053916454315185546875e-149"},
    {1e-147, chars_format::scientific, 392,
        "9."
        "9999999999999997047942135082161782845621982909807944388620614063823370082378088815556167824019818061154775"
        "3267301525028109548441377097466012303024777787838102507230793516713146659303527697780185387732191214403383"
        "0251141091664779112581825085221751768948668512925298433184174504631276777652370413516825219229273467367678"
        "73109447318760285566630713102839918271502739344214205630123615264892578125e-148"},
    {1e-146, chars_format::scientific, 392,
        "1."
        "0000000000000000260483900879485549145240551858620818666993201772609285379135454623724519020869191215007787"
        "9732452028052299918966549394031267953386350352353589471564600439475364858757576593278812118049323717148396"
        "6646335629649336669038803415683613046202912529157250830828828141257641911661418463350694669155844394233157"
        "85705380865772214765502279117310481526548215924776741303503513336181640625e-146"},
    {1e-145, chars_format::scientific, 388,
        "9."
        "9999999999999991491045261369468074238838447233407702107309210401553886373401631393867145439347723972231670"
        "9210082769533219907217260254619345072186052052140310298815582638672644731031289462772249594971145257322799"
        "4038925886836191534775616013607373075868211734278088558080067596686134438690556193526703746900102992403778"
        "8916508597979842347823863503257502127752331944066099822521209716796875e-146"},
    {1e-144, chars_format::scientific, 382,
        "9."
        "9999999999999995047459260545592047747179910066303857167348508745406355947146564143748119765537864189142457"
        "7406702773049949277600695034041212099922836522986897312201317600618565965125521933177328502338214669854372"
        "9214743617926487584571589819440575439439704072612302878146696017771025535626117294320381489190772096380674"
        "7888947723673401521480956499754455535367014817893505096435546875e-145"},
    {1e-143, chars_format::scientific, 382,
        "9."
        "9999999999999995047459260545592047747179910066303857167348508745406355947146564143748119765537864189142457"
        "7406702773049949277600695034041212099922836522986897312201317600618565965125521933177328502338214669854372"
        "9214743617926487584571589819440575439439704072612302878146696017771025535626117294320381489190772096380674"
        "7888947723673401521480956499754455535367014817893505096435546875e-144"},
    {1e-142, chars_format::scientific, 379,
        "1."
        "0000000000000000415187909843646941992853405491851801412104911250566867805593359198344341404058462314443407"
        "1999004998205277646578228806936119169092900476835416006646879910320012432440675705741433050519791236593520"
        "1126483700951764547204928276237357349018272445874789153751726477574834674378115371235219650945488500256152"
        "8285839188544891300604311457078665625886060297489166259765625e-142"},
    {1e-141, chars_format::scientific, 379,
        "1."
        "0000000000000000415187909843646941992853405491851801412104911250566867805593359198344341404058462314443407"
        "1999004998205277646578228806936119169092900476835416006646879910320012432440675705741433050519791236593520"
        "1126483700951764547204928276237357349018272445874789153751726477574834674378115371235219650945488500256152"
        "8285839188544891300604311457078665625886060297489166259765625e-141"},
    {1e-140, chars_format::scientific, 376,
        "9."
        "9999999999999998325050402186307901732467402213100953670680726099100791906309894166038425704554697413047438"
        "8736707768290967065346068526756404752685057091319111903737610941547926974466766577902649223367705840443471"
        "0752777238899304424063559278896454737707191411621114795520100770642861170561930404811834896485852742605782"
        "0477947621912585655923333405326047795824706554412841796875e-141"},
    {1e-139, chars_format::scientific, 375,
        "1."
        "0000000000000000298651335918643711628932072437743460203097543522435510082600885241996241637337863799815674"
        "5373938153930041458569504416084023430328021523294715043392256147086968485441875896151199424883187106083685"
        "5116242505539397726245213806567814973968761784932253618911783197472724962913730905084412418686107855057037"
        "903823030327416475360191583376945345662534236907958984375e-139"},
    {1e-138, chars_format::scientific, 373,
        "1."
        "0000000000000000671568372478654048793480338210890152071921120252455854796176801902310160890843779046624419"
        "0574152055610797260197422466810729794375634174624958125807052189432709115838035286839947026920320323715156"
        "2349014330858971553316300109510350574127195899948367330399601693799476039599761196766995561916125919694205"
        "6630578736140489704009581828358932398259639739990234375e-138"},
    {1e-137, chars_format::scientific, 370,
        "9."
        "9999999999999997765674847346292395985645003553380915867445361004070274835946019175567546824295824542834322"
        "0936386915769833362904191450666345206613638114323747280115416878029316028872527491869527820312006013996264"
        "9903619500919943683456929824482651337469540239096944228288373026152734555532884967287960181640825645650030"
        "4089424972613098230311834413441829383373260498046875e-138"},
    {1e-136, chars_format::scientific, 368,
        "1."
        "0000000000000000015234388133035855383875390450151974382791625207620048100283188580157663004673368212241028"
        "7021775588652667049332286697531726593651835908283730300757011154904205606340794759227751247334965860683767"
        "7619335918296521617671188216331487917848351857520007198181041140264394144632347883405649229831294125932790"
        "40680454942957577912920896778814494609832763671875e-136"},
    {1e-135, chars_format::scientific, 364,
        "1."
        "0000000000000000397101433570486440640372814601854186856466967779160881086984927240319116320263425424973183"
        "0906794623973760990199274781475873910436591263245899217149762302266244011866461975293028791820990275538393"
        "7825694267423765216591980590544644372410588391296507638744567280502987247158842902088614368498832624121250"
        "1922610289550874540509539656341075897216796875e-135"},
    {1e-134, chars_format::scientific, 364,
        "1."
        "0000000000000000397101433570486440640372814601854186856466967779160881086984927240319116320263425424973183"
        "0906794623973760990199274781475873910436591263245899217149762302266244011866461975293028791820990275538393"
        "7825694267423765216591980590544644372410588391296507638744567280502987247158842902088614368498832624121250"
        "1922610289550874540509539656341075897216796875e-134"},
    {1e-133, chars_format::scientific, 360,
        "1."
        "0000000000000000641496342650454815204531166058943602839619187024947014198474039982822446442241062041121761"
        "8993206806579261112354147155200128193178834690421687323641123036577948591402888993574806420292045901045354"
        "4357763610865201119901287710041064503330419772913467920705224010255686832775799714045712057246057262961864"
        "454953175851414926000870764255523681640625e-133"},
    {1e-132, chars_format::scientific, 354,
        "9."
        "9999999999999998594326335945560165992244413962574716935320854384313882417088792068117900519126248694463097"
        "1166878222416607214585555592825144884036557234591653828687686867804939368863225350731180091846678994230803"
        "4551417118526062293115049276525200843869593517391950184311224750470481588015379157829994532549384186718988"
        "143383057831670157611370086669921875e-133"},
    {1e-131, chars_format::scientific, 354,
        "9."
        "9999999999999998594326335945560165992244413962574716935320854384313882417088792068117900519126248694463097"
        "1166878222416607214585555592825144884036557234591653828687686867804939368863225350731180091846678994230803"
        "4551417118526062293115049276525200843869593517391950184311224750470481588015379157829994532549384186718988"
        "143383057831670157611370086669921875e-132"},
    {1e-130, chars_format::scientific, 352,
        "1."
        "0000000000000000860474181186106478814017048964495719560523575469171389466368285000105430231533024449190888"
        "5118632122193789221804912802057060030515884801171193467057382254521235894667527601955279175402111741499591"
        "1810497742588727689266426889109856940634588690842264333341972440114105661488593017559271586363570539363054"
        "8343253394705243408679962158203125e-130"},
    {1e-129, chars_format::scientific, 347,
        "9."
        "9999999999999992588077050396257392703488768553145229733371914199873875069132357308356059441403851215995624"
        "3155212422703836212507412136177871631363182768319485323556005461360487622175994949438213094542015941771738"
        "4419280934109333533385517507781179706383817482773534294846124960068136571893048547172361733897591462572052"
        "02346085570752620697021484375e-130"},
    {1e-128, chars_format::scientific, 350,
        "1."
        "0000000000000000540140885956810330905283414542659480243086298659334589074477275146251465374054496583672623"
        "2958009946209108101694078484369205457039971496303344480117025912844198468177541980552987602212529712035107"
        "7136783812753168822080851861443509146635347302329282152570500451292647260628735384990864503768808260741884"
        "90792948869056999683380126953125e-128"},
    {1e-127, chars_format::scientific, 346,
        "1."
        "0000000000000000283874249773373412578296507005190488789136477211465148760964467263168293488071674291258011"
        "1229512205421363205605411030218921798259240852409065290564740839502568526985553483431154343660864088463520"
        "9397812668884721728332391839310430911435954191518896407953322860235480539940849278936138837692998437844948"
        "9668128080666065216064453125e-127"},
    {1e-126, chars_format::scientific, 343,
        "9."
        "9999999999999994638210139863752739319384028852897161364970485782829397577234820373021434529266429555312521"
        "6983194349005795381216751769380140901609027919473718839974286048093527151711902926412879162955340930344432"
        "6331050085056910283373197684845805587978962369256620251783545688525470337396137395610167062504070045747539"
        "5523943006992340087890625e-127"},
    {1e-125, chars_format::scientific, 343,
        "1."
        "0000000000000000119863602615973784849024886181210334258608591484828706960316270217995063481042668024112659"
        "3323273651317206472108663859562740256639573240316726609251278392563925364622680845273181058187798089377705"
        "4044871136808915588333377425145260840908342600600249531398329201958893838700602171061114411404480151190909"
        "9644981324672698974609375e-125"},
    {1e-124, chars_format::scientific, 339,
        "9."
        "9999999999999993326124962604555717485211062261055925120747399969737863172049244011635594473034379418149707"
        "3733285916172541513242774404130688568651687022735009389466586472584381852808921821149092879170812937657908"
        "3507517828450461163381082371524445023758069641907445239343596422312776727474160532609971652195923752515227"
        "533876895904541015625e-125"},
    {1e-123, chars_format::scientific, 336,
        "1."
        "0000000000000000592214266429284712709327154154273179306528902377541659346183077708093965901286206073491272"
        "4893240687137177864579295711052543096504215963142662011434050239747217672227754043168144120350228166744854"
        "1461342749187237271530538937940950644027863982445952535876710937795463538272513841741184759115412816754542"
        "291164398193359375e-123"},
    {1e-122, chars_format::scientific, 336,
        "1."
        "0000000000000000592214266429284712709327154154273179306528902377541659346183077708093965901286206073491272"
        "4893240687137177864579295711052543096504215963142662011434050239747217672227754043168144120350228166744854"
        "1461342749187237271530538937940950644027863982445952535876710937795463538272513841741184759115412816754542"
        "291164398193359375e-122"},
    {1e-121, chars_format::scientific, 330,
        "9."
        "9999999999999997860691335212340624944112834802459237580782384539782206076370595916585057707372344692184393"
        "6804969460044266880960840178432795831352257161863989250421196205543988005817624520940738275930141680382536"
        "2705645307282349322073832894363067133705474907626194082336061086343845843364512571138646990220877341926097"
        "869873046875e-122"},
    {1e-120, chars_format::scientific, 330,
        "9."
        "9999999999999997860691335212340624944112834802459237580782384539782206076370595916585057707372344692184393"
        "6804969460044266880960840178432795831352257161863989250421196205543988005817624520940738275930141680382536"
        "2705645307282349322073832894363067133705474907626194082336061086343845843364512571138646990220877341926097"
        "869873046875e-121"},
    {1e-119, chars_format::scientific, 329,
        "1."
        "0000000000000000130024390228669006586108721634497552792083855061365287802750027321337635426438129020374848"
        "1664600942221067190062254340279232015505994888221071175236010018076668185817385530952343819169425474153069"
        "8485296570604075930318596366131621457117669193880841542694664169076444938015837959888187924661906436085700"
        "98876953125e-119"},
    {1e-118, chars_format::scientific, 325,
        "9."
        "9999999999999998548601848627210513127507711110962495648793617754556340466596531375943317018774133794497211"
        "2773177452477547884893180823304700696093795505933333750808977000588526776288870678657278259082964292612168"
        "7135109387034031318296259047753696621199718313862638351258177207227966550723285976687293441500514745712280"
        "2734375e-119"},
    {1e-117, chars_format::scientific, 324,
        "1."
        "0000000000000000295122913448237779750123491948538334728406551032911080056404251831583617661174558404929924"
        "3896970860405054631006016095048489183043964090797713855329077408887357490730484608804313415126102901088181"
        "6348367949744479609411978642945372534116287611377588167235972038088633907781943577219863072969019412994384"
        "765625e-117"},
    {1e-116, chars_format::scientific, 320,
        "9."
        "9999999999999999429127305798243970002253152785846665975847996269467232486085728763921888937368423845457617"
        "8012483682792147569926576848740738922962964586342094711305336418245536402492065760534449437518577236266098"
        "2404823409116184273460964524093702365192349873845287015478485841959641056142515935789560899138450622558593"
        "75e-117"},
    {1e-115, chars_format::scientific, 316,
        "1."
        "0000000000000000506449023169285809400062397950510535606899601876489694141081659204698474921637188017160421"
        "9554404355680558555414031141153138357492564670095816485848203669125039801019251428454834497950650007565124"
        "72130993150441963186515079572669739126745191857734238466488461104242357890825587674044072628021240234375e-"
        "115"},
    {1e-114, chars_format::scientific, 316,
        "1."
        "0000000000000000506449023169285809400062397950510535606899601876489694141081659204698474921637188017160421"
        "9554404355680558555414031141153138357492564670095816485848203669125039801019251428454834497950650007565124"
        "72130993150441963186515079572669739126745191857734238466488461104242357890825587674044072628021240234375e-"
        "114"},
    {1e-113, chars_format::scientific, 314,
        "9."
        "9999999999999997851225686547752015282709321304454232749766549970746913987161087044664288059247456074136569"
        "3103646918068384934346731171159358420413413594249595070095860341804175152335940173810558685761958841238256"
        "528149588154496617780581231049241207195755411835638060919569276852048034243125584907829761505126953125e-"
        "114"},
    {1e-112, chars_format::scientific, 311,
        "9."
        "9999999999999994965919868489709583795543458024193783422074762453086903017698885043736103596397686435149509"
        "2127488262573504686429299075010548358608520351566167154741389802025686009193310529515444168264142347473060"
        "254169697398616737432210540562148125004249902260523746627858543423172932307352311909198760986328125e-113"},
    {1e-111, chars_format::scientific, 310,
        "1."
        "0000000000000000881538779516831325493393960176944394019499534253785495567111745464819138901807658070228739"
        "7681304980894892987643297313652483665527200791644662114844284839296243389627793282213199385225366151754600"
        "23692731730268401631043898549001949195234763482210724552280700638817734215990640223026275634765625e-111"},
    {1e-110, chars_format::scientific, 307,
        "1."
        "0000000000000000512219634805401894263036729677071056505554985451525014163020583608700331290562887556438396"
        "0756356672991548315909866005345435977616174456581183341678912610204596779305536687743424726985645640552655"
        "11385789128593139162584753710767157743183492959649261329346803250928132911212742328643798828125e-110"},
    {1e-109, chars_format::scientific, 304,
        "9."
        "9999999999999999213090032671148042944651608772737164832437073679082439164747246389102391125712547343738461"
        "6764393803461968411363759120541596769585323204796173046143170436579622027899261365917852738020928226295429"
        "16946809659127192130501219695914914199014601235509201726525674303047708235681056976318359375e-110"},
    {1e-108, chars_format::scientific, 303,
        "1."
        "0000000000000000394037508497744476269322415917111588501092729834801660113711411814742312854964560992025486"
        "0940373214462478020955167986687180717484646029360870134265993496895269864002414577513096836348935076968032"
        "6744756749605705517267782736253202447852708639242959309800795608680346049368381500244140625e-108"},
    {1e-107, chars_format::scientific, 300,
        "1."
        "0000000000000000015854704313240738689436611885241290886813511861286927155922062074076653861049915985904174"
        "1529226147169453077100134326980763885063755062255867870544652334305423735032423824776047586311461273497240"
        "8684525827194158640497566304817959803162658537732665475772364516160450875759124755859375e-107"},
    {1e-106, chars_format::scientific, 298,
        "9."
        "9999999999999994107622176180347585616193254342488147039667631036633544234591024890115994707864839761100750"
        "4713908395006131669320804714504969531903295148878642485905064741616699286804386203967687862515031879439739"
        "78815635133568363766522001452157157165857837531619534132687476812861859798431396484375e-107"},
    {1e-105, chars_format::scientific, 295,
        "9."
        "9999999999999996527992122961171506127462400146458051771054626067127835164442863230376212268918567800277146"
        "8945249625681491309993020136626037259396997338350656973721648182191714512212327021484803062754864221652807"
        "34670414167907363879815853064012686426021044028278339510507066734135150909423828125e-106"},
    {1e-104, chars_format::scientific, 293,
        "9."
        "9999999999999992655400208111853233309431766860106204200835434018336969676679921885959864171232602937594912"
        "6175103656600915884917475461232328895407073835195433793215114677271690151559621713457418742371132474111899"
        "253027677129649636985456904850438396097599136336242509059957228600978851318359375e-105"},
    {1e-103, chars_format::scientific, 291,
        "9."
        "9999999999999995753473739991307851563856273489187682257010787657369662066890274961492942649381374827740700"
        "0391220431865376224977911201547295586599012637719612337620341481207709640081785959879326198678117872144625"
        "7279688487691888384356182054821891706276881794934752178960479795932769775390625e-104"},
    {1e-102, chars_format::scientific, 288,
        "9."
        "9999999999999993275014914487744156960316668185922499812070504746143508154721992501066479866862357315624070"
        "1018327011653807952929562609295322233645461595700269502096160038058894049264054562741800233632529553718444"
        "5480159114575574772754891649767885510036169449676890508271753787994384765625e-103"},
    {1e-101, chars_format::scientific, 287,
        "1."
        "0000000000000000517161727690484989105730677364159537554778386272002904693312974831111350122295364137378389"
        "3800821542866933565876163585210479432782250659739311511261223096517320888518916526900192486585135348216411"
        "421179001055338801084410855940271152519915887069146265275776386260986328125e-101"},
    {1e-100, chars_format::scientific, 281,
        "1."
        "0000000000000000199918998026028836196477607885341594201826030059365956992555434676176762886132929895827460"
        "7481091185079852827053974965402226843604196126360835628314127871794272492894246908066589163059300043457860"
        "230145025079449986855914338755579873208034769049845635890960693359375e-100"},
    {1e-99, chars_format::scientific, 281,
        "1."
        "0000000000000000199918998026028836196477607885341594201826030059365956992555434676176762886132929895827460"
        "7481091185079852827053974965402226843604196126360835628314127871794272492894246908066589163059300043457860"
        "230145025079449986855914338755579873208034769049845635890960693359375e-99"},
    {1e-98, chars_format::scientific, 279,
        "9."
        "9999999999999993877776100850210847487897500195676592182679981550153708786161318795442195615570982374570834"
        "5025814691449261356691720986931002153083765209119373679695640965032686000950926838525646548331616632759691"
        "8109804658117462243096325476277019816961910692043602466583251953125e-99"},
    {1e-97, chars_format::scientific, 278,
        "1."
        "0000000000000000362347275614230386486015179458496381198537636440236074215343295235503271551048096227501536"
        "2076793128266838165330935538744052169263360047450615280383040626852473271454077752909394064704527719494238"
        "439954420779105059740904555554141808215717901475727558135986328125e-97"},
    {1e-96, chars_format::scientific, 273,
        "9."
        "9999999999999990629210549086179841697146068732580852248447853932751364330404107608912022317267655741089325"
        "3111775827709554591152509520094495639900486787323780638317385863868670429754309941669548515427063112032127"
        "6147925518186447666098282116564632815425284206867218017578125e-97"},
    {1e-95, chars_format::scientific, 272,
        "9."
        "9999999999999998945538361602099216521469733278105946480082100633301366137142568246429265960924171922801988"
        "8411715318883203910932890875195952313649679547120498824245718922848550292017649197621159479662720125094691"
        "957033611640984498321327311742834353935904800891876220703125e-96"},
    {1e-94, chars_format::scientific, 269,
        "9."
        "9999999999999995619007236595731466591740267459895908787428401953081365414447183991422368503461565450116923"
        "4291739522413744183020738333155369644150002443201811549874385699256598347112313495240515093968457319869666"
        "220137187712048605636727671708285924978554248809814453125e-95"},
    {1e-93, chars_format::scientific, 266,
        "9."
        "9999999999999990296557436585543066704173122150759848479182484064729364258134569183411332571521395093820818"
        "7699778248062608618361294265890437372950519076931911910880252541509475235263776371431484076857636831509625"
        "041102909425751177341368247653008438646793365478515625e-94"},
    {1e-92, chars_format::scientific, 265,
        "9."
        "9999999999999998812477116601844506524280554645377544972375952686092566108234752876228990062625667663894586"
        "2246916287024425521816404773514329006869692462963751333270865593904872214221435769525933704234949612885690"
        "92755775468382706261394332614145241677761077880859375e-93"},
    {1e-91, chars_format::scientific, 264,
        "1."
        "0000000000000000221884498860836508245232352764322462356965334013463784684827482635335605305906737669192409"
        "3206577150260915228319844897656388566043736181737648710222711081486303100580449952876371355518587472543611"
        "7282139692787057416722973357536830008029937744140625e-91"},
    {1e-90, chars_format::scientific, 260,
        "9."
        "9999999999999999493750691003148621709889149244946960691831430175801622256242767571654402661914009469500487"
        "6210687330141370874092813614124240337583226333846298487062114638096503972538048521373489674425134635395776"
        "198474142304473133435749332420527935028076171875e-91"},
    {1e-89, chars_format::scientific, 259,
        "1."
        "0000000000000000385390156717149495889778415468219122129634648610993958160349406162237704329735939702537825"
        "6557882200608982112866183019402767285414984310749460027132610852092294722576437013319784788364231877946032"
        "19323390230766079866953077726066112518310546875e-89"},
    {1e-88, chars_format::scientific, 256,
        "9."
        "9999999999999993389539464367463749646836141632804995845510351868008479170090955900642705772290466891271611"
        "1095298783813540517696190402259434814389962850738675989092523202139483418021198264819388181521076833705412"
        "17106330922348433887236751616001129150390625e-89"},
    {1e-87, chars_format::scientific, 255,
        "1."
        "0000000000000000176102914661068871704759455207231397620617925926155336111681344047803017579234561099855692"
        "7468211736163456500646870223567402524619786705614341541487939145716625446421573575952215594321807039030933"
        "9980083880305983257130719721317291259765625e-87"},
    {1e-86, chars_format::scientific, 252,
        "1."
        "0000000000000000845822089240526869096820128042392116049471438517638926667419142813994015180838972628438518"
        "0555157222389138459748671170240569759164419042046720695550888606118767130117136575528437015257566523559248"
        "2227300337171982391737401485443115234375e-86"},
    {1e-85, chars_format::scientific, 248,
        "9."
        "9999999999999997742714099133940732695230515061349665633058183712651817782386647880884190182719141827059975"
        "6160444444280473251857896555635021838930073037549140490501694694753404362042357762064827417603513483139454"
        "631754006186383776366710662841796875e-86"},
    {1e-84, chars_format::scientific, 244,
        "1."
        "0000000000000000345765105554531564377414825658805446289260815782664512385801586401904736971641012020430008"
        "4916904592673962596952659796724604890704426897510544260517219675685168006291116202511525020958866108444773"
        "60160453827120363712310791015625e-84"},
    {1e-83, chars_format::scientific, 244,
        "1."
        "0000000000000000345765105554531564377414825658805446289260815782664512385801586401904736971641012020430008"
        "4916904592673962596952659796724604890704426897510544260517219675685168006291116202511525020958866108444773"
        "60160453827120363712310791015625e-83"},
    {1e-82, chars_format::scientific, 237,
        "9."
        "9999999999999996142531751338755757593133547433872322400384190960733692081210467362198499913285667881432745"
        "0118036029191910490910660160383934259858098175033375898393954117365887165799092568410709035847672154773135"
        "8441524207592010498046875e-83"},
    {1e-81, chars_format::scientific, 237,
        "9."
        "9999999999999996142531751338755757593133547433872322400384190960733692081210467362198499913285667881432745"
        "0118036029191910490910660160383934259858098175033375898393954117365887165799092568410709035847672154773135"
        "8441524207592010498046875e-82"},
    {1e-80, chars_format::scientific, 237,
        "9."
        "9999999999999996142531751338755757593133547433872322400384190960733692081210467362198499913285667881432745"
        "0118036029191910490910660160383934259858098175033375898393954117365887165799092568410709035847672154773135"
        "8441524207592010498046875e-81"},
    {1e-79, chars_format::scientific, 233,
        "9."
        "9999999999999999887872835092514419317813078520813578332402861996080345150934830450505121252485387470740823"
        "0432153096736340815962020317497336959217417624670274052264414348782613129120472130243434116803058486766531"
        "132161617279052734375e-80"},
    {1e-78, chars_format::scientific, 233,
        "9."
        "9999999999999999887872835092514419317813078520813578332402861996080345150934830450505121252485387470740823"
        "0432153096736340815962020317497336959217417624670274052264414348782613129120472130243434116803058486766531"
        "132161617279052734375e-79"},
    {1e-77, chars_format::scientific, 228,
        "9."
        "9999999999999992696817954285297788806428378833886366942927013608214771257064053320956408281221925859269313"
        "2229048327051034591863408815839603776447524281367429596833130704462499279543423371524601961368716729339212"
        "1791839599609375e-78"},
    {1e-76, chars_format::scientific, 228,
        "9."
        "9999999999999992696817954285297788806428378833886366942927013608214771257064053320956408281221925859269313"
        "2229048327051034591863408815839603776447524281367429596833130704462499279543423371524601961368716729339212"
        "1791839599609375e-77"},
    {1e-75, chars_format::scientific, 223,
        "9."
        "9999999999999995765001370096376884491285850700308643802436708920370749451782251562897192482294336146830490"
        "7462373028783431914145483056546903267762678774509976564483811726039081188696297508577970347687369212508201"
        "59912109375e-76"},
    {1e-74, chars_format::scientific, 223,
        "9."
        "9999999999999995765001370096376884491285850700308643802436708920370749451782251562897192482294336146830490"
        "7462373028783431914145483056546903267762678774509976564483811726039081188696297508577970347687369212508201"
        "59912109375e-75"},
    {1e-73, chars_format::scientific, 221,
        "9."
        "9999999999999999692276142334558126967903414689329158182609118919930401541021545312581396259667021314908797"
        "9761028647000900486666538084652246616646076525732436683076683433657106032411976404006281882175244390964508"
        "056640625e-74"},
    {1e-72, chars_format::scientific, 218,
        "9."
        "9999999999999996550456324544013132986609363498112746678471190920282679869630110312834033237768873180446152"
        "1922104152426925628649694062167971937539358324754468588202386067562686157439433287663632654584944248199462"
        "890625e-73"},
    {1e-71, chars_format::scientific, 215,
        "9."
        "9999999999999991523544616079141142616538881592166488271850506120846325195403814313238252402731836165305918"
        "9379824961108565855822743626193132450968609203189719636403510281811614357483364301515393890440464019775390"
        "625e-72"},
    {1e-70, chars_format::scientific, 214,
        "9."
        "9999999999999999566603349622936327208651652641680501722443601799944492674165887912591501738791095389530292"
        "1447471667217941492345864323752875629481807797693317959281711539013329237413074679352575913071632385253906"
        "25e-71"},
    {1e-69, chars_format::scientific, 210,
        "9."
        "9999999999999996349379856205418253371806544221874896342206363528305225682661058472850202004367391699840542"
        "86204129847741912377366160447289783580765283598918786301304310361326432854411905282177031040191650390625e-"
        "70"},
    {1e-68, chars_format::scientific, 210,
        "1."
        "0000000000000000664449503514147608964971089116525283355896552599755088005547651268002236115452324350684774"
        "05667000768594192052486210537605449626573422560856484483414528645350838331751219811849296092987060546875e-"
        "68"},
    {1e-67, chars_format::scientific, 207,
        "9."
        "9999999999999994290356820418206686116225674833199308898854531034456094808097967631415770174336221338439103"
        "32110954280101910747866971461536841043771495196989574594736115142890042761791846714913845062255859375e-"
        "68"},
    {1e-66, chars_format::scientific, 204,
        "9."
        "9999999999999997584793677677745193725155065855080248808217463024614704207398912977710861102386093916681406"
        "58660035188325913355065673838741549102961556640076313325245227492388266909983940422534942626953125e-67"},
    {1e-65, chars_format::scientific, 202,
        "9."
        "9999999999999992313694706062483581550868040220070744953236771840360929168517400423638715617506297791493721"
        "361815057351675091835477500352140162082574583311375313564306477331911082728765904903411865234375e-66"},
    {1e-64, chars_format::scientific, 200,
        "9."
        "9999999999999996530573883354692871290297660728078348037221324787763949199622610466896432005410134691643869"
        "5416432929769423252076208907803604252402073697828855693148231154054883518256247043609619140625e-65"},
    {1e-63, chars_format::scientific, 199,
        "1."
        "0000000000000000665108390885599516666492874994729659543878425186153119727427511457071495133637934325200422"
        "517323105847758368530076502780808905681852605731451018311606304678207379765808582305908203125e-63"},
    {1e-62, chars_format::scientific, 193,
        "1."
        "0000000000000000395228123538898122123169379282217172946503413797519326445436778014303001284812088763590813"
        "033814098767741265594259325793402808839764107397274361943573239841498434543609619140625e-62"},
    {1e-61, chars_format::scientific, 193,
        "1."
        "0000000000000000395228123538898122123169379282217172946503413797519326445436778014303001284812088763590813"
        "033814098767741265594259325793402808839764107397274361943573239841498434543609619140625e-61"},
    {1e-60, chars_format::scientific, 190,
        "9."
        "9999999999999997043346391313425520922612302581852072572233846426168156435405004008156570318179241258702127"
        "560310406428974820785673527056432009240175516617821216414085938595235347747802734375e-61"},
    {1e-59, chars_format::scientific, 186,
        "1."
        "0000000000000000257049426657387008116987749477410779808647407966538824285057522491605532434213255836046692"
        "97825748714277250889112093117585088725661479625017591388314031064510345458984375e-59"},
    {1e-58, chars_format::scientific, 186,
        "1."
        "0000000000000000257049426657387008116987749477410779808647407966538824285057522491605532434213255836046692"
        "97825748714277250889112093117585088725661479625017591388314031064510345458984375e-58"},
    {1e-57, chars_format::scientific, 184,
        "9."
        "9999999999999995495744986240501044053378048768020469428246581119186532239157342153944919191472312470207982"
        "938076356229324745710523507339850487508903231770318598137237131595611572265625e-58"},
    {1e-56, chars_format::scientific, 182,
        "1."
        "0000000000000000398544412264054388859317738397532526381811957937462858497285880146847740537226460753851871"
        "9151474574467405157551346472642240549577596908648047246970236301422119140625e-56"},
    {1e-55, chars_format::scientific, 179,
        "9."
        "9999999999999999457604583227187704838617738531429373476853980305059490181551356500726746075842050168752993"
        "1709955247404289379029075578142991831409602809799253009259700775146484375e-56"},
    {1e-54, chars_format::scientific, 176,
        "1."
        "0000000000000000307987621475787265184226545488654608574986645956071476601459731247492727351298009606456557"
        "3955378764522009913621658689676652276290269583114422857761383056640625e-54"},
    {1e-53, chars_format::scientific, 176,
        "1."
        "0000000000000000307987621475787265184226545488654608574986645956071476601459731247492727351298009606456557"
        "3955378764522009913621658689676652276290269583114422857761383056640625e-53"},
    {1e-52, chars_format::scientific, 169,
        "1."
        "0000000000000000076162237057823428575993091641927138989513847283709538948144790065143893595321174669124552"
        "225337349106179808916165796528474629667471162974834442138671875e-52"},
    {1e-51, chars_format::scientific, 169,
        "1."
        "0000000000000000076162237057823428575993091641927138989513847283709538948144790065143893595321174669124552"
        "225337349106179808916165796528474629667471162974834442138671875e-51"},
    {1e-50, chars_format::scientific, 169,
        "1."
        "0000000000000000076162237057823428575993091641927138989513847283709538948144790065143893595321174669124552"
        "225337349106179808916165796528474629667471162974834442138671875e-50"},
    {1e-49, chars_format::scientific, 165,
        "9."
        "9999999999999993639946561258385225154999214247803524229414097622136664771612907529682762969603377416406323"
        "42481329099202736442053573995281112729571759700775146484375e-50"},
    {1e-48, chars_format::scientific, 160,
        "9."
        "9999999999999997438173659562304724144296122072586385917800431070114651283524903861286055227527841029653896"
        "133378731029238417615800926796509884297847747802734375e-49"},
    {1e-47, chars_format::scientific, 160,
        "9."
        "9999999999999997438173659562304724144296122072586385917800431070114651283524903861286055227527841029653896"
        "133378731029238417615800926796509884297847747802734375e-48"},
    {1e-46, chars_format::scientific, 159,
        "1."
        "0000000000000000229990434539132168285059616408830844887893493788352647401877225916573826931767115445461078"
        "92003424942768685657057403659564442932605743408203125e-46"},
    {1e-45, chars_format::scientific, 156,
        "9."
        "9999999999999998410519796728108115885556130475730798510027332432797015830574374922176498045556503714645274"
        "74677148367876444723378881462849676609039306640625e-46"},
    {1e-44, chars_format::scientific, 154,
        "9."
        "9999999999999995299012157797537262313524103585668678214901248072213449280016067527327081027864783122672863"
        "183914675200281152456227573566138744354248046875e-45"},
    {1e-43, chars_format::scientific, 152,
        "1."
        "0000000000000000774504271351982067660165221114591715939540558551454771548224929710672474909863166549056250"
        "9435341909114214331566472537815570831298828125e-43"},
    {1e-42, chars_format::scientific, 150,
        "1."
        "0000000000000000376231293568868998402945121672663764541764419753300075029753466364131749531598626313283782"
        "26348851942617557142511941492557525634765625e-42"},
    {1e-41, chars_format::scientific, 148,
        "1."
        "0000000000000000057612911342378542997169042119121403423543508714776317814976295686899169228986994124665807"
        "319451982237978882039897143840789794921875e-41"},
    {1e-40, chars_format::scientific, 142,
        "9."
        "9999999999999992929287939988014500233064511906197367398133222223193004995110860615409765027190768719826674"
        "537642929863068275153636932373046875e-41"},
    {1e-39, chars_format::scientific, 142,
        "9."
        "9999999999999992929287939988014500233064511906197367398133222223193004995110860615409765027190768719826674"
        "537642929863068275153636932373046875e-40"},
    {1e-38, chars_format::scientific, 138,
        "9."
        "9999999999999996191940173987276763588211566534471145248715351257676278874429088350271387325933882331274737"
        "96457707067020237445831298828125e-39"},
    {1e-37, chars_format::scientific, 138,
        "1."
        "0000000000000000663242732278491600632468214134494723437057816416802275528824741710182857868191184588790854"
        "09307663212530314922332763671875e-37"},
    {1e-36, chars_format::scientific, 134,
        "9."
        "9999999999999994103842744227748915040917451572375927424342788675606983591665422599959949054738289619947977"
        "3713392205536365509033203125e-37"},
    {1e-35, chars_format::scientific, 134,
        "1."
        "0000000000000000078575451945823803039225861945108062446233498893822872849650915300095655152256418629619361"
        "1269700340926647186279296875e-35"},
    {1e-34, chars_format::scientific, 130,
        "9."
        "9999999999999992767460389181651091970649217996634988016744348623082634610696676519760628561173110284698850"
        "591666996479034423828125e-35"},
    {1e-33, chars_format::scientific, 127,
        "1."
        "0000000000000000559673099762419019344522426032374800632968937312731638482799663888967410529939883190309046"
        "767652034759521484375e-33"},
    {1e-32, chars_format::scientific, 127,
        "1."
        "0000000000000000559673099762419019344522426032374800632968937312731638482799663888967410529939883190309046"
        "767652034759521484375e-32"},
    {1e-31, chars_format::scientific, 117,
        "1."
        "0000000000000000833364206075859853509313360268686545023645097835488625154102063086192231367022031918168067"
        "93212890625e-31"},
    {1e-30, chars_format::scientific, 117,
        "1."
        "0000000000000000833364206075859853509313360268686545023645097835488625154102063086192231367022031918168067"
        "93212890625e-30"},
    {1e-29, chars_format::scientific, 119,
        "9."
        "9999999999999994320657417510427825855837769787704137433831559589728533970337791964011486811614304315298795"
        "7000732421875e-30"},
    {1e-28, chars_format::scientific, 117,
        "9."
        "9999999999999997123254346160061967703296936367536399994355443342760077484474359743593652183335507288575172"
        "42431640625e-29"},
    {1e-27, chars_format::scientific, 111,
        "1."
        "0000000000000000384948697491918390813719893615913383013961276435003578191840212241459084907546639442443847"
        "65625e-27"},
    {1e-26, chars_format::scientific, 111,
        "1."
        "0000000000000000384948697491918390813719893615913383013961276435003578191840212241459084907546639442443847"
        "65625e-26"},
    {1e-25, chars_format::scientific, 111,
        "1."
        "0000000000000000384948697491918390813719893615913383013961276435003578191840212241459084907546639442443847"
        "65625e-25"},
    {1e-24, chars_format::scientific, 107,
        "9."
        "9999999999999992370049955170282463130006189848140882691706936497618579684498740789422299712896347045898437"
        "5e-25"},
    {1e-23, chars_format::scientific, 105,
        "9."
        "999999999999999604346980148993092553230786866765862587503680141039208439934782290947623550891876220703125e"
        "-24"},
    {1e-22, chars_format::scientific, 103,
        "1."
        "0000000000000000485967743265708723529783189783450120951502847720104849571498561999760568141937255859375e-"
        "22"},
    {1e-21, chars_format::scientific, 100,
        "9.9999999999999990753745222789637139672993451167553075691041795935998237609965144656598567962646484375e-"
        "22"},
    {1e-20, chars_format::scientific, 98,
        "9.99999999999999945153271454209571651729503702787392447107715776066783064379706047475337982177734375e-21"},
    {1e-19, chars_format::scientific, 94,
        "9.9999999999999997524592683526013185572915905567688179926555402943222361500374972820281982421875e-20"},
    {1e-18, chars_format::scientific, 92,
        "1.00000000000000007154242405462192450852805618492324772617063644020163337700068950653076171875e-18"},
    {1e-17, chars_format::scientific, 92,
        "1.00000000000000007154242405462192450852805618492324772617063644020163337700068950653076171875e-17"},
    {1e-16, chars_format::scientific, 87,
        "9.999999999999999790977867240346035618411149408467364363417573258630000054836273193359375e-17"},
    {1e-15, chars_format::scientific, 86,
        "1.00000000000000007770539987666107923830718560119501514549256171449087560176849365234375e-15"},
    {1e-14, chars_format::scientific, 84,
        "9.999999999999999988193093545598986971343290729163921781719182035885751247406005859375e-15"},
    {1e-13, chars_format::scientific, 82,
        "1.0000000000000000303737455634003709136034716842278413651001756079494953155517578125e-13"},
    {1e-12, chars_format::scientific, 79,
        "9.9999999999999997988664762925561536725284350612952266601496376097202301025390625e-13"},
    {1e-11, chars_format::scientific, 77,
        "9.99999999999999939496969281939810930172340963650867706746794283390045166015625e-12"},
    {1e-10, chars_format::scientific, 76,
        "1.0000000000000000364321973154977415791655470655996396089904010295867919921875e-10"},
    {1e-09, chars_format::scientific, 73,
        "1.0000000000000000622815914577798564188970686927859787829220294952392578125e-09"},
    {1e-08, chars_format::scientific, 70,
        "1.0000000000000000209225608301284726753266340892878361046314239501953125e-08"},
    {1e-07, chars_format::scientific, 65, "9.99999999999999954748111825886258685613938723690807819366455078125e-08"},
    {1e-06, chars_format::scientific, 65, "9.99999999999999954748111825886258685613938723690807819366455078125e-07"},
    {1e-05, chars_format::scientific, 64, "1.0000000000000000818030539140313095458623138256371021270751953125e-05"},
    {1e-04, chars_format::scientific, 62, "1.00000000000000004792173602385929598312941379845142364501953125e-04"},
    {1e-03, chars_format::scientific, 57, "1.000000000000000020816681711721685132943093776702880859375e-03"},
    {1e-02, chars_format::scientific, 57, "1.000000000000000020816681711721685132943093776702880859375e-02"},
    {1e-01, chars_format::scientific, 54, "1.000000000000000055511151231257827021181583404541015625e-01"},
    {1e+00, chars_format::scientific, 0, "1e+00"},
    {1e+01, chars_format::scientific, 0, "1e+01"},
    {1e+02, chars_format::scientific, 0, "1e+02"},
    {1e+03, chars_format::scientific, 0, "1e+03"},
    {1e+04, chars_format::scientific, 0, "1e+04"},
    {1e+05, chars_format::scientific, 0, "1e+05"},
    {1e+06, chars_format::scientific, 0, "1e+06"},
    {1e+07, chars_format::scientific, 0, "1e+07"},
    {1e+08, chars_format::scientific, 0, "1e+08"},
    {1e+09, chars_format::scientific, 0, "1e+09"},
    {1e+10, chars_format::scientific, 0, "1e+10"},
    {1e+11, chars_format::scientific, 0, "1e+11"},
    {1e+12, chars_format::scientific, 0, "1e+12"},
    {1e+13, chars_format::scientific, 0, "1e+13"},
    {1e+14, chars_format::scientific, 0, "1e+14"},
    {1e+15, chars_format::scientific, 0, "1e+15"},
    {1e+16, chars_format::scientific, 0, "1e+16"},
    {1e+17, chars_format::scientific, 0, "1e+17"},
    {1e+18, chars_format::scientific, 0, "1e+18"},
    {1e+19, chars_format::scientific, 0, "1e+19"},
    {1e+20, chars_format::scientific, 0, "1e+20"},
    {1e+21, chars_format::scientific, 0, "1e+21"},
    {1e+22, chars_format::scientific, 0, "1e+22"},
    {1e+23, chars_format::scientific, 22, "9.9999999999999991611392e+22"},
    {1e+24, chars_format::scientific, 23, "9.99999999999999983222784e+23"},
    {1e+25, chars_format::scientific, 25, "1.0000000000000000905969664e+25"},
    {1e+26, chars_format::scientific, 26, "1.00000000000000004764729344e+26"},
    {1e+27, chars_format::scientific, 27, "1.000000000000000013287555072e+27"},
    {1e+28, chars_format::scientific, 27, "9.999999999999999583119736832e+27"},
    {1e+29, chars_format::scientific, 28, "9.9999999999999991433150857216e+28"},
    {1e+30, chars_format::scientific, 30, "1.000000000000000019884624838656e+30"},
    {1e+31, chars_format::scientific, 30, "9.999999999999999635896294965248e+30"},
    {1e+32, chars_format::scientific, 32, "1.00000000000000005366162204393472e+32"},
    {1e+33, chars_format::scientific, 32, "9.99999999999999945575230987042816e+32"},
    {1e+34, chars_format::scientific, 32, "9.99999999999999945575230987042816e+33"},
    {1e+35, chars_format::scientific, 34, "9.9999999999999996863366107917975552e+34"},
    {1e+36, chars_format::scientific, 36, "1.000000000000000042420637374017961984e+36"},
    {1e+37, chars_format::scientific, 36, "9.999999999999999538762658202121142272e+36"},
    {1e+38, chars_format::scientific, 37, "9.9999999999999997748809823456034029568e+37"},
    {1e+39, chars_format::scientific, 38, "9.99999999999999939709166371603178586112e+38"},
    {1e+40, chars_format::scientific, 40, "1.0000000000000000303786028427003666890752e+40"},
    {1e+41, chars_format::scientific, 41, "1.00000000000000000620008645040778319495168e+41"},
    {1e+42, chars_format::scientific, 42, "1.000000000000000044885712678075916785549312e+42"},
    {1e+43, chars_format::scientific, 43, "1.0000000000000000139372116959414099130712064e+43"},
    {1e+44, chars_format::scientific, 44, "1.00000000000000008821361405306422640701865984e+44"},
    {1e+45, chars_format::scientific, 44, "9.99999999999999929757289024535551219930759168e+44"},
    {1e+46, chars_format::scientific, 45, "9.999999999999999931398190359470212947659194368e+45"},
    {1e+47, chars_format::scientific, 47, "1.00000000000000004384584304507619735463404765184e+47"},
    {1e+48, chars_format::scientific, 47, "1.00000000000000004384584304507619735463404765184e+48"},
    {1e+49, chars_format::scientific, 48, "9.999999999999999464902769475481793196872414789632e+48"},
    {1e+50, chars_format::scientific, 49, "1.0000000000000000762976984109188700329496497094656e+50"},
    {1e+51, chars_format::scientific, 50, "9.99999999999999993220948674361627976461708441944064e+50"},
    {1e+52, chars_format::scientific, 50, "9.99999999999999993220948674361627976461708441944064e+51"},
    {1e+53, chars_format::scientific, 50, "9.99999999999999993220948674361627976461708441944064e+52"},
    {1e+54, chars_format::scientific, 54, "1.000000000000000078291540404596243842305360299886116864e+54"},
    {1e+55, chars_format::scientific, 55, "1.0000000000000000102350670204085511496304388135324745728e+55"},
    {1e+56, chars_format::scientific, 56, "1.00000000000000009190283508143378238084034459715684532224e+56"},
    {1e+57, chars_format::scientific, 57, "1.000000000000000048346692115553659057528394845890514255872e+57"},
    {1e+58, chars_format::scientific, 57, "9.999999999999999438119489974413630815797154428513196965888e+57"},
    {1e+59, chars_format::scientific, 58, "9.9999999999999997168788049560464200849936328366177157906432e+58"},
    {1e+60, chars_format::scientific, 59, "9.99999999999999949387135297074018866963645011013410073083904e+59"},
    {1e+61, chars_format::scientific, 59, "9.99999999999999949387135297074018866963645011013410073083904e+60"},
    {1e+62, chars_format::scientific, 62, "1.00000000000000003502199685943161173046080317798311825604870144e+62"},
    {1e+63, chars_format::scientific, 63, "1.000000000000000057857959942726969827393378689175040438172647424e+63"},
    {1e+64, chars_format::scientific, 64, "1.0000000000000000213204190094543968723012578712679649467743338496e+64"},
    {1e+65, chars_format::scientific, 64, "9.9999999999999999209038626283633850822756121694230455365568299008e+64"},
    {1e+66, chars_format::scientific, 65, "9.99999999999999945322333868247445125709646570021247924665841614848e+65"},
    {1e+67, chars_format::scientific, 66, "9.999999999999999827367757839185598317239782875580932278577147150336e+66"},
    {1e+68, chars_format::scientific, 67, "9.9999999999999995280522225138166806691251291352861698530421623488512e+67"},
    {1e+69, chars_format::scientific, 68, "1.00000000000000007253143638152923512615837440964652195551821015547904e+69"},
    {1e+70, chars_format::scientific, 68, "1.00000000000000007253143638152923512615837440964652195551821015547904e+70"},
    {1e+71, chars_format::scientific, 71,
        "1.00000000000000004188152556421145795899143386664033828314342771180699648e+71"},
    {1e+72, chars_format::scientific, 71,
        "9.99999999999999943801810948794571024057224129020550531544123892056457216e+71"},
    {1e+73, chars_format::scientific, 72,
        "9.999999999999999830336967949613257980309080240684656321838454199566729216e+72"},
    {1e+74, chars_format::scientific, 73,
        "9.9999999999999995164818811802792197885196090803013355167206819763650035712e+73"},
    {1e+75, chars_format::scientific, 74,
        "9.99999999999999926539781176481198923508803215199467887262646419780362305536e+74"},
    {1e+76, chars_format::scientific, 76,
        "1.0000000000000000470601344959054695891559601407866630764278709534898249531392e+76"},
    {1e+77, chars_format::scientific, 76,
        "9.9999999999999998278261272554585856747747644714015897553975120217811154108416e+76"},
    {1e+78, chars_format::scientific, 78,
        "1.000000000000000008493621433689702976148869924598760615894999102702796905906176e+78"},
    {1e+79, chars_format::scientific, 78,
        "9.999999999999999673560075006595519222746403606649979913266024618633003221909504e+78"},
    {1e+80, chars_format::scientific, 80,
        "1.00000000000000000026609864708367276537402401181200809098131977453489758916313088e+80"},
    {1e+81, chars_format::scientific, 80,
        "9.99999999999999921281879895665782741935503249059183851809998224123064148429897728e+80"},
    {1e+82, chars_format::scientific, 81,
        "9.999999999999999634067965630886574211027143225273567793680363843427086501542887424e+81"},
    {1e+83, chars_format::scientific, 83,
        "1.00000000000000003080666323096525690777025204007643346346089744069413985291331436544e+83"},
    {1e+84, chars_format::scientific, 84,
        "1.000000000000000057766609898115896702437267127096064137098041863234712334016924614656e+84"},
    {1e+85, chars_format::scientific, 85,
        "1.0000000000000000146306952306748730309700429878646550592786107871697963642511482159104e+85"},
    {1e+86, chars_format::scientific, 85,
        "1.0000000000000000146306952306748730309700429878646550592786107871697963642511482159104e+86"},
    {1e+87, chars_format::scientific, 86,
        "9.99999999999999959416724456350362731491996089648451439669739009806703922950954425516032e+86"},
    {1e+88, chars_format::scientific, 86,
        "9.99999999999999959416724456350362731491996089648451439669739009806703922950954425516032e+87"},
    {1e+89, chars_format::scientific, 88,
        "9.9999999999999999475366575191804932315794610450682175621941694731908308538307845136842752e+88"},
    {1e+90, chars_format::scientific, 89,
        "9.99999999999999966484112715463900049825186092620125502979674597309179755437379230686511104e+89"},
    {1e+91, chars_format::scientific, 90,
        "1.000000000000000079562324861280497143156226140166910515938643997348793075220176113414176768e+91"},
    {1e+92, chars_format::scientific, 92,
        "1.00000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552e+92"},
    {1e+93, chars_format::scientific, 92,
        "1.00000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552e+93"},
    {1e+94, chars_format::scientific, 94,
        "1.0000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328e+94"},
    {1e+95, chars_format::scientific, 94,
        "1.0000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328e+95"},
    {1e+96, chars_format::scientific, 96,
        "1.000000000000000049861653971908893017010268485438462151574892930611988399099305815384459015356416e+96"},
    {1e+97, chars_format::scientific, 97,
        "1.0000000000000000735758738477112498397576062152177456799245857901351759143802190202050679656153088e+97"},
    {1e+98, chars_format::scientific, 97,
        "9.9999999999999999769037024514370800696612547992403838920556863966097586548129676477911932478685184e+97"},
    {1e+99, chars_format::scientific, 98,
        "9.99999999999999967336168804116691273849533185806555472917961779471295845921727862608739868455469056e+98"},
    {1e+100, chars_format::scientific, 100,
        "1.0000000000000000159028911097599180468360808563945281389781327557747838772170381060813469985856815104e+"
        "100"},
    {1e+101, chars_format::scientific, 100,
        "9.9999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688e+"
        "100"},
    {1e+102, chars_format::scientific, 100,
        "9.9999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688e+"
        "101"},
    {1e+103, chars_format::scientific, 103,
        "1."
        "0000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328e+"
        "103"},
    {1e+104, chars_format::scientific, 103,
        "1."
        "0000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328e+"
        "104"},
    {1e+105, chars_format::scientific, 104,
        "9."
        "99999999999999938258300825281978540327027364472124478294416212538871491824599713636820527503908255301632e+"
        "104"},
    {1e+106, chars_format::scientific, 106,
        "1."
        "0000000000000000910359990503684350104604539951754865571545457374840902895351334152154180097541612190564352"
        "e+106"},
    {1e+107, chars_format::scientific, 106,
        "9."
        "9999999999999996881384047029926983435371269061279689406644211752791525136670645395254002395395884805259264"
        "e+106"},
    {1e+108, chars_format::scientific, 108,
        "1."
        "0000000000000000339989917130028245949439747197128980477134307148378752717232008332927416163807334459213086"
        "72e+108"},
    {1e+109, chars_format::scientific, 108,
        "9."
        "9999999999999998185087071883998078647176509643281712479583983698990725543800532982058034243931376762633584"
        "64e+108"},
    {1e+110, chars_format::scientific, 110,
        "1."
        "0000000000000000235693675141702558332495327950568818631299125392682816684661617325983093615924495102623141"
        "0688e+110"},
    {1e+111, chars_format::scientific, 110,
        "9."
        "9999999999999995681977264164181575840510447725837828179539621562288260762111148815394293094743232204474889"
        "0112e+110"},
    {1e+112, chars_format::scientific, 111,
        "9."
        "9999999999999993011993469263043972846733315013897684926158968616472298328309139037619635868942544675772280"
        "34048e+111"},
    {1e+113, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+113"},
    {1e+114, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+114"},
    {1e+115, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+115"},
    {1e+116, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+116"},
    {1e+117, chars_format::scientific, 117,
        "1."
        "0000000000000000505554277259950338142282370308030032790204814747222327639770854058242333771050622192524171"
        "13236701184e+117"},
    {1e+118, chars_format::scientific, 117,
        "9."
        "9999999999999996656499989432737591832415150948634284945877532842287520522749411968203820784902676746951111"
        "55514343424e+117"},
    {1e+119, chars_format::scientific, 118,
        "9."
        "9999999999999994416755247254933381274972870380190006824232035607637985622760311004411949604741731366073618"
        "283536318464e+118"},
    {1e+120, chars_format::scientific, 119,
        "9."
        "9999999999999998000346834739420118166880519289700851818864831183077241462742872546478943492999243975477607"
        "5181077037056e+119"},
    {1e+121, chars_format::scientific, 121,
        "1."
        "0000000000000000373409337471459889719393275754491820381027730410378005080671497101378613371421126415052399"
        "029342192009216e+121"},
    {1e+122, chars_format::scientific, 122,
        "1."
        "0000000000000000144059475872452738558311186224283126301371231493549892706912613162686325762572645608050543"
        "7183296233537536e+122"},
    {1e+123, chars_format::scientific, 122,
        "9."
        "9999999999999997770996973140412967005798429759492157739208332266249129088983988607786655884150763168475752"
        "2070951350501376e+122"},
    {1e+124, chars_format::scientific, 123,
        "9."
        "9999999999999994835318744673121432143947683772820873519605146130849290704870274192525374490890208838852004"
        "22613425626021888e+123"},
    {1e+125, chars_format::scientific, 124,
        "9."
        "9999999999999992486776161899288204254467086983483846143922597222529419997579302660316349376281765375153005"
        "841365553228283904e+124"},
    {1e+126, chars_format::scientific, 124,
        "9."
        "9999999999999992486776161899288204254467086983483846143922597222529419997579302660316349376281765375153005"
        "841365553228283904e+125"},
    {1e+127, chars_format::scientific, 126,
        "9."
        "9999999999999995492910667849794735953002250873835241184796259825178854502911746221543901522980573008687723"
        "77386949310916067328e+126"},
    {1e+128, chars_format::scientific, 126,
        "1."
        "0000000000000000751744869165182086274714290643524082134829091023577659252424152046645411010977580354282659"
        "55038852526326677504e+128"},
    {1e+129, chars_format::scientific, 128,
        "9."
        "9999999999999999821744356418524141598892886875941250043654333972994040190590464949711576614226856000977717"
        "5966751665376232210432e+128"},
    {1e+130, chars_format::scientific, 130,
        "1."
        "0000000000000000597830782460516151851749290252338090708736359498322008205751130936310560341066601403445681"
        "992244323541365884452864e+130"},
    {1e+131, chars_format::scientific, 130,
        "9."
        "9999999999999991202555500957231813912852864969525730182461368558677581576901282770959939099212034754106974"
        "340599870111173348163584e+130"},
    {1e+132, chars_format::scientific, 131,
        "9."
        "9999999999999999082956740236127656368660884998248491198409222651766915166559963620104293398654157036960225"
        "3175829982724989462249472e+131"},
    {1e+133, chars_format::scientific, 133,
        "1."
        "0000000000000000223511723594768599335098409300973759560478836428900264860242343595976203511843100595010152"
        "570837624953702918544949248e+133"},
    {1e+134, chars_format::scientific, 133,
        "9."
        "9999999999999992148203649670699315007549827372972461504375111049848301607660324472857261615145089428049364"
        "457837845490532419930947584e+133"},
    {1e+135, chars_format::scientific, 134,
        "9."
        "9999999999999996182969084181493986344923533627678515144540412345510040405565569067619171016459456036870228"
        "9580532071091311261383655424e+134"},
    {1e+136, chars_format::scientific, 136,
        "1."
        "0000000000000000586640612700740119755462042863897304388093713545509821352053815609504775357961393589804030"
        "375857007499376802103616864256e+136"},
    {1e+137, chars_format::scientific, 137,
        "1."
        "0000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495"
        "0478432243557864849063421149184e+137"},
    {1e+138, chars_format::scientific, 137,
        "1."
        "0000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495"
        "0478432243557864849063421149184e+138"},
    {1e+139, chars_format::scientific, 137,
        "1."
        "0000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495"
        "0478432243557864849063421149184e+139"},
    {1e+140, chars_format::scientific, 140,
        "1."
        "0000000000000000592838012408148700370636248876704532886485007448299957782847398065202329650801812456915179"
        "2237293382948229697163514582401024e+140"},
    {1e+141, chars_format::scientific, 141,
        "1."
        "0000000000000000169762192382389597041410451735731067396306010351159977440672169089582623259562551128794084"
        "54231155599236459402033650892537856e+141"},
    {1e+142, chars_format::scientific, 142,
        "1."
        "0000000000000000508222848402996879704791089448509839788449208028871961714412352270078388372553960191290960"
        "287445781834331294577148468377157632e+142"},
    {1e+143, chars_format::scientific, 143,
        "1."
        "0000000000000000237454323586511053574086579278286821874734649886702374295420205725681776282160832941293459"
        "6913384011607579341316989008157343744e+143"},
    {1e+144, chars_format::scientific, 143,
        "1."
        "0000000000000000237454323586511053574086579278286821874734649886702374295420205725681776282160832941293459"
        "6913384011607579341316989008157343744e+144"},
    {1e+145, chars_format::scientific, 144,
        "9."
        "9999999999999998908706118214091961267848062604013589451800154647253023991102581488541128064576300612966589"
        "28320953898584032761523454337112604672e+144"},
    {1e+146, chars_format::scientific, 145,
        "9."
        "9999999999999993363366729972462242111019694317846182578926003895619873650143420259298512453325054533017777"
        "074930382791057905692427399713177731072e+145"},
    {1e+147, chars_format::scientific, 146,
        "9."
        "9999999999999997799638240565766017436482388946780108077225324496926393922910749242692604942326051396976826"
        "8415537077468838432306731146395363835904e+146"},
    {1e+148, chars_format::scientific, 148,
        "1."
        "0000000000000000489767265751505205795722270035307438887450423745901682635933847561612315292472764637931130"
        "646815102767620534329186625852171022761984e+148"},
    {1e+149, chars_format::scientific, 148,
        "1."
        "0000000000000000489767265751505205795722270035307438887450423745901682635933847561612315292472764637931130"
        "646815102767620534329186625852171022761984e+149"},
    {1e+150, chars_format::scientific, 149,
        "9."
        "9999999999999998083559617243737459057312001403031879309116481015410011220367858297629826861622115196270206"
        "0266176005440567032331208403948233373515776e+149"},
    {1e+151, chars_format::scientific, 151,
        "1."
        "0000000000000000171775323872177191180393104084305455107732328445200031262781885420082626742861173182722545"
        "959543542834786931126445173006249634549465088e+151"},
    {1e+152, chars_format::scientific, 152,
        "1."
        "0000000000000000462510813590419947400122627239507268849188872720127255375377965092338341988220342513198966"
        "2450489690590919397689516441796634752009109504e+152"},
    {1e+153, chars_format::scientific, 152,
        "9."
        "9999999999999999973340300412315374485553901911843668628584018802436967952242376167291975956456715844366937"
        "8824028710020392594094129030220133015859757056e+152"},
    {1e+154, chars_format::scientific, 154,
        "1."
        "0000000000000000369475456880582265409809179829842688451922778552150543659347219597216513109705408327446511"
        "753687232667314337003349573404171046192448274432e+154"},
    {1e+155, chars_format::scientific, 155,
        "1."
        "0000000000000000071762315409101683040806148118916031180671277214625066168048834012826660698457618933038657"
        "3813296762136260081534229469225952733653677113344e+155"},
    {1e+156, chars_format::scientific, 155,
        "9."
        "9999999999999998335918022319172171456037227501747053636700761446046841750101255453147787694593874175123738"
        "8344363105067534507348164573733465510370326085632e+155"},
    {1e+157, chars_format::scientific, 155,
        "9."
        "9999999999999998335918022319172171456037227501747053636700761446046841750101255453147787694593874175123738"
        "8344363105067534507348164573733465510370326085632e+156"},
    {1e+158, chars_format::scientific, 157,
        "9."
        "9999999999999995287335453651211007997446182781858083179085387749785952239205787068995699003416510776387310"
        "061494932420984963311567802202010637287727642443776e+157"},
    {1e+159, chars_format::scientific, 158,
        "9."
        "9999999999999992848469398716842077230573347005946906812993088792777240630489412361674028050474620057398167"
        "0431418299523701733729688780649419062882836695482368e+158"},
    {1e+160, chars_format::scientific, 160,
        "1."
        "0000000000000000065284077450682265568456642148886267118448844545520511777838181142510337509988867035816342"
        "470187175785193750117648543530356184548650438281396224e+160"},
    {1e+161, chars_format::scientific, 161,
        "1."
        "0000000000000000377458932482281488706616365128202897693308658812017626863753877105047511391965429047846952"
        "7765363729011764432297892058199009821165792668120252416e+161"},
    {1e+162, chars_format::scientific, 161,
        "9."
        "9999999999999993784993963811639746645052515943896798537572531592268585888236500249285549696404306093489997"
        "9621894213003182527093908649335762989920701551401238528e+161"},
    {1e+163, chars_format::scientific, 161,
        "9."
        "9999999999999993784993963811639746645052515943896798537572531592268585888236500249285549696404306093489997"
        "9621894213003182527093908649335762989920701551401238528e+162"},
    {1e+164, chars_format::scientific, 164,
        "1."
        "0000000000000000017833499485879183651456364256030139271070152777012950284778995356204687079928429609987689"
        "7036220978235643807646031628623453753183252563447406133248e+164"},
    {1e+165, chars_format::scientific, 164,
        "9."
        "9999999999999989948989345183348492723345839974054042033695133885552035712504428261628757034676312089657858"
        "5177704871391229197474064067196498264773607101557544845312e+164"},
    {1e+166, chars_format::scientific, 165,
        "9."
        "9999999999999994040727605053525830239832961008552982304497691439383022566618638381796002540519505693745473"
        "92515068357773127490685649548117139715971745147241514401792e+165"},
    {1e+167, chars_format::scientific, 167,
        "1."
        "0000000000000000386089942874195144027940205149135043895442382956857739101649274267019739175454317034355575"
        "0902863155030391327289536708508823166797373630632400726786048e+167"},
    {1e+168, chars_format::scientific, 167,
        "9."
        "9999999999999993386049483474297456237195021643033151861169282230770064669960364762569243259584594717091455"
        "4599698521475539380813444812793279458505403728617494385000448e+167"},
    {1e+169, chars_format::scientific, 167,
        "9."
        "9999999999999993386049483474297456237195021643033151861169282230770064669960364762569243259584594717091455"
        "4599698521475539380813444812793279458505403728617494385000448e+168"},
    {1e+170, chars_format::scientific, 170,
        "1."
        "0000000000000000344190543093124528091771377029741774747069364767506509796263144755389226581474482731849717"
        "9085147422915077831721209019419643357959500300321574675254607872e+170"},
    {1e+171, chars_format::scientific, 170,
        "9."
        "9999999999999995397220672965687021173298771373910070983074155319629071328494581320833847770616641237372600"
        "1850053663010587168093173889073910282723323583537144858509574144e+170"},
    {1e+172, chars_format::scientific, 172,
        "1."
        "0000000000000000826871628571058023676436276965152235336326534308832671394311356729372731664122173896717192"
        "642523265688348930066834399772699475577180106550229078889679814656e+172"},
    {1e+173, chars_format::scientific, 173,
        "1."
        "0000000000000000140391862557997052178246197057012913609383004294502130454865010810818413324356568684461228"
        "5763778101906192989276863139689872767772084421689716760605683089408e+173"},
    {1e+174, chars_format::scientific, 174,
        "1."
        "0000000000000000689575675368445829376798260983524370990937828305966563206422087545661867996169052854265999"
        "82929417458880300383900478261195703581718577367397759832385751351296e+174"},
    {1e+175, chars_format::scientific, 174,
        "9."
        "9999999999999993715345246233687641002733075598968732752062506784519246026851033820375767838190908467345488"
        "22294900033162112051840457868829614121240178061963384891963422539776e+174"},
    {1e+176, chars_format::scientific, 176,
        "1."
        "0000000000000000074489805020743198914419949385831538723596425413126398524678161602637198763739070584084656"
        "0260278464628372543383280977318309056924111623883709653889736043921408e+176"},
    {1e+177, chars_format::scientific, 176,
        "1."
        "0000000000000000074489805020743198914419949385831538723596425413126398524678161602637198763739070584084656"
        "0260278464628372543383280977318309056924111623883709653889736043921408e+177"},
    {1e+178, chars_format::scientific, 178,
        "1."
        "0000000000000000524381184475062837195473800154429724610566137243318061834753718863820956830887857615988724"
        "636416932177829345401680187244151732297960592357271816907060120777654272e+178"},
    {1e+179, chars_format::scientific, 178,
        "9."
        "9999999999999998045549773481514159457876389246726271914145983150114005386328272459269439234497983649422148"
        "597943950338419997003168440244384097290815044070304544781216945608327168e+178"},
    {1e+180, chars_format::scientific, 180,
        "1."
        "0000000000000000092485460198915984445662103416575466159075213886334065057081183893084549086425022065360818"
        "77044340989143693798086218131232373875663313958712699944969706504756133888e+180"},
    {1e+181, chars_format::scientific, 180,
        "9."
        "9999999999999991711079150764693652460638170424863814625612440581015385980464426221802125649043062240212862"
        "56366562347133135483117101991090685868467907010818055540655879490029748224e+180"},
    {1e+182, chars_format::scientific, 182,
        "1."
        "0000000000000000645311987272383955965421075241028916976983595783273580932502028655627150999337451570164538"
        "2788895184180192194795092289050635704895322791329123657951217763820802932736e+182"},
    {1e+183, chars_format::scientific, 182,
        "9."
        "9999999999999994659487295156522833899352686821948885654457144031359470649375598288696002517909352932499366"
        "6087115356131035228239552737388526279268078143523691759154905886843985723392e+182"},
    {1e+184, chars_format::scientific, 184,
        "1."
        "0000000000000000173566684169691286935226752617495305612368443231218527385476241124924130700318845059398697"
        "631682172475335672600663748292592247410791680053842186513692689376624118857728e+184"},
    {1e+185, chars_format::scientific, 184,
        "9."
        "9999999999999997961704416875371517110712945186684165206763211895744845478556111003617144611039598507860251"
        "139162957211888350975873638026151889477992007905860430885494197722591793250304e+184"},
    {1e+186, chars_format::scientific, 184,
        "9."
        "9999999999999997961704416875371517110712945186684165206763211895744845478556111003617144611039598507860251"
        "139162957211888350975873638026151889477992007905860430885494197722591793250304e+185"},
    {1e+187, chars_format::scientific, 186,
        "9."
        "9999999999999990715696561218012120806928149689207894646274468696179222996240014532018752818113802502496938"
        "79805812353226907091680705581859236698853640605134247712274342131878495422251008e+186"},
    {1e+188, chars_format::scientific, 188,
        "1."
        "0000000000000000230930913026978715489298382248516992754305645781548421896794576888657617968679507611107823"
        "8543825857419659919011313587350687602971665369018571203143144663564875896666980352e+188"},
    {1e+189, chars_format::scientific, 188,
        "1."
        "0000000000000000230930913026978715489298382248516992754305645781548421896794576888657617968679507611107823"
        "8543825857419659919011313587350687602971665369018571203143144663564875896666980352e+189"},
    {1e+190, chars_format::scientific, 190,
        "1."
        "0000000000000000725591715973187783610303424287811372824568343983972101724920689074452068181743241951740625"
        "976868675721161334753163637413771490365780039321792212624518252692320803210995433472e+190"},
    {1e+191, chars_format::scientific, 190,
        "1."
        "0000000000000000725591715973187783610303424287811372824568343983972101724920689074452068181743241951740625"
        "976868675721161334753163637413771490365780039321792212624518252692320803210995433472e+191"},
    {1e+192, chars_format::scientific, 192,
        "1."
        "0000000000000000409008802087613980012860197382662969579600217134420946634919977275543620045382451973735632"
        "61847757813447631532786297905940174312186739777303375354598782943738754654264509857792e+192"},
    {1e+193, chars_format::scientific, 193,
        "1."
        "0000000000000000662275133196073022890814778906781692175574718614061870706920546714670378554471083956139627"
        "305190456203824330868103505742897540916997511012040520808812168041334151877325366493184e+193"},
    {1e+194, chars_format::scientific, 193,
        "9."
        "9999999999999994465967438754696170766327875910118237148971115117854351613178134068619377108456504406004528"
        "089686414709538562749489776621177115003729674648080379472553427423904462708600804999168e+193"},
    {1e+195, chars_format::scientific, 194,
        "9."
        "9999999999999997707776476942971919604146519418837886377444734057258179734785422889441886024790993780775660"
        "0796112539971931616645685181699233267813951241073670004367049615544210109925082343145472e+194"},
    {1e+196, chars_format::scientific, 195,
        "9."
        "9999999999999995114329246392351320533891604611862166994665838905735117237499591832783878891723402280958754"
        "48767138256706948253250552493092635735926276453993770366538373425000777236538229086224384e+195"},
    {1e+197, chars_format::scientific, 195,
        "9."
        "9999999999999995114329246392351320533891604611862166994665838905735117237499591832783878891723402280958754"
        "48767138256706948253250552493092635735926276453993770366538373425000777236538229086224384e+196"},
    {1e+198, chars_format::scientific, 198,
        "1."
        "0000000000000000175355415660194005415374418651772000861457981049363415723055131933782837715237643652049003"
        "28030374534281861011105867876227585990799216050325567033999660761493056632508247061001404416e+198"},
    {1e+199, chars_format::scientific, 199,
        "1."
        "0000000000000000972062404885344653449756728480474941855847657639911300522221339234388177506516007760792756"
        "678147673846152604340428430285295728914471221362369950308146488642846313231335560438561636352e+199"},
    {1e+200, chars_format::scientific, 199,
        "9."
        "9999999999999996973312221251036165947450327545502362648241750950346848435554075534196338404706251868027512"
        "415973882408182135734368278484639385041047239877871023591066789981811181813306167128854888448e+199"},
    {1e+201, chars_format::scientific, 201,
        "1."
        "0000000000000000377187852930565502917417937141710079246703365785635546538843904449936190462361495892930754"
        "14109087389699655531583234914810756005630018925423128793192791080866922220799992003324610084864e+201"},
    {1e+202, chars_format::scientific, 200,
        "9."
        "9999999999999990174745913196417302720721283673903932829449844044338231482669106569030772185797544806747483"
        "4210390258463987183104130654882031695190925872134291678628544718769301415466131339252487684096e+201"},
    {1e+203, chars_format::scientific, 202,
        "9."
        "9999999999999998876910787506329447650934459829549922997503484884029261182361866844442696946000689845185920"
        "534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752e+202"},
    {1e+204, chars_format::scientific, 202,
        "9."
        "9999999999999998876910787506329447650934459829549922997503484884029261182361866844442696946000689845185920"
        "534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752e+203"},
    {1e+205, chars_format::scientific, 205,
        "1."
        "0000000000000000166160354728550133402860267619935663985128064995273039068626355013257451286926569625748622"
        "041088095949318798038992779336698179926498716835527012730124200454693714718121768282606166882648064e+205"},
    {1e+206, chars_format::scientific, 206,
        "1."
        "0000000000000000388935775510883884313073724929520201333430238200769129428938489676307996560787770138732646"
        "0311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552e+"
        "206"},
    {1e+207, chars_format::scientific, 206,
        "1."
        "0000000000000000388935775510883884313073724929520201333430238200769129428938489676307996560787770138732646"
        "0311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552e+"
        "207"},
    {1e+208, chars_format::scientific, 207,
        "9."
        "9999999999999998186306983081094819829272742169837857217766747946991381065394249388986006597030968254935446"
        "16522696356805028364441642842329313746550197144253860793660984920822957311285732475861572950035529728e+"
        "207"},
    {1e+209, chars_format::scientific, 209,
        "1."
        "0000000000000000731118821832548525711161595357042050700422376244411124222377928518753634101438574126676106"
        "8799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832e+"
        "209"},
    {1e+210, chars_format::scientific, 209,
        "9."
        "9999999999999992711378241934460557459866815329488267345892539248719464370363227909855805946618104447840072"
        "5843812838336795121561031396504666917998514458446354143529431921823271795036250068185162804696593727488e+"
        "209"},
    {1e+211, chars_format::scientific, 210,
        "9."
        "9999999999999995631340237212665497390216642977674715277558783887797819941046439365391912960171631811624271"
        "82749897969201059028320356032930746282153172616351711759756540926280845609521557638656931995269719916544e+"
        "210"},
    {1e+212, chars_format::scientific, 211,
        "9."
        "9999999999999990959401044767537593501656918740576398586892792465272451027953301036534141738485988029569553"
        "038510666318680865279842887243162229186843277653306392406169861934038413548670665077684456779836676898816e"
        "+211"},
    {1e+213, chars_format::scientific, 212,
        "9."
        "9999999999999998434503752679742239723352477519933705291958378741313041288902322362706575693183018080857103"
        "1008919677160084252852199641809946030023447952696435527124027376600704816231425231719002378564135125254144"
        "e+212"},
    {1e+214, chars_format::scientific, 213,
        "9."
        "9999999999999995444462669514860381234674254008190782609932144230896805184522713832237602111304206060342083"
        "0759394471570774012830691334058616534761441882231086885899095873696576543933537799342139254257827782747750"
        "4e+213"},
    {1e+215, chars_format::scientific, 214,
        "9."
        "9999999999999990660396936451049407652789096389402106318690169014230827417515340183487244380298106827518051"
        "0360154142627877628796278041656489342342232169486529059939205469049971308256917907539158255367736034737520"
        "64e+214"},
    {1e+216, chars_format::scientific, 216,
        "1."
        "0000000000000000214215469580419574424931347467449492941767090953422917405833303694048810293471274498629572"
        "7931833093209082895047886994342159460414833548007346784224294244020182387388080564786631265270395622996207"
        "2064e+216"},
    {1e+217, chars_format::scientific, 216,
        "9."
        "9999999999999996018550557482517698064500472922445423764881181256896722516563598670087645039024937968280966"
        "9207303311043921578914820929146871797851747047760433825014282722254169172214732186358496974124638792508977"
        "9712e+216"},
    {1e+218, chars_format::scientific, 217,
        "1."
        "0000000000000000826575883412587379043412647642654443507046063781156162560010247521088856083040055200431048"
        "8942935855313773632204291895769631741044492391238650185947160215814947857554687910937412833128327366741516"
        "61568e+218"},
    {1e+219, chars_format::scientific, 218,
        "9."
        "9999999999999996508438888548251941759285513062609384217104359519083318639905153731719681670679962529722147"
        "8016185520727674168639944850288849622355474122345476546392575499689981548348018063279122228410984187505225"
        "498624e+218"},
    {1e+220, chars_format::scientific, 219,
        "9."
        "9999999999999999643724207368951101405909769959658731111332700397077533829291106126164716113272119722945705"
        "4393031662703690742880737945597507699179327399689749963213649275279180755601047675571123855843594715481209"
        "6741376e+219"},
    {1e+221, chars_format::scientific, 221,
        "1."
        "0000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339"
        "7659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278"
        "435495936e+221"},
    {1e+222, chars_format::scientific, 221,
        "1."
        "0000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339"
        "7659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278"
        "435495936e+222"},
    {1e+223, chars_format::scientific, 221,
        "1."
        "0000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339"
        "7659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278"
        "435495936e+223"},
    {1e+224, chars_format::scientific, 223,
        "9."
        "9999999999999996954903517948319502092964807244749211214842475260109694882873713352688654575305085714037182"
        "4092248411345058928811833787060802532495190829039301080947896405333883515460849480069503260157387926689005"
        "64521713664e+223"},
    {1e+225, chars_format::scientific, 224,
        "9."
        "9999999999999992845422344863652699560941461244648691253639504304505117149841757830241659030710693437735200"
        "9423588636134254484622941461177838218040629861358615028052178586193608330530158506646130887048916655460323"
        "666687950848e+224"},
    {1e+226, chars_format::scientific, 225,
        "9."
        "9999999999999996133007283331386141586560138044729107222601881068988779336267322248199255466386207258776786"
        "1158516456302898039974055321884209669604278635503163870368752841505828478474711285384828785535693672443269"
        "2495112994816e+225"},
    {1e+227, chars_format::scientific, 225,
        "1."
        "0000000000000000928334703720231990968903484524505077109845138812692342808196957992002964120908826254294312"
        "6809822773697747226137851076470969547585887373208135923963504986275470907025292240033962037948280174037505"
        "1580804694016e+227"},
    {1e+228, chars_format::scientific, 227,
        "9."
        "9999999999999992450912152247524686517867220028639041337364019092767077687470690100086747458429631779210210"
        "7215397297714017257980807797893073643852992008461269166974189675556141912776812173197487139230503413422370"
        "196749149011968e+227"},
    {1e+229, chars_format::scientific, 228,
        "9."
        "9999999999999999183886106229442775786334270115203733241798966706429617845270246028063904958693084084703377"
        "1568529473419399259339888984619722376655344697909305196038533750435568775767256264054340435331422744203442"
        "7503713670135808e+228"},
    {1e+230, chars_format::scientific, 230,
        "1."
        "0000000000000000995664443260051171861588155025370724028889488288828968209774953551282735695911460777349244"
        "3453354095454801046151441888338236034913910900102616284254148427024265175655196680942530570909289367345315"
        "883616691581616128e+230"},
    {1e+231, chars_format::scientific, 231,
        "1."
        "0000000000000000564754110205208414148406263819830583747005651641554565639675781971892197615894599829797681"
        "6934753636209656598064460692387730516014560327977941978394030406231981856423808259127691959958830530175327"
        "2401848696295129088e+231"},
    {1e+232, chars_format::scientific, 231,
        "1."
        "0000000000000000564754110205208414148406263819830583747005651641554565639675781971892197615894599829797681"
        "6934753636209656598064460692387730516014560327977941978394030406231981856423808259127691959958830530175327"
        "2401848696295129088e+232"},
    {1e+233, chars_format::scientific, 232,
        "9."
        "9999999999999997374062707399103193390970327051935144057886852787877127050853725394623645022622268104986814"
        "0190407544589792577374567961627599197278072294985673111426038063107978834995424892432018269339495628089490"
        "44795771481474727936e+232"},
    {1e+234, chars_format::scientific, 234,
        "1."
        "0000000000000000178658451788069303237395289299666618054437734005596700936866924236758275496199492420791481"
        "5574087624726007172578525540816077571080742215354233800343364659602096002392484233181596564547219412071017"
        "4156699571604284243968e+234"},
    {1e+235, chars_format::scientific, 235,
        "1."
        "0000000000000000531660196626596490356033894575245100973356972987043891522292165594595004291349304909025721"
        "6818125120939629504451380536538731692163090204038766991703973342235134497506837628332312354637835291480672"
        "11236930570359138156544e+235"},
    {1e+236, chars_format::scientific, 235,
        "1."
        "0000000000000000531660196626596490356033894575245100973356972987043891522292165594595004291349304909025721"
        "6818125120939629504451380536538731692163090204038766991703973342235134497506837628332312354637835291480672"
        "11236930570359138156544e+236"},
    {1e+237, chars_format::scientific, 235,
        "9."
        "9999999999999994020546131433094915763903576933939556328154082464128816489313932495174721468699049466761532"
        "8372051330560380424582445502262385046995766402482607793500255578094113131409067638500218263478644773697770"
        "82931390365469918625792e+236"},
    {1e+238, chars_format::scientific, 238,
        "1."
        "0000000000000000486475973287265010404848153099971055159735310397418651127357734700791903005570128910531738"
        "9458888321424285845971655097086231964664549661487146743209815430858105570132200393753020733506236458916236"
        "31119178909006652304785408e+238"},
    {1e+239, chars_format::scientific, 238,
        "9."
        "9999999999999999081179145438220670296706622164632687453780292502155740721970192601122065475966761298087599"
        "2606572876278870174311694720942354526832307168264075624845941652321352997368437911380879830217714020914580"
        "56119576436948334022754304e+238"},
    {1e+240, chars_format::scientific, 240,
        "1."
        "0000000000000000139461138041199244379741658569866383311120941709096804894261305436384085130786057242097951"
        "5339949701146446548847363722091034057475758294690703234774682671482523407894986432184061083215557424821369"
        "3581484614981956096327942144e+240"},
    {1e+241, chars_format::scientific, 241,
        "1."
        "0000000000000000509610295637002728139855252735311366616309601643306774209564163318419090863889067021760658"
        "1066817562776141799113274522085911825143802419273576310438824281483144380948014657857618043525615061189227"
        "44139467759619125060885807104e+241"},
    {1e+242, chars_format::scientific, 241,
        "1."
        "0000000000000000509610295637002728139855252735311366616309601643306774209564163318419090863889067021760658"
        "1066817562776141799113274522085911825143802419273576310438824281483144380948014657857618043525615061189227"
        "44139467759619125060885807104e+242"},
    {1e+243, chars_format::scientific, 243,
        "1."
        "0000000000000000746505756498316957746327953001196155931630344001201154571357992362921494533074993280744790"
        "3132012994219146759283457434082633596451350659006615078863874911883541803701952722288694498124051948464656"
        "6146722558989084608335389392896e+243"},
    {1e+244, chars_format::scientific, 243,
        "1."
        "0000000000000000746505756498316957746327953001196155931630344001201154571357992362921494533074993280744790"
        "3132012994219146759283457434082633596451350659006615078863874911883541803701952722288694498124051948464656"
        "6146722558989084608335389392896e+244"},
    {1e+245, chars_format::scientific, 245,
        "1."
        "0000000000000000443279566595834743850042896660863625608019793783096347708261891185958417836517007669245101"
        "0888562841972100410265623306726829729177688912148325455279810104971033102576911999816916636238052732752107"
        "272876955671430431745947427930112e+245"},
    {1e+246, chars_format::scientific, 246,
        "1."
        "0000000000000000685860518517820514967070941733129649866908233957580193198738772127528879193763396158444852"
        "4683322963769737489479890608611472822996618309634957154147061950501040063476944577794338925746852105322146"
        "7463131958534128550160206370177024e+246"},
    {1e+247, chars_format::scientific, 246,
        "9."
        "9999999999999995214719492922888136053363253862527334242437211200577348444497436079906646789807314102860458"
        "4684743791410795092514075595651859726657572016991249995842530919570066511567882035027119361046151169859572"
        "7381924297989722331966923339726848e+246"},
    {1e+248, chars_format::scientific, 248,
        "1."
        "0000000000000000452982804672714174694724018463754266578375331390075701527880966423621236290806863208813091"
        "1440353246844005893434193998802215452930446088047790723234500178792233381012913302936013527818404707654908"
        "851814405278709728676750356293615616e+248"},
    {1e+249, chars_format::scientific, 247,
        "9."
        "9999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640"
        "8111814232401040478571454131528428125775275729162364250341707296785977412047465036916114055333519200963067"
        "47820855546959721533975525765152768e+248"},
    {1e+250, chars_format::scientific, 247,
        "9."
        "9999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640"
        "8111814232401040478571454131528428125775275729162364250341707296785977412047465036916114055333519200963067"
        "47820855546959721533975525765152768e+249"},
    {1e+251, chars_format::scientific, 251,
        "1."
        "0000000000000000482791152044887786249584424642234315639307542918716276461750765553721414582385299426365956"
        "5935453370610499537728043164857800396298916132410948026391308085570960636368309306117879178753245974556315"
        "302310250472271728848176952226298724352e+251"},
    {1e+252, chars_format::scientific, 252,
        "1."
        "0000000000000000991520280529984090119202023421627152945883953007515421999795337374097790758657277539268193"
        "5985162149558657733676402265539783429787471556208832666934163027927905794433734427088386288041203596340318"
        "7241060084423965317738575228107571068928e+252"},
    {1e+253, chars_format::scientific, 252,
        "9."
        "9999999999999993635870693776759177364257073275700735648394407233581562780527075488933869945869475779810351"
        "8260940569245515066416531433574377226240942000556018171970272123856812886243740399827635383197392066315077"
        "7435958293799716241167969694049028276224e+252"},
    {1e+254, chars_format::scientific, 252,
        "9."
        "9999999999999993635870693776759177364257073275700735648394407233581562780527075488933869945869475779810351"
        "8260940569245515066416531433574377226240942000556018171970272123856812886243740399827635383197392066315077"
        "7435958293799716241167969694049028276224e+253"},
    {1e+255, chars_format::scientific, 254,
        "9."
        "9999999999999998845256969464145328989141284776683389667736846542884813090103490929587961990894531655929258"
        "7569958465674654992927728624557883489163749540246356891129106733591931304833693638565628182306078113383272"
        "782784390994049606075766012189756664840192e+254"},
    {1e+256, chars_format::scientific, 256,
        "1."
        "0000000000000000301276599001405425028904865397746951288321079799032741333776462328211123562691457635682438"
        "4301717278281796693413668637734468849950199557199862786645617442138002603970565622955602242159302695103782"
        "88141352402853119916429412464176397346144256e+256"},
    {1e+257, chars_format::scientific, 256,
        "1."
        "0000000000000000301276599001405425028904865397746951288321079799032741333776462328211123562691457635682438"
        "4301717278281796693413668637734468849950199557199862786645617442138002603970565622955602242159302695103782"
        "88141352402853119916429412464176397346144256e+257"},
    {1e+258, chars_format::scientific, 258,
        "1."
        "0000000000000000567997176316599595992098937026597263174111412691669067749626774798772613075396740496539726"
        "4650338994578968657651041933912824370611847303232008129066549774156440667002371228778987473473667420713674"
        "4674199783831719918405933396323484899269935104e+258"},
    {1e+259, chars_format::scientific, 258,
        "9."
        "9999999999999992877384052036675753687673932081157661223178148070147009535452749400774634144113827644247438"
        "9769547563525432293116501122567178714359381222777104854460745804679379644497043208267383631647167377861948"
        "5458899748089618699435710767754281089234894848e+258"},
    {1e+260, chars_format::scientific, 260,
        "1."
        "0000000000000000653347761057461730700321039947829362977564319217312692202698874789352289719462431012014058"
        "6361897943794063686207001388689898137223574581962294638641248120402340847172549022642470747494264132908839"
        "774942043776657045497009088429335535195969814528e+260"},
    {1e+261, chars_format::scientific, 258,
        "9."
        "9999999999999992877384052036675753687673932081157661223178148070147009535452749400774634144113827644247438"
        "9769547563525432293116501122567178714359381222777104854460745804679379644497043208267383631647167377861948"
        "5458899748089618699435710767754281089234894848e+260"},
    {1e+262, chars_format::scientific, 262,
        "1."
        "0000000000000000161728392950095834780961727121532468109675577629605415353003578843613352249644053642881905"
        "3303318396315116321724674929173953241540025456475844343490985646025955809392324929988807089135627070664687"
        "60361494711018313643605437535869015444666630275072e+262"},
    {1e+263, chars_format::scientific, 262,
        "1."
        "0000000000000000161728392950095834780961727121532468109675577629605415353003578843613352249644053642881905"
        "3303318396315116321724674929173953241540025456475844343490985646025955809392324929988807089135627070664687"
        "60361494711018313643605437535869015444666630275072e+263"},
    {1e+264, chars_format::scientific, 264,
        "1."
        "0000000000000000441405189028952877792863913973825812745630061732834443960830236092744836676918508323988196"
        "9887754761103139711296842870587468559973333403419247178065357187004521519773963524920669081446318377185805"
        "2833032509915549602573975010166573043840478561173504e+264"},
    {1e+265, chars_format::scientific, 265,
        "1."
        "0000000000000000665146625892038512202385663455660488454393649015417666847091561892050024218738072068873230"
        "3155303852933558422954577223718280814719979760973969445724854419787374088079274400866158675294871422402699"
        "42705389409665241931447200154303102433395309881065472e+265"},
    {1e+266, chars_format::scientific, 266,
        "1."
        "0000000000000000307160326911101497147150864284725007320371909363284510229073440613161724151826770077057176"
        "9927225306004888484302202258708981207125345588886413817469658847334809978790776999353375325137186550055668"
        "797052865128496484823152800700833072414104710501367808e+266"},
    {1e+267, chars_format::scientific, 266,
        "9."
        "9999999999999997343822485416022730587751856112282375059371259198714596402444465669404440447686868901514916"
        "7622996309190165824584023146941018349739309135463248122613459314107074039291811569329219648848907543004197"
        "890512187794469896370420793533163493423472892065087488e+266"},
    {1e+268, chars_format::scientific, 266,
        "9."
        "9999999999999997343822485416022730587751856112282375059371259198714596402444465669404440447686868901514916"
        "7622996309190165824584023146941018349739309135463248122613459314107074039291811569329219648848907543004197"
        "890512187794469896370420793533163493423472892065087488e+267"},
    {1e+269, chars_format::scientific, 269,
        "1."
        "0000000000000000467538188854561279891896054313304102868413648727440164393945558946103682581803033369390768"
        "8813404495028932616818466243033147431327741697981638738927986463793558699752023835231102266007829372867138"
        "519293326106230343475263802678137754874196788463928344576e+269"},
    {1e+270, chars_format::scientific, 269,
        "1."
        "0000000000000000467538188854561279891896054313304102868413648727440164393945558946103682581803033369390768"
        "8813404495028932616818466243033147431327741697981638738927986463793558699752023835231102266007829372867138"
        "519293326106230343475263802678137754874196788463928344576e+270"},
    {1e+271, chars_format::scientific, 270,
        "9."
        "9999999999999995290985852539737511455013423746469952044436995337522223092081351007747372543990698759644940"
        "5879902689682400928375844147591690679948638939044369127946865823435090410987852070094314805704679411017385"
        "4458342872794765056233999682236635579342942941443126198272e+270"},
    {1e+272, chars_format::scientific, 272,
        "1."
        "0000000000000000655226109574678785641174996701035524401207638566177752810893043715169471647283826068076023"
        "8458487340241071121614642608687943103994317258797079104154646440083568631482671560875436423095301659220218"
        "514235305581886882057848563849292034690350260273827761094656e+272"},
    {1e+273, chars_format::scientific, 272,
        "9."
        "9999999999999994540234169659267488457897654195544265913261035982571869424291411931484216282067527964903920"
        "7299571308833846909191138684972507989282336695782607667040225918275050684065261167516978177354790265605065"
        "466066369376850351293060923539046438669680406904714953752576e+272"},
    {1e+274, chars_format::scientific, 273,
        "9."
        "9999999999999992137828784441763414867127191632582070293497966046730737687363606887442116243913381421732657"
        "1842510890118474047800081204591123379150169517344970992138978221762923557912970279269500966635145000285641"
        "5308090320884466574359759805482716570229159677380024223137792e+273"},
    {1e+275, chars_format::scientific, 274,
        "9."
        "9999999999999995981677400789769932612359931733321583285118877944076548466448094957909476304960015890806678"
        "8573807560063070626025773173201338755361637002845189671980974536182326959756635700465464503786577424796719"
        "82722077174989256760731188933351130765773907040474247261585408e+274"},
    {1e+276, chars_format::scientific, 276,
        "1."
        "0000000000000000520691408002498557520091850797509641446500906649770649433625086632703114045147193861658433"
        "0872891956793010241376743389786585565826915896804571450360176569078889512418143271133577699295001524362330"
        "7738608946937362752018518070418086469181314516804918593340833792e+276"},
    {1e+277, chars_format::scientific, 277,
        "1."
        "0000000000000000028678785109953723248702060064614983783573429926910385653902272159683291957333224649616958"
        "3131285983040101879363854817804477997671848058660543459340401040833205876982154097220494366539618174024912"
        "75192019201707119869992081071729797163687409453914913289541779456e+277"},
    {1e+278, chars_format::scientific, 277,
        "9."
        "9999999999999996350686867959178558315902274782992576532314485486221746301240205812674342870820492799837784"
        "9380012040377751897535439602187919431477937881453210665245806182366589686333627580900277003353114937549783"
        "34367629875739137498376013657689431411868208826074951744485326848e+277"},
    {1e+279, chars_format::scientific, 279,
        "1."
        "0000000000000000579732922749603937632658625685457000366052203856513881087191824369465492695684870167103410"
        "0601884673643359244818290018424438474005524037381854809282549632468371548670461972003147699225647526402820"
        "9364937790149360843820835266007499279518823345374529865067232493568e+279"},
    {1e+280, chars_format::scientific, 280,
        "1."
        "0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174"
        "9758182415081870163467691069569599399110129304252112477880424562006581527327235514959649032854891251030062"
        "90926013924448356521309485648260046220787856768108551057012647002112e+280"},
    {1e+281, chars_format::scientific, 280,
        "1."
        "0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174"
        "9758182415081870163467691069569599399110129304252112477880424562006581527327235514959649032854891251030062"
        "90926013924448356521309485648260046220787856768108551057012647002112e+281"},
    {1e+282, chars_format::scientific, 280,
        "1."
        "0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174"
        "9758182415081870163467691069569599399110129304252112477880424562006581527327235514959649032854891251030062"
        "90926013924448356521309485648260046220787856768108551057012647002112e+282"},
    {1e+283, chars_format::scientific, 282,
        "9."
        "9999999999999995539535177353613442742718210189113128122905730261845401023437984959874943383966870598097727"
        "9663290767809757055586510986875337610314766840775440358130963455479625817608438389220211297639279730849502"
        "4959839786965342632596166187964530344229899589832462449290116390191104e+282"},
    {1e+284, chars_format::scientific, 284,
        "1."
        "0000000000000000792143825084576765412568191916997109340838993423344357589751710277254453455720576452975216"
        "2833294418062406838213115052098838781957320876356853543120821491881752894667070520582225774709469217797130"
        "505057184069381648545374773244373557467226310750742042216461653692645376e+284"},
    {1e+285, chars_format::scientific, 284,
        "9."
        "9999999999999998015915792052044285019310951985284721180002571056165035998253808522408861618614649384428614"
        "9397221450372619320895438893697947652166455225334059372746413748147206443420891752540620587530362220273863"
        "006901551095990707698442841525909542472844588688081080376132618600579072e+284"},
    {1e+286, chars_format::scientific, 286,
        "1."
        "0000000000000000329886110340869674854270880115045078636847583141738025727786089878914788718586324412860117"
        "3816294023984005882022115176158618240811672377905911327059270770583804511182079226095749373929800486437916"
        "54301923722148311225012721166820834263125344653917287293299907083743789056e+286"},
    {1e+287, chars_format::scientific, 287,
        "1."
        "0000000000000000752521735249401871936142708048258363851925443970635243430154657100253910763966211992393922"
        "0917551527141401041968172205589677021287693862203915638886974287199071604654071266769099226071211897966340"
        "736882502910990345434353553680702253338428636675464684849307718019341877248e+287"},
    {1e+288, chars_format::scientific, 288,
        "1."
        "0000000000000000076304735395750356605147783355117107507800866644399695106364949546111315491358391865139834"
        "5555539522089568786054480958499982972526059487327108739962648660614644255098884001691739462644953639520862"
        "0267012778077787723395914064607119962069483324573977857832138825282954985472e+288"},
    {1e+289, chars_format::scientific, 289,
        "1."
        "0000000000000000617278335278671568869943723109630112583100528505388133765396715589425391709444647966943104"
        "5845149126131034590785433956171738211535366987228554259102109161882186134743033813753627273385960246277244"
        "99484625789034803081540112423670420191213257583185130503608895092113260150784e+289"},
    {1e+290, chars_format::scientific, 289,
        "1."
        "0000000000000000617278335278671568869943723109630112583100528505388133765396715589425391709444647966943104"
        "5845149126131034590785433956171738211535366987228554259102109161882186134743033813753627273385960246277244"
        "99484625789034803081540112423670420191213257583185130503608895092113260150784e+290"},
    {1e+291, chars_format::scientific, 290,
        "9."
        "9999999999999995786090235034628413215355187809651428385251777322903315400557247862623653707190362514808261"
        "2890986863714202457020042006419681526374965874177788623543449994485057258262661745948026767632275613049896"
        "960078961318150545418464661067991669581788285529005480705688196068853638234112e+290"},
    {1e+292, chars_format::scientific, 292,
        "1."
        "0000000000000000132565989783574162680686561089586460035632031477942492726904253214615979418039362499727374"
        "6385658920909881229746500070257845517383027467316859073953152552746468610581875582146175794962018326623525"
        "85538835573636597522107561710941518560028749376834095178551288964115055725510656e+292"},
    {1e+293, chars_format::scientific, 292,
        "9."
        "9999999999999992462348437353960485060448933957923525202610654848990348279466077292501969423268405025328970"
        "2311625456483436552753066788724417337901780594783307353950604674697279949729005300639788058439531021138680"
        "00379620369084502134308975505229555772913629423636305841602377586326247764393984e+292"},
    {1e+294, chars_format::scientific, 294,
        "1."
        "0000000000000000664364677412481031185471561705862924544854611073768567466278840505835448903466875698044061"
        "2078356746066803774429216105089087787538737112019976077088007803912512979947260613395493988432857461329320"
        "5683935969567348590731356020719265634967118123751637393518591968740451429495341056e+294"},
    {1e+295, chars_format::scientific, 294,
        "9."
        "9999999999999998134867772062300415778155607198205813300984837204468478832795008398842977267828545807373626"
        "9700402258157277029368704493591001552896016804949888720722394020468419889626445633965848788795148458000490"
        "2758521100414464490983962613190835886243290260424727924570510530141380583845003264e+294"},
    {1e+296, chars_format::scientific, 294,
        "9."
        "9999999999999998134867772062300415778155607198205813300984837204468478832795008398842977267828545807373626"
        "9700402258157277029368704493591001552896016804949888720722394020468419889626445633965848788795148458000490"
        "2758521100414464490983962613190835886243290260424727924570510530141380583845003264e+295"},
    {1e+297, chars_format::scientific, 297,
        "1."
        "0000000000000000176528014627563797143748787807198647768394431391197448238692552430690122228834703590788220"
        "7282921941122853493440271262470561545049232797945650079545633920176194945116080744729452765622274361759204"
        "8849967890105831362861792425329827928397252374398383022243308510390698430058459037696e+297"},
    {1e+298, chars_format::scientific, 297,
        "9."
        "9999999999999995956620347534297882382556244673937414671209151179964876700316698854008030255517451747068478"
        "7823111966314522286348299614922233214338230100245921475882026911692302152705828545968641468338591362245555"
        "1313826420028155008403585629126369847605750170289266545852965785882018353801250996224e+297"},
    {1e+299, chars_format::scientific, 299,
        "1."
        "0000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044"
        "4383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994"
        "508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+299"},
    {1e+300, chars_format::scientific, 299,
        "1."
        "0000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044"
        "4383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994"
        "508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+300"},
    {1e+301, chars_format::scientific, 299,
        "1."
        "0000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044"
        "4383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994"
        "508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+301"},
    {1e+302, chars_format::scientific, 302,
        "1."
        "0000000000000000762970307908489492534734685515065681170160173420621138028812579448414218896469178407663974"
        "7577138548761372210387844799938291815611350519830750167649856488981626536368095414607314235151058373458986"
        "890825155659063617715863205282622390509284183439858617103083735673849899204570498157510656e+302"},
    {1e+303, chars_format::scientific, 303,
        "1."
        "0000000000000000001617650767864564382126686462316594382954950171011174992257387478652602430342139152537797"
        "7356818033741602744582056777919964339154160602606861115074612228497617725665004420052727680732706769046211"
        "2661427500197051226489898260678763391449376088547292320814127957486330655468919122263277568e+303"},
    {1e+304, chars_format::scientific, 303,
        "9."
        "9999999999999993925355250553646218600402872201173249531907715713232045630132339028433092574405077484368561"
        "1805616217257871719374263603053023579884086688277498730144168201104106771025316244090584371980254855159907"
        "6639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744e+303"},
    {1e+305, chars_format::scientific, 303,
        "9."
        "9999999999999993925355250553646218600402872201173249531907715713232045630132339028433092574405077484368561"
        "1805616217257871719374263603053023579884086688277498730144168201104106771025316244090584371980254855159907"
        "6639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744e+304"},
    {1e+306, chars_format::scientific, 306,
        "1."
        "0000000000000000172160645967364548288310878250132389823288920178923806712445750479879204518754595945686061"
        "3886169829106031104922553294852069693880571144065012262851466942846035699262496802832955068922417528434673"
        "0060716088829214255439694630119794546505512415617982143262670862918816362862119154749127262208e+306"},
    {1e+307, chars_format::scientific, 306,
        "9."
        "9999999999999998603105976025645777170026418381263638752496607358835658526727438490648464142289606667863792"
        "8039265461539335317285025210333627595237061539701073069166468937517856903985107314633964162326607112672001"
        "1020169553304018596457812688561947201171488461172921822139066929851282122002676667750021070848e+306"},
    {1e+308, chars_format::scientific, 308,
        "1."
        "0000000000000000109790636294404554174049230967731184633681068290315758540491149153716332897849468889906124"
        "9669721172515611590283743140088328307009198146046031271664502933027185697489699588559043338384466165001178"
        "426897626212945177628091195786707458122783970171784415105291802893207873272974885715430223118336e+308"},
};

inline constexpr double_to_chars_testcase double_scientific_precision_to_chars_test_cases_3[] = {
    // Ryu Printf d2fixed_test.cc D2expTest AllBinaryExponents
    // These values test every binary exponent.
    // The mantissas were randomly generated.
    {0x0.63b831e8bd9d7p-1022, chars_format::scientific, 765,
        "8."
        "6673155601518373204745615934992065170006880827787289636461039456117181014435225731420739682086431846196084"
        "0559717761976781401452617612090003075542930260777812518669659241729724010681746641686623499848468215594968"
        "2021079153402945471922988971873909012440740220527800911244244822910902773084448896950002963160859062629660"
        "9882885374947604962348974323036144310657614326754120115556509383797380330234783520222245524583876671362471"
        "8494080431858617260899963028423305531253945552260335123939000593240656910669298632181747412649714974019858"
        "8356285761402581880926947783051518340651609793980053160313425027619711896255545853478748493923212623215309"
        "2624291889535798750202922731324119623206905408779063259071595105183391812893811664489504206776437911230459"
        "57647264003753662109375e-309"},
    {0x1.8777195166b0cp-1022, chars_format::scientific, 764,
        "3."
        "4024962888548891870780380223721963415936057267215768489022880931036340709664117046765987977180526441192766"
        "7980233377849338161398396361988635343561859686478002041658296279167269633549887180398681467085048366045915"
        "6676370951509663121515851044197786647785688189698831775149285429703757400159268959324595109001459740108998"
        "7064349011889817819942001416735892399032878298656443356501797788246594163297203747575928614864543561706962"
        "7150190560661004463760153276800654567748203691908193307868018274961903878508519765463087823925880361092267"
        "9880731846129559561006152326978128322135743176002677808113397223361200222360522182681889723507749332427973"
        "2240457324020870731250050608330505053074385990942209557473057293561320028309889744618215584592846312261826"
        "8243968486785888671875e-308"},
    {0x1.4668b84fe57a0p-1021, chars_format::scientific, 760,
        "5."
        "6740958740641631511384384536776561146340227260577357930980504423887626489617571637837441488031383754955785"
        "4086594144651757106826827082053224819137614951757164822186954713633389739294124192094600295957101411513892"
        "2292227756567557970015697918331549646091513808709325026828267412677470869412642816923726953169932993282696"
        "1970700281786004455171108499583392239457705199245309170122601944018148603634684132173289075939231416021795"
        "6773831481083699810908312929539145137356475139290129992626736771448814573026906644585538148884867233811394"
        "2395343914793125973137539097252903908512233824086968776157212299338375466427657302566612718734454791559738"
        "4296829871117558203187275819525974756928809649794138442664770396059164903717939140888326665645990942721255"
        "123615264892578125e-308"},
    {0x1.befe59a615135p-1020, chars_format::scientific, 765,
        "1."
        "5540526173622352375993445245662683293464994107818202403773732113997242921188175334393284236610673877760032"
        "1140045136930880932847198094667333515588636758849652193589488647628623014759199260062387648516658758902202"
        "4414313323949909142159529537456605070198347779192598243095403947592025125119457352938379814319820278343589"
        "7747302961203036640889656009214261792160762451937044526624584298357832777585944388632200805521152515342330"
        "8561170623085034646351360745189671642589380586080254484943279473962393703949926697788378603146358212695781"
        "2370158648390166491038532530966495890940486561351377873613480311323741789526145720019072115667475187757369"
        "0752588227109741861829975787681759234538817712508305395458670019301186211951459779169503264140139719984290"
        "42287170886993408203125e-307"},
    {0x1.1e3d1ff2f0c7dp-1019, chars_format::scientific, 764,
        "1."
        "9903200051351428805615989243193127044770722692702459361378399559534652305451954151277557670839014475339478"
        "2867837696288408273532724825127341865493665067774242606965035835847639336549731232556074151242689053806547"
        "2696077887804553644884150043878406627507745699995507099147377175105877153481526330603572499358626260756240"
        "8161745031548857838580407488540228220931314580542710929232921821435828527112974792024775296802861545460264"
        "3826566011906669643593108259028344252667022294947897471948646741545397199053445447059963324528762468428056"
        "1552964343633309851882307590384491177630806444328543647075668536514853052975155234251635207407297067719395"
        "3884058314203115240012536217140219386138413382468962035052024511938122187739312695493269084190401940759329"
        "5909464359283447265625e-307"},
    {0x1.6f434a1f8b19bp-1018, chars_format::scientific, 763,
        "5."
        "1074185390468469270473736828301327180750062564436661993518732867820414412582796763617494622074841605120794"
        "6280001513512476415260093780274458550261745884171770589710369360980007788208880420310179065543732589777800"
        "1026322540349851343686142888941809812697130982668148593939074359425039990092398040350897342987033684062247"
        "8891910045787038724069756928395277953670595630959968898874335051527496681463133794176157145807591872109216"
        "6144382506150797267436509897049656206429012398091894503972795298016547064662347920285527872288390895517604"
        "4191810941642460040564082188712438936906291867000270523960550332664002210898302673308442754015967789648657"
        "7199640058529357006968235192644651239960321968186374102417320609944271040560945042782563241257065556055749"
        "766528606414794921875e-307"},
    {0x1.587345c18153ep-1017, chars_format::scientific, 761,
        "9."
        "5803415071347647865082718369266434040574270026977809712667208404792036119580302875847883246591206937429220"
        "0765720124757014325334439209209434046539893719315938780007431549634993916215217605362262858269407426842334"
        "2012580732514751221293610595763003495795061946838666946253209134456556726989193259291618902375718355472162"
        "4042439056845036040587911004852089800421901874454407994337108163738052947210061561024263715054967969591411"
        "0270363560682828986102429968210287319178363269091390190666341835673642784686119809160641359798630514658952"
        "9621994975436450348729144771801748911075356977674248196373371459254492612305520113008095746852968491757589"
        "4312232673600164454503147125519469744188854742689367713126583601172208920773079707158131901323372403567191"
        "2133693695068359375e-307"},
    {0x1.f1b6b87277fdep-1016, chars_format::scientific, 761,
        "2."
        "7686246461533842708986290401534510677245449052480438452772935563477911887903937433332521175778793903095384"
        "0412239557231923283555660292437990927601776574893980601557250737329754310915661825472040213756951830291482"
        "6971556169842700521540676609741125857389706633023242364855348478771230295850829291438723530923932923590702"
        "4151611338319751130631733719608246390666274473865694983392385750305737090058291815147877218349104719543513"
        "7063089136683774947602824936693432977762482651171413713941775960038695919756102724251419600380177635071493"
        "6245861443988258956704733318591666199586331239518529031729048520377213164363192327716960117074516227535950"
        "9369132897727641328747183370449707056957130139385301002356826323260325258247061322707666120024327938153874"
        "1290569305419921875e-306"},
    {0x1.72a498409980ap-1015, chars_format::scientific, 760,
        "4."
        "1235396742477088973208679969440262899254505285796142223814175822702981218018251380021070120502969772416262"
        "0356011168621659532952906006748436531426296108744371485218418489239052308056360753777114430810169989395269"
        "5946140077164320660032095927443769046869340226546265147500705839457828617891438915581029354085740892509908"
        "6126202065003470601897807688053820010379771148507245760602767529755342564783534772481563133530608872155816"
        "3170273217810752940595356441071317848377916852111771962558733789348917288503698641911641096452799678633118"
        "3241428470038337938910339876846473513908343996450852057201827354601830122948746860487681564435359569830201"
        "2244034576878689343471222581935495027065359114155162611459186679259780987690986908851542569465209453483112"
        "156391143798828125e-306"},
    {0x1.ce91e910d066ap-1014, chars_format::scientific, 760,
        "1."
        "0292523314007669232638574122959890467082535280831773462781705248559642874893726342757936877737789465732731"
        "2479354581078416852016211748037289062294153412444887077225201260286873016177402040776581672627422105268655"
        "7419196324208471582119260101560948486357037365510139379540004408308132593738795998437771752956709763675038"
        "3014741316553229608555779896363377365729952793542626535019308363767322768135329791753783704045210472287174"
        "3258998969100598727128250967239986818240346849429624604806528929509814942265446828862812886192478721784982"
        "9763922746869649849450345544760606574327399799533824584266016235963525049495453939501167672500218822286450"
        "3213932415104343443746664957043752138584117730581730514644229269575090721314998575865173879861913519562222"
        "063541412353515625e-305"},
    {0x1.a41cd0fb8478fp-1013, chars_format::scientific, 760,
        "1."
        "8695629667714589591675011459069349152361779084993905567488662819408615881583054005738477193311059902345076"
        "1887740398618582452621943937695612634176016332254849337060923845633060080657730525723232050132901795302428"
        "7747627232037457266368651155516174545033578105816636548996204160600146117412245796293507856944957146706304"
        "0254113362718627037659792095227781184269228376974078923485650054103229807045611097285162062152946597899434"
        "3606420788243552352751894800076450567507229035568346316425077269088928498850264418366552561657569635100768"
        "6952407174842753490576669187086405946186033731473973426151694416850707500076337061041599563960687925311368"
        "5553781567772169884961236205927091959675967933403932478188107975984517174399812395983733193105535974609665"
        "572643280029296875e-305"},
    {0x1.3e41d54eded4ap-1012, chars_format::scientific, 758,
        "2."
        "8325827575460101051539146153659554542949953849899101704093223118334282451264669960468445814674273734277278"
        "4980027834494082685766178127629247208184380986441039452161190285373582999883474215846885769779038605962665"
        "7678189248144526566294279581606276306288020536846141644176497881789932815661474116675442020743817107419678"
        "6033403238981156288307360202517295738237238234044693827210253447256461636044859195631301675170218334495437"
        "1143800460586565184398113067165957481092210378398497900972951098730107411912334069394868562044554181578968"
        "9681881384571986389866669746565242803754572930194362570076270849264642814287648059465115948199864438616530"
        "2340702226649342072166051234769942192131532561249089789855476072421163114219198973092739279877605440560728"
        "3115386962890625e-305"},
    {0x1.59221b87422dcp-1011, chars_format::scientific, 756,
        "6."
        "1435754675809883764607389644039122653481643689751494279548380407226734715556912511959558049135199048091303"
        "4570147895374919927596970561282274649091727304992573536378826177765491606914330790712251813627403807741060"
        "3228952574550189497787908659493137234313533520312295234438706051770280882165612147632789337287128790236358"
        "3684228396504255283710239792217487466451145359639305211018532224666776225360631707573627254298962575843632"
        "6997585642760239301816630363203045431540296803267094601248551668127076407345103299971987320334913146074020"
        "6557039826594483610259885518699987425238236440286961754514953182564652960551764735240281677725263789812661"
        "3360122856215329758437263182035107129113790998892977867473178270734270283430110068390028743579023284837603"
        "56903076171875e-305"},
    {0x1.922a6e54c4bcbp-1010, chars_format::scientific, 758,
        "1."
        "4317575812076783279096962507607344781067968670789399357106075957085731026073398561781473029430115436014229"
        "5042738269957197194482263497390666912499621452236468720067330567331779529652769510718792075605208255229780"
        "4453598386016350631514998361352765835015287841808273033244090798155636616618100736973069441228252750043602"
        "0203687243042317304969036116006867635224978070867606390602657909489556516702811707764895990014055554819168"
        "2970313452199620495617335159702746235323083593453065072144972997529670760566203914519278435423331980290138"
        "3227718965593270032595543344712007425459523297691036565265412105198702522141620817697556902837198527180570"
        "9506606910343882865250484528903431183126572403711830756908976441373889806932772055664271348973670683335512"
        "8765106201171875e-304"},
    {0x1.072696ae9ff91p-1009, chars_format::scientific, 757,
        "1."
        "8736954404407842914371682565703603275065764259885958103791820006438214075779341036606769350112633220313924"
        "4013286873373278194295713473289353980269648254008823511740795625917107257638613508520649307128393978192620"
        "0705468314546127800658230827802488328422886555037223958144179314615586216250084158766674880816820412018646"
        "3506557142633404052761483488369917577746023162650582898107046603525443910985220071389009387344317203213496"
        "8788006389079497093133715393761312169804834914967830608316141061423753171621552752239867268985731345293183"
        "6000009671729651430504379359358929467240989725060006847711032116813580555184077897939000848084702416809622"
        "5624812892285306182628743961866717634410103283855733573331697661905063280118823205999678549460440990515053"
        "272247314453125e-304"},
    {0x1.0f9b544278c4bp-1008, chars_format::scientific, 756,
        "3."
        "8678085703767115679707960176797382475896222472846518711203204581057046445044323572045619149527021471033513"
        "1037742529492665225855291158606504096304763954369359355075134749682657763340277193897585554908876427528122"
        "3404237262544370036021050362028274509177214367131685009066980529198965345188509320693984189852122869096724"
        "0307762668804484986822336109648123529928998213973332360935499253090321992465599641371421976527675643722147"
        "4818553028447896343622184778775789582470210526709724599576515721933721910757383142738726001358720616381592"
        "4229271802232530916741889867942756272048490315195062592530929515848282749067855559474139733793821353946484"
        "8445188615771182360486800621802327201033747158405727472729308966998705733027858963413159187894052593037486"
        "07635498046875e-304"},
    {0x1.0c159c101694ep-1007, chars_format::scientific, 754,
        "7."
        "6352975143049522614438211587901154588102399522679308870720966934866278134299233303209132483254882406877024"
        "3032314978411326683785882828449889576731085199036357093879916119191477548962018450810436368437123537879171"
        "5398901706373669321385471295753589758753964662654457905715120673904659565201490447825557005135025380834617"
        "0283527824311975829475393389338044032315549305419642372717127492349123269421393795189501093425583277951613"
        "7482472996690706456618658477990379299062555451161914006646917062753813072403148854358191467247380141960317"
        "4369718591349917430634535930397154004116848462943127209818005654101392783570316361193216938245623206104415"
        "4092104891133848306373809820626535624355866825082456994424052303706479922855952791049816141821793280541896"
        "820068359375e-304"},
    {0x1.5dea4ce8e9d1cp-1006, chars_format::scientific, 753,
        "1."
        "9931833457401843380206268213719062063350814301599018679933261580130337290316898735876549592164313534803701"
        "0367716961871843460238736763173540738894631496044341513014086769607675313389734660544429847137223449237368"
        "1854732828188990763143676913549798050111000449048160356662711177445920457729101143615093098470889673928997"
        "8721590778489898585846173250830089770352087321756188087231770443888379781496362819885950130996391895508049"
        "5967945265553649325413439043352821440085193375901604390558169700922107887759422298045475048448298435182127"
        "1529249898671025481762571674803699881589864389977475085144039107611461508367830308205819849065857072705384"
        "2544909780275364598179935132913048405234257751121414962140712577875960000639218860918333575682481750845909"
        "11865234375e-303"},
    {0x1.f54052ccfbd85p-1005, chars_format::scientific, 754,
        "5."
        "7104439440441903852943648577406503088003161021002627368323935629069966209695533414405887372311247087423593"
        "9781943349661969952724399972643565145643565596680341154191365245563840621127630622979641166875699011127504"
        "8568462104925391744823983638657336393276468809438060554239207107070390674319071138242241936104300064142641"
        "4253161862928768191727964756739054251002351820210559683067678277426478312879053806872980671807735494036931"
        "5976069688037470882986462600191569302988629020903776604825882710768551646760758983546554323851915180357433"
        "1464966657766198572115325587926099638392334145329333710974022615959231083135651027696907010536501610597578"
        "0684355323209040588603358187555694328693197982659012778489710933784939697285300275186870067045674659311771"
        "392822265625e-303"},
    {0x1.0090aa3ec4669p-1004, chars_format::scientific, 753,
        "5."
        "8457732298371823574823131482226670449533326157358746716791953135062569212292668611641801097780408195948596"
        "5888373447402064062727322207217975101640660738989340741657280509189289276615212047497934355406431806641278"
        "8478834023123098163293513531622437049966284424578880391547670271754853142196587321184864022163506030620064"
        "2833463853585974609101781931276219629563822287439933439020777086511705876102130660051067922171320065746506"
        "2465994749375713082577376195362056859759924579898568161899707504166498745404902069366067260964218815046333"
        "9524113776506291985183641972212962838327237136002597053343023166906014203406467918165849951752439662675714"
        "8515684537136969992272393011690298548643680023668422526561162499435912606954648951251840571785578504204750"
        "06103515625e-303"},
    {0x1.68e98ac55ee26p-1003, chars_format::scientific, 752,
        "1."
        "6446596413123795549652277705330359127501949597887884484643611330088026618345889007411448311200165299004153"
        "2139330705876914793120460121891845777978753428196824338319708537694880490448415548357571084171954782371013"
        "9827936080983236731056925429888897928508247060002591227377665559607280147694385759161472019199431022048753"
        "9252764806264502002388852086321464182435389525557563807453640035300562682385718848951290103132751234367433"
        "2673547866665016504944648849864967346476782260339605421755639569644367437952386484883839418341180039062684"
        "1460528189649358085660200495553016137618232436443335627143917562089955116648923161635472084978246578377486"
        "6022112969364460310239797566964913160076166500253272495540657636319430742310315762821915086533408612012863"
        "1591796875e-302"},
    {0x1.87db0e29f0009p-1002, chars_format::scientific, 752,
        "3."
        "5713345155797761761079287822950557022675635846989691191937710506813782658682864940472796826062016923286770"
        "8166475001047504811177502998554808270085595314612727547047624036293060053880752125848194352774957680860559"
        "0290184599616254184674980579084610532650542277059343477381901087349157002708882523813589860191819919463864"
        "5572473742585546004235957997477845885941869654346021359209516817462476983259862602002508582493398382630013"
        "1126260391727473707770159740877054653682600781506186186387821934514680593847124459886451259056737591228212"
        "7533791281642861022630716480368525884787242037112467446408232606412304327122490841829569553119141625758702"
        "4691172442399017515655247762428343915640594942453182541456052819062032841011117278995357082749251276254653"
        "9306640625e-302"},
    {0x1.1ebac54ed6e41p-1001, chars_format::scientific, 751,
        "5."
        "2264507616884437569805809040739207336366694095277810554730657091293085596388058781521598800524476996130637"
        "4980627154903920257708024997792739202136400792180949605152479609662491266228594913712258572249852752399855"
        "1285095014756776289555458879942755967386577111803668209714736832027600164037534380000658070281110020332651"
        "9987841007167969298905049974104357743571558147007766635477857992855064039069143805060571043111052222533607"
        "6906939348214560580910775118826868200509986914895110839876152537097330539855968230909381107897375007290398"
        "8378385138191514671010111525187054811597159710392200991099127775914461518114073763353708106827024513399075"
        "6049414344541691511157350304779944771415413564368359181745069897590897094359629893034480119240470230579376"
        "220703125e-302"},
    {0x1.26d300e06c7a2p-1000, chars_format::scientific, 750,
        "1."
        "0747997253788843490025917088317140149354267531941831543005317538947117106260486277259597702417316344843162"
        "7823155594400408640689601791632312318793792452277700217881375008551777955008479104306751684583798640011117"
        "7331237195678228062266622507530803180421764933136874457770345473896308774311676909174769953465658733136531"
        "1730646743826073699550122831792121293574779463809583658915629548187457141074175132979644912781434112119879"
        "6449732242461849927674893802726574013367315709379237708819341288775841440380509951443158447860262711021202"
        "4512841842169839736663696096780505831114559890703110871001542936248745358663880699070477580187175555004706"
        "0426293407222477239023776188348421566739034336984800207756080926084740452888799389086216251598671078681945"
        "80078125e-301"},
    {0x1.05d0c9256bd0dp-999, chars_format::scientific, 750,
        "1."
        "9089292620000501462461091846419476055370811043243200914242752398813586917946117117276706450408017538758722"
        "5660390310015790741172721365183864329136645491654476508380946870544854973961644577246381082657250286554378"
        "6724684318613551976033658170744074959929074525489851922078469090207322060182315897761166701384940345796648"
        "2390692682550639168953244522694274039612474765568989798173496674976754209790799304541250614878586316185908"
        "1832434850661741938378087947299281921587249685730116526155067127702638040935609007598196903511226053833394"
        "6368989549925329930627669708876781138383078123518967695199641472080864590952079516774516291036652778177765"
        "9754149721554139538144541534629568996232451758594381806119602658917928450846290822084938554326072335243225"
        "09765625e-301"},
    {0x1.d161118863a28p-998, chars_format::scientific, 746,
        "6."
        "7862726827637822308383819837405744625386270069383303690107600052832104729374686176902718298036439556876536"
        "7007835766438473158503573341233420991356741827641046279183540631203113336246661546736423349686499782037093"
        "0641229855313759587426623336318947131414886263684536725151767642125347109002448147389830994122526274370789"
        "7617018358553974800233291485285224355118796255276967020647450176078219330437486876008901717954573383579099"
        "1047714288626185265103482007250812237430446740002717533482314627054425459382273947022327354496010149857916"
        "6998179831269447169218862728847291808670566291805820903410461158893419653332870539994687457679135320191821"
        "8210212370421266288662389144108768187401712413790015232870218865309040051636557677738892380148172378540039"
        "0625e-301"},
    {0x1.a15ea25a19660p-997, chars_format::scientific, 744,
        "1."
        "2172372613102280993179252931186926982692345919033968631102111765103315033304380176933385417160002408427950"
        "0295470238003737903138964229170029641147550066555294617444125756680352014437431112856968897249350959816759"
        "2236046524827959672222373231938825328608517533711548379199837592813292143627291147239524233411932374697495"
        "0076147620325900633348562563414895932402962713954954623414922689851738589686706046155327824502166704335474"
        "0483802830489519355136211942835589461562419698678550112002073553337267646181096609192841991425028505763676"
        "5310643658630077974934313260104372537119221193415761606516937805300536262521389430432123931165919988196641"
        "7445153541195275166274485974787587695265918859779451904129303848765483730964831465826136991381645202636718"
        "75e-300"},
    {0x1.3405ef09605c0p-996, chars_format::scientific, 742,
        "1."
        "7966676643662128335665392247768118683231502978059871166650153469309831612890500966882039821861868400342764"
        "6561658712020662099545587837211036370546812947350494432238004683763664567568973440673650283854843511596346"
        "3698442719535496115538726433986266863862950537061969082882291651460484133576667255869437876496100220690327"
        "1627540775195602113421651211440307831129924696845524348946549788527717960851496934136922932274256932207250"
        "2504730017520700249939263105447824182001422269657481368614500917398558972900508936492536325012033905462034"
        "2733517067914324213319731475850729738988853204799698138245429919661266017564480782965092181767914524772807"
        "0114038343552765434718432890065190765206137218078347442517180856079439532635433351970277726650238037109375"
        "e-300"},
    {0x1.d446d39179d61p-995, chars_format::scientific, 747,
        "5."
        "4628196945287030878864501228515552805464723717056197760606756889643903510249553048439017711133773671440354"
        "6393863354679463635258948740705694069667341257396888036371466715243466156053378293733554928216028872449926"
        "6270281940200034766664065924797146527366094882988718989577228548661057271640470276933597886851166967309922"
        "0490286146185662487877704337685653857174654805590027514341847429667755625338708736633025559983835650906911"
        "7082144597398445022686629737262804848201604027875209019963234888348727732753557137541010501446542044860603"
        "3076124889789498045902945493217533531235155103049453504888178998390271594265142786559200789840036462465329"
        "0699411376938730047962082755849242672666320969811738379369429636779305695104547169194120215252041816711425"
        "78125e-300"},
    {0x1.2a6191841a2f8p-994, chars_format::scientific, 743,
        "6."
        "9617062487220514621989094015930584333539423148144476551620642624680348776495275585358068724521997148409410"
        "6383911454657957927017181245452872915474622111096382221071681697520914214818303865707205751044498351025044"
        "4536884198365605166521031955111219642419220298954347889214534531094837790091823656984057353139300007125800"
        "3293035204706020167948760755422183994450699458391794656901738793039684960506013257067218773020004462578765"
        "1439009842232692428211132570873279618568830654102695286917053708082753966210260483718165254879075265420369"
        "8658797634666096444025144902359009191385276894101485935046230814418030394044362489237345080002513507196221"
        "2292725330139318787534438587025433685744672341079724930282999161273299604246744820557069033384323120117187"
        "5e-300"},
    {0x1.43dd16d8c3d1dp-993, chars_format::scientific, 746,
        "1."
        "5112507155402444702013530602239356519676208975557545662433849515130820968525645380967790058631717581998946"
        "2383489016678007812825705103181297543850063798852533579279995518512249438119478194724227415435927609478553"
        "0478989334370229123257813332123709533239479541328383215098833929934144690721346831873831758199105011512667"
        "0141483262312008742676060289776355889496425001520922157519067534910344942859758756256865735756093457144432"
        "9997703898734942358076870125601377536544377173388533764111459177194183621681873341290551265610317343464385"
        "3672019620647251124865042369790323166084999111485707852379027804775884480582808977213872674467521399597635"
        "5584951293948756727528587090551401340178932148867448233676410270702548249710517325183900538831949234008789"
        "0625e-299"},
    {0x1.1e84f4437de27p-992, chars_format::scientific, 745,
        "2."
        "6739808737490122536400919026942802234689576692371479366784405643483990062433008551497319332426200403535689"
        "5030064921783009805791888470580796419933084847761281293880427379962271237851947800328657537013648988481294"
        "9516962024244211760960748336098090994846015649655386170552493311162069257719900379903030507008588526031419"
        "9767588940990499498807868924298521846143186141665068730082632329712887735907185105610033092499947885537087"
        "2777021779956743000754547833513581633478384242279856707134228104860925927074204711269107333714275775531468"
        "3776136264937390122187354227141214309429715495082890329538893471744410403270954316441211712985000610177269"
        "8944311067042059526539301195418948431941957516625083848704359299592279997082044928902178071439266204833984"
        "375e-299"},
    {0x1.c7925872b0513p-991, chars_format::scientific, 744,
        "8."
        "5033691573552436743032359501867675425844556882485721384874628070407223682326838306017437077936494642893855"
        "9999659947344275015058137995788308286051472366936034180700376051612641241581279358969439631011755807941264"
        "0180009205258501662816829998856768170023903650537160919301714607898859451205817572487894938437883022633598"
        "3376290822291404418924863244602723542510196397911516919435936905242919732102909562672293761027406048075865"
        "7835985167284620389463467848900582426969335519962264577071777190480699878841459712168172042966775236944743"
        "1326712331419045036441427176290319828551714549495813962256861277779164177883181431486896646293602751921197"
        "3383768944719374984215587270106299004243931703144739402048268194422506183194343520881375297904014587402343"
        "75e-299"},
    {0x1.627c15354010bp-990, chars_format::scientific, 744,
        "1."
        "3233106901096892065379397808572390395445480166333342374132370300121192775365256676551830867982461560404647"
        "3777896550467847979014748844578467275598314335113075595369097593300537485855884838260655662363690589028654"
        "6498407090340200266273232047853174074580694696818844330785856152531370577370227513485232394640688728493031"
        "1135847573135818241585024900463197122494596403199246606733219005485941416655806006702981687133567159445266"
        "5264784897912598384678392200864189243829386425598374397938130908968237282949373565710105887439242496421421"
        "3457126729435160471794471801982845652213879420707161040622898225638702937020553616740975943614118011210770"
        "2980056185861897975475259225613788646834383911028404539765069186955590008203387242247117683291435241699218"
        "75e-298"},
    {0x1.1d2de00ed154dp-989, chars_format::scientific, 743,
        "2."
        "1291789776720231974744171840452344550382511057197936020876953529640730687265974572615745465067992041620069"
        "8777501121683256345606354913401960704423029842081367774831586751504524522776674423749062780692170748646712"
        "7042943546561615399294326604589514550653819458352282966533750051174678662358361943789708146595937329877498"
        "9140003486840484348673799695074315983476709436945484939187203715033177550788146372453950458146622857219661"
        "7273106008632520237983276624844623210830411434978194668918585129565128333659485382511336320510797758394849"
        "7066534832654912056496337016989948283722604021746733182517415331234370695363197261511199956180205135316943"
        "0561914971324547624168015418679749304199862313667091306116297604131976095587219788285437971353530883789062"
        "5e-298"},
    {0x1.17d753cb61bd0p-988, chars_format::scientific, 738,
        "4."
        "1786486152355461374776858263541260614950495378611306967856664376317856708608093736614315389654405332780988"
        "0689426945941220120153421904054106863117496760957640139892128130420227762590755039729804157834222703199862"
        "8589539320999048052554586101710114818979133947966212532305905925289774542948861040799079637308077821570870"
        "3072502377172962357928714199868899047024282661076090342274212069139243739604752292552932633409518449469092"
        "3515593099815763625746247415708072838144287073191379829134836259189096560570733143915925546748005565580401"
        "8976745664144920158206659169946960403857699609960069561793275867483380048607554657047054862232324598082497"
        "358302008075588962346666145156130842715967918196794561008886211006529975975354318507015705108642578125e-"
        "298"},
    {0x1.3499cf58eac56p-987, chars_format::scientific, 740,
        "9."
        "2161893778403732513862252343445239008981140568922643687663896941163644334084345821330989953720210499840621"
        "9160441214807915624700581299217694372147060099730582608651734963216528832267933134373355153359342883308274"
        "1031301445760468599085716685646380991547104769050790451044679611799053816971826590912754216056544099398818"
        "2528853848068150300509122056753832693713094307177084179547175302766171211400043481645401436905858815277797"
        "1778893603240997534730307040753686951999518274826840134999719889934188564885663380751476200671715491306522"
        "5875510502534842446581576198070129986491767883536217287215961728669453640209658291317958839138963689034141"
        "88789632715887110086986492180657573226368342685188914874974230699578026104745731572620570659637451171875e-"
        "298"},
    {0x1.51a27e8a8fd04p-986, chars_format::scientific, 739,
        "2."
        "0166542228894893663309521343065653027086245497896068869059180976583615938098889986991041485859172655850284"
        "9231212781790493656064318876082158442840914388695516071513871282541627904960007529256925655758366238004656"
        "0935056627139456537528211198364194749602836764902987565025944221130708673443828163387359505375370290009445"
        "2745724436276139585419606556712353250612586551744106137528572254128169189469681750106767803119244277794048"
        "3750210471579159462599857421379948439622868937356578266959909594120741362514869852677384097257555841840521"
        "5236796758338972388174626883880522031537078122191460297407274783067835677391633127317778686117811785197733"
        "8577887683038299362987414194915000779858380976854620285433129268926055743804681696929037570953369140625e-"
        "297"},
    {0x1.28c16b4ed7098p-985, chars_format::scientific, 737,
        "3."
        "5449747515908893859520264700887688271107416558032715906653570211101157114219987495688096790234026558681710"
        "6753141856950390441673389046891140333791267175538211915142881836447148902272897131242054424760323762734875"
        "4141190178165059795776451057876420487228094750780831495237996530558044233292884300493086993773653449202457"
        "8818090715338972401729596065603472996108834056777416770233084403727965152368376850711830195137130645640590"
        "7046607319098707053806529570935342883620442701491795272567870361575635905003352499512824154974326187486698"
        "9060265662902975470835003190344156534010770165498653170496875412652458097421921303135343195297833828784423"
        "96301612754526570175306033284095638792306713346530524716480707592136667472004774026572704315185546875e-"
        "297"},
    {0x1.519084374060bp-984, chars_format::scientific, 739,
        "8."
        "0649390857434579193115655390618626369629653008353154439327413620740314818119036634456720430925246670592130"
        "2576840115065505875190702262346443580413571712749788204695695123012277087263105239201891820479284533969818"
        "5186455177319075030110798057602091473932084908015034567525286047273421566565922229061651406247462013601709"
        "9678838136927214185461292825117230319532485842557112068939568153450865993280216546928857042166319106957693"
        "5849602489732653894260268826761621079492065154996852043006813295420056272714448441938250959284349518278972"
        "8109873701528734475851958983525486767921479203821534881357550897232367303129611065194955396175464225609057"
        "0653475980420477041519013852253561174979884533208594899267372506368456441805392387323081493377685546875e-"
        "297"},
    {0x1.bb4c1e678fe69p-983, chars_format::scientific, 739,
        "2."
        "1182119864764602130642094783087206583734941656216310675491273631944013364753704741751950662508914029324838"
        "5386753482217342594034540534307701346332311222871574796733810364341680474829175453754906619121554670765885"
        "5503073696569114420021537616341893639125948726900059561203121631918388786858610891472826691304489021041592"
        "8204921425043137414284707993217579365651624846035324808539913069705011705983388530603140990470370905914366"
        "2429130360743269466709195978765360244654637182808686838641860759085152084357532663577478471344174751577529"
        "0972240748548223967022722809144914777444077303014654296707516764326758858020731632035706253909022691553299"
        "0280045685258559475635362835015005020199131435664704208816162996076304381176669267006218433380126953125e-"
        "296"},
    {0x1.8fc48720ae1b7p-982, chars_format::scientific, 738,
        "3."
        "8204276533494359839532778695795003743446747435092568229275870270753905396609753758094766310024169594340308"
        "2531804530234533427497205555769804527722891005758348613020336577997700742420034577833321799026159177505203"
        "8674621644837883321860447905574589203789932596264453065004201158075133646977415286488731152080905405203288"
        "6266679457055618321561423956395086302343657062006032766471353302180451828901269627826024873174709466366952"
        "2603971081606399156333469955622929484291725938608707418721047578358097887363479034370662134536373850191404"
        "1367247728531590692172129197246521625036149275003013119095905494187761857146715048378242133953612536023019"
        "323048284861285524529772302016446491866534790783641858391019539842314856059601879678666591644287109375e-"
        "296"},
    {0x1.df9d17014fcc7p-981, chars_format::scientific, 737,
        "9."
        "1669699368021086682830030909381357128562123247466233909897185256173290436869196843837665941337171529679475"
        "3554027780942902843142861485494708552404216026343714053469828571423620780701853124085458958213035274017523"
        "3562430379023280135911193419908156405083538884612994163219093960837540940184158271766902246238563881542840"
        "6251457874360114711958891056340399560828449448045550476994666752321648418727132667488079133200123889863209"
        "9770597084200640414102147020755519357329067231460009340640433675296982654429366131186868621479458580681292"
        "8077014517560803574745671039698546093195029449723264978711517158326702241626826015082812354952033962735634"
        "40918968053523398319267275737964394466129772993407912666757701714015382776779006235301494598388671875e-"
        "296"},
    {0x1.14f46f3c4a3e6p-980, chars_format::scientific, 736,
        "1."
        "0587007370833376930716458861240726931462968747989541788325161898554411576600043532117576307710243415965780"
        "3371982184680260925510856439625563819378279886442352941227379220220640407362537154862374128710810114674567"
        "7514478491771437336532301602490071369439129589842422269461377654471657420744038482489238158431343585984336"
        "4112273523714497764911231356847826305616843916838285794259969923537096357742706370960263518594403395298085"
        "7182155015332054436960602985037397127457131249088164023687141746534813653668115686827607828769158632621634"
        "8211661922776018594564117076133002365617217752004182146230232982446412088873912163365353558350257031136436"
        "6418258839009664698934453704098273993991469348626790718931843515715485182226984761655330657958984375e-"
        "295"},
    {0x1.4f1412250492ap-979, chars_format::scientific, 735,
        "2."
        "5617734189585967686818299768257372568423106543272584457448193134718128599177000553291346980043202473956121"
        "2180367126021412392244741193093745572031930603983359883904384447106760541450042234370555490923410636519399"
        "5271125408960594257515760719605036779487548177007694984011771817662329599641936649037337848258202676646918"
        "0324868409975856119135278174695452389974070452340956443806736535092875052779083369995045277193094102198751"
        "7882529396548606924708322774133458177969737673112380202006832077418450022973957900587161535254837673962218"
        "9939870489332022672990844324757213970295295844625265990020341139334420341388520264993199887535744618476933"
        "977079195980768174754058802045425915342354542418540247245180296875588510374655015766620635986328125e-295"},
    {0x1.9017f415ef785p-978, chars_format::scientific, 735,
        "6."
        "1176671633415973759609001711717395696866869599742022471777599404256210233902902155237520408258615349882123"
        "2345052721336844845647017772470586010537618628661882879046216714785572845072040142162072217724152815520427"
        "7434678258158119268340086515696034960671064545207292832947525798713291829364263480267044200323637785949438"
        "8102548829612274498076763793880960706749651498038909594010336103449964450053626521644029697954744301714206"
        "2487861183843172080607954096705021991049257049493594690141603262357639301600484671778732997391911525141831"
        "4656160745439460383763946147928236577727544572145499722938153200720552176047316890086301362717234566541647"
        "151923209709182593285429056144712640551237160829125782371580577478908935518120415508747100830078125e-295"},
    {0x1.96e1ac8ff079ep-977, chars_format::scientific, 734,
        "1."
        "2442918509206014012028953502157484899302248375526922745314229166692585546772990892217496229641056244180835"
        "5613151956891377577895885020022496772410413988317059045245377611213388418239106676765461468848383746280664"
        "0929738154742991672225168441354650138195822558318864938044614007032745608778442983632656067307717276665535"
        "8175666838652658690245143514862764213610885902701104197953459657922797754442670964483945940232205602535173"
        "3747561716472202211817409708258360725922875465550779760937086007766054677009929064967760576046514113812222"
        "3636084341489934911882403581096088174673455142188302497447440448899021951800042462326739293158886225459160"
        "08495285196154157875508821587667877847598940277661829097687051781662148641771636903285980224609375e-294"},
    {0x1.fadb23cfc26e6p-976, chars_format::scientific, 733,
        "3."
        "1000512351261170557348686264751638282347697441603952716948646046693942464502542196818852403552824031750041"
        "4947458847906837349261846175883025166164806498599908783951915826113591552191892899938026717712946307353394"
        "8255638002534280965595353092919104693493427497172744505685162739090774795106876820569693546699239184707928"
        "5679683543224431856784444083274091500700420703555836987399712520363953870514465047148032607184325622329241"
        "4232090453376616525296057392478727384385760735974124403991028933509493200214488404622950198348128729879347"
        "2514307330004432461763750012676803885387452378858427867468188188241476144860361211975943760433595129660724"
        "0419261927649158173573533413935670423949606511027942182777417112760076634003780782222747802734375e-294"},
    {0x1.c2d100e9fa8aap-975, chars_format::scientific, 732,
        "5."
        "5145996431260139100993467191842543303968665047751359175490329248140080201690655843472208689617281422163505"
        "9465153760311444328611419690134650231524119310940944686897401473972303914830917415065953443301454685388122"
        "8415224134154043819888549152070816439653378310887032225499836821436715596770866662350547108554679082936746"
        "4674575770464713312264697289274394842495745574537422516867037314585991641886069493735438794004631014086781"
        "4902330463154994955086532232557782440079216740709862709191364247832437561527741320374664494632591901127302"
        "6587248425665118907646056283387444873731418111750757745277659752247589518641113946873407135807482894539278"
        "142676044746795852491585953284333927743046282564834512270046662507638757233507931232452392578125e-294"},
    {0x1.47cbd89edc28ap-974, chars_format::scientific, 731,
        "8."
        "0195180800119955218580043524324296264728715452014332332170246674538871845805219648492909707144892198471904"
        "0400825346030529599798793600046834482647444437487683767751220097572919791242799892524698422822978446221165"
        "7237982567495904839900279146786398360818656186570954245843716698894420854352456620438185242918109562666605"
        "3625235057734407156147486304856183344925087301696163775028804963431540984237380150218682479654930440154361"
        "4208533335453633897462326737963649687648265020685474228502202597648554842420403440696183134806821821458476"
        "7854658453964553739423544076630981269681312843563475213302475499714965733582391790622273205357040908868407"
        "87322202915150173415505785588461369367258646472150182028804099587659948156215250492095947265625e-294"},
    {0x1.c4a8aba89bdd8p-973, chars_format::scientific, 729,
        "2."
        "2148549407571021803058758089237874818004404516229096026612875823708185387519711434118448231175696552473972"
        "5514269341594904066527742443470740785459170633244811385112780556696588157177143608961573643126150562761915"
        "6849281750933181906556668480299887622009529190391532401176424108617948387268885330819182146283103769726065"
        "0618579771433274264469131477484276258449987868177936134280895329165600889520845336168357333217832316495642"
        "0441319644683365839431195202310742805276534309836915086270614032968345195613629397653273340702900233535205"
        "3483609729854816729883780272599181867846846521014410520170084903621204572180935977607232534510932678463816"
        "822029867718281826574420236100747585318545294634398450106527178604665095917880535125732421875e-293"},
    {0x1.ae1dec42dca09p-972, chars_format::scientific, 731,
        "4."
        "2091145246438698296464197678858462022320601841030835843206149990791488671059123306883776612699424108754647"
        "6736165489660708158188897653252826134814761213834692117553854271187898625371210169220451412074088885812485"
        "5710541461898075840990354146023487795168820924822425403426146314849307917765992062977805313760286080036912"
        "5671659281747652562037736469615487893495477714687409716479264021912064773034682227763646081732196052572030"
        "7042509474279237735500174408103971978728587499232657269969095263398622200501943268247798636403094152328953"
        "2031147634770203769239297303467977711453401539253419892970190835849736701525053640119980542501565476014438"
        "53999776062961816363960978393038157465241961259638119909054498890554896206595003604888916015625e-293"},
    {0x1.54ff221954c16p-971, chars_format::scientific, 729,
        "6."
        "6739709449862607565675687782920119483875632502307667185780159162168993863980184050971107230906704288464015"
        "6496699439994300838785152866487131226692050111421937130047388309431505994270060996058822819880128635044711"
        "4884254092561109053574594536003321082373236228343853763690520906814230225860764906029592314130816213101024"
        "2194197916325697362693742596076819693587167915078095246529186795090291998404360439137726334573248196108267"
        "0822286777585677288460873248318553492874197977095601357714718256395148609413826610224397173111647233642602"
        "8926215761392757848297473482615711761267249168799474035866969371240333263088855516815397668226530197493884"
        "525983129937954791936115506649432796777077774136549374872640072453577886335551738739013671875e-293"},
    {0x1.be2f99979a8cep-970, chars_format::scientific, 729,
        "1."
        "7465463640233769100638197360771104302050851103989186606102081931650026488304599327327558753282729200068332"
        "9804678627668050378425568460067787042712273854355127306999057546471422220437915342161900314891762709292057"
        "3721527715623421389755093972134547171078825977573421206869147881140899358764839567176481371382813534485115"
        "9835678704427518919036015896266154533044169369007760086516985334355446363476266907650310724315327746390025"
        "4578075093931194270369530646516335045309634453905095844888951319898980495309981925213072753792773010838101"
        "8242065386226332023454226886482050639863587133447070386576679785063884990939398460469896517681871811495270"
        "565050105345772489759853919318571093384770703357713843295595523841257090680301189422607421875e-292"},
    {0x1.462457ae27e71p-969, chars_format::scientific, 729,
        "2."
        "5532945426002904780507157538181669248527607853073242744554647032768966856497503985566702814500794761713015"
        "1141601224844822200746378164407163008645601989012874056444092985231929202649672787574039697242924779836829"
        "0103900949007393832538886143168315948223660409479333004620541843867294642578845204520026497108979679013560"
        "9295231175581237890039211997494098462608140330553092569686196215361473140966026675727675473684805370218685"
        "8212126583546909956560076422277384338487963183774513252266281901186798524198419702068981637862802969769450"
        "2793001789351434068617111543379937626164684311069822291752668796387656882250217177699698369291172140147851"
        "454964940605010325751218296624302065265450254613545551241049480495348689146339893341064453125e-292"},
    {0x1.c9bf289091a57p-968, chars_format::scientific, 728,
        "7."
        "1671990510048377614019126542833310289999616144912903876805253277584351602647703123458355536528192167364440"
        "1662353287232239949764532980184843582562259507270415311588513053208283288743801563778406068749572307800194"
        "6125568827170156775233327361851224388982041403917785806215783044313688219646403826782962055511360668264737"
        "6897088961002236150471094097641106960350616121428369305065826571573273641647725775688943703343567101225478"
        "9953333312287057640008514453879865778655393259160740174367773735675048949532421715134949497702708361285237"
        "7322542673884527343694192326023200301290131404052076274549091612163177499275646656982709711584001572445734"
        "84733167635547219613675510582898110780193501917110197874105637083630426786839962005615234375e-292"},
    {0x1.c9a6c21c0e44ap-967, chars_format::scientific, 727,
        "1."
        "4331413352279302128149191072605813876697528611345885441115000029609556842920386965482577284207290323742533"
        "2199509594307830151946681984866655822228339143835403194270253223913061678439860917065041842332387051370077"
        "9500944288148698788627957916496725038596154564027501474646179397442030182754135054292301436144243035179137"
        "1270610282715417684609169626900527234807117188403332704905395975649634750649953559577652559528484291031633"
        "4676186094662346061090628337052908713177247664619683224737543046454127747542696798955644966121171604862571"
        "3175695589578575525883542807316083301746126724381306477578494291843709874477007787068278367148644618010713"
        "1875144882846097603267302176234293033266604144621188254848931364904274232685565948486328125e-291"},
    {0x1.080ca19dc76cfp-966, chars_format::scientific, 727,
        "1."
        "6537479214140957496644432073018089012144452120603766472454112579144784777132047524978251678680652305622500"
        "0499253635866315767976997523004602180573355978400757182575064036053958408210190339447230879379051417089690"
        "2600640674876720995879922414089510417178382171731253321930144431314913298710310772875402641130578414655191"
        "1643305304636464367182427851593250624197965599005919337369891600964947788560805510699332326217569801868088"
        "2270353417276939433992552778680098874211345639068458050074871457491113617241586311735177325328666991945594"
        "9361607389174582641520633304112836941762385362003194298015982774531160072879490045018610848272352089449297"
        "1559993956728196016916768467473936479509527842902093242027916630831896327435970306396484375e-291"},
    {0x1.568db6b9c2a6bp-965, chars_format::scientific, 726,
        "4."
        "2908439090205467290104179871798651941226153898698783477673232932487248769134773470874791558624108005131697"
        "3536088629026557536545749155269194293346060062071094839619735992744602682720872020489985764651605227123683"
        "4449315338589395858711154446384822881445654088301480606833643769669528121156913759180085536698487352616174"
        "9640088098036503504388607252321301774363944935742492341884553608844792004824932319261176330222096044026500"
        "1756051164867224989944424575770385717357779091208619818711665610895151705642793452624142140189626570619779"
        "0385808753024813077649775797625712909337310437672688236559439684574369461412897368191004528045867884390464"
        "739907179528687280026756613807116577015152709246269269183216010787873528897762298583984375e-291"},
    {0x1.8094bbafe93acp-964, chars_format::scientific, 723,
        "9."
        "6345631221449255842528627098837665212135824138580247641095033482922043986659116736534146977997184184550644"
        "4601994755561347497711188804648235220805765618575601316863143054761832211432259334276682908110694267973267"
        "9363364525747904721132014099792189719325293711235087718438176498772644269414827594417119678477271996103962"
        "4464068850461484304306996962247952090789771393359568041684499232396514214051736756405489381778675872598742"
        "8157370116667389407454794188886316922944939839391299995745043273460133146343884929041994919904676232308848"
        "7621676588987291499515095008487221366327604330469301849090855522740604347010078082126314423497545739632197"
        "917648583593472744787066092183286022494344519144504612739865478943102061748504638671875e-291"},
    {0x1.a4d81255160e0p-963, chars_format::scientific, 720,
        "2."
        "1086057222075156140699923441456450084308897252727905713437086108596166987468409078397587971487533636066512"
        "5559425961800525159988473481938995387145032563193842335341149252710258276907339069644310335615204766793420"
        "5046245456558650038735730800871978103887994564534273473274917826583210324132525399524175049381515195829365"
        "7369564370243965168645236220245406226889139007890757799017450226883309511109663784656864385739561274426355"
        "7657149281665440973055056669372106589677993963623493823619251634129655150817988363340633174195752548807091"
        "7823271593105149749384800080661837689037203940523891442460358685629634666925659895161508889612895551671788"
        "573863480573115671110693838776867128142144224012266562340300879441201686859130859375e-290"},
    {0x1.555b4760590b2p-962, chars_format::scientific, 723,
        "3."
        "4206800637910766975986348248756809245585722617245253884913765467082902655863539744793091912901291965590203"
        "5289765511658279266066746655823602750349947919758040236162078686374492458909606117047221706343896128942681"
        "5347747096631346945775370008450257597462683149099332669442286046338578340101553491642092478945964573763265"
        "5303976057606048773717878928602898047324228476912795333101577534185800126676720392565056992132832438154329"
        "9424787438555730075039358292293164678724048090901309369949159601150254447351579618707251348992673994468585"
        "9607150588631254483057331394140758973297520621645166366212282409238633290902812737463038899559245953449436"
        "212948563447937782437491106183531864268581560058202217788902999018318951129913330078125e-290"},
    {0x1.4ac2efcbe3305p-961, chars_format::scientific, 723,
        "6."
        "6290167589677367951375617422929271680606864220946847505992857434808143549267256285863593676807534571811650"
        "7990734126024664323017252510560123157213222771972932719343366101285834110047644303294398466421171333829299"
        "4338219373247383273584684158361076342788872926422826115587259635077003684919003684823669045395557799403510"
        "7919232269198025498868586627294909726179966695692030720962338197573754049554465371037256488197839056598921"
        "9877292992603247756361908752192553418763996358838205450960619495274938457068746433456118860927509511328976"
        "9257647430285377053075634126944778075167863283379686258333392834303348019917586267926480779517948478918927"
        "063607609213267237687171277444430229764849742991883463361091344268061220645904541015625e-290"},
    {0x1.5152151a900e2p-960, chars_format::scientific, 722,
        "1."
        "3520946857575770466924336009049788127880386587840573750855126370148211922936332843549880833329104097140562"
        "1291061084670927969996645981504375234327144377801924067740766068048371191442881668323888989913832196109695"
        "2897929141749716680995649364750852884940442785486690547343872512681947134948592736866712512591490524779325"
        "5090731673364236766649870776441267794337031914794723417664812216517460238008000903094550881000779334604095"
        "3306025721701601332578457998076339413637327928622239485921271826646340819118973796496053821335859717066618"
        "7905138168357733394815415483037124393427107254818942235087012334513591656298823628107449960996084615787537"
        "90281688211841686919921141420718345664751217256871473892942958627827465534210205078125e-289"},
    {0x1.7e58e6c112543p-959, chars_format::scientific, 722,
        "3."
        "0651532125319828043611403886497181631776301530986382422563220573322643168258847453877099886269667781939003"
        "7796781862197307930725514343043551254211702279911167296696208484262395929929119796791221572069220941246112"
        "6684609711196673612053116397582155620461783165845586140232413390195514862846452362791383900061129942543777"
        "9683856317930346474170707234461546445785222564966395233185078975823809338083628329613971259053735059038816"
        "9226823931122118444143013014003539703511505762260490564710070701542059395640989371263266941829283247158447"
        "0128679373107055110632193260404785063947141156633187195789592983001451297372755688720100822729534737038975"
        "00046421729618175608545958200349764878121067677996247624605530290864408016204833984375e-289"},
    {0x1.3c778445a2b30p-958, chars_format::scientific, 717,
        "5."
        "0740229754679630015597497635411251704782842388847706892559998222461039019858354788545899536364164695375615"
        "9004970663065251376452644444722367868679833631961456879821363325500296762139359140059831135664037636091103"
        "7851826795084045937024297722699696856108091789878307056427588017412016141242065429389459914673058410334447"
        "5029045630695628818864852040810568120665859876397220638806076762863741270024917808851144173068814023493123"
        "9465794949117932333473719195382807214003119528830022330600771410797617629186091757430776249487934472813481"
        "7295607280179935636124185858339459651464992994383411267201247553011716792219570153380458235643643535470204"
        "673305630435954878625940750273716264569061340505840007608640007674694061279296875e-289"},
    {0x1.d5d886a6af07fp-957, chars_format::scientific, 721,
        "1."
        "5066401531008765660209715620847113430721240845311467067488393060399424689768179013689935270456617217772626"
        "2449294236315192284938560348589795751273940538757255549062206419695642046911817014605594134791735095417547"
        "3496661062569118259538483356471500150312765170021570234313983189886563782145873240440323828891290807194213"
        "8146945071589392359015982750809131377045618332285170839599383602029439803065564549875367002305011744027345"
        "4791998767288977253280431451014572515866251973827561103685944590487910895898225162299074096391327451735400"
        "5702009089867354879711711819298254603418980386599420783790582966667612569549001195037944795412981296229040"
        "7978653640090229326186696355379052802457638497724001780397884431295096874237060546875e-288"},
    {0x1.b4d6ad2f813c3p-956, chars_format::scientific, 720,
        "2."
        "8015937941494582893752219699378451541676163091913910886367587801515223826775770979017901213581846339239008"
        "5972743564483406182138794082415708206777985372462737529604331783161052369852259640641682719407243347401272"
        "7456932011627695318546847116981997986538474037406413302814400876575334916367833693107072636011428947924771"
        "0431832859153979633857644425954502850284440493944167381091614718033977997952112454266036283567034492773027"
        "0297214072392515941181272044503439934946642157033684526504794793241794104430220950327217291773091671208313"
        "5200570135510136075668818444233387687590160584099397367567846354051160569747236486489617845200348490288202"
        "051349985773023756814947896164670199036189450481071361309659550897777080535888671875e-288"},
    {0x1.a3accfb847f5dp-955, chars_format::scientific, 719,
        "5."
        "3830364529866897070892653133613309687768553145998845020770002508286663820178028904357041106164871662930240"
        "4292326281883963909154096452472893947755538934242330914543826959031146221568246692512569359075149804195162"
        "2455286861325460251680876019901469233112170819584404180268970996038988942682994555869177877222572726704409"
        "6706370606363455491707358638817637507737802603692179707323013726519499078873069293802377310441059050095455"
        "8409431256576666225481896876642690857726316749420932215444605654341122928806547906002555368770089678159201"
        "8321956437180967622979120309900059276854565582725176763468818525035142169991443317320021522630614922936712"
        "84130552998907366615149384496898688035417847308483629831243888475000858306884765625e-288"},
    {0x1.490cc71c1b5a9p-954, chars_format::scientific, 718,
        "8."
        "4412342380502576546081430450113714547500629438411347771053360322063370388173904974678292331037009777086711"
        "2099414815476448744759263688277212497420153992338777818006934888909213572957511956634738036763365144586177"
        "5322858389270843029115166607895428831657856603626176699984273793880426192286194266443686243608836600001354"
        "4530110132454205033116021887062016086384595971121585437748216881228804338113019161359341335927611034275239"
        "4037940717746332315355023656647031482236645528004617260974202488109127266152579244998351781422253738236175"
        "4243701550773001844292452055370516538649507594510998476523084758454303188096588303409769684799427283670348"
        "9527961893337125050753747867908906204526854610836750225644209422171115875244140625e-288"},
    {0x1.4fd2a30c2f2bep-953, chars_format::scientific, 717,
        "1."
        "7229963037415353860036939274512602607703473934570316813755563202371450285352667556180727589154087041362056"
        "1283459465386257149814404426731073509224486647540553797898000159803219506010895542832878489629573788723953"
        "1749999981802001417396108156377958282976764626235599595602595041214194378359560862503860866807909172646002"
        "9975659200114921786030177059914763470055885610745129137128591706559908111228082064091725340897564033533397"
        "7713665527965071968852553983251712474158073574273322543402496753700449881082906684354028745885662376033485"
        "1322987488292975046799929539221349587261627100702755350754850783890370827469481884228645990808184748247674"
        "193083168557675793886784178115221749321393784892819667220464907586574554443359375e-287"},
    {0x1.e712b11ec1d63p-952, chars_format::scientific, 717,
        "4."
        "9980227888927947361544276876048945527052628694146361153893340602625907491058574989544577033169635434323920"
        "2363631494369169360431693425214763451868479262473007994553742587698599717845223124301708762653254310627635"
        "8615929213885810712355953882567405745554059674387476562405224374765909844276132250641182466570610855208408"
        "4218918059037991974479006158869305616984906845622665393220531272998910203769643038213835331473037608225072"
        "4904487349755042619016279363453628277094581074974439583045948813522912747444842573673747533613488115993276"
        "5382595260797681368667692815244795049862397821162429723072459989031430648448876485854621050523129541804361"
        "218208441699108218502865720166791044828773216135431312068249098956584930419921875e-287"},
    {0x1.a951cb6dfa80dp-951, chars_format::scientific, 716,
        "8."
        "7286979124915840031811171249768746744436889710675327400944811289743437499055150408336143447207699067554825"
        "7442958324490534088914416947203034596292953382062295275457233755524482929174694081985804881831251240710578"
        "8126951104999460919138178657731447361495992307164569451115113425119293927665641245442265523577467103975280"
        "7359164333796045189813934206387956229569099202670383997385959263031751034359811529335821735321526957957448"
        "2300932318121087160706915252100028942112875612578710323463601402080899019147011869735277375358119396699255"
        "5371084452440315677385870831672103657333622119478297079186131716864900307968338276669280687253563323393612"
        "14932314316194561659184333914511633536505164077112794984714128077030181884765625e-287"},
    {0x1.cfeea9a77e27bp-950, chars_format::scientific, 716,
        "1."
        "9042271010497776332001708801330615626361603928163568681486870742545599127089701284279280984207169692023217"
        "1320030282687303728445015162144559242089873660014349397431364036606843290349007956825150392182396077699610"
        "7081360034058760638306226987187123573951079730136436300311799651097396464377723858909261474710812858063665"
        "1516285060709599373476272758518992824461516136888329866236431665769165459746602035234128545216729573491347"
        "1603418758679870235818016847163544362617754381161439704896309338364473880342545334782765942594159926024292"
        "6776721855571408975646106864867688734105951682537834904812715247258315613008475070905740733513696526664356"
        "90680061075434980258140771483701977439921548818091423527221195399761199951171875e-286"},
    {0x1.61502417e8ce2p-949, chars_format::scientific, 714,
        "2."
        "9003728382951163001336386523617062381286133744090594743589414411368340653555137244271537591451655680687315"
        "9732505961309688819203604378162522072256819193225779837080532812628857860412608929343509699484705718495967"
        "8498590349546873362607386039910958079726915480506740564727937744213886081662414338883958167769615634834449"
        "5208205332455141483630438934437969676485027072711307631327019462760209568508259406390712220813594963156926"
        "1054788729428850637210162360658988869878013349259167463031826438489783029936508298061711618268376301932063"
        "6233705491974210920522838275477083252004563254028764269886961406388361787734609729556483215835413375983163"
        "021711842878443424060979670008305676166815434413592811324633657932281494140625e-286"},
    {0x1.6f4a6043ee7bep-948, chars_format::scientific, 713,
        "6."
        "0302300114805323360867140613666291548447107657508151641660095102893904089283521303828228226597660628182350"
        "6911153986869512195032232066813781715107387668300048677099943316832593032950727022533383996204830780873687"
        "0336786474106255162862393383020101537774908499396139970912718835720263245510686995538097893670858302693490"
        "7891508455961763342319381299089701452017976885541745003090606738691178664596292998458754512228941266385244"
        "8007064836689028083268810534974265755607698465042353718916652874807767108414470421851891490105544576545965"
        "9578607346221279870994992550342662655560173662144012241644703804158632807596075223431027561864483265724367"
        "88800100967001687104564561953359727412837809623624707455746829509735107421875e-286"},
    {0x1.82fd3aeac2fecp-947, chars_format::scientific, 712,
        "1."
        "2707290656410451972148714179141781588967973845926807547334471277675980850408554878248054803892782582018822"
        "2534182569028299426262570059445694988348700318777825258518784535605857425130299671300426071383629977858895"
        "5387337468219031494910244066256770720046737203696728672760192370711138924283768772475940785693724826698986"
        "0466008993894741453396502146202005519277127551424134439683925893021558019255827189881118691971239229665920"
        "6657060745898812201958149661378249840066133255936674274226197607897248507836438905238727384458811013417251"
        "3379082500885683858207793250918021016981595825486761813591464957247173777907417675517257352395503235491976"
        "5037037450328159638720514623892016668749160857032620697282254695892333984375e-285"},
    {0x1.fda8896e44ddfp-946, chars_format::scientific, 713,
        "3."
        "3470583063356332108498766757166506385353764031783485196998561866179457340599432256217213352642082359348776"
        "0065619379843121648679832554328338726173157671099841073635018988556349126405324929433103638921411010000406"
        "9970975541397062403299836691883872720101591275772567836499474144709269745164033553143381865980948114813450"
        "9563323398425378499328625730378201514987590090742627365532394510810911008494010157265556059636318908537716"
        "6588265752427397414769519174240481162648267831006229274985704703073458419860862001834681264408952610279695"
        "8120272042811100264333042992405966114086480503347740480307977037393767702327170428860861334438521055997639"
        "87519384051736961186649658053551804025305127510137026547454297542572021484375e-285"},
    {0x1.f63d0121b757bp-945, chars_format::scientific, 712,
        "6."
        "5966578537292035157422433162339949684328657517781425278937040263737397772577187341772038360860221866728139"
        "7401687446570117084677990224984289048367008807112058030080344286777952675512614595714878804489254477073655"
        "3631788209373029438911737396887226525344476794228878774806817015940622309814103147301158180909849015378481"
        "3123115801307697707920891837072640679333216386798989999483042211053745064747961945094371289546480468588624"
        "6554648581517370471456957394934735507329277236644627330631947684311599090344589073145189553679017707785009"
        "4743043339681131317035896807523747130636300631758866165476656409393301104737836983161194297942630550081578"
        "2254835380854001782230228668880262464513375419983276515267789363861083984375e-285"},
    {0x1.1abe55124f6a6p-944, chars_format::scientific, 710,
        "7."
        "4273986683209386002029183146497792358537735412418076229677375034053108781538417130596628794716377703048792"
        "0439447874391640830497329263769197669372654570210896760100817222039133059067468132996774053651076190226967"
        "3589441074259230065627957038293185520235291906031948115381397829092825319154312472026340183818944682611111"
        "1156145441474169706609373281586299060755244822009110650534665364827404192153653867280756103054142218360222"
        "0934581061734895574051354048724565591943722679704655789621606831198408689956651820414839333271464401183877"
        "8450966879494076305659347420726388904357845227958574995156936912713306237255628189778269960699349488082411"
        "06386418643030651008928724469602099256260174797716899774968624114990234375e-285"},
    {0x1.e1cc3addbf112p-943, chars_format::scientific, 710,
        "2."
        "5312725644714645962947927743805809804618884397617821437572318458550743118084862705289205943966038119003290"
        "9589290532205874362493462899587538183794311484367769029075747596682977338151350446246593552098587417080875"
        "7851469248740093376850022734253382347640497467551967268290362838553891696265966263369157173634431861777730"
        "2846800242763765681365778209538316436546166804404273332427861460075267064607964574701863428965562408362011"
        "0521953699389815696244858788510527465075072050708829210926602831437546879251441709037514462450585484637061"
        "3750986429422869415728090168020176752627553816027216600373170891796638653891754210465863152465601677758468"
        "90651442682066021379729291296127070831634142678012722171843051910400390625e-284"},
    {0x1.c37ea66e435a3p-942, chars_format::scientific, 710,
        "4."
        "7441324100905745554574287302084691280382079597193581631559111336633158232950997129792894980805894193066494"
        "7024126350169270196995072745313996409498284229154731375549048678636733572900612861491971019072075638834606"
        "0562319519438688203810434951289695484950243280779028505894245638965721460493474958616244676132192911374490"
        "9744685596656046149778452097128786811551965968423994803335170886805118220108585832414027702378690965054682"
        "1132637590793226042392427342459479251395153348234719604672659565852875863171207615153939055490446947865662"
        "7069451502833062779732643453355045985620373037341930171564015143867075156826922069841065014424129701542771"
        "86018963546023944039247179557390425574947556697225081734359264373779296875e-284"},
    {0x1.5de150d8571dap-941, chars_format::scientific, 708,
        "7."
        "3528110594538782482365773897168607965627670328398853743572294287489462941040004923609086852490422148378042"
        "3221265352794066364321977056316193229087193345799980407047318859371585571006327608060193056679922161895138"
        "9023450857711029880846747347949781266947671465791140498898018902300018409192427375203800129541619913353668"
        "7913336770565773056104716911264461178801127817029921714572406594873525451090759250061606175297688853642741"
        "5063374341194168250819599742158320993808193105179075468474640923879534600345563234330664743865595922943046"
        "9027013248365025737108296595578764740793659540153206839917157674241108599911219442200327046926386379632794"
        "706173770738386202136504580487326443449802582108532078564167022705078125e-284"},
    {0x1.2fe740d15c5e4p-940, chars_format::scientific, 707,
        "1."
        "2773195914029404839997121365019846678012360652350488064445378102080680878178292751812127902282256650732547"
        "6245703207416712594596348672625016459895425199193206223669274574590781615279792558252820397973515964842037"
        "0516008716769106316730250486845936703583635694598574992126846759388865096988008602912529868185336100299108"
        "0553719525657790562548044625513894808092631398771815402398278693165346783864034097203390263050764499973133"
        "1176557957400353328895833934462164126215289648841232814684151554950526609425364545645803014958449858388387"
        "8330615551788311376615569801461643158576202752253276793725354647037131210454236435093465752334159968626474"
        "04985643869421282773361209076680433671668879469507373869419097900390625e-283"},
    {0x1.74c88e0ca098dp-939, chars_format::scientific, 708,
        "3."
        "1336514683809335823642014056905165811057462424986100566379077646256522264565554151413406651253885848300977"
        "7428810212153271901858767685448835580809572557049468597099913066770055289698506664019615839038475534710535"
        "5795137683512491796292640286340784407826504261360116668998806692920326410697970081470553311956742163565291"
        "9488919030345834471449497634015773733880344369868510365310417368327167250001545295912972407904243385685009"
        "0568326188908814426299175347109946078168784813256752832581828231750592798891910497717653512598209256212615"
        "2163332546148270577877121959807562829701730894716563197686457689793871379392247928709120246303744498721385"
        "387058298586846638108429548307855283528766676681698299944400787353515625e-283"},
    {0x1.130f11f4ae551p-938, chars_format::scientific, 707,
        "4."
        "6243399480760986651758048859591898670257532481551975234236150685657300241821139657878022784585233874791240"
        "4963492241550289496212262096830935350508363684680527380586207161154519672283951737774939811483462728083444"
        "1777428783029826723607606656979273452995057139008359627554000935187030159957139984855268085241021567271742"
        "3431954876230363643507044623195289945422834721951642431654272869278279463263248928505373646536454486629285"
        "0388933272047691776851011626956714255714297331667761444662037758523239544520796498062658035671762514053396"
        "2546352624989961931110902588588758282909374019543277991567132082147774864908128579658562342391043382460857"
        "66373351339663978363866896439428322285181138795451261103153228759765625e-283"},
    {0x1.08835fa35800dp-937, chars_format::scientific, 706,
        "8."
        "8940877727403413478054422469551585361360602132146479276553748560572263855354900108174388413873810810570869"
        "4447652663318550897683068640027357513815073547307056520232708373475428951985938086920965381705362856293155"
        "2372597405794368429177559397287482636064879735202907026717819924195853075278831851189896959260779613681724"
        "9507141535585621250711601400414125889337957763942399330493823244145586671155604257863693476957809385848081"
        "5602432524204309644294980503300147419523958899518054102661427177982614986697817162798859038178707067029274"
        "3666765992474172041115451984467344953683138400045170040908790923436569293770430710009650254127241328424225"
        "1963700416095371587683104442657866517407683204510249197483062744140625e-283"},
    {0x1.6431e220a8c23p-936, chars_format::scientific, 706,
        "2."
        "3953652083727512388926071411736651094684359629139545046331701056101374156295569337074287726281108064839092"
        "0197220354257125643370788918721253430411000497833026470918438064748906303836803667779264399037996493294682"
        "7799070539590992054178881563195508842237166002254838778941432287913764333677699977715082668936870273420684"
        "1637889564941327849417969580798865985391354437385154150217050073066367310703953519083722746947699236233991"
        "0914485251702387166357531280402329580119848376247994125192476520054069021178244018175790204834170600687522"
        "0061280292199496428179636808244244925634931880191201392142822061160051761870987672004337971307673840421985"
        "8403977956304139210111692789677284576299598484183661639690399169921875e-282"},
    {0x1.17acfc1134894p-935, chars_format::scientific, 703,
        "3."
        "7615674663262681818855898106340652384824488135624420876733253077105060946198861732627493193519901047247753"
        "0851516450610526148310774617875503789522940191314377583805558176016959667319286171660282631959695917660262"
        "7948161600893585841102962267471970566960719972616815524052330290448761157948723719283892809603393480152922"
        "6963821818326771744159065697180266351038889725789977121282586495071803503310337622258942765229731736751373"
        "9802285453673323672402567322678297740121435959673931330218239056618465199032675986831449764985280751644590"
        "1051071633900768229571292193676658069223654709451072516761075679530496081880163478624608778936598616058103"
        "8975154763000147609318065712591394600394778535701334476470947265625e-282"},
    {0x1.e09c9bcb32e3ap-934, chars_format::scientific, 704,
        "1."
        "2928212167160485647289050725920773987486183606941436119505729854684825071061879741408404976987332542805202"
        "6475209722120894427905829017312531660824109185257625493974124746918871520377551204868603233138855433546350"
        "7137482116585173531717089284209974439757094815476313032633987246657466217424082287904980049799285173092360"
        "4321033958606419596582626473030678859231047068503703431925355566575260878258096148842990948930661388461594"
        "5556331126875486164601415077624257882874367569017493013432167566077044569124299536340949294173450937422124"
        "2410848684155513238368365796187170024735560371706926710527316014102463624584103054216799753888489426954230"
        "67389883463190992127388374323404551802241257973946630954742431640625e-281"},
    {0x1.a1dbb96340c68p-933, chars_format::scientific, 701,
        "2."
        "2480352182123752808136544940388978663414452868402807172164353048087159318240699108852308410935527799042372"
        "2607479167570828666405584023758943395449623547786265060474719000797492782936683920058858257998717582822367"
        "5779905454921856840712616925561352311554761780822321050704750714835793645031281809131734465005054259103162"
        "0770295421779702653225582120691078585469805486852420383602140963091660990507952839665684312488509192593627"
        "6146801902962301794667900084167998719481932390233466300406339130835304539931159145009172042189525782968134"
        "9889384996716260685606079478830353867971542977200900041965604299936591138903279189511225516719288109338314"
        "76652227485316062853136671872977814246041816659271717071533203125e-281"},
    {0x1.2535112b05fa2p-932, chars_format::scientific, 702,
        "3."
        "1548509399420712639272059276400333316882547293984026315247476639493255963348140121345690526759136674812168"
        "5127366607186078984663434814626878761946743591353198878185556202712852448632736187785808850221879652949417"
        "2466935302619475876494375304284254242084862440019357167612816636962625129579057766644896049407870955464974"
        "7335787221346083512058193881301726918508813388754032954001938768613080740109292797103362848370010728277700"
        "2447037363112380936616653230090833282091176580530259321841919447337344677998409580350026291730548714720245"
        "3464907595976076416622159108849254870594068881747711745858983412187878188897296623397306560923894227742617"
        "663131411366557437721031172117580609892684151418507099151611328125e-281"},
    {0x1.1a21c468e4a6ap-931, chars_format::scientific, 701,
        "6."
        "0713639849830441431950666885186177075226515153992662907626497301095398390732446604186943203382345914038884"
        "7323282265478315251107842926851637284944473721522256210665632511691427823143735225088177817782851258604105"
        "8802465427960568227820236551669931647579766385297520509184110046667024917465803528176712653827604854690676"
        "0539717394672162140625498504576723310423343077058148234412701000131002157689180704997981873225601677878672"
        "5558225608403941078353606559612621001943710817919983755745476941534320115237355705280174943756986505561652"
        "1642323629981253371080878813132722433052139744568133360474352311923115847036015008659884511808602933588905"
        "40549489846723710069942465950010301867223461158573627471923828125e-281"},
    {0x1.fd135d461e64ap-930, chars_format::scientific, 701,
        "2."
        "1910202165183367961031144734329017463226979382701869453713513013968249085356785932288012024393541953545552"
        "9886645511615889973880166664007518614802113825590802875492420305574416936839892706860731192309333765848970"
        "9908439585083718902707887189552668448593889249735204217996658815646772179955571823374833497551591956309240"
        "1541329154965837938438971554547587418225460815133461459523484200094358091531238453626872459122480596669953"
        "8348727335482836669569692921603283834722554959131362093164174528692609148104334930473885438918883552561594"
        "8363008632224664238662463784686332242084676173707932159699210038441526890720252029751413671687868241305111"
        "90159598977575695967511849870934526052224100567400455474853515625e-280"},
    {0x1.f7d9a435e9332p-929, chars_format::scientific, 700,
        "4."
        "3370603492213999246605109863562578922697904205023479088354225118411162637603179888703710226609475240843189"
        "7778308805673483166109113138700510733670800321786228644296296310480876601318227660027323174410959962952323"
        "1073474743346300893802816394194037660492099236546107192724017030062164767337377700574128707882663321060086"
        "3968698996521352740869816450919671756597948507794800031118955538243210878544952125774573985954020360906486"
        "2954843068964485740002357562419225222618117352360709939373196717678314283249625825294875669011304620563035"
        "5933690645526817739372794594388572468529067558242499477463165957541382915860867194951359610429773433468680"
        "7656652381430992566229733198301943275509984232485294342041015625e-280"},
    {0x1.94c659bdb66cbp-928, chars_format::scientific, 700,
        "6."
        "9684715728693185128958785274644908897459959339474683388991916442657376227644833807738962310289463011013541"
        "2100965211658967777232367812792866866542712076638289606844458587892947675905576979450985333650908225454235"
        "1258556803112976410432769807463403605097818593159599336715606881192650863075807426528516907258685085390493"
        "7589052995111653435060748089104567805432665743598861338717605076720671406807599807657542183118213510386647"
        "6758091298822363245367286109870252428162266516719305025469724969389301398868015871079726249945173149617262"
        "5833737082375357463190498230523012813555991495326869696530083748073407599377627499057902905597850692529203"
        "3909987407906166508790406222129121260877582244575023651123046875e-280"},
    {0x1.abe769fc688c7p-927, chars_format::scientific, 700,
        "1."
        "4733311152437789540227053092678323460332933852257475188822441222074344436589917689823247953665290710696624"
        "6909916118096358672315472282160539273894339479994193169330520625936397519235918130249340730882903493307621"
        "0895612852780366731538499350545049966975086920227034460151662663011478742176698549702779007271900180889286"
        "5490797177322439918350145063046375849294907349943601734582058091677850466600549179567598052592528981026904"
        "4947060856836578814899623194745365093095429477087602427196556222424895294076578456413124521507596172456938"
        "8251331129730062208483813193703538285744927685484325243111761550184614450373063948573745792548306864820340"
        "0069389217127511839951041483498528350537526421248912811279296875e-279"},
    {0x1.825701170d480p-926, chars_format::scientific, 692,
        "2."
        "6604406094948299284840023312889151895045655703225518408579970423545100011582978514470567087920738321442927"
        "5307285432371144591909800719245957781141729612931668439653482875327754820963954270428962349149199726835698"
        "1184592735245864921999727092722643583285720404162313925726900614240612356134419032262428558843961823391328"
        "7064205337047968262378349013995361823268143063235754023395627339613127590917817943514492812352700718204492"
        "6865908504249555492149730428374342137900767838918385014099377896161172321732594458974432078343771471436203"
        "7560194621358324729605336632503570581400682087260645108688451326585554293824380869245358022373059672081904"
        "52841033281990330838784331035640207119286060333251953125e-279"},
    {0x1.9cb40ebe2177ep-925, chars_format::scientific, 697,
        "5."
        "6839734362842070796608423358963762521942847688739811715193332262874402507007578228137833409228851937575142"
        "9881333886818972762441084651503135482841878157912998491023471197153193567938330820279182603747487685157804"
        "4499143359656487408812158088001014917344439759287983216092513910053323400256593370050435002396967994998634"
        "7831174253791387681379454495092330365305712925878132005668316354328176029389998813412358306819750991589464"
        "1588404401875403708454179807021556382772917776316285266398822892936165695523171539159535919943189320603911"
        "1057506511608802173147778806205368856349281475078098721211793053402011838737841041885975679740409233160578"
        "2924669070403089223518511285959675660706125199794769287109375e-279"},
    {0x1.ff8156df08505p-924, chars_format::scientific, 698,
        "1."
        "4089452631685326968433243074109517968005896956405243537738629556725543089192340456976745618392509456384421"
        "3295122043611679935471391755079980979501871944052554986009587710715393810226977108801992230611058211129108"
        "9485525691899073270714769067531770667572601957595368192889003105509212398388055993160239542503494835067228"
        "3245379563818248188577432178069785517522144713560421250029225560558108073716075633654170491660565462257320"
        "8077336936537681601495287937831361476225032018916859215383170855286140431926630333405822225809755086425841"
        "3403531304832809177251851959422421163575904569070712506755851911160818342317775969283615277190753064800086"
        "42654648867933132806891383115299731798586435616016387939453125e-278"},
    {0x1.9d0f772cf5efcp-923, chars_format::scientific, 695,
        "2."
        "2755564362864926940281773480518310790479861467637050696098191485132841536234255195968894202054768127594340"
        "5052471207178431622061755181896773453067772352444724262922219671446487226142118896359570378668235229095798"
        "1166316968715768476878377717323676558275913110625496417171332179028764068241742129287569330477989538640722"
        "3078981110638172143427694907604433837129087063112485314874144827336251086973085916732340036992251561259733"
        "9675515620741030786110317330091445693562528485582028687881785896904192513842055970675225542253236829083202"
        "3599170155833556378582588541054835832258928781218529554093314331968991940112828530328124430108304974376277"
        "30945405107483288202618876283622739720158278942108154296875e-278"},
    {0x1.5ae0a07bccfb6p-922, chars_format::scientific, 695,
        "3."
        "8219068582864352723967747931343616562165720978117376164184044778882819856109340136059651353300760019380045"
        "7963875686854151814858111036445511242704770934444137666535548776414562807926044830228719368181619572195896"
        "3465354214067102619271776398409728111334674729760537429642740220094300496716298519328903002429770328300604"
        "1946617762562693335543494641811348659320099800248426163155938515097474857985088679151812942108594818030328"
        "4306883294509926394689017938918992450263082868445216830695420503163246032988791848623232836381428857315417"
        "6463928935563277762910223655851384736110714238400238082211026707573695288948291896607771043645486689943174"
        "76597365746052831735057875306438290863297879695892333984375e-278"},
    {0x1.6fb881d919007p-921, chars_format::scientific, 695,
        "8."
        "1031176278644846070191626517872180531833113532613231879550018095229278369791466764376263012400841347446788"
        "4537069420798897444792340459678011732950473018974004142598230372463984780283182332380363238844680055174104"
        "4882685402671409590390401829607859501011832309453302992160500266190368039980817257528474182247691498330235"
        "4021964279286190987699675882237711813507510953617123368849494245241661812574268038787990734683012163703440"
        "3253494540299453377386417370013446614658571822640671013053242841183193770612060018133599299419386567835242"
        "2302987448586734996718282943690713535168181153513958291979209420682272276968832405387188696007394808815855"
        "34337397162967550449941267487474760855548083782196044921875e-278"},
    {0x1.9fca25adf211cp-920, chars_format::scientific, 693,
        "1."
        "8324734254279028869387784372851448047860823258323750611134821016907972862665862948679459543729058185314029"
        "4109234291012590537213580345220640336487442495620076073943474905128820570844254967289771491084820829982316"
        "9103036957205913876376666459893503223052173089296631419583528827717374000015474402335079386664374426327190"
        "1555348969754355893424268192757537688455844358838861788081285696553822294575029080340122592400621898485210"
        "0980586377051787274079525731758978655809619252450538245824044682934365444142441443713505465606942364261493"
        "3323336396499777095021957372015947166181084102535422709985885556677780495536599067966610216695720290798005"
        "524230155507763549704858263567075482569634914398193359375e-277"},
    {0x1.3567868a935e6p-919, chars_format::scientific, 693,
        "2."
        "7272220545317517868889157965337696025274508420889298588711181595213704043378248791909948540380616435611593"
        "3910336212536767318988081781070397664794560055943968584737578105345111712898159054166131527987411472217401"
        "7866347800567633763552707314540341731219481235621611130507775509864789785266383510150307545015561531035709"
        "6185185351422301629593018870035843562289123275825378701398430382047446661917309450697462735918474031918662"
        "2340850441148530538284790831967160290452968341473708720459139121500038263702725273690181380827057032060125"
        "9532974827496579814102373524204368860193693113227607483201472667063978336888662018926203111235696960255284"
        "736973595876500901791228415049772593192756175994873046875e-277"},
    {0x1.bf28dd0f45ec0p-918, chars_format::scientific, 687,
        "7."
        "8829105150282179084399238370911642114983690457028991880625181033648641884093153361369152425774473922157315"
        "7774153926247698010132275250508458101810012251517742409690624130795818557484012862321262235357269411599568"
        "5913932502489931128923562170444579956137349168575918204365789567048958596408790512900515843150356938508578"
        "8171741990769154846781061888409738831181893137943969463124620309874532188237550188168195998920556942302867"
        "4792427236737851009052228703362388910682325650020113635567569125549130164578253048806221058312058858233667"
        "9214533967590618353077697183881161890577696002739400403994708829285246662769338823361787863906471416520890"
        "065817296459005358855165468412451446056365966796875e-277"},
    {0x1.a393be0039498p-917, chars_format::scientific, 690,
        "1."
        "4793325264349519609224189087172778660628550715159699314589946835960775139104114196387124361744349388346423"
        "5262499975290638162865880048776094965106354069497400210979615410318388465977151507798144171315330304323435"
        "9885975630954582425728852297479422077814813539875382686759895441332139770602381357809077363620286647587905"
        "6725196621533667569514255202620311480396908342237186203988319154990018200960799763004452095958354279543752"
        "8262461095548407540224109002577690372446359884979680520216781761547575060963446756203043820334004229099108"
        "4802146480535794498835721701300992022479494296931692114542127887432405933594739009899021351204586356951492"
        "886187572435401083037476155368494801223278045654296875e-276"},
    {0x1.3a8c0984bac67p-916, chars_format::scientific, 692,
        "2."
        "2180410620430225517898657079973304666136981289307679736753455928805959725081462934224670303724159485938268"
        "8828714380229742386971411041934144824845530951396830281289648621278119877048709460244734297439979032457124"
        "4210910101722242920154336630006086991235669508210185826348819618229937866676364296126489105865139605828360"
        "2048459899956394727237587803958256596040689177850038369317144434041219912680004534927123313725716843926392"
        "9141846933227654282444232967074996992421239352155928725744678815679120998085146002248164874856671200987562"
        "5412875033658742338513264563614366747586845781134774124232829708849899521351684572920654027513944639970411"
        "74444432233190359349261910892892046831548213958740234375e-276"},
    {0x1.938106b73c776p-915, chars_format::scientific, 690,
        "5."
        "6906497436586979168324009384548588036589095543759130627636379562863411660649404239561145787562444857179638"
        "3242916879169401001373374357414748760162350056495718058588423534096485487067553165909715657381402971404442"
        "2468094756706901074082987816674625471919162817470744562403850861742638326686838831329543166906530868544059"
        "4898149718409995904694095670341472420644316999405402196876112361507834250398148271011353848871090482305740"
        "7709927312703785037310249086969034897324787955384440730093355487897020162730857189426818122829178924268502"
        "3478828131783734931249186206288600257156152529666027885484652021194383320420661247802440895124858403164728"
        "133943685880850871239289290315355174243450164794921875e-276"},
    {0x1.f4a40cb3650bbp-914, chars_format::scientific, 691,
        "1."
        "4121156100358157296664884403439661646302276365078485687132001035304070507720766854695035558157858304450576"
        "6940217400099355023661276743227694506565541149890385524583996128825300819463743839851012791085031812663780"
        "9078113983498722820987671412284313866751671649867202543815081237996571345329124002747352450708274021201033"
        "9249382671053582408053415675489886917683768256732181737438581253783555941794602878960721256857697391077076"
        "4877147702942096611971251748274003472604976609538520625018538574328879978037098590719449636953103849833441"
        "8749823932561430082471354799282769696040754873243807348200109701833759917789263818613074275506995243758898"
        "2806943523648328386865813399708713404834270477294921875e-275"},
    {0x1.d90c9ff0ea8b9p-913, chars_format::scientific, 690,
        "2."
        "6685811370633676469151456124462933808944608667956228777777669887667468102141343225224973573822627858520662"
        "8706394471551392518714620362982432694174419506683788723487695530093086709272946848081120027413065121574478"
        "6557772150087296243176647496252440476244799624976290239020794096466570190721144031552410062820989434121667"
        "8829969777457299984096586701156978531800501269895806288448209599476087051536904832327274865690798406014041"
        "9242923626411226561350556759451418729720362364708522318857675731726321139280873439306988245518166084854544"
        "4617167500172223520590496019958399406193343130729441401318451882177563396082993744332324550487662094880548"
        "934381955914103834448525276457075960934162139892578125e-275"},
    {0x1.9dda5bbec739ap-912, chars_format::scientific, 688,
        "4."
        "6692815012344966698882844875437366789005901188975934417131762702284328641862258488125658455485014617892258"
        "7849067391433971807460553436148881053030070580286108356418420118416969143514528711425882108264857440652948"
        "2949951797469318976010031015211593519685235614350499208005655246051120557587904621971388953661755198499957"
        "0757281730469581796681608340143307523472370915834088491490803052108454624701398786420702452110089930576895"
        "3323642622737252465685844839888300778476275250469032520933241067415921740697019684544854238709595905534560"
        "3004485318890117726846497855781173320368657200811902980978359247250167408579989059372735019254137725760123"
        "5072778330693898940495500937686301767826080322265625e-275"},
    {0x1.b3d55416fad60p-911, chars_format::scientific, 683,
        "9."
        "8345480986695514089618875926461208483325452018779020379963044696050432933349843715361682741761584908091249"
        "1003925803323420285422299200257544927820640319697426292214256590284651687321803691614450944195461737083147"
        "0053949450130019955123314130153815851209568829682254278667162756302344761919601995206987208217756224520301"
        "2490168186679900137224439591161763561631529346451548557236425884128203137861028096947942575417821017601760"
        "1378479729168995921054485337026942189492031327824997457509579952046482421043196522791788544424088239606919"
        "5834232249409883053072784499831730816048858974051601859926639595921288052515471787430631231700012801861588"
        "06417666411459066466704825870692729949951171875e-275"},
    {0x1.9c252fe78c1bbp-910, chars_format::scientific, 688,
        "1."
        "8600057734718371714825273518634978354358430652262526675402237331598535844295454808421652847968623955166229"
        "4650573866111151552786059604653573925266743396199432791559547670426194582452576205390410214677534836184397"
        "4555536608449663541605202919437531227398833959534590546980892951601368099412773750211386643708216564687986"
        "8614705595747648294239448551774117577448974310225433244569605702819713532045299071620588883760079184637819"
        "8288424060798361639111043395696475163888439664871728837230441754911577683195623724591428200525516519522384"
        "3673716690874231955397032122819347024452498018750025400425613047170373078212498439755828093049590198255103"
        "6706501029587002005172280405531637370586395263671875e-274"},
    {0x1.37854269a312fp-909, chars_format::scientific, 687,
        "2."
        "8117756756308431810045707418457549719710610000849801105585413392312211123265412907366996179793959773262310"
        "2528407504563563289183363949413319716188120462245043980380898047975666961940548527936494252165792282227270"
        "9751021750995630547875850829787122147998996258733220571087825557332332005588075878604400572352057444304256"
        "6115665804874692939210171450919961655577985423556158382103522613283595365382795523013526774289312455559646"
        "4851187246037583046031577328203772305918749846723310361418283969452255932829276064984353856245298419264081"
        "3659122168387059488839582188262378663355081166412581348801204378576235540860124864292440125940486330437256"
        "312075595780786141375529041397385299205780029296875e-274"},
    {0x1.5b68fa4ac2b42p-908, chars_format::scientific, 685,
        "6."
        "2714270295442504603435251110132409147534667975735926257860278262299612701213671612207350641905602947661894"
        "4494416416416353727267861835534249791206425657048892129789772365623874471751817192007152737100353458016022"
        "5562053419694214377441724668769025436402835091526788281492455721704077602519026610127870369118313142031480"
        "9897533450610949249311456682364212522217340674731787953847187007405298194868195503414511556939417484877318"
        "0287260778212420819630672451773814859942905927714008129810096642973740960075495296454058304959469149948991"
        "0019786761795794622366208715634510022620666391042308290790968346187058669856385832192052476042596874880069"
        "9115977970443669420319565688259899616241455078125e-274"},
    {0x1.1bee12d355aadp-907, chars_format::scientific, 686,
        "1."
        "0250975871333601410285213100183232774538473685218055938897189096735340237340018400725666682494033072536608"
        "4523344487902158562213073784305960609813824694625419037109496021095951526904178029433537609825161518260979"
        "4611783379551401163974146864458329467185443162645279912920460025736906612085102498298245991228083818940277"
        "5148363138806380170433459153981158132727283701179492276737893371060445823347383802426142678436476115955450"
        "1380582707481618618086710570120193173722547747612927374090450924298878319085773548224441762980740444341131"
        "8861570306917779317213969781190995485564962851095177735122684967750904878926948300062887536858489633614618"
        "24513759001631374445651090354658663272857666015625e-273"},
    {0x1.5dbb3bf725a55p-906, chars_format::scientific, 685,
        "2."
        "5253325080332935122289495566127846548934475987700357144674961351479357467092094630453535541284919659245903"
        "8003494070856329734901083535046760786533056388680476864446948292312458125217671960943795156782787115386651"
        "8489995612260332097305108374078181507603174632534081548073471396342504983710412240194257585234633491428220"
        "4317410475710039015821596102435733830265474911659400368786801131458888124352482480324532223906317300645196"
        "6507983841113564976333857639263147106429864722263664851030405649181367011150329531668521843720200537028123"
        "0974830602030567068197067362558553069481671246793360301294886083514645802904351128554253419272228806760314"
        "4347717143702869435628599603660404682159423828125e-273"},
    {0x1.deb564bfc9b39p-905, chars_format::scientific, 684,
        "6."
        "9132961251476578929222904530052273628363552443315557555004747661057069612999210997894255772698684551025199"
        "1243515225364882882698889624584628027249467492666941103078711591669709456393002977814548674714031442490579"
        "1873235024838423268345382820217574525587164194948220489599485554712874650998509771058740523491301689686432"
        "3179317665178723422213216184384022812397384381918414301497856335169286849906525371490446315447355139287718"
        "4968492224551797774340395828836008134619132640683002736269625867150029972744613412338525800662983389755954"
        "4074960661569254434844416849696643611136230480746804569554606627570565749735444390099046341993234153112576"
        "404723484124748011936389957554638385772705078125e-273"},
    {0x1.5179ff1b0d531p-904, chars_format::scientific, 683,
        "9."
        "7473722876297753859094243167038918335732475648235279596858447770771804886894929506661512363400799235132329"
        "9611094127822440521351999791476209022441638779626597351701245970013572675145669042456116850923505846902122"
        "1019543910350446840555896408640821843961400220187736393637951646466301575756491015220368431665646131851050"
        "9727736135505497758609491007485313307150194231963853639010109636728185073120919295228223264260018917015441"
        "5611027124442793742874753965529671066910351191453495845396281368093624689695699465834057840582376163654013"
        "3747927057892605277115304361791933151276527348358808702693259272579380945576312699683565750443374991247958"
        "91878615672343499909402453340590000152587890625e-273"},
    {0x1.5567a7e8b22acp-903, chars_format::scientific, 681,
        "1."
        "9721670909138485406708209875245988754855499584359380143538249663486318133335425048801360176933315465830102"
        "0938111316690961968819801684276456747470648078446092573136974003930909131364649434410677191755964374461168"
        "9449985149741847522870512655148231642390548825459654618135998463059314939845854863862378838430177919605456"
        "8577661945071167810995560010331333745976303201264359555104651738851008461460823371625460226785030567535616"
        "2650233030360899161133192808264578667329162878470873772247704774334161447668174066561587041726468755775880"
        "2755495463473945116677959704440051349739279053896878897062724521932452819827121021438059285702750231882048"
        "720898070737206353442161343991756439208984375e-272"},
    {0x1.82d26b4d40ec6p-902, chars_format::scientific, 681,
        "4."
        "4690483726796048912736648731122955257354188196024231986588312330742257238021456634908826654127234839916269"
        "4465100758770795918495191617148046111636565021984454301308771295767628366526457752766226774136157158677204"
        "9777232414728237847783800185819300150695494868265399989984303418186913936387103778295846707558587698898974"
        "4537743159905346990806740300898994948523687536782820980310082956562976516393428723186369254972697917639523"
        "7517451055069267609733839616408831778853430757895403549124610101368994821095535082159636545165567339743831"
        "1473563149126607326293087358055222847103895464442221682394762176220261504241500948369995664309148768991554"
        "272721200558038390227011404931545257568359375e-272"},
    {0x1.b9adb0b3a270ep-901, chars_format::scientific, 681,
        "1."
        "0205638445192074540686039149619492166036221303655622880582574223699718851191956040320709720157071445964723"
        "3428300334496957481984272637141040116652643064109299002000714912526722350009504846522887500937742299459777"
        "0942012244050224737963234632599223698388649382113915392050770236622145013987906289250667977440016565465777"
        "2786124745824565716876090891358069196313060797768032150978701298003352609463312591961660591133735686117058"
        "6913634840700315149168275684264190692289543505043910139097370899071681006640009246216690670515068530285759"
        "7044837404540088869708210335900301553691604441179068784764324781639073532912521042956144573308772953464440"
        "883496189282908517270698212087154388427734375e-271"},
    {0x1.51754b041523bp-900, chars_format::scientific, 681,
        "1."
        "5594946591458144416815819205468086167159843664426203644788299768110350898895635640473683177179787484935471"
        "0761890097077391170243907498359928566450028944900998781236203230936550568356138185326342260744947797959044"
        "8089980215073756826092589717035140761699187009768022799578563932926539959419689583937077771224903982883050"
        "6603754515352518370426730719503690418615989945023940422246487398920505321270052974773170110606272759183833"
        "5205417118146670159764645404909603278176701604829743198580484412492486663798834003281774366390347368165759"
        "5362339231688365149446598673054797852034665234088747269980370542955955889926977401007116018807400721172485"
        "495540083189069946456584148108959197998046875e-271"},
    {0x1.00a667d829ba4p-899, chars_format::scientific, 678,
        "2."
        "3721122629194563688992695961022591972700965769964962023979613518831273586889391072823312996245341552083908"
        "7786296830599233560970336654641563328353367827061193750339055849152076714473993684277978272782656779678651"
        "9248093278523380946182387181270224161693471305960716801796086350401820941530293610124339885099370122455633"
        "9213480773166503738453729836723477976233921432682499010565949348556862176229902488779233912691955710018077"
        "6162421733605519251254994399050521606947229834703901001343373353991955700195987881196711778257611305372877"
        "0778315767911073839509938476337268634020082539441903467893818834311806047336796227578822931941039658316800"
        "094184362279747801949270069599151611328125e-271"},
    {0x1.2c4d42a513cc0p-898, chars_format::scientific, 673,
        "5."
        "5511359192841546886271708253316622680838450085144175548410195027433013664293688195461190062847630043330013"
        "4827722505022186068415003251035061785241544879329174355829128492380420931948872833966395029320283239106512"
        "8400274603099891349456086079489507202429780609710291427660660349740546127638820776459982111416694789552131"
        "9811293298057424598688814891254105264492191523450049178395817421850597417689862288876716646753931200748381"
        "6862950901304269793360490536140388506490900700818282906806961856225837425294307204020811869910715963415241"
        "3919749269646896273238207930381447337881848530251103441328808489089045268485281854014309335709649584605224"
        "2040258306587929837405681610107421875e-271"},
    {0x1.225c4c3c8232cp-897, chars_format::scientific, 677,
        "1."
        "0734739674446298024207248229790974212690206929738748612035688298132431930940767808978781611808395357190463"
        "1495036629406095455507974294251384055596725229006339887006543979219474079905078476701423633851365003304096"
        "5533581637264699330161053700604940173012198029893482448464528100444472938931188041028209567758949481905183"
        "0490015311349228608723684009581342357121335471812569531901439452988004676219145306228626404952817818807907"
        "7542648436105191086071959808006028363021097640334464264306889872584610305498775551918545763871034864670939"
        "1697784898357237005514529545736458270109663587122574187506989374675610244730559373166968547248456823482850"
        "79432681499156387872062623500823974609375e-270"},
    {0x1.49f96e8fc3b39p-896, chars_format::scientific, 678,
        "2."
        "4398554262702667444398148018038098952470544215124227046286789042553768286136848758427981512172714445409930"
        "1156432338778458633994988719747981697534403350242401988431098023618401338421499127747850118979962781370625"
        "1582218414906726136931294160385412469197440440380909570572089389208878233063263470015565582345570048109359"
        "8639683646815093873774935940375258540408008971091122482936133784909715421457345554809011396322005411855059"
        "9162338229209184168112927326017394605260506607024809166145756193292992255504344399533818727388472020637202"
        "9841837099259731932443851592118412411307461059862509222808177157336752523381613241275274954877922857555982"
        "462385291142936694086529314517974853515625e-270"},
    {0x1.d02b819f5ea60p-895, chars_format::scientific, 672,
        "6."
        "8642158764630495478107887035397014093806406478739147400934802190758122966145509273130663656083449116193388"
        "8223685640572561914307745731515469808330697336384232242413969293063536569077723416762396892707530258707424"
        "4545467438925612214275881601335127633854291543549312798476681105264979340881027849188655526015371664367066"
        "3196129370831861216770934862924684216985743727871460443148241127262602309896093569590960002026708618897030"
        "7759109386838123883489097316625629036908204612253030886781498471111475701705130013263603331962648371224484"
        "2831818245768202447715876348197096113292312233505987050190351763242747076189226988458164602331524196780765"
        "390002443382400088012218475341796875e-270"},
    {0x1.9799ed1e92e60p-894, chars_format::scientific, 672,
        "1."
        "2055339469240307377403402594354358674407642465821440316185387366532834818376870794496751703591990320577027"
        "1070113114076479488114135898545635834909792131037998106545850994330544371266945740534776833488374278778857"
        "4210076011956356747276577674394094443595818534447499249115341998676084394486307876183969501905326447231792"
        "1674817757806138643290162179595339950043670422343416927403419489541542045362472536831804335763027721048931"
        "6956915292444618610846509129090912794604455025923507204700630210668066737375536920033779883548191818661184"
        "8963048722354732914235674141422188511695223505091651304612258808796215869856934551053015669443762235800432"
        "502941248458228074014186859130859375e-269"},
    {0x1.01910e9dcf23fp-893, chars_format::scientific, 676,
        "1."
        "5235738192618518189936618594353198373490038933641511179090306267605182024133053338385048719805469080900154"
        "5957303087100560223792006622980536966737234211755461011587426519659509365351506623505775740873732101274705"
        "9302244480684314824553717385232770551514728255582443659403778984013667349238036092179546944931299320331086"
        "1757505321077871877040854320771623366194214101040976735574958938663792105124704745406309365766329618014782"
        "4771690982829988866222038776007404704345799976200349382370719198260584387074295575308489654601314392380880"
        "6247650486965191635898381488272370659215232130706305838899655353946746170671987732614538924943360375947442"
        "4588216123765960219316184520721435546875e-269"},
    {0x1.55d13790babe3p-892, chars_format::scientific, 675,
        "4."
        "0438764974429647181083693278793666999589651788371231605969383877729524560726610847524939487893537632362689"
        "8846861862368755886367916636298143998039008428394610535517912002245989309306202382454578439356783495073513"
        "2918308903968711752955260187817332338525640497165750231938096458190808206428445911366884923501080893523954"
        "1206093029385768713858239491000151225959463531583588963736180340573010650508237574015975946010392644014468"
        "8165168171854738715370375794081116073467023962896828734809612148557370012497858203113645628993222560967395"
        "0336664355143451919771945115113191166252509180553149351063482548119983121858449386491438816394778188001261"
        "909345629419476608745753765106201171875e-269"},
    {0x1.7188a97a16f94p-891, chars_format::scientific, 672,
        "8."
        "7435562511428746407917858121214372902879051776678981737976322047613610624282685209507466698778142288224027"
        "5455082159625173427591657526511616774859950448070519505134802050234509915695099201889128074783085073031931"
        "4819188183029263829944697648815507866941818927878058242566543632327940530631337555099540355405781631178699"
        "2808924770387346666342826175687898745708869277309879509815729325382945015154228534140524374264126591488175"
        "8531162780816922738713821526003173659290088391480469742480863935095626092090116984973808179531069736545259"
        "3665854547305770395594226542202736076609270724296938582309549515791111533078749081279345889490509807252804"
        "908017651541740633547306060791015625e-269"},
    {0x1.3590ea1f17fdep-890, chars_format::scientific, 673,
        "1."
        "4649312749107112699249078612253466255139190610866048930207234799841567003889985307011573295308929480552062"
        "5046779174563218713759188180095944870657550678355333052939808456821890187651923588680269654593860121514434"
        "9181485500931165058227711343981064209269072796191838297693555979340057353274795768482966261660740325721905"
        "1699070179918086660167018142370691860419426843786474241321383571061970541818509874342719546432238383475256"
        "9862600241934899065233608023840660646981036704306246328305078273787020906287373283828550532772777376154504"
        "2382603061313562240235190280769184374891864894990808094527898696863693474382944773192204352614134786180616"
        "3432873972851666621863842010498046875e-268"},
    {0x1.a490bff22405bp-889, chars_format::scientific, 673,
        "3."
        "9804068003253801924882375719417812536118621472122388416843607937530335021800715604245101187667554747013995"
        "4999377434052851878178252101539359394319413669582928785161047412343231670883353111905217616764325459046667"
        "7828829988706129136467711963276762541096135592752188769472589597065685993694758879579630673912948899179398"
        "4628734396688639664301833802570854901924189530778964826733402354920570755968722831348583712843989489597142"
        "5614412988732348614862400377153642464721973372576680409450027908761770203176461069618154939055565879769143"
        "7413131078539175704147903187697872905257705223315772497825560770376041116692908571522268713665397078024094"
        "0907646063351421616971492767333984375e-268"},
    {0x1.c59bdc303397cp-888, chars_format::scientific, 670,
        "8."
        "5862866606155157862058221336345820574845880378878616534766461334711933967608601405237094305285212951224721"
        "8811224414549999834241924697168185098548362501537290019314014899176707940187530956780726325235279997326100"
        "9452705579499169901168981268202020899909243284637492060661433758304632176006814240421686409284667595109084"
        "8814780526424923767058416281780691829025801360594452925927646668861343662081573038042895131100883925664927"
        "3434566380169524829965025455207365527009316501409537452384812648683458666570530994016398472257935821870147"
        "5792921574606565186297310529472246116485610860468577453516637959521359804094235499407265480713324131561980"
        "9341797008528374135494232177734375e-268"},
    {0x1.b5cd6c8c1c28fp-887, chars_format::scientific, 672,
        "1."
        "6574180187301560277042993359422084230465392733787051007866897996899438544490745152444688834530645625295640"
        "1232710668621853008468276391128301097900292398003336274182420225374479310694714219204498291060859779351667"
        "9876740791517128544885924840330252161606481575353740949876187647749371234129360568830223801641060064222372"
        "3867362631145241282908960084578297501714717916105706062353536412253151235023622382582131429436080455694095"
        "5547690271019911428549317360851577278100317763948693937529484290614370922528247233871396511557553970893932"
        "4974793123602180721204916958184979393062444379753888516263944185940942548772357521469280603746275395797560"
        "303634554657037369906902313232421875e-267"},
    {0x1.dd323693a3332p-886, chars_format::scientific, 670,
        "3."
        "6131068345429969451130373310115607099294864130669813892800930118616243487082666684796081077226753480935212"
        "0688722595031185095810662074858300293333264091798976751709329421719319329249471449113212585104216180364902"
        "0903052455642472114216144930468732881689213430973791424810940744070365363417199107528165592848991563388371"
        "4239891254785518595031411885155607054339603011357809855510923231449073199376203490368131774971870870529128"
        "9254522590611068555644306549625893758075882651211411533144826878180312068875356012841418042267850727474063"
        "1152624795386765656842235212097365641842719519291963550795467751354357546090784488915890550681843124830594"
        "5047150089521892368793487548828125e-267"},
    {0x1.86d3c9131605ep-885, chars_format::scientific, 669,
        "5."
        "9183241751764955109389764976714155872620609643410243773660851543979583503245329654584813732786527982073834"
        "0521636420852725417997261615447417981415016882734448973389564189606166822481467349095902747600636497815870"
        "5655949314017730228570170646553719431745599699755559963097604629279063754642229864212114707279675331717816"
        "8440072594592218022370998643157234465370967008505124175029486015944278448019481201861981653551367410858983"
        "0359527730465346678452762668709266971955765590228540631576870240350592327118633813432163334893809956910105"
        "8186934058654616506900726068423578479775270344220112716254835138009906792965231941252390889503048020114928"
        "107204832485876977443695068359375e-267"},
    {0x1.85911e81c4b3ep-884, chars_format::scientific, 669,
        "1."
        "1798475245572565258836463208928683635416019155375711636848835775165384607837563334358573139483721738528709"
        "1120028390252414848147343275955457018828059343282834073062154638169876178683144127461935561949669627002417"
        "3685557443459253842752241847183852027161270157839527291020148506061113896949022943154133603759166570662569"
        "0345523867216992200844339835298032472528560480231572053267575814735819031230558839583597348451054026157224"
        "2255926498453096842484137847010445108819535016652319334499549429994953654304666027843239794666289393464823"
        "3129548468640073030619432252064931487614833495014858781346346117845149269477579183027503827919826688563897"
        "931771862204186618328094482421875e-266"},
    {0x1.fd3a7670dc2aep-883, chars_format::scientific, 668,
        "3."
        "0845119288706609241776127310550945770260699097294636090232555316906282397758975656802444965817572435648830"
        "9154179460646805809256909673683564407525994808351915660324637706817216948128696931536528727801890757276085"
        "7821998571184112154093996098113552610554410114972749654435078757144390250817251359366357240834609588333752"
        "4472602522735858303857046884402733676415512137932791990670019608401150097071887929689475019078052824432695"
        "8169030004334188899958031100736000503800060878357350714914804570705622357760565433666940637984589125351111"
        "7578209700869532329366449360905532226889918970109979920440676664073492291325343965342652658654645433933261"
        "24487430206499993801116943359375e-266"},
    {0x1.55795032e6bd0p-882, chars_format::scientific, 664,
        "4."
        "1367697432326765352340817035182743358257354812683967551470618307077529029943028853088076762554639432509154"
        "8046642335686562972830560848535832043202751676119898478727926728300673178723638882161179194197617980196622"
        "3908838232485454712767866954880107986586331614093671038168594790202349294527476303912376120107032564932286"
        "7198926794092379193979001160520283118740890457050606561528368852971588670160141873796334891005265000215879"
        "5052277642750755249858943871277223658376131404786971097472549039306650994514211262733568954010543397543745"
        "1964937117339719316717342057260783566644006824506803928857754052307315246529116200657496496984749656533608"
        "6860042996704578399658203125e-266"},
    {0x1.d4b623359ac05p-881, chars_format::scientific, 668,
        "1."
        "1356367562498619145310244385698473525427283564803902471480930973319788737231514592977108114965063815055345"
        "5830977379024144088680682202364780595772824626362655507626398656976630817003866602520718605455234378514735"
        "3087788741804559931776255025847515183240478076966312904995778458881231949209035981411121604045278278843061"
        "6977268547183960163850017321591993093447821248669240119333705313884423383580946619081395963426489952177610"
        "9997766439665027209396002034188443586122091652193792470005755939774105652393587570468729608467321990883421"
        "8208302180369362225717108121963705936493691882457994726492485413609210469134484467589008870790296193420410"
        "02028054208494722843170166015625e-265"},
    {0x1.3fc14119b6b30p-880, chars_format::scientific, 663,
        "1."
        "5494624584252723975906249583375352303256654343181075171301275908694037222380263592504310689836780104021758"
        "1758123367338251903106006965951338021603071523529116946521691907573658498425349392869295127718000433929885"
        "0163756715521637210713685129495086748985049799710299739775854204400714728515170031210558291615920547395211"
        "0992782609302602588568324649970167427445308975305630972919772035489011201841001127297023151195017709922837"
        "8421528368003116558663783106453961275883213934228645792733584503015487388799720683461887271416060866520401"
        "9257084947262289315617219879609164279766856157954598104804131015062387788537884648628367603544198072285098"
        "533029668033123016357421875e-265"},
    {0x1.387efea29f7d7p-879, chars_format::scientific, 666,
        "3."
        "0285755370951038681608683696905621033772278330728553552206929677317758937278752313911937150897127680137831"
        "7003552524566357980703032758133957564184151555886502238750580053267415635428852577548128543311783224172494"
        "8681614868585096210717704389551477048999401562959159801158673751335958285076385209833933722745096602678100"
        "3143061720934102794967836052054893105516224558881550411686422692703782419027059745570753240877996075484408"
        "8749613809519051548412628920654763685820783842694818471287892370778516701681078600125302612513778414895942"
        "8881521605742355054257217013573044606787074642577830411006902168840320052258179872988498243578485424887247"
        "745573404245078563690185546875e-265"},
    {0x1.e65f23fe2db0dp-878, chars_format::scientific, 665,
        "9."
        "4274033334811503748528404757289384726806770032674327402818133341840737332411750121426215821853365474391355"
        "7230387790285083933191457903289270345596270263672196354394182427315526000880649977141656105787327135299739"
        "9155480063881212524740495031457329664415784460015536413542144918144920982279053472736448128968434148254398"
        "7888277231002210993520750386501402122475620747774111346439482660309836582783279713410116736596619463882867"
        "3812504921615547034950622887983231873998865416652468144478421626318837183678578001787452762876752114351500"
        "8392129613740783506615926436788653883816643418293983827325355790595619401175112158521708318652601588105710"
        "56164917536079883575439453125e-265"},
    {0x1.be0d3381db145p-877, chars_format::scientific, 665,
        "1."
        "7291748366915169805535173361311690336060863250937536754419109791788940622928061477911081864929176484648733"
        "0392740026820608012717601990878326637047638718248681993991531006456103430748094806588017738041317168594778"
        "7021878692496904266200427795631638810860354316879657866121076029993751741729645917063224939510035511898570"
        "9999359928300674405002289342033156169213644776362614794679384856915080325537702909530580016470514923381118"
        "4731189167500553098889569815790695467489682656267030416780025246929633596118386225452442180730702839693663"
        "8818669944862651345233138879791333792498482753324138047601610356877377484188814783042194078233402820821140"
        "72181866504251956939697265625e-264"},
    {0x1.15b4bb463138fp-876, chars_format::scientific, 664,
        "2."
        "1531241335994102581545421543905718553261205634596225205065032112054906757350946064401973884364945201367158"
        "9193498889587342518389527340691619196698218268405950444924912994180329555785724990446715258463485821370710"
        "0297914720890097779169205883809457497940081169726676329974463181247441649888441390421006496972025799387444"
        "9869399622491655605240174565953844905584693276335440945576505682668112743945032654000227377822639620983203"
        "2424628169867278960066124057642301935079333533998374656641508551131984260262634639285697704413869791566604"
        "7058344555168615768293471860018877719927801421962570793677149082526170886197341877046699512490007810683323"
        "4414807520806789398193359375e-264"},
    {0x1.c9829623e255dp-875, chars_format::scientific, 663,
        "7."
        "0943811579209456674393546810681034475092272127137349769143575260247208850042176344557556673219122391550803"
        "2134627914531660834653724133266216664851984579431280354615254876343265450440084636894948463058853750279245"
        "4180594190614999429011156768877522268148802551983220139436429766464461164984165663141029854488048705467562"
        "3483604810872383651838979512701583025652350883872278828061474056265146942266842117494952581371563236372454"
        "4745480159434009300924698850473710854892506668277594645356984354898943282803740889954727605047952229451319"
        "9536623800733390878855344111359557724030382934857005734748620310003839032941834111259667519124028078891797"
        "122196294367313385009765625e-264"},
    {0x1.4e746257d7670p-874, chars_format::scientific, 659,
        "1."
        "0372442383613189969714086258459722252660210904892135354666456482486436513413329300096044197495219274963897"
        "8020863794678225957572854635073507252775535164961781534910344480358232648898270595208601349292946268441297"
        "5659811329213404719323722531070098963653390797863993492237598760842383012198699274324054996159547329459864"
        "0580924969673405756953920124756145504369343197985189208048577768929728892896888692456901412684203646115966"
        "4146976253775304747117052161568491733834101439034106718671249125299580172355437057762980472448608774453369"
        "9693661677914745564631876392042680021779683932888965662895943618616656316757734516189595405655232696062739"
        "70566689968109130859375e-263"},
    {0x1.0cf4bc9e57f3bp-873, chars_format::scientific, 662,
        "1."
        "6682266784627316054126786634947099848892653011771160846990224792777416965125633659363823166150708783511656"
        "8115883612889554220377387265788086029467082903772667492283129753284952803154692864161969436641653582454220"
        "2025731166907532844165700456927285153916176469595705886744314524895022139352304559343255941857888068865999"
        "0319914265277282424260166051913216749835283576431746611538506471427827307023604012634806795610432203420196"
        "3154877669659580960959116015504309990919735860857543724951224894412485861253372083552618782145415839816201"
        "6695152261152695946643426485073285270438041876766580343024065650025617255398049533262602511438088548345604"
        "06743548810482025146484375e-263"},
    {0x1.bca9d75009185p-872, chars_format::scientific, 661,
        "5."
        "5161395008185867433415357299266473202855702442652255015417473346516523059631823879137334341688412064252201"
        "6359703316218905950439100436732933226969082782786169311545430229194074907477275505071792114832480787270717"
        "8915637107070607758223870410283818480871009382801702917218018303290530391528205160937483613744722094375755"
        "6647797218095071645532979709602538130511390566521835079669946838247561601190008503934840995758658023290110"
        "6296333354593470671297966973754686923720279528690270848804834944868781772303189955069294165504271947347376"
        "7583033498736701881264169093594528605625061561557706388575048347185417471798563922342096155909674237705075"
        "9387202560901641845703125e-263"},
    {0x1.cdbe1ccc95d90p-871, chars_format::scientific, 657,
        "1."
        "1456020464232507675057122277543685119216460557168252748157621249520884155966158083731684691602468224843210"
        "0075159391224235566394108391370020174395111096729007531631823808928065243014130184606154497386524196017218"
        "1110143712808599775710021657762313485166911340457125405068169443597769672899512513065315032891834699262732"
        "1908035386645038986601439051667243567979139672430921599967702480280650531086256799068476585431284585388240"
        "4720314532219838347561762351544068566196357919731108439498951529832585320483185327879968362288867769633642"
        "3887444215207972301820659320054036430922363633794449770968981950183436840696718769035296336955553897496429"
        "271996021270751953125e-262"},
    {0x1.a08e347eebee8p-870, chars_format::scientific, 657,
        "2."
        "0669818736985631229211433609173300771521838259787418165128492129593346843199105889991555630546885520424873"
        "4500210012141010459200844730111260401895114952654803481888935046927199523015310712190548867351015143128831"
        "7341497991035832678659314223700819815496411587815428866045015831262423046888744843665130751642206640470596"
        "1913785805669387095600713483824728909600527076010029285289082448583244303100393919800739122262878737798465"
        "1267691566022679307642868763358002955970597599049178708475928028052269404319007521539151009465828335775167"
        "5552194266495084558603653401864419204157889257764915433524177885184490559892343474975885675437581312507973"
        "052561283111572265625e-262"},
    {0x1.12459afe073cdp-869, chars_format::scientific, 659,
        "2."
        "7219184652406805993113200069724571033116395794260022510965600900076256395056708441474373792056450106821277"
        "3411179024958530270817243162958424331800455670782255602327569922315956959137078323961271124142919678140836"
        "6427948378212113066025708694772668990832057641669827087574149746812408127966499041381146615522441977831117"
        "5038207495040561355208394644648970017561375493866454210039949616609826369918160587076346295322087365807525"
        "5752221508525467227047509182541235289800893474477444565810299484569003495443070616025087922865386504523121"
        "8586303252491596734499946262272599981000921593324190166840578960162765846077581071744836208048390346903033"
        "78738462924957275390625e-262"},
    {0x1.0001756acaa34p-868, chars_format::scientific, 656,
        "5."
        "0812835426747345075553611923477617398987820369648939551306803212741371571526499464855930630049097064592210"
        "1122379892382479717106538369694733235716438656264863128490731915205653554091870063362517275282717008654459"
        "3535922167621228929536166429804941621134212881365185181432564583359823929240075429731442028191437183310347"
        "4322206835097502207668064791097777030747293208431008738427234530056421963205800084404703834502602573206400"
        "4422225278499492883613711474972843024484702154518332563961230115989187179489623402654993380597009086900293"
        "4536386965363555076444252747751067112437620044942160741851891286975974928623936015302867130749575608206214"
        "38324451446533203125e-262"},
    {0x1.a923f6cf5a94cp-867, chars_format::scientific, 656,
        "1."
        "6876650530578207621570229952797785644682110844600730382828697983205295811627431458729119705328829243777096"
        "7196655799942541178490674643026183703121754253538937824062441208188206739880347984078224093935173556451996"
        "8428512418545184148127106046414566467839390422090352343007549697592858950809976923310636041815949880034513"
        "6248794879877104664837625430195393564841311745786113921932455203585099235154424807349383493024231486017916"
        "7453641477542234843453022929695045828962922773750009075946875267007574023695528840568813676232828754491306"
        "8646813805642245606261257736522932872947412755257832558074192370113465124289365328893661177822593799646710"
        "97695827484130859375e-261"},
    {0x1.1ec90c20f8a14p-866, chars_format::scientific, 655,
        "2."
        "2768831274043772176382445707214941137050004819857296684931317704292669869186330235385392974936135583425559"
        "9391396336854625037981166318159043959947117232845747306996155023939888756843144321245127560309680255408819"
        "8239536295503375270446676949521636344483280297142204797105650413943143524391493206834878212096730282097671"
        "6001570512136786783004641864845978867193614401580700868334274804209917513296587055016135300878023975459549"
        "2547459644523442197433522979067269453221697470469185215254072576985178910173696058780136578510752082477360"
        "1510406473818284898811639918943826900408540402073733604377575240372790188611135900765419792790567043994087"
        "7258777618408203125e-261"},
    {0x1.8c40010a69bddp-865, chars_format::scientific, 656,
        "6."
        "2919183472541600602721754928426186640791713919207735791429339647422629100785659522780692862200166897491701"
        "2555568019104071065737204485334987194383301234768696626240704934209115582338286117696015309238068919260879"
        "2858350306420316229909315039183892926423127496965408791803311714197177193889783060818926773096147698988342"
        "1151170779345326896958734602721257311763761737474562447460745166179129141239961621209497591323866150735669"
        "6648749093728161566479406697838649713830671083063257024116592611233964687353694158987479949427380270159845"
        "5838968120913239056997624353817810715748408942055331411763298560932984099783720632762321067765753923595184"
        "46028232574462890625e-261"},
    {0x1.1efdbfdcbcd2ap-864, chars_format::scientific, 654,
        "9."
        "1140703092024367155067044395221164452736675833151013263211220841163780409432338993660009501481842296218708"
        "3495412014520893619544114461468039750464209587202548042016950090674691007785016340938454849306345780627414"
        "9209340633047382140528725623452408559558958439548164560966946219116473549606304395767765048257811327042187"
        "9425006157651070495838384845023596106870545840216347820462109279705594517393524899645116315147968384649516"
        "6598556482074094825029100883563347947309602750682254364482901382848664076403072603858551382288376096255467"
        "3920959090444603889415032225272728877288017133034340098211825380764598208977109714858111377822069698595441"
        "877841949462890625e-261"},
    {0x1.906ddfd189240p-863, chars_format::scientific, 649,
        "2."
        "5433112499173347793194125621710163645079369331423202898876274087013265664417996337089113018887096628689528"
        "6909980735596949777809152245542352924571623599896408538766930694228602626651083775966167899682411094921866"
        "4528453283677257072323229605736418093485916168131207495359269594380116782753501753335290525716376820637813"
        "1651313649600349107789087387461150989691005378537949674398986598192233131311058346321863230434371277975115"
        "9601698778173244506374886663889558909304985006734120160002143650400648095280239164877277385388078424667808"
        "8998821393839777960585285786855049346501567034793016761392974678965713676407917748223397325091355014592409"
        "1339111328125e-260"},
    {0x1.7ce18a4c43eb1p-862, chars_format::scientific, 654,
        "4."
        "8383034142174994104272069838127782959216294890444624860488117740479459442612088085799847149791718592639569"
        "2514342169545748844407930478209370082097698966466303161266693588296916477694843719922217257850078663588627"
        "4299181215882835731412951066974921021211756829121808175859818791449336493487434400842599626556712001876150"
        "9667718055608502897452028494895946834053067261106309416912495083775349051010869220082426966767527218818197"
        "9310566617032157898763990519492387274070392056149682430213652686973136279413174816037833439958789749907392"
        "5267530473811700835332428644282412990851223505003816036845036704538201885036357457504918588853115579695440"
        "828800201416015625e-260"},
    {0x1.782df6ed4d7c1p-861, chars_format::scientific, 653,
        "9."
        "5571620410084553612231327876427113790261344273014651312134653137692369932119559217494148337440282302224113"
        "0263997567506024287148387776798461354301437476844010018790776658181862075147468952135479241966863723499456"
        "2671930616485340107247684107637321972451853389214118467182112388997076370539357788063452893376151729748408"
        "2915270789468943416839744708329469795749877089097746641157553737198869698139987185436460253491149445310810"
        "1743200834799840591710632180550687823669819744527982460287775503302538194712879042143801864025232229533473"
        "0678286714386718609825203493845270564103948780979172013971383228946576489832464467236161631547020078869536"
        "51905059814453125e-260"},
    {0x1.c8f1f802391b1p-860, chars_format::scientific, 653,
        "2."
        "3218163991190385364508984250447706848286720702433334282915779197051348928890111569809302423668131306768854"
        "9671606004297189773600697112362201312947071746547498935123129686311916312718213019473461585470236625342179"
        "0700948554276270180610568750669698346074396782598841969164523910845529402228142249335459416846310411634554"
        "3338728832295769239658657884743735612915332354292164849060945176872147230331318167350766692977206334410141"
        "9125790001753935727822079685994595251980575717534807762111364585832641492934382986141296078256014490691906"
        "8890930223248032001378178220026349482108995119241996449400126609003650787411201237078750558850970264757052"
        "06394195556640625e-259"},
    {0x1.b4262171cb3b7p-859, chars_format::scientific, 652,
        "4."
        "4322942901196376863360319680933694654308997921164922102745484052756965358320504133937620417038428351006134"
        "3936976933967608342074121415324210078587243517426577185350093924310156264119225838613696398659496989910420"
        "8353518232315947890478652282094992701578651352178291486176574508412703120463808237396444949047768512976373"
        "1251327511010233610480829310705679565613059064973397437654199701626566854193403167380367233618735049297794"
        "5056134852446758581372606649514849162314906568429829544233164063991054988715229534439385687585779318932257"
        "4286727246285838594808424556563360450020368516054773532563608037624243787652624903400377931461662228684872"
        "3888397216796875e-259"},
    {0x1.64a437deb4440p-858, chars_format::scientific, 645,
        "7."
        "2486245456651862023472574370876819260411370718249819818743335943776205307646101765920973802250296286459327"
        "2610893461273931317458322627631905835530944678673175436224034968381667303539572414025175474653846060626371"
        "7734775468528471925761988836228340907693385947639524028564463791929467246414768399226257697924451237021644"
        "3969480729800801902101353001138560925948801924917672399080489050286782872517574693040850996560237083997524"
        "4743120699197301488506127069616803558654617805738359241041246801384050437850303366990706136685985225470569"
        "6051810053431151300980240986285936866882956104322697194439226699982917385446656854952607318409718573093414"
        "306640625e-259"},
    {0x1.68d1c7ddfd3c9p-857, chars_format::scientific, 651,
        "1."
        "4667081257360905122219545067067544733163746805490966430488449206414100150968687775032402756052292826192310"
        "9033050351341337814114817123415079541930647873262150571704767679131224864582828071686888611188799409109024"
        "5011385394511550083590844403769171740415813831118767837488500000872271900044128369701757149831659567051913"
        "4569889281021321327141354177750096990863112151715710379567247962185037697773480199531512073678158854750890"
        "5840170569256617197434173544665833127001525561200203131031135463571741228836842304648117709300656826393728"
        "6667433592776261377970432715687365719647591411294638482443774640687500004641624813672695637478682328946888"
        "446807861328125e-258"},
    {0x1.d75f7e137fe61p-856, chars_format::scientific, 650,
        "3."
        "8322026353591041945549619532350115070542582231900572219630335353346952308164980213456390925558452250257609"
        "5232494591328629456449452280125255079148668498861800706754585208817826976126668888145120396190261611609172"
        "7621191237931458727896037788052038025879689611214479161439961002799972418744907169391423514023327463523140"
        "9141504165184730552533850275002320357839853008554356923544887943781694190440637960551088058658109244864183"
        "4918347642188228638308919041402117875214276091388203088789844277557265644615942295037352991745550805324976"
        "7938517447633564168025048025383225174523163173171511655810658287115429190399515727016854782505106413736939"
        "43023681640625e-258"},
    {0x1.ab03ba2215decp-855, chars_format::scientific, 647,
        "6."
        "9431480258533971970776226476780070833439447534419340955589877460326824250672274858385074795336068109179111"
        "5181741727644326382169942415232772611867462202344841982342436831859881780104169648940151652988950108209827"
        "5370546075553403132538586162373545653948610582831301940723300705685976603592449533077414627581849293233497"
        "7877716272934729294493458229693156484855489071519117809921208470019603290425328615499359681908998029766237"
        "2634261835803744746628765582402678876539119010835463553046443911243526573460491703172114040390276817289845"
        "8905787436203069668723750929115862888028737610673922200768669995165371277212260081590500249149044975638389"
        "58740234375e-258"},
    {0x1.1a8446c1becebp-854, chars_format::scientific, 648,
        "9."
        "1872993990256398393531416600457280450059068320796514631056090469764224373506303894785318601668954036095739"
        "7379178452096086476025584315867174672392450396115503992411623576333908756070286366449656119838691258523423"
        "4303304141441636209538276044437434287446030632450415026343274481569236323844213095362475894936453835494631"
        "5916381176504061003068786853124720741143508000759975764912058080348409246107484554164396410838347897285039"
        "5816761052341102619407499643636683374539552278851416563265692570816851024552511717992981218509470445404085"
        "1058592434129680720256177905954138754010038223227654713022183966981646315616387432623213271654094569385051"
        "727294921875e-258"},
    {0x1.d6414a4bf4907p-853, chars_format::scientific, 648,
        "3."
        "0584908958671776337833997728212552743197169604966979110845813040276451910012854307217756535365938877958672"
        "1422062480805494048637982077473308559243951566395413290867225547157080991564751569942298190170759723875656"
        "7053418426117941253353267909236696526460445120208280487438673462490361511956069037937150670663546570743734"
        "6296769657742269429934163903699889943903922695607261208044403504503321200370225042400066440906017069328778"
        "4261706490929305618215679483092331173245544667709092235091659004587744352478247058204575908244766418147686"
        "2773133919940629127853848611379955271758919464669049389518829342226751666594490586259524889101157896220684"
        "051513671875e-257"},
    {0x1.0035d29019008p-852, chars_format::scientific, 644,
        "3."
        "3327306790247037336907675034392568454272595369411738900867617488007913473551733534201323063199723807019393"
        "4483504697879606878598819097351469420895437630770473232697024322335525318888227840552509675600524255646902"
        "8619739611765019036536534035050301257528705215736828310189129109513417846670742657861223079682981086395798"
        "8927567766792373175362266064722463852642260216366005158732934562712954829503899973208430525614046950049994"
        "3939385349824496739105901495187144509403790073622444198594469799057201540623756926169050435684444872560782"
        "4856932216929044311840257291219286900776173012629452228655688472199201998272255487165693921269848942756652"
        "83203125e-257"},
    {0x1.20220d0117b02p-851, chars_format::scientific, 645,
        "7."
        "4959510555108538799335754813356701754792355065646873389377940176911239971986659490383240376007977904208311"
        "8660847570367526920460011559675059654679049732952640292043242998460981893007748067031656426282809466359894"
        "4693614670185383532442466218699267405223828138978645448763130009589274108419749908670440725967037481300206"
        "2851633748523492548210781300670887434058964089123011544222688423237087102135336306066767496744054282140733"
        "8711019067174933523839551077258961555519024174473109573715905891230366304042366550548239550909206406025216"
        "0684959021066679582680454839013311819960942494580582546135693497151510794086759492671490079374052584171295"
        "166015625e-257"},
    {0x1.3b95c8f65ccb4p-850, chars_format::scientific, 644,
        "1."
        "6420266726944825630454808088054330790688039184429766248449244744802510234416512167593735365107794611013870"
        "9782299643946831257931373691292450527147133474394368778328589464320389279444152929596129775091079169751014"
        "4519842247604265947164098444353337876295194407250912855850267351168187138849274287240408555196983493342848"
        "9933467342587973598710220715138598315391026469456477501218614918988364315987081858415903538046962891966892"
        "4800293313739934982286504732834842708929909888507762225095896368591204588939199683430514018879374199320842"
        "2307913615130573653829855907178088163064254606588826707581097183952044795199332050117391190724447369575500"
        "48828125e-256"},
    {0x1.79a370e99377ap-849, chars_format::scientific, 644,
        "3."
        "9297951542678784560085047330289181715367243624999440411535626335855349124270289750581378228979122629841836"
        "5716041276174947051226059321141415572441753775776361360750193106965033615162658101521745005109053033835175"
        "9584991103790007219099337019871347846863373747416772168678914168817718265590672635122732019115088840685528"
        "4308439255530425901592683130664478484169626574567424147948837034542847458593654965464404208798178515235674"
        "4909406359357588361014427767062561979917000205966828612337591322173531342449808068102635168063343642736189"
        "9279318539070692012686415588482858054953378973526677058505748782057145603377468212613621290074661374092102"
        "05078125e-256"},
    {0x1.9c56d66092450p-848, chars_format::scientific, 640,
        "8."
        "5817991246225452741092042091868243950477436438061983588714379408467689836034614775795371333619284889814662"
        "4881729754285305304028716295937305832118768504741589064001775240877211755650206045802793098231749200556033"
        "1959933582336136059033009322539085521752257781672307684288330420314630742326494970432677741777569981162003"
        "9490095521058458025954384848954814776478898052375202040873522632601594631876073317485237288376180074032624"
        "1165338903507414978168516140117648928081962307140674669659472269099418474948911293324974333980429566047863"
        "8146733257119542873384793509262530795138061221424111646611504484593192093599967051886778790503740310668945"
        "3125e-256"},
    {0x1.421d62e8a645dp-847, chars_format::scientific, 644,
        "1."
        "3408011506316038440876133546193212552863655819964643115232648414608851460824412779274915182857333649885355"
        "0576135355890044448144591074850288974977950713678686563287865201430204637815836053277231611431919085691074"
        "2176504263281383704688378934842635350107826626491841796750832996448091584065997738570818997931555021995406"
        "7467015447979030230032418560932618957121652453967921612902472152407298980304430344846944714451589948955752"
        "5437413743051434352342449627142280703374251033865227110536913247629525335673340273427147625680436359716961"
        "1438811713524636803197146424960795969018772423073980006145654577415796343889398123394585127243772149085998"
        "53515625e-255"},
    {0x1.715254a64adb9p-846, chars_format::scientific, 643,
        "3."
        "0745985371377658309028784463801492290964511331496359833560993895247133471183641249699681449552243237472526"
        "9431831755931005890372074394881882566245495978107635358098347060477106877104572904855819242902252133462944"
        "5267947457337839385094549901547440113445942355135938964379412466831551967266918677931538876399443000538108"
        "6549704757852670657762062506022796246089046295743650517804858349388973761791892305019059446288013874091013"
        "2382985115260402448385415743377226016102355004438263205348482304617941213627282753219081015230403317774960"
        "7573235824693271311509414701066402074719718754079572549356306768426427920154475614822331408504396677017211"
        "9140625e-255"},
    {0x1.f2cbd7490fd30p-845, chars_format::scientific, 638,
        "8."
        "3049473134495637562783372335308040826947988947911227489305609217047398914763715260955078525106138710236649"
        "8636130716831502004815770007428786901700220001409422949750681686209887083042942769382184521970832898856698"
        "1564429427030907959956250390354575017810396993435701154688399222312002352067564686299288641194649680412519"
        "2055831811634890274031010872847387842015145697773860849597339982312872612038388001018205969465761016324883"
        "6221890713622421785887916102589252792760578729135290979060008922160938551159483058864969866471513981057877"
        "1325541600104932329110315094541017055279256323295198054372855898377578376390317771438276395201683044433593"
        "75e-255"},
    {0x1.b2aae429d3338p-844, chars_format::scientific, 639,
        "1."
        "4474411243713316867208977352315208912748300186833139035453984167535475363914803045214345115839914983070346"
        "8107963464265324484638353285518964551567088265107554403873137980901895793359340168401743333116776228534381"
        "8411044885533746274434524620506219125995305723357527314776166432074669080741627207730696930953203477260024"
        "5308586568934283524523440596892702417372491246648480892544416253172082204519214951423032991733233973222191"
        "3704414744084396980182542537483986194053369028249533947601013624027010399377778605496838258484958724080102"
        "8509885320895297831483040255143194596899156238644941664600889849492774963390928633089060895144939422607421"
        "875e-254"},
    {0x1.2617611e9b255p-843, chars_format::scientific, 641,
        "1."
        "9586457971591684628123217698773108935833562264144584623143719864276904693871407795456172875015943670393176"
        "8778961167502825335230168197000394874158844610101174297566165868577953600731530124390559329841336668647646"
        "2468308974382408845446004492911085860270135950244988831730889623751367135007863460811455551400837050028746"
        "4166926141825676068445301167385514883698177546176927308109450223226867704952176417382444892612246343386496"
        "9518502089292929143453729778070058866366076873565593983608492151377810843966575548269321853362612694434735"
        "9338761906490029759018080945247530366860736467759639429490063485076465146783597504054341698065400123596191"
        "40625e-254"},
    {0x1.5fdb1f3504dedp-842, chars_format::scientific, 640,
        "4."
        "6867153674920416790873337244849971076484220776787110409945879501513043147393108951843513448728397762554022"
        "7879888252572412233135500143521775531145980390850992942943675033022307280642493210611912876680597019732548"
        "2421531656498659115150512846925176018749355178878646041710082824033332351824268692851830401035105154057711"
        "1375092493159921425872818144761750136660331176266578771858537248827685693005467675230328337994759363083192"
        "1961798272782320798169726042997383300927368593567279231201682441735999054882957709060176324055801659088172"
        "6724432954799549383358558234672790149531275862362895256284006733585745935188882071997795719653367996215820"
        "3125e-254"},
    {0x1.f6c7a277dca7dp-841, chars_format::scientific, 640,
        "1."
        "3394037849881334765215059992884678582059252311456778113974098621513971288241782735420610917120016976004897"
        "4101237183118229518455257182717275229827659782720693591974491238575838983952697201911225839142407518108571"
        "8387875308026359155400107105741151539207807846271470685787797198661393857298908016252366323393251433958973"
        "7460426086328194140128257808492826202220353818668408282284630672148896793138260476005062793728842134893731"
        "4037303402325371530047168074113847203340154903164323156507991141932470177139673422077096863737284741727886"
        "3808972654184165400453746952390769201581688574999827740403704881609701221600872145245375577360391616821289"
        "0625e-253"},
    {0x1.bb9f1504a1a57p-840, chars_format::scientific, 639,
        "2."
        "3636119615931954460250167869238911011154326491479430909872707793904843481361199550716724821767345510198869"
        "7933841684366181492076821446815839454724649689656529509127038316112414479726862331466461938824094976797737"
        "9143220992333278223132260837716239494499620700131088794260669791925469170854867933113640126889557448864829"
        "9498325434878096355990555941114674441441864914479110196859470066198102332189630543298418737541697203517800"
        "5724591334289072091451093449446509958846630135866773448711738522258235844477343690396553420497616058860223"
        "2307735599284641966598526646351415873074695035701931182197892727567777038100160780231817625463008880615234"
        "375e-253"},
    {0x1.140d6862ed66dp-839, chars_format::scientific, 638,
        "2."
        "9416104456955937221543776398156706685887661223033136149978144195414487069880048080968267584297336066506254"
        "3115356949437725212090915600835200704935405467625569119444005558649057853906959361320327321285798225893023"
        "5229317177289893607816570293832641314174027421888172164237619051576765081507797361682755327770880513040405"
        "7575826358204046303559225686729160901856986719048077867296931804843574430849104888948208416960160463531835"
        "2482831563717046642268932327206818661898710868016377802766481100753130432486192161299895341263446334301439"
        "9966471714416366962788461689772484722397543415502179310786106319420066257386281449726084247231483459472656"
        "25e-253"},
    {0x1.1556a20068f47p-838, chars_format::scientific, 637,
        "5."
        "9106288435436441832925321437439273066502477312033311246968237725276751639214797258968915217210458498406519"
        "1599955142680202342645938198876556661177979692713340361790875196351637828414851815092581530891522562889255"
        "1785526041987019154864916301964965994784344521781015097700885197871228199743117772247657733964373336298903"
        "3343024133323958002289706156266221722389423041489830227675743527604713272295232402604297526043610489011954"
        "4521874334868186828399600397263829823264455558567290365650686459810955354562951522008422782247078306179082"
        "4274297798382230073449857061911562247122871488645554553253686055815790956202704364841338247060775756835937"
        "5e-253"},
    {0x1.8a637844424c9p-837, chars_format::scientific, 637,
        "1."
        "6810396848558273510235799637525049545294830249948222214411090835531380563125319563203943253866909216175104"
        "3257048804487611404557035566261801859080485790221260947098571342313927613866021217690405138818610985006226"
        "6056665647550736011704735446153339487543803430367841295100167579486103332587829562856169336508741156116699"
        "3821573800278394690338640699834125530610486716022332187450360770206194564289972002012617700416236636708103"
        "8543888500074700833328077519662860658313152207041831981854465792023538138098947494890681839362176868398994"
        "9485522109183673226012048016787838896032817586439816560580009379994442797467968375713098794221878051757812"
        "5e-252"},
    {0x1.6c58b883c43eap-836, chars_format::scientific, 635,
        "3."
        "1059777449559429265900676399183362537453270079840668482441014488765656125936602920378930602673659646522508"
        "0750485088311931270354408819089265208117161050801207000067848396965880346198894113665199706590577342696924"
        "4262616672598390077967522675156490575620339033736544018575331426236187140125932174293413904931149686676806"
        "4298338564655493854637072357239725464925528075313439590693619626864606148281041428613600174497025784538263"
        "3459579611621591637238666391502205681590372801573488459837345671891293214092887485037314994884435306602798"
        "687276288545989827758369435248803257946775797031683187521866108295187647314605783321894705295562744140625e"
        "-252"},
    {0x1.36a7fcc1cfc46p-835, chars_format::scientific, 634,
        "5."
        "2965573801445690722158614076883511123532332685924214717774752426044438667279139986749437517515188177140269"
        "5485375202212937664379653938486718551271787640302576447258297441253734512519058771847953071990841730343795"
        "7327930452143347292118755771583009879983230855464894740311328415111572092561634509970907891424846710866942"
        "6864597398228408661760562863344203484553975704767864965698077298580010056954322574128346908080869265075775"
        "5739269716961846858456688528224803759035924554112211405402620391714747114614201404766504398808292555529737"
        "18941456131767751776122974578049807479540550113655955376254567783245175149886563303880393505096435546875e-"
        "252"},
    {0x1.aa3b9d0ec1349p-834, chars_format::scientific, 635,
        "1."
        "4534181673457758400949055236695221048664713095250053797426519767853237041835956791976580225636371098279321"
        "3214068181046129672798657879984495167728061963953124586161238507439156789985644488887055291390992087782055"
        "2701336906544502774398188591604781018114504110735607946242802648806954749263291520974122404938211127908934"
        "3575631285032666899798293647051957896468777447945107059181546956408240664336422516004145304588450388632522"
        "1070737739693194936546919810702692652603043565212622312212995327472532618638556231986680206742586143722403"
        "550783309924285289349297072101420663057753817823364411493644089180821143969524200656451284885406494140625e"
        "-251"},
    {0x1.5f0344953ec57p-833, chars_format::scientific, 634,
        "2."
        "3938479247234097018550458511544817367739361536200950902814825089891669710214106361799807545093859687694323"
        "4520222814663334325501959922339511022417169200258138866716240572516473903243780418299855591784687744221561"
        "4673730495274627840445980495455053691946265275961590944942894884161146186125918812095405141490376065791257"
        "2990007375277218500031379100913127364874315175834774396942682472145171601247554709419898298359216080654381"
        "5234719036377453626738864303434918589623115748337487232265520789623861131272396012356699775618072348868787"
        "76372878894847401207188983556061557308620341306536104552493931900414292357481826911680400371551513671875e-"
        "251"},
    {0x1.783fc5ed947a7p-832, chars_format::scientific, 633,
        "5."
        "1319111420103700499236206263878034212106202950930977551857998220289308747630115765877892885472362039275322"
        "0523269264416102554328703892784714509871799045575377396811614393505255988764201594860924728188446262020599"
        "5816224373606402176926540883831558717591219455218087384224255737945036264103454832864541982601681641504954"
        "1718987656545856396071620261775045714406002201539977040442012225019186665790253178924857163319970339024221"
        "5773002375760167632603757343376191928042229339921704578692579360050525881528852289207475083143721754146523"
        "1243409180954321670387197333315664529506371145190073701706340823791574479173505096696317195892333984375e-"
        "251"},
    {0x1.40710848cf107p-831, chars_format::scientific, 632,
        "8."
        "7414290750552295546310067304417538089998764617839404299068353704815397343149675509135958228378829386585016"
        "7188491498788205872086312288388767426146999394659547867198614986995481660971205928823308477880542196613894"
        "4275623574987168431568745304364621669241457008033758230714634333799159208383480168990161078479986731377274"
        "5020111854169849030780011055234667752217741062441145534653890585011154245157298808199839856876073524543679"
        "2821070637754721727631828680882026195550243758494821815186708842256768881464944978789741055024675233939100"
        "433403212219702473933537591600476985467616468889370663931655085210348232749311137013137340545654296875e-"
        "251"},
    {0x1.7d709da2908a6p-830, chars_format::scientific, 631,
        "2."
        "0810847152471556254401311232032188728447267117360175717891636755620348167659504840695434647539993442189667"
        "9066888555643495483464096384894027472978012957276210634072464269390297861825532386002160928480072354865994"
        "3879732460682150385691303824800896612452662280810299151162782505065316201313287687887744161894093458421161"
        "0513283413566516116159526022930867617376801255296549189477727203602595481316438645897519886431470703998215"
        "1377960435417890291154205919810773879383879482532629222150323363757619454356194585518671919581410963596163"
        "31249245416003787574812480465286687861085268674943439588960990282995311417835182510316371917724609375e-"
        "250"},
    {0x1.3e0695064ed8cp-829, chars_format::scientific, 629,
        "3."
        "4702108400000347766175063830843523770353778618261381349778046912840338008912123330979886734938140131953647"
        "3650404380879594113908738392579171180233191183812382724432641795305629872774983638622063672350876094571233"
        "6499953240251855646705291887761133361595958660743063765329731272882479029390612416402919177315324330478981"
        "7906314100021310207581009790350421328660994413130289544979421802072005157445008442147491610582962042054585"
        "1320886313933389161115405988770793923103408378052619011716334186056438214857870078005536727201067661995785"
        "790466451286588137374823625348339837864856184966498995800830706937034619841142557561397552490234375e-250"},
    {0x1.5db5937ba8bdap-828, chars_format::scientific, 629,
        "7."
        "6318668361521597024921032941163912195843047360807572633855844063123137453078655746202441700789564711179706"
        "9916923337389527280904671103326648100882322011480055143650535250537017261380037289381165619083602515263170"
        "6262769131163996536699740657297258151427870476072005518538156986453060386081899065708959573969700226946302"
        "9719928757736377066684783971457371284337556021383941621372989509463523373387393627423053871399621032962573"
        "6022033942155448268043514668101801250595923776575465783992676218557609418576221962370419170839207704238194"
        "605439691883635468306303649484833033050509910062272350022606615116416151067824102938175201416015625e-250"},
    {0x1.6ac6715436880p-827, chars_format::scientific, 623,
        "1."
        "5834019337617895673529802567022957766337379198918511085508103045110528907733717602402102884849998115672191"
        "1870061098205010006064994116341947870874025934708681989200668415753105577412001082854515786066821742485680"
        "1456062548357689341619587901384884023764854066935774035847090830187065881058547524256867923951849842211943"
        "2276079112931267920833853415931213541677648134703690053765744168086411452423513659991329474857843477918188"
        "2707143218003668264272483816403234724241995471642051516300929038491267945868500721886688596381791055070199"
        "667412232286926092094960561657785392136164166225682260746854268518291064538061618804931640625e-249"},
    {0x1.3c3b00b563094p-826, chars_format::scientific, 627,
        "2."
        "7604974029531470755379958955203393724195949942057591244473815246912413391595013067101010555177517397100426"
        "9851394280913110142349802027895864686659380331926581354881712999287134480758847780103851594645801982342979"
        "0641807148719767698251796504092725134760739333533889568923210722351490145615126375166980861819231195004556"
        "9505026974147140173697808659679428521673427481132186985576932729538148337201682004999096184931755553173054"
        "1128144851232381321744989354016415799229573544122021935326635841125869650200213049730204055454487099841334"
        "7544193726240738861198240363922061035190857842312351787435187322472529558581300079822540283203125e-249"},
    {0x1.0a0ff03dc7b93p-825, chars_format::scientific, 628,
        "4."
        "6451194553246022272173425910248807842189717398564905420998902159587754760551012912411892518528475138617823"
        "1276077149413751767111950364616545937565579226648034335148841326886078901110074148150025254392503526305529"
        "0370216558105709306255319467921884924334139388491595779690971062717608281675484211415461117818876639956161"
        "9813289346817198949598305014082475316385753923603720505835516199626324546859661234530477365388955308858864"
        "3275088066098893147926453981673835512772595499765753830966771751165528157351625613694857586869049470850208"
        "88284307723768352498369060642533108685449620935516154367726782137282270923606120049953460693359375e-249"},
    {0x1.1c1859cd75eacp-824, chars_format::scientific, 625,
        "9."
        "9199020006964591277293509665148114175738068218299722216171684761860715405043509729734134051835419456145780"
        "4061721782774131614986369921373038006621814451564434018015185478894418237919900549658925539440736238657233"
        "2689373586933180978659721914807011300151418921971642861345180133723088014278380959822191416998871835413481"
        "6229989291886742495498869896064739850070478724667412357597823910441887617574862626088827907557313143938169"
        "7371051031113861825221076651489337708984454153330070788022052771042484812220901567775296839230012789253525"
        "76743515243575159677709123598388542132205569638845363104884267357874705339781939983367919921875e-249"},
    {0x1.6a30b52edc7dap-823, chars_format::scientific, 626,
        "2."
        "5293584256227206734436690448860438863560423322197287673071289227707969220482106883975461366052769605665567"
        "3032934775744927789366034483299943037941202054718946505243272833507365629419200820002804983158179977271757"
        "1671721074991839534481385737708488066272572252571245350667982202726521017811552285767239087036275942444147"
        "3374843557581613823597887118702404883540266812295744444400774717845528291905742135010555522440223183088720"
        "6967806285670112170221507665071279926429611065289317694700042420246011589644121085837055088423442887441142"
        "392232124354630488844367280025213630868625148079983856914954021277708307025022804737091064453125e-248"},
    {0x1.ed57ca0b1796fp-822, chars_format::scientific, 626,
        "6."
        "8905280466167352632776620072267895607425419562720887072786636113143019987094343582792471662292866076472939"
        "7730215669170795196785528888685159578923864553514694529384313751243344600123412643351227172604529578659637"
        "2096141206042297685159845546380806896152212520111951628197619447822423235689063793472058111226067963673455"
        "0174591142037230254783839132641626802370354491366421432128406243347719909512208656554280798669191054910107"
        "9454291551252805162525706181057897779052882188595582910816002410243781113060844501237388400738713446722875"
        "308537861185231999546786141281236847796378186571867436281679797360766315250657498836517333984375e-248"},
    {0x1.64e9ee7dcbf58p-821, chars_format::scientific, 622,
        "9."
        "9700406511611006380450058410122703902067520359419945795899511825630118597958866580756336755422909335129934"
        "7926878163027036020163695376425344287053227483975642933460875671431629596491665913660803544069466490750869"
        "9970961003572985859670160028279294993823700602311639161464638127681204361896145848503624511004696881465583"
        "8036376921871076322233996810721470996621854701276918380162974677430101574359190896715256741796115091909122"
        "0856185361682832504647890500198973106127845308319244621499182967427340316386207631543160167022751161619375"
        "39201346108337384023359802355141440629266624923426713678065169688125024549663066864013671875e-248"},
    {0x1.7342806f62711p-820, chars_format::scientific, 625,
        "2."
        "0741563200652302519678516416917490637319537103668252987275223368145627331969006334067507115020665860903497"
        "3765141461912192994606787899859502313760751816479041023020811816052948008049981562060747467660282220009364"
        "7710183989389227941857128261486792713783713285962553612344064327011914894418682422167270443852098206799122"
        "7847782624679359595950024366056315181802777138084183269364044545618872783135809627169533047399996575516600"
        "9060687380227497970016437257881455779017980410088339024792475991575812183540342607164382360274099587700869"
        "33482837896691685792186827022522786412573603601400469044480079361392199643887579441070556640625e-247"},
    {0x1.a34800bb3cdccp-819, chars_format::scientific, 622,
        "4."
        "6848861238967825523919435523535138669568875591721693952497479446960968892754400320865877857137724925758637"
        "6466312176966101394984044901307208121700242179682309442063485879866325529597911633973911504800785909608004"
        "6421048235855444747600807137572005573286478427366497261165548010683612698376700103460067306048636372592132"
        "4059660642721400203275806867777947123755775768605772981974944361167157944352867406159553540359103081682108"
        "6636053116272544880672224430084688270810005976480858092339374406472583258511653370211245655171535530171348"
        "68475375552171532363258796791949094141543712314728307999356360369347385130822658538818359375e-247"},
    {0x1.5d9ceac385ab3p-818, chars_format::scientific, 623,
        "7."
        "8128790561179689261605470119862193017985069838967025530261087587933055171958709784048417131883969881289232"
        "8797406572135239307512241855106659665785341333808027529891639934853547347164191104084961308532479285784922"
        "4142225226040785724236443793549159284110455362352309285581855331258281918297212200744899407805498796041724"
        "0223606030354633376997447668412408687420142278688803934473416390666672371634334561300974538601862070328598"
        "4804418822456502710865535581459474356864773068661534540543910873665770745502929686614726428960140394322959"
        "359752172388948566070676292817051125806874533856884006144394305692912894301116466522216796875e-247"},
    {0x1.0397aff005f16p-817, chars_format::scientific, 622,
        "1."
        "1602344741507901062609933663400332688034477906059336896625075268185503321277861155577877309099200703570062"
        "8717598155228811133748159351247592155729939171162247951338314835092976771138161453964800725190495041903503"
        "0115998861373685927735467998774993942859232888651217060603538892135095615587837214035061210211423585850725"
        "4986658169040416093975183029957643060233052384979024889678988680203420436124343358353115842501466575805640"
        "3520972892965604183687346789132289312009394370877881599615814659100474082740931232740166655750873897827114"
        "15272427588336281066986388648508170505840000460355369849008155824776622466742992401123046875e-246"},
    {0x1.260e422cd6d4ap-816, chars_format::scientific, 621,
        "2."
        "6285314099653654176280875743233612539556461168217321507191666512583849543277500473619693088454262930856098"
        "0983039488026043122846937971785423871648148955714263876626708355772491994903748165606956838961840921237500"
        "7093350457729581755520989176424652492855243872462258991029991096716016371967122853936092377692113114869321"
        "6974910909635803632416076140521430405408494331098431557109315555609723028171644630679617395772994661804039"
        "5898962237787927702930458496474668440982602127355647894730320066735255098153627327592205560893738901018096"
        "0507882534877738471905760480320075691097888868409150620042424861821928061544895172119140625e-246"},
    {0x1.95518b86155dap-815, chars_format::scientific, 620,
        "7."
        "2461952671145799308682942273613242790942104994852816207973587954637784400200604552323859641436019959259805"
        "5416275243813683243530881530312826717587000377649636921271072048731825212743492857367125402295389748557776"
        "9009988607499516894855419967617891078215141053644838762332408552091459298218235738836401360617336568712397"
        "2838007379314935535311449332150300365272142072421910507865927246673247351952415023600273667576940226363301"
        "6530964920377056989684886628111989097851316155861987869187828267689030429662476215473756935600868637399013"
        "945524368611538824872280748159378906498225093109517847000944357205298729240894317626953125e-246"},
    {0x1.a74e934210e34p-814, chars_format::scientific, 619,
        "1."
        "5135575793727129243415548881706639972764602138477489832613301661125525653261291190457252646003879661546406"
        "4557235535184255428202266594734780713103215069500727504595579802054769661280199593841908822623154438852886"
        "5167219048211633614353037959605771745618174998999740314969772733593311483252794879934591349391924024139119"
        "6084831250696806847449720365426721059694382001837632545128601846310630150492094628787281763376199207812883"
        "0310281174844229789408905630908727536976405794432973052507474674698762818002597976646771449616515170649132"
        "35704712171841032071854384668013379767883698598547603797470628705923445522785186767578125e-245"},
    {0x1.33f5e315efac6p-813, chars_format::scientific, 619,
        "2."
        "2022598987138437754955088140950822414079425891031517825754706103180380894029334891007977048969785793187456"
        "3628273401003849229027947643460709548320874194553229940197985486063866961467079881830131956202351541355456"
        "7537809101283096834013388339700196877232995665517358526772416380714017470163654641203667347296739134840984"
        "5462268627991297391371820917998165639554697550184147146843309056835791578191595920503487299426257807906684"
        "5040859907941076591375398817610400020832219000691738654346851177693702055925078500930211965695729283618046"
        "81928981765720671382877489626197246411346537353463659325569778957287780940532684326171875e-245"},
    {0x1.218a6c088e0b7p-812, chars_format::scientific, 619,
        "4."
        "1410759136055035697554355612523273349805779575443516024484433325588504826173501106274906121179378322764594"
        "2484379691318093841368847098623863226362751057949455437358357281291709007819852095728818477728142143877797"
        "0618618828499284120946242604063906544270123754851472649535798272106982211037305830443951538621938405272895"
        "4163702265368813309267001173474115003096471620752013064126070402182426851829272536682605271459261120871427"
        "3261395627080752743556294388041183383938489151395241871318175793857142069803602514255759195099358106829389"
        "25941403961228692586646991088112498341686942122073789018799061523168347775936126708984375e-245"},
    {0x1.666ace219c563p-811, chars_format::scientific, 619,
        "1."
        "0252325908734784187898407846312169662933964451617206135619057870361506177183633250060030678288380992953815"
        "3910350720774420252564370061152467229984493300103561343350506499789324794467185732493962094862799214271322"
        "0434893279799034506854982649170149103444477505174541550420185719057992592872659016813377466213470076718167"
        "1587928184828928855320129149015094685111159435268814365435146233180280512075699541026462959427795332349621"
        "6849064667560874431015731716350235234093796641399858007197207265469483871962411812276890490973250357109437"
        "40918313124555298228499379304666253435895481214111535361865890081389807164669036865234375e-244"},
    {0x1.66ca7625d6faap-810, chars_format::scientific, 617,
        "2."
        "0526028348315092269326491491416671614717274844171552199771340287149629751710490353817825471600522327742276"
        "9848566747186724592570603262783159622679618375839605019976045985194702598494093298790453729629386984648069"
        "0036876519192087476613750641520994696959915507812672382558594635321159278065876914295340826056875441592600"
        "1413614588937378827408562300025096391492039454051283528928602590153392153556731943973383727082855350556933"
        "8189950869666550111368368477078616821706475136695480270170795820169174490625031489877623760618366454582967"
        "116336156971442918961856394686992446379464696305794380037923474446870386600494384765625e-244"},
    {0x1.56e3bc6c4d17bp-809, chars_format::scientific, 617,
        "3."
        "9232668413253934109576315523375410824827635006014532478566376795435761660713281112033855290558209088544095"
        "5118644308491937391706798210947879783273508829940864077425555029743665433796448026542881792523707845529392"
        "8888040646795226366213825411580640005811347292313508735062094848631128449978823754429190527768902694777788"
        "4900217247311196596714046442296568356579966479778682707394799024085491910187918573868394308146580143541149"
        "0916677352788480766516306849228406228050468116273820675030593448761271107798128039605500438662893943456546"
        "783890712558413724203498532897484191055958980230700117175501873134635388851165771484375e-244"},
    {0x1.4b39b2c87742ep-808, chars_format::scientific, 615,
        "7."
        "5796150735595968518238983107483839070003142955986974311581916680225791453486833700764162887478630207856704"
        "7822941859480260584365963321876199100372555439312474681875955134391985832190379567800238426220267234842361"
        "1239623046545996988440924432526210697817982616974975257322206843303081668533190742330428145605682185623573"
        "2670262122379369805524587294726325653350409831517894348004467928232650745530506560430564162969593601708820"
        "4593973141345297028237304870101790866929027772577561222369175133237449464221430999208311216033139713942561"
        "7718942914363891383632845680383464106053752022684744105163190397433936595916748046875e-244"},
    {0x1.be40d1e238ed5p-807, chars_format::scientific, 616,
        "2."
        "0423721499211961109568525534671443647740451225589577776776615350824924185902447511045534069936905640957606"
        "5372006706682415988169410761618104420823540344653655850495453161898116740909085283322163797816690426713928"
        "0588386591469775611793558909607779568837686913517898927696512373572016048102090271465196837631021566949809"
        "3458778713417135141374746058126296881347472422680267110011339066236275056110971927834750821976896185521894"
        "2603002734635679430244400522090001984828634799129531569049286075717103643972525011916090411511711638026757"
        "89249238420106837535506252866076169083468642463652376051186365657486021518707275390625e-243"},
    {0x1.40ae59ac6132dp-806, chars_format::scientific, 615,
        "2."
        "9353293314833333854985102733201521796250036157410578174458181974941681427901748305530776598182206753889861"
        "8636371016267800470669357640180721556010164004214645520298136353408719208286540502372077707795876864389123"
        "4530987039470184872750427478883560918646684350505130722837863014999727875555215685304086401604276801173120"
        "3139790194066844214273369426057653128075479513670720217838142259228046519573053627935149750677307039941356"
        "4828147132972855997122201965456703954022412625507350561624510655574143234052851884708200203074614546619619"
        "9361830208532545550931607060890187286750154134484791512704759952612221240997314453125e-243"},
    {0x1.5c161d88eecbcp-805, chars_format::scientific, 612,
        "6."
        "3723638585700451642795559570510679148094993613910324952290173092838588831267228266631303318254630028045739"
        "0407187178061510576300035754372233822499222282961203456720941314976636497138825053868512001918319562376117"
        "8503122166819829425566310708112327632839687765866542175513644077648632060395171310907363823836647106858223"
        "2777412680176689313447386866112250866307040221174507703114483598510540103447645068390784004440801839078883"
        "7194778885429238978252063987403236158204856335435926863891604588752783057832428086623507826775024249195807"
        "3955716265349471157901811121367537037413035505561964555454323999583721160888671875e-243"},
    {0x1.ae3b20e6233fcp-804, chars_format::scientific, 612,
        "1."
        "5752344142353219450694189702451991296910433408430789019004125131863629296511431154230659503890717620031590"
        "1038316721233788818826571623317203349289987417121376686501945841032567911901250552698960793265396245960534"
        "7373167055651820451912046546618888153412645242490087251350087576649187699383010638982269418082540884562832"
        "7750244082466163980074438483304220415007922943039390750698179386470176966033711270276708288351928574480634"
        "6620427578497508169144643312340209721649688496292864219377630628268116030388752066570843025641533813750666"
        "1505153630440989474460324611066529306552773392890998138682334683835506439208984375e-242"},
    {0x1.c895736ef62c5p-803, chars_format::scientific, 613,
        "3."
        "3434436478293493280593571271178008379632079500385975548283939163497852214879044844517670759497091492926604"
        "6301395881911376324184025424812370739165394698174516004668202850196235934904450092005834916657352885854495"
        "6797122849756889458856656030089637540017312018075458430375030356712402369619517176293964796597028107692733"
        "6877655770322576324057362054878847600831468525556287002358878533444200008041718236056969477827934772656677"
        "9815145097506338920779765572188303868670858298304546602128519970722727663497018972024558384033232006396023"
        "88217361333368030658835443253281029721128182752298840796356671489775180816650390625e-242"},
    {0x1.630761913b642p-802, chars_format::scientific, 611,
        "5."
        "1995664937001350863664258209506916125612045887421035495539968219921552001490404512666597057126511434752881"
        "3007435581863058379511824026420279450528771594711743194984119825629737962368975331651816862223263764907329"
        "8959845059152436168274836787886410245541432791484117122823236508634176085889592513409849869200565154766887"
        "2239050279254533707915364965481634484943025853564537256019007487191319787066437301873020171361092201939838"
        "6184775914931861779759491034394263205676462386582564671334894431929147821752438599108003402914657920461899"
        "226466173041809225803734159361765368727488489941634952629101462662220001220703125e-242"},
    {0x1.8907b557208b7p-801, chars_format::scientific, 612,
        "1."
        "1512226658355749483847981607903749186968456271470668422905514968048682862550587964588422845161815767196734"
        "7161381736286682330197784945747956438186532961339942750020185568887387914264273351910759945563214255066684"
        "6367743093899226009412278214746750427881209859743419090772304032977787125925338802665415242857226084498164"
        "3083102151843503613040369064236192185129466999497241256541067862601025573632294816706426141506628320469477"
        "4696736056927673474964247532394453617303703702170832899939996119301381165251917266354496116545457774453945"
        "0895523040343609292008370421060948365454650044181761359141091816127300262451171875e-241"},
    {0x1.0954ea214daecp-800, chars_format::scientific, 609,
        "1."
        "5543636774561636974984361218111011815787496115988125251761512745799203239114570231530311587628929592941376"
        "2585042010727044016847870464502675936376968118423019078639597656703801878013483722710291570262191347684833"
        "6805205669043926853377700998806089359780103711297258044030751523125011328665317845898485403235762350467927"
        "6134156787944549174068596540770894898876924542106646637655671038405664723034557454476207446791320248290714"
        "5008167400683897298836718888410810473704984083888533798729692197933748270991636472806299358418250481774109"
        "4771758489864324415337151128538238880998079149975410473416559398174285888671875e-241"},
    {0x1.5c2fe731927e6p-799, chars_format::scientific, 609,
        "4."
        "0794930994574949442525316075493436362455473092684438997934986135437654466941332739768956377877473397607134"
        "4064958156084532579410087539106327345372818664352247197277361471370030117784789618983207924927651450687711"
        "4770356574608290123358451973486669321692492332398543131893173963499548478234080992976620729264092514266793"
        "8419538195787260791452711556640767302269532128743048602157910479633566088244594787936712119482747027241365"
        "5907401119681985982507921557024707142597573048794208218331141095078100425607731851283402621691247039292834"
        "2115674805610333210644028408620173696379207495255059257033281028270721435546875e-241"},
    {0x1.6ae6c51c6cf43p-798, chars_format::scientific, 609,
        "8."
        "5037834545028439726511173970387065376495451801221358745541466022111055279447814368476465692501533897808052"
        "8414620606538201959175171073351443366751678402386951129508572093685812674971226575682201470239574972506910"
        "9128943544677360375146178941605556087049517009816921069940296076289616976017445345589202204019215772204351"
        "6311008757552625899436454298892097346319367204313955610412435512953237673867098391988751837296926369447076"
        "5727893031773910333948712489912482607284107894642961799688586136148985510389912656105970673902638925743472"
        "9720838400566841392990613565908529915098046370047768505173735320568084716796875e-241"},
    {0x1.ac4e86c315850p-797, chars_format::scientific, 605,
        "2."
        "0072820595479573216169126231394408838551922619989874786871658199647732697034762028792666015861804714982292"
        "2191591154955291378005015587839555531480612063235835347012810772327501856166588209464579572448604508899906"
        "1772187223684855162442424175711463772705279180982126416318031074372302865560128825632323317889694497843360"
        "7754085808572590924978633945247230403112787302032626015620605415136044530348825415809501368263327044824152"
        "4145945455699623696095441521069129226509344118102237809251029986795488661778437540002054621660753197441908"
        "343343400344601261991557764803617049109707437537508667446672916412353515625e-240"},
    {0x1.794bdcb1e5858p-796, chars_format::scientific, 605,
        "3."
        "5364382089011979980897109687165254886696841520981254446556125956556978294321082019870841710940758511838532"
        "4894179439057364357461159517137903474744654629717453375448208774398730333711862007633962738258032417741380"
        "0685321115393078264140362224325824070666437344191369939443217492221993668605716208990694526263949725175127"
        "2531533913011070118815751448623244063021481460622877756524201582813510487724558551743402584791531847833324"
        "3947677512125596726121471095288063842196951847839048568745797565605397830354659437463682786127174530399653"
        "052185980142212749148863110471344671503768353204577579163014888763427734375e-240"},
    {0x1.d14f7ef9a1bacp-795, chars_format::scientific, 605,
        "8."
        "7228090145957935347248318547742302587087102313285501442514035526226306674555848729098848343284853736028606"
        "4873831254928609967322217177874171796955578934465313147402878865039420827565176878567927435477084189200595"
        "7806847646599109442906678146695129581406643504246823239271381485582046753531471862258384352222573375498842"
        "6169068002044002105223868118456214469943463514242867324395558742911540780602189115030142752959592996857877"
        "2273040528807362627380272902106605717316557112560491693041298619232077978968586186803325882819783307168556"
        "881297598817001041704706994464233425767840657272245152853429317474365234375e-240"},
    {0x1.6eb9675837dcfp-794, chars_format::scientific, 607,
        "1."
        "3749379101340066083857337348176012879302998942040643891959413447462809923213710792385920913367060586620860"
        "5258647049621760492047179451844836572119347356991890024090747092362463756927276284737937087463531842640685"
        "8110822716901060321069319180330630095350071198454014017603381215347279543191075769849271941472232894509230"
        "4179731068530834521111061163476202640787726787899152301887532484498175670012280605395371745814997035811104"
        "7972034718728424120220308910285188823533296077514778262102253723563125528563041143324629454753231680542831"
        "91572629933059608724961728922265061757224113847541957511566579341888427734375e-239"},
    {0x1.96e8a42e0e289p-793, chars_format::scientific, 606,
        "3."
        "0511988184972799383071211924634487175460180935326054116102185981586408321039421266980709352417518315887404"
        "5050170880613243376562389933452426086185695180699312804245142060569472810956533457237033496816457196253387"
        "8125149465944408270649637103835598442140509946028942888834087818054913127959283097911123015576692191085606"
        "8568283496852317230749669582281777159547977023790389787193331339347536950378181463434129630396971207994134"
        "9950377993759212633121226292844763708145719324648259205908825462198868419797842376770017948515553052857064"
        "7693354807915784314898721093603267857929939310679401387460529804229736328125e-239"},
    {0x1.9df5b8438b263p-792, chars_format::scientific, 605,
        "6."
        "2081425746751335610146680295435101859461655681989036586327775217238749061303501735332371382900280575515719"
        "4020730148118435599036452088715313932099113134973129083783128920389682715075150575144731203122222001783294"
        "9424406905553795591369611573268431281518228057618249401975945890243492974663368994552896023782381782553916"
        "5337044719128567721394744671262149404471486748537392698331767276580429963086090235313827296241311355503851"
        "7755830887058852014800933522702452536975068231984788501210512796491195164930952739801311157528383120640408"
        "842401705946246458190149534645571431645816318223296548239886760711669921875e-239"},
    {0x1.fb32cf0b36aecp-791, chars_format::scientific, 603,
        "1."
        "5212878641555802724950846086516145032300326998691190900292301735619031405755263380867819445511072562572943"
        "3287593703388535027004430201878462180974444880722937680016604317123047097924707771861156618306166328988807"
        "4173424610772542026483506595446813945016920935740824692420808377728446284988055043397756717427418778466960"
        "4764984416510689582171300446811130954623811981865739826589607924848307316279607843133793365371483255657291"
        "0067339723232808270374427845927610682612753312034224066285259685752517765740312550171970032472135036986863"
        "8181213742553728087480359007130879811509061028118594549596309661865234375e-238"},
    {0x1.a45aba26ad06dp-790, chars_format::scientific, 604,
        "2."
        "5216166351846410904598804126503919975960206341421556680673122139430839618893068778953528650714452899719345"
        "5246108125158739482741680475817985898310280861272177832678069868601568095686217379876046803162010708112630"
        "8023604716065459630277834590133356599359591175082540998292572569927744367695512232618054512372669109059329"
        "2278734289697568086682228820112428175532506340283777063322011931055911875751981872871842214504360402471002"
        "8669711497076549528902364758613574081434795344422816278952670020566267027219316225416939365006958713799490"
        "66388752655501946377532357382246670784997633063539979048073291778564453125e-238"},
    {0x1.76eeea7b33d9bp-789, chars_format::scientific, 603,
        "4."
        "4982897883519312349700257852074285242839338405891623616075244867023942468017792455826328206218393099579788"
        "8538183326678388281543698838695901138016399892101462657564145324397174804795442702076264717572685786596699"
        "8309206594117460390492150507731013549139591322588458630372846181251298644962778269180438519777882585752366"
        "2061647833682308513660258531274218090943034841110993020477090849934919002278855577982822728887910520508057"
        "1309121300301230873906142310636922125841785801395507975381319776355298465790722044417775302439469856484395"
        "2193959423860928797599218080852621903797938784919097088277339935302734375e-238"},
    {0x1.2f72b0932e6c0p-788, chars_format::scientific, 596,
        "7."
        "2812801441645303966418732522860605234446781581701162951874702445421625014697873257721100247133280933337547"
        "4632822147569730372734556192651075193509364068638545045433634662479604972014032304625118712264784753862330"
        "4240701146998515213155895112699926325225487803168318982122886793550787654412114711135260065548158754163814"
        "6267792175300075972880320531815842324890334392814926595009128071211433776121950591682377947812052908478752"
        "3782045399878957499545795346063587985477731111479849521556134883351589450597232837336115964779975403775359"
        "793941134875836977710206014691163289853648166172206401824951171875e-238"},
    {0x1.a51a411cbcd83p-787, chars_format::scientific, 602,
        "2."
        "0208837171448895837318180903259214725922207568227959012108677599688049530743023941864936723736235817948008"
        "2611403427798946547661988139742169620596220391493753722071403821592772010242534186589497286966518076494362"
        "0678420736321907710661911556894381850108346506265630319767913919399030191431965110937831030511219504532874"
        "0586466146512917773158338656319118663906595686588537648936843031647093427657363683641219540298646042122056"
        "8317426577038520940327301670924988866127770057169548924829741512502567293851452818399420681877823748179849"
        "398737440333262050279769937353134545698907231781049631536006927490234375e-237"},
    {0x1.b808810bff5aep-786, chars_format::scientific, 600,
        "4."
        "2234650668214423350279081718143018052918828845233278512008791451987305685594591145976330970127359480860248"
        "8548917264315584433512455554684826100034965613524346519252961698792900476189960718557697298950778181410013"
        "9640228026095584871810289683508239794468996786987719366315242777184998255799306920272281717213927883238578"
        "8203065386664239152516789871769170789609239941892434305575451880664013613320226313501911783489649376683084"
        "8714814724615946149072474408582468575754684669730712413191753420272477919667200484972631788609536129952239"
        "2188637733793856554789030127543270065615388375590555369853973388671875e-237"},
    {0x1.a522225f95f46p-785, chars_format::scientific, 599,
        "8."
        "0841257435956645678547405463747941035254532491290665291476902755342035620999121915876359426286744536442548"
        "8791455796027552732952087071822418098846022103639505489312321900912629868532623475135095009363265921031875"
        "1871079021611411332741033775270408893701977185246154640873852536013091269615317189935301688316595497628363"
        "2052474049117604877290387290489379052271964810487511690636116959829601543260594988729338797802211604439634"
        "9881544511737095144068929116901090243016127270909040329117435763031291331734916897008832721886597106496144"
        "499841505379496532267678712661840290110148998792283236980438232421875e-237"},
    {0x1.b3dbd2256d4fap-784, chars_format::scientific, 599,
        "1."
        "6733590187416606942028788295822734147043087946233607968651016945006043063743409956982922605165150262493695"
        "2359551337435141043924366256262954714703084104196403532472922571050719624290744697858239688419404203520754"
        "7557916850717553492842057781744688693737608928952458431646709318550288396484391157776279484004370212297762"
        "2085741279270737213198962173572325958013463853117760877665013868039714619089151048393695975458000098063344"
        "6858750098421368476749851793586866701372231665192694279106769119933450898417201549643514656077765935283060"
        "136103656512062492185832101622422474207496634335257112979888916015625e-236"},
    {0x1.6578a562dfd81p-783, chars_format::scientific, 599,
        "2."
        "7448244739455369599852949492552923507948333818208197008468158129083810159695483256360269175415015466412031"
        "4225695400387005807802038517353586335988207343902959393348397621769684884913575361723052144412545323525101"
        "2843207362623477900893247213636680781392280455803632115282785593332780520340251878255628655632838690511799"
        "8586350085644107340826449520555370615285390114023939058381308345313892978294651712108011038387663767010617"
        "3438419253507596733224476414075014265345891995296496120856593048414341827141680276415523884377632032961134"
        "065066676791255166649173319499965817414022239972837269306182861328125e-236"},
    {0x1.c375b704d8354p-782, chars_format::scientific, 596,
        "6."
        "9330212812845955601973051705409859820189947914406991516234621867700438780635584678642245240229377264515669"
        "7338726349371873983367424350097381613788724747210201244748437625890393184241908098354893458187915104119341"
        "7684465460693231943222252870968475205589194276287015578056177004092191366508966567650334814489885848490942"
        "6122870870673228226689067501074893767746717599791972139895758896137999486120056433350900790851566486391753"
        "4010543666617786469916707237836024118874742072934775462928779342329475149180326686989774048800335725396492"
        "694612182396772755548224227706288758099617552943527698516845703125e-236"},
    {0x1.41ed65ec296ccp-781, chars_format::scientific, 595,
        "9."
        "8876088484049352922774021202980270628015087562012427292778038682091273168220811432033616289760109002310402"
        "3704996008069111083741196140661388861826358577996302406407082910484532702903501127304650131518239172470834"
        "2834373731353510858807009428849017497972201623850366494027130268394546556252337263922088889702844419759589"
        "9063387263573871573732612758260782869758009494263629328008981472261588690396371322017572369585846209902633"
        "9510542868187895386861625212297072254733429651534552220213138019454443987615077904499633483996281342741497"
        "11127064592991748928608140845053497969274758361279964447021484375e-236"},
    {0x1.2750c8cb09651p-780, chars_format::scientific, 597,
        "1."
        "8140520866375597592817140173198328456153471086515443891947301419067427016349814663252643281827753782214000"
        "4306072580093724492340899978941054679924199470836173279701306416204849855804566293231708048363754246665689"
        "7132773851376950137481730406496137930367940298307822959184929691157149248171962689707484240913709878645248"
        "7651516170928175691609460578402568818237797997967259089571151773860066324450511535569895183000043741984628"
        "5606114661392523948868455531855100625018508153569679961738521387114799227459274565213553967286187012847908"
        "5175141572936063038323285280528640583952437737025320529937744140625e-235"},
    {0x1.19ea333f13ef5p-779, chars_format::scientific, 596,
        "3."
        "4634694166405885699722665996156819190835305157939379082230431113198584814406142159489506709243038109913804"
        "8087091839156277339696816832118015570005868291208987392092241756886550999683176589757786184600708233295992"
        "9104748617248162737955257920342448513168770535182891455893675197708497078872366516469116334460618374815662"
        "6215995971472457141964876831499902261701806293373256835816802621390185355511566406092215783275965392566585"
        "8442737716827116543576353841785651389340117531460235593391101203276419598915973745824201798081334576050870"
        "430956021545159155021671205931799164545736857689917087554931640625e-235"},
    {0x1.a38c43ff3364dp-778, chars_format::scientific, 596,
        "1."
        "0308725436052673004078265535849362842941462603767068009055817328335165518994401933172454910493217867696432"
        "1845962716686314874470651933591385894469274918631064185075059486235684207315610254821040680581793107781394"
        "6746960625748974345607263573914820643627389442572446655908256314652737333336207566756390293322256348701247"
        "9314565117858212385111597451728156265292208695902500402336262572667655661806388175890193990786445710715532"
        "6444270656212874978801400697046881563390089872226946501545033080160837709416037693167240629952771552441667"
        "361465182176428352680002016594773550650643301196396350860595703125e-234"},
    {0x1.0b0ad1b956d83p-777, chars_format::scientific, 595,
        "1."
        "3123008280909585060094739769474378460538866107048392129824696126606516279205972547670492262550710764284363"
        "3234354641682526072825042161215500583864172196389183875957416010067398215922042534330073715044124724096640"
        "6740630337183260137195168587876580824443134710976924007017901504245366920570333649552524608892742277095894"
        "2579696379671576766979558709660405125643620837514272390698664170189566381311138897213106203693198480966230"
        "9746683046481084817065834830049684480464548077598539532315246634601937680515282851307846303670734268112421"
        "64361861337955626193876000618043775602927780710160732269287109375e-234"},
    {0x1.8a159b1e99b88p-776, chars_format::scientific, 591,
        "3."
        "8732242378153897318097485186350960300031186584656562863006373476206011523682262557811183503862971612833114"
        "6916417461255020728803411155740943257717511092693240971786080135296087495134091242375838374168505261130380"
        "0492598166723089782339674226277801628972688152897218578189493489170331295747560535252056117984854618682523"
        "9305131571924373146542287418567990354344016310437205184558983660529561615320898762527140916102609030211008"
        "2103832765594531080012430285923201547172290131441715644938740240491425394877727279661634375115396176587234"
        "0989930831780784230462810757700253816437907516956329345703125e-234"},
    {0x1.d415deff614c1p-775, chars_format::scientific, 593,
        "9."
        "2010739647813000085411005568727105998799066899037448965302675135776884816654819628173659937259171048554565"
        "9299792147126593896231306003331909077948383910755151878314000991105111186376426687047583016174605352766814"
        "8534331818246298245816068105997048536931836094343752160045427531551482079866068037732986220746545492963890"
        "1238271162895703777874458709089484490860087292013612010824285906041126662575922290223290517197672726442811"
        "0290759243860558664957215585129480394134876729038989456780357462903511930632723604504410411901707601194771"
        "524410246628913870770190286396683632119675166904926300048828125e-234"},
    {0x1.310bd967f9a00p-774, chars_format::scientific, 584,
        "1."
        "1992483584063613937396382002898619029819538686188191051376468587418398044923819788257981810312450970237429"
        "3152236901426529753933885926217522939375787436168025095420854421089105328643012783084193445775178532627019"
        "3002021288587642607408488965662669916337673223002264510994634236841840933737724623832016553236992028678401"
        "5079222380268705401143575325058869567756026714067386945351235295748404808174268116051793510048341986101843"
        "5189240188373810482122213082644041469933620211270257379648322982766563842384538563467443736569589192277871"
        "478824920734897185869982649819576181471347808837890625e-233"},
    {0x1.2a478a0b632c4p-773, chars_format::scientific, 590,
        "2."
        "3452909097606002102998388857387398320146582515932569159622941748507502071602816219003857791914292766210287"
        "1282920701702839101779318975472524788417303881315933266593759151136812057701602281728908118286422653068981"
        "2976721417530770069277611318604358776733743161458118453496278452601803441503553632201747451899227732879279"
        "3939383070761065446832297352683219271773789038387084150729566669981216349132935276369359294821930391936873"
        "0207897372104156558695370518639326240457297236641350456607151007096954463810541500796919853141331376838730"
        "027058339967416700395930195810478835483081638813018798828125e-233"},
    {0x1.a10d1c936f397p-772, chars_format::scientific, 591,
        "6."
        "5583225953784304043954834614176088194295405940341601198073153875988601237261704379055993336597678819170772"
        "5308732928182976190209935831121926799822295206356039751458151538698202210999800319499370069053119068921318"
        "6495513705997548419470722568105046316621424908719955943222521965922140810646651477916277542996197210024407"
        "8354448201804009172919086425145196331932267229375638726444077959998629259488107236621956571918999810323974"
        "8735717531246698300106404621320272068687120569178549223991517121489275313276613889947072468874020996202783"
        "3578890959869765026578336541973612838773988187313079833984375e-233"},
    {0x1.4135d56a1a3e2p-771, chars_format::scientific, 590,
        "1."
        "0102359616097600006944043696266304310402566123880381330525868678360586417700284313711997697393207834996490"
        "6412477557422038262981083901801238882772015066331526420346388047508965204935499624567755681398845856171526"
        "2242364880332481311367223365533330138935433511898794179657484124403659524277293102547115573188942514605904"
        "1262737288899085376795178896977519105000739053421097877918031437721663292284423338700565418149569030815098"
        "1976897643794990537239534181469858547742793045584048036497046009670011336379378447273760163550393934817516"
        "023051483276085451591674857496627737418748438358306884765625e-232"},
    {0x1.9ceaa4e0f9a65p-770, chars_format::scientific, 590,
        "2."
        "5973213970621353044824545188200592183419042385639727292053562666249675544942691912517025505947140109121201"
        "8691791676589598304859963199178052096220362044453690802401185643378067015831822620192178219791939757230914"
        "9709039667116952289847151837424216761341021681339723578337857881286638542378091891939886703814853841423404"
        "3498297625474216866415185214871267451369155514201746224365590408487372081525980706478638859040170095365664"
        "0645570094281836888650858982474863060907436892730671482497330980571409299449161530863472389822545360807847"
        "278223954502168854992227853273334403638727962970733642578125e-232"},
    {0x1.89f20e3a83371p-769, chars_format::scientific, 589,
        "4."
        "9559800065235153489796410194161390966488355617585666542707339136900558711218785557363856112303748107913099"
        "8680237278243350843537532200899336534061998689022480144868594550956871874227163881895319963658374522051904"
        "6712966152320510867618543585720024531194940872820672919233356870518352801434898546241842045716492357747647"
        "7957958540068442712132045749702481116171119884122838963976902383703248102452023124430340570652009799204816"
        "5249261523263392714849956402443956398232588164511714409814006544850650200925905726503033287699786574183111"
        "98129755525915792098434753398805696633644402027130126953125e-232"},
    {0x1.bee6d84bb634dp-768, chars_format::scientific, 589,
        "1."
        "1244377262803143878068016423688012596039718894748761522693123703181634130104650640135262083103846749672518"
        "8012492495381704764285966084753488065021470092208542183182084032595971810165044465057115424454465191892043"
        "3359242751160280842713632780774054505432019612624878172464734301273167678163431120242405621415824776126460"
        "8947838926595118197402289470545118797483097395936263215464251151336740856339180880724959346882809972866164"
        "2692633775304002961981768923100643096019801742272879022489813178847770417859840592829885544529002381973852"
        "04296812693280688440211623202458213199861347675323486328125e-231"},
    {0x1.deb403c7e96ebp-767, chars_format::scientific, 588,
        "2."
        "4089050126555282541403121147937146640322688813110950873494165256577427141764900209847715481143046869400508"
        "7142706729187182868489888726631219010556346470377235782761231255161283491871481571830171798317313191456617"
        "4309783228992987395309874214938085167780197703713450058388341555810443906059468275497970709180486706718587"
        "1313640308216356155999604435917605136780020449205792873192769293405985822537229012759146679613240165097560"
        "5210869334907295625604149011565843196894122999061870059481852780220056624802519719890268394327365072648952"
        "0827818495221097315484026779586201882921159267425537109375e-231"},
    {0x1.3d89cf65433a8p-766, chars_format::scientific, 584,
        "3."
        "1957993198054625725213645741173162786935684857677527438090979500370647810397958920480824463940923329563437"
        "3636851774003368423771672117121283918964674083790880004924598131903193790947820607391613617716363350605791"
        "5622232960627326392860115950940947029579098561357097854414116991950975007688070342833923998116760516870121"
        "5749176970374592880103567554395837929673462006697904438147786695003031463211995666528121763991142543575975"
        "5899718471093397427400766264709037449493655219279456023568676329258618536362702872759367963005063148812537"
        "726423102708329937460263181492337025701999664306640625e-231"},
    {0x1.3cfba273e39aap-765, chars_format::scientific, 585,
        "6."
        "3804197587403760326652898054200801828323214780442215032022007620478359597818401693284013081678136665027405"
        "6490197573287853590724100179977990824731156430940900293657954999782897120810644701128329076885474982261315"
        "2004534567980240484852566346849092151908799371287257255382445454735215000987503928361640304537884889342864"
        "3145781279385770628277566694325711581556041680649755580831709124446178875091795627785989583994623827758905"
        "8753937000671860615795959039778377116606289273494321908010815730672333507357816874258583488584279492533715"
        "5136765021905438655114295443127048201858997344970703125e-231"},
    {0x1.8fd3a095fbb3bp-764, chars_format::scientific, 586,
        "1."
        "6095894110621704153832201294055971532390391615911012418102173691565843809408450333609669585716893417322632"
        "1447397301047417148502624258582835574723816240415594393369665164751768647196218708742592134423663760259422"
        "5725582449224662605981402620585333275787021731573507809506478128418455212296523148679126266426699652401165"
        "5347686788983136076956554273893939557385379020373453645222044106667326598338033048058315587381156417693815"
        "9689442060769621685872330312916464823415664426762643483429352265211453025979662093409239736334483968002895"
        "34637228014489311600510035304978373460471630096435546875e-230"},
    {0x1.f4db39b3ecc94p-763, chars_format::scientific, 583,
        "4."
        "0326128219471308776340774632801968730422798127085717909547582642722780609987155279615390281066933947805844"
        "2834132325348297619070203917114895484113342497422436622422171014950377706618395303383927177010501146744877"
        "5538953564225445443359521685452770061497047825649312653532071752631734104992995726313037715144741959667621"
        "3378577557632829154543778635778400664844147650126586480978710722699215601770032193691389861493527186292410"
        "0599178352375439954606326097129388309765290899844628674147158970800023347955167381151032697590479982052777"
        "90672589771116263168693194529623724520206451416015625e-230"},
    {0x1.77036a5ea0238p-762, chars_format::scientific, 581,
        "6."
        "0387918131443855293985504488455915724451292685267014767829849073500412060744954585531063673030529339395152"
        "3888733562888957496230925242955930292779412423416985599139667873737076545274846108104562187768695151949854"
        "5128012141933364974487522376491162699773763210995107076549084989195346688616058796160233927611226734207770"
        "1687069702978155674956635793332657387620943979787993513510686776554055594710429194494938662706250339068265"
        "9995039549772250462149515137830868639868155808286646814645933763259664624485459438133730144593675207962419"
        "919759523671831669133780451375059783458709716796875e-230"},
    {0x1.16a7ee18d63d3p-761, chars_format::scientific, 583,
        "8."
        "9743230112456742542899279796268272934437787928293448086298107077647616276508988954791659580428804464479810"
        "3641898249421376652724137290600459136448447242365922273624432734917290803189814744215370570273183759401554"
        "4794593860976939114279110402292024483236793330618757059821482848520627476373652688290899567926159549042944"
        "6328543904775889245889306222564992234900589838102861964399884580694207148624055586974244583117165245055477"
        "2427198667133558451445735864240418102343992211275762410613327206706574095487836196314795231910512044608674"
        "78785766697922665624531646244577132165431976318359375e-230"},
    {0x1.23d8446ff655fp-760, chars_format::scientific, 583,
        "1."
        "8798157375327937836177365552311551722298566992689137495408401180064460810275669557368262486050476535706822"
        "2914315437284620215942901943604543564464950435141155358461881045086110693670535222743758425687312773016464"
        "8403232716340427184106949371967480783761089412133835752241924595873877701261614154333943909110324386106585"
        "7106392044433133552798988180692705602297018211749323498943970494194463977408110252138958916967143497719195"
        "2134646702290784545105260132872002148565751843028231690655926702860817601062025257596703145147603743783651"
        "26359435670864994616380272418609820306301116943359375e-229"},
    {0x1.d9ab918404aeap-759, chars_format::scientific, 581,
        "6."
        "1019603119906394823703359893419041043488928668777127321609779602295957755846206771587439667498191607870127"
        "3188407787323422531248450139973168123277344462820437889744367034040516526005744130783797920887934326880891"
        "0151822705828875469292565269036546147893915456863015857572909063802064779293512026308928862177518529874001"
        "7449142693550088732619227748522352368557175278481264314118546468989352818488963814913806525070024091423038"
        "4912650786353791658298950508324864755779932694843174445480821573854098041924252035624281216732196095488604"
        "104431604353842022447906856541521847248077392578125e-229"},
    {0x1.b79a4312f9cb4p-758, chars_format::scientific, 580,
        "1."
        "1326182622927227585026998401953453564387331526632995841434572566012270184131360172862035269820314552997461"
        "2413776329453373615156209188225602299611703931307655537572480430140533142776043280046186005695400263226405"
        "4098695658992751763639680664807306814276096257291132541721885536638354061211829923923336184608179768249661"
        "5655564150929904808543900488190715743181006200383902980812754628242850109644997858821492841688957682488157"
        "0801892773888859331879713604531979736514527913407419982887313114056184858415168691653101367251865741739853"
        "26892508292140337999853727524168789386749267578125e-228"},
    {0x1.0546601b642e2p-757, chars_format::scientific, 580,
        "1."
        "3463284210193605937745722937725857242949709999335060039840423204785367847390302267195263556416334323998196"
        "0737824736070186305672691183645646002343666546236439493821527304306900177800654130523476951053665910754980"
        "2006642369582270152401156269927147775627734652327692830564639498543071813945773867021650033486926053374860"
        "7064447801305583373185311623132192011604915251465977752968767098478902675252505947952937650369501082058516"
        "7696604253619444550313473087062527883887885241945951106616373139101667498193153482586796890932764432009382"
        "89032121165933464368436034419573843479156494140625e-228"},
    {0x1.e06b693958e4cp-756, chars_format::scientific, 578,
        "4."
        "9511263202511957641512399699829602641557623549736408253556822425590975395266427611114962041653194091053383"
        "3336879775284591319617332462680755701831085768322962567258389848441961989693426878116735587887408259374359"
        "2329287169456729011123175424958580526996189794057792610262538257537982706974488840316535755315962922121208"
        "2104534907468772395489064614074689875744296450508670594617851315848483996401206801717130288469826373770474"
        "1070405506427014217576152560575005033081034199467103000860613468937483063135363487535101835560640066559693"
        "432397641632558560331744956783950328826904296875e-228"},
    {0x1.9b121164ff8f2p-755, chars_format::scientific, 578,
        "8."
        "4728535909856012410200041906372414632296215272648004484427766845608477344705431493395232423944742460409199"
        "0778223620807142394934542575683530467976285196904925993313206910110734535883670650682654077675051720555490"
        "7153785753112902611247022137719954694936492237768465584405476424134983268359229541767595642143658069865886"
        "8311486350995177436653307794720582217765353864645824269735870431707954815959499644615997063996698543462258"
        "7493782430960216741916190622401646187797991212327006779815878528741174104469600086982166560311473505952658"
        "790405830624425931318910443224012851715087890625e-228"},
    {0x1.33c105a132a50p-754, chars_format::scientific, 575,
        "1."
        "2686651186489640418613729090000624883664125727826691528539824897946273278972673662123556913679663178920818"
        "9983431026863877108668219641584809556168837216776958126517591068005717065263272298248242603898184394956661"
        "2935545218642071817145322217521025560041269146239403948013671611970850556013445928964207740870533157257423"
        "5474192624851323842879640005145189256370467851069614167518680883900253222756097604564947196666302205472963"
        "5272862815877076419614503481104276280881883230397522547283862747567583163122464808826042178125167560452464"
        "976701592025420950449188239872455596923828125e-227"},
    {0x1.461881a63a0b1p-753, chars_format::scientific, 578,
        "2."
        "6885518067927030135600540861707655056802159939373748083541390174722386534014508552498653876610051009906744"
        "5588072524415445950949218647103736177038525626564873722274278821070632004195312288860329438863021795170526"
        "0348488305643570712966829103828184920483901645182663652301170189091428704104767787904483000287380436224672"
        "1781438144108851865293957093901180296561836196437647790186463949972800429878337528313848596170010590760822"
        "4914495063158132615052678462862682436495900588406487060191263024372546385805536617848116566363084955103460"
        "608268235720874628214005497284233570098876953125e-227"},
    {0x1.0c2407710943ep-752, chars_format::scientific, 576,
        "4."
        "4214640337505111554944922904823248343623564594516449176929291697505388608995390558125712875479191233524058"
        "6693816810894915724128757425416511778571176251130211532941252220691325000829704363646059477032385920079354"
        "4962681567393060012625739634735505971763236487302996987119743532149729213667588530593927826040852059927106"
        "1340719831810161934489555283359505257515360447477172801213945337256578391537827633397957645917471387846426"
        "1200380015132547253153164479656660812754868324751497403180618654707083628746868296897020739943514195984012"
        "2704954168408875148088554851710796356201171875e-227"},
    {0x1.f4741e5e15139p-751, chars_format::scientific, 577,
        "1."
        "6504299596692554662898438315568742680263082991056883014480508018205961615940064061679191491165679723425025"
        "2863380902661161947391420357522669511001475560313481087440258851257182689933724644529724655327662646988233"
        "6762161281034853480590013149229622340795138373021923715805777359887470617461808606384004424205619224951313"
        "3466820813188574640339167232416711196939091660364895317573753947157950137937372932611869784085126390992185"
        "6882812206410494132708440516194191677950453419818231956956927305302147631427349917441266753329544669595973"
        "13317938127585904339866829104721546173095703125e-226"},
    {0x1.5b320400f0d98p-750, chars_format::scientific, 573,
        "2."
        "2900091426989979358392530605461785016759482015004950433915892907133250152886447840948978235687269889320859"
        "8011555329351538993695790173998143655914545077937899287779003767388246713422999451873399075196857287901623"
        "2254708606129229326286431030847922256382404862982847219322903060522246908430848008821265886585966924413435"
        "6907554414094347760036636740432338875043535463497813544269468938114827178091505465716734212496341311036397"
        "3407460982512641208562604885921079704974941535175270523473393712114776663146839494306211123926383134927762"
        "3049276453315314938663505017757415771484375e-226"},
    {0x1.366f1ad138336p-749, chars_format::scientific, 574,
        "4."
        "0950816688862851715741981716510555491131806923753079625646873200101011841833105563713915712920089627877338"
        "6672732937467202519119479522480723407795353914204905417959638564763550732026709549946750372655366146768751"
        "8465985902038355614934756776928998890897769920782971767051608290557297810235286435333791164042348138624570"
        "9046496381294842944373805881307325210054336683711946102589264968227908777678781740079297949761856941279514"
        "4701597319058829218721200150253909999303678357294756834116509540473774653285708580012040678220305249095247"
        "55276801766257221970590762794017791748046875e-226"},
    {0x1.b68e4ea5cf6b2p-748, chars_format::scientific, 574,
        "1."
        "1570396019147199951614746811927139404489382923242367733464441788630888078074734225096038097286016984649018"
        "1257751514645035556156464040606586912645807541608011134962746741848405681341004188686066346084883838015448"
        "7709392372278436106894714725168488891402256613958895568185934523280803785025487945761033682602426807961772"
        "9904564830592280904276028380829012893805188297596888949701179576800381646868176872342258629059497492830636"
        "3044703711795299868868306207209032360457765193935610352982502060997012346564833664746548695777890303893988"
        "73717443638753366030869074165821075439453125e-225"},
    {0x1.5954dfa1e8cfbp-747, chars_format::scientific, 574,
        "1."
        "8221726162720878219391559104158395374959669147213245613503896745402028338069685891693215118247249574470577"
        "5773632834069059255893405040677506968723179290673586481906516623729639441266599175307316096622687835586709"
        "2618728864713924727177719872204601194021364444558707639237904893406100689615370860293434227131712148405798"
        "9380802416798615537137977507699992247403662018950839836603506336485592101596794523530482290152376909489707"
        "0300591877272350060504222949064487781676187937692524103140075795400513362329702290145224825379126327590939"
        "69035679716483855372644029557704925537109375e-225"},
    {0x1.63b19116eb98bp-746, chars_format::scientific, 573,
        "3."
        "7536981380660995920317409206965536403197907919708438483243207276046259780782636795750670960498823863331556"
        "4361973497515074649074065367912595029978418187255189561165849485222600093847343956329389558975557559433994"
        "5426797526359625422480751140301019400455902701141973071402070186685863946369415699476975609655342242607715"
        "4175594829868582239458210962130867456517266283551635612083202636192488879561782024006010046525100412652755"
        "5170158684805557278505285667702165065594214305077880047427292259582451470534124011087495426670029856086065"
        "4499549138307656903634779155254364013671875e-225"},
    {0x1.5ee917be76e59p-745, chars_format::scientific, 572,
        "7."
        "4064424298983799758409921962326965702801554143551704944707467008311784842257503029702562542519306298330314"
        "1981194326469369362196400053024258377938098669978555830397634582317243369415958205231282129633947664312153"
        "1976378191602362283805188798654196420950991548470132438346982289817929616927653810036882833861429456852197"
        "0713465987069320473011773610399506362043394265338556489274108520861453579183080406614208415614734431946343"
        "5152942179725876432292383499756386727340433786992675333060737024142305637908247415113277343120253686591211"
        "890466457390402865712530910968780517578125e-225"},
    {0x1.6a83518d3d07bp-744, chars_format::scientific, 572,
        "1."
        "5302655517853281865519088036641672349453364010152362760912937487442751067960308155681513204043060353114011"
        "9169719954301232130009138770629329047623431367136583488292739563960649306317491883315147232877811185355163"
        "8370183466073023350414179430653267818383940598863187341144619169938988058504946188990166111689037141174841"
        "9049310873563085132522363302203246396131818560894282203919762752828801213801660943168347443587721221760182"
        "4120899083102402432899611516052729144447370268452974713939382192826509551728150820699522893409931803161412"
        "415537068199000714230351150035858154296875e-224"},
    {0x1.82e119223c726p-743, chars_format::scientific, 570,
        "3."
        "2662448520856141582359969116197647314758219008736296797176525214401520867340405444019626396002597772252866"
        "3186968836682916017000501882086507974134707585824404879354484989379169992763394149298116714053649735117003"
        "4620473951673976632347333736927399827635100863212403303690831363747883357719095736646178466990610801108914"
        "5100688546861344607708883052424869986261801888046350637846415147864801751679914776550653014890427156042126"
        "5143357707928115720602473152213992952494569908513824173282587811025445448262815293110163847537687712297826"
        "2757424516848914208821952342987060546875e-224"},
    {0x1.9511005e0a3dfp-742, chars_format::scientific, 570,
        "6."
        "8395808072043960437946888615913144022818684597480409139416604854902806048015891947817642973494886224589391"
        "7947413915725902749084228620358340824715778220783690279558522472606442707272495233483210036215958136787138"
        "4747045125219246721474379386766703417334122219654531636577160208810229335271405672744950103125127528872400"
        "9435300708255534437191306099867781740609566530007646264293977991206060866325869748017718453607135207160818"
        "6568842594609317420574039197696219126111789580806886704377222403255162694449756479070580400807826281677544"
        "8607042875437400653026998043060302734375e-224"},
    {0x1.576318beef5dap-741, chars_format::scientific, 569,
        "1."
        "1596240640257126022580763758808333956544914575696812877152686057979427423806170124631043143735351202411969"
        "4363662457652244105630058142241979306591818240376577457661966478951484782536939435778999430258151174735559"
        "5089966426087501178358421511195473450370805053307045519754477962046904488712634815387123346504771003022944"
        "2722753411960100534791965680527445943153570370446261605271101412760296271908054669579741086604944255251851"
        "3374006349826604238537903375962608496582299588287827376733567575702244649391501104268570722067296520471808"
        "840557770281520788557827472686767578125e-223"},
    {0x1.3c835681df4d7p-740, chars_format::scientific, 569,
        "2."
        "1377398290102081642547105998237554930329666933658618760594961639445573510652955157391280972437083853672039"
        "8540998941814233984546474450984876341146695082690204736204153091292361713610538283246285375156970891488936"
        "4657721411115003246578851078377498053405000389321952672989234337447900215597922146055742073876247357396257"
        "9358521690424567183406689386488112127694739315104861479151904980569027263874934181377723991907538689472357"
        "1747205612378221487781918539268552325445912516413672019263037175191424832565863233869284296762895038863071"
        "250911929155336110852658748626708984375e-223"},
    {0x1.7d9de55918ba2p-739, chars_format::scientific, 567,
        "5."
        "1549054346354190045728099178612284242864048592546973638605764909752084453816898814444030014754736745717415"
        "3939513681086581225782028757920689989789619947673798544076608371701340543491069008762335362774759252282519"
        "9064650634747881447163611830016466349492795111878424263081300113733758864911137921755019812391457219469952"
        "2018826787081963786228915530507044987879833529533084057706702139312734830970335891638672616232082242460176"
        "6946182748458144665440232215693253443416551663932895618598752645643856647100005740868843057170269018277958"
        "2617200730965123511850833892822265625e-223"},
    {0x1.2414b43111a27p-738, chars_format::scientific, 567,
        "7."
        "8908966429612138761442053410825010841147511936821955177458713457438198805466271838051424678765828645719939"
        "8716167726634748358732992726254088667359542908405506833271333150314097274575986309942361703879329062363600"
        "8556508006663024226238472910535467867270836577618155340121918980941880199608993074855517174397941766797943"
        "3257699387199457655420176793846119930278466362457725082492520846136072700371070220886045238515771099913835"
        "3273919581839928751011974288119291623295782179106535018353071051530918600909349102146773770371535343306351"
        "7396561792338616214692592620849609375e-223"},
    {0x1.c124cfe4c459ep-737, chars_format::scientific, 566,
        "2."
        "4268259861629554096961607208386164396338924587886253098651453550140391339378844998393460288990930432820913"
        "5852605544145260297178418009195622867007636059040404647511674582759252082159463333924946122636209365307724"
        "0977873157795898832579503773541214993031434002947123764437546804261294178223949649858284233282072275776984"
        "8867766962872304329173251511142705953025211517869429174767445738885776946304025525607550282127555871896204"
        "6723786844906946927224287601746539109080079061293230280772642604110267497185547395959062910204359782805061"
        "396260271067149005830287933349609375e-222"},
    {0x1.db6ca39d80d3bp-736, chars_format::scientific, 566,
        "5."
        "1376518013281176581393767003881692452539216189638454082513861671056344330553488898982859915462604752562071"
        "3194858456483355295843937655229752763352932747821261035645606743918047613597052911193054514507809178873973"
        "8860992102826623263280195239978630705630377197171290709976656635856120178304492299111334031785584645526739"
        "6623011402146431073232036141359852328057576136808206313364418877233034792328694524368872457314118573580202"
        "7632133284215709838404948187667872353512508935047651023146817004887328668815745386660026858747409429610530"
        "917642563508707098662853240966796875e-222"},
    {0x1.2c644921df46cp-735, chars_format::scientific, 563,
        "6."
        "4923393123279893973798124975067957683661821055302531079268770502420049095140983455228370658848833305956119"
        "7328682798229063527454145383194037041466250579724775714844050640734797607497023266424826652646549956059872"
        "0122438324703282326440711764504014832126567471117309554888078096114310082094633910668580186775907732763117"
        "1603679876938544156082643007574401942740559623623544623788327531808322409634703611830824020277630688513162"
        "5921709679724265116094709949553901139341687598482559954476240751055168594273882198683993792029021073497485"
        "616599078639410436153411865234375e-222"},
    {0x1.6bd13122dbaecp-734, chars_format::scientific, 563,
        "1."
        "5726294053843144363681777730802477936874597299084010995107628966567384953622503257042435468958025681768951"
        "4556296506682508635691790408230988645053782874328147548076915865073026467921875301752650598198704321811945"
        "3256217150144733715978427901629387459284666143864869306007500181496611203249610419580016413429528044973803"
        "0498260886817981140598424248086555342030238604672222152498165969915199735649857611225997848420675936268197"
        "6604047511921835077849991651550299984928801347440824803576874096605998398187416862946416525739844020914670"
        "608135565998964011669158935546875e-221"},
    {0x1.287892a1444f4p-733, chars_format::scientific, 562,
        "2."
        "5630401696102993478539054633433987502198527063819861595789767934541667125215787275857810993033871291977652"
        "7357557274968367720569106246135522165132339121000037669478455657996670633099125384048964216917608128715393"
        "5906807676638979861995899482434722854021681551266558689523039027804336232103222151597704699482237992239166"
        "0359274271916002455343495552557398005709744430276564223663170930770139608062610354384149949188616132053843"
        "2032766932551477934507877337828248379260954800678355110576711200666093855448294052836140256287434172066674"
        "87562299356795847415924072265625e-221"},
    {0x1.b57a6911074d3p-732, chars_format::scientific, 563,
        "7."
        "5641405712977867210175274043088388783420867275149767322122351434047338374177936253438028204899302356962837"
        "0488523999137071089542042803849243123833082314485877867503612078844280060492941395300769301050477461083884"
        "4771708168843517945782166786778563721827463933958843025588740107399532386823702651549747742355276118694133"
        "6160543862549988839807751895579998772653688325470326107232963792745930375230680670041063232822687276267356"
        "9564881628548880660380868326841031190637588018517873017028771871603303484157541767382497748122591012254201"
        "103814921225421130657196044921875e-221"},
    {0x1.c6dd472003239p-731, chars_format::scientific, 563,
        "1."
        "5729507340845360691172961950552389472595381927177044158053486244001384093120472450655528827917252656828986"
        "4216611421173869718771305470695584254626336167914579072549868149824208386320969543895385031322917376889944"
        "7230105143157394883461683090195494454277831621323498297629020214235087735116688238005071860004717990435749"
        "0609359649320526641329699019669238016740369020731988890670133234059565100213750710244133154401228977080320"
        "5276992871702817661919812277763853056745348801031263010975075959504586828496545179759104529564690995446785"
        "137801271048374474048614501953125e-220"},
    {0x1.d8d511e371cedp-730, chars_format::scientific, 562,
        "3."
        "2701700758416348890173944451402027003733394142827984966197329168489787891030628871564620161154472920441976"
        "6307611657940026085950139753419063816685006534077373432881969780274053777402989565349198574634732026976514"
        "3503255254357620386504234408609488451270885440695994276651147053203891254558854795233618129556019768983064"
        "0184701664660375714893506854424496235149299558008859536198192378392345711490047852485737157747848891480215"
        "0630607439567831179019341191103700093381913366407539928796967549450157323322682232329438392219632739110757"
        "31348319095559418201446533203125e-220"},
    {0x1.124f0a5bff47fp-729, chars_format::scientific, 561,
        "3."
        "7943104300103846907465125718962807644452544067635609245252515780846857398156326074983345152492123344644782"
        "1885437295835467826221176433927630707683821690003074953611689959684984404544763811290392050828423812284286"
        "7366414367667191706792193414168278284604872591203010012649027975022160519975882018294860956880832296313536"
        "7584518805465684770614223278321761156339523325948618400016289310007069346377405273846598794682971919776451"
        "3811423318034585497341869887347777030479661972259914559435182043273955731705789607524360400575124535604842"
        "8902795421890914440155029296875e-220"},
    {0x1.04cfd796f792fp-728, chars_format::scientific, 560,
        "7."
        "2152364285788005379377524795979174964552660715900699704053929992547268233990189269000176177971746118345250"
        "6890531596087448200502671823360487351976610446845342947428207102346678631846396319052254600166448960949818"
        "6500465974675840014654365386862246582628238623047987966821810242214677090011418517167697893840061749072186"
        "3813117391739117779902599709017270299269508886378624385770036071380417341488142510535238002530826361679656"
        "4133325313357389734835576150072007476083226753697027000461059379961318619180529733097450138953020404297689"
        "083250588737428188323974609375e-220"},
    {0x1.dad5c3f1c8083p-727, chars_format::scientific, 560,
        "2."
        "6272169024527131679324702550410633379720544552442983857477309996825839785642672113952228338812997232757040"
        "3797174621153077818446075620602878393510121524818246548823801693833402030540125548686331399867214868694778"
        "4260560502252535561694789091997233504905922513669597935518961163028798881022064346029907879394780909043154"
        "6510688244717805991877047303956839696222139417136531025243815182537858993807034353276986207761918342522761"
        "4300384259833292804793092625070317127312066146987547947564826452153651186093453320258026285872153537948037"
        "183014093898236751556396484375e-219"},
    {0x1.c10f6676ee08fp-726, chars_format::scientific, 559,
        "4."
        "9692140757055039685842047867803507007965064813391203944533935860055513779002006825977512730737397856713792"
        "6521109400378936101134773568989454265111600307864836389445565543201080839068439167059749047437910051659606"
        "4625090341000441213521055191798235088826104555942477721851467019646047257372488602165144957533569983171669"
        "7266729296749078146706981079609212540351242271637174021478319280589008464239239745801817192984144557569294"
        "7272035641528057138305985529303378800935731596276356114916201308852708295081464082330730116848424571251996"
        "43996893428266048431396484375e-219"},
    {0x1.09d1c057f71b1p-725, chars_format::scientific, 558,
        "5."
        "8830122891423099384974225173148494713081864421101162087417346023157060407226954996657527710036574230300777"
        "8228849597449568302036718302194461244246668661412782472746574338449486220048071223852647745826445147658614"
        "4430653128313524882251162242029169684145131727237899353273750494174098311927424774952874365921338158977154"
        "6065750542832073408942424875590605836275787577900142528431793301587988020156120572901113235812687331457996"
        "1154642175089610096423965852398002114518436398455397841740576752460394155163561730458765986363084410371016"
        "0197806544601917266845703125e-219"},
    {0x1.4d15da31c76d7p-724, chars_format::scientific, 558,
        "1."
        "4743436359705466669425597004321834607160275202191708101647359884779278816000005465530348819209779595146819"
        "3274657326555527683528423165521075539607371822078683349867541347863453219805292318913772267021247819793992"
        "0891478945700675670578997649636833850295033438465261262013370652846731723982875478958167012077393670206969"
        "0600361602022159246479474998393004303980486125738995295279594477648650045806279857474029772106803426533603"
        "8275194781950606208085012372213473554552613880716866570935356126307329100842696616070606264233683324604839"
        "9814753793179988861083984375e-218"},
    {0x1.88eb0dbcf442ap-723, chars_format::scientific, 556,
        "3."
        "4783661139951836659834650869398120825446263038654374830389179725779207115608018307232395526906385987088082"
        "4300939458172670455150508058822235267367986041627005790042997377904752045570140208853566396039690367647975"
        "8706671069406990269746660238927428872711018746481991387760562749230806116297403149718889702098837849022025"
        "5913529791938285558143796317931984839907097658936340062828470837435597321113430649553015925929159557163989"
        "7200311940047402536426101840440670659097350647474752106036851970713051703441768301934192532745560022533481"
        "96973092854022979736328125e-218"},
    {0x1.4855037984a9fp-722, chars_format::scientific, 556,
        "5."
        "8132163840225073067103367504949528996314796226487824120028997327955421486231049647242313211271414237877849"
        "6575931983419043299641654638440132125481074183643823625939890917321998087428065303811935078982220060216703"
        "3080320155151816220164993979839757227461089845910506971715485581225714522454629832571060428488951781247009"
        "7151684577794782847430343609839366343499101500085822887900487908381027204874540283621144246564638885440392"
        "9804648678499580352812183946211325003975603679026913411470755820684245890767411404683725822603590493997671"
        "72872088849544525146484375e-218"},
    {0x1.9bdf4fb46cd50p-721, chars_format::scientific, 552,
        "1."
        "4584641434878504465497720362417662180955274726977105761716287781409371922551725296330598498660010627062041"
        "4109901686131526983419367027803870618372028238406674358525350147445594176436041882093323966634786798353743"
        "0948325547099905606010669434778234784583536242970120916339292852416310909963648082888736027543685653844861"
        "3952710301010589710537711722090325475348344984737385438871422926542463279581236916939059511106840811631424"
        "9538880185435710253794201340101487723780500252093742594419319926143493063899916744598998091797525944457447"
        "6219713687896728515625e-217"},
    {0x1.5226e4ee6e982p-720, chars_format::scientific, 554,
        "2."
        "3948318645722383698596132966002861356262867738431677803939697357779251148165688995352120160627222611575929"
        "9689826700992662030416378730689248077616852136705267786161545096222007215990088839119646235536279253476934"
        "9003551732144440707467704087139749385796202008451363169785499180779157968872915037551550990021449529891812"
        "5517183603560498907759526081213279162400316981058258462632041089918690774422656232572587897271295319785406"
        "4812435396373595099397773524674835098025684827649463758892584301435835947832788841887802396002360438842515"
        "577562153339385986328125e-217"},
    {0x1.b6eda5fbd10c5p-719, chars_format::scientific, 554,
        "6."
        "2170841982723338730702402774174581104079444355770645227799441152140990179937180891783242637499954374597087"
        "3008464662250243986006844228667869882594430102531078175913907335687966432831398569868860162052899262109384"
        "5883473398478959234838688550011663002757229956068858414758150089312638851089337799986122131137270728206083"
        "2893291385031591432573726834519044254175548566041758328320909158474462834862032394036782743365444459136656"
        "4824457589210171975436779113469419212320975164890670393225444447157944180323651986618178379162547031455687"
        "829293310642242431640625e-217"},
    {0x1.ab54a9970b491p-718, chars_format::scientific, 554,
        "1."
        "2105626076543997255531329501726923857588877013053286207541994102509381369451991729752658885355274540690355"
        "5024928460084443639809967630734347791425042367511569366398014451637268244225964319453806479955920246917322"
        "4725157361024728582311997914670812221434452861298531071639274681709795071912599059726607128925012726609172"
        "1796505804854529742126200406823478966258730629381222482927094750078171044839460480027612836177749536420318"
        "6481127306920043772287163277386036128721081549056499440748286378438450585143025905904301010862500476150671"
        "602226793766021728515625e-216"},
    {0x1.e52475ef13116p-717, chars_format::scientific, 552,
        "2."
        "7486687055906062577881540001431501496575123590678476529391262404690426983095262500085467262333027891722830"
        "9369613395301844882547555622556829703655868321121356990562366845714786526091127616873916492482916608026871"
        "7602849506400147401598589825990533520239405794744626858577327624634743462392529663276150233619312212816854"
        "9072964925682415315626227428381800235264458800518729103506057993613643332214275142683792589021523962328572"
        "9865420017710938892453157987835329199562430315689174276210015076968788768203356014704474147292145858045842"
        "0328795909881591796875e-216"},
    {0x1.351edff72489dp-716, chars_format::scientific, 552,
        "3."
        "5027657450499662471757545735089001918731485641097980290576178547757495509249093266284554696367026278492810"
        "0147173830738518713645420310526648989877752676392141828172888665979441700520145529662902345885785383753539"
        "1376370469690434685885587545230474222594249760620632271040847695338529030730762570328772853749408787613766"
        "8270604712743772537998893069321436302826336423836895233476630313955731119058149690419864151407171234861512"
        "8474122750522428045014018099803822512938181757888309118095505239530365123035368002575324491987274200255342"
        "2935307025909423828125e-216"},
    {0x1.9d894421705e4p-715, chars_format::scientific, 549,
        "9."
        "3718787940821138640143238528704947331582272378326109901966018120838594360065413663088557482229251218067569"
        "2371300339797039083262347018707985682314341168037040952899218264275877516637512478504333541208945387730294"
        "8788479526657955342331154879371913354353728215275083747527094608785656520445709279082581079933935684375053"
        "7970732376976367986120404826719685528839665031396276263448812459785233011630612074800352768861034195271243"
        "4605308321679121688893108324785422380802302551469557739581220727134268270817100629239276843307493436441291"
        "1236286163330078125e-216"},
    {0x1.e5b92a8e62631p-714, chars_format::scientific, 551,
        "2."
        "2015678401956501509913015563202673349273994830102214878621064509890592629710942073381394734079571892066071"
        "7487730292989115288528305280638727413962106934831869139267022072217246445392935266135588703131037280675127"
        "9330987296821526480487767504365898637613452426541908791360526539551414732583564950686053667485060220450589"
        "9377266646047617280040514279127012951123130564005585555626870345590497806540537552635681909822254316423847"
        "6156766516279219677862865539783026980640293512478470347104263432506258267583226624305482721499771514572785"
        "235941410064697265625e-215"},
    {0x1.5145b770bd17bp-713, chars_format::scientific, 550,
        "3."
        "0574111115052798755704223370355788580585808691529488807936764944992602196499942092750844854714155848637597"
        "6497130637186256919022738489601122933480405757980718915295656524814620284490229794811067698027804710242913"
        "0376602599274637302539181859471723845759904668345426627291624744410958365438947344354893144388403260841879"
        "1325650128517766244303228585118902873034286845844905346105029784310865178592908660838937112931288536138630"
        "6009764825661633654047990831795098362102506534239404342245751501345683352411639527096073876144544101407518"
        "61035823822021484375e-215"},
    {0x1.285ec117f96cdp-712, chars_format::scientific, 549,
        "5."
        "3732563210682168420160693837490128172921363352811330680377129309428579320206596965611505276898569179318064"
        "7093390822649793019079985569694858841420483773418054150208979227588072543018999060176454825188719716750266"
        "1464925503548223182782469269863121025084723548092520888452073422375220993719096473946649034335302943612161"
        "3096677012827332884190800037895188734464273611331722229788010640188364868864193380798439305695257683444830"
        "2578304119397235029009490306081909908983761213174092123799691360182549197602745922903305642037707912095356"
        "7326068878173828125e-215"},
    {0x1.1e8cb1b784211p-711, chars_format::scientific, 549,
        "1."
        "0390415242853728816041217572591158422222247006803021323666432451437875045999340376240492922325054882674552"
        "7408607706487609351627677616440371363336671781330254328137763364074729743139935129859512507832805869472312"
        "6339297623061284057853330414173406542547210083549372626832453025030820018846792813026550288561349826779134"
        "9277277621847116668163955578302733989002925493494555577398661411420940027588717214435232462267698247622369"
        "0888792643168096799257646791531616954197624569093221460530831327866723955961876871018773060839635036245454"
        "1027545928955078125e-214"},
    {0x1.614c26f94db72p-710, chars_format::scientific, 547,
        "2."
        "5621446229095083155702111829323711502594107915197651192397683293270975877689437093976421160394334140860514"
        "3508654306899631700199453849808488956890026352075766904074073805277078860674472639414882982434752290186285"
        "7504465252020208455116434356283038730965714616498666771546909185959002909855327970887019228977304196897290"
        "1944724658400811662637824393687273273295100029361142051970122838752977899584677183241852846360865547995966"
        "6687843860920406095408137347378557822727582591951003279152824322080606068595729331652255389428773924009874"
        "46308135986328125e-214"},
    {0x1.cb0371a5199dcp-709, chars_format::scientific, 545,
        "6."
        "6576126403697076608882696856128986307080116494217692992548764570798174913048894445931404315822786110091829"
        "6649348687901768437850106811170410660836029465125717942313828125061569507507709085499361748389979318407375"
        "7272184536689291808393520451326509862470686467487625232638447718595087340927786472243230843937796297226695"
        "3842878096505666768374797711233029598166668335444663888730788648119384576217082726860978665043128401209712"
        "9547423798181108350450372658894135422090442624951810200919587095679400509616314811356385661156309652142226"
        "696014404296875e-214"},
    {0x1.5c0c6be27bdbdp-708, chars_format::scientific, 547,
        "1."
        "0096315129023046456467927747886062404829941065542894028799876798238419315163636763041967115486534078158780"
        "3792746626275267505476475853627997814869597841933589181384945321349031280264494810636851886988579388341166"
        "1080080357956361471549802945541738879096317122362902737135301247488849687812997256313209104551730147943627"
        "9917883447751656421134845380154896344888378922177548945568579291932819057367458807794924092411351316038054"
        "7290591838918031503312280507777151643810289962815833121504010394331494282721910617575677981960780016379430"
        "89008331298828125e-213"},
    {0x1.9b18dabf10f4fp-707, chars_format::scientific, 546,
        "2."
        "3850500688279488736069088312896597807712501153938563573110116042391645632737275531425873467863538337130966"
        "7891010427975650224937133559719351401006461226265549956373571669015855704039359014374848412483435923712895"
        "4250186816972181807777308389417398269916805254701545926256463106859217585143569273237619388976344522803930"
        "4203567895064463853141388798875624607003998797915225340849743889366284235720427859685783218868506557926674"
        "1580214199554455933843367880842257560684391957709515003912459582292372011308966266857067850537532649468630"
        "5522918701171875e-213"},
    {0x1.a3e82b920dbbcp-706, chars_format::scientific, 543,
        "4."
        "8723235743335383007316942037138333939727876640397027548637587311727725444457866859726981985910149027071370"
        "6468340207283669307155333779520424052725448086908738353241626783050347648634151847564260366778472261414833"
        "2613564491961095108182457631457759132936579947589807479206304597712222245032642246469025898682295077537797"
        "9074763121811936361499537945776887634577317313987291053433221818981193498354026091626856226453756264612039"
        "3754530427037991319234814470049958889326819291611453036550148575437432122510385962277368321338144596666097"
        "6409912109375e-213"},
    {0x1.e55d4e34997edp-705, chars_format::scientific, 545,
        "1."
        "1263700063301883961637593345853650848173698173906203553947316800214949500052155115279306618384733383355823"
        "9012593269879463412835243497329655831225472435522686519182378700969305497526912686191024754645697306870198"
        "7762145427468664520014456587758418342960524150909771188685359678729708491944850185052337045874514571952057"
        "4137475072159689914997940459086273680774009478900069713199343055246913368028437896195004050375544491283694"
        "1746714816416655581946140115510899932593584992390168732897366379179420338335127806106417125420193769969046"
        "115875244140625e-212"},
    {0x1.82443127bdb92p-704, chars_format::scientific, 543,
        "1."
        "7927923533931952950586931510282749592790453715109808832297352620022802755310066252394361312560633056624429"
        "8444201320939750950080181045198894675756701860610234013571800216193558312750617204334599296344409701776745"
        "5629192373004068874618729305040214979501665418511156657769937991179760363455405882943393933388417275007027"
        "9238392034119581576347126335201240604873503387124270592794021386497103267133076944317349877812852252494116"
        "1179202904954465216073197261130107718452951168115991671745272658875064850016612522098924387137230951339006"
        "4239501953125e-212"},
    {0x1.c3ddc4e626843p-703, chars_format::scientific, 543,
        "4."
        "1945272696274143506064751591019143690519608938330793458941131430315420967011543669286107587304069881291831"
        "6032656187170995340885670400984520535211128358722668170887203873605927186042732064909372141468474051452393"
        "3678415858455418832312297913362303042355926367090313440035220453662023511344211217569805253299537764581623"
        "9298412580286410353907497125866517188536279462904565662754642482258294680343001078696867682334679872718368"
        "0479454352306477125153503393953171166192097258701941353102439406321508295406082916789713976868370082229375"
        "8392333984375e-212"},
    {0x1.85179680c1b94p-702, chars_format::scientific, 540,
        "7."
        "2236307258538304887715568455167838293359876919019126748017947977725350522616163447033071439365285720056989"
        "1830461200043803436029630915487962565111962873028113557121533529866936632303307488823207702072296748481648"
        "3207014721774399563123795598496459219700635915793195213974388269457089126242058992162724467598411268911353"
        "5041058088826843891771253918599206993317190354583185164130892272323989170581794237052458129973574375453130"
        "8094598405624524073068109367799283444890475986358854047759977156130022709224630661495325512078125029802322"
        "3876953125e-212"},
    {0x1.03abb48e8728dp-701, chars_format::scientific, 541,
        "9."
        "6417543570694105910088319847436003732314160404928095487625173156883373210396589866754925983282318468734151"
        "4860626102306640936393564625714042933596543888017233328739922582864914111709598516057698962957292905855399"
        "0934567441164734848774927916780969315595016517054297439820165043351563820924614514119398727275481604029996"
        "0756386042271669947379377208367499428338782010383566943029832407667528711616577681695535866646659071647091"
        "4123908388130256787445397850940448407274826997829338472227774193835039834169289840737349095434183254837989"
        "80712890625e-212"},
    {0x1.79d5b387ff6e1p-700, chars_format::scientific, 541,
        "2."
        "8058534999670358996633679682617510657197520464930955705056307782763303148434523913703200877980345442582067"
        "4486691061078409468449240314443515147593774451511192439041146470049754857277557200825953109839924060422472"
        "5351798824855369573419311576039958119981039707226303862508802136483934658223688603762220164216055731622818"
        "9010355568985916250984833862564859204793321703030409451231964242558722126734054399784848841245168962609624"
        "2173140130434703254320898457436036968768953024903954353705239159040468922704306131699070192553335800766944"
        "88525390625e-211"},
    {0x1.f9a36c542f98ap-699, chars_format::scientific, 539,
        "7."
        "5098815942701431264042911004176988103520194201365702934373413006724432292697433861353923851217255084766983"
        "6599886630527602489344121303782618389277881882670799795601764912090432524174366596031421997948061932162102"
        "3117734679986634642030304403759434983992681398802899425054501200452186621488202264269552010067268804359334"
        "1738127090236808055131909220403452002271755020123581692062574392122588359572183090485242498908330249497151"
        "1253704899077164433785232677029233050564661707197414749244240081859608324128807499420190652017481625080108"
        "642578125e-211"},
    {0x1.dcc43228552e1p-698, chars_format::scientific, 540,
        "1."
        "4162133808983744258886960127739256541973507395750856304999796672802119573692833361419165044069472916119768"
        "2626134172668197351710112526943632551376973400614773690079165656484698046811087576617553125730497832111644"
        "9781456794745739819723112960798249196264114657578024943397007196103135600134960687383208140764370034939725"
        "6333481638144816073339075261783865664048692839880337281432279537203733127391385250064522871588966853314004"
        "6779946169294976195251626252015124492655057417910144823152616491496420608135059504562036636343691498041152"
        "9541015625e-210"},
    {0x1.d0b8e4fa0662dp-697, chars_format::scientific, 539,
        "2."
        "7608735580016018810532251366986066427701731560219460946383276544412397502773716043763024013333758381762491"
        "2766591900986052852630094841182135458765270892661477506362963745598227260101624863784743478641335048748703"
        "8347358590002100584791242861223336881162576985051154343250452765979930861239511263072723698300020976430933"
        "4957108997036962159641594598842541302828078543085854370441114036051976116492434546275183049970630689903281"
        "9114395235094129047761582275001321029896541652183422416686914671450455067459872626756123281666077673435211"
        "181640625e-210"},
    {0x1.b8f44bdf82c3bp-696, chars_format::scientific, 538,
        "5."
        "2393404251407047567474899294317887937950423337622470825030283559680483919109740585087289336722256687375700"
        "0562612150372259732590220204200981462672070447082476439023788329111668015810993854242609354608168841001197"
        "5721911366783257993585749567931267566346598996672644920149221841635228584772963688239938336655237227386206"
        "8491342840831866257649196363752331752920763018118631801890578071444865477033486159660377821557266936722920"
        "3653830659767569868274491572483668536449410976001011211353130518765763802210844168882886151550337672233581"
        "54296875e-210"},
    {0x1.f859c249f388dp-695, chars_format::scientific, 538,
        "1."
        "1985208897227798591039255948760211295972666003794523598898895366020833219755267124170139715038638699952937"
        "4329645641469104729428750120637526367360593775039076317110708918658483802996513415675328247462305935532785"
        "3345693077234597796127995527491563794867569650848921446775522592734337766008213264400815397407021420615343"
        "1176922528484394185175495700629128401173269414579032286321428360062399315349631550183174906062438748159785"
        "8516867445804419504747204630742763446810820288164538437931161379214648832550182966372176451841369271278381"
        "34765625e-209"},
    {0x1.76c3cf6d25fe8p-694, chars_format::scientific, 534,
        "1."
        "7811558999586523701977647593653910305007237069848717168449377479088923371990969176642927894674055304613438"
        "5672757693904280120418869003651550514604809425577325849506851929562524269723511223669099656493330621079242"
        "8428532458822479610900457972964267869820261321558949972877826760738857749922382498268945857045773232228967"
        "8217862435840327482891491017196268320347469034697494415172295492230087479206891090890393696595327575030145"
        "6994053947741352652623430920429779814837285839361266979135427518008642083779946574395580682903528213500976"
        "5625e-209"},
    {0x1.b9755a541518dp-693, chars_format::scientific, 536,
        "4."
        "1962642963537321076602226972991351491104742192225758657473795663642271950965237649181687944784531856492724"
        "8565355071455733746569152196344022113027036138256316024271384693248884883018412271913955944148702408979980"
        "0598227265908537135628614882879304623430375054715224577326792297458415887012265235615755629258591793791972"
        "1642684984061588604707508785500264498166000046974354417486291970140109533598016391655783942366698854204024"
        "2341326597783970853680579332068366495230471063766360766930156215738360360456571385157076292671263217926025"
        "390625e-209"},
    {0x1.f9c57cc980773p-692, chars_format::scientific, 535,
        "9."
        "6151781021743031816511544979411331543689547428158611066559215048652158551199908498702146817365187884427510"
        "2350184914401779293504720175219084860292010793608864288357348223601530554819113162490280742714226103002168"
        "4787171977026814222128547887762200230029015250967853285838300682440492056232862759485418693647725985578269"
        "1550194921251369678834994115687793640049054121013242722791010216905285005198355969738557592934334727596160"
        "2106476021831384121674402994034324448547614929792406649935288203665277248499698714567784918472170829772949"
        "21875e-209"},
    {0x1.e4a6ad7e5cfc6p-691, chars_format::scientific, 534,
        "1."
        "8427321798270691931419529256184313716571973690089230501201213024968691169451064054203767633648839365337058"
        "9959392624389463429096165611132917690021295878986853446245457921782248607739873408176038083804939583706995"
        "0654397880772093066305522988989510818550541148687265521818289398962787230883040650157422886214071659687864"
        "3792754837833575353871758489957381015893355378481232127208667013672716372137306883068549817908551789512733"
        "9316502913213462282092457461996729259367925729225844679795995907374116934418495361569512169808149337768554"
        "6875e-208"},
    {0x1.7f07a911528afp-690, chars_format::scientific, 534,
        "2."
        "9126998289538513112480448166551114592654020719347039834038759867260996999416181764018441153984388750809778"
        "0175629271501825790485883418229175243037382302172755297279108088469220160306070492618960031004834039173709"
        "4843896631120823118503330457284170724809216045678379076340848600459520650305058603045381131112866260428467"
        "6407593658543022863820181235359501241223422387971893606331689220550564750593432841072650225389271369147403"
        "5512661765215882184128685885148232309762780083810333437476996260755753714866145287487597670406103134155273"
        "4375e-208"},
    {0x1.2f7677b3b90c2p-689, chars_format::scientific, 532,
        "4."
        "6152840107250803974346147876459468792499531906015218999353543308743048639273421787001944283505171919058319"
        "8144255365651071365678271599484595358357673877795342194463858767642709308320670009187206082826373037562838"
        "5820261005469798564184709286723729385073245071251176864233114190345074392110857638137153854209350977844546"
        "6239189605282520378949050856283020490336290298380676951122376139656287149424509011548673735977675085494428"
        "4169319003497073383951870387582031016960451123529784253738775685058440267916068933118367567658424377441406"
        "25e-208"},
    {0x1.c96e22e0f49e0p-688, chars_format::scientific, 528,
        "1."
        "3913867725663096448636565841594072797239179967141265670015911796658179232356371330082615064109491014185571"
        "7852548486936144847167954972821760976259988719708497654837756844368594047016474258346086098675771802638328"
        "1517450488570140127406126304896613526413806573826761435555192929139460417688891661002342541921558364334502"
        "6424879420586382525190545149881043545710069777649964342012328828582070171780832398513896867752356832570177"
        "38989819696745189651711690480619467448362029039063335112658375929128862225070406566374003887176513671875e-"
        "207"},
    {0x1.22d28ade59d78p-687, chars_format::scientific, 529,
        "1."
        "7692162295985285274613328500102516630943365500476087310567181746961135254937482576801750221428295918086536"
        "3285468548760863155815912570868365060156998843371602515772361967652878837326101707102753470819861557367288"
        "3481713892386335979436052605905323135549877546295135146022879990274278167641463897483651103068687816673451"
        "5907500780062167799434488187226465946666108588036946480456968207077669688736279858958332805166846949099791"
        "588247445999167063696700086089680623439003509639588506091337715385447548754882518551312386989593505859375e"
        "-207"},
    {0x1.11c6046b7b121p-686, chars_format::scientific, 531,
        "3."
        "3309984084439476052884870790017880296080055634528788265015815316869436089527404130952395838719945250131986"
        "9730320728842084196597888023818389616975983226758975382992530982514820717966583153778807531118235599662188"
        "9597602340856152965036165428696464896332879564853822887552698906231145653313756449773063821682323652058481"
        "9547805275196402678496748808344099487927760988789865833706607909581306479099658359625457565668934621834351"
        "3757747548413425604442641719595489739459706804383826827911176430511291934877249332203064113855361938476562"
        "5e-207"},
    {0x1.198b1ed81b492p-685, chars_format::scientific, 529,
        "6."
        "8510701846894067422582475523370404378011418963303009769966838302347841714706482962267873687455961537128859"
        "9906207574662056939466225701661938852045145443629892554749935483888325578119293711819310924456525734183163"
        "6915472912399010879835032970087392517046341912957239003522427587484984610921827305673994149628011173396226"
        "3780525714752427605029016226469261556860836160984332674984228909414266256047184662690199519534155528347876"
        "034022294815245715147598466779192478520189164084980440014264351823725096579664750606752932071685791015625e"
        "-207"},
    {0x1.da6addabbbd1fp-684, chars_format::scientific, 530,
        "2."
        "3088921688496223736447698070618132190331861821537468965751360953523467964117030458093659711888679953431325"
        "6791383016641616913805533295082590105365577700220213661827891554176114291090426996418755045595031272391436"
        "5056337843282569335669119776810340847055881483383938852947141165661430884677477472557582460844244118662091"
        "7179971616485032181643293539463714565118379358749880808820996661168372725964919205188069147711554587345138"
        "9108133001777714280339866642455389931961554995216357284980538007966577307428224230534397065639495849609375"
        "e-206"},
    {0x1.d56a8fd15797dp-683, chars_format::scientific, 529,
        "4."
        "5691048306445641604873487344582286150036188199466936663762245861254367951253078053084337328657486501850324"
        "4639933585428847066193727231878618202759175994292635769866898199587603013635816698477200737836786434113051"
        "0572218930930147956667737444440711664958909309074610966569304085097304218562735090854035050636703161868796"
        "8928801205899327226333183208398450978715639442169140673197444986361607235881156993779171410174755922663555"
        "574675719765400978001502127488303683860400844254815568243693565432528291836433709249831736087799072265625e"
        "-206"},
    {0x1.f3aa6275d60fep-682, chars_format::scientific, 527,
        "9."
        "7270783116371221191762939854842941752679733416007252745486261609859880583198730913356445623264907215190864"
        "8560349300936337143532788944063699216212541764989243921159202999554308982439677599213591449347542999436251"
        "4845075367400598016897410898113328837764425820423149230175473845973261109374719277837435612064676023199513"
        "2475233045514061072806455531384785125604686392921739119523946853964894459653941721178135905207621152684004"
        "9022573637782547046925665674774262349927107727157916980699199453741510268400816130451858043670654296875e-"
        "206"},
    {0x1.0771405e2a869p-681, chars_format::scientific, 528,
        "1."
        "0256959546160606488726805315356855337658063975579249432725148357253870081722014642762758518975160176683096"
        "4808276510052018475391378929787195203544548808862085870952275388594930486183074992699706535882260315165688"
        "0892231031191155150934789100065019417689392678461684332352523612060746529016035174062783183041957589223796"
        "2611722543461090395136869252370957694533919461366539737366218664440312378620580551773284635761441384637008"
        "17283527981808733394394904977790897574079405672970002302133341216816564411828949232585728168487548828125e-"
        "205"},
    {0x1.ee86c40e3a880p-680, chars_format::scientific, 520,
        "3."
        "8508135367330314292296381359837063529186758232718527682702510581759040588871922777381914733711030542054411"
        "6504406319838169445218070711077138616618166877563823794260052689199619964193690292172702945639700832394191"
        "5328700138150745001949277117267453139446838790491763636519220242854305248572010509495178581545932452964994"
        "9108075855219014019756123543254738453324470847942263428819845634073838218187937116566664828909343554431079"
        "815240877180188791702678289624792713938430940614004939666348281690488875028677284717559814453125e-205"},
    {0x1.585a84931d29bp-679, chars_format::scientific, 526,
        "5."
        "3628739344977650941399396994664062909446794105596352721943281729728627450572873114769800695622557543189087"
        "6170408118377833454298924787139421021372070641261228862807374926415125351691951403510273975967747017495700"
        "6029397110551891149991745218172557472670307074649319964465385236521148916045120642010778039075647952239021"
        "2432361954484400227604278580711506847746818030711390963728533887728476714567950565229014485423029218375353"
        "750732081888124338330413581757188688331103832532131348029085481099453858178094378672540187835693359375e-"
        "205"},
    {0x1.7a49530caf5a8p-678, chars_format::scientific, 523,
        "1."
        "1782670406981829321748342170270093032401355879831618957954947784523973296396796916865369743006762277930095"
        "0567702062680043666952893020944559270149791677273250353005779342633235074698481516601654762622366900001635"
        "2281219998184870480772600739120486824490248828894700930458720074575576880726612790401491826496007397517867"
        "0647685837737977220505846996881709361842165075378521510676934361503017940903085360306384528629882989519304"
        "090767877812950822319769876550077524994542753523582646391944239727678223061957396566867828369140625e-204"},
    {0x1.3b2a42806488cp-677, chars_format::scientific, 523,
        "1."
        "9633198540986483775799261383979870216240862506382911577912309546688800104365843575901826331397993154616681"
        "2471280347835772651872541523676383736038356840857212840087851443915105283550968900875649801137459350855386"
        "5821482142774480083157679864221799425963658261456298178545244297451518724341603830296153018149068454475650"
        "8028506847600398711903974966533330036220169201991967451668704148602041768160661383832744400783773461300798"
        "358098723210470279803874144148526265154314849414816574238971946808618440627469681203365325927734375e-204"},
    {0x1.c83826db2d099p-676, chars_format::scientific, 524,
        "5."
        "6840339139060946981762684285710865654814425966664609557362410206095193210907436592806745280940604984084917"
        "3638712394538581010752596199682994606441641293311620399555882268983726840264501484788914059102776623643905"
        "2122858877029711702866367625234785883294752383576438575622547825433771433309812245628796339307339366141624"
        "8327266687372571881603606669105061926117522601057432280607513852894404333029087097387483751980844478298920"
        "2235197876029202131802937817666288074953338254840490731769654664251589792911545373499393463134765625e-"
        "204"},
    {0x1.ab36df94f8e93p-675, chars_format::scientific, 524,
        "1."
        "0645321758200814413322079175861714925420398312598654352133555760997816258375072365309746623458451602566928"
        "8892955587817123557658132010249725751416542814066399908321499983973004793509504161485004080347135156251003"
        "5442658249039229363606436055076672347113866815163628981036236168445495284717579960502642475861507919904976"
        "0415239301735078975625527410821978439898777022303097916766691649207535368545176326930298026323109512486224"
        "3828406557136280207205919064795260099278785611381060600944513383492306957123219035565853118896484375e-"
        "203"},
    {0x1.50471d0714b77p-674, chars_format::scientific, 523,
        "1."
        "6758731287663245067929802646359253751876178073393718529381383029991245143140589642891986998226638001813841"
        "1884571540760722831242178043882468016912989619180020502706117428233351747395942121515884241840494596513741"
        "3168379056082846586489400073062815260306226775250614217297608945528700853686763895314550239200685720351426"
        "9290032819751222225759992649072668129215176147377509677947335109118716015043007331011463548126614761292320"
        "640235481244469082541147893929952413974668845082847184134976215030832236152491532266139984130859375e-203"},
    {0x1.af855fc3c3b42p-673, chars_format::scientific, 521,
        "4."
        "3010538577728233744816436369978549136976645950673498532952391599320329530671325173016013614684923269901956"
        "0268052180793702299742913140983893922344975035501831505450412114109672135334397735251037816337885684958047"
        "3992723015478174654344760932744538761509098314194729572674808143340483916485684814524519684382188211579232"
        "2879301647036270532651278165887797562530738322949801980031349707060037709951853600603902434774229050505469"
        "0763471466516501229666796891561067299047712433489573159196839302609305377700366079807281494140625e-203"},
    {0x1.ad47ff12ec668p-672, chars_format::scientific, 518,
        "8."
        "5574595335115486808557631060044950010564116057553208117505835698979224270605230907269762845091732308470041"
        "2661175089528304438909809546901546014735177540676134332138472881953762100352137042313700018497337879496165"
        "9189580288095025616031282691409656494757870534052617087201115566268802280358798705227412553213249254918373"
        "1480193588714200446263056192475952356968184570908882976764095565692431171738149734334933275867032274731426"
        "4652633278520834947286422890756022706803482172043515997794660421504886471666395664215087890625e-203"},
    {0x1.2cde48f104883p-671, chars_format::scientific, 521,
        "1."
        "1995252022699291430772090009162585049509756433689356686849255866758337996064757995487412332217041915275396"
        "4502645220981501885133249216447042172461355588080996605721879177162634972981475480497356065079367468236338"
        "3237004497147886219100337958851778353767446944517197980739705022950728600049945132461920818493416267256795"
        "7907818111439963640990460062983183893943301010505311294044136435378077390399185184359595876312531247040973"
        "9561953852017096495437565634136727399479205502966257918494308309931284384219907224178314208984375e-202"},
    {0x1.946b82be44de8p-670, chars_format::scientific, 517,
        "3."
        "2247460965180460029537786395406798165049710692182337402826426147217110915625857896714231641153250293652179"
        "8048216973815754542961726075194872454516155016492934790014344438607116755383594469734469708786475281532119"
        "8632661073619619247275295413044208923754797487662014202281803328562662568942790221177840910386833830029037"
        "5416632087550289611906245010468012912803588788333467800241460580247976347907750916579605580990918756438712"
        "680014884999019899375412526120418451580793367541540907217356703995392308570444583892822265625e-202"},
    {0x1.4e2c914eb1616p-669, chars_format::scientific, 518,
        "5."
        "3292453195387590853998556300829021590225189208980014515926856740122155957485101726194890227274448168718106"
        "5927924279053206776354571063402558326010932660840917790876541357680066598140056129283600893403415124104507"
        "0961228748867478240688904822297467593907518308374935005892642075637132415584498144496749609150067413936743"
        "9954339942007959039524337809360913993203485623878501836329594368309888038663244905138395997368272478763961"
        "3141872635547279188040318374333051363586680061786428168335572053138093906454741954803466796875e-202"},
    {0x1.031a309da2912p-668, chars_format::scientific, 517,
        "8."
        "2640741741205575704886671257776920898830696348304845258875783028559751437157907478574887586455610818958574"
        "0117180728435510741583686422632774929222632147511918567229325831684032651922903276735266790117843593501601"
        "2515772658634021392622635795100871872629560992833058770828358801605333052744848692059467100573291501861921"
        "2965168501531832990733805673234966033806861779304385144732204173637508580888072780122033030001124800084442"
        "798088493409434384997049557284279503347774175966576788721074109389519435353577136993408203125e-202"},
    {0x1.a060575f96216p-667, chars_format::scientific, 517,
        "2."
        "6560666151344702603270112657977499843280481963854547007415424282841408834245148563080751707062214127712174"
        "6575089241378645724002796193936213328030191138196663527134590072339814022756945163490059566462430178303277"
        "1228244858625675383094839366484676870834540231014217479000886731065845109947279954974574188657815117614123"
        "3386435630286269060704468642455055794196959719254965002131476394999432110093478415169008939749380189172464"
        "419028229169215643606811336644663330285421791733774070365381447800245950929820537567138671875e-201"},
    {0x1.54ecbde19e11fp-666, chars_format::scientific, 517,
        "4."
        "3495214972934750530933724968222678819054125647445515129232273277394298473692482090246833126125365966736388"
        "2354688517832178150409693045033840944581780922681152100231430786789827130799202367673361512373001296052937"
        "0144885754098436449140938587128444015910802676078333389890644004297198057112836294886007788657922515419803"
        "4578833295918606774209296834570437196389294791061023161018923830592981622192484695052880013934282074495956"
        "590306105321231640691595930251310123645268261612767922430489164753453223966062068939208984375e-201"},
    {0x1.9b65bb5e316dbp-665, chars_format::scientific, 517,
        "1."
        "0497223657147530461540305772931267585053715061256250505487087888061029408785894563215220970697678764383480"
        "0325939065916205702309557577375277159458987036426427633182733447713021968370263145361858036928289137615212"
        "7401495504331960559979975536391905723334450553852881134362068216711904999364434749875519041157852477294908"
        "2822453778469194141465743679238160144163995956438907303935779751926152780243481780495784919204856732854249"
        "500399151396209309650004291796200412761177808216423411324935699440175085328519344329833984375e-200"},
    {0x1.9d9f0bdc97dd1p-664, chars_format::scientific, 516,
        "2."
        "1107936672284170528945594825984539537267894560074842735445651564636232548380045553302817073544554452002495"
        "3381174620534078658991556593400119244710172233781404038272600835408871699423495545285788169382119890019819"
        "4201664584882960325446094595491519667713215219785422905110363553929458253876328347995783978350150958928634"
        "4404234645121978246820592353953489916252647358865343115582584946414230154135689901732367690272225496245117"
        "49407430127543500008710404569387590416050499587800361178668850925532751716673374176025390625e-200"},
    {0x1.93eb2c4f59fa4p-663, chars_format::scientific, 513,
        "4."
        "1225583388333102048516138791115797958837443685538615330228158010372085611196534261347478949518515573803887"
        "0427766833577772299895100679885999472136933656647575247856639421484005247092295404547283959255810537283939"
        "1536152805377136989128030010671552377676024122283837285170688576898765577337301783627428040617023286366646"
        "6304756840766048041588267560017035084467460711609718511878343601909600068154087444256240183857041447304877"
        "66761632079166770683820072204968831426390708208735980111470098563586361706256866455078125e-200"},
    {0x1.8700df2babc4fp-662, chars_format::scientific, 514,
        "7."
        "9814802786247251835728077164402394423392733891469600650972933646922261786684070011768202491345213497635405"
        "8363929473900800406081157910353783243643114657359608848833361253991272841241506805336597404984340460111575"
        "6660220570634633816720601395545604136254404189400125104060973148928687734799098012124540258682432908196877"
        "0832041763169112950312043616184359878531487269768561814660148368024122515583353773744932580874663344179382"
        "612758572700658879417422882008015735820127939371092240516958327134489081799983978271484375e-200"},
    {0x1.b201def031dfcp-661, chars_format::scientific, 512,
        "1."
        "7718621999986474927820511105591201858912597837406619766922788131515103038772434517005243859964561302258421"
        "9802754045709795325932881605994542308608831118420588061617714154977002180480859035445177618929493918433782"
        "2591600499156132639399865379537611196535055279648285165951017807905457511484142062562046872721511722442160"
        "1426553623832184397323279116431379887141296247183522062676919582794723562211028612905055854024015629021129"
        "8337387790447592797183168010955799288442025804339585715041494040633551776409149169921875e-199"},
    {0x1.eea8eae3e8e15p-660, chars_format::scientific, 513,
        "4."
        "0389599243158304571394333253525250389507631147978093452054769366480656241867872583554732831311043329402127"
        "3363893780503478092860643094562529070727567425705557388421503723273887240863523056769045564816791339544767"
        "4811798960347663619673711377735935298979851283703861602303938137477503201616025923026704439389500584641456"
        "9114236964868927498070315671368575179598358409648827561251869544093389097568519080961306269611881755257923"
        "57071395194827800525263513822042296462436685865367291814465033894521184265613555908203125e-199"},
    {0x1.390918e84e1b9p-659, chars_format::scientific, 512,
        "5."
        "1119492579282878449920089216681553851133879719260531373201034289194388628158048325602868518451980288065475"
        "3328687915381964890604155102827426856253986507040691348861285321350417983375890401837008594914469552729077"
        "4041634025375852486627406374778113240174679877779001695754357098999719528767000365619537633912001008295810"
        "4111194123452305704581476943981312220929979415555290962822172556120286736561042880277446914041656226018140"
        "0463623856109377838127752113794699265665949440735904563126723587629385292530059814453125e-199"},
    {0x1.349996396a2a7p-658, chars_format::scientific, 512,
        "1."
        "0079029980377603525237940067452489874385429612174195934573594706121935473916862429397131565712352453110768"
        "8142811950276179105213171370309953751158020788719826912383098267593711702326094595805498105681922999726532"
        "4909688432503132216386611947197870773295666668788871748938567859669346354132428937646632915596507684775523"
        "1852907339258584868938933224714470378079481955959311832805716821495059947675108015714103667421409304485555"
        "3792288834043863450758146748423007478214340356358069694664436610764823853969573974609375e-198"},
    {0x1.f935ab4c240e3p-657, chars_format::scientific, 511,
        "3."
        "3000803685506844689972816481749463828043574066484070851351960926134710393016865520510979359197005978741538"
        "5457598964481630013120758369194087749928754243965822423618640689642584934167891050733801943716663854770925"
        "8669749210069487078131864042347118088271846481163803328753828032361946128656564185923045562644481274673168"
        "2442894934517445593122976663972120711272481059100994734541198539955373713891254486701781695330533778123947"
        "552216106532507338730815426432497099038104195443954491651084026671014726161956787109375e-198"},
    {0x1.a6f53d0b3c96bp-656, chars_format::scientific, 510,
        "5."
        "5256081634540492912099873315946178218679701636409896216166339425112476137903833335081550464272182350571563"
        "1649173618325315650797318358082316818623716988646890803244474427212087305270872800356709989796858446518028"
        "0007153929447642907339740642327205632776395602540495277658534898752570556826974137137544575680121747318156"
        "8109294857884968121748814804138707666969927662354233378783086514773899604185508664921655337560966881995309"
        "90443024609879186497798459794215161380336108314093035431824318948201835155487060546875e-198"},
    {0x1.fd60024c9f6cep-655, chars_format::scientific, 509,
        "1."
        "3309156466126676327720798888520711121310973719016756617814609392099367961465512997004022190634798593712344"
        "8090126543369123336008687248835603759825341297324826585552662290670252876445576563127635381521847011482567"
        "7842445245383024757386520155419520590180607348277590132836378469352051761008545687687211422030370707996919"
        "4632854436567543001424200212283006776315002739251470698678414022677441491080589922168267970859024072320361"
        "5400917553291417625497725089895008484400045455087191470511243096552789211273193359375e-197"},
    {0x1.e59d51e4b3404p-654, chars_format::scientific, 507,
        "2."
        "5376664846351879796446894886180118923517375928916788468439012038559075591863943949905482322123331177881875"
        "1175818045667507501033007502798482889114822353165030685871064806380979997518713085247211620359113239321892"
        "0137447365082778750155424105285638558275846595641108095833746918637233220466393816326595449266228517373855"
        "3977212332931292826069615658590284856893342692154277412999385588950569011586612223617034264066429835291956"
        "64034560092739263995560422194101981991352402767692097995677613653242588043212890625e-197"},
    {0x1.8f3d063ff6ff8p-653, chars_format::scientific, 505,
        "4."
        "1725845639630823234884227494718580270580351053715713703971375362827503015835943180643599018229301247410673"
        "4531370235114440276681218585911086934300107994205504714104860990795054228564285081786387946659435399143288"
        "6039995130765713915101684430478057187716062578581352152485071389375497738696764199545096908565956533808131"
        "3066078143179085025594301665865165419361839755147261933143617447462954222697482489653056327589852788118074"
        "865087443355257133659824688533856429351574790498347056200145743787288665771484375e-197"},
    {0x1.8159ef44ecc50p-652, chars_format::scientific, 503,
        "8."
        "0548915652553614245327177394068343716266241601526344429862653871128012696092458059218804885886107480434857"
        "5996679239026442252671328552262873096601408628711791229287582758527981933915133142134968110008715888249271"
        "4360596305961404470471333694306867890527358826950270156557243671697176671195161373933098056018737049190157"
        "9062338058785059859208293885656813869546314004329986095442735468526295545526700031871588905460237269435492"
        "0045505660403734502280634268682688319158924361573781425249762833118438720703125e-197"},
    {0x1.72d55008d0c7cp-651, chars_format::scientific, 505,
        "1."
        "5502849382509784344046037079839787991991438980451926341439221279817304432312682866647314718184756317272284"
        "0418818164653948573900468129228650155998421452040946741052202506711300163335367314534852081645212273850483"
        "4936009445548134585828779634942569389313670043772850997818968097978274270563993945839657893655782681355924"
        "3399450305997531733663209449593963941246859189366865487597377476931307594702606413878721039121116753323533"
        "807929870963298864021730228539197981164725337333010202200966887176036834716796875e-196"},
    {0x1.9201b21128595p-650, chars_format::scientific, 506,
        "3."
        "3612132087463898062764140684189935461768684214886003230114344682573470604125696689595274182067484837098156"
        "7388239748345166372728200991082722447070470950976867382049849321900596490945089196119817194645074654642382"
        "2293731129894706387694427155598543964629550957151612379995382696796015118450028002145601154875875180150576"
        "2629218754188327338915245534983749038112110319832390876772625179935411466060958956629202109968362912633613"
        "2681375017182897009957109717175163086000551360132959644033689983189105987548828125e-196"},
    {0x1.bf95124bfe3cep-649, chars_format::scientific, 504,
        "7."
        "4845511815508472389273098151681950055020091161609473435727151103841950465792552422516369304948060633102603"
        "0748543057238889168858814345038221851332602680360589796942496976998706591507226986479450583156967310376947"
        "1550616591376104244996055290823711542442328688452990316118309517988468414880165494471060878616231312672161"
        "4660037498120830248157761796212768295676112842922578987382164266246048592784044581707325600021518482162211"
        "18106040902173381508385840983168502105714325889351812293170951306819915771484375e-196"},
    {0x1.05319129bc0eep-648, chars_format::scientific, 503,
        "8."
        "7354525906889357430513499319853860181982631924149000392085053971647451377290292578090547222488245265834970"
        "5414899403485023309716361193505231457636757444187175708777555726402719541396118635204985184043477505618747"
        "5847559854756176999196488474136708647066869380958111801978413140177547807244097772736963227119156935670681"
        "3323315849604381739911974325657778568932885367514619084065148363560917676654922798826780533306406883703832"
        "3167938402444969732430229950789418789762474926163804411771707236766815185546875e-196"},
    {0x1.45af476abc232p-647, chars_format::scientific, 503,
        "2."
        "1784629336342830433438401052550444396082133172046876130098970781925971096906924659862775926914085559598218"
        "9400663017394445060955050790938880349417984181161062059937297849164047537024227807102802573693182922323768"
        "4988835519769163005404421634184916315156946538119863486913379372954302859826455909344216690658954228864068"
        "6518489319695139936631205914340242708131038022972028056540459137983053554561488795642242191718171201322878"
        "6261160061353215424961010708322035390495374773678349811234511435031890869140625e-195"},
    {0x1.08742c45210fdp-646, chars_format::scientific, 503,
        "3."
        "5377948750753546389134876678525502149469329636100241627697547777540495032071588666485860794956076980685142"
        "1648973041035651788522826916676596088401130357999256151013354430964513824609480628150120736931652913772699"
        "9982913797176673718855319142272201371103880783459641259655175318625370923447186213384332996959675405576982"
        "1423466528711936764992224608103888079428547551703232208782450602977450285489861691938795324543533418630584"
        "0889333459077886488131187709654153499168327545731926875305362045764923095703125e-195"},
    {0x1.e06706f5cc1f8p-645, chars_format::scientific, 500,
        "1."
        "2853400648125002047663650303839837768770868178827228680425989408577299035277697772519128024365042269006137"
        "5219583393883196975265503479494447072597343928704527629935234980629701495621199539547037556144229442345470"
        "0796064280527920406982515008146955967451695398724643112299643103663775673910972184612760788176258685407613"
        "5642395098320769603757825318678910573482963656312687065092042077801896417210663056529091563705356552511784"
        "8744898314956824515887701286388062303644996831053504138253629207611083984375e-194"},
    {0x1.c3b440515c5ccp-644, chars_format::scientific, 500,
        "2."
        "4171125083478185854577296568973058488028696120773687858171527751677783966413609421158848849895950071414992"
        "7767427664623224802204953078177500746806460413182965492695822167375307505348079714337003905535333983330970"
        "7181502126431081191942010252850595523287033985789669321526444757608927731550951889320987373819142026991025"
        "1567538566070467758974459713102558552732954856343026723690055888710021350990995482922051405478223152042970"
        "3251711643812898068027460606431856653120160416392536717467010021209716796875e-194"},
    {0x1.ec1433b7cbaf0p-643, chars_format::scientific, 497,
        "5."
        "2663240453669009136451576689712462018780864628757726838532298564973456520124312425159168990966344080685284"
        "3720480382087984234515131775332141605827039252921143204800571618187675999431430968489137764119560673111591"
        "6759478685050363495734853368006928166562436836138049592492697802548236478358520529617766739001729760991012"
        "3862634939696554148089055580137656188780075461507170901101717759741393603409206482184290891472920793565653"
        "5253609046038903154631796610265874469813951463947887532413005828857421875e-194"},
    {0x1.8c19569a7d35cp-642, chars_format::scientific, 498,
        "8."
        "4782562742821825187637774072036156880782589649318925320904558902615305403899383502544659296812445003369004"
        "6922729704209086787736189120322426639864121576693397330358676265593198834037152235715817069429196893999010"
        "1011594016395775564940509800763785671916185917507549352955056824078478279323005977928175814655943739879529"
        "1538021924646821332904342665749434907103144778825208546062155400334839930506320175047419033723187526321855"
        "64516811751524813377187526721215880820547994289881899021565914154052734375e-194"},
    {0x1.173cac50c28d1p-641, chars_format::scientific, 500,
        "1."
        "1953794466200874950308910223847802663992105229667520001447180957079004440344103290919539635946785467448663"
        "5101108320842702261329824849337500079159383293237143393259388273511334641497706315723447326003299101241322"
        "1117379942112771102982874993847323660037994013482573676273472522789803757300898880108155726096998947940489"
        "0006031075166624593609122438130204229832717825013013180449460185827436065860119332649187858804645882720105"
        "3492998972995592881612034128274647988565693168538928148336708545684814453125e-193"},
    {0x1.08135c62a0056p-640, chars_format::scientific, 498,
        "2."
        "2609509033348430712795357140935977280309512733698287057990757911935349021821947685234330624308209739910346"
        "7772270922940612799108025398381661528666224493282545567170070803473785763542388437441950076122245663201438"
        "0804220304282042074737823775324236510491104141195362756591323881292372606025430047584104793476982829997116"
        "3833702491013210688436845620875268204319510942541720735041457845466698101522952622178680700662949823493228"
        "83116291501047308902301260328539765642741343754096305929124355316162109375e-193"},
    {0x1.72e01124a3b3ap-639, chars_format::scientific, 497,
        "6."
        "3506864504234787217892916858872910373177620746625376458668035645917888586328943349478973125084439934368395"
        "2454007404739476733674972532888856971140947480305553043580744964130001124409209147401842341895272817350358"
        "2967907318694311580157475110469517637645997431939894575492729066843808617131234673944976587290456837115006"
        "8097358639249101610267432497854886217853527900415351535406568855784166730515150549809118454920495773146011"
        "2041598585348160002997507320447907741556292648965609259903430938720703125e-193"},
    {0x1.e830eea3741c5p-638, chars_format::scientific, 498,
        "1."
        "6719092307496787724810559419625415421265345344982027451035214168134737544212060731999082598951652542812153"
        "0851622757957648957787354945239842973641168921883094179012153842080031968856243689294313054164220779419616"
        "3185205252988408837352595118420621916054112930407241813976472546961527155883577597985057849232945503946152"
        "9700917317130576683212396338930885138139608143780624593505064057096724037453800040558676726388410965108000"
        "85511376306229931840104611302550048634874002573269535787403583526611328125e-192"},
    {0x1.a55edfaa629d8p-637, chars_format::scientific, 494,
        "2."
        "8861375664964044259358368710583120953117948717615414732645978781844725959856063670973732226688698008775290"
        "8855286029832137603479464792748518405725776034634453198114500345112924366610049934881872894137471578343997"
        "2272095705181453677718281937893424772356043639946249738131015138508747363998350555539212469835793234130222"
        "5611134741196263127354006994422412740010583624493733640101270323986057803752221480551347236346238685334139"
        "3126740018852601983569028279257018265724354932899586856365203857421875e-192"},
    {0x1.e4fda41f3dc12p-636, chars_format::scientific, 495,
        "6."
        "6437958622447088767008821269554630170953468199463824514799297420575734289189965271614292158798703423278770"
        "0211670773747181252710225781433614349909082934153740628607832041425472458132448888355030553558474449140267"
        "7532352029048675127730409628858188469012202328932369306696111994192499642393175288938545581909362670265661"
        "4142505131384975210072259285428843744450254240067804540915295982013954480300602499657994651473650515508069"
        "48573291876921601661574797868976827164289034044486470520496368408203125e-192"},
    {0x1.b6c6d5b913315p-635, chars_format::scientific, 496,
        "1."
        "2021435877944512549874307758373463485567732529548696497108946777892373338498825233998851190169288250470729"
        "9837565510492003253409646038667103199192178730894714971640838750321839454360839834009539364164168776033623"
        "4187003338717194709455390020102928159467155523872584982511528028983638984992933752520154204626796100307564"
        "5349437387211946890857172860201104002606422391817193670983149333434914995143903809339065936913317470198921"
        "690228366842475023103730967012105212976535995039739646017551422119140625e-191"},
    {0x1.3d5cdb61d5eabp-634, chars_format::scientific, 495,
        "1."
        "7389964555399592703024922101071638710228058853010454955816287203412674019899135279944202376472905021337258"
        "6258962377260188928899086845828533503606946253121325963450366034526072666759964392438712742370869822534456"
        "3874894747840335256486925055706840475130878149016154785918583949575125805400818453276293215346026410674679"
        "8409452115405004337540444738954378827964445928741978867217483445923848187815353826331562166817109812355851"
        "91326326911503365880101742535317199678246424809913150966167449951171875e-191"},
    {0x1.f66ce3d3a114ep-633, chars_format::scientific, 493,
        "5."
        "5061029114396530055781180408544466257723099083034183419703118907194804421094663580781660676273528898210088"
        "0431574966784461117119754411304894464276186456426615997746028595767878242155456834626624868962582541328173"
        "2698743091955612694553222682503348082494541469600607497030280636718224508777918266791407040625019889179303"
        "6039432538320513687547095452177893522474675770324240828465783630281774188233607627719489884195763554935119"
        "805608804359250562788832806214445181325345402001403272151947021484375e-191"},
    {0x1.172470deb171cp-632, chars_format::scientific, 491,
        "6."
        "1182680642406057145274956363318000274544013834890966296936024088988282930612184978650264904063655374278708"
        "5820049824373260415590233856953389263574865715472704679815904138025683990166563353576868412611739320572220"
        "3061670363833037695225389013764717715215814805406610147515377607379775485559684197286852537353051075869007"
        "5622999002133683147106802833986208071593930453200187676542794020322742581458245280814157780849754554959666"
        "2062989989245184079000110764778863625679150572977960109710693359375e-191"},
    {0x1.cc8acbb3ce387p-631, chars_format::scientific, 493,
        "2."
        "0188412709311976353396884746311782549660027699626134416908249213603286354301183164885857133455556626170175"
        "2986650828364633304418446703878674495167794883307172379160008761496010293765369166879233431965874199769146"
        "1247264270712989910977467696385844786711157938997013783312673882579017433385308124601678176538989823901426"
        "8504426857552292598582757513121935280241619514931840030076728470889198521213809709086287440776710908200405"
        "735357811794408235582388012711863023440628239768557250499725341796875e-190"},
    {0x1.9d46d3757a126p-630, chars_format::scientific, 491,
        "3."
        "6232946244639112367859903422212363335346720737453523731673042531604023172777826136821456024225495282135527"
        "9147249851468071176677140162008005389158117032353189569393774872787748437635734676141743605239899596247807"
        "9173907474651509305526426663536509510071332191959766754013674972380722084744542075898159198263972544323990"
        "9862127078321763680723742293917247854494085650342015232239396059322574446979695006954270328936113654558116"
        "5109048996725791055641976122492220468984669423662126064300537109375e-190"},
    {0x1.5c67ae0e78895p-629, chars_format::scientific, 491,
        "6."
        "1090986836497964518361303425180367723651770315999856077892729499033830962250844499257483134844993286529957"
        "3396737151577326827495417291920603068403409539650431533658243587896155378299195574892619397055020676300748"
        "4081137435305555643552213889591461713709239993638313481580791776559826037819644583208179233694714627479712"
        "4038277978644551890909885049639824861857655631507863094307400842947454757116813778845481873427571851486232"
        "4305325582256049241387124183744194994005738408304750919342041015625e-190"},
    {0x1.2f87783b2188dp-628, chars_format::scientific, 491,
        "1."
        "0644449452139395541202935621152473437563772434876136314750186066160168868665485527429324719400873126529471"
        "1776208189233000924188079381994589329829074340081641242779083161698962978837918189289798934978657684522178"
        "7193869606025896830482212763406278603126524969759522714284262548258216685128420411064588664951016966673939"
        "0845242506290804466119517491841125808875606147358759849354078294511591903760561737780825280148148379041554"
        "6575626016714499472357838456837431095891588483937084674835205078125e-189"},
    {0x1.45f46f0331583p-627, chars_format::scientific, 490,
        "2."
        "2861786222533954646339338691509779541402264763066115611162751161332286389741951997410211952913065640508722"
        "6575869024011507037043987193802942274169970521619512563506532093525808423532637902062603827257377383924857"
        "8834042883646674050483274861201465476232289908450602259119542804457889706508812587002689534404145674260289"
        "8921599918546506922933261671353147226446502233455978523651976194012189261061433226344919763518640419647944"
        "054596842767851933093579096245573367696124478243291378021240234375e-189"},
    {0x1.6faea09dda3f7p-626, chars_format::scientific, 489,
        "5."
        "1576905486221095495936291261435152848936470928518784833293608233493425320242788522830160136503780002845701"
        "6048122210607633734845264378147025848275264231001539119629139628017208552752229789388978000511788179842606"
        "3317970612546358672835740360045451972628457734270690142631590928444025538183708917796524126513769584005208"
        "9566588457104934404172248545830966642830155623590373212577067124362619633973442089846035406156342718763126"
        "22767073101055486120613234601872676421407959423959255218505859375e-189"},
    {0x1.fd11ba94c244fp-625, chars_format::scientific, 489,
        "1."
        "4282019181687436415805061570582957797941162203963167425601499169707767566576137048543241444320531168598156"
        "5115836884276861958472129897937475431167531842729039094949094354884306009515806723673286503437496509105787"
        "3782638327303358403092014499545668583556513012056701640438893215817552078525004382652304169786365593370561"
        "5949165720580529687699459243337232320280125250787257153626075271940536628789995287096375595375273874864083"
        "00778929339319455162830678485175184277977677993476390838623046875e-188"},
    {0x1.c90c420cf0b65p-624, chars_format::scientific, 488,
        "2."
        "5645102658000638077662655089472362542882984305302201347516398173403533180585976534161315640938051666852184"
        "5162493546322932210500567375141201380918228455858352480628723115250797285514387548153230939412238584051887"
        "6678363214204154015141209497251639796833017773424919290240970816054977116200075111851757962310125684874866"
        "5271116317931001749649690210063583111446018923027887259222427377589680137555787871347433236980870707367622"
        "3030545509731425180281923215108719205090892501175403594970703125e-188"},
    {0x1.d391952e49017p-623, chars_format::scientific, 487,
        "5."
        "2470856179554396914220750697206729680930693393806189392472186972317553487714556786098233769482799791950847"
        "6936934598345790216268399728663746626185262113984143990716591357062201655858886386541140904956275446729344"
        "3451534230378626979844440459329023491130157174730485458049630374966675633574693062515331282157551074828734"
        "0588927778646025401932502132098401926185663426957522247203760063557453586246851349782431341310393754891747"
        "355941298035050636481939345667768748171511106193065643310546875e-188"},
    {0x1.e503a112289d7p-622, chars_format::scientific, 487,
        "1."
        "0885720130033327524143787276552924485207749474236947745950934265104724459837447523248118491135661241355555"
        "4232574757514637326804013587665252102597948137223374246525570157421645385185077366595494308247722426388075"
        "3119476116577310064807731317312781001077692695195412670562534730271894253873410722316538605384606174341590"
        "4126374880046187387430900137190727541241598691090538953096044591639726558323746143783829642440266358936970"
        "699956723022336843044975684957620387649512849748134613037109375e-187"},
    {0x1.e034bb81e6223p-621, chars_format::scientific, 486,
        "2."
        "1555608982793881032727700454096876448057956857157050502496261686574263161511608285224246722003343000927303"
        "7170918392497696227267889285573432933779319637407407790610774179847495887678439501670748288585196870929692"
        "2631032851601097932395854292976963625544033998797106811775949503368245505473163357535226402013752099869119"
        "1325549281307961732743070166406501415911305100704902729441738565684824332740737975732433035435605707383320"
        "56586222159526048335574655023805235032341443002223968505859375e-187"},
    {0x1.7b3f7b7659658p-620, chars_format::scientific, 482,
        "3."
        "4047560211390398233126309568152129229163573085233746529962515141769860702660931684182926361748771674041996"
        "7495013736445763182743473510953840736163870669821867413809602871013516774422732969041413817218575179638005"
        "0875945116419344891273141268326046666030950270526350859421486707701849832266291902224529676973277412963424"
        "2022391711546658347775048931980490466521054406862017429528749012178022403631956930652304619750657559521682"
        "3978488395241784846001475983712225570343434810638427734375e-187"},
    {0x1.c3de648e8e3c4p-619, chars_format::scientific, 482,
        "8."
        "1134394501696493643970170895844859050224211984805270797934948972160041994065592646160497525561847540423315"
        "0813807595154285254949233279422425559267946284083567427347887635007556376708519246514086205471778512341436"
        "3518932443771014783422046775533781186699620751308267263855491161152739861928620614332415977705700567596766"
        "4862641318690146376278630164143314536054904863747143635960925293922708102025814503615280997269393301674470"
        "3307415890333677450929616981056824442930519580841064453125e-187"},
    {0x1.5c1fb09f4e5a6p-618, chars_format::scientific, 483,
        "1."
        "2501335652550156692148201907563971897160094599357553635775710000794313839387986491396580421848511127121467"
        "2834212759262118551641268797951714831348473471191972599936690879566720474936486069169882451620075746975670"
        "6186070712175957038367674918959121878800275599658681630037550050069344073450148603507547516824435960857783"
        "8035657183539595621318513297001759908054939222484006322563328047101387846029777029392729213061137991735191"
        "96290497784021327441761339827053234330378472805023193359375e-186"},
    {0x1.96cb5454dbb84p-617, chars_format::scientific, 481,
        "2."
        "9216455145197990881697076029069682383862367622239909838970901266656416619071823783376826565064724501517459"
        "0701539592225503271024718266218547248626039047992425493790137556386884876463021059476422710406079165707647"
        "8035331425667060181110341423930489375804406916453089986931472266944633195682980465023708899952177106470268"
        "2690151782591846080679893335942503991582720417747237342953988826766205275785907263374548647122176495933127"
        "570825962591766385145763962327691842801868915557861328125e-186"},
    {0x1.17e326744eec7p-616, chars_format::scientific, 482,
        "4."
        "0203689191003500137032618357647146694952938707754104131177614885341123472548521527075537816698643711941179"
        "0099119606618891309209407696274360253203429336179171351133531689315057310507797931718347867905142878647295"
        "1295378015371889396345363159252325592648677983269855951990787798154248325992797181678229344332440102948264"
        "6293076484812638568001554150811635968863201084650719977028858419487757190406448299518015352159703896986728"
        "0321388645943753679945498191727892844937741756439208984375e-186"},
    {0x1.8d0730dff1c35p-615, chars_format::scientific, 482,
        "1."
        "1406014918543048611129579046078472017190434076827676333703184492562745517458722933909773128140863811860680"
        "4407235198747673113581675421832304460289731814158715726226721499893358385121455295036409753755696291856376"
        "8098784914446226027812795614298253285437604990024681376542185656441137513607157191982929093989227066316968"
        "3454585239942627682309380956856546873709262441718817170600788510391208708618239903357485935403444561300988"
        "9522537510867503975087178247349584125913679599761962890625e-185"},
    {0x1.84e464adc9bbbp-614, chars_format::scientific, 481,
        "2."
        "2344564074253929881602452952105121463033999896331509753060278603561383062671020092513964622839910827392979"
        "6120725053806395919718505867953302822071585340945473684155811269041734009391899894892884998655950936230307"
        "1669852431153178035825596725766172839564272885227331529420345731439115502642545507672856789487309544230679"
        "8912794588961931961324587403615865918507170866263260790615432342540019426259929855207218540356013049043725"
        "298895767697004814678063411292896489612758159637451171875e-185"},
    {0x1.0f78207ab56b3p-613, chars_format::scientific, 480,
        "3."
        "1195598970627892124787027828771258554467274331378106474180853903784890176470576278085246910031864176926682"
        "3810097575938279721843585234379937227458526717860732051290204395780473433869536107639158198822468448383115"
        "9850946360996498401289488125559457224226066168139585512180838489229070664388435003461492126740239264693377"
        "9324794218572275222475371415195959735820466509414273243741084753632448488495906132266682527804921511867261"
        "44134988124453043700778920310767716728150844573974609375e-185"},
    {0x1.5529ded69b52ep-612, chars_format::scientific, 478,
        "7."
        "8408892826173784349899140483375110468365507426372771215508168337980921036043285415746083661506063036302466"
        "0337267991264308099236262848998613132804398487495251763436683220632776620778652222684238885184627406388017"
        "3229920844992419303692750294188388326470646133479933189911245652940004567736087396799055775383956456338672"
        "3024800062465207795949876534463873259186889135949555497350644501301606934956057533627187656477601229539927"
        "078260013316828025420335279704886488616466522216796875e-185"},
    {0x1.a04e5d2b8832dp-611, chars_format::scientific, 479,
        "1."
        "9135749100368870646470019839026295232772871223966552993833368138787991754425940205303288817218434799653336"
        "0676967652656209466863703861565021219253899628393157406814397593941242505553200228515413826724835127232051"
        "9185851595688434551396579504904836374850383234197454697279713290430878565007147332017477402669464535867351"
        "5775192868362553696596252586924323504526235631150752451721765189140363973209619061479811966865121637316157"
        "9595099193750774857480934088016510941088199615478515625e-184"},
    {0x1.ebf813b0bce87p-610, chars_format::scientific, 478,
        "4."
        "5227279193825361739063351116581608889422003874799378804732418515554268862505634014557098902874036193318621"
        "6690467386983882756961652575255407524524231250012838933730250624835733642161557413446773017614154929610452"
        "4998635489828297481285095734401803451480336950909547116497526559046290615361439294561656735211425759983595"
        "8658796913640401549715379516221334359696133496301930305779915803185229950546802865949446986687845586568652"
        "642876913762791379891581300398684106767177581787109375e-184"},
    {0x1.c8dc05f944175p-609, chars_format::scientific, 477,
        "8."
        "3999229662967713528086187594173418172158294345371367977068288734445756810245726239154122121417804811678553"
        "9260638908340859917786703727950548339528508554698659192678302294445813989552010648988331687084249678986072"
        "5134086126172959651037933921293267583373144983517760442249968121280748656790906595397770655757785243584311"
        "7665011821890292937224415194440719059952578889148712792501100830129843689192652755309251105434679191014804"
        "94498409103999725378031371292308904230594635009765625e-184"},
    {0x1.b3209b1f6e28fp-608, chars_format::scientific, 477,
        "1."
        "6000703209667125522791462448559322479873062933223276333349152772387295549263802853627258955887541875044108"
        "2947080038083309540852416217060880963411880129141024234284664106285251262025261537496173726779635481066239"
        "1399956818327965395732286282182169589674025784504944090995218716248499475156431003783177219541707924492549"
        "8325814926158454470942474826570277646630983287446062760977259012870381602771233702771674396301817368407594"
        "07891672679545569391024173455662094056606292724609375e-183"},
    {0x1.5eb78be3e1518p-607, chars_format::scientific, 473,
        "2."
        "5793451325824551491141095667675624912529344342712005389262969789586908298595671025931892803478199322507986"
        "8523010849281646737274885718408262502576874120606976940116290679237340341259636981155466151665848618173232"
        "4032607948080657805132919680722936044837224175094957632003247401297641357721425657261766165473818699028835"
        "9825505903137699079686289257017072435439734264967279514362822953866073386940049227380450195986556441556177"
        "8167473687417565741952785174362361431121826171875e-183"},
    {0x1.8c46fec031da2p-606, chars_format::scientific, 474,
        "5."
        "8288366507307604041374269061151039091481400225143596125768084467228171073647588417776611518319759684136669"
        "5557291353852212593508193848018264294866764758668148761093094182833021715126098317988401041652929218002060"
        "2358184934865157857832670838256679385610036129043203830159719538870546915932165957386758340306712837687657"
        "4139690927957720219748627972540410054088613214587368073136947535541347600289632712236225552316903946201217"
        "43439748913939713048648627591319382190704345703125e-183"},
    {0x1.86231c6dfd804p-605, chars_format::scientific, 473,
        "1."
        "1477041919553151503755311242286463359086338700939173534433881149141551312845676541528433370751398526129520"
        "5360200123442369544861627337651189410728311021716825316418209072205209059768027017097741944446106051476144"
        "9260586341856618907842200283371765359783819221589931961870907795236477229042736793261103112697240517930987"
        "1772095882680155257799467917171661002569274579372573148249479204708825803923891308204782759202811211858909"
        "4147011638036293135201049153693020343780517578125e-182"},
    {0x1.6f91c9cea3db8p-604, chars_format::scientific, 471,
        "2."
        "1626294070138318712021828339014812165466875626132428688506066130661223800325245624218990344615529115525670"
        "7498826015032971421773458480080315944694557039046086653470574190248564560937128913048158665762605822060055"
        "4638663222463820196556288005293509078032902091923457112717105630806377089745970685933260769211709292606271"
        "3883265602154051291339880146519818852439242793594288516683321266294987653057491978352698407891148399388724"
        "79857372155276351577413151971995830535888671875e-182"},
    {0x1.2c556f28eff41p-603, chars_format::scientific, 473,
        "3."
        "5340830852507131965886973628844009684695670072958139623317371787746358871058121738979142765604242918427270"
        "6832415724931842814426120166478731717470396051187190782581219012149682498960891262131383887862540827723812"
        "7643023274199348054497036263959980391539791048593977360916969031572048106601825361653601806771067623066557"
        "4051011657281000462617858827996936464081367646380909919085410798272389504087757458521098222151497599140581"
        "7346111169208189295432021026499569416046142578125e-182"},
    {0x1.e2ce238120917p-602, chars_format::scientific, 473,
        "1."
        "1362518681203582246140939809705922332332975015608228604463964843232561988310452537437790568021290911866235"
        "0839847885927093395163376953078064940732037455207673242572744714448661683497842412332824043550192279636628"
        "0503312783365917365174312756198857236845666628455487179177649489943944605272828958999095810535518041549318"
        "9818268179755941618181564000540778433874330833462914620292376177100970824204171827936477371939329301106083"
        "3410329727610754702027406892739236354827880859375e-181"},
    {0x1.24196dd650362p-601, chars_format::scientific, 471,
        "1."
        "3748749674401770954459165335871081766876292885886953638318405208098300543963268873795361532633351527309260"
        "5183293467910096607640374531111183083050881483551578535590574862217605392658691254251016040206211732176264"
        "9513738716450171265643756029288065693302635054394259859478975337052256681676444287259784856070495950346420"
        "0147147833503265827822922002568340246087493652923517964388001136742818825550149740093584171030834883177820"
        "79866403999179880202063941396772861480712890625e-181"},
    {0x1.02bbba1fa294dp-600, chars_format::scientific, 471,
        "2."
        "4356505490995989137168281913610731830019560936055966573555888682095611638946741848058176225505118866181664"
        "6626267444282690413817201444989379537984347462429716702593341950876461070954522685954552542326714837267824"
        "5393625964579526328349325430932794835417522958299065595103892073242338952253770707833051812460982697751239"
        "1397642546757797290343067143148163681852061908086271106945153788678767070284176602262881688759899668002859"
        "52308775805352780707835336215794086456298828125e-181"},
    {0x1.7727a07c4162fp-599, chars_format::scientific, 470,
        "7."
        "0632264615999984553004824523934828389746815912663087276342193164535550939884152883670041383967458297749541"
        "1936486820912787231863213987513973227977769787492778564103481765224649564842940083968386889634962937410157"
        "3069328602934415866941417964147777899133182591019874029905970963950870131654961921749867946840387912428480"
        "4538594740895098332413481316117502058978520795751015258819941676721527211850355917929781785411532757190855"
        "2225891930742562863088096491992473602294921875e-181"},
    {0x1.8f0824209bbd1p-598, chars_format::scientific, 470,
        "1."
        "5025541635379650323807804926251313131836557909893686530962020768745327962627687341360811479854106994068553"
        "4263173419339530468602130784596336253828333239650646771645717369473848852911124115928811400443967809140245"
        "9813215515621469873636992676768817063884474168442971019069351420018247479917638346466764078010317901152627"
        "3081216374180988281024361584175357121212766604713032037039974454629576819451922761645310017488437158483350"
        "9687996466741566337077529169619083404541015625e-180"},
    {0x1.38fd6bcbd252ep-597, chars_format::scientific, 468,
        "2."
        "3571270014353365322336931950633836856113223159844998673765836415920035201232388224807330916269590271324890"
        "4334731033242228233263401451666324072513909789496747974372655367892497264045352322984236122954019123722538"
        "9295828403612962912512216580766983652588284187430913252738151214604768290342680303710604633254838264665098"
        "9962035785843582809055612178144212382821531464078007017087908041952151860790529094170570698810065899235103"
        "91969274646584153742878697812557220458984375e-180"},
    {0x1.c012c11b55edep-596, chars_format::scientific, 467,
        "6."
        "7488790504233201532404821012783315024399985087878933914326993678810118949573654609919916051799477574590605"
        "2555587820395782532203892095091092520933306954962049724050297871723120684162663655400693709284384679579844"
        "4229626121510547440413205330956979446376661290569033353380029097827152899554534893469580751628492269227510"
        "2307945654300221853112443217811972597390157707545064145290234402918947143290826226229722152773665129123377"
        "6865652327359157425235025584697723388671875e-180"},
    {0x1.1aba0d7a89944p-595, chars_format::scientific, 465,
        "8."
        "5168606875567321498727662037372810859520433921783123995459117425504744477611215726819499227583845539616812"
        "5239580447740616724353434082982514047154634288153751058253832016000933674669111863819139788156587916539153"
        "3715294248439635842170170518537437533149976925664023652905320015380511107595544259672890160470678028598596"
        "9007664706297339134454910441203849873467808766000671452678283228867172077673641166000719771578738611874552"
        "84682545908481188234873116016387939453125e-180"},
    {0x1.fb338c7268b50p-594, chars_format::scientific, 463,
        "3."
        "0557865935212958394376086957173324154082751196112498539965546191859384115363199888292606660746361125668283"
        "3404840375713838316990182046660217446344946472933812140353250354288117258476863349697332813418892391221042"
        "5909219328122261566214838211818211400416693170662727113985478183823335721980028025030361593055215041959837"
        "1905219233320642590550021466201626391931891093110222234205139677685160791537656843706503862113584384899329"
        "926543742885769461281597614288330078125e-179"},
    {0x1.51b04971b0adbp-593, chars_format::scientific, 466,
        "4."
        "0690125758357819313890653104659603597467313761268844991087784245249784829428847210475329294275518716491653"
        "4121363796664234945241951639537426384878238066930222719005716702736354770121804434103616468073547678393421"
        "3866666956214335399982637848595661597381697776886918409632666455919979846021303241798302378411367222817251"
        "8260900155291238599964614405125995189283239303437292544747420798857552235240907507102919238856499693549029"
        "737782429805292849778197705745697021484375e-179"},
    {0x1.a8ca233514955p-592, chars_format::scientific, 466,
        "1."
        "0237088948578388358098853060992576583367816569954351981673902681175827710357388491891184587825924676377634"
        "0849697422669866470721371511852998301084735245899689191518783967305093246868883270208809502585863440586583"
        "8719400606468608999474499247944762751706090711502562362059161157946679758864812671596322877059632473937360"
        "9857690212696944678148132075078524683281354026644263575846458787445324344890837847883377169654004993848352"
        "318697170204586655017919838428497314453125e-178"},
    {0x1.402ec07779db3p-591, chars_format::scientific, 465,
        "1."
        "5432289335652199429529596192176095228012899535553233590378023000243990210617168196490459969107617309775975"
        "9271595161852061445606846570553485751629922977685294026681803756969797432088015163086656410384375134034845"
        "6654787834477195943853030778904275812187520216131508463375328855191606753215808123343539126680637528150749"
        "5586400182624672163254831082909010625241829629378479391253695739321009052894816650751602501038193173413725"
        "84218017749435603036545217037200927734375e-178"},
    {0x1.f0aeec50d31b6p-590, chars_format::scientific, 463,
        "4."
        "7878677416379371549125789239926548827527615154124045791534979434488720324473118535175349175451116574955482"
        "9196846477560962493984753090692845809166165686038186185598545516804955486444807934972963947481576822992280"
        "1413673914161293747159398543359951739982313316116576662886014320825440802061395606568618051069946931111084"
        "3403784158309126949658184006386667169743740687424550046011927504256647287974642036460883111432322478315769"
        "254120226605664356611669063568115234375e-178"},
    {0x1.57d294d3c2f9cp-589, chars_format::scientific, 461,
        "6."
        "6286789908919767154439712855163324165485647125775879469082523552535784443231882065986199405578268409671614"
        "1775524355094157699459438893136009843313395926452650072279802208152136503116316085826330120645706047536069"
        "0707532743601948118549864883622173092720567735244279208420288624269214419901245909769732036473350606372685"
        "5287774209801534211907607596434562429271112638134066194967154756089303850511085273262727747824243635776236"
        "8270840624973061494529247283935546875e-178"},
    {0x1.ae73fe6587cecp-588, chars_format::scientific, 461,
        "1."
        "6597719647556534585125909210073988053664761497437503116043924519032075968467392138434096782371133771691041"
        "4692966359530302893843702342909948977224093225788840850241158526002495811490793284029994355447936207717953"
        "1701030202592523890664293391660227483252564706908710533792330581122217799978898141257599150318157143299562"
        "6438491757766678273670461681099223694022755564691644672587301285547650231438839095722621873493583105878962"
        "3693172643470461480319499969482421875e-177"},
    {0x1.fb67296e3acc2p-587, chars_format::scientific, 461,
        "3."
        "9129616361835474995816830113427371139394783748006906776846465564831734796400082279893725348246088077820873"
        "3724773721727647969237518001871833488349905404751288122720075258042368323832359271430311964401334649219933"
        "9519425305966013506257262632784489759265561057060941101640097783767987620799907927064604185859394447002994"
        "9081905073803555079273434996212221006831413351082560112476320410824712380110268981480781210164473159999337"
        "6480739470935077406466007232666015625e-177"},
    {0x1.3ed3dd4d0600ap-586, chars_format::scientific, 460,
        "4."
        "9174333185201845885701643304817719285286793119402385343997121743834215253289182597526179950619953400075056"
        "8215327569860654293571277325952168912585808066003526425979416007658121367350545330904392662818296290555095"
        "8363362875972718209741260985284999305425043970836369172025830193280142465849744222930368949184112590984937"
        "2570588281489240090240019398068143537541563361531771384907078697949056986176353435518052413541351141658408"
        "696599735776544548571109771728515625e-177"},
    {0x1.c7fc47e8e35d3p-585, chars_format::scientific, 461,
        "1."
        "4065772131663601624731605132771376030687013595023265826246899604517310916218342653982498273578257694903797"
        "8468638033545923123797757358334963538697635759700073763508738768671726201090282961141287767540599357579432"
        "6842542570723744576605062186938060430296209980469258502851293064721411956550060490555280947897869268535238"
        "6179746516768341436744109032500119725007587257232992073560146104583620982534044853267658149002760617409663"
        "0464731561005464754998683929443359375e-176"},
    {0x1.e55c37b92c6adp-584, chars_format::scientific, 460,
        "2."
        "9943788764426966743964594522375614351628056540175421741903002166035225397433156307925002196026795564333321"
        "8608007322600239902857674736096887285429346165120286356617612333602815378437074971902704269699125569824971"
        "8734965454790960376519785799921911505099839114997820088040932021308668960743662393965366462481244219250884"
        "9572198239276132947860029194547765807895534142629802891987129320208281337887778316462208527447689848828560"
        "332805182042648084461688995361328125e-176"},
    {0x1.d5f79f14558d4p-583, chars_format::scientific, 457,
        "5."
        "7988273284859469245975909244211226235064534468838026322900953010973310895710460351625303496060697525894981"
        "7548467994482334725806573119794681098598188149502821244093362724432709697646779140442854709952519834481575"
        "3552685473794970090692535724337831399571800371346050428402437303389817593443709839557440032105433568682862"
        "4757675607836065407289464361427118285829539423788560868340267151754097473537655899023331355796062082375019"
        "741675714612938463687896728515625e-176"},
    {0x1.02af8b4a8eee0p-582, chars_format::scientific, 453,
        "6."
        "3837373791831109164464429226879340089313583401475598285331493581326429673206288607877477935245231280837188"
        "5647870091324083042948466168427797571451303935851646140779239476004716342445942378983444119379324329844134"
        "6151467615682475506740110029481560213541664875596554901104780563157049593014023988690619684414077863454296"
        "7876711134989798226852771797948262135736554301036508910870959205653707241544181380479035784912197892815299"
        "83782093040645122528076171875e-176"},
    {0x1.590863ea685f4p-581, chars_format::scientific, 456,
        "1."
        "7029147394060241225903488954267271489892327386935164464069609449685702563324256490556157119037765012843166"
        "7310922276302573508422178617217778935442879125612302277325623482105142657441536641590746592972611280474769"
        "3325030138100672596616353372172516265836210204580350417097583162091337255177727535194710323672332335205952"
        "4514418255814217675702145734323793974251426625781831584646489266954982049226992568944037760889998259217215"
        "09303097263909876346588134765625e-175"},
    {0x1.88afc27ace629p-580, chars_format::scientific, 457,
        "3."
        "8762215209996964796089923759037167832249242753682372854337872650601972808271639583174726700107777427008492"
        "5501806670174866216009677450964270651295366445299067761270362555402692011724280700725138145693269599925464"
        "9548206525351444569181879737766662552654721137751514033505841091039998863734933754460921996873791362418981"
        "3877322683660487034814611363469602337211596081779924811843071508227249052874980749704115988758129120184126"
        "037429450661875307559967041015625e-175"},
    {0x1.5c7176f603643p-579, chars_format::scientific, 456,
        "6."
        "8789882161917508509670824126173614140304474268001492195639974058156288616291688554218622136287337053108089"
        "3419613781966113824431849672860148904218174388005163947601938431582715382608955397928680356858042289516561"
        "8106610762680714571764269279291838992388844607635676991533109853040114513708619359429236357658230665495532"
        "0578191159151869528057193739314193893582637371956923500775255998034385509158645247066496985387717630344717"
        "17901396914385259151458740234375e-175"},
    {0x1.790d4472e6dbap-578, chars_format::scientific, 455,
        "1."
        "4887562197711446908978121836254756656593526509585899499756689436794712354563618715575348874663612719205860"
        "8812204683915199610533975015269320265559281666130669232952306547433129957755583211217665345578272425010678"
        "2491820289781945266397473512670935662579443028260948228067153672789706239267967937964617523411091552992446"
        "9346136169054560512819064301157801030140723999008663632807032826898858941509657991405075602774164128527800"
        "6989756249822676181793212890625e-174"},
    {0x1.c378249bfd0e6p-577, chars_format::scientific, 454,
        "3."
        "5651743098904664145382811359911180260058861554103089185268982152317863809687513381561548742845716244486591"
        "3339519437222363016273356520765126496768749718777737323105845875880161315828096125505939574746537095716796"
        "8204318690266014998655565144550272896236561789845289241609388463168613747026527843760982680001585378259619"
        "8640242466945887021327694298597975835869968250249240285430911246574479070674348728464172280055825836608818"
        "235617945902049541473388671875e-174"},
    {0x1.012a9572308e5p-576, chars_format::scientific, 454,
        "4."
        "0615954239203778285980217159357064260763320100626199584318312723187831388742625072953964794756680641316452"
        "5187049730893926840073392280738696074481503657716473125301415875810091183435586269507991482810462712565678"
        "0885586781210885206452316190347498731570541051286629973013412217129841564336368659136736331103393064703397"
        "9450485811165942478075559148657607681083750037261710068110348985087259076445035649476524760030822502887559"
        "721784782595932483673095703125e-174"},
    {0x1.56195178ec146p-575, chars_format::scientific, 453,
        "1."
        "0805981132105149879888828194236853539061686084662780914854471675383228243117452879571122473537783026978971"
        "8424874479211805105139792453651861428584866033364818684675278744191346541679918674777914698058883725209587"
        "0918149265106456137485286704653323044943850364593356260109867034399495400691418744678903519925194377801076"
        "2381486731478479183022737197451235240098008967031811463223159118911278393762876998825339197552938830249047"
        "44161176495254039764404296875e-173"},
    {0x1.9d2601c0463a5p-574, chars_format::scientific, 453,
        "2."
        "6100490335909980979552265558355493219704695290513080366093465835681490016799462387973765729881171426828168"
        "2417332590133992921463694477503388807139807845292305705181442388256835168226672308962563672964438490805297"
        "3384732142938193798164642599720638713195222674660177386067424332816501896648413308447588486597263343965697"
        "5571046238161474247493645115957000348819974290112611670238924589617136104709839809219214750270546265831228"
        "53844542987644672393798828125e-173"},
    {0x1.b1a83e573f7bbp-573, chars_format::scientific, 452,
        "5."
        "4792243323914630975072406281613606832261951011145665036504979668985390735600110157767758785050009028843723"
        "3069196872688278263180607019226460569942714717248153474281746765628088520324003473535650431537768304962822"
        "6352434526342626991833896405159190457009628685312050850428276694131688178962296877209863921698707625891704"
        "8767076718398953420167969591438265381595345439024715691196807395095536129593152744587067381250994335672999"
        "1137399338185787200927734375e-173"},
    {0x1.9db5b347aea9fp-572, chars_format::scientific, 452,
        "1."
        "0454380162673489713965397325213210055216387987310910537716239241543349829428624537085690812460149858173021"
        "5858895362945461402133653079036345203985491835929817281954592025413065471497974913996205317355421037620462"
        "5461005863476843387305393280877162550277919224926407850550461402739010315434561658615507741623588071536234"
        "7189767875031969711231284078903547104466269425076082101727424913763945754500035848790708990687509105654839"
        "9137682281434535980224609375e-172"},
    {0x1.3df2e64e62b17p-571, chars_format::scientific, 451,
        "1."
        "6069032799845684304837025898602516055352533047665360898514249707918755589705310767056414015917650944256637"
        "2059407021909524012789333201080366212249374842632041801829250909350915204889376556367323396385595859359363"
        "2026744656404079205066647203536888565373193524222234484027163667384520159643669604080393032721274484448190"
        "1820454994441082559588679931543647630524022363479603462003303851739929994528409740117298461041517310121662"
        "376332096755504608154296875e-172"},
    {0x1.3fb9aff5a09b6p-570, chars_format::scientific, 449,
        "3."
        "2317634556278561328898229389131235973792702732562633280991403487915739132162432712906493266003295399869372"
        "9842545240820838063867420776343008017269498231628387206082119219270972996042897891079135898914037979639792"
        "2628678340369132274813716042402578734967764593771810395739266217871863837169342502454420046781060151049163"
        "8476195268941251133713791394315017124881357339068944310325585037652194459172678551852687153095322614149154"
        "1056893765926361083984375e-172"},
    {0x1.b756a80b08275p-569, chars_format::scientific, 449,
        "8."
        "8816113793007975094594031352311578123949416737178828130854708415442420035465070777620177348898079141507841"
        "7796406238021557467994937388956410627563305885106754023883545285183176270892863135364360578393441082982527"
        "6089987266954588114848541270166660775652880062869381533707804994144812325315805417332298566443583361231344"
        "6487476518149284318543738637159669254492391164491862892635863291851603301999049071455106466738138593086659"
        "9665023386478424072265625e-172"},
    {0x1.f7329a0afd825p-568, chars_format::scientific, 449,
        "2."
        "0345160158699940505892624292575175803854303259223972778922037104994094712540208045167546542096546399329092"
        "5568741352851754686883111360672231989108344218909911608003767338157437940100332128954412292965650257298986"
        "2399508197162346096661909599065879618173136942841150302867570196096215393226563365157688113883373826699019"
        "0133804036385605415722207224450777798150430412030970963249225767509927828485208128706060882323614080746665"
        "4223389923572540283203125e-171"},
    {0x1.0dbb0dd4c3dc6p-567, chars_format::scientific, 447,
        "2."
        "1811364732319512379299888562598205651832586862578556577373471722160887631668486562918227829168345226693356"
        "4477152396005065372978045785609586439600163180898405459353425875008497418764842761473430968015877893142753"
        "7144073637743030489800810787461796351034399996774268268113982329617709594542586517687546529900207424315352"
        "9571645636159086028928066553000090306544475559951765315539204235148847117034688163479628705831991908326017"
        "43750274181365966796875e-171"},
    {0x1.f37273553a82fp-566, chars_format::scientific, 447,
        "8."
        "0774068916080526911822864255084323152268934947928782821744873097715265550575551375438531877561394581122040"
        "9981387823919747733730008958851185059841992813660027980133828742374911473631504963198955136372118833915445"
        "9270356424436854717354034107500870354542325791569854174511255863352105517142777144763847882237666874762494"
        "6628127548310914850138612320071626178258920473997347412686438015422955451063231513707035488791596833380026"
        "50998532772064208984375e-171"},
    {0x1.948f132293c63p-565, chars_format::scientific, 447,
        "1."
        "3085617726519541939747154125479359905912083343808525334106458195989110396773558319983334774985646548651422"
        "4001778904513903298081176394305764399493112846351303350353239502484610555690434248628579595201736161689146"
        "6336607580363322588353007728783819901789415921638100352602461638880220153348552331791239223807821536185010"
        "2983913584124516775569012523471486144188013970774833418807493808520624064940293843848631225035283875968161"
        "73754632472991943359375e-170"},
    {0x1.1ce9174ee8dd1p-564, chars_format::scientific, 446,
        "1."
        "8431087174635782043252618133185158278565571369229321208308841340213027211857844123697256040862519901567725"
        "1326726395183648543716289037081590754301619279792859862700397570904034465465726650754241810398171714853256"
        "1992992808930081880678923005030883215333996109506247186677474230868515683431825040191371852399000466202113"
        "7975049434489578580438315462876494403387379133295692106882124354166769411650396731530785615627010542993957"
        "6424658298492431640625e-170"},
    {0x1.3f6d7ec03ac34p-563, chars_format::scientific, 443,
        "4."
        "1328064925321326743823603312867683387167979700016372758868184808065548286026722508349641027855711185659446"
        "2152961711974203123360596743084083781406915821893135130157239833260145924419520141522508884955957878888182"
        "0404459798243483214581582816502707353740530994471599110522744654340322094456670675212886409515158274968834"
        "8421670736899255799425452401539295289292709073381110625359305055039988110166265680798375337090533321315888"
        "3154392242431640625e-170"},
    {0x1.d271d5b8d56dap-562, chars_format::scientific, 444,
        "1."
        "2069870317233675409785921174121444821305867547484647026031802481804471906324306712077013729055445084455143"
        "3999115380573910887578371341979222946847987949711339523886024386272732747418877700383850969235187003203291"
        "0037612444082501641811469305197024541046308746885012559865055123703620520256489024970530609600773121721925"
        "2509953590142701977279265426554214972769816776184129905490996033298708068601791479909982052198813562426948"
        "91989231109619140625e-169"},
    {0x1.e5620509d2608p-561, chars_format::scientific, 441,
        "2."
        "5119843525307733558434594260816051677090309667396793035381864422174122683981429619725915214786050355950948"
        "6239204789313430961464462590490736435598083042927274138263378247661251164296052912696897186466478706288935"
        "2642748759037672326378535772807239429456532155654974325325269095690646913354309930487294342711006492165995"
        "5315549232098416962449358057714977677229240849969698671418318066142700050605778916770760567089837422827258"
        "70609283447265625e-169"},
    {0x1.daaeb48f4721dp-560, chars_format::scientific, 443,
        "4."
        "9132134419173275300225535204544729851911649970165869483463440887839418340380665622292163306488996250106549"
        "1350976425275433250304984863280428171634552315241314266603032484551607070114757965733712324125396174103372"
        "9226789364662827961018036133320427313617289178588424239333846712216532419601164460554698110560287829079138"
        "8448732419818004683184996584630381592680288467103992938091395362608822911344140526874318952721409914374817"
        "1627521514892578125e-169"},
    {0x1.79db46c531467p-559, chars_format::scientific, 442,
        "7."
        "8220288221977700063059894664378227368411242897337007442348771025734261062567460361432757911617862838819629"
        "3795797162626830091814571929935183642335516230967612876521043115431354642305807169176548620989324925775808"
        "7062177758498404099890663358857738381451506168661384596087031927979812839991222673925208238906810303540299"
        "2951541364381739672960888215163802051676603836709312773313559283595797003584392382939671772845713348942808"
        "806896209716796875e-169"},
    {0x1.5eec2ba1c3720p-558, chars_format::scientific, 437,
        "1."
        "4528932941845978123954041823161320670444209002673199194875936774636685005800572366209642420084980102688522"
        "2284771627441317362560849791307952496665289476714272091976068922300999847479343600358850073272097152220030"
        "2906669435860845485433716289821162240358438688669844790169613107356205858019787842075248471375056422020616"
        "5606463372742572760669498115895300190252052394461218022126572921109385011864418429938794474765018094331026"
        "0772705078125e-168"},
    {0x1.0484bafd678aap-557, chars_format::scientific, 440,
        "2."
        "1572028357831314739248769724465999741271766633293079884733473069385467128577256574275705244906939184117582"
        "9038386984094283473151970125795043177080588238644040574776169825974122573988755713447254935101455602327279"
        "7444385837941145779765796154296050920630528440861628624187628402654542146737760578131033795692117902664174"
        "7620343404617522327136474787371783786459139769882545368567133405075767410255971768401339616616496641654521"
        "2268829345703125e-168"},
    {0x1.6d5d28581864ep-556, chars_format::scientific, 439,
        "6."
        "0507342105712640753626842163097646809308860776311719574201719128177872342977742833188684816835118633113178"
        "7469902672162020402460054333735597377259788893050409419567542473760275232535702628013402757453555954460066"
        "7351435740725219890174284399124917029076743181228148661697596212430136719929459778243961595404978812094624"
        "5720008957977972786818679608200766196761709853673787110020335195594341069592956953993034829863972845487296"
        "581268310546875e-168"},
    {0x1.bb2a34ea37314p-555, chars_format::scientific, 438,
        "1."
        "4678367854256142298667827818101418425641171158235873201689619347389131481467218178604900546424188785128526"
        "8336878307696570650647319626714281180108177890970382493324330201954352563963102778896234442647145321597454"
        "4934864973158225723162874678222498197027137108636727761413525838697942842193364203301906166874401738418313"
        "2646072919751818499258993671664303007808184992375802139546683974996661430648331805870476785003120312467217"
        "44537353515625e-167"},
    {0x1.dda66275c3391p-554, chars_format::scientific, 439,
        "3."
        "1641143055571888721675810050989542109785465028434827969598434513594568939907735780944113164818353072371269"
        "1472274425932244055295948253650409847772105060655087817291808653621495733409941136183312201214290111148995"
        "8367027559058113415177240496976939184069245076394699362838845068654932477476209593443045636001585391168764"
        "0813772856068351759540302693121233132284473037020618452899137221945934076678210757072040593129713670350611"
        "209869384765625e-167"},
    {0x1.ae53c827abeabp-553, chars_format::scientific, 438,
        "5."
        "7012659962131172748331801135657757849545869452984033576198099915159574664118824194511400497947243457984780"
        "5462116330084017885988449660823105199629138988659606033366015659128259656868559311576294716708666983658509"
        "1151417828734600815851793300182954790630057074667385636416663954055631149802259850642458557110755505661731"
        "8968904489469062159847604242814589351698444276015868870497315679527347144186144242694602723986463388428092"
        "00286865234375e-167"},
    {0x1.8a5ef719cc23ep-552, chars_format::scientific, 437,
        "1."
        "0449784962477287548783251955237842370155156614682633486401981005538590595074075877132082832649026253806374"
        "5178776147247109081094734941639330363553681011985727972623039202822527299326384345045236499496566530651968"
        "8594839664257358745546726073837195205368734856443137664431116736502834299388928251796513021111914290343565"
        "8352635759488131161489780485873740697437859266638088959535098381735367626006998759136124022006697487086057"
        "6629638671875e-166"},
    {0x1.0a8013bce024dp-551, chars_format::scientific, 437,
        "1."
        "4123103050632778867079410198580307726871240292054106836891157576370049073328446726336757729842328297539268"
        "7130135769634683967418176373335886121724564479293530828467869228845230209513050262924753268824301017453219"
        "4011901728294090601781190078090265727142204298288503540121641833715510263559360460931322723029926320336771"
        "7097431398505056111687252861128855861691714189014884325150929764686547454902946358012982841501070652157068"
        "2525634765625e-166"},
    {0x1.1c9bc398428f5p-550, chars_format::scientific, 436,
        "3."
        "0165478216464074512212005380921449232249896009416388345909558008845922680766679989900406888605168527800772"
        "9156847515877911950031988284153897746333486898789272568844785705133463127705015634359057096161632900627980"
        "5162991598947429131105988549014486141475892089870149610321000309897505488330122362804139249717716232071224"
        "3561484642920486418632362138024921480131995555150640263619194765536340598175053806517809107390348799526691"
        "436767578125e-166"},
    {0x1.472b04c33821dp-549, chars_format::scientific, 435,
        "6."
        "9352686559745381219629204415882645570340784420147777997532775506263318841002038546151778930213422949524749"
        "7247338585103033841186687904998992673315180478385844272679998694228379216159690401411169743129037832534724"
        "3997549961343698246262935026970483997121083598418491471419947499240108314702249560972217943633149438923305"
        "3529333671768056532410769536588940137956502217616423212346252026017570923308377950355918528657639399170875"
        "54931640625e-166"},
    {0x1.6e2aadc8fb08ep-548, chars_format::scientific, 434,
        "1."
        "5523915631659218211654033359396501132440764681876474497751136639122155364971012804370210703738009265241858"
        "1215759342693384516281140289868088753255070953848917975089495962398728196671418875605246865007097905910819"
        "9194200320736265532747460554648315694463585924985028588151664651715814237876462229975810345451375987064856"
        "1867718950564534290667687163868632147450459471857685230728295838544660435309036072837329811591189354658126"
        "8310546875e-165"},
    {0x1.79e0dd8d6d77bp-547, chars_format::scientific, 434,
        "3."
        "2040881224406470104070105421447199363651981713125257613338523327774736749929132144470271088534670292970793"
        "9332666973487821118966580744192703719425525128891426882244292259084076067532193285611697408370057076213402"
        "0817519404294049135074882815764210025817010708368161243484161145536272444835580693740277441857916573303193"
        "6560847200506946165778530591600551545348474288707176758359411167341011404587763911067099797946866601705551"
        "1474609375e-165"},
    {0x1.50a1c6dcbee64p-546, chars_format::scientific, 431,
        "5."
        "7087065996614392467041253154630145625242817661293175265664196357354858848843609759764525139516246750819154"
        "6800113857365848905498771900411790329918307580100153169495954152713830350478046241412786653023542349115414"
        "6722690420836671854852719370789115313287766786109595137579201772327062305581861872141887474541157775863540"
        "8998524829801519942291352361441050850385032916477495024457844951280632243145740645218211284372955560684204"
        "1015625e-165"},
    {0x1.862c46595aae8p-545, chars_format::scientific, 430,
        "1."
        "3233342513427446533220846176980084180352307495935298772563684034576138699777035986613426588992064096929624"
        "4845573413990218913068901383100060791443228776423588462888697503055590150915018973328299846328628471661195"
        "1393315603019845988865964947204500622134618088187057959743436057427473338804629924458598854986541360321208"
        "3717503132967830519046643299291922805519127421662183480103792153741442023939800520793141913600265979766845"
        "703125e-164"},
    {0x1.abecaaaada1d4p-544, chars_format::scientific, 430,
        "2."
        "9027492682223769245463501295368700005473044084194294943260531463212751655391460399814755446587701909041474"
        "9357432786031241406072562727822572506649901334086394861768322314208033554135758133295052719658033386416436"
        "6820140576973418864131397514691999982985832569462960667909084778059718781902132556507382819564321302015716"
        "3424326728187578875387306118496551002665440241638148086882173459801728850060431597057686303742229938507080"
        "078125e-164"},
    {0x1.27363043a03aep-543, chars_format::scientific, 430,
        "4."
        "0050313185332246980379480793530275790838034216130234269239697945665097491937671792280674809190792923657176"
        "8852195478275993329637976842756444979578128393305680093053021087734539543173563658797050864465135277447744"
        "1606453018747691217753280777119448590588588328443857685929471452269672993927502101792232928640358924482952"
        "3991254114083701145132411140665518759135223474616940250607472942846200812672119440094320452772080898284912"
        "109375e-164"},
    {0x1.f9396910dcb42p-542, chars_format::scientific, 430,
        "1."
        "3708394080755749882353739878794548975711060319922576116897896423058078740860088250207940293013167382216341"
        "9006732222086034323894484084689341216849641479224140162706297861465282366851351586406974904598321862463844"
        "7467632641139961223891013812536479652440735884693444562940524558164549745388180146106893720295017931658690"
        "7829620444413074029684670336457955213142348285380185813403038234527882462121528561738159623928368091583251"
        "953125e-163"},
    {0x1.d5c5aea5e5776p-541, chars_format::scientific, 429,
        "2."
        "5492926252346403699480399559723131522475692333126746007271937061542803045775918073816174245595068744449375"
        "6897045095772044904146125927159052272308828398501309068340258447459074741175325962308804749526641331075081"
        "4215616392500626374978271647156167704249652658943675636494935189465329052215140979594908979807630334047669"
        "7056289062895628727450248207182214063557902486967781907977747553301723845708970372925250558182597160339355"
        "46875e-163"},
    {0x1.9eff9de8438cdp-540, chars_format::scientific, 429,
        "4."
        "5041091507036545799166835714074572890973281642718254791920274591194041492121447735125974303212253865292637"
        "9956781548301884168031234796205554552277059391393411410991884557672724397409012081748646328143893420883989"
        "3697531955943794618870985059845862267848439181439589090531245749517761564002445364628152426757015371501016"
        "3957628881209237239059125078916075999874661387134914030492787980695630969951714916987839387729763984680175"
        "78125e-163"},
    {0x1.35efd2c76fbddp-539, chars_format::scientific, 428,
        "6."
        "7276831657939996199173247920738175748428147489414967017255708514301722548148393714375353958474701042207610"
        "6789338814555349198970333778333109059056976956517846868239691306501960145686115152454044713905123500514611"
        "0075237349741554326342899856503196071852473843842388818767105974929475307629768643213482436875111072007913"
        "1704627264173704339529068829140553825452116336982891479634968447435475896734047296376957092434167861938476"
        "5625e-163"},
    {0x1.153e8699c8ec9p-538, chars_format::scientific, 428,
        "1."
        "2036075452964588496228569301122721156525464871926940161129067123147023586573727518394806164231402726198423"
        "7749837183196555799200371216024834938526447430132500567697920492429156919627160529487552376377185441574529"
        "4149576799984302279677976161507766568997846724405958600191220802794683903667424716117063509411388751879558"
        "6940287978563712681000947575682247836826937306646431995714552203610801101030247650669480208307504653930664"
        "0625e-162"},
    {0x1.a972fefbd352ap-537, chars_format::scientific, 426,
        "3."
        "6940271053456158204818523935502210337755894478159207791982138392485477834969511571329007609766637419171039"
        "2759126610360094205450884682246809737165114335090151986083381777065321763615316038483834946612248296528505"
        "2765157487090496645351674079514261542379781046580777315105509837747199023673206838144493261571740029835395"
        "3756296447509425775852372321989718301071508531673976172450162203846416031360888609924586489796638488769531"
        "25e-162"},
    {0x1.cedcd588064fdp-536, chars_format::scientific, 426,
        "8."
        "0377497486029463796907310997887231749986322040492207560557729723370806214523480524090767477875661565204951"
        "7694248285106989633954680376204841270502625916650274862984725526583670182750426489618103622160278962969969"
        "2859802003702012845796674268710432520262677389871132077322222514180605600807095690066984447887518374820105"
        "1435419316066722225251905327148732308104216510737234667068193476021156773647646787139819934964179992675781"
        "25e-162"},
    {0x1.cb43f5da906adp-535, chars_format::scientific, 426,
        "1."
        "5950567846572765244507927820377824901317858913529875732063943109841715337321381611732771703577489536903502"
        "3493796238094804046934236086714128000654855531067412929636750704890697323743904633485510251869076888268108"
        "4279306285811281206887100844614192075426548612302663962004264088177849786782954944307405424456628148596509"
        "4248487469731734128190901062790141762240880188100041952915632764231981810532090548804262652993202209472656"
        "25e-161"},
    {0x1.cf8a16d1be8a0p-534, chars_format::scientific, 420,
        "3."
        "2198008776677365715483088235590941078068129505484886301991581386389243298290941875520546912655676996881281"
        "0441917229942979342204911774403664097134020776067023160848590990575248460251418985831836138485385022657308"
        "6973362244606926901073831212122632895414679410788205226590464932818260131222656038901409342927690461162453"
        "656396066174341396517780764483920907682608083655719332828054092543457187503008753992617130279541015625e-"
        "161"},
    {0x1.27815078c4b63p-533, chars_format::scientific, 424,
        "4."
        "1052288903310634043960832987571931636234400160954032470064104477855048188571156057943012804319643271386198"
        "9257969872076510180980285118874101869727065976609233032449496732356088241557456578015929237728817932232804"
        "8388309232337303750030778612509711908501951809831162651603726739987027097299398843085135417047599817866157"
        "4272744294799819204667879819235963165001435696452328267353628992418490550875276312581263482570648193359375"
        "e-161"},
    {0x1.94cb793c06293p-532, chars_format::scientific, 424,
        "1."
        "1247015311011619164388570519415046282988509125973527974174792513587997406324036881610609032812580610918323"
        "9424576993216500730132779180552061858976096213910756516933563665760090369803621666784511143304283240882248"
        "5088788757268226486530324074227172828587904589966139213296169528291499631970170151695928941760193584329233"
        "2629190240565533263563800574591121957879184091543084291008630540113777396271643738145940005779266357421875"
        "e-160"},
    {0x1.fb79dd59284acp-531, chars_format::scientific, 421,
        "2."
        "8199919854660424181406498611767457424061948125885429858945745962442848819176197726683136969437028570888108"
        "2830040755467647076905556002995811053078143823884675889610939027344604289894269581058754232110640784754856"
        "3781536173906753112551553439539348939569353136479925510922455594220822191463137765761460800308028834455808"
        "4468684208204756019731248859110647696119656846453414657236217176483616952964439406059682369232177734375e-"
        "160"},
    {0x1.359571ef938a9p-530, chars_format::scientific, 422,
        "3."
        "4406501648078402345831943940992850675010433136247541593007126579014461564621507825989069421046377258353352"
        "5266279480436005810313967603484552689107264291271767543364013759019524730559490934549343018230659686062274"
        "2466309500895727273464880490026271211635573150397503406895568336637245126201262342174169526481361294262605"
        "21133278102774052246731966461848087618487349311800460637664395881218926120936885126866400241851806640625e-"
        "160"},
    {0x1.dc1506c0bf6c7p-529, chars_format::scientific, 422,
        "1."
        "0582157294697288713963195158371767274324188519857217198944098155515218457859889527082041394743997571994198"
        "0782617107314884480425902230968999173789160718211219459793393266039878135868700464888388541483290580441123"
        "4276364643529183272406529036702764173345831700785070362277638232538650696886272801586331584871705734800017"
        "93016274242856198979073331588237555754089321977604226135305401194919294738383541698567569255828857421875e-"
        "159"},
    {0x1.2d2b9e28a6a75p-528, chars_format::scientific, 421,
        "1."
        "3388582036266355541959404316699840795114375100648807498487442232547937540767560212253164334353383449534594"
        "6743958644332602294994034082624978656972696903905477947930595101845262918336444821387696088794686692195304"
        "0167045482466019883897788454591971526214814157238791252917209606217864777959421032096816467916409844038417"
        "2836004474854932106579809179603391993269887733998929837348564227117453384607870248146355152130126953125e-"
        "159"},
    {0x1.bfbb91d629252p-527, chars_format::scientific, 419,
        "3."
        "9808070524262983112904656865346504878132939372419465371210599523355680262235845071654587488829808528826255"
        "3211542596573645028294042617979689261030895068039674263323248377753554749934026854747850685855751439106084"
        "4862583279339947687017283592856642221530763984147033229022671292069654536582029312632080382570358728048793"
        "26080897160088621835645648574210621835117584474315503701422926108310917925336980260908603668212890625e-"
        "159"},
    {0x1.81261e2a2b58ep-526, chars_format::scientific, 418,
        "6."
        "8487446591097199941568879338773260958022232603308129404577395366943751087141371095291924550966687048416161"
        "6769294776395348321020638598156727873424656596843199381833408121608182144007626543586767966079553232265060"
        "0491832255616582246035074672018377924273775286911895790270086967708681272931741809331769970454006868479980"
        "1126128292639790394592107549831084067660125239545389747952523762375420801618020050227642059326171875e-"
        "159"},
    {0x1.baa3429377a6bp-525, chars_format::scientific, 419,
        "1."
        "5742030359655316135314019631790472127126364419477776829501394414493294958623139441874916754684678732509715"
        "8991033070315380568522405485975093110902491134901423225555834565328486328064118867427922601658085650759434"
        "7866705253552661370252961676208893318743217957734924116551774986936407789322905691142636861514631034901222"
        "50101193233407172333537545750830117935069349686134489453548900017576528398421942256391048431396484375e-"
        "158"},
    {0x1.9a907771fab1bp-524, chars_format::scientific, 418,
        "2."
        "9202734088397782914748976105327502984069864360599784056489683368011606263857076661142188306671405159781423"
        "1670256843555408784320151853777095713405165964263539211094938101679106092335341904570196983657111607404300"
        "3839001894312185913020143290160018732262249780193598708143728594996072940408519441822653019593776771607108"
        "4536867135236252471735572482767841378465604833111435732133191744974709536109003238379955291748046875e-"
        "158"},
    {0x1.5ce3039935233p-523, chars_format::scientific, 417,
        "4."
        "9631432238623663477546167552731124003328921514474820413997492211106129001776874436254409714844492300472015"
        "9111477138859528039163853994425999126996609683227170224030873388958268153423145767609226993844753478328382"
        "4259195277427492686885377724220076528946842969848256726439179741579269576223391510486187927658224539225843"
        "413775535462042906286635028827134767522968000184340037184670124670304858227609656751155853271484375e-158"},
    {0x1.b45bcf37c8d61p-522, chars_format::scientific, 417,
        "1."
        "2414975541479182662530661958882288430785834775491841525389411874824159995097885756544225128758410546645621"
        "7648773130036540949365023441814765140175590447946206316753149905087898914730214365332693362747497929964614"
        "0492013260693375349748541774845381848399320823459041716554134838029493474244785198203045687110985403998184"
        "411933091955954072991836879522317775602854761084515929797124356159798708176822401583194732666015625e-157"},
    {0x1.3a2690b025ac3p-521, chars_format::scientific, 416,
        "1."
        "7875996042719942144684408823686534589648628475912376125631821356837144462300068766162676042653370244492773"
        "8923771107674341441242397371908288063262833805963550278795611140294172228349290732312168702927741365063323"
        "5640923880607318621527226861884183570539435102743690701331486754067853858196036273816308192289028030388742"
        "38541139810169708202329862942424051508832654330268286681747402777631350545561872422695159912109375e-157"},
    {0x1.8664d335d8f63p-520, chars_format::scientific, 415,
        "4."
        "4428868657860281376359178678068678828865965144798881231178035166970602687133480970061156378529524002809523"
        "7462616854285876469189545810325410817406934099121471189600341416115425999540048866344895066961885974140878"
        "9048876099387012441921979951172011268855276022497405913799786381336671115842409863056361279540698104879752"
        "3362754888079179316205818081708016426963313589920827914418743898039565465296618640422821044921875e-157"},
    {0x1.a79164aa2fc1ep-519, chars_format::scientific, 413,
        "9."
        "6408509408080923610447309847908498668818477504064378536812604606911138032185873877406416092196184093377840"
        "8732022497546793318629212174366316259374071673186690940671105393994035996979527549102248122127114953365994"
        "2125679052983397494126651483669742329979687385596140269710005813496485982376814623846949071924371149153140"
        "14743723316819620786140512242325153138109329199514885809507713787525062798522412776947021484375e-157"},
    {0x1.2bc49fa39fb10p-518, chars_format::scientific, 410,
        "1."
        "3646071402129266218022608455308893034728544720923587430500970464976763025029439675540553811195474237663235"
        "9523834483010519315791469330342593252278915593622431617814522042082490158690280378293849484627353286026715"
        "5225175793585354441642493367039247804878240514821595105922697779865504810971833579265972782223673414429052"
        "93644749971602789648179855297617277419064627585012540456066432170700863935053348541259765625e-156"},
    {0x1.b2a37c764c384p-517, chars_format::scientific, 411,
        "3."
        "9571324550397298455952293967097384825358953198030980159505341889845628196675999913836798970468837187820324"
        "8478294128925979240194223968807640915113276532656464287084729513579896441131394373033593237548328064981059"
        "5159222317626828045607596436841049015855425001023090510787469983857446377619492592718840110454684657613648"
        "987645086834150321214164087322605627281014744584084104339627430135806207545101642608642578125e-156"},
    {0x1.843ae1ac69ebfp-516, chars_format::scientific, 412,
        "7."
        "0692179366582615531567675897574671091761437361338241149656756895396177633253683272883611099990399246500443"
        "7598258992764058950920726978683938929713281967633418748635447629975311846108340480127933613935207582106283"
        "1418275464323041900377706185784736448842459419508045556665132399047286015752324647790319023015284540485487"
        "1979543351655494158128079536161932019562760201123060264938313679294878966175019741058349609375e-156"},
    {0x1.4a7c9b0be349ep-515, chars_format::scientific, 411,
        "1."
        "2035560157157919813062745372089973915433204195518742166387275134267274407820877716584250745353852034461563"
        "9510290947540420847412015550237264275570830129622833566341709883458286591764701770519397372432417712594848"
        "2712272309929483096695073317289136760663753949010538916406220492776005908179269094318962119052575144800112"
        "517791981236689550651499999859263780522026324949400565011981001362073584459722042083740234375e-155"},
    {0x1.3e27452f4c3ebp-514, chars_format::scientific, 411,
        "2."
        "3172816969783969551891233777943526250416932539763293520394005777040356077947428725088477967218198192385517"
        "9173739379747918200529704692932728516243182940513018768265036831234199951980780926608738288565060565046999"
        "2621982723809517078775790931964018019003000211754865589982252409368493331309771709369251704091173604782777"
        "233093007760038948922133043358862285948249785523761316852198177684840629808604717254638671875e-155"},
    {0x1.b9268d67486d1p-513, chars_format::scientific, 410,
        "6."
        "4262723679026234613089358592151495114322567354938475729446594062899894550316581573372400318968212811428919"
        "6470319876282149819515198919937995775425705761798674673066995193119893788442638742100166477114130792519595"
        "0776140684380624064791666341285838548486494556094652195717677079876446559347047552594588771871315680949382"
        "32717074211917422314413953063196922767011329619070598984098552364230272360146045684814453125e-155"},
    {0x1.4df9e0d56e886p-512, chars_format::scientific, 408,
        "9."
        "7301072362246582992731617268110711029353064013073350453998818620182181804740211694728963191497913793567991"
        "1031034017939591604335701819972757665270952692642901948619176904535218754880890639319149166591492630199955"
        "1633152928738414986716903478505634319202980484473770916202240532708166933819170785587530689982280013134565"
        "017333638307204694287737428192204358891274416205018071845955773824243806302547454833984375e-155"},
    {0x1.7d69eb7260760p-511, chars_format::scientific, 404,
        "2."
        "2224325771347583865914578960158321557360842317854318621134693365709148731046280122802494349067538519750041"
        "3130917810364898093092551411950073674123927781422093946252603565097262860073949138157458136720220464476024"
        "9595881705742112157886504025211275233525917071227188614551772891195644263290147759646936048898544911099912"
        "53573791105880281676020497507543159037307514518111428714064459200017154216766357421875e-154"},
    {0x1.d15b6e4b731adp-510, chars_format::scientific, 408,
        "5."
        "4231128112241111883705509773089298055689258334481416666694017403320776689974726528298409316165705979593427"
        "2651133535944542041523246725633760821160380141790144506211196558566480102602131990816837498306875789723207"
        "6504585427720559612691028995704712640626772361153715821779073508058665270716186992631855993540730057277097"
        "798447449807118198421095187366823174718827741476630255323954088453319855034351348876953125e-154"},
    {0x1.3a5731ca0edd8p-509, chars_format::scientific, 404,
        "7."
        "3264353948817245453789075948016247651899446607642030711491920326112691995960046353812600332536813842352429"
        "1656290504702564770688838031055615174036884610469534126066936299706736185979551439500161693073301855346571"
        "2808422288445892090588535812980025454718642561058682378505086089914779359167555255668678072269653119910078"
        "85637914963465670003796036900151548500417677915741432315144265885464847087860107421875e-154"},
    {0x1.fe9875d1d94dfp-508, chars_format::scientific, 407,
        "2."
        "3801222320149624687970238838551821292683756958494975634914436808747089296715116646167927695091570422907292"
        "6369290928298137726435619308975066477116451778078282790249877308178993242493941303767119336504866436159369"
        "4314583580741034633830247502226974735196463810986401237476592299983502726826416248447495090355412974549206"
        "46488679466589507176571074090805100721695650319541248673971267635351978242397308349609375e-153"},
    {0x1.486c8e4f5125dp-507, chars_format::scientific, 406,
        "3."
        "0618730536691985545579000169222995038373293836922890489125504007146208609330137385438091876811492710859419"
        "4560986809112016677495317703714285414101823358342697061863929398148649681794221820608430077282387116500634"
        "0524333371725021719175453309110948816510168122988585283130771853920058975957661080754853677159756800437879"
        "7317284169074057937506011637447702247448555836796535434274346698657609522342681884765625e-153"},
    {0x1.bfab9b8aca208p-506, chars_format::scientific, 402,
        "8."
        "3471948672359081870252474793852930929195495939030283177039922550551126183653446755773285874366359596754283"
        "2502756933262416846096962919049560927597425906971808170555329109012049943787534763467415849596127066744913"
        "5137335706245812851751344457709710650666087089376367629961851390368065008093519365610537666124040492551911"
        "298472615483739376258107919132264624991379871332686235518849571235477924346923828125e-153"},
    {0x1.6e3eb2a2ebf2cp-505, chars_format::scientific, 403,
        "1."
        "3657896771381836370309182418161048341057689712493955806624448243905928334545004278697729898364093587345786"
        "8865313130892630862358886674091915514194799331994886115738707464006492635762748605607064664260305266934879"
        "0678316930885947176435659031006469277337966316027578384047346694343336071347790439049988766926425966011418"
        "1565996765839548397549385581670407344110642310075487415588213480077683925628662109375e-152"},
    {0x1.6acfd1805e7f2p-504, chars_format::scientific, 403,
        "2."
        "7059739547586404103734020958479760826890651200741852274550973101395207195449636437564463046700627498648696"
        "2573403237486822427240404441709874784114954462792607899085616545057563405007609306607813789573026667536278"
        "0471635363727993881117980818158418505372787172646299938963726825437220330053205315677811360493235151514227"
        "6147452978679714962653853072995287764931503400600565356626248103566467761993408203125e-152"},
    {0x1.fbfdc9be7c4d7p-503, chars_format::scientific, 403,
        "7."
        "5775452971095829834740720048137883659078221730037758958977500243027089042030315562065576850353242510972298"
        "8908820640414600991363246465113659524874333368518080485302807469768102470893345904366988820833134850152267"
        "9233594131683886635586807403560296348126596298935394558714901539292174038185034695148230653865497794789982"
        "7035012684127696551603799048515935761914023675867024820718143018893897533416748046875e-152"},
    {0x1.8b6638a74b1b2p-502, chars_format::scientific, 402,
        "1."
        "1796090875694487081840030359311463862270589279053705811580876107483727824962666775311728890626901753646893"
        "1733577855602836561907239918066053974196590031535933155795041615263196884064656501777212660485632917003723"
        "5553003815414569897105068661910842231236269130833379581876621381560616120996039580011757096732043000870625"
        "476753518672332659627018455181383888174151582106663482818476040847599506378173828125e-151"},
    {0x1.d46dbd2abc6b4p-501, chars_format::scientific, 400,
        "2."
        "7949604896251110474468435743440309945288120594039878056554427992195401617178448765891155578587354824245327"
        "2163051998044291731736689754999480979232786217446696064729498506880523647341315312637248430084916512736609"
        "2938786364110450759620750625707230523155311741574527176683116117371581754805189904683589112934565440671302"
        "7853111244031216018263685608830589461614758717278306221487582661211490631103515625e-151"},
    {0x1.12792046e3030p-500, chars_format::scientific, 397,
        "3."
        "2753828239853733863446369582437710222695184799823949849189206166844715031480630276984905665029410879633325"
        "2127316348030245611596414872858686019667951434279227319113223501530777253893140911875570729889382852881733"
        "7051954380499856181898096431741496302183450840154663766232702257784963092897043278167953142643939679211226"
        "3446829491223785021441382997151012842866613095083039297605864703655242919921875e-151"},
    {0x1.91f97f1e1b12cp-499, chars_format::scientific, 398,
        "9."
        "5938032050821536271229835447916874887997484567576901965829125696937852892456863299883609755835723653544210"
        "2841682756532772118758908073143284830054239179665994380300567905166497888249079872424626223422076411420239"
        "9847393492562247437513415173947998719357558940259847465774991079887176648133578620470314414244635744129631"
        "07645174158017020074996772789705377546508324737573047968908213078975677490234375e-151"},
    {0x1.4b9aea9518c4ep-498, chars_format::scientific, 399,
        "1."
        "5828634475728830814843440523506683765688254183130477711430434290240840477584699481675281765446827769126533"
        "6303593028015611137361963891710823183778865940042147787475049837402666312756010315158359598341391818527548"
        "2488775243582874001862476692842480950276260886343365712468475565010191030391942463146663252915623226414517"
        "974202343217299198758136604105901053848697024317715431607211939990520477294921875e-150"},
    {0x1.1106179212948p-497, chars_format::scientific, 396,
        "2."
        "6064697688781666463934826758520573747383519448492866680729950884307524602126143847451988424868593484060194"
        "1716682978957613938305513748932267449077368268937442295833820496383123332506277430625866887250915854592511"
        "1757800801345831269796185208403514964100000121598690191471297899173032180673797887355522464851068977489807"
        "267142354958247478671324520732786021205706905590204769396223127841949462890625e-150"},
    {0x1.f48d4b7371b3cp-496, chars_format::scientific, 396,
        "9."
        "5572143783563679212569396386714562244314668940940271083529053255203811492473894394483995163236935273856965"
        "1628260530221751772117369080803655866703068176768535686143790764735897463820055564420846715137456754533728"
        "3626211301932389420934134356722717872774848179655096293845502516384809908089594305714462025397850425772483"
        "581964588413924537744877269495840494371863282907497705309651792049407958984375e-150"},
    {0x1.38223e0cf2f9ap-495, chars_format::scientific, 397,
        "1."
        "1919359645157150762151885745871298169469988759647520275617530679373213681293098328176454498212756348418279"
        "1181505556016652016850967697539824481686335844121764077022166174838198246329265529449867422827831499533947"
        "7190052647484303927124340167358793615407569077242194702127961550080648296820459406354990529597216843845630"
        "5496010216053623887351146977264459915664407407831504315254278481006622314453125e-149"},
    {0x1.3e9fe67fedbf6p-494, chars_format::scientific, 396,
        "2."
        "4334447753350621478964908361125060043278078662466547499862131283708984042278535636275983077789926684370094"
        "7924178444565748309990660069844962338807872875732613196406804108645775952673011694052762137127630272887337"
        "9411794872081659295112882233786679511861407738863134690326265257013513191916123647888187047926526116330566"
        "078186068092790478450763659348438420169935536563343703164719045162200927734375e-149"},
    {0x1.bf4f6338b1c00p-493, chars_format::scientific, 386,
        "6."
        "8325195696222758262300152108424437528570430091504730873063246196160570278444533395376186268614032140532264"
        "4888404804519145048373433855904839511702044902178408277990112573516429336486994559408882196722920797431871"
        "2051202804979917404513606924385342451021231548098961032710267504632110823167822434654856228970383578198439"
        "78777235944402878039559477534037323920301787438802421092987060546875e-149"},
    {0x1.1cdba81ed92b1p-492, chars_format::scientific, 395,
        "8."
        "7022316670098795959727408762827482104361505903791877283921876903868602415596437465814520086552230400500984"
        "5672509117962584522015252416171153944623922048021811670715197632594303566335424562084952924302166284271162"
        "0992116548640972021637094804825070765198845261168362052582156148171394464612237005333734915500968164199971"
        "87621877146469562458463689321063101213271639977619997807778418064117431640625e-149"},
    {0x1.e8bded2bf3efbp-491, chars_format::scientific, 395,
        "2."
        "9861508065908777159451976047342515240826688859949110638489858234060840988973359424384553665819870965413447"
        "6256943272501564888338028997374032133260948786678076350777407867941949730285495110740536215009936451824351"
        "0024657283742270237945843651504136068975350045379052042474267029695327356093256084645810010718354716697542"
        "68192542916115180944707276419549670486153214454816406941972672939300537109375e-148"},
    {0x1.8a43b5f93a8bcp-490, chars_format::scientific, 392,
        "4."
        "8178117758993382415252081853649016760029538206499370204986995420250082323503440516020366472603862356528682"
        "2407474487671722791487229578768266569205598375311931512631402861579435514639874109138388148482164551601658"
        "9991338662690181015071509492664273040280948122893995104403874967577075668844761974265722111301155846657648"
        "10221611126794232827586086115464157619836527146617299877107143402099609375e-148"},
    {0x1.7c6fb9421797ap-489, chars_format::scientific, 392,
        "9."
        "2976724414783708703425137615132523255799443671421598073694843277985025047735238958873938469833101210668978"
        "7849419886842856325526502716934419983558360032835835080894125849892846465314091581834698079153876328993648"
        "4730102094049772932148827792590711460754459836901369343119647606860551192961236559861883261715726861152891"
        "43456512542275199984831499038060061146371282347899978049099445343017578125e-148"},
    {0x1.fc4d97b6db260p-488, chars_format::scientific, 388,
        "2."
        "4845337797454605412409621847810516244910538112904300134285148151719670450247219375039112563279547871450070"
        "8261201353671779025865604768841322168996196583909997616168972687643361674751144097063023465593797952596539"
        "3871719212044328488997810247788723400358607298489506003722550735501161314071797972142749009847789793383658"
        "4355771901909066274978117572734548357260564444004558026790618896484375e-147"},
    {0x1.27312209461f8p-487, chars_format::scientific, 389,
        "2."
        "8857361527417207852560816625809604310973138050037527355003547400669847002661975613103114130109031618794874"
        "7123850992698667099033685561487362675009968516001114183271998961003820072099355306942878689026849858227367"
        "0224442596264970542245334711246017142526341026122147120651448137089111639290660393218550072182078704511962"
        "93377558772035164374411778261640681986222034538513980805873870849609375e-147"},
    {0x1.77547904a2effp-486, chars_format::scientific, 391,
        "7."
        "3382987425347269650466241166435692135599525604305813942337856931534257940953624331547168348337623202811632"
        "7675134796928634170492220120827081521431892535790219564289416877103465440408362924506713267045825031797854"
        "8465353673947500213159621357227497454897214905553162925688998444394828308276455932000197241734550930846676"
        "6426135760102477320412501970623396496673507272134884260594844818115234375e-147"},
    {0x1.a21026147064fp-485, chars_format::scientific, 391,
        "1."
        "6347598189352821770450540544887874910462748993562374915104923632121430427394154917169330583508545076873765"
        "8921710993603107178696650209105813061398573309841803393393955858839364145480190924253344292068014980758090"
        "8718275496480021313751877719439275878875402393075928784943183580785470118572485534281639981340542519549125"
        "8920008304407477816080785984194194415675127629583585076034069061279296875e-146"},
    {0x1.e33ffe116dfffp-484, chars_format::scientific, 390,
        "3."
        "7793226434705113646355980315406843842730161819232106915137928260298076813313813372642658016571660158177452"
        "3380558558885463980900241817266548165024945160760116563363642163937498191689679806757915110601496243241433"
        "0499266088828954939790981701152596161360776773445374142941503398715913393644403242726936741616261493580695"
        "326300741215037921072531691842576184736657296525663696229457855224609375e-146"},
    {0x1.0d97cbfb3bcadp-483, chars_format::scientific, 389,
        "4."
        "2167773461430841096168944818744711307173047891677654476328304156506561188571555447146574496467644980277018"
        "9032079619071193887326614005453208506142767585099322327607003777151774727915336623087705415153818142529084"
        "2099630456044653627617275033231662411852557050306840891668696221622591255126538876387262079254791476225386"
        "08157385395783430387663692794943115504935349235893227159976959228515625e-146"},
    {0x1.fc7c669e372e1p-482, chars_format::scientific, 389,
        "1."
        "5906736035433478795666492032411048437699973656947142198913549771963049630784995328887755327128517799168066"
        "4449513987454305753588712869415089089334399246465373968206186757087206883763796426378897368432012105506716"
        "9326875666687873260448935727563546153270143949896632947326143345688646515033756768437592665073003021431039"
        "22720410241795394945083183557178740930027061040163971483707427978515625e-145"},
    {0x1.ca4a36bac00c0p-481, chars_format::scientific, 382,
        "2."
        "8672951771554432303752342207397704874686379593615168937776854662187877340530190070806874633750499494532240"
        "8818988088425644366771375033162476683944430496046660877697340757485633491943820158288520141534155518743581"
        "2767248875572624752948053776526726589546868961296725647676685932179510318584450981563941057488017848730749"
        "7168016508884042466468421161973623156882240436971187591552734375e-145"},
    {0x1.12bf051e55395p-480, chars_format::scientific, 387,
        "3."
        "4379041633188433781391796667234074028435987426722232347622158962219748268262338986398326998553663730733286"
        "9261263118140094455518050615101152124817967901873027097068416097734341519818353755672448406009788972230454"
        "9743586116310371815207363078165968507947562208219568651368309624970888523684513951862673701624317481637524"
        "015502112241292046885060497592168093916598081705160439014434814453125e-145"},
    {0x1.7af60d7aa5967p-479, chars_format::scientific, 386,
        "9."
        "4838962310135761344092396167333415391569688763220398309454881231605306514746244823307718893899616717980139"
        "9057332623091728034184656426130519076454149994764188014351734458633392258002552377150853127295195134676491"
        "6390419819472756495777678716502600107256209456679635005594684631820296766940686808383128006043474601256098"
        "97815494060316512924194566440394549289294445770792663097381591796875e-145"},
    {0x1.b73357a425a97p-478, chars_format::scientific, 386,
        "2."
        "1982900216496951912636237517321659702670798815780532692828188834087902755885019342613033041567821756664960"
        "2016365783841795080898673546344147158231616257438737990978384536904134112934509784794056796055102796462400"
        "1327053575991226081531574192187674082752085759776287241663068738388351272800591961971565145686989428887852"
        "50819213532101900745451840933630816010690978146158158779144287109375e-144"},
    {0x1.cba92c6e719eep-477, chars_format::scientific, 384,
        "4."
        "6013959285449562218784849796417406268924809275050240965117618538701248742081787894298428024850220631495394"
        "8843090919478937616929128000444092637251029405884356250538030864103321329060205766394419703651516351399195"
        "6339704480986356625598760310779666153618027622379329597990176509872185236937051592948849485535253991494778"
        "196501116690165993113720808993516442342297523282468318939208984375e-144"},
    {0x1.8be4634ff76b9p-476, chars_format::scientific, 384,
        "7."
        "9260896178364885712586863338954190885910769204002578873260609825376157123972452672117034283698349000727217"
        "8811914952940248175221547710878388778883291965540342485837401637947057005394455813653078713555099106601674"
        "0526456787922005976420018108523974718072488216371523207019836445781599000049045968896364821326508004681718"
        "328980102387774532495348135674451128807049826718866825103759765625e-144"},
    {0x1.195bb1128d351p-475, chars_format::scientific, 384,
        "1."
        "1266048743457620018132449750109616902012501552632301028746300222772300762831245282635755871042079935221433"
        "0397304252105202227560938436270619441940232384938913439609896370609801593025643499862217542244084349248920"
        "7365678039104096653395735733434216596882709167520981641503247868678058348447755344979159303793136769657451"
        "566731575139884695914882679901314332937545259483158588409423828125e-143"},
    {0x1.d9582810d5991p-474, chars_format::scientific, 383,
        "3."
        "7906989762760977010539296420204713197961323178556125566473600056453448874348023486668990302113409067507642"
        "5512666375287866720556532018498012991417750946868079816281685420092627374913565047968810228895304309081082"
        "7776483853652208363091961204475009565583127525351886644817961845159699988605135294441599824142042948767636"
        "76852096147815252970649825547955202864613966085016727447509765625e-143"},
    {0x1.91dc30400a639p-473, chars_format::scientific, 382,
        "6."
        "4364586827198767306358125396341809950796993470218142142343574880083891301701589050045580411828601056066543"
        "8578613541848555355275084443348178823538223876085347005568276012166754572940813489866481451272426938454005"
        "7688367320099074111805095744115674497205307649349993431268929194537492248042883602140585143587994761332590"
        "5648050990408162049774727642148519635156844742596149444580078125e-143"},
    {0x1.bb4959cd66718p-472, chars_format::scientific, 379,
        "1."
        "4199943377251187537949675350005079423187700022228758326221521640526029521346740953695783399936936600872287"
        "4407753705401513284671140970518928691753252515077837559669042688180179223137869737013695121637086330367906"
        "0473230296854766707360327968674338036515155027602470266905967351968056368459849948118636405588195957644242"
        "8067625960673098033625050273798251510015688836574554443359375e-142"},
    {0x1.cab1b98b3b707p-471, chars_format::scientific, 381,
        "2."
        "9387007315399001337843467140701947490646533646383646741168981933069251261075266021456186550679433594978996"
        "7239321904345156747275229367729995831822884324397633531132361947458460677520772536493144275246577960215862"
        "2313197512447305365216189939904546876264703794084991693455204003412709032881758809299262428136448855311663"
        "929317040733753824545242128163380357364076189696788787841796875e-142"},
    {0x1.513f97a6beae4p-470, chars_format::scientific, 378,
        "4."
        "3212757508195659485508065379853979844500716301246743150152785223009553880036241184640287335154013264357096"
        "0952043271132202966879024207483585271608519582168701354278018371563475097472078209541866054396550301840853"
        "5752782166921273364856333578679926605858330352242829232861196385760569862934221186030844482600416992243969"
        "322617877399178251164590935928799808607436716556549072265625e-142"},
    {0x1.23ddda4aa4f46p-469, chars_format::scientific, 378,
        "7."
        "4795674901009501599687387979276428028217065964050376989668893383691257823806867042515842078744474517031407"
        "1895485469191115831640711419412290132762704670408024637792177786766340048068468354031068962246601535160186"
        "2349167111369075434108876998189806009451657247710719467572422765836922739389375015650257781352180780599630"
        "217854761888887876568332568893993084202520549297332763671875e-142"},
    {0x1.37ee070b3fb77p-468, chars_format::scientific, 379,
        "1."
        "5987439857085749128543979468421347404798369339619842909758538091544906123513224004714621004604317341155476"
        "4830277704469716857696790698012386358199581778604043428049370268894875238346646052337439645510118935311304"
        "5871567381746415270150272493696335723627439701097622331692153552932290372744776405111128360907502878298528"
        "8180585511628949125194354419221554053365252912044525146484375e-141"},
    {0x1.7a3e814f7c455p-467, chars_format::scientific, 378,
        "3."
        "8772543479398745912495310674542245392251289103259487422362584185221005555927613777493177235835548528117811"
        "8302432240933992624204868787463842883298566251264050405797426114438754525206002596249474935519087677964390"
        "0013313472242863345433568164189149550863949526447244598726165343683113264168124346368742549505223090492057"
        "351838011423203673479209729890726521261967718601226806640625e-141"},
    {0x1.b008ef4139a7dp-466, chars_format::scientific, 377,
        "8."
        "8572904580841789614754232711686396959759290995923259860158443209002812929627074824889999094798269835513254"
        "0998845477274750334005664050117293551284426384679313859709553221587795313680157822564176364684723674516690"
        "2000693415871071595853995191227910934758948131752454927512504000367582800588546292331716557590430260551314"
        "49871016536323016683784903335663329926319420337677001953125e-141"},
    {0x1.6a3ceca142f25p-465, chars_format::scientific, 377,
        "1."
        "4852721614344735437292541639963060443263141102043656353372955189549517666043979043032187958942357980893037"
        "0840252848547401622923075567638582241455382956074528344237666272700101153478685493953250306368486765749182"
        "4332905746273268182840421417991838003237060783473024229840428934381790407194987886288409466183411626302457"
        "65429564945800410859233497973264093161560595035552978515625e-140"},
    {0x1.879c5a128f335p-464, chars_format::scientific, 376,
        "3."
        "2114166221217845174327447115992392374668964402329268800963712003830340521992537289583647041045528110284263"
        "5303499515391399834686408526191662512438001577893564043814181085298234246800586801045226636006748241313130"
        "7522786571652361908511927539092360053210712569816779695997967844462040278748911843877424273521146041902588"
        "5846797137206727786040705296954911318607628345489501953125e-140"},
    {0x1.a13b758752749p-463, chars_format::scientific, 375,
        "6."
        "8430533321006578298315622206827888634375564457496296600363690350980619762819624331006890836920053795052268"
        "8370402495113279403328072887329458087656201260342686767845714173996590984304971343366016453921898634106206"
        "7674396745885910406868827681945359154367703453121597743174729503689380057241534775569646829196396378247871"
        "130136170076470499001874969735581544227898120880126953125e-140"},
    {0x1.dd22c5548b2a9p-462, chars_format::scientific, 375,
        "1."
        "5651071039519719751268946730433209491685269599788420485953219030692473518449901649555366566818121803846373"
        "5680904417760697692262477792647738252648295215490091671889157286396107620561142080138411428231115221654909"
        "9455747381869282054756781298103540835711990016306871443323392685777042535287304513633281869348053796759051"
        "449311207979673589429925328886383795179426670074462890625e-139"},
    {0x1.3a466b3b9a35dp-461, chars_format::scientific, 374,
        "2."
        "0617783292012132110048484524577034708763801812806846889421937147593782421046544694512376644429350834218531"
        "4226530713713824082127126656554247991288683437918042715199973601623635055616074512412883505084857003066123"
        "3050190132621333636152617574413419624138051138995646737549047491952163495322980116587422304830212863807167"
        "57918646594494906099104269969757297076284885406494140625e-139"},
    {0x1.af63dcdd336f2p-460, chars_format::scientific, 372,
        "5."
        "6602054122048727921826190049712048498669146495554482077926052213769892391972155107823538731408874729899034"
        "6792194827829660599641240756981656489830070688868731818918413640802502222925430134747083688070474879030296"
        "9738046971386503460831112186107202194534175784137625129392628895158265668499896268624088807818901523078678"
        "889008399162559304063080389823880977928638458251953125e-139"},
    {0x1.6ec02ea745f7cp-459, chars_format::scientific, 370,
        "9."
        "6241634559974588550470031663368349943378831463927445452058900881064926118183848091052345386686684876344532"
        "6161315986809133600636497090313419475443507804928279463021903686529521982727237277282770740989981019500686"
        "5574824665465743137968830206089146401495465235722508613312222305895849308346944245441317410343774024309939"
        "3609930015773545886048623287933878600597381591796875e-139"},
    {0x1.9e78dd35e6f36p-458, chars_format::scientific, 371,
        "2."
        "1752909285251191697648113699053702637727489520541042360582333721279125948156690408463090424584646923549518"
        "0942992131659468643940147628854434370427060263285244175515322077650246922688324052450302930384427072839475"
        "7842492386837881192332322824075015094377235565634494864419445464055485911488407505261872310932269115328920"
        "21280816813831593403705255695967935025691986083984375e-138"},
    {0x1.9a585f80bab85p-457, chars_format::scientific, 371,
        "4."
        "3072629120188103249512398775746221992085610716624708892374467991779261742776439264109609536390646567234426"
        "7525349801934937730247292561608380009185242796805519587479768507806463318749894112461752099897976376679226"
        "5859716833133142309161784445679684796923222134468302918127430999767436216601957379453800307851317225326157"
        "33040986549275130901293096030713059008121490478515625e-138"},
    {0x1.a6e65ba502986p-456, chars_format::scientific, 369,
        "8."
        "8780896980845694512355699450135667167474608494983516478858968409659482574692196941169154704757494026767065"
        "0881004269664970292068439515226078190024902892002557556809749308704779003267551048192576495608146500136488"
        "5058786848795066433476360168510321692410412462444936724066019551372571776922263017000926269477966339109356"
        "079124769044186304967070100246928632259368896484375e-138"},
    {0x1.2041239e921cap-455, chars_format::scientific, 369,
        "1."
        "2102860505856427441863506911416438557648140836421513056577062373671144072180353513990930639340259058767237"
        "3257099356704235139962445699680300772732754695176822292468996066789589373242949311404414022027874115262780"
        "8785308312747064770780467959018293493486808663697190464543529527135601732353052334628323918972488583866538"
        "415926878032025104658941927482374012470245361328125e-137"},
    {0x1.e2c2206571f8bp-454, chars_format::scientific, 369,
        "4."
        "0538881189604874758994800103224482110424419984906922206717025596060356483137003469609681462381640957524317"
        "2911889262541296693730039817442824706217992206174740879595790963900654804304187742835595325686164988374589"
        "0322213024653290007771883621311168396610036064921521154842858228344839533773793548383142400170080167454900"
        "059158143070525692763794722850434482097625732421875e-137"},
    {0x1.264bf10d7be2cp-453, chars_format::scientific, 366,
        "4."
        "9426210322338252635572061070906968405888216870034632652951803647003944472039593835210475205592373220399127"
        "7018801884718299712534752193391140108918824839767655067751800656957226981466137842744520790572580634924148"
        "3459928010949501467461950221909399691687985514158948841431923008834959479285883564251332461521178735704628"
        "190938091092387907110605738125741481781005859375e-137"},
    {0x1.cad3f14cb1924p-452, chars_format::scientific, 366,
        "1."
        "5411744957634478558732875158007911309742643791263152383028800246394250010301841139543420118207407753920760"
        "3218589797015836084381494407933290832598692742653536345116174588473355663138399758752109216617072642962120"
        "7135842117636071464132112769695338048041137489524235515090494741996883492492346460319710822961304962419452"
        "460110382008284801713671186007559299468994140625e-136"},
    {0x1.4a043fb92141ep-451, chars_format::scientific, 366,
        "2."
        "2170106143596450609014218157804357964381470241171242549541903911649755928696395840283489106316089146427743"
        "5062966705933777580211869707929056934148231613404163981973357636235389342669699272984120998848954292369787"
        "2554428392780018075983672770091316945354715295754269008522521640290584844958554224663146563346799785217835"
        "259873951636588884639422758482396602630615234375e-136"},
    {0x1.d91f605f33ee8p-450, chars_format::scientific, 363,
        "6."
        "3567575408975392743526724403263859606835265005008746398722782311228825240165088104697549263316148656313234"
        "6426578332847489634158927173716225287463270003583594203279044269022582967257937898723790101285177867709597"
        "6655741399044978428732881345094886140578723570628664975737909788927071910708005133352031145300938446489913"
        "435412388853507081876159645617008209228515625e-136"},
    {0x1.653fd37ce380bp-449, chars_format::scientific, 365,
        "9."
        "5998267065455804136465170482547947366999684488969626917464974228247748059445435327953748521367236770367453"
        "1451560088375242660031278793518034857995227061963548088366069731985696736508405628059744476431105501074451"
        "7632659439131361488912251913663824732302366424969441750856521571686454336063947389316836480712814735548475"
        "72435787250721972441169782541692256927490234375e-136"},
    {0x1.ea583b86883d5p-448, chars_format::scientific, 365,
        "2."
        "6352597315051091964713257494843957096579268453980939881002664775610008832253360604307895378781817021575772"
        "2131262889797575381102714481443132987139497702786597756696037753098692013672145953687801073867566319294992"
        "8316534778995707013335990382676469114470866914005971164662199459123732837094223290390067459830854578717031"
        "59650651759893236203424748964607715606689453125e-135"},
    {0x1.9caa8f7dd9b8cp-447, chars_format::scientific, 362,
        "4."
        "4355852076232533703967017722389898945821857225058681977965240699080262887084660386234585786609389805397653"
        "6231928757581244511544360492016168686756363796237882797468921698797356010241314741136892145667049203620013"
        "8721847402285626290068242713216335744583762528489836802234047080678004035672934625936455690987526985520882"
        "90749606525054105077288113534450531005859375e-135"},
    {0x1.0b26a7ab62a03p-446, chars_format::scientific, 363,
        "5."
        "7429993366141817840812479753542746382814749094420490827347512947579020362059688082352895775572141852211758"
        "0909348864872030450848171956721649351848205979835186312573993891506062416099298516603424161994426165270037"
        "7907106153840215329576081676331897976487016666661306584555944953024603245394667724116557668613623517681616"
        "016498924448541174569982104003429412841796875e-135"},
    {0x1.694c9672ecb8dp-445, chars_format::scientific, 363,
        "1."
        "5533843624429323819438527942729951888826684224818085321658052959257745308554358873724455989172691764656869"
        "5293047034140544314292313264389433797659762881589730183326362518440901757090487907181989255445273967251973"
        "5593544269570691464381471936515939828758279599762414292837467494719157630828112902620254122175049117795947"
        "993016236754471037784242071211338043212890625e-134"},
    {0x1.15ca8f95f7163p-444, chars_format::scientific, 362,
        "2."
        "3886940472478101815516002304586010705250369950263278520937586735205575920300597436987445133566199723253520"
        "9056220889611772034033406268425620639481665338487162539900951615422228233639702916913751658371808451818416"
        "1750465910278224501683266661880297864234626506047662879560009369157585287147781138669192147467158593106463"
        "12523018774953698084573261439800262451171875e-134"},
    {0x1.1c2c03dc16238p-443, chars_format::scientific, 358,
        "4."
        "8871215235872988435170790037236813375378604405677194217241718090326866560500874834949274333014957336071556"
        "9022758867015207526151988895553482901234999063630370884845462854314493655716813545090738801982175971799897"
        "9421127360512136790705971320293037416921996157365427902453505027610932303474146785641141022275140400955070"
        "0580088999913641600869596004486083984375e-134"},
    {0x1.5e495a5a5b735p-442, chars_format::scientific, 361,
        "1."
        "2048289504187995891459061440516981076638732120771659218926621650385434481812842556576460656624351028821905"
        "8966625819337939917796520503670154154436651304901717368743143186394807699935909156584679015642358410947459"
        "3413689541976548679931460273314635130483027907981785192792081387152832558721199653564067984309737744271471"
        "8438765419961100633372552692890167236328125e-133"},
    {0x1.810f44c622e44p-441, chars_format::scientific, 358,
        "2."
        "6488657681982224362975086519642031326070653599531695491298942136575989842374130913957574220303933630452909"
        "4287691741966627719771032423495762254409444179311243835772567386195458292994705194115642989850139200494159"
        "0588928963306893800268427406521691881809325113789150170542748396344959084162370306735064676678771923231964"
        "9187434862369627808220684528350830078125e-133"},
    {0x1.97653902c35a8p-440, chars_format::scientific, 356,
        "5."
        "6050315915746605269229572281796709012860726683120704776540492198506714810181021008440854108255765850085384"
        "6529071987618814344910087704317888361861949507041571302535319807153374858734455612866387542618405871469146"
        "7962651372264615689058812238015769309640382466140672015426133338338772381569455413477985178391665863290374"
        "56071233691545785404741764068603515625e-133"},
    {0x1.d0b06982197c4p-439, chars_format::scientific, 357,
        "1."
        "2786580967537967393170156267226710383127074452677704468202081316753593149446278054272379462839378967644636"
        "6320800166067176943939047031161439109805642265774803971575385755561407104084377645079662000061709133084688"
        "8569611013370819364101411249570919954868002270900165871976213924414176953438451896858275740510024279521401"
        "890935550227368366904556751251220703125e-132"},
    {0x1.7ad59dce3307dp-438, chars_format::scientific, 358,
        "2."
        "0848335483911190942323580514455303482680343446709325008703159284449727956557371856834417264871825204784953"
        "9318713541842166242449663027334071210292408400120764346191285493915664731350155622020867542388811251124441"
        "8594782642109557636315727983442346610806562372007733240534067389665742275872183681831213869255187963209097"
        "8955449855902770650573074817657470703125e-132"},
    {0x1.22c47def048eap-437, chars_format::scientific, 356,
        "3."
        "2003528362030216678821821948371825837897558579366430203164885731689848020333537717135124881473922701620992"
        "2888692730907506242357242214089838597240338986102464283276271560347056644198372344751496698973482209898323"
        "6068759470619965482251995605014430152608968389315404259797294622728604564411967070087013194247143227410060"
        "11785458440499496646225452423095703125e-132"},
    {0x1.d3be4f543da5fp-436, chars_format::scientific, 357,
        "1."
        "0296499233307166051409990566706604558221380043891789602456125181542044296852211953765862019485098933960139"
        "4420734357402502486292275942333853238461193404309849063372198452914528639370611863498197972678354451284120"
        "4496073458814758724065894241925219977128262975118574813009362420632733150442614970604109796889529120935379"
        "002954590532681322656571865081787109375e-131"},
    {0x1.fd62fa30b36b6p-435, chars_format::scientific, 355,
        "2."
        "2426394767283500572344787579772127805358981710503513931978178996544410137352679575618851857302903865882730"
        "1751992291035654960112926310959345577460789432200950261826623585506549029505895986246328713415363125428407"
        "0821805771156523871968356216030311242150331649720790515554019625705236196928987062872353517240543707960548"
        "3585709180260892026126384735107421875e-131"},
    {0x1.170603dbe87b6p-434, chars_format::scientific, 354,
        "2."
        "4568729171490546923419108015884002973420344879350156891911357332634520808703214918225650257080313080960162"
        "1140390889672566806744097301945489507607449341174694978874620449423462236080322660186527317970438773249144"
        "3371566819375998762229137926757890994877314033084529060250209190344653250494453969941105882736470645243131"
        "993851193328737281262874603271484375e-131"},
    {0x1.77ea54b4399ecp-433, chars_format::scientific, 352,
        "6."
        "6200607960369036504168364221207739485773877228613560172975009101038528445698754193218898779976326154511917"
        "3363842872316641841962349364203859251798613207224032137413479473949030378760712878146559509391806548214262"
        "6133671636697690281002255506343628331447342616711548975819904164047980593449147058277505601860937669428386"
        "3429291159263812005519866943359375e-131"},
    {0x1.93170d7796999p-432, chars_format::scientific, 354,
        "1."
        "4197241995605936318075317043001757935035457049201291955866575822547697829794624951982915510254185587423055"
        "9487389305607751617582700679057839905945613876060209570099889526685608968859022154545165173060918859596578"
        "4720429445370267692111528854939925241769500649591614777352662374519950927507309951396734409084237509869608"
        "206969360253424383699893951416015625e-130"},
    {0x1.ff784c52bc952p-431, chars_format::scientific, 352,
        "3."
        "6028982430553334107374243676082305559955741670713515214432745189797018506318167441511937904497465065161068"
        "2213475903496748485769939459318413756361660218138899061663084963748999691972507933997769029036491031713027"
        "2509703637802374239144100499997431894236097897299940723946702573929557957332859418318120851204621000324346"
        "2693944820784963667392730712890625e-130"},
    {0x1.5af297257d112p-430, chars_format::scientific, 351,
        "4."
        "8879393706963279061651865580809295809985896396271068785213668870613554247017676426461356877587014324609933"
        "2229707765029557354523950224816865264246462861886095699349276602653803989153158999090858568594116436322403"
        "7664050403023168762797067327883280705896601134110886320862615955338992676555453042929182604106022776158102"
        "516319559072144329547882080078125e-130"},
    {0x1.03b2ee82074fbp-429, chars_format::scientific, 351,
        "7."
        "3174892255233898487807636785800529379525766260573968879990028870309082137226413786970703775409476682616810"
        "4680726241144403907247560017629565271829849434655181507428399984635472560338317561978206370575594884945710"
        "7129514927443108698035930496633435099731335354533972538276537731498433942868404311764137596868821065976273"
        "843034505262039601802825927734375e-130"},
    {0x1.9fc2b88614a46p-428, chars_format::scientific, 350,
        "2."
        "3429620296922070165437262528679235149465662294858826443217125037749387447136789889409314083302682771001468"
        "0222756477338010049488544385369435757883115124974928734552290063202520905298185016474992670850977943921244"
        "0228311467969508963451461485549943141147936657095208040273361231910217912547166432836108378900052615079196"
        "98260593577288091182708740234375e-129"},
    {0x1.1c19bcdca8429p-427, chars_format::scientific, 350,
        "3."
        "2020192787585524090907938204703897171601201083956022918880219758055616705464752170779213045668342297853927"
        "6218514141557210930831458346531846588992803118289362499502577922826432688268564989495048351325555007141628"
        "6759032612040821481599308776899597909970425095316884308438864676280665908537781294443748170602858163502624"
        "22247396898455917835235595703125e-129"},
    {0x1.1d050f4eefbe3p-426, chars_format::scientific, 349,
        "6."
        "4247592636344160339866493641672423120493138167713318610601027318726114587010038633956202506757668116896117"
        "7536260327713435210153350074908844036866886983227957128782764805685483552587503499283051807011191846971140"
        "8579142730695650817051390788544338188841755967937911393061842504818190481891870009980858467139430006964673"
        "2254113885574042797088623046875e-129"},
    {0x1.11c71a2da956ap-425, chars_format::scientific, 348,
        "1."
        "2342695551721854116452683863845499880701888817578316467000565057081031681549617905907560256885144592305226"
        "7240083781534046249220963683438736274553173251428809235268476409175105649982640214427984817459457410804145"
        "4897293931112550425507422822024993325841784631941211847062895362538601302639805927337145199863994993183524"
        "684354779310524463653564453125e-128"},
    {0x1.ee81e63a1dbb5p-424, chars_format::scientific, 348,
        "4."
        "4587660431030845738140444950938925800210778297935183932030487301692384916913432314579352529747020633396157"
        "6718982792226559730910116675387121867734619940500817757656699817860412688243739129436110739866715672133838"
        "5429894258111317173503504684713165635003661117654688712321287868251005918630130709379141148930754401380482"
        "931926962919533252716064453125e-128"},
    {0x1.dc836471938d0p-423, chars_format::scientific, 343,
        "8."
        "5930403540130827014185033574850155045437600585425997369866718416666609027827328902822137151134768600284621"
        "6279124762562562326885970331685674789827255964644127407691554650046050256430460386721430959519718823793955"
        "1008802980430695929352329472514508171419493761170181627352450560922451007920075807096848500427066497309169"
        "7902418673038482666015625e-128"},
    {0x1.55264a312e91bp-422, chars_format::scientific, 347,
        "1."
        "2304010474281754010997831364457453532363710534547555388355590377279653877735542614715890519378694731622300"
        "6782910963684928592070655580364056608821698264700123403236140552502228229389995505527297808002861636424769"
        "2131602981552825675357276743670326242029680867553906299343023194677184192076335608358703832152999946281113"
        "35259745828807353973388671875e-127"},
    {0x1.652956524c153p-421, chars_format::scientific, 346,
        "2."
        "5763001930484683121866989543781242187607596461670705046008890509721150477966409285424037614285381953347765"
        "4997259597310460635607291805673065230273042570734235752898997793752366928544966510763348120931402869337506"
        "0230754644492619570048227210977560174685317157897957914242825662416808322569345838414941963958465498407690"
        "5748224817216396331787109375e-127"},
    {0x1.0a2b6e525e678p-420, chars_format::scientific, 342,
        "3."
        "8399042293533291316095939321676303114799213077840440281919805704609059805275974287633226980837249931736591"
        "0044710145437381439295690008968031009068382843451057480056121258710576890301225315461825406976833128757025"
        "0854349786862226002299989130792880255411596025381026026745679225130052848864003625387812494718087208411816"
        "391162574291229248046875e-127"},
    {0x1.80f3cf53f1e56p-419, chars_format::scientific, 344,
        "1."
        "1107053483914006829775982286940992882599488872595391539303723414330261552652730527139790712226602314231212"
        "7419956658436525690382907755165110589877692458034515109141334121688675583164152180022072392038346677920997"
        "8618498763060489316670378435241139862270569941618445758195740528710132038842602464041533659108718090635647"
        "96815626323223114013671875e-126"},
    {0x1.c6389b5e53ad6p-418, chars_format::scientific, 343,
        "2."
        "6211336846809098773276314685119387768693234190106735856477190922246722065339865398519354564344593251621915"
        "8248983511966078734456230097679988912873164107313981697736934498486708329908151477908573290741613410601556"
        "0829130407628536830946616731021905982268502134836446565495063653291366241897645429462270546400182169577419"
        "6996353566646575927734375e-126"},
    {0x1.55b26db32be1ep-417, chars_format::scientific, 342,
        "3."
        "9436012113465104438175990673990938076352359286600886903149796902820550632115347356375237735627780655402675"
        "8184464885274554100597829193095879346435654863845212628185087858146802889576223211174464307298442034499394"
        "8110429433813295989818119876936942903021691744560733604484421618817074472770713269558092405053795204139532"
        "870613038539886474609375e-126"},
    {0x1.e8a41e7181c02p-416, chars_format::scientific, 342,
        "1."
        "1279031828486725368285162812517936169788860166634935888590711537150219574688036629032895212853463959440650"
        "3650154654466484722168943018596890328292712388739910978936869648015362134240447110651890664773510091035844"
        "5188415389113650373815757025479195624246867750482014684485575007572491946959890442186741528474147600036303"
        "629167377948760986328125e-125"},
    {0x1.2667eea0c2e95p-415, chars_format::scientific, 342,
        "1."
        "3591220818753578967877485753540957219846849806734534544651217267891770002384398001643363339942878637947316"
        "6328302358041252417529977510170575717126095134299788618696349062141833073414504245591187769088276321436054"
        "8305459034386167488920945628442896474526151212066690180059060509561977041122748851645894198336694813633584"
        "999479353427886962890625e-125"},
    {0x1.ff118baa5e05bp-414, chars_format::scientific, 341,
        "4."
        "7186848778189670994069605940876219782781216914711086309942798924493013128851790778946762990913058749981445"
        "4055147105208148185524779392795023211756732677794200342825699871430136909959253091552973875772042184950963"
        "8515139692290002872112044140465990852885558676453756553237897954025802506482414042289106823058197903719701"
        "57139003276824951171875e-125"},
    {0x1.fa00c13d0ddaap-413, chars_format::scientific, 339,
        "9."
        "3438288096510300708206359179854147909888509692470353687641927888677731435274230558789286142542238872497991"
        "9291642304056969254290225288534313592005499287342065072705040637147124194333306505257478080943345820147523"
        "3518790218936634917638256885277056259540461483126252396164441218119171308576411058848150414934963237101328"
        "559219837188720703125e-125"},
    {0x1.665b3a489008ep-412, chars_format::scientific, 339,
        "1."
        "3234786366979427240557035972871836642676524574733744100764337150714243649312395488035954592443876672160155"
        "2453328962421458549925648630711638265850295574292128380162020867890736183395718452916357821887276692711606"
        "0686026545609252412900499832587222722510252054321150497353766705080322145596004049998388463205145626488956"
        "622779369354248046875e-124"},
    {0x1.cf3a6f79862cbp-411, chars_format::scientific, 339,
        "3."
        "4215813214105460697767882447548971368626256994487285819832925973102312220381249502362412524582654137714631"
        "1911755533093525433960566479878897896249684215009582527023317672508250867310488454244976076546569023883629"
        "7191957544621034981392176942003185295012273726522451681136015314107273762726204980959797408157641029902151"
        "785790920257568359375e-124"},
    {0x1.f2a92a57319d6p-410, chars_format::scientific, 337,
        "7."
        "3665992405027932576502815813307644287807305675409422460506005018551902720267819605398541423809769647828049"
        "9866977319501776335044121496578337140066670655016184682180563483630646645866140852592448554624381952636290"
        "6038236009913051704692368907667120951434121614917932393108410626345799351846363141934487250850338568852748"
        "7218379974365234375e-124"},
    {0x1.b4782f812a1a6p-409, chars_format::scientific, 337,
        "1."
        "2895722651891137630425330384438299474095155094770258996582306778094406533114323313551750471068869202418567"
        "6514306684322130376192414829153873010105653873073220980942636936455031716866157608940595168933427613117398"
        "1279045829482843002519751437286808742894695158893832137633512513924892098960289256708716676413928325928281"
        "9926738739013671875e-123"},
    {0x1.ee7af34b365e0p-408, chars_format::scientific, 332,
        "2."
        "9219365150591819869806878286596392558866811418403158078032655046272755506560359880667466294148560229158569"
        "4781151191877485626592838708956568599966689642307979951883892138750321041592672907937811096196078953938914"
        "7880920600844784042147871987802138706797121319153428637095263913657634075401623927059624463709042174741625"
        "78582763671875e-123"},
    {0x1.14a9643bbe260p-407, chars_format::scientific, 331,
        "3."
        "2696466282687585616618735095593104865627521210668173946224068440449703487453341173667423751071123364783968"
        "4085354894924673886100417360021334173102821673101378406750581340715944228625674542170598795643367302528327"
        "5837865087998562936760655026168055781811414767475009002774837970555003650418701005575528029112319927662611"
        "0076904296875e-123"},
    {0x1.0ec395f04cef9p-406, chars_format::scientific, 335,
        "6."
        "3998932062842191571304885686437603344672159589284746987272459342086482985695887045504776020852483783906536"
        "2172506322079792471903631811738029238588537100394070287934331478185936935198191455534087534416095445119132"
        "7942135351924917315670514758298955554619991631363968830288155815152759638969869613114860307234721403801813"
        "72165679931640625e-123"},
    {0x1.3d46e281947e6p-405, chars_format::scientific, 334,
        "1."
        "4998583170769895145258239667197277367953253255810089766774812142211547445430103147393926520164148452565746"
        "8217264380338598104855388663677112214256453366606244072120286151220936656003436396679154181835015100676359"
        "0584348966466807600606971155966424574894203639782754137091303494195009152389539124755613030970380350481718"
        "7786102294921875e-122"},
    {0x1.5d50c95200fb7p-404, chars_format::scientific, 334,
        "3."
        "3026285632030961027430781526695104834652824763749934105342216592027767938527528216746021154719645500132460"
        "6616794372108054609285611564286855905212986858383047108185221762771718705161049816532541785396613413881621"
        "2217761748227152819627098792981544023621850913148052426306024200164421671955248312885222716772659623529762"
        "0296478271484375e-122"},
    {0x1.31ebbf8025802p-403, chars_format::scientific, 332,
        "5."
        "7847010173866356658135714751782132458915473391965410419281395217763813953559535968598835173728934249636260"
        "1391514459957848282287968614420455369316177721591679287181702700396345255239479649102860468456508414192128"
        "5765602981762140026015686251155088703174799414546865824038807089051963687735763777753028591632755706086754"
        "79888916015625e-122"},
    {0x1.45f7b06a1b161p-402, chars_format::scientific, 333,
        "1."
        "2327531669436545124898364942880066252999983643906149889220149845403378792647983133165166313028540606985070"
        "0818436949056057893055823679249585303051312488233045352968305435308456249734196737179082525750979594444667"
        "7228676476284721228550824045540658730028149589335013698528738527418574216139323697360996590077775181271135"
        "807037353515625e-121"},
    {0x1.df4f5a7e05b4cp-401, chars_format::scientific, 330,
        "3."
        "6253358049975739948158532959144013335613046749062970323972515958518272146127656397527061651233015893692867"
        "0103303942817509059905956200910147442693283287995230815845232814920748801039202484840625264268960547701839"
        "4461232562723775452393614394463284378370218080769149758857505694173512387676848456319333990904851816594600"
        "677490234375e-121"},
    {0x1.ae574f97a96fap-400, chars_format::scientific, 330,
        "6."
        "5099035263477567697676239505583198082407067935910598028302046053953016881173914627929885947779143472525852"
        "9119807135344605329826410498881079099916276669949098538219094433024528915815827831019768695616878227040110"
        "4253286553344639621446432482400791768130297624278687916140708336692433937814041000624598609647364355623722"
        "076416015625e-121"},
    {0x1.5682e2e154108p-399, chars_format::scientific, 328,
        "1."
        "0362549937904696495909186260047111788995618647637336817784404369937467772175933363337212662356207536735218"
        "8030101548183531660454669558507451081374831816640389350098116044525532899664635039328699336476198997181098"
        "1611054570213321448002855193018317174796322288015370915456149081441713079385774642915407639520708471536636"
        "3525390625e-120"},
    {0x1.d4e64d894ea04p-398, chars_format::scientific, 328,
        "2."
        "8372763744588855358195664212326247986525884317469934762680318091318529844306906832798118576979789563617608"
        "7880787247738178476250311898177500090645985936560651576500379515533764989527583633204112961828419907248472"
        "3993397281384249852781206296581626131873567108627993360107656068926314295395446629655111792089883238077163"
        "6962890625e-120"},
    {0x1.8405785281eebp-397, chars_format::scientific, 329,
        "4."
        "6957762796709737155545272375088190271165041022145719332035280937122606597820767289040881062663178655971790"
        "6800163258532738477839926886177406049478443972511824178578427468672843486576511058856103122000518325560094"
        "9669432592376902045278403406836799158321502945965980280664261537807858390208490262374141366308322176337242"
        "12646484375e-120"},
    {0x1.7eb41af181b1fp-396, chars_format::scientific, 328,
        "9."
        "2628413735990423976072574727831848085171853809438809598495177277610358137788162151768704610738207393586717"
        "6239925229724538135518882743778801921512445790917757600220464043852992967680900899632107966724376688268527"
        "6343517164257771308795820514969012334125522761495819641199962003503392009209210788966970540059264749288558"
        "9599609375e-120"},
    {0x1.812947dca7db4p-395, chars_format::scientific, 326,
        "1."
        "8644654417675819487878768291262887764232591738129708040196998864550979088967279045136490762476499773291512"
        "9620812439715211609748176949969393845599259659318287218077670995102127035337504860737911557372641561128410"
        "5183442729822976469520193988570188951048643143750502460453397587635942242792475020962683629477396607398986"
        "81640625e-119"},
    {0x1.9e33a8306e02cp-394, chars_format::scientific, 325,
        "4."
        "0100862103638260260327403702106109516070843800804666499770138974502808794721389200773475598343085572822186"
        "9050575652000849999783616094397321798140965240453403340309552058549632349997838495783548076103129101125761"
        "4639151880210011426990683848939531260460233147640120904706864264441669009481072905032306152861565351486206"
        "0546875e-119"},
    {0x1.fc59e1a319ca7p-393, chars_format::scientific, 326,
        "9."
        "8431817833160122601313212773122942893409910851546209354885728127108295688976875179174547748983566433413213"
        "2025798622516539150550515346244583769585261311971860204677532235067528321744733234706537880403917023842260"
        "7574806660943207182365054888572670670918103919236001613298781456569337992498769374094536033226177096366882"
        "32421875e-119"},
    {0x1.ea48053546540p-392, chars_format::scientific, 320,
        "1."
        "8986595125046416834783391206475835197011693029669966155263156671691418830838428529139208448680176162863118"
        "7695816852367151953603093414023513472452231891026909148753713286042719755834756149864024108431735261809022"
        "0909719089204136527578336674363112487531886729182570991963930462755397177154748078464763239026069641113281"
        "25e-118"},
    {0x1.c4f7cfd35c403p-391, chars_format::scientific, 325,
        "3."
        "5083205445088968495677101873388169021587210288068562220603066512276293052810916395438868133171298860873211"
        "5906573028050475979768658205494632257575125878903299547717299838346765905333055749041027617447665836622709"
        "1941304109695520879458424636283604303800109503244258137414372793865533547291724048022842907812446355819702"
        "1484375e-118"},
    {0x1.3f1b2c8eb7534p-390, chars_format::scientific, 322,
        "4."
        "9430715648584051844621127511504766932271831089032969572932369896232697013659331467295126281359728019366715"
        "0223703961334976370441319425264759617856817683619261680544917442005575369381757511402108712309881085300325"
        "0818301375453449086706715170921583482977020013786182723813883417931808877954225067696825135499238967895507"
        "8125e-118"},
    {0x1.d06093b0815cfp-389, chars_format::scientific, 324,
        "1."
        "4386748780689463441172008927045007293630513034969496905804592655018261534900625376938437377392865739866729"
        "6615558447456358810107305126537258821495219592310542410906686690234000177678885634217857624515847833430176"
        "1013692954086773103893646129885982191773115862652319223214584781092291281001660507854467141442000865936279"
        "296875e-117"},
    {0x1.5f088215f30e9p-388, chars_format::scientific, 323,
        "2."
        "1750535480226043651063968030552837701335419048796120873289665746737982864577869182423674166128902294355190"
        "2567578863327434873478216467219071537837824503113360190943651743419094244810729043431689094699067495426602"
        "4495878370083247028266065338479497333757962125955769283174403691587467726820115387909027049317955970764160"
        "15625e-117"},
    {0x1.1ee7b2b7ec4dfp-387, chars_format::scientific, 322,
        "3."
        "5554120237464134602694119759921381410530091439238523194592402342557057246628016063414378639043829736854188"
        "7370053506577563972296682322952558114285158990250458154246016563621912592790284052637737715198370177263940"
        "5405211316069492320708638950783578941509117218036792610026741347911943130766232457062869798392057418823242"
        "1875e-117"},
    {0x1.e5212858a9ac0p-386, chars_format::scientific, 316,
        "1."
        "2023735450313651421171538785871176726817036060881631127943497279521174527072830335195052010261740485366509"
        "7035885847417422710449856594985414474195173129388921911481901258066228860986222371389439608412512086611891"
        "34406624290828135248622000380630662078487158618897919413632808909031535193889794754795730113983154296875e-"
        "116"},
    {0x1.e5a64b660de0fp-385, chars_format::scientific, 321,
        "2."
        "4073250149223043677529942257093521551685293966172209099803476112751766606813967498557515485126803686976280"
        "2509846959709723111928491817829971430314205791200580751789038145211771394494147327366858698467104394248895"
        "4039058477399630531971831293463019719488441957560055472393256961109557490186006134536000899970531463623046"
        "875e-116"},
    {0x1.a4a35c112380cp-384, chars_format::scientific, 318,
        "4."
        "1701370789218155692754228746962316110046975782997471789899742477944413513185760207420533618377892337282650"
        "3369609111243586518876985010803989860785855249416361813452820232507673882731452960098324300662753351543989"
        "0605798534521182860496797973742972290515095803870329475781942164640259118613130340236239135265350341796875"
        "e-116"},
    {0x1.fd84aa058b587p-383, chars_format::scientific, 320,
        "1."
        "0102559419519475794201171450381673041089322627018053899889380695208263228396234959442210305668054031580026"
        "2617175361107992065273974530599080955152985761274225519088885807436325575834309377713847614939429333357521"
        "3736221842600597238671029059811607467346072347130676068618442925385256248027587844262598082423210144042968"
        "75e-115"},
    {0x1.8cdbd7659dbbep-382, chars_format::scientific, 318,
        "1."
        "5737569358633547811206080917170425167450411520103815909249604594369345874856545245212805027522831482869727"
        "9497837821986319825226191691030482601360852618520169586052322172410999244763978900894391063989290727442929"
        "3647733654219928166653100454479140789463860010824500467182821754168198236101261500152759253978729248046875"
        "e-115"},
    {0x1.c3fab70ff77d5p-381, chars_format::scientific, 318,
        "3."
        "5846791147293954395277110210507684652698239680639314917967800036918115365251759384633992808617776665470287"
        "8948196800507852844357586424000876576667554483947866806149903563073606011829317396890873012538987787373457"
        "9886342475181978767165737092606523456123743582322344239764951045502938686837524073780514299869537353515625"
        "e-115"},
    {0x1.92f9eb50ba810p-380, chars_format::scientific, 313,
        "6."
        "3920642274634331751536794408261143575334629993511050648872666338672571665986021735206183246506631631027507"
        "6674090520833858863401291192443279548090882698094889561395443424178066943634531052696735508613482077083274"
        "38532663382585063040866730643823561567323258792113871334440201865678687909166910685598850250244140625e-"
        "115"},
    {0x1.e5d12025f41a4p-379, chars_format::scientific, 315,
        "1."
        "5412187845587148647082679443541904930956627197223735714308064939313678370864379713857586412466743837378721"
        "4477045757622973435427658211214451056290469467722605684096423425588572056824523259270347609435702307410245"
        "0187989051299157133388192780303421949264106738071728509661029345167992943288481910713016986846923828125e-"
        "114"},
    {0x1.70cc20b16cbc5p-378, chars_format::scientific, 316,
        "2."
        "3399657115069453242799372427454858441916409637026741437784068092438045672968038993507346705421009607546622"
        "3270999126531558453930448337869948963043039837440559106704597253256508416121847397066754992986499963921290"
        "46637675265839770011966526475548357054437982946807154687712923708808876455123026971705257892608642578125e-"
        "114"},
    {0x1.f8f54258baa23p-377, chars_format::scientific, 315,
        "6."
        "4077707249453147734571294870181459497973836656567528268148064225575734467252266106733401529485664591286872"
        "5537475815263199419956592789659795423138900495943348557937327067031684374451512495466067674240016165733527"
        "8642566121441607503387428396992405649535766870058376239570482012231078527975114411674439907073974609375e-"
        "114"},
    {0x1.b425d7b5baa7ep-376, chars_format::scientific, 314,
        "1."
        "1069178065391464118041197835859986853981823370991214279644651068058195236576781864336459899685058699818985"
        "8389076952457334918508095427607000023790685113724227614589746900778059551210150285899771549942676809335780"
        "216735649319371255941752281553265395319094745377493328576212587577298762653299490921199321746826171875e-"
        "113"},
    {0x1.35f98a9945d86p-375, chars_format::scientific, 313,
        "1."
        "5733958801672790951911831966450540333286901510422187698245081061936132440082110172995513811552188806194750"
        "8483008380141477614143817728347389618471096913538493454947739839883504613082714342355282868320572300743114"
        "95047375197878671140995642548351193717183402608319281064104371015144323564527439884841442108154296875e-"
        "113"},
    {0x1.22b6deb90a23ap-374, chars_format::scientific, 312,
        "2."
        "9512643039682987271607130402882275984250978924222980866335903775679967461152359642908392339478572995711210"
        "6711158137101871047341964134538644022448223316135917805111115721985676440930948226211551129468067801597918"
        "4580368796271490374849056743260859362475989065448386808516480217523536566659458912909030914306640625e-"
        "113"},
    {0x1.af8b9b949bd33p-373, chars_format::scientific, 312,
        "8."
        "7618958399039475289411495157932994119285940106393630296173005536001515294054979103676044947610677490024580"
        "6433762089986893052332064562978271936803143494243928200924114342896992504891165235980509540813946170682297"
        "3867935359995281054682095411461508824847074251216971999141856775050740679944283328950405120849609375e-"
        "113"},
    {0x1.6717d5464b378p-372, chars_format::scientific, 309,
        "1."
        "4581718353001727202767958474568085509641315254096668946517258054929653338668760014668801958991413536588583"
        "2166422613380830543504451930921550793798367298723049105942703198978517102345816708317809381648497621791749"
        "0144653395402570757209661432587925807640507185377121211582174264975719779613427817821502685546875e-112"},
    {0x1.e82648ff239bbp-371, chars_format::scientific, 311,
        "3."
        "9644645414828138173162257943342753791936726404197770155908477143700013008038105686863030846404367750060424"
        "4814244967592799688033858650321919135290377962541541757670567069855566579894393167253937584463430211194847"
        "838410815447232136167099214308805859745088063782002314890638705602299296515411697328090667724609375e-112"},
    {0x1.e51cfb8657ce3p-370, chars_format::scientific, 310,
        "7."
        "8796103616943104296862864926637808976384305685460046349264971296098085718108590424082442044168977749480870"
        "2928472617532638674178490816260470459625717085681235305001720392192877266453685066566192314061292465692667"
        "01975452020742004266052294229064688879217955185466426624822655622182310253265313804149627685546875e-112"},
    {0x1.b14f77ac7c51dp-369, chars_format::scientific, 310,
        "1."
        "4076373030698913279542894696649495363335439496734696510065477536845414461119135429499341627348207442652927"
        "4935947857370618330448711125058799086304561047878820957561978470428392090947171839593614746022113900576819"
        "12459797630302957798856517266927440740025132710425346247752609318837357932352460920810699462890625e-111"},
    {0x1.e710d0676d8ecp-368, chars_format::scientific, 307,
        "3."
        "1645295789429928436647975840549801301515330036544211466830277436202701723604780666991621823155867912659398"
        "1980338448054215434328683248511272110006708490433287132241742891859869273554563583159617428780711727619231"
        "33899979676544387692632814983780063270773577183589647492112373328154717455618083477020263671875e-111"},
    {0x1.681e2130ddae1p-367, chars_format::scientific, 308,
        "4."
        "6794637406214600552685009184111994631046788070673294911846952958589294261135845244842000381052918421797166"
        "3686856630365424161431494428961656868717060092984824469137024087943584804835372179942601678375223467571832"
        "515625537071561402276458569226060997833551855877904268772582430102602302213199436664581298828125e-111"},
    {0x1.a823fd627c74ep-366, chars_format::scientific, 307,
        "1."
        "1022787950727771717610943243155103519105415962234389134639983375075983585745388621128252129251831360374758"
        "7200078501494916601004074837757884294948649378776832588867301852289741497219317204928696589057736588055220"
        "25872507231167222528685303920977870186585482457331214116436068906068612704984843730926513671875e-110"},
    {0x1.4154d3aa34c6ap-365, chars_format::scientific, 306,
        "1."
        "6701855515857908584747803132448487756483101832993797232975308804071919095972790016154322704905670927038588"
        "0494132185610153140585022535102018358801929938831640361250668541664980168293360212741724810288220079797390"
        "6720466201397769120663869839685513950245652908075809535415334750041438383050262928009033203125e-110"},
    {0x1.3a9ba6e00a75bp-364, chars_format::scientific, 306,
        "3."
        "2704792321346139269395198188310864980762772459780219667337880506418288619313658795189633157901844118202961"
        "7959899821736910033629581384546366449781130238868918794233156215017316457250215443260494499049530118568527"
        "2846413113018197664085143742641569449064726380745830695839782009670670959167182445526123046875e-110"},
    {0x1.a63e2539171bcp-363, chars_format::scientific, 303,
        "8."
        "7787729275384650464205839686581567124783107846404487702633668032504537138009690656495102209028217361135521"
        "8390388558973430219290482843591529548434600383846735395604846042341730293207372906214891355297527580963516"
        "0087896703692795742861281764048566296912514108556450931342141075219842605292797088623046875e-110"},
    {0x1.5945227d7951cp-362, chars_format::scientific, 303,
        "1."
        "4356894911231067898171923164012923523397719956349474652622401817264054835179242430812570726867562039556960"
        "9395820536576981686866835269785818676298857562755446418526260219235762960808818683579213832173570812722647"
        "1309299601555074913893102541253974308888834531656129855914372228653519414365291595458984375e-109"},
    {0x1.82217c782aac0p-361, chars_format::scientific, 298,
        "3."
        "2111903570682555570830432285106056350808268235667287036759585960084214919407425089581154098784074762322198"
        "4762123193423025747805649805390981226048331145080309572679467705818692956022292826723774128752395133008996"
        "84678865465498234764125959913015552026947590190386616626483373693190515041351318359375e-109"},
    {0x1.098f6dbee458dp-360, chars_format::scientific, 303,
        "4."
        "4169724909246743271783375837700448384399037383754852175667172815642110900066699080460389447141005868057730"
        "0512595879015513339295564000425906636050874382230874106442651414859196934264601320288039760451686440122377"
        "9211715551095402858460824838483699891256643499837415689501796123295207507908344268798828125e-109"},
    {0x1.fc1a3e0355565p-359, chars_format::scientific, 303,
        "1."
        "6902188100294218634935247637485270281651549319941796535330082790416249513368727689884420951594130215709004"
        "0184990306867018953130130856037669985663887665299573761002835240263686645156373136524713074576393774585196"
        "6064973879549502996367695229140698130020298981164052209980042107417830266058444976806640625e-108"},
    {0x1.9d22abb8a3e58p-358, chars_format::scientific, 299,
        "2."
        "7486157518272163198462750357234962521840564791749654630448944205121330934304735487728385237098477486960962"
        "5847974164498179204746922062216049657612246741906384781995063278488580462198784747628586625522717685501064"
        "683276474702628786475061222493509474216607179307414465796455260715447366237640380859375e-108"},
    {0x1.8fe6b364f92bap-357, chars_format::scientific, 300,
        "5."
        "3211348201503955918326994712215674983015794087547371314733947107537140792678543657825063978585635866620708"
        "4197313956182668385962971395188922621807236400003448458010002652773369381707765820726202495191307008424796"
        "4985873179224173871150940905947186618917750283892786899997418004204519093036651611328125e-108"},
    {0x1.3924fbdf3f4afp-356, chars_format::scientific, 300,
        "8."
        "3334785623935782116298108685266686643370574881636034800871153561094144663382514150166540391974744686871180"
        "6417987830668578413862355044420640648941380509579676293326802058743764083969551154493102801167674568470045"
        "4921274138664102521131689349566080338539705656651646048516113296500407159328460693359375e-108"},
    {0x1.59bba3abc92e5p-355, chars_format::scientific, 300,
        "1."
        "8401463566583057000467205063624781534185149195807291439532371443811570882259925022763641473815090371969689"
        "0884731353588984692080088307661553053498541608357827654845057209245110680041052095293937588746057055307668"
        "5104080099519938253964156154017020428131091156799536978638798245810903608798980712890625e-107"},
    {0x1.f91ab28f6d8d2p-354, chars_format::scientific, 298,
        "5."
        "3767844238622670481304274663876506600784579490273356231591616804154663121136971131851337071593432079006723"
        "0801406917418121743555085258692970299942364812832124045965349670231901635472698014492910758725217321403406"
        "44845226572809529157488064473891307432846836840412141356182473828084766864776611328125e-107"},
    {0x1.29815f4575ee9p-353, chars_format::scientific, 298,
        "6."
        "3338293748065631419556714682364874673867676285049644451673425924784138630592498292679137715512703719066539"
        "9099547436808253509249037923744258894826392480910340657908008256358036815594577611142878960404510461173969"
        "42666747803151643950824239942570360031580162414599488585054132272489368915557861328125e-107"},
    {0x1.9b5549ca69f66p-352, chars_format::scientific, 297,
        "1."
        "7514400642486577219423056529958168455121436480387689214857689064489248433753353045222356747974792138413681"
        "2907705310492578831489120381580810440200883241625934295912642633798054015146534242980319769381134505869389"
        "4271570763602292963970708357409197599381992481448744314320720150135457515716552734375e-106"},
    {0x1.124b975a88735p-351, chars_format::scientific, 297,
        "2."
        "3358765579576565334772675826735107157872544630083091706192581114916616667385249065695562210242645649633370"
        "6045442624764341660639114681090349749985529232191675913872702599912722915102318783709303584090894615368605"
        "3705913497996218739612629046751784994643955963022907695858521037735044956207275390625e-106"},
    {0x1.1562e3a0ec3f5p-350, chars_format::scientific, 296,
        "4."
        "7243986610495878878673984778734765597249236867292989667607298760616960219054966616029202455795780518195146"
        "5005795973444987034101304350852038218864051288571350765414212230181767935792865589673805453295871045943135"
        "218617322658165475074435295648383851079801960815007788596631144173443317413330078125e-106"},
    {0x1.7499ec4ac4fbap-349, chars_format::scientific, 295,
        "1."
        "2692169671992971794859529307417627065586882159206511522850272309303557550875672875281941705264110562532404"
        "3962157386294274558513375437279520372365842188678652778085743847538559542383103862214745631648353208671844"
        "45964579981005077479106468489233703280283545311579729286677320487797260284423828125e-105"},
    {0x1.2027f877e5c8cp-348, chars_format::scientific, 293,
        "1."
        "9631316012898760223014058906912067489377912540647879826283094146946912960752087047972415846827587026831640"
        "8529836716359055729125867701272323663315317923152316903512706305527763621084339310460970385816269376507207"
        "732386773493842387889323502724040878468329818229420880015823058784008026123046875e-105"},
    {0x1.3ebd90e3fdeb4p-347, chars_format::scientific, 292,
        "4."
        "3429894872560729418193397434044195297928892591241402688768517638740285594212782549821378697599010953184725"
        "0001479148556894299716929279968971252973761365088083456011722548856128988536198502330225503216761835636784"
        "70959217821493701938086947191985055989095487749551693923422135412693023681640625e-105"},
    {0x1.4363389eb80c6p-346, chars_format::scientific, 292,
        "8."
        "8126165753911829296073940994630312372578087100698810179318575514900600400132302692737889199062390479419949"
        "8337013660830380592269111943379641150657051580457441463012673490810863644239815703741098676074978193264928"
        "62699285514009118677994236229754579522131796576189799452549777925014495849609375e-105"},
    {0x1.36a0109bf8851p-345, chars_format::scientific, 293,
        "1."
        "6929662136678211488078955588025689249252946388568113517812621468398839813210730900263559495041405947214123"
        "3023424598961524341866409500482279716433603612382080707599516239910317980701008812896983399390264869857599"
        "436031413554009831686140961859092949411305373264013951484230346977710723876953125e-104"},
    {0x1.852936e8160a8p-344, chars_format::scientific, 289,
        "4."
        "2420016230315380894459699263590074580121107948381560051483582623204545213465113172292812816818464247780754"
        "9945914113013415578186602251423255710110678586170729782875957266034899743601335079915348892173656670268744"
        "05553342866483389551396854187976397966564068298112033517099916934967041015625e-104"},
    {0x1.149ec7bfca2e1p-343, chars_format::scientific, 291,
        "6."
        "0305298093927812974371236707006850466550484837899433998791788439447945090567504761728273446428158503828027"
        "3815680772046816887312242613127654618110699752592730180526202629349727603958501864226949792627071804458332"
        "9530560909162178292548227844095570554690255438146095912088640034198760986328125e-104"},
    {0x1.5b2dc6b83f4d5p-342, chars_format::scientific, 291,
        "1."
        "5137520077480203129736786547797218619270753778448891209064918076463125636944869989096240366834149603449714"
        "9622117214819752421125106211299219496197133556427938606464103348868389804966690375917611422685068708804532"
        "8321041443260516963902382193582509786917988936494339213822968304157257080078125e-103"},
    {0x1.da0f73386d67dp-341, chars_format::scientific, 290,
        "4."
        "1339493171608475510736380563699750629156862226280416325731522075378368999604060724669971773099651206101216"
        "1017546178458942728313191490202170666992385689982184609191280290273663347725787965403909863535334056723463"
        "899330281266936838654482799695804640972840449109071414568461477756500244140625e-103"},
    {0x1.638d3b1ba2bd5p-340, chars_format::scientific, 289,
        "6."
        "2010359315134640090731319437049206220696431274480364487068426341395584546604605252648624919716507113178716"
        "4770913020638743635294940380183735409118973050619962086116661476750520741067204022527272515483696214789128"
        "06267420333330775690907300282423840649681512360302804154343903064727783203125e-103"},
    {0x1.906c98f786defp-339, chars_format::scientific, 289,
        "1."
        "3967279728811321015556380205763949708026110141846978466576526561943061094238322509857317048680101516109209"
        "4059480169304313282251175137756521835472643562161874889067638864262324158569496198868632887339727876854190"
        "94620032800056105071229529844130628872533872453232106636278331279754638671875e-102"},
    {0x1.758b9ef75765dp-338, chars_format::scientific, 288,
        "2."
        "6059428457609154486911302444167565685187311533784113372214336570808417256412519024956191525183770555440174"
        "2351821205386265043059591636376635678882878599304488236849642358298092440065200725936048618574206149773742"
        "6327712363547867434874089592920722198432503802223436650820076465606689453125e-102"},
    {0x1.7b53efecb0cb7p-337, chars_format::scientific, 287,
        "5."
        "2925657186107486696662256436218499175870505461474569242666233854160474625850779906598158267271520849939229"
        "4202392215141578825785317356572899446095010353693470459520062697277725597854451377947127151669409262676817"
        "805963710919477975920904905105901332162954275872834841720759868621826171875e-102"},
    {0x1.c70cdb03862e1p-336, chars_format::scientific, 287,
        "1."
        "2698160651847152511134198109881258456142759956828081770588497598811394283191928496354871928599416248545921"
        "2624831316216668122250847400605418281738828454092443406664370924540263061336400427843941139863146710024305"
        "866123781960021918923744815065946835164201189627419807948172092437744140625e-101"},
    {0x1.c8620f3a56118p-335, chars_format::scientific, 283,
        "2."
        "5470706341249348902221902622568371957573968152993335291114182491469056877577567806133288792502362191377384"
        "1104198106509806681478945672264147381937969112303470510735230530092792306517987071863243310330652402455664"
        "18482483161473301224825995891891394773409729168633930385112762451171875e-101"},
    {0x1.6de527d45ec04p-334, chars_format::scientific, 283,
        "4."
        "0841165079066422503311958952355012554890105582329316527378510871501269657351408619401715479431010259110172"
        "7331888613681649927397941295691701840380977033084709459930029994062241909437403184233652851218799652841192"
        "43738253055377647337106095646631909179546937593840993940830230712890625e-101"},
    {0x1.32f4268de3560p-333, chars_format::scientific, 279,
        "6."
        "8524262499820672910465946411140257927338084441301598854658498719088905756918548930722944195040062465232121"
        "2741194099526199284333586848262300092485070516184133947332196308672745095179576985257273100178992879756211"
        "3861611774779207012072627762389043226676221820525825023651123046875e-101"},
    {0x1.9504d4e40f114p-332, chars_format::scientific, 282,
        "1."
        "8083260374699234761065257773418498730106022787616035325598600451327358187952165471790323439179847122950235"
        "8546322993371696334394192802862629454251406168400743329730917576310927470940241674403303605819271810565651"
        "3295101069735058671395240667729986672185304996673949062824249267578125e-100"},
    {0x1.cb9bf91a5cf2ep-331, chars_format::scientific, 282,
        "4."
        "1041218769683543865527782587708994321977282570253751835355176353868356467589133067113662048462713562786916"
        "3689797540950303302913366392376656159255697944455891223668807057168630685792060203335559517088803685034984"
        "6654097283173859379552553760216182521247674230835400521755218505859375e-100"},
    {0x1.534d1a72353b2p-330, chars_format::scientific, 281,
        "6."
        "0596402508961119571296495219413977960985088664161517023286865497038758610911606257218864532266059908463494"
        "3566866588930258825411622537414066336047894439146752568610278062157672883821538692535856116708042779936221"
        "736077402161935015293480030935946434311745179002173244953155517578125e-100"},
    {0x1.8a81f0ebdd183p-329, chars_format::scientific, 282,
        "1."
        "4091162264655094096918422902209131451813071235940686704267979933905629962370860646608701739601729195398426"
        "0348123961816264514026789687986440107830948993608087358064153065552612602602023499720117578184592448397117"
        "4376577529462311334822327015502130276303205391741357743740081787109375e-99"},
    {0x1.2d8d843b6d359p-328, chars_format::scientific, 281,
        "2."
        "1541940438019324865167028884178297080890453228868603437885007477923378991221330760569498464981192644981579"
        "9086766356008861141722682975426269705872292139055342559529362293475470513544579470179567050581508580483092"
        "766000531858470043399035620014514424980234252871014177799224853515625e-99"},
    {0x1.5ae523c56234fp-327, chars_format::scientific, 280,
        "4."
        "9562087398984028798002675205915029145934162551746287076478264141066334902604617021355261270418382502703079"
        "9012887618525302370636569884647253237361252245553836239316100690838738298913987463032565645940507442438449"
        "71395465018007039720702891320847083278522404725663363933563232421875e-99"},
    {0x1.2e2fba4d55710p-326, chars_format::scientific, 275,
        "8."
        "6348821682352886680448613345699107777997779283593013133209274283334866227298574857315844433891549697529806"
        "3967453807178597920834220273761421926245222790190624072541898839336096889584915861533631101787200214097731"
        "755254463696422798459940983750726672951714135706424713134765625e-99"},
    {0x1.a8866b54f8da1p-325, chars_format::scientific, 279,
        "2."
        "4261340414990349785900555645144753836486017984360325092686326468941813894749700948319279369699030354562016"
        "2128067628714222500858744515024250725224913377594619406969777600338582044025172737970786616230297899138581"
        "5415528011949603900100570948172862273395367083139717578887939453125e-98"},
    {0x1.f1a5726eaf292p-324, chars_format::scientific, 277,
        "5."
        "6880342032875110801140107811674257242681040973129201120356046066242525206668362776013267547666870081864709"
        "8697301511059933888881427408978800238200024191730958421845191572140573277862850372978086195948703239443239"
        "55228780749141742495715752536700193786600721068680286407470703125e-98"},
    {0x1.449fb8851eff0p-323, chars_format::scientific, 273,
        "7."
        "4208207048148695360887516750671585448954709948122751839360897930189242396581441749888939165021423228508336"
        "3595829634393473133215432271177697513478113798725154449792965648309451308710292572224103743993982360407449"
        "6105070814565044206960464645561614815960638225078582763671875e-98"},
    {0x1.46c05ddbb1318p-322, chars_format::scientific, 274,
        "1."
        "4938910681786228098433397618427083905000278780570950467448198038274216732657666002119768524178303625459142"
        "8113514269539148166937605854031616806544458143119642972251690661738492452061452603871892869715803063032290"
        "16720368895964772527028274762272985753952525556087493896484375e-97"},
    {0x1.6b11a7ad03ce8p-321, chars_format::scientific, 273,
        "3."
        "3198659912779944591755497965186522112578908724555826481398937929092451620495530950235419850252258210723507"
        "6103357799725303807187723552061327603203139944318751411700583753118403087341835633246108094769809451825572"
        "8458429841924240692903336213959164524567313492298126220703125e-97"},
    {0x1.35af01f0d426cp-320, chars_format::scientific, 273,
        "5."
        "6634316286537580410549627430526563174209683489552393365657133589081290878698891065102827260170613964063421"
        "7988490623562854632880516016770172038156097146354316708909596705851523980277831473118340477805634968266611"
        "0387736739752007997066030053900931306998245418071746826171875e-97"},
    {0x1.dcbfadb8b3393p-319, chars_format::scientific, 275,
        "1."
        "7437369721819611306370401524320874706796587550801634394374128782974215775486231933474204434212241812954672"
        "2253205431824225310790378426225749581112311746779383635732956570294552148059878128300037030766362232845415"
        "610269516394232537279639083660498499739333055913448333740234375e-96"},
    {0x1.e33f175f87825p-318, chars_format::scientific, 274,
        "3."
        "5350054379821040281789284265976009753915056027158289663573472460364318135080456532420187970414666391602000"
        "5749792748196365536928031655309360101630870384004441686023479759971468723814758726445507263978188305294501"
        "66237066652626089735718395434815874978085048496723175048828125e-96"},
    {0x1.754e6b5cce5f8p-317, chars_format::scientific, 270,
        "5."
        "4615606193444131862109204544103266030868122735855760371810669285382344869384517529242953427788269452822158"
        "6447733355524512940892011377262788258325539802499302096414943486531804678941620226371353010632838705878571"
        "6076215004574612686683021678391014575026929378509521484375e-96"},
    {0x1.8467156a708c0p-316, chars_format::scientific, 267,
        "1."
        "1364847491964381755809073325658806539668735063951189927636831017735890051798137008661548359628176249486567"
        "5638355075809542316572770260795609472341017048086809154108791537763758262439106114402680050430718549937605"
        "4984664105996887417671104003602522425353527069091796875e-95"},
    {0x1.895d0eb98e49ap-315, chars_format::scientific, 271,
        "2."
        "3020007806568932024585160896856794015905763244531581751345471550226462732325455222444774590029231192793210"
        "3526585809434548954819303101741588289887271759169385050668460900964752827696537189730053914236112530299498"
        "78718850332174066138091195199422145378775894641876220703125e-95"},
    {0x1.40a747961380fp-314, chars_format::scientific, 271,
        "3."
        "7529890242406666427809537541355673359784524729918599611738936303969683643463506435674045097086533000435903"
        "6833805751251437135871962069969241765350603702037415332674882077174238682833668617350553945267812311343474"
        "50183664810112785757689746191090307547710835933685302734375e-95"},
    {0x1.3b6a90b6dd82fp-313, chars_format::scientific, 270,
        "7."
        "3833844812933601001626040712223208545049894159172436674233731756578183832102588069235339862415563708591953"
        "3290144340614000151931192578763645062459485049299914120235431773959612511632269475578724910553760753162725"
        "9035773503789072506886537183845575782470405101776123046875e-95"},
    {0x1.29a514459ca70p-312, chars_format::scientific, 266,
        "1."
        "3934768122159904445853290075552856512674507704664699177572841136493178162330742824621681098250948372789843"
        "4729750251456654416423830571259374225337974011611156252922037258169533613173818100385793804677394622735141"
        "766994054388605073224738362114294432103633880615234375e-94"},
    {0x1.0b74c8584ad3ap-311, chars_format::scientific, 268,
        "2."
        "5042865665627230013905293764731537341817933131283917087004920122084647344228898478210371710543160857493563"
        "2236939001136948844407029210584627234019763143896970351150846985824258803274296439361886009001435481001665"
        "10812608939716590594759537680147332139313220977783203125e-94"},
    {0x1.1e03e68fcf7f4p-310, chars_format::scientific, 266,
        "5."
        "3561230856431216215705891197384170210658872854832333041087321234180910038318181672802850047733820007628560"
        "4182171685972328799651035840891788773709992554797907500387843891228116979454940850233766623349333385640802"
        "273842934100485380088940701170940883457660675048828125e-94"},
    {0x1.713e883d649b0p-309, chars_format::scientific, 264,
        "1."
        "3829457207184735000646794778614053460940210246011933848384018350432995141075648085203697000208221493806949"
        "6871105807765061634200805943647551922633019924217056463629491090846563741317220831180219308859755163461485"
        "5151721147207000139900401336490176618099212646484375e-93"},
    {0x1.86281c91677fcp-308, chars_format::scientific, 265,
        "2."
        "9225397297013291485340291504603700336599579795115816142467807020570283454539177669728489061469790947015462"
        "9997814087950868773198110436893831741279455750950609447941220401713815828135354829102946691124843423371622"
        "00459380729210268068385403239517472684383392333984375e-93"},
    {0x1.45504d79391d3p-307, chars_format::scientific, 266,
        "4."
        "8736427954876516111588556297323223735366132652170239201846287920067706228596656189402267426246839952413216"
        "0049764777409257875974799672905922600908337766650300092966930614776888318933855334348681166027395590583966"
        "769997135959867351484575692666112445294857025146484375e-93"},
    {0x1.8b65fbaa5facdp-306, chars_format::scientific, 266,
        "1."
        "1847214117665037958349200111689262962159366411777270344855697272453913854959328881800526601044047876095253"
        "9508884510689090450544760680794078282991730837875342801146971856602898038792043608811629235497645397056549"
        "789557803741175956435682792289298959076404571533203125e-92"},
    {0x1.15b31d81ca8eap-305, chars_format::scientific, 264,
        "1."
        "6641279667471598281077652098259945521671295549362078378109870769039305816240186759177203366513405424353633"
        "0530761980743920794284685177470701845646722007722289704781280982002937652274421398782929157293977334017839"
        "2330593955435180664181871179607696831226348876953125e-92"},
    {0x1.eac3901bbf6abp-304, chars_format::scientific, 264,
        "5."
        "8818504424690985169205536700281187606567042378602631203335310164716217466374569085773532485133568172286664"
        "4136317480410796037360933641727560690299399698464619034628147686482037707302630902387957209311928858323561"
        "0316787898670110035226343825343064963817596435546875e-92"},
    {0x1.54d51a8657184p-303, chars_format::scientific, 261,
        "8."
        "1698158411107261909593405947137163967522047624097756905903111770746755936496192101549234847884183779745242"
        "3170474746072782115324967751585643030135116010607593205418148559244337424314958917190348394072848060723705"
        "5238019525493786687775354948826134204864501953125e-92"},
    {0x1.4254ea10b5973p-302, chars_format::scientific, 263,
        "1."
        "5452699464889383084423290711151957352280795463335067223992351392751481442851664811520430139228875639213995"
        "7443372996563698494777793436879534495292022436992037556775109404800293598056714392374950920150650171867569"
        "806873131225966044866027004900388419628143310546875e-91"},
    {0x1.7da943773f203p-301, chars_format::scientific, 262,
        "3."
        "6593953762901490298980465769951165569165929629731813929605504263224870936440470834287500461898098845461917"
        "6300712475200183741800575688110181618613341186483104049336857735772610014290974319446787969336623844116806"
        "49009906106383649415647596470080316066741943359375e-91"},
    {0x1.ae4f00acf5c6cp-300, chars_format::scientific, 259,
        "8."
        "2516607665957782806495449548266610202563683706678154753337492221892598865851270347456671454474309415340154"
        "2947108353765710923663409929467862648030890496688726139045114262386812243844497274555150209350984257558006"
        "30762397396278373662426020018756389617919921875e-91"},
    {0x1.8295f42a5103dp-299, chars_format::scientific, 261,
        "1."
        "4826450102010817711210930923040416160476151525185906279856054958041241077876390807571824882338445071789251"
        "3774699575501451998966639677459705092394758161469439414273380135760573163439712286440819442904694661281541"
        "5837368683560359983175658271647989749908447265625e-90"},
    {0x1.abb6488a3abe1p-298, chars_format::scientific, 260,
        "3."
        "2807475032115240062100233478393094020251354181481746915075124012767501350915592204090764547211207441234158"
        "9250311944676967760616784054804356827548506333595288049246369690491136655894910770418537088388769788416740"
        "388219995649965454731500358320772647857666015625e-90"},
    {0x1.48abffc61d5a3p-297, chars_format::scientific, 259,
        "5."
        "0421279276628866771404917521343449655818410102699411247766865670698511764154971706103933661501555850943124"
        "6691132567436980119815055690200132903971131676335235354630998904758603124455624172088445296120063391046502"
        "32281999711059228275189525447785854339599609375e-90"},
    {0x1.68d80a54d6153p-296, chars_format::scientific, 259,
        "1."
        "1071352931313987677170263865765649059990762705126667526251537731419538691260092093877617025045125993875951"
        "8957282035594918033530304494227577752017748915004609937482099729275688967497784979892357979608435015250917"
        "52096634223345716918629477731883525848388671875e-89"},
    {0x1.2c6b77467b856p-295, chars_format::scientific, 257,
        "1."
        "8434860272299224398646710148202596071649163719074503710061903300320517800432749157104831068290668987721246"
        "8288905577843079932802656060133153397763658738705621885098366210921463101614640108441163625096848957520139"
        "530678882078262859067763201892375946044921875e-89"},
    {0x1.6ef654b64f428p-294, chars_format::scientific, 254,
        "4."
        "5036297145461490155658473901364871637444212817199245336544093047170635880998585764076422564090558606666255"
        "1938086353343001846340281510205158335022043844604870268243750850377280010291550976095751246698891426552117"
        "424331189710073886089958250522613525390625e-89"},
    {0x1.451173235af75p-293, chars_format::scientific, 256,
        "7."
        "9789499766966189057432041933294408174821133119234321595322590241361258550194960490787811861606827978987534"
        "0580669985289732544810391373789920254660051031541038369168888736649566723608062419701182989006022283778749"
        "24371282450152875753701664507389068603515625e-89"},
    {0x1.ffacd596082c9p-292, chars_format::scientific, 256,
        "2."
        "5118610569922106564460984688389187692141330531682768924103863645054219481499842629645126936078591972527872"
        "5114722222435312309709437730552329335737166622168597422045113087432814378216341861796310595179875161588614"
        "82397368636299006539047695696353912353515625e-88"},
    {0x1.063332099741ep-291, chars_format::scientific, 254,
        "2."
        "5743284390384121121339828370307253704732203904243798931630246226927879139516091842410667400769648561814006"
        "0967151854945291742251165941694548044712489711348582758259760078958923842987028079231637018004530552653017"
        "459741047190391327603720128536224365234375e-88"},
    {0x1.96f4c617754aap-290, chars_format::scientific, 253,
        "7."
        "9911430601386120440060711986378002682633187804808109392328090664875747637758557400825900344026788010313343"
        "2729113699362461043666923313670271869280829318221799503990742364295320472425956004990574429576668221347291"
        "24604834993306212709285318851470947265625e-88"},
    {0x1.935ccb527a6a7p-289, chars_format::scientific, 254,
        "1."
        "5841152817579089701888246464101800895048854300815732047427000213855511213199411158696917835920060194040385"
        "6832944195530241996774628793343986472070897672191257541684614583042669447587509362813108117841725100392066"
        "653831601996671452070586383342742919921875e-87"},
    {0x1.3b5e38a2262e5p-288, chars_format::scientific, 253,
        "2."
        "4770739864851201045215521130565488910183929199437325725631421672722396652413988843021963416616140085403298"
        "8566619651757547235989152653761825101443066623967176924256056621254930876323270126516930137333399219767881"
        "07482736478459628415293991565704345703125e-87"},
    {0x1.484a5328dfd67p-287, chars_format::scientific, 252,
        "5."
        "1571453461558414690975411195843410181665902370366403386781820716480868872616970347287285000078485643033558"
        "8701703489523571282053738369007553845016143803485386942297636126664238201721806757128415840988374615235911"
        "1636354072061294573359191417694091796875e-87"},
    {0x1.34089c222a3bfp-286, chars_format::scientific, 251,
        "9."
        "6778617084384446515856594489186391560274790969791576420550050955675959857565171616414306909257785259034695"
        "2362288345318732779856813605993054429873501524126201190913398770745075709628316629547843926599154360294018"
        "084598377527072443626821041107177734375e-87"},
    {0x1.e6fcdd939cf07p-285, chars_format::scientific, 251,
        "3."
        "0600555655865200534976772197248794399591456706189630865265707040418808227552314886557434562051285553829030"
        "0716886533358185718261901052219893727742299836868360224318883583437603674338252457160623503337061100215525"
        "655254822368078748695552349090576171875e-86"},
    {0x1.44926d40c76ebp-284, chars_format::scientific, 250,
        "4."
        "0789867108393157187752948756264703859264191233331053076042708075185293288917985839904448038455228974372772"
        "4796581245328847896234645778426859241054384479033713048023996115476263476953358964540485263635494439472470"
        "30717306870428728871047496795654296875e-86"},
    {0x1.4e29f7527bdc8p-283, chars_format::scientific, 246,
        "8."
        "3990628635128793878113999378017349458345655285229811951413205941895445655212208355669760623316311014944192"
        "4895587056060013769855374324172459834228975819398443536073706731699095978262061796216568521405087480863338"
        "4560607737512327730655670166015625e-86"},
    {0x1.8c68f2953a6ccp-282, chars_format::scientific, 247,
        "1."
        "9927178266561660444642125584749374937520778851582251840153437757893208705737778210140182563707851211680549"
        "6000088093483500136470476092352988612163262395625243307278830900372908744130530715872596772314013667190546"
        "46381437123636715114116668701171875e-85"},
    {0x1.daa11a32d930ap-281, chars_format::scientific, 247,
        "4."
        "7718392311175778496834201787015006522460756370577250546037300400638004617260362478357013608710612128385322"
        "1779947181639233169587356613212047538343034581376134935211933499518225742900654242594724446526025006878879"
        "43087162057054229080677032470703125e-85"},
    {0x1.c877431c64f8bp-280, chars_format::scientific, 247,
        "9."
        "1784544610577110087548536112667514918507241599449782305683393170457359980388202548163671022362647074555117"
        "2116019074929067384595406042749373380753064107605729164133086776553397098585026443014794176607191273850605"
        "56179041668656282126903533935546875e-85"},
    {0x1.5319d83c3ef66p-279, chars_format::scientific, 246,
        "1."
        "3637044518063170854462076009090508461307355230988207158833822119619060364687943744832686726236043170915496"
        "3514036585997359479452159849171388489220331093611734663524586436250473091482431300623345135401918559042711"
        "0099653873476199805736541748046875e-84"},
    {0x1.df184ae5a1660p-278, chars_format::scientific, 241,
        "3."
        "8533883620323423714136812889341534099647891816418950569082704468822715181673302421954378737049884964815594"
        "9225657910076871879456492908086055679238145888180249016876041212016385323048783306274907371194102245759438"
        "57416859827935695648193359375e-84"},
    {0x1.76fe5bdd1cd6ep-277, chars_format::scientific, 244,
        "6."
        "0321909257448322486188799696623295177021420540236469007302485328870820788061538273852486152111947182499602"
        "0430389313128435058945575768397789160853250945403152483495552579619178531893547143208613567133330110592304"
        "15185083984397351741790771484375e-84"},
    {0x1.e827f6053cb84p-276, chars_format::scientific, 243,
        "1."
        "5705072660535393121974894551856858865391970566370239367261961889364900750033565832132944807855682429973423"
        "1165743808838199193559492724914123351980041439654289592979913822692992177082452061483603995980466022652777"
        "2692861617542803287506103515625e-83"},
    {0x1.57fe4f2319e0ep-275, chars_format::scientific, 243,
        "2."
        "2134072641839148014616350155697182746271787657512992252495965052383531821160101822839509773517719903367658"
        "9885091166977969534942621043863491561694472421479566604474002796800759780876778117908416951915753084767501"
        "9458620226942002773284912109375e-83"},
    {0x1.47d634f051b6dp-274, chars_format::scientific, 243,
        "4."
        "2188963156964790091976855129879663206858758676041114580017440270985892530256344542758502021499043746143513"
        "2986767861064045946038194991469606398275313429723392840792584921040979778779308359876410281397596940822225"
        "5196960759349167346954345703125e-83"},
    {0x1.ab161f2c4f9a8p-273, chars_format::scientific, 240,
        "1."
        "0992259537194823078078492322005134697759069190880982299089476477421890699462556853397689401906770390979778"
        "6076941515468432802074130342767290219697959626185832487110501790388370592167474364612702816563355456835893"
        "1646798737347126007080078125e-82"},
    {0x1.e291ca105dbf4p-272, chars_format::scientific, 240,
        "2."
        "4840542381260295931026824878265850213738163806945569103735598853085085998454192004270399375665114378419793"
        "9339093426915978383823920259991198886269275880452442035925336260690735668115500978992897615927476495656378"
        "5744947381317615509033203125e-82"},
    {0x1.05497b2f09b2cp-271, chars_format::scientific, 239,
        "2."
        "6899801291961049649259897509032221460182990193199573687789715730498841548008680282752621494050089364971956"
        "1463605015707114076093509216799977300670476900145388353293690677054565291249211441112205284685587880488810"
        "696988366544246673583984375e-82"},
    {0x1.5c2e8d0a58e74p-270, chars_format::scientific, 238,
        "7."
        "1691442839152966800651789754421125674555953045807849165758253326495394357218725180436693959779826838539023"
        "5241811586085690413191170438571390570469553243783321439188124683995544413425828554208859124188824019086041"
        "51685722172260284423828125e-82"},
    {0x1.150c7af401be8p-269, chars_format::scientific, 237,
        "1."
        "1408995211686882396999673277161942905911769631008359348308702974525173207061901437452806284674796790066877"
        "9068752395048930939229325944194026364434225582687841188243409709254873786228664105033274878825411136062939"
        "4766874611377716064453125e-81"},
    {0x1.bb30e9d725359p-268, chars_format::scientific, 239,
        "3."
        "6501624740693435787870241089127783673137622073205114014170416150615960587516148133472666902880108394136902"
        "2414280357161153404157898726888077804987981004743248455675731222748902769395701614578618140506682809842686"
        "765477992594242095947265625e-81"},
    {0x1.8e26580dfb59fp-267, chars_format::scientific, 238,
        "6."
        "5583965679406291322543386377247490770669733923095682391871457649122662052805566842350436869479069566624479"
        "9577994068697065802161796337967353919150253326164238823498761305697129755079000741114120557814781697913986"
        "13597266376018524169921875e-81"},
    {0x1.2ebd25a1e5a0ap-266, chars_format::scientific, 236,
        "9."
        "9735404360143309836615940606941282378612316332479673006818986372431047284827499250652587489448273074521490"
        "7159098256425409638672402820464938454137381883658245598470175431363044393496375251856344602841009105986813"
        "665367662906646728515625e-81"},
    {0x1.430c70559fa8ap-265, chars_format::scientific, 236,
        "2."
        "1285263571540235575696332659335516392967259876634974541900328449762481882645550424221520486704326122874324"
        "5389964017346232785164042207656441873771873947372771748143644161220111890357661173789620596974447863658497"
        "226424515247344970703125e-80"},
    {0x1.b37b4c8d42152p-264, chars_format::scientific, 235,
        "5."
        "7386670202301382796372027888070564929201692176971669630590876089659777060558652704543784738546830046295004"
        "4603280725800304057600452205270691087995607476359238776203611756090465773659736699519777827771527256572881"
        "01501762866973876953125e-80"},
    {0x1.e7df267017ba9p-263, chars_format::scientific, 236,
        "1."
        "2858099560631301338481970648325266446537589188919690394573293863678630154936269933032378796467868286022293"
        "1313596145811383746152520746396771825426169624107483758544143530277325048406906936058276443024528390424165"
        "991134941577911376953125e-79"},
    {0x1.24edec18cb7ebp-262, chars_format::scientific, 235,
        "1."
        "5440597737151946460972322931613150367282007839535034780293980553235893087580481701735620945314590019229682"
        "9903029002040487140597712979475535950195881357446664740641123548932565198031098388959129683040139013883162"
        "98834979534149169921875e-79"},
    {0x1.e259e5060f8b2p-261, chars_format::scientific, 233,
        "5."
        "0850413106581489843264497391468834239896808424048302785732446399420840399817211944222782861236400064717650"
        "0292091292079844810287479922800960523182642683648046932685960291959579642015772043086609122131136473399237"
        "729609012603759765625e-79"},
    {0x1.74c84ba4bd4a4p-260, chars_format::scientific, 231,
        "7."
        "8598917902586301437063592700391486067845391377030263724566219385264035315415509521990392844610347274677649"
        "3187534013093110305784267349454320227788828198489207064733005870559642487953084957850308223115121109003666"
        "7883396148681640625e-79"},
    {0x1.63e925b45db68p-259, chars_format::scientific, 230,
        "1."
        "5008325529570412331623540869231822246729874856884866752807101484418958561722149716692008029675745594666613"
        "3503364128985836668117456388387335023474589528561716496306845300111545482800773821004114427779541074414737"
        "522602081298828125e-78"},
    {0x1.8cfb3f3c5fcb0p-258, chars_format::scientific, 228,
        "3."
        "3480454826799275168273424149426024516039420592697674339471485209977799621418170443904530724423345933811752"
        "6732740417275913568885136319985690578200693894309818221260736539715042738901337997931006995600000664126127"
        "9582977294921875e-78"},
    {0x1.f7c87448db5fbp-257, chars_format::scientific, 231,
        "8."
        "4975685812240518705712137865350408669165500059723872621242165482954565097487677179811044593228751800199178"
        "5436537587101247795788092235280018313908274894860537262681387520877021653599208068138176619399359879025723"
        "7851619720458984375e-78"},
    {0x1.e5fc8e5d48f9bp-256, chars_format::scientific, 231,
        "1."
        "6394772414307022630918211937753726342439186922700005937997030738726779071510104514297590583407610112272420"
        "1605153941665901729175616786406066510329221717620551523250096943414433377873453800532138613377242108981590"
        "7180309295654296875e-77"},
    {0x1.ae03e4daf2ee0p-255, chars_format::scientific, 225,
        "2."
        "9013155013751830433627264368121165637564844007563220302732139238380508640398659878415626116750234917257035"
        "4358021314491547644576387223565138757629841448907671848335714372372538869101956521268093069920723792165517"
        "8070068359375e-77"},
    {0x1.1b8ab942a6426p-254, chars_format::scientific, 228,
        "3."
        "8261180450693601910659987374822551200498589347100111087127385186891707357059664475499120073190271709835810"
        "2333262835696749317479762874812949441156340532185274119802689659385649761565455131279156475443414819892495"
        "8705902099609375e-77"},
    {0x1.0c1e462c5c1cep-253, chars_format::scientific, 227,
        "7."
        "2359827219547880037182260980171407807010957821836862935778233916886051101359252066396988945460218716415299"
        "8058217929659776342575854014888159205157469067456314240460661266281712378036264886327355583262033178471028"
        "804779052734375e-77"},
    {0x1.e7b34d78e6948p-252, chars_format::scientific, 225,
        "2."
        "6324142915079566794044585228208590792665767389780345214640856391021186677025555855415331925777643406404267"
        "4815827159675201972348758945269748619500474089457136522536683890735534662775902542408701378917612601071596"
        "1456298828125e-76"},
    {0x1.19f7b9144e56ep-251, chars_format::scientific, 226,
        "3."
        "0439003831515615676336056485285756533835399224529189344052214824595214456119324049792258875343600293464605"
        "0603560529499605598396432199482500999142131561233177111438702268476676808609806754168936038240644847974181"
        "17523193359375e-76"},
    {0x1.9243a3c6aa988p-250, chars_format::scientific, 223,
        "8."
        "6850539709499319555594997827933889454841898663613334205733556673628208790371074675294281427261965075820622"
        "1271882727206860063168834267557287655720959306207165641773755143610896424207282184859479912120150402188301"
        "08642578125e-76"},
    {0x1.1fcc03dda0a29p-249, chars_format::scientific, 226,
        "1."
        "2427314157729456479934367418834492113980183267925625403583281509539683257573896953625230295290581867933513"
        "9867126855919765889486660234790771255321938873431482613218900832291311030712967558575776649831823306158185"
        "00518798828125e-75"},
    {0x1.89816794283e0p-248, chars_format::scientific, 220,
        "3."
        "3983797108077041005965221970144927011138697559396869782925070589033970948834132451537407163528766580562328"
        "9119716016152060124454015265884051674568238114179095340987075753721931596282312959544924524379894137382507"
        "32421875e-75"},
    {0x1.c60043d326280p-247, chars_format::scientific, 217,
        "7."
        "8416589235876873864289188382541268098206197299049393893562552331589852548698913622637238112143222399360991"
        "5480134465272471761419124295424633425260765943378864906926742411121021916753370817332324804738163948059082"
        "03125e-75"},
    {0x1.80c28d4967c46p-246, chars_format::scientific, 223,
        "1."
        "3291407760196483165741511994194910753052570869084757495085032652859082885914003067026860815170496007105388"
        "2420687980563833583212875833639219887705559466700038838126004537916422394141710561221714215207612141966819"
        "76318359375e-74"},
    {0x1.a40c7ce612bbdp-245, chars_format::scientific, 223,
        "2."
        "9020896579031938453736117362122286671352965063235487145399744925912078407328282009772735936130948465580980"
        "3814778028095486508264623146907774784542240889474784632658103007257975695107679592332772244844818487763404"
        "84619140625e-74"},
    {0x1.efaf47443919ap-244, chars_format::scientific, 221,
        "6."
        "8493063311021444285262622630853901019739233598253225435361636963656204227414135855331310041156163827176413"
        "6297086180878976214390376525714424271780749287936058534182261326294307462493604621300846702069975435733795"
        "166015625e-74"},
    {0x1.7500215776f19p-243, chars_format::scientific, 222,
        "1."
        "0308144847135353771186145298171097410301970246782425463944124259742140545264889430363986396035589042598392"
        "9655776844273240873118061640991963182770593248030297396972216312970955988826543547887126806017477065324783"
        "3251953125e-73"},
    {0x1.4a99b1bcecb64p-242, chars_format::scientific, 219,
        "1."
        "8272771233005929132884988427301378153940847425631690632810979503758848344768354506461635004842080033192263"
        "3901401061824934045326281599520081408691385773308746157750681691937582554891017494469451776240020990371704"
        "1015625e-73"},
    {0x1.be72480668102p-241, chars_format::scientific, 219,
        "4."
        "9351506696419103240061669265502256149959617111583303561219685377261392905223787116563640644769825543047758"
        "9988217137215046802369061635078622989986340228461792966116610916308424326232051626561769808176904916763305"
        "6640625e-73"},
    {0x1.e7a659213dfb5p-240, chars_format::scientific, 220,
        "1."
        "0781250168794165933748349260234324391026463879289947053114193829482841759135318917268811758748161809004643"
        "2679611225514535349967383908198802533763640615597337848108680394109407845240622414451081567676737904548645"
        "01953125e-72"},
    {0x1.8490c51f45e0cp-239, chars_format::scientific, 217,
        "1."
        "7181272168700195560600399255994575019168872251009996740322328861948515810175299840150713970748225557399786"
        "7396379335700002769043874836031870998424017159999796374606522132792154819447283387034985935315489768981933"
        "59375e-72"},
    {0x1.e2624233f3ae1p-238, chars_format::scientific, 218,
        "4."
        "2659307529076216561467963956055319316897246968344236420579031063442725355740818771410564719833709091988943"
        "0309795900282398265726189862458374678051097719482165551080831781337690013222729845665526227094233036041259"
        "765625e-72"},
    {0x1.d34363be146f9p-237, chars_format::scientific, 217,
        "8."
        "2644256896671227468821316614503358331827205136754073205926088157584837967768526931310522556079545315620199"
        "9752392611005149405019628407058574516126059240841495119417818289946466372986044746085099177435040473937988"
        "28125e-72"},
    {0x1.cc0d98a80a987p-236, chars_format::scientific, 217,
        "1."
        "6273802065732597896113817387260276341030974100457666845629201763813055943005389152933610589184732283144369"
        "5959054192608060281009150208042269805343768362769324987082037382895216212630451479981275042518973350524902"
        "34375e-71"},
    {0x1.0361a6687dab5p-235, chars_format::scientific, 216,
        "1."
        "8350586944381437658146209039595796622558843610506614077602816551920309835339246680605412417590509836746350"
        "0907317990415345399158177353222862249035451776703642604718783418757486330941119945237005595117807388305664"
        "0625e-71"},
    {0x1.334f6d8947b79p-234, chars_format::scientific, 215,
        "4."
        "3482861542842136933757337627047159251109583384931118811727977153338308729167124422446490325358280576021385"
        "3128933592905108885143475829591672376873605604435264983395219417897960278995839189519756473600864410400390"
        "625e-71"},
    {0x1.305f84a10441bp-233, chars_format::scientific, 214,
        "8."
        "6134539761559003805548061531588022181123903542512485056622016306145283431381871224850727794432398272373581"
        "0512724266920229223820220601910535835876168753169487298805997950229204618288747496990254148840904235839843"
        "75e-71"},
    {0x1.c9b7f3905ce9bp-232, chars_format::scientific, 214,
        "2."
        "5905952437250455635059237293015822897473731806321263112212662836451190738319086758301231709882273911943529"
        "3270180444466210678654003519384812165597482919674043077699101118816990552140566705929813906550407409667968"
        "75e-70"},
    {0x1.2cf7988d814d0p-231, chars_format::scientific, 209,
        "3."
        "4068276481875121106288335315725238787330858093186688658099540644480044178549555509113134844354121258224253"
        "4525917021069896218436602993505532330186491208047744444804166320805993706244407803751528263092041015625e-"
        "70"},
    {0x1.2439294be562ap-230, chars_format::scientific, 211,
        "6."
        "6157007521363805395917512221628507674702476236714185773792545977038289879884140448995517698614722807482564"
        "316269955719701793397075413905783271318826294501086750761564164204087123977160445065237581729888916015625e"
        "-70"},
    {0x1.7d0e7e36e5257p-229, chars_format::scientific, 212,
        "1."
        "7253632008143088480986275464805616259466461047557408455579172771296622170925567796958477645145988934861094"
        "3280541592636736407336659321916801029023411688490517352222660438058887688583808994735591113567352294921875"
        "e-69"},
    {0x1.7644d51f65057p-228, chars_format::scientific, 211,
        "3."
        "3892588392445132904880849439603103583240865854698042092539617889110357535583974094512848897341060231911715"
        "668847206489491686550142284002714273859791254064651550505603955741606991836079032509587705135345458984375e"
        "-69"},
    {0x1.10bed5717b54ap-227, chars_format::scientific, 209,
        "4."
        "9397904291451873909412488950158690757659293412589473529426279864502529323852039218836670325495060439451386"
        "0826816969882247207957292424991122060599367981196290341226848470690402592708778684027493000030517578125e-"
        "69"},
    {0x1.97ed031bcbbe9p-226, chars_format::scientific, 210,
        "1."
        "4776181570075499135778399888179597296465432706936910908693639807173018504138725021329993525857491897140530"
        "58229777886958874081655166914945387334176236365795347469506899364122265438936665304936468601226806640625e-"
        "68"},
    {0x1.e87bc17774e5fp-225, chars_format::scientific, 209,
        "3."
        "5388392753930521569458603056975605427089057010706444537751899483971678103585409044068753689573306449520087"
        "3620048630042160735560641391063978204063233997161090636218434661575127364585569011978805065155029296875e-"
        "68"},
    {0x1.4ccad3c275ebbp-224, chars_format::scientific, 208,
        "4."
        "8218563385773112223108708692854480026506826778318969834120319390327162934136818773749592474331651671060117"
        "997507815882786838060737091655122402328021117440941168240798979371941612726004677824676036834716796875e-"
        "68"},
    {0x1.5a61517ffd9c3p-223, chars_format::scientific, 208,
        "1."
        "0037463923948035398952377686954725695708749868243331851405077722286769296317670730594311068901851751621982"
        "905208845752049158036704193593034774538757502752294448392761903876557738612973480485379695892333984375e-"
        "67"},
    {0x1.3760a2aa6c254p-222, chars_format::scientific, 205,
        "1."
        "8046301120677577831156523273751381553004340805312555968258097633741380875846144919225810181030729661426063"
        "465509289312072911372495984143831747178764135517056767525796712181573866473627276718616485595703125e-67"},
    {0x1.b29dcf95ce2bfp-221, chars_format::scientific, 206,
        "5."
        "0377562652737656740740431834806965092754376110615663711189065303770401719757724363364437831625604535900905"
        "0665914162340930680631398943831178102597624583278594631650763868702114223196986131370067596435546875e-67"},
    {0x1.3aa4a3e7fe35ep-220, chars_format::scientific, 204,
        "7."
        "2942263641848924709791974333318552392922497189413454562471159916381061755863392570840931492118884350692330"
        "28642932663345158882507360789118899600106765970543491284065751312226666414062492549419403076171875e-67"},
    {0x1.74467fb9beca1p-219, chars_format::scientific, 205,
        "1."
        "7260576914043516299667521604544099503136894225460607729102546218393499372203570873973193901356203104541651"
        "858702919756674718058411944198830741320724457610150486788942736371410546780680306255817413330078125e-66"},
    {0x1.04460adf3c909p-218, chars_format::scientific, 204,
        "2."
        "4135211264249107986888028696130084430233119968060816832629237084810043354459709587812751305641953795863448"
        "29510636863294535714465088337298135341399152847190355737107270162056238405057229101657867431640625e-66"},
    {0x1.4821325395af2p-217, chars_format::scientific, 202,
        "6."
        "0855030282997452019447514867331630657468044127645732990093511432831652591240656693499304388331948005719576"
        "291647734019028586433069197626384835517846818553661819052591486212122617871500551700592041015625e-66"},
    {0x1.6de490a48e2fep-216, chars_format::scientific, 202,
        "1."
        "3571719432209208961682291759079089652207854358802144505639464668566870317288686062650570379736789869557706"
        "865220772694797664743714525554547694672115452339483210146553471275865376810543239116668701171875e-65"},
    {0x1.9fae33750204dp-215, chars_format::scientific, 202,
        "3."
        "0836891319146542654621676435453427927985346471540079478265100941925579218917725745363008519792667726936509"
        "578521025584579103122413515433971308009849425461816976347384500201087575987912714481353759765625e-65"},
    {0x1.b89a1b615d668p-214, chars_format::scientific, 198,
        "6."
        "5371343011973150852898838767014285054009170245914920231983714940724080952210572962111819974100627028808120"
        "47091371176364709303433877377005013842865407407861123856296359235784620977938175201416015625e-65"},
    {0x1.1205bf14b82bdp-213, chars_format::scientific, 200,
        "8."
        "1312459641492482081166541589604817706874171006980185066355810432118883401318669273227828384881320643830327"
        "7572700842855620364346413336010642698923532080491406205668969420230496325530111789703369140625e-65"},
    {0x1.38bb74b2cee28p-212, chars_format::scientific, 197,
        "1."
        "8559814129506473866421804012367533608804583471137464959335795734206066943305396434753643633830322823523500"
        "5214453273509006641309435920997178527079040475538697363422357966555864550173282623291015625e-64"},
    {0x1.22a0215ce7d73p-211, chars_format::scientific, 199,
        "3."
        "4495677626158958674214395696919224233179649058963110430872447723008494208841922384319206038046498414808280"
        "237161710744628525006862200491884428522247284967078805040241462620542733930051326751708984375e-64"},
    {0x1.43e2f21e78901p-210, chars_format::scientific, 198,
        "7."
        "6887156715407682591023832286745406614960750239691936325646278514953457227545274838167326206011205999045631"
        "11087521684757125178339608488309602901621649250645841588980289316168637014925479888916015625e-64"},
    {0x1.a6c0fc50fb8dcp-209, chars_format::scientific, 196,
        "2."
        "0071439114262729837504870375731843208174931765110570173322624378508420496349832547945412094836606565794537"
        "382968664101699765520520611518293913512915851364397379352766392912599258124828338623046875e-63"},
    {0x1.a43598a7e7224p-208, chars_format::scientific, 195,
        "3."
        "9901264509201541515385647530544570777756931329657382905939255041595638020778163201073900580091263032608950"
        "62982775705487829263395483122897991853489149519963741230554887806647457182407379150390625e-63"},
    {0x1.4514380584fc6p-207, chars_format::scientific, 195,
        "6."
        "1736189512288787578528448418416349991749663700847809784694461643519721427376584527516757457805346764750442"
        "95637676288210916584739439369126886970047830556322654427248153297114185988903045654296875e-63"},
    {0x1.8641944ca7d95p-206, chars_format::scientific, 196,
        "1."
        "4822815568311571387774347113736553185061762803960083516201697860528424266401203404618141803921229407587221"
        "857702493025749782597434002635293362003405325086520527566591454160516150295734405517578125e-62"},
    {0x1.f6b995ecb51e2p-205, chars_format::scientific, 194,
        "3."
        "8189270099686453656944330386880851242990199456831493480657744929486472424859446314843153606613176940390537"
        "7110208626473460382988566967594883564850175212447569439433436855324544012546539306640625e-62"},
    {0x1.3d552fcd337bcp-204, chars_format::scientific, 192,
        "4."
        "8212075626309096460733573704691029512918454861204396148089296640492675485760690343627691702192822676968815"
        "63389639383199305786840112696187596685076424095350855481001417501829564571380615234375e-62"},
    {0x1.c5d7efd89b777p-203, chars_format::scientific, 194,
        "1."
        "3790405547409108597572348642030233030506653548234544771446962869832057530013194054847840729805753756239288"
        "5414951947851272710887256062334379377993422567498515984851792381959967315196990966796875e-61"},
    {0x1.bc2f329491015p-202, chars_format::scientific, 193,
        "2."
        "6993809501677146778769479910183262199839109507301803802721972810548917211929893732348630965943238348446579"
        "057907037793339112719528261592247795018823419872788793583140432019717991352081298828125e-61"},
    {0x1.ae773e40a5fc9p-201, chars_format::scientific, 192,
        "5."
        "2320218954487896785355755028514760124845743029055888558216867850774043141361941613159031705933056320069790"
        "15834175581246399137582629331561177468584472767532123071987371076829731464385986328125e-61"},
    {0x1.54177621d4f18p-200, chars_format::scientific, 188,
        "8."
        "2671699641426339340820628302131200394314879529639688939193883369957348095154029848956018262827562450461879"
        "9767543649932136066178729407262731386312436254737434637718251906335353851318359375e-61"},
    {0x1.8c7e3d8c73527p-199, chars_format::scientific, 191,
        "1."
        "9276428005917081988903274894497209583789235200873622102196547773359677427329917758697233946248094995833163"
        "9251543454284154774391128234192554058215314342905610800471549737267196178436279296875e-60"},
    {0x1.1d175cef3afb0p-198, chars_format::scientific, 186,
        "2."
        "7720738716829783366211423523072899760981646584179840305538218818577604522061421136502687349701011005022293"
        "19779605131760929109482801560084493683148998410814556336845271289348602294921875e-60"},
    {0x1.4475513c62602p-197, chars_format::scientific, 188,
        "6."
        "3097149258933373555396693520858956722428887774266681519521577936216995977632340581826830951793982217486997"
        "0049426645388404390460596730442919006912917689877673410592251457273960113525390625e-60"},
    {0x1.777b0397564a0p-196, chars_format::scientific, 184,
        "1."
        "4603881466067395019154406506648622335799728217146120546120015685836648701405196240311851355498324046529694"
        "693589869018846255688032266344721977514853339386036168434657156467437744140625e-59"},
    {0x1.335f347ccd407p-195, chars_format::scientific, 188,
        "2."
        "3909749954573929098486304712726443669214066244454384679654334105674731318682311463077318753893093869615216"
        "2587410648990459456387497476367966217701381548277339561536791734397411346435546875e-59"},
    {0x1.cb7fe420097c3p-194, chars_format::scientific, 187,
        "7."
        "1486821832535713452582704014218377603862581434335880398190116453503559511534348413760937020125432455684447"
        "563995618441814110812057986298391571637449171117140167552861385047435760498046875e-59"},
    {0x1.2b9e54a754171p-193, chars_format::scientific, 186,
        "9."
        "3226518683238715224399565661749611547006242370061528887320716195165308684845154101442598457938086015001409"
        "04741554326054101316920396718331088344207391305218379784491844475269317626953125e-59"},
    {0x1.61db13efbac84p-192, chars_format::scientific, 184,
        "2."
        "2020498812644948762033635142117124936558159878950024605332256666966723974999759217940229530756811212534736"
        "376207515633057521771033537451227692950672665261890870169736444950103759765625e-58"},
    {0x1.b0d988ed3cddap-191, chars_format::scientific, 184,
        "5."
        "3872611595972931554175099145771626677167753110603582724995579755815059161748788482588937205208507054423401"
        "377376127275846562117768446237202968791824009286983709898777306079864501953125e-58"},
    {0x1.5aae85fd3e364p-190, chars_format::scientific, 182,
        "8."
        "6296228594991325157229731878859944777554471925473343599866427363221069537701112240904539206861116322405729"
        "0877271989319006564197611655622440797464012263162658200599253177642822265625e-58"},
    {0x1.b03e8e5e29e8cp-189, chars_format::scientific, 182,
        "2."
        "1518906041456636649540146948591549576372380444424980691438719151181009657554823177254366549770014614706032"
        "8618439467737562606935278910241424697724621495353858335874974727630615234375e-57"},
    {0x1.4f61610cf1a2cp-188, chars_format::scientific, 181,
        "3."
        "3393236367487654889340514543993395885414094092298264710390768628882191685264273016078445381612177618356717"
        "142797177462480388287308407104197853498828152396527002565562725067138671875e-57"},
    {0x1.b36be913bc32ap-187, chars_format::scientific, 181,
        "8."
        "6708313720945146475351007645513441880275082684907503647662074215317905170752758954050433985625724643831520"
        "591378420182088554349024731181705578919594046283236821182072162628173828125e-57"},
    {0x1.c8e61b78565d0p-186, chars_format::scientific, 178,
        "1."
        "8197046818766602603686632095754096661651615753540376705159513693924449853347371957727126685333242730655442"
        "106873499937217143284318981587451002912558806201559491455554962158203125e-56"},
    {0x1.1775e38a634cbp-185, chars_format::scientific, 181,
        "2."
        "2260313359925404901383328255729970205956519425128348372731656993019288377550164061818329912332283919450786"
        "272972464419724461788385182721742260036901228659189655445516109466552734375e-56"},
    {0x1.0e15175ca8a3cp-184, chars_format::scientific, 178,
        "4."
        "3026606722410031733302677078662118124311005158053603782297542165579613935866431571476014496940810383434619"
        "138429936362412482276547319426894533389571506631909869611263275146484375e-56"},
    {0x1.4acfbe5469d34p-183, chars_format::scientific, 178,
        "1."
        "0540262429918153965846666776264916628183054605768575074287470826265255183716784817538128179345311968289342"
        "157486633140791923370468402402534702222425266882055439054965972900390625e-55"},
    {0x1.e17bb356e6d2cp-182, chars_format::scientific, 177,
        "3."
        "0681879985386225718752955391330904327341113602244606377562999866621196092449560501454295722110444234867058"
        "60565642117224838768142549934141161127598707025754265487194061279296875e-55"},
    {0x1.ae1fe199896b9p-181, chars_format::scientific, 178,
        "5."
        "4818233542942428453861995676140864431915789921130840684049211074743678696081616378159770391924796871267297"
        "084151393359730921440980329112542535074936722594429738819599151611328125e-55"},
    {0x1.a3e5b17d50316p-180, chars_format::scientific, 177,
        "1."
        "0702958332703832567616253901818145919920308310633570412149764544456728717958501944115424465582180828240141"
        "48718865247007996674714476958122089111924424287280999124050140380859375e-54"},
    {0x1.96b34187d54c0p-179, chars_format::scientific, 171,
        "2."
        "0733146515683786499609111229893863241245076553478564325616037441745856391159383548352298797077518654354117"
        "66550177248096035898124699092814893219838268123567104339599609375e-54"},
    {0x1.675af8398ba55p-178, chars_format::scientific, 176,
        "3."
        "6639110494840281694548174991298603448018526659230862490333249247127707514516761738926902815833573835511573"
        "0033554552298718973314046770846375000729722160031087696552276611328125e-54"},
    {0x1.5dd2845405124p-177, chars_format::scientific, 173,
        "7."
        "1334288244990372312224907648096701095619611996252745460578769413617469873020204065524906820710806990110295"
        "5125093074988767111613914735646080345077280071564018726348876953125e-54"},
    {0x1.1b379a2950eacp-176, chars_format::scientific, 173,
        "1."
        "1550490218152729646319151841501684609404232393195007305328016237754776338400569798686076059288528676396276"
        "3889248411112118081783719895916373587851921911351382732391357421875e-53"},
    {0x1.050c080bc80d1p-175, chars_format::scientific, 174,
        "2."
        "1292639261534582404213908408502234742842056862369668785710500233303706301115784477889068818329602152581373"
        "76334762627097723751361355200295566447721284930594265460968017578125e-53"},
    {0x1.b43a3871c2fbap-174, chars_format::scientific, 172,
        "7."
        "1162918935221443051517621235069819357956135232874696046768179379869415044499101446193354791112976594195410"
        "557422635999734494396452323672352946459795930422842502593994140625e-53"},
    {0x1.df22454bc74f6p-173, chars_format::scientific, 172,
        "1."
        "5632471909265050611068051615951617519978312479534271514571791116510630486516616104887110827559419704430548"
        "593022161692046697459355757142684950622424366883933544158935546875e-52"},
    {0x1.b833d723fe25ap-172, chars_format::scientific, 171,
        "2."
        "8724553500903598028572546383001781149110271282722642567137230852108467397456216094989216899040621575989169"
        "04794959450945984543606716299368741829312057234346866607666015625e-52"},
    {0x1.f684b3c7cc0acp-171, chars_format::scientific, 169,
        "6."
        "5581707069521569877856870724319603779730281282161256613335172096317790203054916032047180861903076571475476"
        "949770983954945174541038832582984241525991819798946380615234375e-52"},
    {0x1.a5b141082f7b4p-170, chars_format::scientific, 169,
        "1."
        "1006685169756962680050220555041590876254318428865998856904568826933953891310864740495265959403191562163377"
        "069746200609492539396368215864896455968846566975116729736328125e-51"},
    {0x1.4fff666a560aep-169, chars_format::scientific, 169,
        "1."
        "7539896072768474874561864155705114932844071436878901874932631783846705575216123230523996677805058270426469"
        "440568499952626504620988023841476888264878652989864349365234375e-51"},
    {0x1.668bb57ef8bccp-168, chars_format::scientific, 167,
        "3."
        "7433921715043594589736460314331405184962182591207676516772049221533184130039279221624312002874994124075876"
        "8607887085263453345700124241801631796988658607006072998046875e-51"},
    {0x1.dcd176deeeae3p-167, chars_format::scientific, 168,
        "9."
        "9564289980093796889603154154145876739448114195979055992690259022457312971712705761139632367260793438914366"
        "37755164485333344410143696645576483206241391599178314208984375e-51"},
    {0x1.16a3865422377p-166, chars_format::scientific, 168,
        "1."
        "1636497924322522189729705224278622993088292323624873159489348884349299835648653258490495496200575681563301"
        "93520858451476789898436370318535182377672754228115081787109375e-50"},
    {0x1.bce21dad63749p-165, chars_format::scientific, 167,
        "3."
        "7158384115949350614737820871904816925077956940869230941314885111502890909776030181321957172434491271547923"
        "1680692485678623002316733892058664423529990017414093017578125e-50"},
    {0x1.89eeefab48d10p-164, chars_format::scientific, 162,
        "6."
        "5805696341773827568201073427914990313810882433786527452734017775108553768567645871412871223414498597936013"
        "24190138180379207322179269112893962301313877105712890625e-50"},
    {0x1.8fee5ccadb200p-163, chars_format::scientific, 157,
        "1."
        "3361521745438592840663955655631716549469431650538517476774582035584703495979290821050139073573949863898319"
        "932246070741721499786081039928831160068511962890625e-49"},
    {0x1.07380dad14bcap-162, chars_format::scientific, 164,
        "1."
        "7588058594724069068378151340006562382389089937477477155953047822519153788093489690886862546961352922261512"
        "7616072031613314065323638857307742000557482242584228515625e-49"},
    {0x1.0b59bf6c21943p-161, chars_format::scientific, 164,
        "3."
        "5728259387967835757810502314748228560336702191385482390899073723989786692440757890127298326923356779924206"
        "4063605352086812859402353836912880069576203823089599609375e-49"},
    {0x1.fa531504c2a95p-160, chars_format::scientific, 164,
        "1."
        "3532863609445874625424619828095184220811044476992203391714726909818173064528541715965734117428727450051983"
        "0798601500848545205191175710979223367758095264434814453125e-48"},
    {0x1.bcfee137bb727p-159, chars_format::scientific, 163,
        "2."
        "3787372002095833385126791878777862375484338276605231718277360413206612063565553320217163353776596974116930"
        "802973502625109573915818117484377580694854259490966796875e-48"},
    {0x1.151cd5ef2d805p-158, chars_format::scientific, 162,
        "2."
        "9626275330019588245631947287909396699745270360057415499881998525739843605313927572634283409800720682223941"
        "17076967551033424286277551118473638780415058135986328125e-48"},
    {0x1.a50d5e23e121ep-157, chars_format::scientific, 160,
        "9."
        "0029880689123645099794460485807721339684096115950637844009362876227390039831564636627226957537724402162583"
        "602570082390824379725557946585468016564846038818359375e-48"},
    {0x1.82802e4264badp-156, chars_format::scientific, 161,
        "1."
        "6528407152844144785500614973455273336999912777463385056299104335915202959708996003513567290694805135376868"
        "9247248694610022134998672527217422612011432647705078125e-47"},
    {0x1.2177668084382p-155, chars_format::scientific, 159,
        "2."
        "4757619185369808203021240003521593381209663272308204986803350240581317601172411555122448494060667114028109"
        "01342339011156623573839397067786194384098052978515625e-47"},
    {0x1.03b3d0af74440p-154, chars_format::scientific, 153,
        "4."
        "4423898749490084399433969599509826144329330591332567939146106957870737458728262016757657867649861507909368"
        "67056336867509713783874758519232273101806640625e-47"},
    {0x1.d2d07d1f0f329p-153, chars_format::scientific, 159,
        "1."
        "5970369012122509593184775144635604659721100528580203484536611149954537884269829964378340152297825770815400"
        "55113898402168459700334324224968440830707550048828125e-46"},
    {0x1.8fa32bc4d85bap-152, chars_format::scientific, 157,
        "2."
        "7344299616431543522432421912792718134436427057605665499943091928202467144496467783172463158734772458732489"
        "503583523195173743403074695379473268985748291015625e-46"},
    {0x1.67c2abce8df9dp-151, chars_format::scientific, 157,
        "4."
        "9231615603464207242007921876013588518601290251044916876629241339050523954671848627932540076411043836705992"
        "149190718766560426189471399993635714054107666015625e-46"},
    {0x1.73f3b6e413e35p-150, chars_format::scientific, 157,
        "1."
        "0179995696026282273811276434771842619116554426387226609081999306437938716096066552645975664851424917170160"
        "429284839383179406269164246623404324054718017578125e-45"},
    {0x1.7a95dc8122d45p-149, chars_format::scientific, 156,
        "2."
        "0723091166540273850593168126191139912345243921985305222697460100039055010978950792132675510399982633713397"
        "43302659321122494162636940018273890018463134765625e-45"},
    {0x1.af1bf9e405f36p-148, chars_format::scientific, 154,
        "4."
        "7196310508913904671194894358782925911776121787765422306796132134761227959946314353602058140317633579755078"
        "227792840228627113674519932828843593597412109375e-45"},
    {0x1.93bd4a776ff22p-147, chars_format::scientific, 153,
        "8."
        "8399910274584726229868620813946972911876446658509805639346664857566354389109651130454527996512493390832109"
        "06594691158577603573576197959482669830322265625e-45"},
    {0x1.998a4f77b7f72p-146, chars_format::scientific, 153,
        "1."
        "7934004954654291024566203990087592056831316726175324954536665777161166202131665464671804424276289424204482"
        "57652650092541790627365116961300373077392578125e-44"},
    {0x1.e2ee6bf0a5651p-145, chars_format::scientific, 153,
        "4."
        "2295683591056470906800337028618844741657141766568221367835581227246587308429206335630344989589287675262730"
        "91660778125078223865784821100533008575439453125e-44"},
    {0x1.80940300d356fp-144, chars_format::scientific, 152,
        "6."
        "7363600023840417999542393041775431286862924968647585475108908864653553304615525710316981002244346312871708"
        "8829987280629296719780541025102138519287109375e-44"},
    {0x1.fb7e121e4f09ep-143, chars_format::scientific, 151,
        "1."
        "7778710260255370823068118815744034545239196175044810566452485059711823829134148938595203744881815979364219"
        "466006546976899471701472066342830657958984375e-43"},
    {0x1.db7f5ce10385bp-142, chars_format::scientific, 151,
        "3."
        "3315696595658846047469585592309601760666312357714637907805304801690666734362639697081633088940864280810672"
        "903680724754593711622874252498149871826171875e-43"},
    {0x1.1d9d22c7f3534p-141, chars_format::scientific, 148,
        "4."
        "0023019609904230460306129375468853345556873060242695191434355850628634523560076237997206470162408844618039"
        "983898061251466060639359056949615478515625e-43"},
    {0x1.8e16e3aa24c6fp-140, chars_format::scientific, 150,
        "1."
        "1156841616796604932136274348484852039247641538297458130288766038216630495392051161520698228292050021146544"
        "20551642655112800639471970498561859130859375e-42"},
    {0x1.87e3f754c260dp-139, chars_format::scientific, 149,
        "2."
        "1966221825446393623879986362588124795901767213242488227182002426802973438517357803464949551156413886798953"
        "6864355759604450213373638689517974853515625e-42"},
    {0x1.fa5d32abaa11cp-138, chars_format::scientific, 146,
        "5."
        "6765373748004688332440652788786161538895277758131917477071063157004169835839984069461934543412473811103188"
        "1204748827940420596860349178314208984375e-42"},
    {0x1.f67503a2182bbp-137, chars_format::scientific, 148,
        "1."
        "1265477503439072834143778179138023300408281899179844848603578440471818264924572994395463590144925447532309"
        "702169950327288461267016828060150146484375e-41"},
    {0x1.db3ed18fbe233p-136, chars_format::scientific, 147,
        "2."
        "1310740108629266741825276640768152345702055957167240124922338099906733105461315720740092281151001145210075"
        "94603485557627209345810115337371826171875e-41"},
    {0x1.8335b0765d557p-135, chars_format::scientific, 146,
        "3."
        "4726169049944299879453329939481586991700522073634174410762170911503198790930241004432988390365801374063802"
        "6145557404333885642699897289276123046875e-41"},
    {0x1.4dbf09123267bp-134, chars_format::scientific, 145,
        "5."
        "9862794573467662440074595060500155028664274136233854601575667668611139098768423815169512058364388094422285"
        "646611925358229200355708599090576171875e-41"},
    {0x1.5e56a8ce3c277p-133, chars_format::scientific, 145,
        "1."
        "2567777808329330013217753137114716276021058025597090076586824197836408715656044366011499934739896008786645"
        "686949867695147986523807048797607421875e-40"},
    {0x1.bb079ee8f4d5cp-132, chars_format::scientific, 142,
        "3."
        "1785827035279190121784119339542902927547255686713026008937054510447409625558295054802900095791530292975435"
        "312285981126478873193264007568359375e-40"},
    {0x1.4f6e275cf1a76p-131, chars_format::scientific, 142,
        "4."
        "8131885839189464342630285810238985752699527646604098580088304609518450064927286820639649469111945897896454"
        "038544789000297896564006805419921875e-40"},
    {0x1.6e0c8ad2bb37cp-130, chars_format::scientific, 141,
        "1."
        "0505090911062820335561411705941054623172870846458893207124770055231061069218704308882579307096982170963150"
        "87104585472843609750270843505859375e-39"},
    {0x1.98e433996597fp-129, chars_format::scientific, 142,
        "2."
        "3469216079446797138739112899579158124687027232331769891232554936238609927331878316423045145059373263289603"
        "794845561424153856933116912841796875e-39"},
    {0x1.42726d8c4369ap-128, chars_format::scientific, 140,
        "3."
        "7015098458206448453351979822608106339451489448555898068736741171041629697322955547340351680885679134386245"
        "7921431996510364115238189697265625e-39"},
    {0x1.486454058df80p-127, chars_format::scientific, 133,
        "7."
        "5395084299958847860449433646301178540543942807329687696496446852570945235346855720548050138439533096601508"
        "077583275735378265380859375e-39"},
    {0x1.6661274c7f05cp-126, chars_format::scientific, 138,
        "1."
        "6455979868696783534082063751133429136529036015164918660712006211854998013425847958975152867999508163321387"
        "14415123104117810726165771484375e-38"},
    {0x1.3aa7b44b0a502p-125, chars_format::scientific, 138,
        "2."
        "8896506750036806475577971922835255312815452296746498235731599185088314959519438221419769631184574013027521"
        "74387933337129652500152587890625e-38"},
    {0x1.9fd27c3ae95f7p-124, chars_format::scientific, 138,
        "7."
        "6374477588979438591229722951487526821041612993472034040866978911302507182089909043356325487765306689325051"
        "08159602968953549861907958984375e-38"},
    {0x1.da78946cc5490p-123, chars_format::scientific, 134,
        "1."
        "7429312422110310718977979413748775963737044267099005799918778562901268253551041976159609585717708002405856"
        "8596956320106983184814453125e-37"},
    {0x1.f203ac3519f18p-122, chars_format::scientific, 134,
        "3."
        "6588315678322708272314019672027802295093711627258677622098624893717512039023793281375763542569851116681434"
        "1777353547513484954833984375e-37"},
    {0x1.b49aae7f5cad1p-121, chars_format::scientific, 136,
        "6."
        "4153225021810435302055377998130934309169404574711166917674284394429969174601750224385013791146732675674257"
        "961873081512749195098876953125e-37"},
    {0x1.b661988bbdc4bp-120, chars_format::scientific, 136,
        "1."
        "2882866599344565053618788391492597985347367160360079978812335056300495851823386955130707091986101697766997"
        "631333651952445507049560546875e-36"},
    {0x1.7dc73059f4d49p-119, chars_format::scientific, 135,
        "2."
        "2438898905531304113205534342267833215945294680111818683410060358815191180269281387787392467074790158854113"
        "99722215719521045684814453125e-36"},
    {0x1.cdb2f9141b525p-118, chars_format::scientific, 134,
        "5."
        "4272469927212228398680026288174857747043423993740677691930900376873032761152811202056904353336480584246714"
        "8977448232471942901611328125e-36"},
    {0x1.ca41b4813a41ep-117, chars_format::scientific, 133,
        "1."
        "0773562313702051217542870690540839915318470195130197080844837846839614171734258592932298947107694342406603"
        "027484379708766937255859375e-35"},
    {0x1.81c487a032056p-116, chars_format::scientific, 132,
        "1."
        "8138709823870134963339439770612428318675600824578467344813375616044665156285156623700098024384863570901416"
        "09660349786281585693359375e-35"},
    {0x1.72bcb5fff535bp-115, chars_format::scientific, 132,
        "3."
        "4863954234406462550691749145030310991616513432575743908019034815279292363755361258808440757736568649249875"
        "30685029923915863037109375e-35"},
    {0x1.8bd7918860dbbp-114, chars_format::scientific, 131,
        "7."
        "4449617683806484935384150283945931186617540420755360525592411297979559594039747096401091457779086724144690"
        "3790347278118133544921875e-35"},
    {0x1.a7f69dcd72222p-113, chars_format::scientific, 130,
        "1."
        "5947728558224362995607999419897654924356426479146237070985315256260841154700059297961143613131529406246045"
        "255102217197418212890625e-34"},
    {0x1.eb4294b46da96p-112, chars_format::scientific, 129,
        "3."
        "6958300841764796394552603076512147534499147838425848046122473845261325916666391709798763706706914433652855"
        "22304475307464599609375e-34"},
    {0x1.45d8b318ecb26p-111, chars_format::scientific, 128,
        "4."
        "9027929571472789278384447568697681490197245669783486622993745123202427301521908282403838102991855407708499"
        "1149604320526123046875e-34"},
    {0x1.c95d0b441f711p-110, chars_format::scientific, 129,
        "1."
        "3763280779744355993441768388857348578041188915187008104911491475416457823921091900787544784479088377793232"
        "21184313297271728515625e-33"},
    {0x1.98333d0f2d03dp-109, chars_format::scientific, 128,
        "2."
        "4567652907408954862171758719761037178820726837148989034299592147290607067172199302776489787669689235372061"
        "3755285739898681640625e-33"},
    {0x1.dfd8b02992707p-108, chars_format::scientific, 127,
        "5."
        "7759413981215069525017042272423165722552378432976327150239566602665492393820853640382627369742607470470829"
        "866826534271240234375e-33"},
    {0x1.18e3e3b1a223ep-107, chars_format::scientific, 125,
        "6."
        "7621854242881406431627770947480800315291558269137007328403548746185753195763627266309109264952326157072093"
        "3377742767333984375e-33"},
    {0x1.9658328cb8114p-106, chars_format::scientific, 124,
        "1."
        "9564777034032247331266106351051660587948852300059958121203145251012029185530780310726950421695846671354956"
        "924915313720703125e-32"},
    {0x1.86c79844889d0p-105, chars_format::scientific, 121,
        "3."
        "7630713133101953008740171427121495587283910326243938739987716991334361642764145573780698583732373663224279"
        "880523681640625e-32"},
    {0x1.27dcf92066d8bp-104, chars_format::scientific, 124,
        "5."
        "6981175081206400922391655083797863384815261135600412746592359796806200489991016465245177169407497785869054"
        "496288299560546875e-32"},
    {0x1.b6c8ffb6a90c2p-103, chars_format::scientific, 123,
        "1."
        "6901389263110543181102365648652894274606301487002452251574237197576175408299383818092054276860380923608317"
        "97122955322265625e-31"},
    {0x1.39b18e81b6f59p-102, chars_format::scientific, 123,
        "2."
        "4166074419571089575889751347120191547305858469115993073742053892915281348533368963385492556028566468739882"
        "11154937744140625e-31"},
    {0x1.58ad465068c9ap-101, chars_format::scientific, 121,
        "5."
        "3105877964807320710292501984853581657899622371005556307571107853309782196652680426318671180752062355168163"
        "776397705078125e-31"},
    {0x1.9d0ed395b4c84p-100, chars_format::scientific, 120,
        "1."
        "2728329747902230165316181540568536882833839113574207013715404328367409245034930567741504603418434271588921"
        "54693603515625e-30"},
    {0x1.bf9c0e64057fbp-99, chars_format::scientific, 121,
        "2."
        "7586071091388190196112205187915629121694961798162398502469066619619835167200191071434911549431490129791200"
        "160980224609375e-30"},
    {0x1.f3a0cebf107f8p-98, chars_format::scientific, 117,
        "6."
        "1583924748384136682512359017261255450407522093971748312640088161632302368340627363174633046583039686083793"
        "64013671875e-30"},
    {0x1.8d2ccae7cd365p-97, chars_format::scientific, 119,
        "9."
        "7911189758325206052557743537635646483728105421101526676208264656982528338082742008774417286076641175895929"
        "3365478515625e-30"},
    {0x1.aa0b3a331c5bcp-96, chars_format::scientific, 117,
        "2."
        "1005583908999635980523814595285630437648644793626080509594614990803394929735556373451288436626782640814781"
        "18896484375e-29"},
    {0x1.4b814b3a1cb61p-95, chars_format::scientific, 118,
        "3."
        "2688922135094771214795507178565946598481426142285005760621407779950612653330384305139233447334845550358295"
        "440673828125e-29"},
    {0x1.f4068960578d7p-94, chars_format::scientific, 117,
        "9."
        "8612648786366515414854961643790399130167377288239167225981380011826524576009841971391267634317046031355857"
        "84912109375e-29"},
    {0x1.f62c0cec38831p-93, chars_format::scientific, 117,
        "1."
        "9807195772041244841383550163089449103868726897978856906267460422507129962120878130527046323550166562199592"
        "59033203125e-28"},
    {0x1.37c69791af80ep-92, chars_format::scientific, 115,
        "2."
        "4594770057660368495756651818864062387955645568161205513648519067289568355676177002777649249765090644359588"
        "623046875e-28"},
    {0x1.c42f82f902ae4p-91, chars_format::scientific, 113,
        "7."
        "1342307123642233045958095225167156992008276425321789727449239863317162219785716459341529116500169038772583"
        "0078125e-28"},
    {0x1.ab5c60a4631b5p-90, chars_format::scientific, 115,
        "1."
        "3485130668183937590444128052855465890028802588861696634054925499593654875281345528748033757437951862812042"
        "236328125e-27"},
    {0x1.163adde1f573ep-89, chars_format::scientific, 113,
        "1."
        "7558778301243823121155271808116835370371045792990942242404584251962271126273895660574453359004110097885131"
        "8359375e-27"},
    {0x1.6cc1d8ecb558ap-88, chars_format::scientific, 112,
        "4."
        "6038833248427952809663776964936140725404629123882134521116254371057353346474716460079434909857809543609619"
        "140625e-27"},
    {0x1.0cdf536fb5eefp-87, chars_format::scientific, 112,
        "6."
        "7872927594290552636925886720441058685794883580176619836663438543506473958621949549296914483420550823211669"
        "921875e-27"},
    {0x1.cf43fecae092dp-86, chars_format::scientific, 112,
        "2."
        "3388936048665310851316745468303563301324829126576636843972225326095050641772576938137717661447823047637939"
        "453125e-26"},
    {0x1.f45a241c9839ap-85, chars_format::scientific, 110,
        "5."
        "0522652313759764410835719385889967890520096634286257939712790137828674758013747236873314250260591506958007"
        "8125e-26"},
    {0x1.0e0770a686d83p-84, chars_format::scientific, 110,
        "5."
        "4531934926351591660177398201938298068678042808590523162341841824872750582597902280213020276278257369995117"
        "1875e-26"},
    {0x1.0248f281384bap-83, chars_format::scientific, 109,
        "1."
        "0432046065743156487678104545227567829109732926698293352119589937000883328455103082887944765388965606689453"
        "125e-25"},
    {0x1.ac4e19937ae27p-82, chars_format::scientific, 109,
        "3."
        "4598208650514789897486706324846604978683020740045778389727925607329515889087900859522051177918910980224609"
        "375e-25"},
    {0x1.3087a7746f421p-81, chars_format::scientific, 108,
        "4."
        "9199458656109230376671766694383649258995953059687000036237194733378455535621753824671031907200813293457031"
        "25e-25"},
    {0x1.70783708f772ap-80, chars_format::scientific, 107,
        "1."
        "1905894569192662776098050199813402280754741687796493203055674863031360155574134296330157667398452758789062"
        "5e-24"},
    {0x1.e065c19de1dc4p-79, chars_format::scientific, 105,
        "3."
        "104495987602903687782546492307846204182230640542680505726853422594768705522483287495560944080352783203125e"
        "-24"},
    {0x1.c685d70ae0fe0p-78, chars_format::scientific, 101,
        "5.874569663977717964226825494393114