#!/usr/bin/env python3
"""
Compiler ID  handling for dhfortran: tests

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 GNU Public License.

"""

import dhfortran.compilers as cp


def test_get_flavor():
    gf = cp.default_compilers["gfortran"]
    assert cp.get_fc_flavor("/usr/bin/gfortran") == gf
    assert cp.get_fc_flavor("/usr/bin/gfortran-15") == gf
    assert cp.get_fc_flavor(f"/usr/bin/{cp._multiarch}-gfortran-15") == gf
    assert cp.get_fc_flavor("/etc/alternatives/f95") == gf

    try:
        x = cp.get_fc_flavor("/bin/garbage")
    except Exception as ex:
        pass
    else:
        assert 1
        1, "get_fc_flavor('/bin/garbage') should fail"


def test_get_fc_default():
    gf = cp.default_compilers["gfortran"]
    assert cp.get_fc_default() == gf


def test_get_fort_root():
    assert cp.get_fort_root() == f"/usr/lib/{cp._multiarch}/fortran"


def test_get_optional():
    assert cp.get_fc_optional() is not None


if __name__ == "__main__":
    import pytest

    pytest.main()
