#pragma once
//##########################################################################
//#                                                                        #
//#                              CLOUDCOMPARE                              #
//#                                                                        #
//#  This program is free software; you can redistribute it and/or modify  #
//#  it under the terms of the GNU General Public License as published by  #
//#  the Free Software Foundation; version 2 or later of the License.      #
//#                                                                        #
//#  This program is distributed in the hope that it will be useful,       #
//#  but WITHOUT ANY WARRANTY; without even the implied warranty of        #
//#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          #
//#  GNU General Public License for more details.                          #
//#                                                                        #
//#          COPYRIGHT: EDF R&D / TELECOM ParisTech (ENST-TSI)             #
//#                                                                        #
//##########################################################################

#include "CCAppCommon.h"

//qCC_gl
#include <ccGLWindowInterface.h>

//Qt
#include <QDialog>

namespace Ui
{
	class StereoModeDialog;
}

//! Dialog to define the parameters of the stereo mode (for 3D views)
class CCAPPCOMMON_LIB_API ccStereoModeDlg : public QDialog
{
	Q_OBJECT

public:

	//! Default constructor
	explicit ccStereoModeDlg(QWidget* parent);
	~ccStereoModeDlg() override;

	//! Returns the current parameters
	ccGLWindowInterface::StereoParams getParameters() const;

	//! Sets the current parameters
	void setParameters(const ccGLWindowInterface::StereoParams& params);

	//! Returns whether the FOV should be updated or not
	bool updateFOV() const;

protected:

	//! Slot called when the glass type is modified
	void glassTypeChanged(int);
	
private:
	Ui::StereoModeDialog* m_ui;
};
