include(CheckFunctionExists)
include(CheckLibraryExists)
include(CheckCCompilerFlag)
include(CheckIncludeFiles)

set(CMAKE_THREAD_PREFER_PTHREAD TRUE)
find_package(Threads)

set(CMAKE_REQUIRED_FLAGS "-Werror -fsanitize=undefined")
check_c_compiler_flag("-faddress-sanitizer" HAVE_FLAG_SANITIZE_UNDEFINED)
set(CMAKE_REQUIRED_FLAGS "-Werror -fsanitize=address")
check_c_compiler_flag("-fsanitize=address" HAVE_FLAG_SANITIZE_ADDRESS)
unset(CMAKE_REQUIRED_FLAGS)

if (SANITIZER)
	if (HAVE_FLAG_SANITIZE_UNDEFINED)
		set(SANITIZE_FLAGS "${SANITIZE_FLAGS} -fsanitize=undefined")
	endif()
	if (HAVE_FLAG_SANITIZE_ADDRESS)
		set(SANITIZE_FLAGS "${SANITIZE_FLAGS} -fsanitize=address")
	endif()
endif()

set(CMAKE_EXE_LINKER_FLAGS_DEBUG "${CMAKE_EXE_LINKER_FLAGS_DEBUG} ${SANITIZE_FLAGS}")

if (CMAKE_COMPILER_IS_GNUCXX)
	check_function_exists(__atomic_fetch_add_4 HAVE___ATOMIC_FETCH_ADD_4)
	if (NOT HAVE___ATOMIC_FETCH_ADD_4)
		check_library_exists(atomic __atomic_fetch_add_4 "" HAVE_LIBATOMIC)
		if (HAVE_LIBATOMIC)
			set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -latomic")
		endif()
	endif()
endif()

set(CMAKE_C_STANDARD_LIBRARIES "${CMAKE_C_STANDARD_LIBRARIES} ${CMAKE_DL_LIBS}")

check_include_files(execinfo.h HAVE_EXECINFO_H)
if (HAVE_EXECINFO_H)
	set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -lexecinfo")
	set(CMAKE_C_STANDARD_LIBRARIES "${CMAKE_C_STANDARD_LIBRARIES} -lexecinfo")
	set(CMAKE_CXX_STANDARD_LIBRARIES "${CMAKE_CXX_STANDARD_LIBRARIES} -lexecinfo")
endif()

set(CURSES_NEED_NCURSES TRUE)
find_package(Curses)
if (NOT CURSES_FOUND)
	set(CURSES_LIBRARIES "")
endif()
set(HAVE_NCURSES_H ${CURSES_HAVE_NCURSES_H})
check_library_exists(root clock_gettime "posix/time.h" HAVE_CLOCKGETTIME)

set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -g -Wcast-qual -Wcast-align -Wpointer-arith -Wno-long-long -Wno-multichar -Wshadow -Wall -Wextra -Wno-sign-compare -Wno-unused-parameter -Wreturn-type -Wwrite-strings -Wno-variadic-macros -Wno-unknown-pragmas")
if (CMAKE_USE_PTHREADS_INIT)
	set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -lpthread")
endif()
set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -D_GNU_SOURCE -D_DEFAULT_SOURCE -D_XOPEN_SOURCE -D_FORTIFY_SOURCE=2 -DNDEBUG -fexpensive-optimizations -fomit-frame-pointer -O3")
set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -DDEBUG -fno-omit-frame-pointer ${SANITIZE_FLAGS}")

set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CMAKE_C_FLAGS} -Wnon-virtual-dtor")
set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} ${CMAKE_C_FLAGS_RELEASE}")
set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} ${CMAKE_C_FLAGS_DEBUG}")
