/* 
 
Copyright 2006 Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package eric;

import java.lang.reflect.Method;

public class JBrowserLauncher {

	final static String[] hex = { "%00", "%01", "%02", "%03", "%04", "%05",
		"%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e",
		"%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17",
		"%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20",
		"%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29",
		"%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32",
		"%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b",
		"%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44",
		"%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d",
		"%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56",
		"%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f",
		"%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68",
		"%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71",
		"%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a",
		"%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83",
		"%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c",
		"%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95",
		"%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e",
		"%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7",
		"%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0",
		"%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9",
		"%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2",
		"%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb",
		"%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4",
		"%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd",
		"%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6",
		"%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef",
		"%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8",
		"%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff" };

	public static String encode(final String s) {
		final StringBuffer sbuf = new StringBuffer();
		final int len = s.length();
		for (int i = 0; i < len; i++) {
			final int ch = s.charAt(i);
			if ('A' <= ch && ch <= 'Z') { // 'A'..'Z'
				sbuf.append((char) ch);
			} else if ('a' <= ch && ch <= 'z') { // 'a'..'z'
				sbuf.append((char) ch);
			} else if ('0' <= ch && ch <= '9') { // '0'..'9'
				sbuf.append((char) ch);
			} else if (ch == '-'
				|| ch == '_' // unreserved
					|| ch == '.' || ch == '!' || ch == '~' || ch == '*'
						|| ch == '\'' || ch == '(' || ch == ')' || ch == '/'
							|| ch == ':' || ch == '\\') {
				sbuf.append((char) ch);
			} else if (ch <= 0x007f) { // other ASCII
				sbuf.append(hex[ch]);
			} else if (ch <= 0x07FF) { // non-ASCII <= 0x7FF
				sbuf.append(hex[0xc0 | (ch >> 6)]);
				sbuf.append(hex[0x80 | (ch & 0x3F)]);
			} else { // 0x7FF < ch <= 0xFFFF
				sbuf.append(hex[0xe0 | (ch >> 12)]);
				sbuf.append(hex[0x80 | ((ch >> 6) & 0x3F)]);
				sbuf.append(hex[0x80 | (ch & 0x3F)]);
			}
		}
		return sbuf.toString();
	}

	public static void openURL(String url) {
		try {
			if (OS.isMac()) {
				final Class fileMgr = Class
				.forName("com.apple.eio.FileManager");
				final Method openURL = fileMgr.getDeclaredMethod("openURL",
						new Class[] { String.class });
				if (!(url.startsWith("http://")))
					url = "file://" + encode(url);
				openURL.invoke(null, new Object[] { url });
			} else if (OS.isWindows())
				Runtime.getRuntime().exec(
						"rundll32 url.dll,FileProtocolHandler " + url);
			else { // assume Unix or Linux
				final String[] browsers = { "firefox", "opera", "konqueror",
						"epiphany", "mozilla", "netscape" };
				String browser = null;
				for (int count = 0; count < browsers.length && browser == null; count++)
					if (Runtime.getRuntime().exec(
							new String[] { "which", browsers[count] })
							.waitFor() == 0)
						browser = browsers[count];
				if (browser == null)
					throw new Exception("Could not find web browser");
				else
					Runtime.getRuntime().exec(new String[] { browser, url });
			}
		} catch (final Exception e) {
		}
	}

}