#!/bin/sh
set -o nounset

oneTimeSetUp() {
	# Load the ./play.it library
	. lib/libplayit2.sh
}

test_wine_launcher() {
	local \
		PLAYIT_CONTEXT_PACKAGE='PKG_MAIN' \
		PKG_MAIN_ARCH='32'

	local APP_MAIN_PREFIX_TYPE='symlinks'
	assertTrue \
		'Failed to generate a launcher for a WINE game using a symlinks prefix.' \
		'wine_launcher APP_MAIN'

	local UNREALENGINE4_NAME='VotV'
	## Override the function returning a default list of winetricks verbs,
	## so only the non-default Direct3D rendering would require the winetricks wrapper.
	unrealengine4_wine_winetricks_verbs_default() { return 0; }
	assertTrue \
		'Failed to include the required winetricks wrapper in the generated launcher for an Unreal Engine 4 game.' \
		'wine_launcher APP_MAIN | grep --silent "winetricks_wrapper()"'
}
