#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2016 Mopi
set -o errexit

###
# Anachronox
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251113.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='anachronox'
GAME_NAME='Anachronox'

ARCHIVE_BASE_1_NAME='setup_anachronox_1.02_(22258).exe'
ARCHIVE_BASE_1_MD5='4e23d4f7637f6914a7cd6c13feb7ad7d'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1074901'
ARCHIVE_BASE_1_VERSION='1.02-gog22258'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/anachronox'

ARCHIVE_BASE_0_NAME='setup_anachronox_2.0.0.28.exe'
ARCHIVE_BASE_0_MD5='a9e148972e51a4980a2531d12a85dfc0'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_VERSION='1.02-gog2.0.0.28'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
## anox.exe requirements
CONTENT_LIBS_BIN_FILES='
anoxaux.dll
anoxgfx.dll
gamex86.dll
PATCH.dll
ref_gl.dll
zlib.dll'
## anoxgfx.dll requirements
CONTENT_LIBS0_BIN_FILES='
libpng13a.dll'
## The game crashes when trying to play the logo video without this library.
CONTENT_LIBS1_BIN_FILES='
anoxdata/plugins/anoxsnd.dll'
## anoxdata/plugins/anoxsnd.dll requirements
CONTENT_LIBS2_BIN_FILES='
mss32.dll'
## The game fails to render the menu without this library.
CONTENT_LIBS3_BIN_FILES='
anoxdata/plugins/ui.dll'
## anoxdata/plugins/ui.dll requirements
CONTENT_LIBS4_BIN_FILES='
anoxdata/plugins/NOXGAME.dll
anoxdata/plugins/PLANET.dll'
## The player model is not displayed and sound effects are not played without this library.
CONTENT_LIBS5_BIN_FILES='
anoxdata/plugins/camera.dll'
## Items can not be picked up without this library.
CONTENT_LIBS6_BIN_FILES='
anoxdata/plugins/intellinox.dll'
CONTENT_GAME_BIN_FILES='
anoxdata/miles/mp3dec.asi
anoxdata/miles/*.m3d
anoxdata/plugins/dllorder.txt
anox.exe'
CONTENT_GAME_DATA_FILES='
anoxdata/configs
anoxdata/gameflow
anoxdata/graphics
anoxdata/models
anoxdata/music
anoxdata/save
anoxdata/sound
anoxdata/version.anox
anoxdata/anox1.zip
anoxdata/*.dat
anox.ico
anachronox_word.jpg'
CONTENT_DOC_DATA_FILES='
manual.pdf
readme.htm
anachronox patch 1_02.rtf
*readme.txt'

USER_PERSISTENT_DIRECTORIES='
anoxdata/save'
USER_PERSISTENT_FILES='
anoxdata/nokill.*'

APP_MAIN_EXE='anox.exe'
APP_MAIN_ICON='anox.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	PATH_LIBRARIES_SYSTEM='$(path_libraries)'
	EOF
	cat <<- 'EOF'
	find "$PATH_LIBRARIES_SYSTEM" -iname '*.dll' | while read -r dll_source; do
		dll_destination="${PATH_PREFIX}${dll_source#"${PATH_LIBRARIES_SYSTEM}"}"
	    mkdir --parents "$(dirname "$dll_destination")"
	    ln --symbolic "$dll_source" "$dll_destination"
	done
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
